/***************************************************************************
                          smb4kshare  -  description
                             -------------------
    begin                : Do Mr 4 2004
    copyright            : (C) 2004 by Franck Babin
    email                : babinfranck@yahoo.ca
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

 
// application specific includes
#include "smb4kshare.h"

 
Smb4KShare::Smb4KShare( const QString &name, const QString &path, const int uid, const int gid ) : m_name(name), m_path(path), m_userinfo( uid, gid )
{
  //FIXME should throw an exception if one of the param is empty
}


Smb4KShare::Smb4KShare( const Smb4KShare &s ) : m_name( s.getName() ), m_path( s.getPath() ), m_userinfo( s.getUID(), s.getGID() ) 
{
}


Smb4KShare::~Smb4KShare(){}


QString Smb4KShare::getName() const
{
  QString n( m_name );

  return n.contains( " " ) != 0 ? n.replace( " ", "_" ) : n;
}


QString Smb4KShare::getRealName() const
{
  return m_name;
}


QString Smb4KShare::getPath() const
{
  return m_path;
}


int Smb4KShare::getUID() const
{
  return m_userinfo.uid();
}


int Smb4KShare::getGID() const
{
  return m_userinfo.gid();
}


QString Smb4KShare::getUser() const
{
  return m_userinfo.user();
}


QString Smb4KShare::getGroup() const
{
  return m_userinfo.group();
}


void Smb4KShare::clear()
{
  m_name = QString::null;
  m_path = QString::null;
}


bool Smb4KShare::isEmpty()
{
  if ( m_name == QString::null &&
       m_path == QString::null )
  {
    return true;
  }
  else
    return false;
}

