/***************************************************************************
    smb4kstarter.h  -  Stuff that's carried out on start-up.
                             -------------------
    begin                : Mit Apr 30 2003
    copyright            : (C) 2003 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/*************************************************************************** 
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SMB4KSTARTER_H
#define SMB4KSTARTER_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// Qt includes
#include <qobject.h>

// KDE includes
#include <kprocess.h>
#include <kconfig.h>

/**
 * This is a core class. It is invoked before Smb4KApp is initialized and
 * takes care of all the things, that have to be done before the main window
 * is shown.
 */

class Smb4KStarter : public QObject
{
  Q_OBJECT
  
  public:
    /**
     * The constructor.
     */
    Smb4KStarter( QObject *parent = 0, const char *name = 0 );
    /**
     * The destructor.
     */
    ~Smb4KStarter();

    /**
     * Does everything, that has to be done on start-up.
     */
    void init();

  protected slots:
    /**
     * Ends the process.
     */
    void slotProcessExited( KProcess * );
    /**
     * Receives the shell output.
     */
    void slotReceivedStdout( KProcess *, char *buf, int len );


  private:
    /**
     * Starts the main application (Smb4KApp).
     */
    void runProgram();
    /**
     * Determines the operting system.
     */
    void detectOS();
    /**
     * Determines the WINS server support.
     */
    void checkForWINS();
    /**
     * Determines the UID and GID of the user and writes them into the
     * config file.
     */
    void getID();
    /**
     * This function detects all mandatory programs that are
     * needed by Smb4K and finds out Samba's version.
     */
    void getProgramInfos();
    /**
     * Get the UMASK and save it to the config file.
     */
    void getUMASK();
    /**
     * The KProcess object.
     */
    KProcess *m_proc;
    /**
     * The KConfig object.
     */
    KConfig *m_config;
    /**
     * Holds the users UID.
     */
    int m_uid;
    /**
     * Holds the users GID.
     */
    int m_gid;
    /**
     * The buffer object.
     */
    QString m_buffer;
    /**
     * This function modifies the config file, if it 
     * changed in some way.
     */
    void modifyConfig();
    /**
     * This function is invoked to display an error message.
     */
    void error( int error_code, const QString &error_message );
};

#endif
