/***************************************************************************
    smb4kuser.cpp  -  This class provides a container for the user 
    information that is read from /etc/passwd.
                             -------------------
    begin                : Mo Mr 1 2004
    copyright            : (C) 2004 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// system includes
#include <sys/types.h>
#include <pwd.h>
#include <grp.h> 
 
// application specific includes
#include "smb4kuser.h"


Smb4KUser::Smb4KUser( const int uid, const int gid ) : m_uid( uid ), m_gid( gid )
{
  if ( uid >= 0 && gid >= 0 )
    fillNames( uid, gid );
  else
    qFatal( "Smb4KUser: UID and/or GID smaller than 0!" );    
}


Smb4KUser::~Smb4KUser()
{
}


/****************************************************************************
   Fills the user name and group name objects.
****************************************************************************/

void Smb4KUser::fillNames( int uid, int gid )
{
  struct passwd *p = getpwuid( uid );
  m_user = QString( p->pw_name );
  
  struct group *g = getgrgid( gid );
  m_group = QString( g->gr_name );
}

