/***************************************************************************
    smb4kpreviewdialog.cpp  -  description
                             -------------------
    begin                : Fre Jul 4 2003
    copyright            : (C) 2003 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// Qt includes
#include <qlayout.h>
#include <qtooltip.h>
#include <qiconset.h>
#include <qregexp.h>
 
// KDE includes
#include <klocale.h>
#include <kapplication.h>
#include <kiconloader.h>

// application specific includes
#include "smb4kpreviewdialog.h"
#include "../smb4k.h"


Smb4KPreviewDialog::Smb4KPreviewDialog( const QString &workgroup, const QString &host, const QString &ip,
const QString &share, QWidget *parent, const char *name, bool modal )
: KDialogBase( Plain, i18n( "Preview" ), Close, Close, parent, name, modal, true )
{
  m_config = kapp->config();

  m_workgroup = workgroup;
  m_host = host;
  m_share = share;
  m_ip = ip;

  m_address = QString( "//%1/%2/" ).arg( m_host ).arg( m_share );

  setupView();

  readOptions();

  setMinimumSize( sizeHint() );
  setWFlags( Qt::WDestructiveClose );

  connect( this, SIGNAL( finished() ), SLOT( slotFinished() ) );
  connect( m_view, SIGNAL( executed( QIconViewItem * ) ), SLOT( slotItemExecuted( QIconViewItem * ) ) );
  connect( m_toolbar, SIGNAL( clicked( int ) ), SLOT( slotButtonClicked( int ) ) );
  connect( m_combo, SIGNAL( activated( const QString & ) ), SLOT( slotItemActivated( const QString & ) ) );
  
  connect( sapp->core()->scanner(), SIGNAL( previewResult( const QValueList<Smb4KPreviewItem *> & ) ), this, SLOT( slotReceivedData( const QValueList<Smb4KPreviewItem *> & ) ) );
  
  sapp->core()->scanner()->getPreview( workgroup, host, ip, share, QString::null );
}


Smb4KPreviewDialog::~Smb4KPreviewDialog()
{
}


void Smb4KPreviewDialog::setupView()
{
  QFrame *frame = plainPage();
  QGridLayout *layout = new QGridLayout( frame );

  m_view = new KIconView( frame, 0, 0 );
  m_view->setItemTextPos( KIconView::Right );
  m_view->setResizeMode( KIconView::Adjust );
  m_view->setArrangement( KIconView::TopToBottom );
  m_view->setSpacing( 1 );
  m_view->setGridX( 200 );
  m_view->setWordWrapIconText( false );
  m_view->setShowToolTips( true );
  m_view->setAutoArrange( true );
  m_view->setSorting( true, true );

  m_toolbar = new KToolBar( frame, 0, true, false );
  m_toolbar->insertButton( BarIcon( "up" ), Up, true, i18n( "Up" ), 0 );
  m_combo = new KComboBox( false, m_toolbar, 0 );
  m_combo->setDuplicatesEnabled( false );
  m_toolbar->insertWidget( Combo, 10, m_combo, 2 );
  m_toolbar->setItemAutoSized( Combo, true );

  layout->addWidget( m_view, 0, 0, 0 );
  layout->addWidget( m_toolbar, 1, 0, 0 );
  setTooltips();
}


void Smb4KPreviewDialog::saveOptions()
{
  m_config->setGroup( "General Options" );
  m_config->writeEntry( "Preview Dialog Geometry", size() );
}


void Smb4KPreviewDialog::readOptions()
{
  m_config->setGroup( "General Options" );
  setInitialSize( m_config->readSizeEntry( "Preview Dialog Geometry", 0L ) );
}


void Smb4KPreviewDialog::setTooltips()
{
  QToolTip::add( m_view, i18n( "Contents" ) );
}


/////////////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATIONS
/////////////////////////////////////////////////////////////////////////////


void Smb4KPreviewDialog::slotFinished()
{
  saveOptions();
}


void Smb4KPreviewDialog::slotReceivedData( const QValueList<Smb4KPreviewItem *> &list )
{
  if ( !list.isEmpty() )
  {
    m_view->clear();

    QString item = QString( "%1%2" ).arg( m_address ).arg( m_path );

    if ( m_combo->count() == 0 )
    {
      m_combo->insertItem( item, -1 );
      m_combo->setCurrentItem( 0 );
    }
    else if ( !m_combo->contains( item ) )
    {
      m_combo->insertItem( item, 0 );
      m_combo->setCurrentItem( 0 );
    }
    else
    {
      int index = 0;
      int pos = 0;
      bool exists = false;
      while ( index < m_combo->count() )
      {
        if ( m_combo->text( index ).stripWhiteSpace() == item.stripWhiteSpace() )
        {
          pos = index;
          exists = true;
          break;
        }
        else if ( m_combo->text( index ).stripWhiteSpace() == m_address )
        {
          pos = index;
          exists = true;
          break;
        }
        index++;
      }
      if ( !exists )
      {
        m_combo->insertItem( item, 0 );
        m_combo->setCurrentItem( 0 );
      }
      else
        m_combo->setCurrentItem( pos );
    }
  
    for ( QValueList<Smb4KPreviewItem *>::ConstIterator it = list.begin(); it != list.end(); ++it )
    {
      if ( (*it)->isFile() )
      {
        QIconViewItem *view_item = new QIconViewItem( m_view, (*it)->name(), SmallIcon( "unknown" ) );
        view_item->setKey( QString( "1%1" ).arg( (*it)->name() ) );
      }
      else
      {
        if ( (*it)->name() != "." && (*it)->name() != ".." )
        {
          QIconViewItem *view_item = new QIconViewItem( m_view, (*it)->name(), SmallIcon( "folder_green" ) );
          view_item->setKey( QString( "0%1" ).arg( (*it)->name() ) );
        }
      }
    }
  }
  else
  {
    if ( m_path.contains( "/" ) == 1 )
      m_path = QString::null;
    else
      m_path = m_path.section( "/", 0, -2 ).stripWhiteSpace();
  }
}


void Smb4KPreviewDialog::slotItemExecuted( QIconViewItem *item )
{
  if ( !item->key().startsWith( "1" ) )
  {
    QString tmp = item->text();
    m_path.append( tmp ).append( "/" );
    
    sapp->core()->scanner()->getPreview( m_workgroup, m_host, m_ip, m_share, m_path );
  }
}


void Smb4KPreviewDialog::slotButtonClicked( int id )
{
  if ( id == Up && !m_path.isEmpty() )
  {
    if ( m_path.contains( "/" ) > 1 )
      m_path = m_path.section( "/", 0, -3 ).append( "/" );
    else if ( m_path.contains( "/", true ) == 1 )
      m_path = QString::null;

    sapp->core()->scanner()->getPreview( m_workgroup, m_host, m_ip, m_share, m_path );
  }
}


void Smb4KPreviewDialog::slotItemActivated( const QString &item )
{
  // First we have to strip the address:
  QString path = item.section( m_address, 1, 1 ).stripWhiteSpace(); 
  
  sapp->core()->scanner()->getPreview( m_workgroup, m_host, m_ip, m_share, path );
  
  m_path = path;
}


#include "smb4kpreviewdialog.moc"

