/***************************************************************************
    smb4kdefs.h  -  Definitions for Smb4K
                             -------------------
    begin                : Mo Mr 15 2004
    copyright            : (C) 2004 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef SMB4KDEFS_H
#define SMB4KDEFS_H


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// Run modes
#define SCANNER_INIT                          0
#define SCANNER_OPENING_WORKGROUP             1
#define SCANNER_OPENING_HOST                  2
#define SCANNER_RETRIEVING_INFO               3
#define SCANNER_RETRIEVING_PREVIEW            4
#define SCANNER_SEARCHING                     5
#define SCANNER_STOP                          6
#define IPFINDER_WORKING                      7
#define IPFINDER_STOP                         8
#define MOUNTER_MOUNTING                      9
#define MOUNTER_UNMOUNTING                   10
#define MOUNTER_UNMOUNTING_ALL               11
#define MOUNTER_STOP                         12
#define PRINT_SEND_FILE                      13
#define PRINT_CONVERT_FILE                   14
#define PRINT_STOP                           15
#define CORE_STOP                            16

// Error codes
#define ERROR_GETTING_BROWSELIST            100
#define ERROR_GETTING_MEMBERS               101
#define ERROR_GETTING_SHARES                102
#define ERROR_GETTING_PREVIEW               103
#define ERROR_OPENING_WALLET                104
#define ERROR_ALREADY_MOUNTED               105
#define ERROR_UNMOUNTING_NOT_ALLOWED        106
#define ERROR_MOUNTING_SHARE                107
#define ERROR_UNMOUNTING_SHARE              108
#define ERROR_UNMOUNTING_ALL                109
#define ERROR_FILE_NOT_FOUND                110
#define ERROR_READING_FILE                  111
#define ERROR_UNKNOWN                       112
#define ERROR_GETTING_HOSTNAME              113
#define ERROR_MISSING_PROGRAMS              114
#define ERROR_MIMETYPE_NOT_SUPPORTED        115
#define ERROR_LOCKED                        116
#define ERROR_SUID_PROGRAM_MISSING          117
#define ERROR_MKDIR_FAILED                  118
#define ERROR_WRITING_FILE                  119
#define ERROR_GETTING_USAGE                 120
#define ERROR_MOUNTPOINT_EMPTY              121
#define ERROR_WRONG_KERNEL                  122
#define ERROR_FEATURE_NOT_ENABLED           123
#define ERROR_FORCE_UNMOUNT_SUID_MISSING    124
#define ERROR_WRONG_BOOKMARK_TYPE           125
#define ERROR_IP_CANNOT_BE_USED             126
#define ERROR_IMPORTING_SHARES              127
#define ERROR_COMMAND_NOT_FOUND             128
#define ERROR_PRINTING                      129
#define ERROR_CREATING_TEMP_DIR             130
#define ERROR_CREATING_TEMP_FILE            131
#define ERROR_DIRECTORY_NOT_FOUND           132
#define ERROR_LOCK_FILE_IS_SYMLINK          133
#define ERROR_SHARE_WENT_OFFLINE            134
#define ERROR_GETTING_PERMISSIONS           135

#endif
