/***************************************************************************
    smb4kauthoptions  -  description
                             -------------------
    begin                : Sa Nov 15 2003
    copyright            : (C) 2003 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// Qt includes
#include <qlayout.h>
#include <qvgroupbox.h>
#include <qbuttongroup.h>

// KDE includes
#include <kmessagebox.h>
#include <kiconloader.h>
#include <klocale.h>

// application specific includes
#include "smb4kauthoptions.h"

Smb4KAuthOptions::Smb4KAuthOptions( QWidget *parent, const char *name ) : QWidget( parent, name )
{
  //
  // Default Authentication
  //
  QGridLayout *grid = new QGridLayout( this );
  grid->setSpacing( 10 );

  QButtonGroup *password_group = new QButtonGroup( 1, QButtonGroup::Horizontal, i18n( "Password Storage" ), this );
  m_use_wallet = new QCheckBox( i18n( "Save login information in a wallet" ), password_group );
  m_remember_passwords = new QCheckBox( i18n( "If no wallet is used, remember passwords during run time" ), password_group );
  
  grid->addWidget( password_group, 0, 0, 0 );
  
  m_login_box = new QVGroupBox( i18n( "Default Login" ), this, "DefaultLoginBox" );
  m_login_box->setInsideMargin( 10 );

  QLabel *description1 = new QLabel( i18n( "This login will be used, if none has been defined for a share." ), m_login_box );
  description1->setTextFormat( Qt::RichText );

  m_defaultAuth = new QCheckBox( i18n( "Use default login" ), m_login_box );

  m_authWidget = new QWidget( m_login_box );
  QGridLayout *auth_grid = new QGridLayout( m_authWidget );
  auth_grid->setSpacing( 10 );
  
  QSpacerItem *spacer1 = new QSpacerItem( 25, 0, QSizePolicy::Fixed, QSizePolicy::Fixed );
  QLabel *login = new QLabel( i18n( "User:" ), m_authWidget );
  m_defaultLogin = new KLineEdit( QString::null, m_authWidget );
  m_defaultLogin->setMinimumWidth( 150 );
  QLabel *passwd = new QLabel( i18n( "Password:" ), m_authWidget );
  m_defaultPasswd = new KLineEdit( QString::null, m_authWidget );
  m_defaultPasswd->setMinimumWidth( 150 );
  m_defaultPasswd->setEchoMode( KLineEdit::Password );
  
  auth_grid->addMultiCell( spacer1, 0, 1, 0, 0, 0 );
  auth_grid->addWidget( login, 0, 1 );
  auth_grid->addWidget( m_defaultLogin, 0, 2 );
  auth_grid->addWidget( passwd, 1, 1 );
  auth_grid->addWidget( m_defaultPasswd, 1, 2 );

  QSpacerItem *spacer2 = new QSpacerItem( 0, 0, QSizePolicy::Preferred, QSizePolicy::Expanding );
  
  grid->addWidget( m_login_box, 1, 0, 0 );
  
  grid->addItem( spacer2, 2, 0 );
}


Smb4KAuthOptions::~Smb4KAuthOptions()
{
}


#include "smb4kauthoptions.moc"
