/***************************************************************************
    smb4kdataitem  -  A data container for use in the core classes.
                             -------------------
    begin                : Sa Jul 30 2005
    copyright            : (C) 2005 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/

#include "smb4kdataitem.h"


Smb4KDataItem::Smb4KDataItem( const QString &workgroup, const QString &host, const QString &share, const QString &ip, const QString &path )
: m_workgroup( workgroup ), m_host( host ), m_share( share ), m_ip( ip ), m_path( path )
{
}


Smb4KDataItem::Smb4KDataItem()
{
}


Smb4KDataItem::~Smb4KDataItem()
{
}


void Smb4KDataItem::setWorkgroup( const QString &workgroup )
{
  m_workgroup = workgroup;
}


void Smb4KDataItem::setHost( const QString &host )
{
  m_host = host;
}


void Smb4KDataItem::setShare( const QString &share )
{
  m_share = share;
}


void Smb4KDataItem::setIP( const QString &ip )
{
  m_ip = ip;
}


void Smb4KDataItem::setPath( const QString &path )
{
  m_path = path;
}


void Smb4KDataItem::setFilesystem( const QString &filesystem )
{
  m_filesystem = filesystem;
}


void Smb4KDataItem::setCIFSLogin( const QString &login )
{
  m_cifs_login = login;
}
