/***************************************************************************
                          smb4kbrowserwidgetitem  -  description
                             -------------------
    begin                : So Jan 30 2005
    copyright            : (C) 2005 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/

#ifndef SMB4KBROWSERWIDGETITEM_H
#define SMB4KBROWSERWIDGETITEM_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// Qt includes
#include <qpixmap.h>

// KDE includes
#include <klistview.h>

// application specific includes
#include "../core/smb4knetworkitems.h"


/**
 * This class cares about the items that are inserted into the browser widget.
 */

class Smb4KBrowserWidget;
class Smb4KBrowserWidgetItem : public QListViewItem
{
  public:
    /**
     * The constructor for toplevel (workgroup) items.
     *
     * @param parent        The parent list view.
     *
     * @param item          The Smb4KWorkgroupItem that carries all the data
     *                      needed to set up a "workgroup item".
     */
    Smb4KBrowserWidgetItem( QListView *parent, Smb4KWorkgroupItem *item );

    /**
     * The constructor for the host items.
     *
     * @param parent        The parent list view item.
     *
     * @param item          The Smb4KHostItem that carries all the data.
     */
    Smb4KBrowserWidgetItem( QListViewItem *parent, Smb4KHostItem *item );

    /**
     * The constructor for the share items.
     *
     * @param parent        The parent list view item.
     *
     * @param item          The Smb4KShareItem that carries all the data.
     */
    Smb4KBrowserWidgetItem( QListViewItem *parent, Smb4KShareItem *item );

    /**
     * The destructor.
     */
    virtual ~Smb4KBrowserWidgetItem();

    /**
     * Returns a pointer to the Smb4KWorkgoupItem object.
     */
    Smb4KWorkgroupItem *workgroupItem() { return &m_workgroup; }

    /**
     * Returns a pointer to the Smb4KHostItem object.
     */
    Smb4KHostItem *hostItem() { return &m_host; }

    /**
     * Returns a pointer to the Smb4KShareItem.
     */
    Smb4KShareItem *shareItem() { return &m_share; }

    /**
     * Tells the Smb4KBrowserWidgetItem if the share is already mounted or not and sets the
     * folder icon accordingly (open folder == mounted, closed folder == not mounted).
     *
     * @param mounted     Has to be TRUE if the share is mounted and FALSE otherwise.
     *
     * This function will only work with shares. Workgroup and host items are ignored.
     */
    void setMounted( bool mounted );

    /**
     * Returns TRUE if the share is mounted and FALSE otherwise.
     */
    bool isMounted() { return m_mounted; }

    /**
     * This enumeration is to set the type of the browser widget item.
     */
    enum ItemType{ Workgroup, Host, Share };

    /**
     * This function returns the type of the network item this Smb4KBrowserWidgetItem
     * object represents.
     *
     * @returns             The type of the network item (see ItemType enumeration)
     */
    int itemType() const { return m_type; }

    /**
     * This function returns the icon of the browser widget item in desktop size.
     * It is mainly for use with the tool tips.
     *
     * @returns             The icon of the item in desktop size.
     */
    const QPixmap &desktopIcon() { return m_desktop_icon; }

    /**
     * Set the comment of an item. This funtion will have only effect on a
     * host item and a share item.
     *
     * @param comment       The comment for an item
     */
    void setComment( const QString &comment );

    /**
     * This function updates the internal workgroup item.
     *
     * @param item          A Smb4KWorkgroupItem
     */
    void update( Smb4KWorkgroupItem *item );

    /**
     * This function updates the internal host item and changes the
     * text that's being displayed in the browser. Use this, if you
     * have to alter the item in the browser.
     *
     * @param item          A Smb4KHostItem
     */
    void update( Smb4KHostItem *item );

    /**
     * This function updates the internal share item and changes the
     * text that's being displayed in the browser. Use this, if you
     * have to alter the item in the browser.
     *
     * @param item          A Smb4KShareItem
     */
    void update( Smb4KShareItem *item );

  protected:
    /**
     * Reimplemented from QListViewItem.
     */
    void paintCell( QPainter *p, const QColorGroup &cg, int column, int width, int align );

  private:
    /**
     * The Smb4KWorkgroupItem object.
     */
    Smb4KWorkgroupItem m_workgroup;

    /**
     * The Smb4KHostItem object.
     */
    Smb4KHostItem m_host;

    /**
     * The Smb4KShareItem object.
     */
    Smb4KShareItem m_share;

    /**
     * Is TRUE if the share is mounted and FALSE otherwise.
     * It will only be set, if Smb4KBrowserWidgetItem::depth() == 2,
     * i. e. it is a share.
     */
    bool m_mounted;

    /**
     * This variable takes one of the values of the Type enumeration.
     */
    int m_type;

    /**
     * This is the icon (desktop size) of this browser widget item
     */
    QPixmap m_desktop_icon;

    /**
     * This enumeration enumerates the columns of the item.
     */
    enum Columns{ Network = 0, Type = 1, IP = 2, Comment = 3 };
};

#endif
