/***************************************************************************
    smb4ksambaoptions.cpp  -  description
                             -------------------
    begin                : Mo Jan 26 2004
    copyright            : (C) 2004 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/

#ifndef SMB4KSAMBAOPTIONS_H
#define SMB4KSAMBAOPTIONS_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// Qt includes
#include <qtabwidget.h>
#include <qradiobutton.h>
#include <qcheckbox.h>

// KDE includes
#include <klineedit.h>
#include <knuminput.h>
#include <kcombobox.h>


/*
 * This class manages the configuration dialog of the options
 * that can be passed to smbmount and other programs of the
 * Samba software suite.
 */


class Smb4KSambaOptions : public QTabWidget
{
  Q_OBJECT

  friend class Smb4KOptionsDlg;

  public:
    /*
     * The constructor.
     */
    Smb4KSambaOptions( QWidget *parent = 0, const char *name = 0 );
    /*
     * The destructor.
     */
    ~Smb4KSambaOptions();

  protected slots:
    /**
     * Enables/disables widgets according to the choice of the filesystem (SMBFS/CIFS).
     *
     * This slot is connected to the combo box that stores the file systems.
     *
     * @param filesystem       the name of the filesystem that should be used
     */
    void slotSambaFileSystem( const QString &filesystem );

  private:
    /**
     * This line edit is for the NetBIOS name.
     */
    KLineEdit *m_netbios;
    /**
     * All UIDs that are present on the system and that
     * are no system UIDs are shown here.
     */
    KComboBox *m_uid;
    /**
     * All GIDs that are connected with the non-system
     * UIDs are shown here.
     */
    KComboBox *m_gid;
    /**
     * This input holds the SMB port that's used by smbmount
     * and friends.
     */
    KIntNumInput *m_port;
    /**
     * Holds the file mask for the remote files.
     */
    KLineEdit *m_fmask;
    /**
     * Holds the directory mask.
     */
    KLineEdit *m_dmask;
    /**
     * The combo box where the user can choose whether the
     * shares should be mounted read/write or read only.
     */
    KComboBox *m_read_mode;
    KComboBox *m_charset;
    KComboBox *m_codepage;
    KLineEdit *m_sockopt;
    KLineEdit *m_scope;
    KIntNumInput *m_ttl;
    /**
     * Determines whether Kerberos should be used.
     */
    QCheckBox *m_krb;
    QCheckBox *m_unicode;
    QCheckBox *m_lfs;
    KLineEdit *m_resolve;
    KIntNumInput *m_buffer;
    QCheckBox *m_udp;
    /**
     * Holds the domain string.
     */
    KLineEdit *m_domain;
    KLineEdit *m_broadcast;
    /**
     * The combo box where the user can choose the file system that
     * should be used for mounting.
     */
    KComboBox *m_filesystem;
    /**
     * This check box determines whether the user wants to use the
     * default network read size. (CIFS only).
     */
    QCheckBox *m_rsize;
    /**
     * This check box determines whether the user wants to use the
     * default network write size. (CIFS only).
     */
    QCheckBox *m_wsize;
    /**
     * This button deterimes that the protocol for the net command
     * should be auto-detected.
     */
    QRadioButton *m_net_auto;
    /**
     * net command should use ADS protocol.
     */
    QRadioButton *m_net_ads;
    /**
     * net command should use RPC protocol.
     */
    QRadioButton *m_net_rpc;
    /**
     * net command should use RAP protocol.
     */
    QRadioButton *m_net_rap;
    /**
     * If this button is checked, the '-P' (authenticate as machine account)
     * option should be added to the net command.
     */
    QCheckBox *m_net_machine_account;
};

#endif
