/***************************************************************************
    smb4kpreviewitem  -   A container for previews of a remote share
                             -------------------
    begin                : Mo Mai 28 2007
    copyright            : (C) 2007 by Alexander Reinholdt
    email                : dustpuppy@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/

// KDE includes
#include <ksocketaddress.h>

// application specific includes
#include "smb4kpreviewitem.h"

Smb4KPreviewItem::Smb4KPreviewItem( Smb4KShareItem *item, const QString &ip, const QString &path )
: m_workgroup( item->workgroup() ), m_host( item->host() ), m_share( item->name() ), m_path( path )
{
  m_ip = ipIsValid( ip ) ? ip : QString::null;
  m_location = "//"+m_host+"/"+m_share+"/"+m_path;
}


Smb4KPreviewItem::~Smb4KPreviewItem()
{
}


void Smb4KPreviewItem::setShare( const QString &share )
{
  if ( QString::compare( m_share, "homes" ) == 0 )
  {
    m_share = share;
  }
}


void Smb4KPreviewItem::setIP( const QString &ip )
{
  m_ip = ipIsValid( ip ) ? ip : QString::null;
}


void Smb4KPreviewItem::setPath( const QString &path )
{
  m_path = path;
  m_location = "//"+m_host+"/"+m_share+"/"+m_path;

  clearContents();
}


void Smb4KPreviewItem::addContents( const ContentsItem &item )
{
  // Do not set the last argument to TRUE, because then
  // we would be in overwrite mode.
  m_contents.append( item );
}


void Smb4KPreviewItem::clearContents()
{
  m_contents.clear();
}


bool Smb4KPreviewItem::ipIsValid( const QString &ip )
{
  if ( !ip.isEmpty() )
  {
    KNetwork::KIpAddress ip_address = KNetwork::KIpAddress( ip );

    if ( !ip_address.isIPv4Addr() && !ip_address.isIPv6Addr() )
    {
      return false;
    }
  }
  else
  {
    return false;
  }

  return true;
}

