/*
       debug.c
       GNU Licence

       author: Rafal Michniewicz 
        email: <rafim@data.pl>
       jabber: rafim@jabber.org
    home page: http://www.air.rzeszow.pl/smbc
  
    last update: 2004-03-07
*/
#define _GNU_SOURCE

#include "headers.h"
#include "debug.h"
#include "../config.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>

char *RdbgFile = NULL;

void RinitDebug(char *Rstr)
{
  int Ri;

  Ri = strlen(Rstr)+1;
  RdbgFile = malloc(Ri);
  memcpy(RdbgFile, Rstr, Ri);
}

void RfreeDebug()
{
  free(RdbgFile);
  RdbgFile = NULL;
}

void RDBG(char *Rstr)
{
#ifdef HAVE_DEBUG
  int Rdesc;
  char *Rms = "!!! debug message >> Rstr == NULL << debug message !!!\n";

  Rdesc = open(RdbgFile, O_CREAT | O_NONBLOCK | O_RDWR | O_APPEND, 0600); 
  if (Rdesc > 0) {
    if (Rstr) 
      write(Rdesc, Rstr, strlen(Rstr));
    else
      write(Rdesc, Rms, strlen(Rms));
    close(Rdesc);
  }
#else
  return;
#endif /* HAVE_DEBUG */
}

int RDBGi(int Ri)
{
#ifdef HAVE_DEBUG
  char *Rstr;

  asprintf(&Rstr, "%i", Ri);
  RDBG(Rstr);
  free(Rstr);
  return(Ri);
#else
  return(Ri);
#endif /* HAVE_DEBUG */
}

void RDBGc(char Rc)
{
#ifdef HAVE_DEBUG
  char *Rstr;

  asprintf(&Rstr, "%c", Rc);
  RDBG(Rstr);
  free(Rstr);
#else
  return;
#endif /* HAVE_DEBUG */
}
