/*
       dulist.c
       GNU Licence

       author: Rafal Michniewicz 
        email: <rafim@data.pl>
       jabber: rafim@jabber.org
    home page: http://www.air.rzeszow.pl/smbc
  
    last update: 2004-05-03
*/

#define _GNU_SOURCE

#include "dulist.h"
#include "headers.h"
#include "debug.h"
#include "rtypedef.h"

#define _(String) gettext (String)
#define gettext_noop(String) String
#define N_(String) gettext_noop (String)

int RstrCmpIncludeFirst(const char *srcBig, const char *dstSmall)
{
  int RsrcL, RsrcD, Ri;
  RsrcL = strlen(srcBig);
  RsrcD = strlen(dstSmall);
  if (RsrcL < RsrcD) return 0;
  for (Ri =0; Ri<RsrcD; Ri++) { 
    if (srcBig[Ri] != dstSmall[Ri]) return 0;
  } 
  return 1;
}

void RlistAllDownloadLists()
{
  char *Rdir = NULL; 
  DIR *Rdhandle;
  struct dirent *Rsdirent;
  int Rcount = 0;

  asprintf(&Rdir, "%s/.smbc/", getenv("HOME"));
  Rdhandle = opendir(Rdir);
  if (Rdhandle != NULL) { 
    while ((Rsdirent = readdir(Rdhandle)) > 0) {
      if (strlen(Rsdirent->d_name) >= 6) 
        if (RstrCmpIncludeFirst(Rsdirent->d_name, "dulist")) {
          printf("%s : %s\n", Rsdirent->d_name+6, Rsdirent->d_name); 
          Rcount++;
        }       
    }
    closedir(Rdhandle);
  }
  free(Rdir);
  printf("Founded %i lists\n", Rcount);
}

void RflushAllDownloadLists()
{
  char *Rdir = NULL; 
  char *RdufileName = NULL; 
  DIR *Rdhandle;
  struct dirent *Rsdirent;
  char RfindF; 

  asprintf(&Rdir, "%s/.smbc/", getenv("HOME"));
  RfindF = 1;
  while (RfindF) {
    Rdhandle = opendir(Rdir);
    if (Rdhandle != NULL) { 
      RfindF = 0;
      while ((Rsdirent = readdir(Rdhandle)) > 0) {
        if (strlen(Rsdirent->d_name) >= 6) 
          if (RstrCmpIncludeFirst(Rsdirent->d_name, "dulist")) {
            asprintf(&RdufileName, "%s/.smbc/%s", getenv("HOME"),Rsdirent->d_name);
            printf(_("%s flushed\n"), Rsdirent->d_name); 
            unlink(RdufileName);
            free(RdufileName);
            RfindF = 1;
          }       
      }
    }
    else    
      RfindF = 0;
    closedir(Rdhandle);
  }
  free(Rdir);
  printf(_("Flush done.\n"));
}

void RdisplayVersion()
{
  printf("Simple Samba Commander %s\n", VERSION);

#ifdef HAVE_DEBUG
  printf("With debug mode.\n");
#endif /* HAVE_DEBUG */

#ifdef HAVE_SET_CONTEXT
  printf("With smbc_set_context.\n");
#endif /* HAVE_SET_CONTEXT */

#ifdef HAVE_SMBCCTX
  printf("With smbc_new_context.\n");
#endif /* HAVE_SMBCCTX */
}

void RShowAllItemsFromDUlist(int RnrDulist)
{
  char *RdufileName = NULL;
  int RdlsSize = sizeof(TTdownload);
  int Rfhandle;
  TTdownload *Rdls;

  asprintf(&RdufileName, "%s/.smbc/dulist%i", getenv("HOME"), RnrDulist);
  Rfhandle = open(RdufileName, O_NONBLOCK | O_RDONLY, 0755);
  if (Rfhandle > 0) {
    printf("---------------------------------------------------------\n");
    printf(" 1 | 2 | 3 | 4 | 5 | 6 | 7\n\n");
    printf(_("1 - local path\n"));
    printf(_("2 - workgroup\n"));
    printf(_("3 - size\n"));
    printf(_("4 - percent download/upload\n"));
    printf(_("5 - 'X' - active, 'W' - wait, ' ' don't download/upload\n"));
    printf(_("6 - 'D' - download, 'U' - upload\n"));
    printf(_("7 - remote path\n"));
    printf("---------------------------------------------------------\n");
    Rdls = malloc(RdlsSize); 
    while (read(Rfhandle, Rdls, RdlsSize) == RdlsSize) {
      printf("%s | %s | %s | %s | %c | %c | %s/%s\n", Rdls->pathL, Rdls->groupnameR, Rdls->sizeDisplayR, Rdls->percent, Rdls->active, Rdls->upload, Rdls->pathR, Rdls->filename);
    }
    close(Rfhandle);
    realloc(Rdls, RdlsSize);
  }
  free(RdufileName);
}

int RsaveMessage(char *Rstr, char *RfileName)
{
  char *Rfile;
  int Ri = 0;
  int Rf, Rfi;
  char Rfinding = 1;
  char Rc[1];

  if ((Rstr == NULL) || (RfileName == NULL))
    return(0);

  umask(0000);
  mkdir(RMESSAGEDIR, 0777);
  if ((Rfi = open(RfileName, O_RDONLY)) > 0) {
    while (Rfinding) {
      asprintf(&Rfile, "%s/%s%i", RMESSAGEDIR, RMESSAGEFILE, Ri);
      if ((Rf = open(Rfile, O_CREAT | O_EXCL | O_WRONLY, 0666)) > 0) {
        Rfinding = 0;
        write(Rf, Rstr, strlen(Rstr));
        write(Rf, "\n", 1);
        while (read(Rfi, Rc, 1) > 0) {
          write(Rf, Rc, 1);
        }
        close(Rf);
        close(Rfi);
      }
      else {
        Ri++;
      }
      free(Rfile);
    }
  }
  return(1);
}

