/*
       Samba Commander 
       GNU Licence

       author: Rafal Michniewicz 
        email: <rafim@data.pl>
       jabber: rafim@jabber.org
    home page: http://smbc.airm.net
*/
// -------------------------------------------------------------------
// if you have other GUEST accunt change this line
#define RGUEST "guest"
// -------------------------------------------------------------------
#define _GNU_SOURCE

#include "../config.h"

#ifdef HAVE_STRING_H
#include <string.h>
#else  /* not HAVE_STRING_H */
#ifdef HAVE_STRINGS_H
#include <strings.h>
#endif /* HAVE_STRINGS_H */
#endif /* not HAVE_STRING_H */

#include <sys/ioctl.h>
#include <libintl.h>
#include <sys/file.h>
#include <sys/wait.h>
#include <ctype.h>
#include <dirent.h>
#include <time.h>
#include <errno.h>
#include <libsmbclient.h>
#include <popt.h>
#include <unistd.h>
#include <stdlib.h>
#include "fnet.h"
#include "smb-pack.h"
#include "find-index-manage.h"
#include "debug.h"
#include "dulist.h"
#include "rtypedef.h"
#include "winpopup.h"
#include "bookmarks.h"
#include "convertm.h"

#define RMAXGROUPS 1000
#define RMAXHOSTS 1000
#define RMAXLIST 1000
#define RTFILE 0
#define RTDIR 1
#define RCalarm 1
// 5 - chars + 1 - \0
#define TfilesSizeShowLen 6

#define Rright Rm86
#define Rleft  Rm87
#define Rfrom  Rm88
#define Rto    Rm113

#define _(String) gettext (String)
#define gettext_noop(String) String
#define N_(String) gettext_noop (String)

typedef enum {
  RLLOCAL =  0, 
  RLREMOTE = 1
} RLTYPE;

WINDOW *RwinMain, *RwinLeft, *RwinRight, *RwinHead, *RwinStatus;
WINDOW *RwinLeftList, *RwinRightList, *RwinLeftHead, *RwinRightHead;
WINDOW *RwinLeftTop, *RwinRightTop;
WINDOW *RwinLeftCol1, *RwinLeftCol2, *RwinLeftCol3;
WINDOW *RwinRightCol1, *RwinRightCol2, *RwinRightCol3;
WINDOW *RwinLeftHeadCol1, *RwinLeftHeadCol2, *RwinLeftHeadCol3;
WINDOW *RwinRightHeadCol1, *RwinRightHeadCol2, *RwinRightHeadCol3;

WINDOW *RactiveWindow = NULL;

char Ragroup[RMAXGHLEN];
char Rahost[RMAXGHLEN];
char Radir[RMAXDIRLEN];
char RadirTmp[RMAXDIRLEN];
char RadirL[RMAXDIRLEN];
char RadirLtmp[RMAXDIRLEN];
char RadirOld[RMAXDIRLEN];
char *RfileNamePos;
char Rusername[RMAXGHLEN];
char Rpassword[RMAXGHLEN];
char RusernameInter[RMAXGHLEN];
char RpasswordInter[RMAXGHLEN];
char Rsmbclient[RMAXPATHTOSMBCLIENT];

typedef 
struct Tgroups {
  char groupname[RMAXGHLEN];
  char mastername[RMAXGHLEN];
  char masterip[16];
} TTgroups;

typedef 
struct Thosts {
  char hostname[RMAXGHLEN];
  char comment[RMAXGHLEN];
  char ip[16];
} TThosts;

typedef 
struct Tshares {
  char sharename[RMAXGHLEN];
  char comment[RMAXGHLEN];
} TTshares;

typedef 
struct Tfiles {
  char filename[RMAXGHLEN];
  int type;     
  char sizeShow[TfilesSizeShowLen];
  int size;
} TTfiles;

typedef 
struct Tlist {
  char col1[200];
  char col2[200];
  char col3[200];
  char col4[200];
  unsigned char select;
  int size;
} TTlist;

typedef 
struct Tcolor {
  short red;
  short green;
  short blue;
  char realnumber;
} TTcolor;

typedef 
struct Text {
  char ext[11];
  int colornr;
  struct Text *Text;
} TText;

typedef 
struct Tposition {
  int Pos;
  int First;
  struct Tposition *Tposition;
} TTposition;

int Ry, Rx, Rdx;
int RgroupsCount = -1;
int RhostsCount = -1;
int RsharesCount = -1;
int RfilesCount = -1;
int RfilesCountL = -1;
int RgrpAct;
int RhostAct;
int RshareAct;
int RfilesAct;
int RlistLeftPos, RlistRightPos;
int RlistLeftMax = -1;
int RlistRightMax = -1;
int RxHalf;
int RleftPos = 0;
int RrightPos = 0;
int RleftFirst = 0;
int RrightFirst = 0;
RLTYPE Rselected = RLREMOTE;
int RremoteLevel = 0;
int RdownloadHandleR = -1;
int RdownloadHandleL = -1;

#ifdef HAVE_SMBCCTX
SMBCCTX *Rstatcont = NULL;
#endif /* HAVE_SMBCCTX */

int Rtimeout = 3000;
time_t RavrTime = 0;
unsigned int RavrSize = 0;
unsigned int RavrSizeDisplay = 0;
long int RtimeR = 0;
int RindexFileFd = 0;
char *RfileNameForFindList;
char *RfileNameForFindListPrim;
char *RfileNameMessage;
char *RfileNameMessagePrim;
int RindexTime = 300;
int RchildId = 0;
int RchildDUId = 0;
int RlockFile = 0;
int RlockFileFlag = 0;
int RstatusBarStatus = 1;
time_t RlastTimeFileMessage = 1;
int RaskRetry = 1;
int RaskRetryDiskFull = 1;
int RrunFirst = 1;
char *RsmbcLockFile;
int RcancelFinding = 0;
int RdoResize = 0;
int RdoResizeFind = 0;
int RdoResizeDownload = 0;
int RdoResizeBookmark = 0;
char RdontDownload = 0;
int Raskquit = 1;
char *RstatusBarStrP;
int RdefaultDelayRetry = 60;
bool RactuallyNothingDownloadUpload = 0;
int Rerror = 0;
int RdontResizeWindow = 0;

char RcharSetFromPoFile[20];
char RcharSetOutput[20];
char RcharSetInternal[20];
char RcharSetFromToSystem[20];

int RsortReverseR = 0;  
int RgroupFilesDirectoriesR = 1;
int RsortMethodR = 1;   // 1 - name
                        // 2 - ext
                        // 3 - size

int RsortReverseL = 0;  
int RgroupFilesDirectoriesL = 1;
int RsortMethodL = 1;   // 1 - name
                        // 2 - ext
                        // 3 - size

TTgroups *Rgroups[RMAXGROUPS];
TThosts *Rhosts[RMAXHOSTS];
TTshares *Rshares[RMAXHOSTS];
TTfiles *Rfiles[RMAXHOSTS];
TTfiles *RfilesL[RMAXHOSTS];
TTlist *RlistLeft[RMAXLIST];
TTlist *RlistRight[RMAXLIST];
TTdownload *RdownloadList = NULL;
//int RdownloadListAct = -1;
TTdownload *RdownloadListAct = NULL;
TTcolor Rcolor[3];
TText *Rext = NULL; 
TTposition *RpositionLeft = NULL;
TTposition *RpositionRight = NULL;

void RwinRedraw();
void RwriteMenuTxt(int Rfirst, int Rwhat, RLTYPE Rcol, int Rselect);
void RstatusBar(int Rnr);
void RopenSaveDownloadList(int Rnr);
void RcreateFindListIndex(int Isave, char *Igroup, char *Ihost, char *Ipath, char *Idir, WINDOW *RwinI, int RfileFd);
void RdoWindowResize();
void RwinRedrawWithData();
void RcompareTwoIndexFile(int RfdNew, int RfdOld, int RfdMessage);
int RtryDownloadUpload();
void RtryLockFileAndCreateIndexFile();
void RsigAlarm();

char *Rm1, *Rm2, 

     *Rm23, *Rm24, *Rm25, *Rm26, *Rm27, *Rm28, *Rm29, 
     *Rm30, 
     *Rm40, *Rm41, *Rm42, *Rm43, *Rm44, *Rm45, *Rm46,        *Rm48, *Rm49, 
     *Rm50, *Rm51, *Rm52, *Rm53, *Rm54, *Rm55,        *Rm57, *Rm58, *Rm59,
     *Rm60, *Rm61, *Rm62, *Rm63, *Rm64, *Rm65,        *Rm67, *Rm68, *Rm69, 
     *Rm70, *Rm71, *Rm72, *Rm73, *Rm74, *Rm75, *Rm76, *Rm77, *Rm78, *Rm79, 
     *Rm80, *Rm81, *Rm82, *Rm83, *Rm84, *Rm85, *Rm86, *Rm87, *Rm88, 
     *Rm90, *Rm91, *Rm92, *Rm93, *Rm94, *Rm95, *Rm96, *Rm97, *Rm98, *Rm99, 
     *Rm100, *Rm101, *Rm102, *Rm103, *Rm104, *Rm105, *Rm106, *Rm107, *Rm108, 
             *Rm111,         *Rm113, *Rm114, *Rm115, *Rm116, *Rm117, *Rm118, *Rm119,
             *Rm121,         *Rm123, *Rm124, *Rm125,                         *Rm129,
             *Rm131,         *Rm133, *Rm134, *Rm135, *Rm136, *Rm137, *Rm138, *Rm139,
     *Rm140, *Rm141, *Rm142, *Rm143, *Rm144, *Rm145, *Rm146, *Rm147, *Rm148, *Rm149,
     *Rm150, *Rm151, *Rm152, *Rm153, *Rm154,         *Rm156, *Rm157, *Rm158, *Rm159,
     *Rm160,         *Rm162, *Rm163, *Rm164, *Rm165, *Rm166, *Rm167, *Rm168, *Rm169,
     *Rm170, *Rm171, *Rm172, *Rm173,         *Rm175, *Rm176, *Rm177, *Rm178,

     *Rm231, *Rm232, *Rm233, *Rm234, *Rm235, *Rm236, *Rm237, *Rm238, *Rm239, 
     *Rm240, *Rm241, *Rm242, *Rm243, *Rm244, *Rm245,

     *Rm300, *Rm301, *Rm302, *Rm303, *Rm304, *Rm305, *Rm306, *Rm307;
//-------------------------------------------------------------
void 
RinitStrings()
{
  asprintf(&Rm1, _("Please change screen"));
  asprintf(&Rm2, _("size to minimum 80x25"));
  asprintf(&Rm23, _(" is empty."));
  asprintf(&Rm24, _("Share "));

  asprintf(&Rm25, _("[ Retry ]"));
  asprintf(&Rm26, _("[ Wait ]"));
  asprintf(&Rm27, _("[ Overwrite ]"));
  asprintf(&Rm28, _("[ Retry without asking ]"));
  asprintf(&Rm29, _("[ Delete ]"));
  asprintf(&Rm30, _("retry delay time : "));
  asprintf(&Rm40, _("Download list is empty."));
  asprintf(&Rm41, _("I can't enter to"));
  asprintf(&Rm42, _("Do you want delete"));
  asprintf(&Rm43, _("Group "));
  asprintf(&Rm44, _("Host "));
  asprintf(&Rm45, _("Access denied."));
  asprintf(&Rm46, _("Do you want copy"));
  asprintf(&Rm48, _("Index for find file now is empty, try letter."));
  asprintf(&Rm49, _("Loading find index file from disk to memory, please wait...")); 
  asprintf(&Rm50, _("New message")); 
  asprintf(&Rm51, _("Do you want quit from smbc?")); 
  asprintf(&Rm52, _("S D size  remai per file/directory"));
  asprintf(&Rm53, _("time remaing | delay | from | to | group"));
  asprintf(&Rm54, _("Try connect to : "));
  asprintf(&Rm55, _("Permission denied to"));
  asprintf(&Rm57, "%s", _("Probably %s disk is full or quota exceeded."));
  asprintf(&Rm58, _("Adding files to download list..."));
  asprintf(&Rm59, _("Adding files to upload list..."));
  asprintf(&Rm60, _("q-quit | h-help | (d)F5-copy | s-download list | f - search remote file"));
  asprintf(&Rm61, _("Enter workgroup name, keys Enter,TAB - next field, Ctrl+P enable/disable interactive filtering, Ctrl+k - quit"));
  asprintf(&Rm62, _("Enter hostname name, Enter,TAB - next field, Ctrl+P enable/disable interactive filtering, Ctrl+k - quit"));
  asprintf(&Rm63, _("Enter dir name, Enter,TAB - next field, Ctrl+P enable/disable interactive filtering, Ctrl+k - quit"));
  asprintf(&Rm64, _("Enter file name, Enter,TAB - next field, Ctrl+P enable/disable interactive filtering, Ctrl+k - quit"));
  asprintf(&Rm65, _("q - quit | Enter - go to file | TAB - next field | PageUp,PageDown,Up,Down - manage to list"));

  asprintf(&Rm67, "%s", _("Preparing find index."));
  asprintf(&Rm68, "%s", _("Sort %s panel by filename."));
  asprintf(&Rm69, "%s", _("Sort %s panel by extension."));
  asprintf(&Rm70, "%s", _("Sort %s panel by size."));
  asprintf(&Rm71, "%s", _("%s panel without sorting."));
  asprintf(&Rm72, "%s", _("Reverse sorting in %s panel."));
  asprintf(&Rm73, "%s", _("Ungroup files and directories in %s panel."));
  asprintf(&Rm74, "%s", _("Group files and directories in %s panel."));
  asprintf(&Rm75, "%s", _("Warning. Can't copy %s workgroup."));
  asprintf(&Rm76, "%s", _("Warning. Can't copy %s host."));
  asprintf(&Rm77, _("Warning. Can't copy from share."));
  asprintf(&Rm78, _("Warning. Can't copy to network."));
  asprintf(&Rm79, _("(q)F3-quit | (w)F8-wrap/unwrap"));
  asprintf(&Rm80, _("Interactive filtering is off."));
  asprintf(&Rm81, _("Interactive filtering is on."));
  asprintf(&Rm82, _("q - quit | b - add bookmark and quit | d(DEL)/u - delete/undelete | x(Enter) - go to item"));
  asprintf(&Rm83, _("MOVE q - quit | b - add bookmark and quit | d(DEL)/u - delete/undelete | x(Enter) - go to item"));
  asprintf(&Rm84, _("q - exit | d(DEL) - delete | u - undelete | space - pause/resume | CTRL-d - delete dir | CTRL-f - flush list"));
  asprintf(&Rm85, _("MOVE q - exit | d(DEL) - delete | u - undelete | space - pause/resume | CTRL-d - delete dir | CTRL-f - flush list"));
  asprintf(&Rm86, _("right"));
  asprintf(&Rm87, _("left"));
  asprintf(&Rm88, _("from"));
  asprintf(&Rm90, _("o,arrow down - down              u,end - tail off list"));
  asprintf(&Rm91, _("p,arrow up   - up               y,home - head off list"));
  asprintf(&Rm92, _("i,tab        - change column      d,F5 - download/upload"));
  asprintf(&Rm93, _("t            - group/ungroup         w - reverse sorting"));
  asprintf(&Rm94, _("x,Enter           - execute a directory"));
  asprintf(&Rm95, _("a,insert          - select/unselect one file"));
  asprintf(&Rm96, _("l,page up         - one screen up"));
  asprintf(&Rm97, _("k,page down       - one screen down"));
  asprintf(&Rm98, _("CTRL-d,F8         - delete file or directory"));
  asprintf(&Rm99, _("shift-/shift=     - select/unselect all files"));
  asprintf(&Rm100, _("numeric *,shift-8 - reverse select"));
  asprintf(&Rm101, _("c,F7              - create directory"));
  asprintf(&Rm102, _("v,F3              - view text file"));
  asprintf(&Rm103, _("g                 - go to group/host/share/dir"));
  asprintf(&Rm104, _("e                 - change type of sorting"));
  asprintf(&Rm105, _("s                 - download list status"));
  asprintf(&Rm106, _("f - search file     r - reload     q - quit     h - help"));
  asprintf(&Rm107, _("              More details in README file."));
  asprintf(&Rm108, _("Inspiration is my wife Magda (Arida)"));

  asprintf(&Rm111, _("Files"));

  asprintf(&Rm113, _("to"));
  asprintf(&Rm114, _("are different or connection broken."));
  asprintf(&Rm115, _("Click on Wait to download letter."));
  asprintf(&Rm116, _("Warning"));
  asprintf(&Rm117, "%s", _("Can't %s"));
  asprintf(&Rm118, _("Connection broken."));
  asprintf(&Rm119, _("deleting"));

  asprintf(&Rm121, _("file or directory name"));

  asprintf(&Rm123, _("T"));
  asprintf(&Rm124, _("workgroup, share, file or directory name"));
  asprintf(&Rm125, _("size"));

  asprintf(&Rm129, _("error saving download/upload list\n"));

  asprintf(&Rm131, _("workgroup:"));

  asprintf(&Rm133, _("path:"));
  asprintf(&Rm134, _("username:"));
  asprintf(&Rm135, _("password:"));
  asprintf(&Rm136, _("[ OK ]"));
  asprintf(&Rm137, _("[ Cancel ]"));
  asprintf(&Rm138, _("Go to"));
  asprintf(&Rm139, _("Create directory"));
  asprintf(&Rm140, _("workgroup"));
  asprintf(&Rm141, _("hostname"));
  asprintf(&Rm142, _("dir"));
  asprintf(&Rm143, _("filename"));
  asprintf(&Rm144, _("Workgroup:"));
  asprintf(&Rm145, _("Hostname:"));
  asprintf(&Rm146, _("Dir:"));
  asprintf(&Rm147, _("Filename:"));
  asprintf(&Rm148, _("Finding files on the network"));
  asprintf(&Rm149, _("Workgroup :"));
  asprintf(&Rm150, _("     Host :"));
  asprintf(&Rm151, _("      Dir :"));
  asprintf(&Rm152, _("[ Quick find (with index) ]"));
  asprintf(&Rm153, _("[ Slow find (without index) ]"));
  asprintf(&Rm154, _("Find files"));

  asprintf(&Rm156, _("Your terminal cannot change defined color.\n"));
  asprintf(&Rm157, _("Any color definition from ~/.smbc/smbcrc was ignored.\n"));
  asprintf(&Rm158, "%s", _("Minimum recommended screen size is 80x25, now is %ix%i.\n"));
  asprintf(&Rm159, _("Please send raports with bugs to smbc@airm.net\n"));
  asprintf(&Rm160, _("or put it in then page\n"));
  asprintf(&Rm162, _("New find index is ready. You can use quick find file."));
  asprintf(&Rm163, _("hosts: "));
  asprintf(&Rm164, "%s", _("%s%i new, "));
  asprintf(&Rm165, "%s", _("%s%i offline, "));
  asprintf(&Rm166, "%s", _("%s new: %s%s"));
  asprintf(&Rm167, "%s", _("%s offline: %s"));
  asprintf(&Rm168, _("host:"));
  asprintf(&Rm169, _("message:"));
  asprintf(&Rm170, _("Send message"));
  asprintf(&Rm171, _("S R path to remote and local files"));
  asprintf(&Rm172, _("This bookmark already exists."));
  asprintf(&Rm173, _("smbc [OPTIONS]*"));
  asprintf(&Rm175, "%s", _("Unable to initialize libsmbclient, error numer %i\n"));
  asprintf(&Rm176, _("Probably you don't have a smb config file in ~/smb/smb.conf or ~/etc/samba/smb.conf\n"));
  asprintf(&Rm177, _("samba without smbc_set_context function, better is samba 3.0.1 or letter\n"));
  asprintf(&Rm178, _("selected files/directories"));

  asprintf(&Rm231, _(" complete file "));
  asprintf(&Rm232, _("Try letter connect to "));
  asprintf(&Rm233, _(". Delay time : "));
  asprintf(&Rm234, _("downloading"));
  asprintf(&Rm235, _("uploading"));
  asprintf(&Rm236, _("/s, remaing "));
  asprintf(&Rm237, _("m, "));
  asprintf(&Rm238, _("read"));
  asprintf(&Rm239, _("write"));
  asprintf(&Rm240, _("local"));
  asprintf(&Rm241, _("remote"));
  asprintf(&Rm242, "%s", _("Can't open config file: %s\n"));
  asprintf(&Rm243, _("More functions and parameters you can set up in this configuration file.\n"));
  asprintf(&Rm244, _("Example smbcrc file you can find in `docs` directory.\n"));
  asprintf(&Rm245, "%s", _("Can't open RC file %s, probably access denied.\n"));

  asprintf(&Rm300, _("Displays this help message"));
  asprintf(&Rm301, _("Flush all download lists"));
  asprintf(&Rm302, _("Show all download lists"));
  asprintf(&Rm303, _("Displays all items form dulistX"));
  asprintf(&Rm304, _("Sleep, don't download/upload any files"));
  asprintf(&Rm305, _("Receive message from samba."));
  asprintf(&Rm306, _("File with samba message, usage only with -m."));
  asprintf(&Rm307, _("Displays the current version"));
}

void 
RdoneStrings()
{
  free(Rm23), free(Rm24); free(Rm25), free(Rm26), free(Rm27), free(Rm28), free(Rm29), 
  free(Rm30), 
  free(Rm40), free(Rm41), free(Rm42), free(Rm43), free(Rm44), free(Rm45), free(Rm46),             free(Rm48), free(Rm49), 
  free(Rm50), free(Rm51), free(Rm52), free(Rm53), free(Rm54), free(Rm55),             free(Rm57), free(Rm58), free(Rm59),
  free(Rm60), free(Rm61), free(Rm62), free(Rm63), free(Rm64), free(Rm65),             free(Rm67), free(Rm68), free(Rm69), 
  free(Rm70), free(Rm71), free(Rm72), free(Rm73), free(Rm74), free(Rm75), free(Rm76), free(Rm77), free(Rm78), free(Rm79), 
  free(Rm80), free(Rm81), free(Rm82), free(Rm83), free(Rm84), free(Rm85), free(Rm86), free(Rm87), free(Rm88), 
  free(Rm90), free(Rm91), free(Rm92), free(Rm93), free(Rm94), free(Rm95), free(Rm96), free(Rm97), free(Rm98), free(Rm99), 
  free(Rm100), free(Rm101), free(Rm102), free(Rm103), free(Rm104), free(Rm105), free(Rm106), free(Rm107), free(Rm108), 
               free(Rm111),              free(Rm113), free(Rm114), free(Rm115), free(Rm116), free(Rm117), free(Rm118), free(Rm119),
               free(Rm121),              free(Rm123), free(Rm124), free(Rm125),                                        free(Rm129),
               free(Rm131),              free(Rm133), free(Rm134), free(Rm135), free(Rm136), free(Rm137), free(Rm138), free(Rm139),
  free(Rm140), free(Rm141), free(Rm142), free(Rm143), free(Rm144), free(Rm145), free(Rm146), free(Rm147), free(Rm148), free(Rm149),
  free(Rm150), free(Rm151), free(Rm152), free(Rm153), free(Rm154),              free(Rm156), free(Rm157), free(Rm158), free(Rm159),
  free(Rm160),              free(Rm162), free(Rm163), free(Rm164), free(Rm165), free(Rm166), free(Rm167), free(Rm168), free(Rm169),
  free(Rm170), free(Rm171), free(Rm172), free(Rm173),              free(Rm175), free(Rm176), free(Rm177), free(Rm178),

  free(Rm231), free(Rm232), free(Rm233), free(Rm234), free(Rm235), free(Rm236), free(Rm237), free(Rm238), free(Rm239), 
  free(Rm240), free(Rm241), free(Rm242), free(Rm243), free(Rm244), free(Rm245),

  free(Rm300), free(Rm301), free(Rm302), free(Rm303), free(Rm304), free(Rm305), free(Rm306), free(Rm307);
}

void 
RpressEnter(WINDOW *Rwin)
{
  keypad(Rwin, TRUE);  
  while (wgetch(Rwin) != 10) {};
}

int 
RdetectScreenToSmall()
{
  int Rys, Rxs;
  WINDOW *RwinMsg;
  
  getmaxyx(RwinMain, Ry, Rx); 
  RDBG("smbc : RdetectScreenToSmall Rx == "); RDBGi(Rx); RDBG(", Ry == "); RDBGi(Ry); RDBG("\n"); 
  if ((Rx < 80) || (Ry < 25)) {
     Rys = 4; Rxs = 30;
     RwinMsg = newwin(Rys,Rxs,Ry/2-Rys/2,Rx/2-Rxs/2);
     RmvwprintwCenter(RwinMsg, 1, Rm1);
     RmvwprintwCenter(RwinMsg, 2, Rm2);
     box(RwinMsg,0,0);
     wrefresh(RwinMsg);
     RpressEnter(RwinMsg);
     delwin(RwinMsg);
     return(1);
  }
  return(0);
}

int 
RshowMessage(int RnrMsg, char *Rmsg, char *Rmsg2, TTdownload *RTd)
{
  int Rii, Rys, Rxs;
  WINDOW *RwinMsg;
  WINDOW *RwinMsg2;
  char RmsgTmp[1000];
  int Rt1, Rt2, Rkey;
  char Rmsg1[20];
  char *RmsgT1;
  
  int Rxm, Rym;
  char *Rstmp; 
  char *Rms; 
  int Rtt, Rtt2;
  int Rt = 2;
  char *RtimeChar = NULL;
  char *RtimeCharT;

  RDBG("smbc : RshowMessage start\n");

  RdontResizeWindow = 1;

/*
 * Rpaint 
 */
 void Rpaint(int Ri, int Rnr, int Ry) 
 {
   int Rall;

   if (Rnr == 0) 
   { 
     Rall = strlen(Rm136)+strlen(Rm137);
     switch (Ri) 
     {
       case 1 : Rii = (Rxs-Rall)/2;                 
                  wattron(RwinMsg, COLOR_PAIR(1)); mvwprintw(RwinMsg, Ry, 1+Rii, "%s", Rm136); wattroff(RwinMsg, COLOR_PAIR(1)); 
                Rii = (Rxs-Rall)/2+strlen(Rm136)+1; 
                  mvwprintw(RwinMsg, Ry, 1+Rii, "%s", Rm137);
                break;
       case 0 : Rii = (Rxs-Rall)/2;                 
                  mvwprintw(RwinMsg, Ry, 1+Rii, "%s", Rm136);
                Rii = (Rxs-Rall)/2+strlen(Rm136)+1; 
                  wattron(RwinMsg, COLOR_PAIR(1)); mvwprintw(RwinMsg, Ry, 1+Rii, "%s", Rm137); wattroff(RwinMsg, COLOR_PAIR(1)); 
                break;
     }
   } 
   else 
   if (Rnr == 1) {
     Rt = 3;
     Rall = strlen(Rm25)+strlen(Rm26)+strlen(Rm27)+strlen(Rm137)+3;
     RreturnHumanDelayTime(&RtimeCharT, RTd->delayRetry);
     asprintf(&RtimeChar, "%s%s", Rm30, RtimeCharT);
     free(RtimeCharT);
     switch (Ri) 
     {
       case 5 : Rii = (Rxs-Rall)/2; 
                  mvwprintw(RwinMsg, Ry, 1+Rii, "%s", Rm25);
                Rii = (Rxs-Rall)/2+strlen(Rm25)+1; 
                  mvwprintw(RwinMsg, Ry, 1+Rii, "%s", Rm26);
                Rii = (Rxs-Rall)/2+strlen(Rm25)+strlen(Rm26)+2; 
                  mvwprintw(RwinMsg, Ry, 1+Rii, "%s", Rm27); 
                Rii = (Rxs-Rall)/2+strlen(Rm25)+strlen(Rm26)+strlen(Rm27)+3; 
                  mvwprintw(RwinMsg, Ry, 1+Rii, "%s", Rm137); 
                Rii = (Rxs)/2-strlen(Rm28)/2; 
                  mvwprintw(RwinMsg, Ry+1, 1+Rii, "%s", Rm28); 
                mvwhline(RwinMsg, Ry+2, 1, ' ', Rxs-2);
                Rii = (Rxs)/2-strlen(RtimeChar)/2; 
                  wattron(RwinMsg, COLOR_PAIR(1)); 
                  mvwprintw(RwinMsg, Ry+2, 1+Rii, "%s", RtimeChar); 
                  wattroff(RwinMsg, COLOR_PAIR(1));
                break;
       case 4 : Rii = (Rxs-Rall)/2; 
                  mvwprintw(RwinMsg, Ry, 1+Rii, "%s", Rm25);
                Rii = (Rxs-Rall)/2+strlen(Rm25)+1; 
                  mvwprintw(RwinMsg, Ry, 1+Rii, "%s", Rm26);
                Rii = (Rxs-Rall)/2+strlen(Rm25)+strlen(Rm26)+2; 
                  mvwprintw(RwinMsg, Ry, 1+Rii, "%s", Rm27); 
                Rii = (Rxs-Rall)/2+strlen(Rm25)+strlen(Rm26)+strlen(Rm27)+3; 
                  mvwprintw(RwinMsg, Ry, 1+Rii, "%s", Rm137); 
                Rii = (Rxs)/2-strlen(Rm28)/2; 
                  wattron(RwinMsg, COLOR_PAIR(1)); 
                  mvwprintw(RwinMsg, Ry+1, 1+Rii, "%s", Rm28); 
                  wattroff(RwinMsg, COLOR_PAIR(1)); 
                Rii = (Rxs)/2-strlen(RtimeChar)/2; 
                  mvwprintw(RwinMsg, Ry+2, 1+Rii, "%s", RtimeChar);
                break;
       case 3 : Rii = (Rxs-Rall)/2; 
                  wattron(RwinMsg, COLOR_PAIR(1)); 
                  mvwprintw(RwinMsg, Ry, 1+Rii, "%s", Rm25); 
                  wattroff(RwinMsg, COLOR_PAIR(1));
                Rii = (Rxs-Rall)/2+strlen(Rm25)+1; 
                  mvwprintw(RwinMsg, Ry, 1+Rii, "%s", Rm26);
                Rii = (Rxs-Rall)/2+strlen(Rm25)+strlen(Rm26)+2; 
                  mvwprintw(RwinMsg, Ry, 1+Rii, "%s", Rm27);
                Rii = (Rxs-Rall)/2+strlen(Rm25)+strlen(Rm26)+strlen(Rm27)+3; 
                  mvwprintw(RwinMsg, Ry, 1+Rii, "%s", Rm137);
                Rii = (Rxs)/2-strlen(Rm28)/2; 
                  mvwprintw(RwinMsg, Ry+1, 1+Rii, "%s", Rm28);
                Rii = (Rxs)/2-strlen(RtimeChar)/2; 
                  mvwprintw(RwinMsg, Ry+2, 1+Rii, "%s", RtimeChar);
                break;
       case 2 : Rii = (Rxs-Rall)/2; 
                  mvwprintw(RwinMsg, Ry, 1+Rii, "%s", Rm25);
                Rii = (Rxs-Rall)/2+strlen(Rm25)+1; 
                  wattron(RwinMsg, COLOR_PAIR(1)); 
                  mvwprintw(RwinMsg, Ry, 1+Rii, "%s", Rm26); 
                  wattroff(RwinMsg, COLOR_PAIR(1)); 
                Rii = (Rxs-Rall)/2+strlen(Rm25)+strlen(Rm26)+2; 
                  mvwprintw(RwinMsg, Ry, 1+Rii, "%s", Rm27);
                Rii = (Rxs-Rall)/2+strlen(Rm25)+strlen(Rm26)+strlen(Rm27)+3; 
                  mvwprintw(RwinMsg, Ry, 1+Rii, "%s", Rm137);
                Rii = (Rxs)/2-strlen(Rm28)/2; 
                  mvwprintw(RwinMsg, Ry+1, 1+Rii, "%s", Rm28);
                Rii = (Rxs)/2-strlen(RtimeChar)/2; 
                  mvwprintw(RwinMsg, Ry+2, 1+Rii, "%s", RtimeChar);
                break;
       case 1 : Rii = (Rxs-Rall)/2; 
                  mvwprintw(RwinMsg, Ry, 1+Rii, "%s", Rm25);
                Rii = (Rxs-Rall)/2+strlen(Rm25)+1; 
                  mvwprintw(RwinMsg, Ry, 1+Rii, "%s", Rm26);
                Rii = (Rxs-Rall)/2+strlen(Rm25)+strlen(Rm26)+2; 
                  wattron(RwinMsg, COLOR_PAIR(1)); 
                  mvwprintw(RwinMsg, Ry, 1+Rii, "%s", Rm27); 
                  wattroff(RwinMsg, COLOR_PAIR(1)); 
                Rii = (Rxs-Rall)/2+strlen(Rm25)+strlen(Rm26)+strlen(Rm27)+3; 
                  mvwprintw(RwinMsg, Ry, 1+Rii, "%s", Rm137);
                Rii = (Rxs)/2-strlen(Rm28)/2; 
                  mvwprintw(RwinMsg, Ry+1, 1+Rii, "%s", Rm28);
                Rii = (Rxs)/2-strlen(RtimeChar)/2; 
                  mvwprintw(RwinMsg, Ry+2, 1+Rii, "%s", RtimeChar);
                break;
       case 0 : Rii = (Rxs-Rall)/2; 
                  mvwprintw(RwinMsg, Ry, 1+Rii, "%s", Rm25);
                Rii = (Rxs-Rall)/2+strlen(Rm25)+1; 
                  mvwprintw(RwinMsg, Ry, 1+Rii, "%s", Rm26);
                Rii = (Rxs-Rall)/2+strlen(Rm25)+strlen(Rm26)+2; 
                  mvwprintw(RwinMsg, Ry, 1+Rii, "%s", Rm27); 
                Rii = (Rxs-Rall)/2+strlen(Rm25)+strlen(Rm26)+strlen(Rm27)+3; 
                  wattron(RwinMsg, COLOR_PAIR(1)); 
                  mvwprintw(RwinMsg, Ry, 1+Rii, "%s", Rm137); 
                  wattroff(RwinMsg, COLOR_PAIR(1)); 
                Rii = (Rxs)/2-strlen(Rm28)/2; 
                  mvwprintw(RwinMsg, Ry+1, 1+Rii, "%s", Rm28);
                Rii = (Rxs)/2-strlen(RtimeChar)/2; 
                  mvwprintw(RwinMsg, Ry+2, 1+Rii, "%s", RtimeChar);
                break;
     }
     free(RtimeChar);
   } 
   else
   if (Rnr == 2) 
   {
     Rt = 2;
     Rall = strlen(Rm25)+strlen(Rm26)+strlen(Rm29)+strlen(Rm137);
     switch (Ri) 
     {
       case 3 : Rii = (Rxs-Rall)/2; 
                  wattron(RwinMsg, COLOR_PAIR(1)); 
                  mvwprintw(RwinMsg, Ry, 1+Rii, "%s", Rm25); 
                  wattroff(RwinMsg, COLOR_PAIR(1)); 
                Rii = (Rxs-Rall)/2+strlen(Rm25)+1; 
                  mvwprintw(RwinMsg, Ry, 1+Rii, "%s", Rm26);
                Rii = (Rxs-Rall)/2+strlen(Rm25)+strlen(Rm26)+2;  
                  mvwprintw(RwinMsg, Ry, 1+Rii, "%s", Rm29);
                Rii = (Rxs-Rall)/2+strlen(Rm25)+strlen(Rm26)+strlen(Rm29)+3; 
                  mvwprintw(RwinMsg, Ry, 1+Rii, "%s", Rm137);
                break;
       case 2 : Rii = (Rxs-Rall)/2; 
                  mvwprintw(RwinMsg, Ry, 1+Rii, "%s", Rm25);
                Rii = (Rxs-Rall)/2+strlen(Rm25)+1; 
                  wattron(RwinMsg, COLOR_PAIR(1)); 
                  mvwprintw(RwinMsg, Ry, 1+Rii, "%s", Rm26); 
                  wattroff(RwinMsg, COLOR_PAIR(1)); 
                Rii = (Rxs-Rall)/2+strlen(Rm25)+strlen(Rm26)+2; 
                  mvwprintw(RwinMsg, Ry, 1+Rii, "%s", Rm29);
                Rii = (Rxs-Rall)/2+strlen(Rm25)+strlen(Rm26)+strlen(Rm29)+3; 
                  mvwprintw(RwinMsg, Ry, 1+Rii, "%s", Rm137);
                break;
       case 1 : Rii = (Rxs-Rall)/2; 
                  mvwprintw(RwinMsg, Ry, 1+Rii, "%s", Rm25);
                Rii = (Rxs-Rall)/2+strlen(Rm25)+1; 
                  mvwprintw(RwinMsg, Ry, 1+Rii, "%s", Rm26);
                Rii = (Rxs-Rall)/2+strlen(Rm25)+strlen(Rm26)+2; 
                  wattron(RwinMsg, COLOR_PAIR(1)); 
                  mvwprintw(RwinMsg, Ry, 1+Rii, "%s", Rm29); 
                  wattroff(RwinMsg, COLOR_PAIR(1)); 
                Rii = (Rxs-Rall)/2+strlen(Rm25)+strlen(Rm26)+strlen(Rm29)+3; 
                  mvwprintw(RwinMsg, Ry, 1+Rii, "%s", Rm137);
                break;
       case 0 : Rii = (Rxs-Rall)/2; 
                  mvwprintw(RwinMsg, Ry, 1+Rii, "%s", Rm25);
                Rii = (Rxs-Rall)/2+strlen(Rm25)+1; 
                  mvwprintw(RwinMsg, Ry, 1+Rii, "%s", Rm26);
                Rii = (Rxs-Rall)/2+strlen(Rm25)+strlen(Rm26)+2; 
                  mvwprintw(RwinMsg, Ry, 1+Rii, "%s", Rm29); 
                Rii = (Rxs-Rall)/2+strlen(Rm25)+strlen(Rm26)+strlen(Rm29)+3; 
                  wattron(RwinMsg, COLOR_PAIR(1)); 
                  mvwprintw(RwinMsg, Ry, 1+Rii, "%s", Rm137); 
                  wattroff(RwinMsg, COLOR_PAIR(1)); 
                break;
     }
   } 
  }

/*
 * END Rpaint 
 */
  switch(RnrMsg) 
  {
    case 0: Rys = 8; Rxs = 40;
            RwinMsg = newwin(Rys,Rxs,Ry/2-Rys/2,Rx/2-Rxs/2);
            box(RwinMsg,0,0);
            Rii = Rxs/2-strlen(Rm41)/2; 
              mvwprintw(RwinMsg, 2, 1+Rii, "%s", Rm41);
            Rii = Rxs/2-strlen(Rmsg)/2; 
              mvwprintw(RwinMsg, 3, 1+Rii, "%s", Rmsg);
            Rii = Rxs/2-strlen(Rm136)/2; 
              wattron(RwinMsg, COLOR_PAIR(1)); 
              mvwprintw(RwinMsg, 5, 1+Rii, "%s", Rm136); 
              wattroff(RwinMsg, COLOR_PAIR(1)); 
            wrefresh(RwinMsg);
            RpressEnter(RwinMsg);
            delwin(RwinMsg);
            break;
    case 1: Rys = 25; Rxs = 60;
            Rtt = 1; Rtt2 = 2;
            RwinMsg = newwin(Rys,Rxs,Ry/2-Rys/2,Rx/2-Rxs/2);
            RmvwprintwCenter(RwinMsg, Rtt++, "Samba Commander");
            RmvwprintwCenter(RwinMsg, Rtt++, "http://smbc.airm.net");
            Rtt+=1;
            mvwprintw(RwinMsg, Rtt++, Rtt2, Rm90);
            mvwprintw(RwinMsg, Rtt++, Rtt2, Rm91);
            mvwprintw(RwinMsg, Rtt++, Rtt2, Rm92);
            mvwprintw(RwinMsg, Rtt++, Rtt2, Rm93);
            Rtt+=1;
            Rtt2 = 7;
            mvwprintw(RwinMsg, Rtt++, Rtt2, Rm94);
            mvwprintw(RwinMsg, Rtt++, Rtt2, Rm95);
            mvwprintw(RwinMsg, Rtt++, Rtt2, Rm96);
            mvwprintw(RwinMsg, Rtt++, Rtt2, Rm97);
            mvwprintw(RwinMsg, Rtt++, Rtt2, Rm98);
            mvwprintw(RwinMsg, Rtt++, Rtt2, Rm99);
            mvwprintw(RwinMsg, Rtt++, Rtt2, Rm100);
            mvwprintw(RwinMsg, Rtt++, Rtt2, Rm101);
            mvwprintw(RwinMsg, Rtt++, Rtt2, Rm102);
            mvwprintw(RwinMsg, Rtt++, Rtt2, Rm103);
            mvwprintw(RwinMsg, Rtt++, Rtt2, Rm104);
            mvwprintw(RwinMsg, Rtt++, Rtt2, Rm105);
            Rtt+=1;
            Rtt2 = 2;
            mvwprintw(RwinMsg, Rtt++, Rtt2, Rm106);
            mvwprintw(RwinMsg, Rtt++, Rtt2, Rm107);
            box(RwinMsg,0,0);
            wrefresh(RwinMsg);
            keypad(RwinMsg, TRUE); 
            nodelay(RwinMsg,1);
            RactiveWindow = RwinMsg;
            RDBG("smbc : RshowMessage RactiveWindow = RwinMsg  1\n");
            while (wgetch(RwinMsg) != 10) {
              RtryDownloadUpload();
            }
            delwin(RwinMsg);
            break;
    case 2: Rys = 10; Rxs = 60;
            RwinMsg = newwin(Rys,Rxs,Ry/2-Rys/2,Rx/2-Rxs/2);
            box(RwinMsg,0,0);
            Rii = Rxs/2-strlen(Rm42)/2; 
               mvwprintw(RwinMsg, 2, 1+Rii, "%s",Rm42);
            RmsgT1 = to_scr(Rmsg);
            
            Rii = strlen(RmsgT1);
            if (Rii > Rxs-4)
              RmsgT1[Rxs-4] = 0;

            Rii = Rxs/2-strlen(RmsgT1)/2; 
              mvwprintw(RwinMsg, 3, Rii, "%s", RmsgT1);
            Rt1 = 0; 
              Rpaint(Rt1,0,7);
            nodelay(RwinMsg, 1);
            RactiveWindow = RwinMsg;
            RDBG("smbc : RshowMessage RactiveWindow = RwinMsg  2\n");
            while ((Rkey = mvwgetch(RwinMsg, 1,1))) {
               RtryDownloadUpload();
               if (Rkey == 'i' || Rkey == 9 || Rkey == 67 || Rkey == 68) 
               { 
                  Rt1 = !Rt1; 
                  Rpaint(Rt1,0,7); 
               }
               if (Rkey == 10 || Rkey == 'x') 
               {
                 wrefresh(RwinMsg);
                 delwin(RwinMsg);
                 RwinRedrawWithData();
                 RdontResizeWindow = 0;
                 if (Rt1) 
                   return(1);
                 else 
                   return(0);
               }
            }
    case 3: Rys = 8; Rxs = 60;
            RwinMsg = newwin(Rys,Rxs,Ry/2-Rys/2,Rx/2-Rxs/2);
            box(RwinMsg,0,0);
            Rii = Rxs/2-strlen(Rm51)/2; mvwprintw(RwinMsg, 2, 1+Rii, "%s",Rm51);
            Rt1 = 1; Rpaint(Rt1,0,5);
            nodelay(RwinMsg, 1);
            RactiveWindow = RwinMsg;
            RDBG("smbc : RshowMessage RactiveWindow = RwinMsg  3\n");
            while ((Rkey = mvwgetch(RwinMsg, 1,1))) {
               RtryDownloadUpload();
               if (Rkey == 'i' || Rkey == 9 || Rkey == 67 || Rkey == 68) { Rt1 = !Rt1; Rpaint(Rt1,0,5); }
               if (Rkey == 10 || Rkey == 'x') {
                 wrefresh(RwinMsg);
                 delwin(RwinMsg);
                 RwinRedrawWithData();
                 RdontResizeWindow = 0;
                 if (Rt1) 
                   return(1);
                 else 
                   return(0);
               }
            }
    case 19:
    case 20: 
    case 21: Rys = 8; Rxs = 60;
             RwinMsg = newwin(Rys,Rxs,Ry/2-Rys/2,Rx/2-Rxs/2);
             box(RwinMsg,0,0);
             switch(RnrMsg)
             {
               case 19: memcpy(Rmsg1, Rm24, strlen(Rm24)+1);
                        break;
               case 20: memcpy(Rmsg1, Rm43, strlen(Rm43)+1);
                        break;
               case 21: memcpy(Rmsg1, Rm44, strlen(Rm44)+1);
                        break;
             }
             Rt2 = strlen(Rmsg1); Rt1 = Rt2;
             memcpy(RmsgTmp, Rmsg1, Rt2);
             RmsgT1 = to_scr(Rmsg);
             Rt2 = strlen(RmsgT1);
             memcpy(RmsgTmp+Rt1, RmsgT1, Rt2); Rt1 += Rt2;
             memcpy(RmsgTmp+Rt1, Rm23, strlen(Rm23)+1);
             Rii = Rxs/2-strlen(RmsgTmp)/2;
               mvwprintw(RwinMsg, 2, 1+Rii, "%s", RmsgTmp);
             Rii = Rxs/2-strlen(Rm136)/2;
               wattron(RwinMsg, COLOR_PAIR(1)); 
               mvwprintw(RwinMsg, 5, 1+Rii, "%s", Rm136);
               wattroff(RwinMsg, COLOR_PAIR(1)); 
             wrefresh(RwinMsg);
             RpressEnter(RwinMsg);
             delwin(RwinMsg);
             break;
    case 22: Rys = 9; Rxs = 60;
             RwinMsg = newwin(Rys,Rxs,Ry/2-Rys/2,Rx/2-Rxs/2);
             box(RwinMsg,0,0);
             Rii = Rxs/2-strlen(Rm41)/2; 
               mvwprintw(RwinMsg, 2, 1+Rii, "%s",Rm41);
             RmsgT1 = to_scr(Rmsg);
             Rii = Rxs/2-strlen(RmsgT1)/2; 
               mvwprintw(RwinMsg, 3, 1+Rii, "%s", RmsgT1);
             Rii = Rxs/2-strlen(Rm45)/2; 
               mvwprintw(RwinMsg, 4, 1+Rii, "%s",Rm45);
             Rii = Rxs/2-strlen(Rm136)/2; 
               wattron(RwinMsg, COLOR_PAIR(1)); 
               mvwprintw(RwinMsg, 6, 1+Rii, "%s", Rm136); 
               wattroff(RwinMsg, COLOR_PAIR(1)); 
             wrefresh(RwinMsg);
             RpressEnter(RwinMsg);
             delwin(RwinMsg);
             break;
    case 23: Rys = 10; Rxs = 60;
             RwinMsg = newwin(Rys,Rxs,Ry/2-Rys/2,Rx/2-Rxs/2);
             box(RwinMsg,0,0);
             Rii = Rxs/2-strlen(Rm46)/2; 
               mvwprintw(RwinMsg, 2, Rii, "%s", Rm46);
  
             RmsgT1 = to_scr(Rmsg);
             Rii = strlen(RmsgT1);
             if (Rii > Rxs-4)
               RmsgT1[Rxs-4] = 0;
  
             Rii = Rxs/2-strlen(RmsgT1)/2; 
               mvwprintw(RwinMsg, 3, Rii, "%s", RmsgT1);
             Rii = Rxs/2-strlen(Rm113)/2; 
               mvwprintw(RwinMsg, 4, Rii, "%s", Rm113);
  
             RmsgT1 = to_scr(Rmsg2);
             Rii = strlen(RmsgT1);
             if (Rii > Rxs-4)
               RmsgT1[Rxs-4] = 0;
  
             Rii = Rxs/2-strlen(RmsgT1)/2; 
               mvwprintw(RwinMsg, 5, Rii, "%s", RmsgT1);
  
             Rt1 = 1; Rpaint(Rt1,0,7);
             while ((Rkey = mvwgetch(RwinMsg, 1,1))) 
             {
                if (Rkey == 'i' || Rkey == 9 || Rkey == 67 || Rkey == 68) 
                { 
                  Rt1 = !Rt1; 
                  Rpaint(Rt1,0,7); 
                }
                if (Rkey == 10 || Rkey == 'x') 
                {
                  wrefresh(RwinMsg);
                  delwin(RwinMsg);
                  RwinRedrawWithData();
                  RdontResizeWindow = 0;
                  if (Rt1) 
                    return(1);
                  else 
                    return(0);
                }
             }
             break;
    case 24: RDBG("smbc : RshowMessage RnrMsg = 4\n");
             Rys = 7; Rxs = 60;
             RwinMsg = newwin(Rys,Rxs,Ry/2-Rys/2,Rx/2-Rxs/2);
             box(RwinMsg,0,0);
             Rii = Rxs/2-strlen(Rm40)/2; 
               mvwprintw(RwinMsg, 2, 1+Rii, "%s",Rm40);
             Rii = Rxs/2-strlen(Rm136)/2;
               wattron(RwinMsg, COLOR_PAIR(1)); 
               mvwprintw(RwinMsg, 4, 1+Rii, "%s", Rm136);
               wattroff(RwinMsg, COLOR_PAIR(1)); 
             wrefresh(RwinMsg);
             RpressEnter(RwinMsg);
             delwin(RwinMsg);
             break;
    case 25: Rys = 16; Rxs = 0; 
             getmaxyx(RwinMain, Rym, Rxm); 
             Rt = strlen(RTd->filename)+6; 
             if (Rt > Rxm) 
               Rxs = Rxm; 
             else 
               Rxs = Rt;
             Rt = strlen(RTd->pathR)+6; 
             if (Rt > Rxs) 
             {
               if (Rt > Rxm) 
                 Rxs = Rxm;
               else 
                 Rxs = Rt;
             }
             Rt = strlen(RTd->pathL)+6; 
             if (Rt > Rxs) 
             {
               if (Rt > Rxm) 
                 Rxs = Rxm;
               else 
                 Rxs = Rt;
             }
             if (Rxs < 50) Rxs = 50;
             RwinMsg = newwin(Rys,Rxs,Ry/2-Rys/2,Rx/2-Rxs/2);
             keypad(RwinMsg, TRUE); 
             box(RwinMsg,0,0);
             Rii = Rxs/2-strlen(Rm116)/2; 
               mvwprintw(RwinMsg, 2, Rii, "%s", Rm116);
             Rii = Rxs/2-strlen(Rm111)/2; 
               mvwprintw(RwinMsg, 4, Rii, "%s", Rm111);
             Rii = Rxs/2-strlen(RTd->filename)/2; 
               mvwprintw(RwinMsg, 5, Rii, "%s", RTd->filename);
             Rii = Rxs/2-strlen(Rm88)/2; 
               mvwprintw(RwinMsg, 6, Rii, "%s", Rm88);
             Rii = Rxs/2-strlen(RTd->pathR)/2; 
               mvwprintw(RwinMsg, 7, Rii, "%s", RTd->pathR);
             Rii = Rxs/2-strlen(Rm113)/2; 
               mvwprintw(RwinMsg, 8, Rii, "%s", Rm113);
             Rii = Rxs/2-strlen(RTd->pathL)/2; 
               mvwprintw(RwinMsg, 9, Rii, "%s", RTd->pathL);
             Rii = Rxs/2-strlen(Rm114)/2; 
               mvwprintw(RwinMsg, 10, Rii, "%s", Rm114);
             Rii = Rxs/2-strlen(Rm115)/2; 
               mvwprintw(RwinMsg, 11, Rii, "%s", Rm115);
             Rt1 = 0; Rpaint(Rt1,1,Rys-3);
             wrefresh(RwinMsg);
             while ((Rkey = mvwgetch(RwinMsg, 1,1))) 
             {
               if (Rkey == 260) 
               {
                 if (Rt1 < 3) 
                   Rt1++; 
                 else 
                   Rt1 = 0;
                 Rpaint(Rt1,1,Rys-3); 
               } 
               if (Rkey == 'i' || Rkey == 261 || Rkey == 9) 
               { 
                 if (Rt1 > 0) 
                   Rt1--;
                 else 
                   (Rt1 = 3);
                 Rpaint(Rt1,1,Rys-3); 
               }
               if (Rkey == 10 || Rkey == 'x') 
               {
                 wrefresh(RwinMsg);
                 delwin(RwinMsg);
                 RwinRedrawWithData();
                 RdontResizeWindow = 0;
                 return(Rt1);
               }
             }
             break;
    case 26: Rys = 14; Rxs = 0; 
             getmaxyx(RwinMain,Rym,Rxm); 
             Rt = strlen(to_scr(RTd->filename))+6; 
             if (Rt > Rxm) 
               Rxs = Rxm; 
             else 
               Rxs = Rt;
             Rt = strlen(to_scr(RTd->pathR))+6; 
             if (Rt > Rxs) 
             {
               if (Rt > Rxm) 
                 Rxs = Rxm;
               else 
                 Rxs = Rt;
             }
             Rt = strlen(to_scr(RTd->pathL))+6; 
             if (Rt > Rxs) 
             {
               if (Rt > Rxm) 
                 Rxs = Rxm;
               else 
                 Rxs = Rt;
             }
             if (Rxs < 50) 
               Rxs = 50;
             
             RwinMsg = newwin(Rys,Rxs,Ry/2-Rys/2,Rx/2-Rxs/2);
             box(RwinMsg,0,0);
             Rii = Rxs/2-strlen(Rm116)/2; 
               mvwprintw(RwinMsg, 2, Rii, "%s", Rm116);
             asprintf(&Rstmp, Rm117, Rmsg); 
               Rii = Rxs/2-strlen(Rstmp)/2; 
               mvwprintw(RwinMsg, 4, Rii, "%s", Rstmp); 
               free(Rstmp);

             Rms = to_scr(RTd->filename);
             if (strlen(Rms)+4 > Rxs)
               Rms[Rxs-4] = 0;
             Rii = Rxs/2-strlen(Rms)/2; 
               mvwprintw(RwinMsg, 5, Rii, "%s", Rms);

             Rii = Rxs/2-strlen(Rm118)/2; 
               mvwprintw(RwinMsg, 6, Rii, "%s", Rm118);

             Rt1 = 0; Rpaint(Rt1,1,Rys-5);
             wrefresh(RwinMsg);
             keypad(RwinMsg, TRUE);
             while ((Rkey = mvwgetch(RwinMsg, 1,1))) 
             {
               if (Rkey == 260) 
               { 
                 if (Rt1 < 5) 
                   Rt1++; 
                 else 
                   Rt1 = 0;
                 Rpaint(Rt1,1,Rys-5); 
               } 
               if (Rkey == 261 || Rkey == 'i' || Rkey == 9) 
               {
                 if (Rt1 > 0) 
                   Rt1--;
                 else 
                   (Rt1 = 5);
                 Rpaint(Rt1,1,Rys-5); 
               }
               if (Rt1 == 5) 
               {
                 if ((Rkey == ',') || (Rkey == 258)) 
                 {
                   if (RTd->delayRetry > 0) 
                     RTd->delayRetry--;
                   Rpaint(Rt1,1,Rys-5);
                 }
                 if ((Rkey == '.') || (Rkey == 259)) 
                 {
                   RTd->delayRetry++;
                   Rpaint(Rt1,1,Rys-5);
                 }
                 if ((Rkey == '<') || (Rkey == 66)) 
                 {
                   if (RTd->delayRetry > 60)
                     RTd->delayRetry = RTd->delayRetry-60;
                   else
                     RTd->delayRetry=0;
                   Rpaint(Rt1,1,Rys-5);
                 }
                 if ((Rkey == '>') || (Rkey == 65)) 
                 {
                   RTd->delayRetry = RTd->delayRetry+60;
                   Rpaint(Rt1,1,Rys-5);
                 }
               }
               if (Rkey == 10 || Rkey == 'x') 
               {
                 RTd->nextRetry = time(NULL)+RTd->delayRetry;
                 wrefresh(RwinMsg);
                 delwin(RwinMsg);
                 RwinRedrawWithData();
                 RdontResizeWindow = 0;
                 return(Rt1);
               }
             }
             break;
    case 27: Rys = 9; Rxs = 40;
             RmsgT1 = to_scr(Rmsg);
             if (strlen(RmsgT1)+2 > Rxs) 
               Rxs = strlen(RmsgT1)+4;
             RwinMsg = newwin(Rys,Rxs,Ry/2-Rys/2,Rx/2-Rxs/2);
             box(RwinMsg,0,0);
             Rii = Rxs/2-strlen(Rm55)/2; 
               mvwprintw(RwinMsg, 2, Rii, "%s",Rm55);
             Rii = Rxs/2-strlen(RmsgT1+4)/2; 
               mvwprintw(RwinMsg, 3, Rii, RmsgT1+4);
             Rii = Rxs/2-strlen(Rm136)/2; 
               wattron(RwinMsg, COLOR_PAIR(1)); 
               mvwprintw(RwinMsg, 6, Rii, Rm136); 
               wattroff(RwinMsg, COLOR_PAIR(1)); 
             wrefresh(RwinMsg);
             RpressEnter(RwinMsg);
             delwin(RwinMsg);
             break;
    case 28: Rys = 7; Rxs = 62;
             RwinMsg = newwin(Rys,Rxs,Ry/2-Rys/2,Rx/2-Rxs/2);
             box(RwinMsg,0,0);
             Rii = Rxs/2-strlen(Rm48)/2; 
               mvwprintw(RwinMsg, 2, 1+Rii, "%s",Rm48);
             Rii = Rxs/2-strlen(Rm136)/2;
               wattron(RwinMsg, COLOR_PAIR(1)); 
               mvwprintw(RwinMsg, 4, 1+Rii, "%s", Rm136);
               wattroff(RwinMsg, COLOR_PAIR(1)); 
             wrefresh(RwinMsg);
             nodelay(RwinMsg, 1);
             RactiveWindow = RwinMsg;
             RDBG("smbc : RshowMessage RactiveWindow = RwinMsg  4\n");
             while (wgetch(RwinMsg) != 10) 
             {
               RtryDownloadUpload();
             };
             delwin(RwinMsg);
             break;
    case 29: Rys = 9; Rxs = 60; 
             RwinMsg = newwin(Rys,Rxs,Ry/2-Rys/2,Rx/2-Rxs/2);
             keypad(RwinMsg, TRUE);
             box(RwinMsg,0,0);
             RmsgT1 = to_scr(Rmsg);
             asprintf(&Rstmp, Rm57, RmsgT1); 
               Rii = Rxs/2-strlen(Rstmp)/2; 
               mvwprintw(RwinMsg, 2, Rii, "%s", Rstmp); 
               free(Rstmp);
             Rt1 = 3; 
               Rpaint(Rt1,1,Rys-4);
             wrefresh(RwinMsg);
             while ((Rkey = mvwgetch(RwinMsg, 1,1))) 
             {
               if (Rkey == 260) { 
                 if (Rt1 < 4) Rt1++; 
                 else Rt1 = 0;
                 Rpaint(Rt1,1,Rys-4); 
               } 
               if (Rkey == 261 || Rkey == 'i' || Rkey == 9) 
               {
                 if (Rt1 > 0) Rt1--;
                 else (Rt1 = 4);
                 Rpaint(Rt1,1,Rys-4); 
               }
               if (Rkey == 10 || Rkey == 'x') 
               {
                 wrefresh(RwinMsg);
                 delwin(RwinMsg);
                 RwinRedrawWithData();
                 RdontResizeWindow = 0;
                 return(Rt1);
               }
             }
             break;
    case 30: Rys = 5; Rxs = strlen(Rm49)+6; 
             RwinMsg = newwin(Rys,Rxs,Ry/2-Rys/2,Rx/2-Rxs/2);
             keypad(RwinMsg, TRUE);
             box(RwinMsg,0,0);
             Rii = Rxs/2-strlen(Rm49)/2; 
               mvwprintw(RwinMsg, 2, Rii, "%s", Rm49);
             wrefresh(RwinMsg);
             delwin(RwinMsg);
             break;
    case 31: Rys = 21; Rxs = 72;
             RwinMsg = newwin(Rys,Rxs,Ry/2-Rys/2,Rx/2-Rxs/2);
             RwinMsg2 = newwin(Rys-4,Rxs-2,(Ry/2-Rys/2)+1,(Rx/2-Rxs/2)+1);
             keypad(RwinMsg, TRUE);
             box(RwinMsg,0,0);
             Rii = Rxs/2-strlen(Rm50)/2; 
               mvwprintw(RwinMsg2, 1, Rii, "%s", Rm50);
             Rt2 = strlen(Rmsg);
             Rms = Rmsg;
             Rym = 4; Rxm = 2;
             for (Rt1 = 0; Rt1 < Rt2; Rt1++) 
             {
               mvwprintw(RwinMsg2, Rym, Rxm++, "%c", Rms[Rt1]);
               if (Rxm == Rxs-2) 
               {
                 Rxm = 2;
                 Rym++;
               }
             }

             Rt2 = strlen(Rmsg2);
             Rms = Rmsg2;
             Rym = Rym+3; Rxm = 2;
             for (Rt1 = 0; Rt1 < Rt2; Rt1++) 
             {
               mvwprintw(RwinMsg2, Rym, Rxm++, "%c", Rms[Rt1]);
               if (Rxm == Rxs-2) 
               {
                 Rxm = 2;
                 Rym++;
               }
               if (Rym == Rys-5)
                 break;
             }

             wattron(RwinMsg, COLOR_PAIR(1)); 
               mvwprintw(RwinMsg, Rys-3, Rxs/2-3, "%s", Rm136); 
               wattroff(RwinMsg, COLOR_PAIR(1)); 
             wrefresh(RwinMsg);
             wrefresh(RwinMsg2);
             RpressEnter(RwinMsg);
             delwin(RwinMsg2);
             delwin(RwinMsg);
             break;
    case 32: Rys = 7; Rxs = 62;
             RwinMsg = newwin(Rys,Rxs,Ry/2-Rys/2,Rx/2-Rxs/2);
             box(RwinMsg,0,0);
             RmsgT1 = to_scr(Rmsg);
             Rii = Rxs/2-strlen(RmsgT1)/2; 
               mvwprintw(RwinMsg, 2, 1+Rii, "%s",RmsgT1);
             Rii = Rxs/2-strlen(Rm136)/2;
             wattron(RwinMsg, COLOR_PAIR(1)); 
             mvwprintw(RwinMsg, 4, 1+Rii, "%s", Rm136);
             wattroff(RwinMsg, COLOR_PAIR(1)); 
             wrefresh(RwinMsg);
             RactiveWindow = RwinMsg;
             RDBG("smbc : RshowMessage RactiveWindow = RwinMsg  4\n");
             nodelay(RwinMsg, 1);
             while (wgetch(RwinMsg) != 10) 
             {
               RtryDownloadUpload();
             };
             delwin(RwinMsg);
             break;
  }
  RwinRedrawWithData();
  RdontResizeWindow = 0;
  return(0);
}


void 
RwinRedrawWithData()
{
  RwinRedraw();
  RwriteMenuTxt(RleftFirst,0,RLLOCAL,RleftPos);
  RwriteMenuTxt(RrightFirst,RremoteLevel,RLREMOTE,RrightPos);
}

TTdownload *
RgetdownloadListNr(int Rnr)
{
  TTdownload *RdownloadListTmp = RdownloadList;
  while (Rnr-- > 0) 
    RdownloadListTmp = RdownloadListTmp->RdownloadList;
  return(RdownloadListTmp);
}

TTdownload *
RgetdownloadListLast()
{
  TTdownload *RdownloadListTmp = RdownloadList;
  if (RdownloadListTmp == NULL) 
    return(NULL);
  while (RdownloadListTmp->RdownloadList != NULL) 
    RdownloadListTmp = RdownloadListTmp->RdownloadList;
  return(RdownloadListTmp);
}

TTdownload *
RgetdownloadListFirst()
{
  TTdownload *RdownloadListTmp = RdownloadList;
  if (RdownloadListTmp == NULL) 
    return(NULL);
  while (RdownloadListTmp->RdownloadListP != NULL) 
    RdownloadListTmp = RdownloadListTmp->RdownloadListP;
  return(RdownloadListTmp);
}

int 
RgetdownloadListCount()
{
  int Rc = 1;
  TTdownload *RdownloadListTmp = RdownloadList;

#ifdef HAVE_DEBUG
  if (RdownloadList) {
    RDBG("smbc : RgetdownloadListCount RdownloadList->RdownloadList == "); RDBGi((int)RdownloadList->RdownloadList); RDBG("\n");
    RDBG("smbc : RgetdownloadListCount RdownloadList->RdownloadListP == "); RDBGi((int)RdownloadList->RdownloadListP); RDBG("\n");
  }
#endif /*HAVE_DEBUG */

  RDBG("smbc : RgetdownloadListCount 1\n");
  if (RdownloadListTmp == NULL) return(0);
  RDBG("smbc : RgetdownloadListCount 2\n");
  while (RdownloadListTmp->RdownloadList != NULL) 
  {
     RDBG("smbc : RgetdownloadListCount 3\n");
     RdownloadListTmp = RdownloadListTmp->RdownloadList;
     Rc++;
  }
  RDBG("smbc : RgetdownloadListCount 4\n");
  return(Rc);
}

int 
RmanageList()
{
  WINDOW *RwinList, 
         *RwinCol1, *RwinCol2, *RwinCol3, *RwinCol4, 
         *RwinCol5, *RwinCol6, *RwinCol7;
  int Rkey, Rsel, RmaxY, Rx6, Ri, RlFirst, RlSelect;
  TTdownload *RdownloadListTmp, *RdownloadListTmp2;
  int Rcut = 0;
  sighandler_t RpreviousAction;

  void 
  RpaintList(int Rfirst, int Rselect)
  {
    int Rlast, Ri;
    int Rk = -1;
    char *RtimeRemaing;
    char *RtimeDelay;
    char *RmsgT1, *RmsgT2, *RmsgT3, *RmsgT4, *RmsgT5;

    RdownloadListTmp = RgetdownloadListNr(Rfirst); 

    if ((Rfirst == 0) & (RgetdownloadListCount() <= RmaxY)) 
      Rlast = RgetdownloadListCount();
    else Rlast = Rfirst + RmaxY;
    for (Ri = Rfirst; Ri < Rlast; Ri++) 
    {
      mvwhline(RwinCol1, ++Rk, 0, 32, 1);
      mvwhline(RwinCol2, Rk, 0, 32, 1);
      mvwhline(RwinCol3, Rk, 0, 32, 5);
      mvwhline(RwinCol4, Rk, 0, 32, 5);
      mvwhline(RwinCol5, Rk, 0, 32, 3);
      mvwhline(RwinCol6, Rk, 0, 32, Rx6);
      mvwhline(RwinCol7, Rk, 0, 32, Rx-21-Rx6);
      if (Ri == Rselect) 
      {
          wattron(RwinCol1, COLOR_PAIR(1)); 
          wattron(RwinCol2, COLOR_PAIR(1)); 
          wattron(RwinCol3, COLOR_PAIR(1)); 
          wattron(RwinCol4, COLOR_PAIR(1)); 
          wattron(RwinCol5, COLOR_PAIR(1)); 
          wattron(RwinCol6, COLOR_PAIR(1)); 
          wattron(RwinCol7, COLOR_PAIR(1)); 
          mvwhline(RwinCol1, Rk, 0, 32, 1);
          mvwhline(RwinCol2, Rk, 0, 32, 1);
          mvwhline(RwinCol3, Rk, 0, 32, 5);
          mvwhline(RwinCol4, Rk, 0, 32, 5);
          mvwhline(RwinCol5, Rk, 0, 32, 3);
          mvwhline(RwinCol6, Rk, 0, 32, Rx6);
          mvwhline(RwinCol7, Rk, 0, 32, Rx-21-Rx6);
      }
      mvwprintw(RwinCol1, Rk, 0, "%c", RdownloadListTmp->active); 
      mvwprintw(RwinCol2, Rk, 0, "%c", RdownloadListTmp->upload); 
      mvwprintw(RwinCol3, Rk, 0, "%s", to_scr(RdownloadListTmp->sizeDisplayR)); 
      RDBG("smbc : RmanageList to_scr(RdownloadListTmp->sizeDisplayR) = ");
      RDBG(to_scr(RdownloadListTmp->sizeDisplayR)); RDBG("\n");
      mvwprintw(RwinCol4, Rk, 0, "%s", to_scr(RdownloadListTmp->sizeDisplayDownR)); 
      mvwprintw(RwinCol5, Rk, 0, "%s%%", to_scr(RdownloadListTmp->percent)); 
      mvwprintw(RwinCol6, Rk, 0, "%s", to_scr(RdownloadListTmp->filename));
      RreturnHumanDelayTime(&RtimeRemaing, RdownloadListTmp->nextRetry-time(NULL));
      RreturnHumanDelayTime(&RtimeDelay, RdownloadListTmp->delayRetry);
      if (RdownloadListTmp->upload == 'D') 
      {
        asprintf(&RmsgT1, to_scr(RtimeRemaing));
        asprintf(&RmsgT2, to_scr(RtimeDelay));
        asprintf(&RmsgT3, to_scr(RdownloadListTmp->pathR+4));
        asprintf(&RmsgT4, to_scr(RdownloadListTmp->pathL));
        asprintf(&RmsgT5, to_scr(RdownloadListTmp->groupnameR));
        mvwprintw(RwinCol7, Rk, 0, "%s | %s | %s | %s | %s", RmsgT1, RmsgT2, RmsgT3, RmsgT4, RmsgT5);
        free(RmsgT1); free(RmsgT2); free(RmsgT3); free(RmsgT4); free(RmsgT5);
      }
      else 
      {
        asprintf(&RmsgT1, to_scr(RtimeRemaing));
        asprintf(&RmsgT2, to_scr(RtimeDelay));
        asprintf(&RmsgT3, to_scr(RdownloadListTmp->pathR));
        asprintf(&RmsgT4, to_scr(RdownloadListTmp->pathL+4));
        asprintf(&RmsgT5, to_scr(RdownloadListTmp->groupnameR));
        mvwprintw(RwinCol7, Rk, 0, "%s | %s | %s | %s | %s", RmsgT1, RmsgT2, RmsgT3, RmsgT4, RmsgT5);
        free(RmsgT1); free(RmsgT2); free(RmsgT3); free(RmsgT4); free(RmsgT5);
      }
      free(RtimeRemaing);
      free(RtimeDelay);
      if (Ri == Rselect) 
      {
          wattroff(RwinCol1, COLOR_PAIR(1)); 
          wattroff(RwinCol2, COLOR_PAIR(1)); 
          wattroff(RwinCol3, COLOR_PAIR(1)); 
          wattroff(RwinCol4, COLOR_PAIR(1)); 
          wattroff(RwinCol5, COLOR_PAIR(1)); 
          wattroff(RwinCol6, COLOR_PAIR(1)); 
          wattroff(RwinCol7, COLOR_PAIR(1)); 
      }
      RdownloadListTmp = RdownloadListTmp->RdownloadList;
    }
    for (Ri = Rlast+1; Ri < Rfirst+RmaxY+1; Ri++) 
    {
      mvwhline(RwinCol1, ++Rk, 0, 32, 1);
      mvwhline(RwinCol2, Rk, 0, 32, 1);
      mvwhline(RwinCol3, Rk, 0, 32, 5);
      mvwhline(RwinCol4, Rk, 0, 32, 5);
      mvwhline(RwinCol5, Rk, 0, 32, 3);
      mvwhline(RwinCol6, Rk, 0, 32, Rx6);
      mvwhline(RwinCol7, Rk, 0, 32, Rx-21-Rx6);
    }
    wrefresh(RwinCol1);
    wrefresh(RwinCol2);
    wrefresh(RwinCol3);
    wrefresh(RwinCol4);
    wrefresh(RwinCol5);
    wrefresh(RwinCol6);
    wrefresh(RwinCol7);
  }

  void 
  RmanageListCreateWindow()
  {
    Rx6 = 0;
    RdownloadListTmp = RdownloadList;
    for (Ri = 0; Ri < RgetdownloadListCount(); Ri++) 
    {
      if (strlen(RdownloadListTmp->filename) > Rx6)
        Rx6 = strlen(RdownloadListTmp->filename);
      RdownloadListTmp = RdownloadListTmp->RdownloadList;
    }
    getmaxyx(RwinMain, RmaxY, Rsel);
    if (Rx6 > Rsel-18) 
      Rx6 = Rsel-18-10;
    if (Rcut)
      RstatusBar(26);
    else
      RstatusBar(25);
    RwinList = newwin(Ry-2, Rx, 1, 0);
    RwinCol1 = newwin(Ry-6, 1, 4, 1);
    RwinCol2 = newwin(Ry-6, 1, 4, 3);
    RwinCol3 = newwin(Ry-6, 5, 4, 5);
    RwinCol4 = newwin(Ry-6, 5, 4, 11);
    RwinCol5 = newwin(Ry-6, 3, 4, 17);
    RwinCol6 = newwin(Ry-6, Rx6, 4, 21);
    RwinCol7 = newwin(Ry-6, Rx-Rx6-23, 4, 22+Rx6);
    getmaxyx(RwinCol1, RmaxY, Rsel);
    Rsel = 0;
    mvwprintw(RwinList, 1,1, Rm52);
    mvwprintw(RwinList, 1,1+21+Rx6, Rm53);
    box(RwinList,0,0);
    mvwvline(RwinList, 1, 2, 0, Ry-4);
    mvwvline(RwinList, 1, 4, 0, Ry-4);
    mvwvline(RwinList, 1, 10, 0, Ry-4);
    mvwvline(RwinList, 1, 16, 0, Ry-4);
    mvwvline(RwinList, 1, 20, 0, Ry-4);
    mvwvline(RwinList, 1, 20+Rx6+1, 0, Ry-4);
    mvwhline(RwinList, 2, 1, 0, Rx-2);
    wrefresh(RwinList);
    keypad(RwinList, TRUE); 
    nodelay(RwinList, 0);
    RactiveWindow = RwinList;
    RDBG("smbc : RmanageList RactiveWindow = RwinList  2\n");
  }

  void 
  RdoWindowResizeDownloadList()
  {
    if (RdoResizeDownload) 
    {
      RdoResizeDownload = 0;
      RdoWindowResize();
      RmanageListCreateWindow();
      RpaintList(RlFirst,RlSelect);
    }
  }

  void 
  RsigAlarmManageWindow() 
  {
    RDBG("RmanageList : RsigAlarmManageWindow alarm\n");
    RdoWindowResizeDownloadList();
    RpaintList(RlFirst,RlSelect);
    alarm(RCalarm); 
  }

  RpreviousAction = signal(SIGALRM, RsigAlarmManageWindow);
  alarm(RCalarm); 

  RmanageListCreateWindow();
  RlFirst = 0; RlSelect = 0;
  RpaintList(RlFirst,RlSelect);
  while ((Rkey = mvwgetch(RwinList, 1,1))) 
  {
    if ((Rkey == ',') || (Rkey == 260)) 
    {
      RdownloadListTmp = RgetdownloadListNr(RlSelect);
      if (RdownloadListTmp->delayRetry > 0)
        RdownloadListTmp->delayRetry--;
    }
    if ((Rkey == '.') || (Rkey == 261)) 
    {
      RdownloadListTmp = RgetdownloadListNr(RlSelect);
      RdownloadListTmp->delayRetry++;
    }
    if ((Rkey == '<') || (Rkey == 68)) 
    {
      RdownloadListTmp = RgetdownloadListNr(RlSelect);
      if (RdownloadListTmp->delayRetry > 60)
        RdownloadListTmp->delayRetry = RdownloadListTmp->delayRetry-60;
      else
        RdownloadListTmp->delayRetry = 0;
    }
    if ((Rkey == '>') || (Rkey == 67)) 
    {
      RdownloadListTmp = RgetdownloadListNr(RlSelect);
      RdownloadListTmp->delayRetry = RdownloadListTmp->delayRetry+60;
    }

    if (Rkey == ';') 
    {
      RdownloadListTmp = RgetdownloadListFirst();
      while (RdownloadListTmp) 
      {
        if (RdownloadListTmp->delayRetry > 0)
          RdownloadListTmp->delayRetry--;
        RdownloadListTmp = RdownloadListTmp->RdownloadList;
      }
    }
    if (Rkey == '\'') 
    {
      RdownloadListTmp = RgetdownloadListFirst();
      while (RdownloadListTmp) 
      {
        RdownloadListTmp->delayRetry++;
        RdownloadListTmp = RdownloadListTmp->RdownloadList;
      }
    }
    if (Rkey == ':') 
    {
      RdownloadListTmp = RgetdownloadListFirst();
      while (RdownloadListTmp) 
      {
        if (RdownloadListTmp->delayRetry > 60)
          RdownloadListTmp->delayRetry = RdownloadListTmp->delayRetry-60;
        else
          RdownloadListTmp->delayRetry = 0;
        RdownloadListTmp = RdownloadListTmp->RdownloadList;
      }
    }
    if (Rkey == '\"')  
    {
      RdownloadListTmp = RgetdownloadListFirst();
      while (RdownloadListTmp) {
        RdownloadListTmp->delayRetry = RdownloadListTmp->delayRetry+60;
        RdownloadListTmp = RdownloadListTmp->RdownloadList;
      }
    }
    if (Rkey == '|') {
      RdownloadListTmp = RgetdownloadListNr(RlSelect);
      RdownloadListTmp2 = RgetdownloadListFirst();
      while (RdownloadListTmp2) 
      {
        RdownloadListTmp2->delayRetry = RdownloadListTmp->delayRetry;
        RdownloadListTmp2 = RdownloadListTmp2->RdownloadList;
      }
    }
    if (Rkey == 'n') 
    {
      RdownloadListTmp = RgetdownloadListNr(RlSelect);
      RdownloadListTmp->nextRetry = time(NULL);
    }
    if (Rkey == 'N') 
    {
      RdownloadListTmp = RgetdownloadListFirst();
      while (RdownloadListTmp) 
      {
        RdownloadListTmp->nextRetry = time(NULL);
        RdownloadListTmp = RdownloadListTmp->RdownloadList;
      }
    }

    if (Rkey == 32) 
    {
       RdownloadListTmp = RgetdownloadListNr(RlSelect);
       if(RdownloadListTmp->active == 'X') RdownloadListTmp->active = ' ';
       else RdownloadListTmp->active = 'X';
       Rkey = KEY_DOWN;
    }
    if (Rkey == 'd' || Rkey == KEY_DC) 
    {
       RdownloadListTmp = RgetdownloadListNr(RlSelect);
       RdownloadListTmp->active = 'D';
       Rkey = KEY_DOWN;
    }
    if (Rkey == 4) 
    {             // CTRL-d
       RdownloadListTmp = RgetdownloadListNr(RlSelect+1);
       RdownloadListTmp2 = RgetdownloadListFirst();
       while (RdownloadListTmp2 != NULL) 
       {
         if (RstrCmp(RdownloadListTmp2->pathR,RdownloadListTmp->pathR) == 1)  
            RdownloadListTmp2->active = 'D';
         RdownloadListTmp2 = RdownloadListTmp2->RdownloadList;
       }
       RpaintList(RlFirst,RlSelect);
    }
    if (Rkey == 6) 
    {             // CTRL-f
       RdownloadListTmp = RgetdownloadListNr(RlSelect+1);
       RdownloadListTmp2 = RgetdownloadListFirst();
       while (RdownloadListTmp2 != NULL) 
       {
         RdownloadListTmp2->active = 'D';
         RdownloadListTmp2 = RdownloadListTmp2->RdownloadList;
       }
       RpaintList(RlFirst,RlSelect);
    }
    if (Rkey == 'u') 
    {
       RdownloadListTmp = RgetdownloadListNr(RlSelect);
       RdownloadListTmp->active = 'X';
       Rkey = KEY_DOWN;
    }
    if (Rkey == KEY_DOWN || Rkey == 'o') 
    {
       RdownloadListTmp = RgetdownloadListNr(RlSelect);
       if ((Rcut) && (RdownloadListTmp->RdownloadList)) 
       {
         RdownloadListTmp2 = RdownloadListTmp;
         if (RdownloadListTmp->RdownloadListP)
           RdownloadListTmp->RdownloadListP->RdownloadList = RdownloadListTmp->RdownloadList;
         else
           RdownloadList = RdownloadListTmp->RdownloadList;
         RdownloadListTmp->RdownloadList->RdownloadListP = RdownloadListTmp->RdownloadListP;
 
         RdownloadListTmp = RdownloadListTmp->RdownloadList;
 
         RdownloadListTmp2->RdownloadListP = RdownloadListTmp;
         RdownloadListTmp2->RdownloadList = RdownloadListTmp->RdownloadList;
         
         if (RdownloadListTmp->RdownloadList)
           RdownloadListTmp->RdownloadList->RdownloadListP = RdownloadListTmp2;
         RdownloadListTmp->RdownloadList = RdownloadListTmp2;
       }
      if ((RlSelect+1 == RlFirst+RmaxY) & (RlFirst+RmaxY < RgetdownloadListCount())) 
      {
        RlFirst++; 
        RlSelect++;
      }
      else 
        if (RlSelect < RgetdownloadListCount()-1) 
          RlSelect++;
      RpaintList(RlFirst,RlSelect);
    }
    if (Rkey == KEY_UP || Rkey == 'p') 
    {
       RdownloadListTmp = RgetdownloadListNr(RlSelect);
       if ((Rcut) && (RdownloadListTmp->RdownloadListP)) 
       {
         RdownloadListTmp2 = RdownloadListTmp;
         if (RdownloadListTmp->RdownloadList)
           RdownloadListTmp->RdownloadList->RdownloadListP = RdownloadListTmp->RdownloadListP;
         RdownloadListTmp->RdownloadListP->RdownloadList = RdownloadListTmp->RdownloadList;
 
         RdownloadListTmp = RdownloadListTmp->RdownloadListP;
 
         RdownloadListTmp2->RdownloadList = RdownloadListTmp;
         RdownloadListTmp2->RdownloadListP = RdownloadListTmp->RdownloadListP;
         
         if (RdownloadListTmp->RdownloadListP)
           RdownloadListTmp->RdownloadListP->RdownloadList = RdownloadListTmp2;
         else
           RdownloadList = RdownloadListTmp2;
         RdownloadListTmp->RdownloadListP = RdownloadListTmp2;
       }
      if (RlSelect > 0) 
      {
         if ((RlFirst > 0) && (RlSelect == RlFirst)) { RlFirst--; RlSelect--; } 
         else RlSelect--;
         RpaintList(RlFirst,RlSelect);
      }
    }
    if (Rkey == KEY_NPAGE || Rkey == 'k') 
    {
      if (RlFirst+RmaxY <= RgetdownloadListCount()) 
      {
        if (RlSelect+1 == RlFirst+RmaxY) 
        {
           if (RlSelect+RmaxY < RgetdownloadListCount()) 
           {
              RlFirst = RlSelect;
              RlSelect = RlFirst+RmaxY-1;
            }
            else 
            {
              RlFirst = RgetdownloadListCount()-RmaxY;
              RlSelect = RgetdownloadListCount()-1;
            }
        }
        else 
        {
           if (RlSelect+RmaxY <= RgetdownloadListCount()) 
             RlSelect = RlFirst+RmaxY-1;
           else
             RlSelect = RgetdownloadListCount()-1;
        }
      }
      RpaintList(RlFirst,RlSelect);
    }
    if (Rkey == KEY_PPAGE || Rkey == 'l') 
    {
      if (RlSelect > 1) 
      {
        if (RlFirst == RlSelect) 
        {
          if (RlFirst - RmaxY < 1) 
          {
            RlFirst = 1;
            RlSelect = 1;
          }
          else 
          {
            RlFirst = RlFirst - RmaxY + 1;
            RlSelect = RlFirst;
          }
        }
        else RlSelect = RlFirst;
        RpaintList(RlFirst,RlSelect);
      }
    }
    if (Rkey == 'm') 
    {
      if (Rcut) 
      {
        Rcut = 0;
        RstatusBar(25);
      }
      else 
      {
        Rcut = 1;
        RstatusBar(26);
      }
    }
    if (Rkey == 'q') 
    {
       if (RdownloadListAct != NULL)
         if (RdownloadListAct->active == ' ') 
         {
           Rsmbc_close(RdownloadHandleR);
           close(RdownloadHandleL);
           RdownloadHandleL = -1;
           RdownloadHandleR = -1;
           RdownloadListAct = NULL;
         }
       Ri = 1;
       while (Ri) 
       {
         Ri = 0;
         RdownloadListTmp = RdownloadList;
         if (RgetdownloadListCount() == 1 ) 
         {
           if (RdownloadListTmp->active == 'D') 
           {
             free(RdownloadListTmp);
             RdownloadList = NULL;
             Rsmbc_close(RdownloadHandleR);
             close(RdownloadHandleL);
             RdownloadHandleL = -1;
             RdownloadHandleR = -1;
           }
         }
         else 
           while ((RdownloadListTmp != NULL) & (Ri == 0)) 
           {
             if (RdownloadListTmp->active == 'D') 
             {
               if (RdownloadListTmp == RdownloadListAct) 
               {
                 Rsmbc_close(RdownloadHandleR);
                 close(RdownloadHandleL);
                 RdownloadHandleL = -1;
                 RdownloadHandleR = -1;
               }
               if (RdownloadListTmp->RdownloadListP != NULL) 
                 RdownloadListTmp->RdownloadListP->RdownloadList = RdownloadListTmp->RdownloadList;
               if (RdownloadListTmp->RdownloadList != NULL)
                 RdownloadListTmp->RdownloadList->RdownloadListP = RdownloadListTmp->RdownloadListP;
               if (RdownloadList == RdownloadListTmp) 
               {
                 if (RdownloadList->RdownloadList == NULL)
                   RdownloadList = RdownloadListTmp->RdownloadListP;  
                 else 
                   RdownloadList = RdownloadListTmp->RdownloadList;  
               }
               free(RdownloadListTmp);
               RdownloadList = RgetdownloadListFirst();
               Ri = 1;
             }
             RdownloadListTmp = RdownloadListTmp->RdownloadList;
           }
       }
       delwin(RwinList);
       delwin(RwinCol1);
       delwin(RwinCol3);
       delwin(RwinCol4);
       delwin(RwinCol5);
       delwin(RwinCol6);
       delwin(RwinCol7);
       RwinRedrawWithData();
       signal(SIGALRM, RpreviousAction);
       alarm(RCalarm);
       return (0);
    }
    Rkey = 0; 
  }
  signal(SIGALRM, RpreviousAction);
  alarm(RCalarm);
  return(0);
}

void 
Rget_auth_data(const char *srv, const char *shr, char *wg, int wglen, char *un, int unlen, char *pw, int pwlen)
{
  strcpy(wg, Ragroup);
  strcpy(un, Rusername);
  strcpy(pw, Rpassword);
}

int 
RfreeMasterList()
{
  int i;

  for (i=0;i<RgroupsCount;i++) 
  {
    realloc(Rgroups[i], sizeof(TTgroups));
  }
  RgroupsCount = -1;
  return (RgroupsCount);
}

int 
RgetMasterList()
{
  int Rfd;
  struct smbc_dirent *Rdirent;

  RfreeMasterList();
  RgroupsCount = -1;
  if ((Rfd = Rsmbc_opendir("smb://")) < 0) 
    return(-1);
  while((Rdirent = Rsmbc_readdir(Rfd))) 
  {
    if (Rdirent->smbc_type == SMBC_WORKGROUP) 
    { 
      Rgroups[++RgroupsCount] = Rmalloc(sizeof(TTgroups));
      strcpy(Rgroups[RgroupsCount]->groupname, Rdirent->name);
      Rgroups[RgroupsCount]->mastername[0] = 0;
      Rgroups[RgroupsCount]->masterip[0] = 0;
    }
  }
  Rsmbc_closedir(Rfd);
  RgroupsCount++;
  return(RgroupsCount);
}

int 
RfreeHostsList()
{
  int i;

  for (i=0;i<RhostsCount;i++) 
  {
    realloc(Rhosts[i], sizeof(TThosts));
  }
  RhostsCount = -1;
  return (RhostsCount);
}

int 
RgetHostsFromGroup(char *group)
{
  int Rfd;
  struct smbc_dirent *Rdirent;
  char *Rstr;

  RfreeHostsList();
  RhostsCount = -1;
  asprintf(&Rstr, "smb://%s/", group);
  if ((Rfd = Rsmbc_opendir(Rstr)) > 0) 
  {
   while((Rdirent = Rsmbc_readdir(Rfd))) 
   {
    if (Rdirent->smbc_type == SMBC_SERVER) 
    { 
      Rhosts[++RhostsCount] = Rmalloc(sizeof(TThosts));
      strcpy(Rhosts[RhostsCount]->hostname, Rdirent->name);
      strcpy(Rhosts[RhostsCount]->comment, Rdirent->comment);
    }
   }
  }
  Rsmbc_closedir(Rfd);
  free(Rstr);
  RhostsCount++;
  return(RhostsCount);
}

int 
RfreeSharesList()
{
  int i;

  for (i=0;i<RsharesCount;i++) 
  {
    realloc(Rshares[i], sizeof(TTshares));
  }
  RsharesCount = -1;
  return(RsharesCount);
}

int 
RgetSharesFromHost(char *host)
{
  int Rfd;
  struct smbc_dirent *Rdirent;
  char *Rstr;

  RfreeSharesList();
  RsharesCount = -1;
  asprintf(&Rstr, "smb://%s/", host);
  if ((Rfd = Rsmbc_opendir(Rstr)) > 0) 
  {
   while((Rdirent = Rsmbc_readdir(Rfd))) 
   {
    if (Rdirent->smbc_type == SMBC_FILE_SHARE) 
     if (strlen(Rdirent->name) > 0) 
       if (Rdirent->name[strlen(Rdirent->name)-1] != '$') 
       { 
         Rshares[++RsharesCount] = Rmalloc(sizeof(TTshares));
         strcpy(Rshares[RsharesCount]->sharename, Rdirent->name);
         strcpy(Rshares[RsharesCount]->comment, Rdirent->comment);
       }
   }
   Rsmbc_closedir(Rfd);
   RsharesCount++;
  }
  else 
  {
    RshowMessage(27, Rstr, "", NULL);
    RsharesCount = -1;
  }  
 free(Rstr);
 return(RsharesCount);
}

/*   Rstr - value in bytes
 *
 *   function return 
 *      Rdst[0..RstrMaxLen-2] = "123.3M"
 *      Rdst[RstrMaxLen-1] = 0;
 *
 *      Rsrc = 200  Rdst 2  = "2"
 *      Rsrc = 200  Rdst 3  = "20"
 *      Rsrc = 200  Rdst 4  = "200"
 *      Rsrc = 200  Rdst 5  = "200M"
 *      Rsrc = 200  Rdst 10 = "     200M"
 **********************************************
 *   prefer RstrMaxLen >= 5
*/
int 
RgetHumanSize(char *Rdst, int RstrMaxLen, unsigned int Rsrc)
{
  int Rjl;
  int RiT;
  int Rs = 0;
  char Rje = 'B';
  char *RdstTmp, *RstrTmp, *Rj;
  char *Rf, *Rl, *RstrT;
  int Rspc = 0;

  if (RstrMaxLen <= 0)
    return(-1);

  RdstTmp = Rmalloc(RstrMaxLen);
  Rf = Rmalloc(RstrMaxLen);
  Rl = Rmalloc(RstrMaxLen);

  RDBG("smbc : getHumanSize Rsrc == "); RDBGi(Rsrc); RDBG("\n");
  if ((Rsrc/1024) > 0) 
  { 
    Rs = (Rsrc % 1024); 
    Rsrc = Rsrc/1024; 
    Rje = 'K'; 
  }
  if ((Rsrc/1024) > 0) 
  { 
    Rs = (Rsrc % 1024); 
    Rsrc = Rsrc/1024; 
    Rje = 'M'; 
  }
  if ((Rsrc/1024) > 0) 
  { 
    Rs = (Rsrc % 1024); 
    Rsrc = Rsrc/1024; 
    Rje = 'G'; 
  }
  if ((Rsrc/1024) > 0) 
  { 
    Rs = (Rsrc % 1024); 
    Rsrc = Rsrc/1024; 
    Rje = 'T'; 
  }
  itoa(Rf, RstrMaxLen, Rsrc);

  if (Rs > 0)
  {
    itoa(Rl, RstrMaxLen, Rs);
    asprintf(&Rj, "%s%c%s0", Rf, '.', Rl);
  }
  else
  {
    if (Rje == 'B')
      asprintf(&Rj, "%s", Rf);
    else
      asprintf(&Rj, "%s.00", Rf);
  }
  Rjl = strlen(Rj);
  RDBG("smbc : RgetHumanSize Rj = "); RDBG(Rj); RDBG("\n");

  memset(RdstTmp, ' ', RstrMaxLen);
  RdstTmp[RstrMaxLen-1] = 0;

  RDBG("smbc : getHumanSize Rf == "); RDBG(Rf); RDBG("\n");
  RDBG("smbc : getHumanSize Rl == "); RDBG(Rl); RDBG("\n");
  RDBG("smbc : getHumanSize Rj == "); RDBG(Rj); RDBG("\n");
  RDBG("smbc : getHumanSize RdstTmp == "); RDBG(RdstTmp); RDBG("\n");

  /*
   * Rjl+1      - string(Rjl)+1(\0)
   * RstrMaxLen - is with \0
   */
  RiT = Rjl+1-RstrMaxLen;
  // if < must add spaces at the begin on the return string
  if (RiT < 0)
  {
    memcpy(RdstTmp+abs(RiT), Rj, Rjl);
    Rspc = 1;
  }
  else
    // if = return identical string
    if (RiT == 0)
      memcpy(RdstTmp, Rj, Rjl);
    else
      // if > return truncate string
      memcpy(RdstTmp, Rj, RstrMaxLen-1);
  
  RDBG("smbc : getHumanSize RdstTmp == "); RDBG(RdstTmp); RDBG("\n");

  RstrT = index(RdstTmp, '.');
  if (RstrT)
     RiT = strlen(RstrT);
  else
     RiT = 0;
  if (RiT > 0)
  {
    if (RiT == 2)
    {
      RdstTmp[RstrMaxLen-3] = Rje;
      RdstTmp[RstrMaxLen-2] = 0;
      asprintf(&RstrTmp, " %s", RdstTmp);
      memcpy(RdstTmp, RstrTmp, strlen(RstrTmp)+1);
      free(RstrTmp);
    }
    else
      RdstTmp[RstrMaxLen-2] = Rje;
  }
  else
    if (Rspc)
    {
      asprintf(&RstrTmp, "%s%c", RdstTmp+1, Rje);
      memcpy(RdstTmp, RstrTmp, RstrMaxLen);
      free(RstrTmp);
    }
  memcpy(Rdst, RdstTmp, RstrMaxLen);

  free(Rf);
  free(Rl);
  free(Rj);
  free(RdstTmp);
  return(1);
}

int 
RfreeFilesList()
{
  int i;

  for (i=0;i<RfilesCount;i++) 
    free(Rfiles[i]);
  RfilesCount = -1;
  return (RfilesCount);
}

int 
RgetFileFromDirR(char *dir)
{
  int dirhandle, filehandle;
  struct smbc_dirent *Rdirent;
  char *Rfn;
  struct stat remotestat;
  int Rsize;

  RfreeFilesList();
  dirhandle = Rsmbc_opendir(dir);
  RDBG("smbc : RgetFileFromDirR dirhandle = "); RDBGi(dirhandle); RDBG("\n");
  if(dirhandle < 1) 
    return -1;
  RfilesCount = 0;
  while((Rdirent = Rsmbc_readdir(dirhandle))) 
  {
    if (strcmp(Rdirent->name,".") && strcmp(Rdirent->name,"..")) 
    {
      Rfiles[RfilesCount] = Rmalloc(sizeof(TTfiles)); 
      strcpy(Rfiles[RfilesCount]->filename, Rdirent->name);

      asprintf(&Rfn, "%s%s", dir, Rdirent->name);
      filehandle = Rsmbc_open(Rfn, O_RDONLY, 0755);
      if (Rsmbc_fstat(filehandle, &remotestat) < 0) 
      {
        Rsize = 0;
        Rfiles[RfilesCount]->type = RTDIR;
        RgetHumanSize(Rfiles[RfilesCount]->sizeShow, TfilesSizeShowLen, 0);
      }
      else 
      {
        Rsize = remotestat.st_size;
        Rfiles[RfilesCount]->type = RTFILE;
        RgetHumanSize(Rfiles[RfilesCount]->sizeShow, TfilesSizeShowLen, Rsize);
      }
      Rfiles[RfilesCount]->size = Rsize;
      Rsmbc_close(filehandle);
      free(Rfn);
      RfilesCount++;
    }
  }
  Rsmbc_closedir(dirhandle);
  return(RfilesCount);
}

 
int 
RgetFileFromDirL(char *dir)
{
  DIR *dirhandle;
  struct dirent *Rdirent;
  char *Rfn;
  struct stat localstat;
  int Rsize;
  char *RstrT1;

  RfreeFilesList();
  dirhandle = opendir(to_sys(dir));
  if(dirhandle == NULL) 
  { 
    RshowMessage(0,dir,"",NULL);
    return -1;
  }
  RfilesCountL = 0;
  while((Rdirent =  readdir(dirhandle))) 
  {
    RstrT1 = from_sys(Rdirent->d_name);
    if (strcmp(RstrT1, ".") && strcmp(RstrT1, "..")) 
    {
      asprintf(&Rfn, "%s%s", dir, RstrT1);
      stat(to_sys(Rfn), &localstat);
      free(Rfn);

      RfilesL[RfilesCountL] = Rmalloc(sizeof(TTfiles)); 
      strcpy(RfilesL[RfilesCountL]->filename, RstrT1);
      RgetHumanSize(RfilesL[RfilesCountL]->sizeShow, TfilesSizeShowLen, localstat.st_size);
      RfilesL[RfilesCountL]->size = localstat.st_size;
      if (localstat.st_mode & S_IFDIR) 
      {
         Rsize = 0;
         RfilesL[RfilesCountL]->type = RTDIR;
      }
      else 
      {
        Rsize = Rdirent->d_reclen;
        RfilesL[RfilesCountL]->type = RTFILE;
      }
      RfilesCountL++;
    }
  }
  closedir(dirhandle);
  return RfilesCountL;
}

/*
 * function display Rstr in to status bar
 * Rstr must be in to_scr char code
*/

void 
RstatusBarStr(char *Rstr, int Rnr)
{
  RDBG("smbc : RstatusBarStr start\n");
  asprintf(&RstatusBarStrP, "%s%s", Rnr == 1?Rm54:"", Rstr);
  if (strlen(RstatusBarStrP) > Rx) 
    RstatusBarStrP[Rx-1] = 0;
  RstatusBar(100);
  free(RstatusBarStrP);
  RDBG("smbc : RstatusBarStr end\n");
}

void 
RstatusBar(int Rnr)
{
  mvwhline(RwinStatus, 0, 0, ' ', Rx);
  switch(Rnr) {
    case -1: break;
    case 0: mvwprintw(RwinStatus,0,0, Rm60); break;
    case 2: mvwprintw(RwinStatus,0,0, Rm61); break;
    case 3: mvwprintw(RwinStatus,0,0, Rm62); break;
    case 4: mvwprintw(RwinStatus,0,0, Rm63); break;
    case 5: mvwprintw(RwinStatus,0,0, Rm64); break;
    case 6: mvwprintw(RwinStatus,0,0, Rm65); break;
    case 8: mvwprintw(RwinStatus,0,0, Rm67); break;
    case 9: mvwprintw(RwinStatus,0,0, Rm68, Rselected?Rright:Rleft); break;
    case 10: mvwprintw(RwinStatus,0,0, Rm69, Rselected?Rright:Rleft); break;
    case 11: mvwprintw(RwinStatus,0,0, Rm70, Rselected?Rright:Rleft); break;
    case 12: mvwprintw(RwinStatus,0,0, Rm71, Rselected?Rright:Rleft); break;
    case 13: mvwprintw(RwinStatus,0,0, Rm72, Rselected?Rright:Rleft); break;
    case 14: mvwprintw(RwinStatus,0,0, Rm73, Rselected?Rright:Rleft); break;
    case 15: mvwprintw(RwinStatus,0,0, Rm74, Rselected?Rright:Rleft); break;
    case 16: mvwprintw(RwinStatus,0,0, Rm75, Rselected?Rfrom:Rto); break;
    case 17: mvwprintw(RwinStatus,0,0, Rm76, Rselected?Rfrom:Rto); break;
    case 18: mvwprintw(RwinStatus,0,0, Rm77); break;
    case 19: mvwprintw(RwinStatus,0,0, Rm78); break;
    case 20: mvwprintw(RwinStatus,0,0, Rm79); break;
    case 21: mvwprintw(RwinStatus,0,0, Rm80); break;
    case 22: mvwprintw(RwinStatus,0,0, Rm81); break;
    case 23: mvwprintw(RwinStatus,0,0, Rm82); break;
    case 24: mvwprintw(RwinStatus,0,0, Rm83); break;
    case 25: mvwprintw(RwinStatus,0,0, Rm84); break;
    case 26: mvwprintw(RwinStatus,0,0, Rm85); break;
    case 100: mvwprintw(RwinStatus,0,0, RstatusBarStrP); break;
  }
  wrefresh(RwinStatus);
}

void 
RwinRedraw()
{
  box(RwinLeft,0,0);
  box(RwinRight,0,0);
  mvwhline(RwinLeftTop, 0, 0, 0, RxHalf-2);
  mvwhline(RwinRightTop, 0, 0, 0, RxHalf-2);
  mvwprintw(RwinHead,0,0,"Samba Commander %s", VERSION);
  mvwprintw(RwinHead,0,Rx-strlen(Rm108), Rm108);
  mvwhline(RwinLeft, 2, 1, 0, RxHalf-2);
  mvwhline(RwinLeft, 2, 1, 0, RxHalf-2);
  mvwvline(RwinLeftList, 0, 1, 0, Ry-6);
  mvwvline(RwinLeftList, 0, RxHalf-8, 0, Ry-6);
  mvwhline(RwinRight, 2, 1, 0, RxHalf-2+Rdx);
  mvwvline(RwinRightList, 0, 1, 0, Ry-6);
  mvwvline(RwinRightList, 0, RxHalf-8+Rdx, 0, Ry-6);
  mvwvline(RwinLeftHead, 0, 1, 0, 1);
  mvwvline(RwinLeftHead, 0, RxHalf-8, 0, 1);
  mvwvline(RwinRightHead, 0, 1, 0, 1);
  mvwvline(RwinRightHead, 0, RxHalf-8+Rdx, 0, 1);
  mvwprintw(RwinLeftTop,0,0,"/");
  mvwprintw(RwinRightTop,0,0,"//");
  mvwprintw(RwinLeftHeadCol1,0,0, Rm123);
  mvwprintw(RwinLeftHeadCol2,0,0, Rm121);
  mvwprintw(RwinLeftHeadCol3,0,0, Rm125);
  mvwprintw(RwinRightHeadCol1,0,0, Rm123);
  mvwprintw(RwinRightHeadCol2,0,0, Rm124);
  mvwprintw(RwinRightHeadCol3,0,0, Rm125);
  wrefresh(RwinMain);
  wrefresh(RwinLeft);
  wrefresh(RwinRight);
  wrefresh(RwinHead);
  wrefresh(RwinLeftHead);
  wrefresh(RwinRightHead);
  wrefresh(RwinLeftList);
  wrefresh(RwinRightList);
  wrefresh(RwinLeftTop);
  wrefresh(RwinRightTop);
  wrefresh(RwinLeftCol1);
  wrefresh(RwinLeftCol2);
  wrefresh(RwinLeftCol3);
  wrefresh(RwinRightCol1);
  wrefresh(RwinRightCol2);
  wrefresh(RwinRightCol3);
  wrefresh(RwinLeftHeadCol1);
  wrefresh(RwinLeftHeadCol2);
  wrefresh(RwinLeftHeadCol3);
  wrefresh(RwinRightHeadCol1);
  wrefresh(RwinRightHeadCol2);
  wrefresh(RwinRightHeadCol3);
  RstatusBar(0);
}

void 
RwriteMenu(int Rredraw)
{
  int Rnr;

  if (RwinMain) delwin(RwinMain);
  if (RwinLeft) delwin(RwinLeft);
  if (RwinRight) delwin(RwinRight);
  if (RwinHead) delwin(RwinHead);
  if (RwinStatus) delwin(RwinStatus);
  if (RwinLeftHead) delwin(RwinLeftHead);
  if (RwinLeftList) delwin(RwinLeftList);
  if (RwinRightHead) delwin(RwinRightHead);
  if (RwinRightList) delwin(RwinRightList);
  if (RwinLeftCol1) delwin(RwinLeftCol1);
  if (RwinLeftCol2) delwin(RwinLeftCol2);
  if (RwinLeftCol3) delwin(RwinLeftCol3);
  if (RwinRightCol1) delwin(RwinRightCol1);
  if (RwinRightCol2) delwin(RwinRightCol2);
  if (RwinRightCol3) delwin(RwinRightCol3);
  if (RwinLeftHeadCol1) delwin(RwinLeftHeadCol1);
  if (RwinLeftHeadCol2) delwin(RwinLeftHeadCol2);
  if (RwinLeftHeadCol3) delwin(RwinLeftHeadCol3);
  if (RwinRightHeadCol1) delwin(RwinRightHeadCol1);
  if (RwinRightHeadCol2) delwin(RwinRightHeadCol2);
  if (RwinRightHeadCol3) delwin(RwinRightHeadCol3);
  endwin();
  initscr();

  start_color();
  init_pair(1, COLOR_BLACK, COLOR_CYAN);
  init_pair(2, COLOR_BLACK, COLOR_YELLOW);
  init_pair(3, COLOR_BLACK, COLOR_GREEN);
  init_pair(9, COLOR_BLACK, COLOR_GREEN);

  for (Rnr = 0; Rnr < 3; Rnr++) 
  {
    init_color(Rcolor[Rnr].realnumber, Rcolor[Rnr].red, Rcolor[Rnr].green, Rcolor[Rnr].blue);
    init_pair(10+Rnr, Rcolor[Rnr].realnumber,COLOR_BLACK);
  }

  curs_set(0);
  noecho();
  start_color();
  RwinMain = newwin(0,0,0,0); 
  getmaxyx(RwinMain, Ry, Rx);
  RxHalf = Rx/2;
  if ((RxHalf * 2) != Rx) 
    Rdx = 1;
  else 
    Rdx = 0;
  RwinLeft = newwin(Ry-2,RxHalf,1,0); 
  RwinRight = newwin(Ry-2,RxHalf+Rdx,1,RxHalf);
  RwinHead = newwin(1,Rx,0,0);
  RwinStatus = newwin(1,Rx,Ry-1,0);
  RwinLeftHead = newwin(1,RxHalf-2,2,1);
  RwinRightHead = newwin(1,RxHalf-2+Rdx,2,RxHalf+1);
  RwinLeftList = newwin(Ry-6,RxHalf-2,4,1);
  RwinRightList = newwin(Ry-6,RxHalf-2+Rdx,4,RxHalf+1);
  RwinLeftTop = newwin(1,RxHalf-2,1,1);
  RwinRightTop = newwin(1,RxHalf-2,1,RxHalf+1);
  RwinLeftHeadCol1 = newwin(1,1,2,1);
  RwinLeftHeadCol2 = newwin(1,RxHalf-10,2,3);
  RwinLeftHeadCol3 = newwin(1,5,2,RxHalf-6);
  RwinLeftCol1 = newwin(Ry-6,1,4,1);
  RwinLeftCol2 = newwin(Ry-6,RxHalf-10,4,3);
  RwinLeftCol3 = newwin(Ry-6,5,4,RxHalf-6);
  RwinRightHeadCol1 = newwin(1,1,2,RxHalf+1);
  RwinRightHeadCol2 = newwin(1,RxHalf-10+Rdx,2,RxHalf+3);
  RwinRightHeadCol3 = newwin(1,5,2,Rx-6);
  RwinRightCol1 = newwin(Ry-6,1,4,RxHalf+1);
  RwinRightCol2 = newwin(Ry-6,RxHalf-10+Rdx,4,RxHalf+3);
  RwinRightCol3 = newwin(Ry-6,5,4,Rx-6);
  if (Rredraw) RwinRedraw();
}

void 
RsortList(RLTYPE Rcol)
{
  TTlist *Rtlist;
  int Rr, Ri;
  char *Ridx1, *Ridx2;

  char RgetVar(char *Rstr1, char *Rstr2, int Rsize1, int Rsize2, int RsortMethodI)
  {
    int Rti;
    char Rc1, Rc2;
    int Rii;

    switch (RsortMethodI) 
    {
     case 1:
       Rii = strlen(Rstr1);
       if (Rii > strlen(Rstr2)) 
         Rii = strlen(Rstr2);
       for (Rti = 0; Rti < Rii; Rti++) 
       {
         Rc1 = tolower(Rstr1[Rti]);
         Rc2 = tolower(Rstr2[Rti]);
         if (Rc1 > Rc2) 
           return(Rselected?(RsortReverseR?0:1):(RsortReverseL?0:1));
         if (Rc1 < Rc2) 
           return(Rselected?(RsortReverseR?1:0):(RsortReverseL?1:0));
       }
       return(Rselected?(RsortReverseR?1:0):(RsortReverseL?1:0));
     case 2:
       Ridx1 = rindex(Rstr1, '.');
       Ridx2 = rindex(Rstr2, '.');

       if (Ridx1 == NULL) 
         return(Rselected?(RsortReverseR?1:0):(RsortReverseL?1:0));
       if (Ridx2 == NULL) 
         return(Rselected?(RsortReverseR?0:1):(RsortReverseL?0:1));

       Rii = strlen(Ridx1);
       if (Rii > strlen(Ridx2)) 
         Rii = strlen(Ridx2);
       for (Rti = 0; Rti < Rii; Rti++) 
       {
         Rc1 = tolower(Ridx1[Rti]);
         Rc2 = tolower(Ridx2[Rti]);
         if (Rc1 > Rc2) 
           return(Rselected?(RsortReverseR?0:1):(RsortReverseL?0:1));
         if (Rc1 < Rc2) 
           return(Rselected?(RsortReverseR?1:0):(RsortReverseL?1:0));
       }
       return(Rselected?(RsortReverseR?1:0):(RsortReverseL?1:0));
     case 3:
       if (Rsize1 > Rsize2) 
         return(Rselected?(RsortReverseR?1:0):(RsortReverseL?1:0));
       else 
         return(Rselected?(RsortReverseR?0:1):(RsortReverseL?0:1));
    }
    return(-1);
  }

  void 
  RrecSortLeft(int Rfirst, int Rlast)
  {
    TTlist *Rtlist;
    int Ri, Rii;

    for (Ri = Rfirst; Ri < Rlast; Ri++)
      for (Rii = Ri; Rii < Rlast; Rii++)
        if (RgetVar(RlistLeft[Ri]->col2, RlistLeft[Rii]->col2, RlistLeft[Ri]->size, RlistLeft[Rii]->size, RsortMethodL)) 
        {
          Rtlist = RlistLeft[Ri];
          RlistLeft[Ri] = RlistLeft[Rii];
          RlistLeft[Rii] = Rtlist;
        }
  }

  void 
  RrecSortRight(int Rfirst, int Rlast)
  {
    TTlist *Rtlist;
    int Ri, Rii;

    for (Ri = Rfirst; Ri < Rlast; Ri++)
      for (Rii = Ri; Rii < Rlast; Rii++)
        if (RgetVar(RlistRight[Ri]->col2, RlistRight[Rii]->col2, RlistRight[Ri]->size, RlistRight[Rii]->size, RsortMethodR)) 
        {
          Rtlist = RlistRight[Ri];
          RlistRight[Ri] = RlistRight[Rii];
          RlistRight[Rii] = Rtlist;
        }
  }

  if (Rcol == RLREMOTE) {      // right
    RDBG("smbc: RsortList RLREMOTE start\n");
    if (RlistRightMax < 1) return;
//    if (RremoteLevel == 3)
     if (RgroupFilesDirectoriesR) {
      RDBG("smbc: RsortList 1\n");
      for (Rr = 1; Rr < RlistRightMax; Rr++) 
       for (Ri = Rr; Ri < RlistRightMax; Ri++) 
         if (RlistRight[Rr]->col1[0] == 'F' && RlistRight[Ri]->col1[0] == 'D') 
         {
           RDBG("smbc: RsortList 2\n");
           Rtlist = RlistRight[Rr];
           RlistRight[Rr] = RlistRight[Ri];
           RlistRight[Ri] = Rtlist;
         }
      Rr = 1; 
      RDBG("smbc: RsortList 3\n");
      if (RlistRightMax > Rr)
      while (RlistRight[Rr]->col1[0] == 'D') 
      {
        RDBG("smbc: RsortList 3.1\n");
        RDBG(RlistRight[Rr]->col1);
        RDBG("smbc: RsortList 3.2\n");
        if (Rr+1 <= RlistRightMax-1) Rr++;
        else break;
      }
      RDBG("smbc: RsortList 4\n");
      RrecSortRight(1, Rr); 
      RDBG("smbc: RsortList 5\n");
      RrecSortRight(Rr, RlistRightMax); 
      RDBG("smbc: RsortList 6\n");
    }
    else RrecSortRight(1, RlistRightMax);
    RDBG("smbc: RsortList RLREMOTE stop\n");
  }
  else {           // left
    RDBG("smbc: RsortList RLLOCAL start\n");
    if (RlistLeftMax < 2) return;
    if (RgroupFilesDirectoriesL) {
      for (Rr = 1; Rr < RlistLeftMax; Rr++) 
        for (Ri = Rr; Ri < RlistLeftMax; Ri++) 
          if (RlistLeft[Rr]->col1[0] == 'F' && RlistLeft[Ri]->col1[0] == 'D') 
          {
            Rtlist = RlistLeft[Rr];
            RlistLeft[Rr] = RlistLeft[Ri];
            RlistLeft[Ri] = Rtlist;
          }
      Rr = 1; 
      while (RlistLeft[Rr]->col1[0] == 'D') 
        if (Rr+1 <= RlistLeftMax-1) 
          Rr++;
        else 
          break;
      RrecSortLeft(1, Rr); 
      RrecSortLeft(Rr, RlistLeftMax); 
    }
    else RrecSortLeft(1, RlistLeftMax); 
    RDBG("smbc: RsortList RLLOCAL stop\n");
  }
}

void 
RinitList(int Rnr, int Rwhat, RLTYPE Rcol)   // Rcol 0 - left(local)     1 - right(remote)
                                             // Rwat 0 - groups   1 - hosts   2 - shares  3 - dirs
{
  int Ri;

  if (Rcol == RLLOCAL) { 
    for (Ri = 0; Ri < RlistLeftMax; Ri++) 
      realloc(RlistLeft[Ri], sizeof(TTlist)); RlistLeftMax = -1; 
  }
  else { 
    for (Ri = 0; Ri < RlistRightMax; Ri++) 
      realloc(RlistRight[Ri], sizeof(TTlist)); RlistRightMax = -1; 
  }

  if (Rcol == RLLOCAL) 
  { 
    for (Ri = 0; Ri < RlistLeftMax; Ri++)
      realloc(RlistLeft[Ri], sizeof(TTlist));
    RlistLeftMax = 0;
    RlistLeft[RlistLeftMax] = Rmalloc(sizeof(TTlist)); 
    strcpy(RlistLeft[RlistLeftMax]->col1, "D");
    strcpy(RlistLeft[RlistLeftMax]->col2, "..");
    RlistLeft[RlistLeftMax]->col3[0] = 0;
    RlistLeft[RlistLeftMax]->select = 0;
    for (Ri = 0; Ri < Rnr; Ri++) 
    {
      RlistLeft[++RlistLeftMax] = Rmalloc(sizeof(TTlist)); 
      switch (Rwhat) {
        case 0: if (RfilesL[Ri]->type == RTFILE) 
                  memcpy(RlistLeft[RlistLeftMax]->col1, "F", 2); 
                else 
                  memcpy(RlistLeft[RlistLeftMax]->col1, "D", 2); 
                strcpy(RlistLeft[RlistLeftMax]->col3, RfilesL[Ri]->sizeShow);
                strcpy(RlistLeft[RlistLeftMax]->col2, RfilesL[Ri]->filename);
                RlistLeft[RlistLeftMax]->size = RfilesL[Ri]->size;
                RlistLeft[RlistLeftMax]->select = 0;
                if (Ri+1 == Rnr) 
                  RlistLeftMax++;
                break;
      }
    }
  }
  else 
  {
    RDBG("smbc: RinitList REMOTE start\n");
    for (Ri = 0; Ri < RlistRightMax; Ri++)
       realloc(RlistRight[Ri], sizeof(TTlist));
      RlistRightMax = 0;
      RlistRight[RlistRightMax] = Rmalloc(sizeof(TTlist)); 
      strcpy(RlistRight[RlistRightMax]->col1, "D");
      strcpy(RlistRight[RlistRightMax]->col2, "..");
      RlistRight[RlistRightMax]->col3[0] = 0;
      RlistRight[RlistRightMax]->select = 0;
      for (Ri = 0; Ri < Rnr; Ri++) 
      {
        RlistRight[++RlistRightMax] = Rmalloc(sizeof(TTlist)); 
        RlistRight[RlistRightMax]->select = 0;
        switch (Rwhat) 
        {
          case 0: strcpy(RlistRight[RlistRightMax]->col1, "W"); 
                  strcpy(RlistRight[RlistRightMax]->col2, Rgroups[Ri]->groupname);
                  RlistRight[RlistRightMax]->col3[0] = 0;
                  RlistRight[RlistRightMax]->size = 0;
                  break;
          case 1: strcpy(RlistRight[RlistRightMax]->col1, "H"); 
                  RlistRight[RlistRightMax]->col3[0] = 0;
                  strcpy(RlistRight[RlistRightMax]->col2, Rhosts[Ri]->hostname);
                  strcpy(RlistRight[RlistRightMax]->col4, Rhosts[Ri]->hostname);
                  RlistRight[RlistRightMax]->size = 0;
                  if (strlen(Rhosts[Ri]->comment) > 0) 
                    sprintf(RlistRight[RlistRightMax]->col2+strlen(RlistRight[RlistRightMax]->col2), "%s%s", " | ", Rhosts[Ri]->comment);
                  break;
          case 2: strcpy(RlistRight[RlistRightMax]->col1, "S"); 
                  RlistRight[RlistRightMax]->col3[0] = 0;
                  strcpy(RlistRight[RlistRightMax]->col2, Rshares[Ri]->sharename);
                  strcpy(RlistRight[RlistRightMax]->col4, Rshares[Ri]->sharename);
                  RlistRight[RlistRightMax]->size = 0;
                  if (strlen(Rshares[Ri]->comment) > 0) 
                    sprintf(RlistRight[RlistRightMax]->col2+strlen(RlistRight[RlistRightMax]->col2), "%s%s", " | ", Rshares[Ri]->comment);
                  break;
          case 3: if (Rfiles[Ri]->type == RTFILE) 
                    strcpy(RlistRight[RlistRightMax]->col1, "F"); 
                  else 
                    strcpy(RlistRight[RlistRightMax]->col1, "D"); 
                  strcpy(RlistRight[RlistRightMax]->col3, Rfiles[Ri]->sizeShow); 
                  strcpy(RlistRight[RlistRightMax]->col2, Rfiles[Ri]->filename);
                  RlistRight[RlistRightMax]->size = Rfiles[Ri]->size;
                  break;
        }
      }
      RlistRightMax++;
      RDBG("smbc: RinitList REMOTE stop\n");
  }
  RDBG("smbc: RinitList before RsortList(Rcol);\n");
  RsortList(Rcol);
  RDBG("smbc: RinitList after RsortList(Rcol);\n");
}

void 
RsetColorExt(WINDOW *Rwin, char *Rstr, char Rset)
{
  int Ri, Rmax, Rfind;
  char Rextm[10];
  int Rt = strlen(Rstr);
  TText *RextT = Rext;

  Rextm[0] = 0;
  if (Rt > 10) Rmax = 10;
  else Rmax = Rt;

  Ri = 0; 
  Rfind = 1;
  while ((Ri < Rmax) & Rfind) 
  {
    if ((Ri > 0) && (Rstr[Rt-Ri-1] == '.')) 
    {
      memcpy(Rextm, Rstr+Rt-Ri, Ri+2);
      Rfind = 0;
    }
    Ri++;
  }

  if (strlen(Rextm)) 
  {
    while (RextT) 
    {
      if (RstrCmp(RextT->ext,Rextm)) 
      {
        if (Rset) 
           wattron(Rwin, COLOR_PAIR(10+RextT->colornr));
        else  
           wattroff(Rwin, COLOR_PAIR(10+RextT->colornr));
      }
      RextT = RextT->Text;
    } 
  }
}

void 
RwriteMenuTxt(int Rfirst, int Rwhat, RLTYPE Rcol, int Rselect)  // Rcol = 0  left
{
  int Ry, Rx, Ri, Rk;
  char Rinfo[1000];
  char *RinfoP;
  int Rnr, Dnr;
  
  RDBG("smbc: RwriteMenuTxt start\n");
  if (Rcol == RLLOCAL) 
    Rnr = RlistLeftMax;
  else 
    Rnr = RlistRightMax;
  mvwhline(RwinLeftTop, 0, 0, 0, RxHalf-2);
  mvwhline(RwinRightTop, 0, 0, 0, RxHalf-2);
  getmaxyx(RwinLeftCol2, Ry, Rx); Rk = Ry;
  if ((Rnr-Rfirst) < Ry) 
    Ry = Rnr-Rfirst;
  if (RlistLeftMax == 0) 
    Dnr = 1;
  else Dnr = 0;
  if (Rcol == RLLOCAL) 
  { 
    for (Ri = 0; Ri < Ry+Dnr; Ri++) 
    {
      if (RlistLeft[Ri+Rfirst]->select) 
      { 
        wattron(RwinLeftCol1, COLOR_PAIR(2)); 
        wattron(RwinLeftCol2, COLOR_PAIR(2)); 
        wattron(RwinLeftCol3, COLOR_PAIR(2)); 
      }
      if (Rselected == RLLOCAL) 
      {
        if (Ri == Rselect) 
        { 
          wattron(RwinLeftCol1, COLOR_PAIR(1)); 
          wattron(RwinLeftCol2, COLOR_PAIR(1)); 
          wattron(RwinLeftCol3, COLOR_PAIR(1)); 
        }
        if ((RlistLeft[Ri+Rfirst]->select) && (Ri == Rselect)) 
        { 
          wattron(RwinLeftCol1, COLOR_PAIR(3)); 
          wattron(RwinLeftCol2, COLOR_PAIR(3)); 
          wattron(RwinLeftCol3, COLOR_PAIR(3)); 
        }
      }
      mvwhline(RwinLeftCol1, Ri, 0, 32, 1);
      mvwhline(RwinLeftCol2, Ri, 0, 32, RxHalf-10);
      mvwhline(RwinLeftCol3, Ri, 0, 32, 5);
      mvwprintw(RwinLeftCol1,Ri,0,RlistLeft[Ri+Rfirst]->col1); 

      if ((Ri != Rselect) & (!RlistLeft[Ri+Rfirst]->select)) 
         RsetColorExt(RwinLeftCol2, RlistLeft[Ri+Rfirst]->col2, 1);
      
      mvwprintw(RwinLeftCol2,Ri,0, to_scr(RlistLeft[Ri+Rfirst]->col2)); 
      
      if ((Ri != Rselect) & (!RlistLeft[Ri+Rfirst]->select)) 
         RsetColorExt(RwinLeftCol2, RlistLeft[Ri+Rfirst]->col2, 0);

      mvwprintw(RwinLeftCol3, Ri, 0, to_scr(RlistLeft[Ri+Rfirst]->col3)); 
      if (RlistLeft[Ri+Rfirst]->select) 
      { 
        wattroff(RwinLeftCol1, COLOR_PAIR(2)); 
        wattroff(RwinLeftCol2, COLOR_PAIR(2)); 
        wattroff(RwinLeftCol3, COLOR_PAIR(2)); 
      }
      if (Ri == Rselect) 
      { 
        wattroff(RwinLeftCol1, COLOR_PAIR(1)); 
        wattroff(RwinLeftCol2, COLOR_PAIR(1)); 
        wattroff(RwinLeftCol3, COLOR_PAIR(1)); 
      }
      if ((RlistLeft[Ri+Rfirst]->select) && (Ri == Rselect)) 
      { 
        wattroff(RwinLeftCol1, COLOR_PAIR(3)); 
        wattroff(RwinLeftCol2, COLOR_PAIR(3)); 
        wattroff(RwinLeftCol3, COLOR_PAIR(3)); 
      }
    }
    if (Rwhat == 0) 
    {
      memcpy(Rinfo, RadirL, strlen(RadirL)+1);
      mvwprintw(RwinLeftTop,0,0, to_scr(Rinfo)); 
    }
    getmaxyx(RwinLeftCol2, Ry, Rx);
    for (Ri = Rnr-Rfirst+Dnr; Ri < Ry; Ri++) 
    {
      mvwhline(RwinLeftCol1, Ri, 0, 32, 1);
      mvwhline(RwinLeftCol2, Ri, 0, 32, RxHalf-10);
      mvwhline(RwinLeftCol3, Ri, 0, 32, 5);
    }
    wrefresh(RwinLeftTop);
    wrefresh(RwinLeftCol1);
    wrefresh(RwinLeftCol2);
    wrefresh(RwinLeftCol3);
  }
  else 
  {
    RDBG("smbc: RwriteMenuTxt remote start paint\n");
    if (RlistRightMax == 0) Dnr = 1;
    else Dnr = 0;
    for (Ri = 0; Ri < Rk; Ri++) 
    {
      mvwhline(RwinRightCol1, Ri, 0, 32, 1);
      mvwhline(RwinRightCol2, Ri, 0, 32, RxHalf+Rdx-10);
      mvwhline(RwinRightCol3, Ri, 0, 32, 5);
    }
    RDBG("smbc: RwriteMenuTxt remote, berofe main for\n");
    for (Ri = 0; Ri < Ry+Dnr; Ri++) 
    {
      RDBG("smbc: RwriteMenuTxt remote, berofe if (RlistRight[Ri+Rfirst]->select)\n");
      if (RlistRight[Ri+Rfirst]->select) 
      { 
        wattron(RwinRightCol1, COLOR_PAIR(2)); 
        wattron(RwinRightCol2, COLOR_PAIR(2)); 
        wattron(RwinRightCol3, COLOR_PAIR(2)); 
      }
      RDBG("smbc: RwriteMenuTxt remote, after if (RlistRight[Ri+Rfirst]->select)\n");
      if (Rselected == RLREMOTE) 
      {
        if (Ri == Rselect) 
        { 
          wattron(RwinRightCol1, COLOR_PAIR(1)); 
          wattron(RwinRightCol2, COLOR_PAIR(1)); 
          wattron(RwinRightCol3, COLOR_PAIR(1)); 
        }
        RDBG("smbc: RwriteMenuTxt remote, before if ((RlistRight[Ri+Rfirst]->select) && (Ri == Rselect))\n");
        if ((RlistRight[Ri+Rfirst]->select) && (Ri == Rselect)) 
        {
          wattron(RwinRightCol1, COLOR_PAIR(3)); 
          wattron(RwinRightCol2, COLOR_PAIR(3)); 
          wattron(RwinRightCol3, COLOR_PAIR(3)); 
        }
        RDBG("smbc: RwriteMenuTxt remote, after if ((RlistRight[Ri+Rfirst]->select) && (Ri == Rselect))\n");
      }
      mvwhline(RwinRightCol1, Ri, 0, 32, 1);                     // make line
      mvwhline(RwinRightCol2, Ri, 0, 32, RxHalf-10+Rdx);
      mvwhline(RwinRightCol3, Ri, 0, 32, 5); 

      RDBG("smbc: RwriteMenuTxt remote, before mvwprintw(RwinRightCol1,Ri,0,RlistRight[Ri+Rfirst]->col1)\n");
      mvwprintw(RwinRightCol1, Ri, 0, to_scr(RlistRight[Ri+Rfirst]->col1)); 
      RDBG("smbc: RwriteMenuTxt remote, after mvwprintw(RwinRightCol1,Ri,0,RlistRight[Ri+Rfirst]->col1)\n");

      if ((Ri != Rselect) & (!RlistRight[Ri+Rfirst]->select)) 
        RsetColorExt(RwinRightCol2, RlistRight[Ri+Rfirst]->col2, 1);
      RDBG("smbc: RwriteMenuTxt remote, before mvwprintw(RwinRightCol2,Ri,0, RlistRight[Ri+Rfirst]->col2)\n");
      RDBG(RlistRight[Ri+Rfirst]->col2); RDBG("\n");
      RDBG(RlistRight[Ri+Rfirst]->col2); RDBG("\n");
      mvwprintw(RwinRightCol2, Ri, 0, to_scr(RlistRight[Ri+Rfirst]->col2)); 
      RDBG("smbc: RwriteMenuTxt remote, after mvwprintw(RwinRightCol2,Ri,0, RlistRight[Ri+Rfirst]->col2)\n");
      if ((Ri != Rselect) & (!RlistRight[Ri+Rfirst]->select)) 
        RsetColorExt(RwinRightCol2, RlistRight[Ri+Rfirst]->col2, 0);

      RDBG("smbc: RwriteMenuTxt remote, before mvwprintw(RwinRightCol3,Ri,0,RlistRight[Ri+Rfirst]->col3)\n");
      mvwprintw(RwinRightCol3, Ri, 0, to_scr(RlistRight[Ri+Rfirst]->col3)); 
      if (RlistRight[Ri+Rfirst]->select) 
      { 
        wattroff(RwinRightCol1, COLOR_PAIR(2)); 
        wattroff(RwinRightCol2, COLOR_PAIR(2)); 
        wattroff(RwinRightCol3, COLOR_PAIR(2)); 
      }
      if (Ri == Rselect) 
      { 
        wattroff(RwinRightCol1, COLOR_PAIR(1)); 
        wattroff(RwinRightCol2, COLOR_PAIR(1)); 
        wattroff(RwinRightCol3, COLOR_PAIR(1)); 
      }
      if ((RlistRight[Ri+Rfirst]->select) && (Ri == Rselect)) 
      { 
        wattroff(RwinRightCol1, COLOR_PAIR(3)); 
        wattroff(RwinRightCol2, COLOR_PAIR(3)); 
        wattroff(RwinRightCol3, COLOR_PAIR(3)); 
      }
    }
    switch (Rwhat) 
    {
      case 0: mvwprintw(RwinRightTop,0,0,"//"); 
              break;
      case 1: asprintf(&RinfoP, "//%s", Ragroup);
              mvwprintw(RwinRightTop,0,0, to_scr(RinfoP)); 
              free(RinfoP);
              break;
      case 2: asprintf(&RinfoP, "//%s/%s", Ragroup, Rahost);
              mvwprintw(RwinRightTop,0,0, to_scr(RinfoP)); 
              free(RinfoP);
              break;
      case 3: asprintf(&RinfoP, "//%s/%s", Ragroup, Radir+6);
              mvwprintw(RwinRightTop,0,0, to_scr(RinfoP));
              free(RinfoP);
              break; 
    }
    getmaxyx(RwinLeftCol2, Ry, Rx);
    for (Ri = Rnr-Rfirst+Dnr; Ri < Ry; Ri++) 
    {
      mvwhline(RwinRightCol1, Ri, 0, 32, 1);
      mvwhline(RwinRightCol2, Ri, 0, 32, RxHalf+Rdx-10);
      mvwhline(RwinRightCol3, Ri, 0, 32, 5);
    }
    wrefresh(RwinRightTop);
    wrefresh(RwinRightCol1);
    wrefresh(RwinRightCol2);
    wrefresh(RwinRightCol3);
  }
  curs_set(0);
  RDBG("smbc: RwriteMenuTxt finished\n");
}

int 
RchdirL(char *Rstr, char *Rdir)
{
  int Ri, Rtmp;

  if (RstrCmp(Rdir, "..")) 
  {
    Rtmp = strlen(Rstr)-2;
    if (Rtmp > 0) 
    {
      for (Ri = 0; Ri < Rtmp+1; Ri++) 
      {
        if (Rstr[Rtmp-Ri] == '/') 
        {
          Rstr[Rtmp-Ri+1] = 0;
          return (0);
        }
      } 
    }
  } 
  else {
     sprintf(Rstr+strlen(Rstr), "%s/", Rdir);
  }
  return (0);
}

void 
RgetSmallPath(char *Rdst)
{
  sprintf(Rdst, "smb://%s/", Rahost);
}

void 
RdoWindowResize()
{
  if (RdoResize) 
  {
    RdoResize = 0;

    RleftPos = 0;
    RrightPos = 0;
    RleftFirst = 0;
    RrightFirst = 0;

    RwriteMenu(1);
    RwriteMenu(1);
    RwriteMenuTxt(RleftFirst,RremoteLevel,RLLOCAL,RleftPos);
    RwriteMenuTxt(RrightFirst,RremoteLevel,RLREMOTE,RrightPos);
    keypad(RwinMain, TRUE);
    nodelay(RwinMain,1);
    RactiveWindow = RwinMain;
    RDBG("smbc : RdoWindowResize RactiveWindow = RwinMain  2\n");
  }
}

void 
RresizeHandler(int sig) 
{
  RdoResize = 1;
  RdoResizeFind = 1;
  RdoResizeDownload = 1;
  RdoResizeBookmark = 1;
}

int 
RdownloadUpload()
{
  #define RstrSLen 1000
  int Ri;
  TTdownload *RdownloadListTmp = RdownloadList;
  char *Rstr, *Rstr2, *Rstr3, *Rbuf;
  struct stat Rlocalstat, Rremotestat;
  char RstrS[RstrSLen];
  off_t R2, R1;
  ssize_t Rbread21, Rbread22;
  int RbufSize;
  char *Rbuf21;
  char *Rbuf22;
  char *RstrT1;
  int Rerr;
  ssize_t Rbread;
  time_t Rtt;
  long int RtimeRt;
  int Rbwrite;

  alarm(0);

  RDBG("smbc: RdownloadUpload start\n");
  
  void 
  RremoveActFromListAndCloseFiles()
  {
    if (RdownloadListAct->RdownloadListP != NULL)
       RdownloadListAct->RdownloadListP->RdownloadList = RdownloadListAct->RdownloadList;
    if (RdownloadListAct->RdownloadList != NULL)
       RdownloadListAct->RdownloadList->RdownloadListP = RdownloadListAct->RdownloadListP;
    if (RdownloadListAct == RdownloadList) 
       RdownloadList = RdownloadList->RdownloadList;

    if (RdownloadListAct->upload == 'D') 
    {
      Rsmbc_close(RdownloadHandleR);
      close(RdownloadHandleL);
    }
    else 
    {
      Rsmbc_close(RdownloadHandleL);
      close(RdownloadHandleR);
    }

    free(RdownloadListAct);
    RdownloadHandleL = -1;
    RdownloadHandleR = -1;
    RdownloadListAct = NULL;
    RDBG("smbc : RremoveActFromListAndCloseFiles RdownloadList == "); RDBGi((int)RdownloadList); RDBG("\n");
  }

  int 
  Rchoice(int Rin, int *Rch) 
  {
    switch (Rin) {
      case 0 : RremoveActFromListAndCloseFiles();    // cancel
               alarm(RCalarm);
               return(0);
      case 1 : if (RdownloadListAct->upload == 'D')    // overwrite
               {
                 close(RdownloadHandleL);              
                 remove(RdownloadListAct->fullfilename);
                 RdownloadHandleL = open(to_sys(RdownloadListAct->fullfilename), O_CREAT | O_NONBLOCK | O_RDWR, 0755);
               }
               else 
               {
                 Rsmbc_close(RdownloadHandleL);              
                 Rsmbc_unlink(RdownloadListAct->fullfilename);
                 strcpy(RusernameInter, Rusername);
                 strcpy(RpasswordInter, Rpassword);
                 strcpy(Rusername, RdownloadListAct->username);
                 strcpy(Rpassword, RdownloadListAct->password);
                 RdownloadHandleL = Rsmbc_open(RdownloadListAct->fullfilename, O_CREAT | O_NONBLOCK | O_RDWR, 0755);
                 strcpy(Rusername, RusernameInter);
                 strcpy(Rpassword, RpasswordInter);
               }
               if ((fstat(RdownloadHandleL,&Rlocalstat) < 0) && (RdownloadListAct->upload == 'D')) 
               {
                 Rsmbc_close(RdownloadHandleR);
                 close(RdownloadHandleL);
               }
               if ((Rsmbc_fstat(RdownloadHandleL,&Rlocalstat) < 0) && (RdownloadListAct->upload == 'U')) 
               { 
                 Rsmbc_close(RdownloadHandleL);
                 close(RdownloadHandleR);
               }
               RdownloadHandleL = -1;
               RdownloadHandleR = -1;
               alarm(RCalarm);
               return(1);
      case 2 : RdownloadListAct->active = 'W';            // wait
               if (RdownloadListAct->upload == 'U') 
               {
                 Rsmbc_close(RdownloadHandleR);
                 close(RdownloadHandleL);
               }
               else 
               {
                 Rsmbc_close(RdownloadHandleL);
                 close(RdownloadHandleR);
               }
               RdownloadHandleL = -1;
               RdownloadHandleR = -1;
               RdownloadListAct = NULL;
               alarm(RCalarm);
               return(0);
      case 4 : *Rch = 0;        // retry without asking
      case 3 : if (RdownloadListAct->upload == 'U')    // retry
               {
                 Rsmbc_close(RdownloadHandleR);
                 close(RdownloadHandleL);
               }
               else 
               {
                 Rsmbc_close(RdownloadHandleL);
                 close(RdownloadHandleR);
               }
               RdownloadHandleL = -1;
               RdownloadHandleR = -1;
               RdownloadListAct = NULL;
               alarm(RCalarm);
               return(0);
     }
    alarm(RCalarm);
    return(1);
  }
 
#ifdef HAVE_DEBUG
  if (RdownloadList) 
  {
    RDBG("smbc : RdownloadUpload RdownloadList->RdownloadList == "); RDBGi((int)RdownloadList->RdownloadList); RDBG("\n");
    RDBG("smbc : RdownloadUpload RdownloadList->RdownloadListP == "); RDBGi((int)RdownloadList->RdownloadListP); RDBG("\n");
  }
#endif /* HAVE_DEBUG */

  if (RdownloadListTmp == NULL) 
  {
     RDBG("smbc: RdownloadUpload 1\n");
     RopenSaveDownloadList(1);
     if (RdownloadList == NULL) 
     {
       RstatusBar(0);
       alarm(RCalarm);
       return(0);
     } 
     else 
       RdownloadListTmp = RdownloadList;
  }
  else 
  {
    RDBG("smbc: RdownloadUpload 1\n");
    if (RdownloadHandleR == -1) 
    {
      RactuallyNothingDownloadUpload = 1;
      RdownloadListAct = NULL; 
      while ((RdownloadHandleR < 0) & (RdownloadListTmp != NULL)) 
      {
        if ((RdownloadListTmp->active == 'X') && (time(NULL) > RdownloadListTmp->nextRetry)) 
        {
          if (RdownloadListTmp->upload == 'D') 
          {
            asprintf(&Rstr, "%s/%s", RdownloadListTmp->pathR, RdownloadListTmp->filename);

            /* must be convert to to_scr, internal UTF-8 */
            RstatusBarStr(to_scr(Rstr), 1);

            RDBG("!!smbc : RdownloadUpload 1.1 RdownloadListTmp->filename = "); RDBG(Rstr); RDBG("|\n");
            strcpy(RusernameInter, Rusername);
            strcpy(RpasswordInter, Rpassword);
            strcpy(Rusername, RdownloadListTmp->username);
            strcpy(Rpassword, RdownloadListTmp->password);
            RdownloadHandleR = Rsmbc_open(Rstr, O_RDONLY, 0755);
            strcpy(Rusername, RusernameInter);
            strcpy(Rpassword, RpasswordInter);
          }
          else 
          {
            asprintf(&Rstr, "%s/%s", RdownloadListTmp->pathR, RdownloadListTmp->filename);
            RdownloadHandleR = open(to_sys(Rstr), O_RDONLY, 0755);
          }
          if(RdownloadHandleR < 0) 
          {

             /*  
                 Rm232 - output
                 Rstr  - UTF-8
                 Rm233 - output
                 Rstr3 - output
             */
             RreturnHumanDelayTime(&Rstr3, RdownloadListTmp->delayRetry);
             asprintf(&Rstr2, "%s%s%s%s", Rm232, to_scr(Rstr), Rm233, Rstr3);

             RstatusBarStr(Rstr2, 0);
             free(Rstr2);
             free(Rstr3);

             RdownloadListTmp->nextRetry = time(NULL)+RdownloadListTmp->delayRetry;
             if (RdownloadListTmp->RdownloadList == NULL) {
               RdownloadListAct = NULL;
               //RstatusBar(0);
             }
             RdownloadListTmp = RdownloadListTmp->RdownloadList;
          }
          free(Rstr);
        }
        else RdownloadListTmp = RdownloadListTmp->RdownloadList;
      }
      if (RdownloadHandleR > 0) 
        RdownloadListAct = RdownloadListTmp;
    }
    else {
       RDBG("smbc: RdownloadUpload 2\n");
       if ((RdownloadHandleL == -1) &
           (RdownloadHandleR != -1)) 
       {
         RDBG("smbc: RdownloadUpload 3\n");
         RactuallyNothingDownloadUpload = 1;
         if (RdownloadListAct->upload == 'D') 
         {
           if (strlen(RdownloadListAct->pathRbase) != strlen(RdownloadListAct->pathR)) 
             asprintf(&Rstr, "%s%s/%s", RdownloadListAct->pathL,RdownloadListAct->pathR+strlen(RdownloadListAct->pathRbase),RdownloadListAct->filename);
           else 
             asprintf(&Rstr, "%s%s", RdownloadListAct->pathL,RdownloadListAct->filename);
           for (Ri = 0; Ri < strlen(Rstr); Ri++) 
           {
             if (Rstr[Ri] == '/') 
             {
               Rstr2 = strdup(Rstr); 
               Rstr2[Ri+1] = 0;
               mkdir(Rstr2, 0755);
               free(Rstr2);
             }
           }
           RdownloadHandleL = open(to_sys(Rstr), O_CREAT | O_NONBLOCK | O_RDWR, 0755);
           strcpy(RdownloadListAct->fullfilename, Rstr);
         }
         else {
            RactuallyNothingDownloadUpload = 0;

            /*
             *                                       RdownloadListAct->pathL - UTF-8
             *   RdownloadListAct->pathR+strlen(RdownloadListAct->pathRbase) - UTF-8
             *                                    RdownloadListAct->filename - UTF-8
             */
            asprintf(&Rstr, "%s/%s/%s", RdownloadListAct->pathL,RdownloadListAct->pathR+strlen(RdownloadListAct->pathRbase),RdownloadListAct->filename);

            Rstr3 = to_sys(Rstr);
            for (Ri = 0; Ri < strlen(Rstr3); Ri++) 
            {
              if (Rstr[Ri] == '/') 
              {
                Rstr2 = strdup(Rstr3); 
                Rstr2[Ri+1] = 0;
                Rsmbc_mkdir(Rstr2, 0755);
                free(Rstr2);
              }
            }

            /*
             *   Rstr - UTF-8
             */
            RstatusBarStr(to_scr(Rstr), 1);

            RDBG("!smbc : RdownloadUpload 1.1 RdownloadListTmp->filename = "); RDBG(RdownloadListTmp->filename); RDBG("|\n");
            strcpy(RusernameInter, Rusername);
            strcpy(RpasswordInter, Rpassword);

            /*
             *   RdownloadListAct->username - UTF-8
             *   RdownloadListAct->password - UTF-8
             *    libsmbclient input/output - UTF-8
             */
            strcpy(Rusername, RdownloadListAct->username);
            strcpy(Rpassword, RdownloadListAct->password);
            RdownloadHandleL = Rsmbc_open(Rstr, O_CREAT | O_NONBLOCK | O_RDWR, 0755);
            strcpy(Rusername, RusernameInter);
            strcpy(Rpassword, RpasswordInter);
         }
         if (RdownloadHandleL < 0) {
           RdownloadListAct->nextRetry = time(NULL)+RdownloadListAct->delayRetry;
           RdownloadHandleL = -1;
           alarm(RCalarm);
           return(0);
         }
         free(Rstr);
       }
       else {
         RDBG("smbc: RdownloadUpload 4\n");
         RactuallyNothingDownloadUpload = 0;
         if (RdownloadListAct->upload == 'D') 
         {
           RDBG("smbc: RdownloadUpload 5\n");
           if ((Rsmbc_fstat(RdownloadHandleR, &Rremotestat) < 0) || (fstat(RdownloadHandleL,&Rlocalstat) < 0)) 
           {  
             Rsmbc_close(RdownloadHandleR);
             close(RdownloadHandleL);
             RdownloadHandleL = -1;
             RdownloadHandleR = -1;
           }
         }
         else {
           RDBG("smbc: RdownloadUpload 6\n");
           if ((fstat(RdownloadHandleR,&Rremotestat) < 0) || (Rsmbc_fstat(RdownloadHandleL,&Rlocalstat) < 0)) 
           {  
             close(RdownloadHandleR);
             Rsmbc_close(RdownloadHandleL);
             RdownloadHandleL = -1;
             RdownloadHandleR = -1;
           }
         }
         RDBG("smbc: RdownloadUpload 7\n");

         if ((int)Rlocalstat.st_size < (int)Rremotestat.st_size) 
         {
           RgetHumanSize(RdownloadListAct->sizeDisplayDownR, TdownloadsizeDisplayRLen-1, (int)Rremotestat.st_size-Rlocalstat.st_size);
           RDBG("wmbc : RdownloadUpload 6.1 RdownloadListAct->sizeDisplayDownR = "); RDBG(RdownloadListAct->sizeDisplayDownR); RDBG("|\n");

           if ((int)(Rremotestat.st_size)/1024 > 0) 
           {

#ifdef HAVE_DEBUG
  if (RdownloadList) 
  {
    RDBG("smbc : RdownloadUpload 2 RdownloadList->RdownloadList == "); RDBGi((int)RdownloadList->RdownloadList); RDBG("\n");
    RDBG("smbc : RdownloadUpload 2 RdownloadList->RdownloadListP == "); RDBGi((int)RdownloadList->RdownloadListP); RDBG("\n");
  }
#endif /* HAVE_DEBUG */
              itoa(RdownloadListAct->percent, TdownloadpercentLen, (int)100*(Rlocalstat.st_size/1024)/(Rremotestat.st_size/1024));

#ifdef HAVE_DEBUG
  if (RdownloadList) 
  {
    RDBG("smbc : RdownloadUpload 3 RdownloadList->RdownloadList == "); RDBGi((int)RdownloadList->RdownloadList); RDBG("\n");
    RDBG("smbc : RdownloadUpload 3 RdownloadList->RdownloadListP == "); RDBGi((int)RdownloadList->RdownloadListP); RDBG("\n");
  }
#endif /* HAVE_DEBUG */
           }
           else 
             strcpy(RdownloadListAct->percent, "0");
           RDBG("smbc: RdownloadUpload 8\n");

#ifdef HAVE_DEBUG
  if (RdownloadList) 
  {
    RDBG("smbc : RdownloadUpload 4 RdownloadList->RdownloadList == "); RDBGi((int)RdownloadList->RdownloadList); RDBG("\n");
    RDBG("smbc : RdownloadUpload 4 RdownloadList->RdownloadListP == "); RDBGi((int)RdownloadList->RdownloadListP); RDBG("\n");
  }
#endif /* HAVE_DEBUG */

           RdownloadListAct->percent[4] = 0;
           RDBG("smbc: RdownloadUpload 8.1\n");

           itoa(RstrS, RstrSLen, RgetdownloadListCount());
           RDBG("smbc: RdownloadUpload 8.2\n");
           RDBG("smbc: RdownloadUpload 8.2 strlen(RstrS) = "); RDBGi(strlen(RstrS)); RDBG("\n");

           // X, downloading(uploading) xx/s, remaing
           /*
            *   Rm234 - to_scr
                Rm235 - to_scr
            */
           sprintf(RstrS+strlen(RstrS), ", %s ", (RdownloadListAct->upload == 'D'?Rm234:Rm235));

           RDBG("smbc: RdownloadUpload 9.1 strlen(RstrS) = "); RDBGi(strlen(RstrS)); RDBG("\n");
           RDBG("smbc: RdownloadUpload 9.2 RavrSizeDisplay = "); RDBGi(RavrSizeDisplay); RDBG("\n");

           RgetHumanSize(RstrS+strlen(RstrS), RstrSLen-strlen(RstrS)>5?5:RstrSLen-strlen(RstrS), RavrSizeDisplay);

           RDBG("smbc: RdownloadUpload 9.3 strlen(RstrS) = "); RDBGi(strlen(RstrS)); RDBG("\n");
           /*
            *   Rm236 - to_scr
            */
           strcpy(RstrS+strlen(RstrS), Rm236);

           // xxs,
           /* 
            *   RdownloadListAct->sizeDisplayDownR - number
            */
           strcpy(RstrS+strlen(RstrS), RdownloadListAct->sizeDisplayDownR);
           strcpy(RstrS+strlen(RstrS), ", ");
           RDBG("smbc: RdownloadUpload 9.4 RstrS = "); RDBG(RstrS); RDBG("|\n");
          
           RDBG("smbc: RdownloadUpload 10\n");
           // time
           if (RavrSizeDisplay > 0)
             RtimeRt = (Rremotestat.st_size-Rlocalstat.st_size)/(RavrSizeDisplay);
           else 
             RtimeRt = 0;
           RDBG("smbc: RdownloadUpload 10-1\n");
           RtimeR = (RtimeR+RtimeRt)/2;
             RtimeRt = RtimeR % 60;
             RtimeR = RtimeR/60;
           RDBG("smbc: RdownloadUpload 10.2\n");
           RDBG("smbc: RdownloadUpload 10.2 strlen(RstrS) = "); RDBGi(strlen(RstrS)); RDBG("\n");
             itoa(RstrS+strlen(RstrS), RstrSLen-strlen(RstrS), RtimeR);
           RDBG("smbc: RdownloadUpload 10-3\n");
             strcpy(RstrS+strlen(RstrS), ".");
             itoa(RstrS+strlen(RstrS), RstrSLen-strlen(RstrS), RtimeRt);
             /*
              *   Em237 - to_scr
              */
             strcpy(RstrS+strlen(RstrS), Rm237);

           // percent
           /* 
            *   RdownloadListAct->percent - number
                                    Rm231 - to_scr
               RdownloadListAct->filename - UTF-8
            */
           memcpy(RstrS+strlen(RstrS), RdownloadListAct->percent, strlen(RdownloadListAct->percent)+1);
           memcpy(RstrS+strlen(RstrS), "%%", 3);
           memcpy(RstrS+strlen(RstrS), Rm231, strlen(Rm231)+1);
           RstrT1 = to_scr(RdownloadListAct->filename);
           memcpy(RstrS+strlen(RstrS), RstrT1, strlen(RstrT1)+1);

           /*
            * insert spaces to remaing space into status bar line
            */
           Ri = Rx - strlen(RstrS);
           if (Ri > 0) 
           {
             memset(RstrS+strlen(RstrS), ' ', Ri);
             RstrS[Rx] = 0;
           }
           RstatusBarStr(RstrS, 0);
           RDBG("smbc: RdownloadUpload 9.4 RstrS = "); RDBG(RstrS); RDBG("|\n");

           if ((int)Rlocalstat.st_size > 0) 
           {
             if ((int)Rlocalstat.st_size > 1024) 
               RbufSize = 1024; 
             else 
               RbufSize = (int)Rlocalstat.st_size;
             Rbuf21 = Rmalloc(RbufSize);
             Rbuf22 = Rmalloc(RbufSize);
             Ri = (int)Rlocalstat.st_size-RbufSize;
             if (RdownloadListAct->upload == 'D') 
             {
               R2 = lseek(RdownloadHandleL, Ri, SEEK_SET);
               R1 = Rsmbc_lseek(RdownloadHandleR, Ri, SEEK_SET);
               RDBG("smbc : RdownloadUpload 1 R1 == "); RDBGi(R1); RDBG("\n");
               RDBG("smbc : RdownloadUpload 1 R2 == "); RDBGi(R2); RDBG("\n");
               Rbread21 = Rsmbc_read(RdownloadHandleR, Rbuf21, RbufSize);
               Rbread22 = read(RdownloadHandleL, Rbuf22, RbufSize);
             }
             else 
             {
               R2 = lseek(RdownloadHandleR, Ri, SEEK_SET);
               R1 = Rsmbc_lseek(RdownloadHandleL, Ri, SEEK_SET);
               RDBG("smbc : RdownloadUpload 2 R1 == "); RDBGi(R1); RDBG("\n");
               RDBG("smbc : RdownloadUpload 2 R2 == "); RDBGi(R2); RDBG("\n");
               Rbread21 = read(RdownloadHandleR, Rbuf22, RbufSize);
               Rbread22 = Rsmbc_read(RdownloadHandleL, Rbuf21, RbufSize);
             }
             RDBG("smbc : RdownloadUpload 2 Rbread21 == "); RDBGi(Rbread21); RDBG("\n");
             RDBG("smbc : RdownloadUpload 2 Rbread22 == "); RDBGi(Rbread22); RDBG("\n");
             Rerr = 0;
             if ((Rbread21 == Rbread22) && (Rbread21 >= 0) && (Rbread21 >= 0)) 
             {
               RDBG("smbc : RdownloadUpload com 1\n");
               if (memcmp(Rbuf21, Rbuf22, Rbread21) != 0) 
               {
                 Rerr = 1;
                 RDBG("smbc : RdownloadUpload com 1.1\n");
               }
             }
             else 
             {
               RDBG("smbc : RdownloadUpload com 2\n");
               if (Rbread21 != RbufSize) 
                 Rerr = 2;
               else 
                 Rerr = 3;
             }
             if (R1 != R2) 
             {
               Rerr = 2;
               RDBG("smbc : RdownloadUpload com 3\n");
             }
             free(Rbuf21);
             free(Rbuf22);
             RDBG("smbc : RdownloadUpload 1 Rerr == "); RDBGi(Rerr); RDBG("\n");
             if (Rerr) 
             {
               RDBG("smbc : RdownloadUpload 2\n");         // Rmsg38 read
               if (!Rchoice(RaskRetry == 1?RshowMessage((Rerr == 1?25:26),(Rerr == 2?Rm238:Rm239),"",RdownloadListAct):4, &RaskRetry)) {
                 RDBG("smbc: RdownloadUpload return 1\n");
                 alarm(RCalarm);
                 return(0);
               }
             }
           } 
           RDBG("smbc : RdownloadUpload 3\n");
           Rbuf = Rmalloc(64000);
           if (RdownloadListAct->upload == 'D') 
           {
             lseek(RdownloadHandleL, Rlocalstat.st_size, SEEK_SET);
             Rsmbc_lseek(RdownloadHandleR, Rlocalstat.st_size, SEEK_SET);

             Rbread = Rsmbc_read(RdownloadHandleR, Rbuf, 64000);
             Rbwrite = write(RdownloadHandleL, Rbuf, Rbread);

             if (Rbwrite != Rbread) 
               if (!Rchoice(RaskRetryDiskFull == 1?Rerr = RshowMessage(29,Rm240, NULL, NULL):4, &RaskRetryDiskFull)) {
                 free(Rbuf);
                 RDBG("smbc: RdownloadUpload return 2\n");
                 alarm(RCalarm);
                 return(0);
               }
           }
           else 
           {
             lseek(RdownloadHandleR, Rlocalstat.st_size, SEEK_SET);
             Rsmbc_lseek(RdownloadHandleL, Rlocalstat.st_size, SEEK_SET);

             Rbread = read(RdownloadHandleR, Rbuf, 64000);
             Rbwrite = Rsmbc_write(RdownloadHandleL, Rbuf, Rbread);

             if (Rbwrite != Rbread) 
               if (!Rchoice(RaskRetryDiskFull == 1?Rerr = RshowMessage(29,Rm241, NULL, NULL):4, &RaskRetryDiskFull)) 
               {
                 free(Rbuf);
                 RDBG("smbc: RdownloadUpload return 3\n");
                 alarm(RCalarm);
                 return(0);
               }
           }

           RDBG("smbc : RdownloadUpload 4\n");
           Rtt = time(NULL);
           if (RavrTime != Rtt) 
           {
             RavrTime = Rtt;
             RavrSizeDisplay = (10*RavrSizeDisplay+RavrSize)/11;
             RavrSize = Rbread;
           } 
           else 
             RavrSize+= Rbread;

           free(Rbuf);
         } 
         else RremoveActFromListAndCloseFiles();
       }
    }
  }
  RDBG("smbc: RdownloadUpload return last\n");
  alarm(RCalarm);
  return(0);
}

int 
RcreateFileFromDirR(char *RadirL, char *RadirRbase, char *Rfilename, char *Rworkgroup, char Rtype)
{
  char *RnewNameR;
  int Rys = 6;
  int Rxs = 78;
  WINDOW *RwinAdd = NULL;

  void 
  RsmbDownloadFile(char *RadirR, char *Rfilename)
  {
    int Rfilehandle;
    struct stat Rremotestat;
    TTdownload *RdownloadListTmp;
    char *Rname;

    asprintf(&Rname, "%s%s", RadirR, Rfilename);
    Rfilehandle = Rsmbc_open(Rname, O_RDONLY, 0755);
    if (Rsmbc_fstat(Rfilehandle, &Rremotestat) >= 0) 
    {
         RdownloadListTmp = RgetdownloadListLast();
         if (RdownloadListTmp == NULL) 
         {
           RDBG("smbc : RsmbDownloadFile RdownloadListTmp == NULL\n");
           RdownloadListTmp = Rmalloc(sizeof(TTdownload));
           RdownloadListTmp->RdownloadListP = NULL;
           RdownloadListTmp->RdownloadList = NULL;
           RdownloadList = RdownloadListTmp;
         }
         else 
         {
           RdownloadListTmp->RdownloadList = Rmalloc(sizeof(TTdownload));
           RdownloadListTmp->RdownloadList->RdownloadListP = RdownloadListTmp;
           RdownloadListTmp = RdownloadListTmp->RdownloadList;
           RdownloadListTmp->RdownloadList = NULL;
         }
         strcpy(RdownloadListTmp->groupnameR, Rworkgroup);
         strcpy(RdownloadListTmp->pathL, RadirL);
         strcpy(RdownloadListTmp->pathR, RadirR);
         RdownloadListTmp->upload = 'D';
         strcpy(RdownloadListTmp->pathRbase, RadirRbase);
         strcpy(RdownloadListTmp->filename, Rfilename);
         RdownloadListTmp->sizeR = Rremotestat.st_size;
         RgetHumanSize(RdownloadListTmp->sizeDisplayR, TdownloadsizeDisplayRLen, Rremotestat.st_size);
         RgetHumanSize(RdownloadListTmp->sizeDisplayDownR, TdownloadsizeDisplayDownR, Rremotestat.st_size);
         strcpy(RdownloadListTmp->percent, "0");
         RdownloadListTmp->active = 'X';
         RdownloadListTmp->delayRetry = RdefaultDelayRetry;
         RdownloadListTmp->nextRetry = 0;
         strcpy(RdownloadListTmp->username, Rusername);
         strcpy(RdownloadListTmp->password, Rpassword);
    }
    free(Rname);
    RDBG("smbc : RsmbDownloadFile RdownloadList->RdownloadList == "); RDBGi((int)RdownloadList->RdownloadList); RDBG("\n");
    RDBG("smbc : RsmbDownloadFile RdownloadList->RdownloadListP == "); RDBGi((int)RdownloadList->RdownloadListP); RDBG("\n");
    Rsmbc_close(Rfilehandle);
  }

  int 
  RsmbDownloadDir(char *Rname)
  {
    struct smbc_dirent *Rdirent;
    int Rdirhandle, Rfilehandle;
    char *RnewName;
    struct stat Rremotestat;
    TTdownload *RdownloadListTmp;
    char *RnameShort;
    int Rtym;
    
    Rdirhandle = Rsmbc_opendir(Rname);
    if (Rdirhandle < 1) 
      return(-1);
    while((Rdirent = Rsmbc_readdir(Rdirhandle))) 
    {
      if (RstrCmp(Rdirent->name, ".") || RstrCmp(Rdirent->name, "..")) 
        continue;
      asprintf(&RnewName, "%s/%s", Rname, Rdirent->name); 
      switch(Rdirent->smbc_type) 
      {
        case SMBC_DIR:
             RsmbDownloadDir(RnewName);
             break;
        case SMBC_FILE:
             asprintf(&RnameShort, "%s", RnewName);
             Rtym = strlen(RnameShort);
             if (Rtym > Rxs-4) Rtym = Rxs-4;
             RnameShort[Rtym] = 0;
             mvwhline(RwinAdd, 3, 1, ' ', Rxs-2);
             mvwprintw(RwinAdd, 3, Rxs/2-strlen(RnameShort)/2, to_scr(RnameShort));
             wrefresh(RwinAdd);
             free(RnameShort);

             Rfilehandle = Rsmbc_open(RnewName, O_RDONLY, 0755);
             if (Rsmbc_fstat(Rfilehandle, &Rremotestat) >= 0) 
             {
               RdownloadListTmp = RgetdownloadListLast();
               if (RdownloadListTmp == NULL) 
               {
                 RdownloadListTmp = Rmalloc(sizeof(TTdownload));
                 RdownloadList = RdownloadListTmp;
                 RdownloadListTmp->RdownloadList = NULL; 
                 RdownloadListTmp->RdownloadListP = NULL; 
               }
               else 
               {
                 RdownloadListTmp->RdownloadList = Rmalloc(sizeof(TTdownload));
                 RdownloadListTmp->RdownloadList->RdownloadListP = RdownloadListTmp;
                 RdownloadListTmp = RdownloadListTmp->RdownloadList;
                 RdownloadListTmp->RdownloadList = NULL;
               }
               strcpy(RdownloadListTmp->groupnameR, Rworkgroup);
               strcpy(RdownloadListTmp->pathL, RadirL);
               strcpy(RdownloadListTmp->pathR, Rname);
               RdownloadListTmp->upload = 'D';
               strcpy(RdownloadListTmp->pathRbase, RadirRbase);
               strcpy(RdownloadListTmp->filename, Rdirent->name);
               RdownloadListTmp->sizeR = Rremotestat.st_size;
               RgetHumanSize(RdownloadListTmp->sizeDisplayR, TdownloadsizeDisplayRLen, Rremotestat.st_size);
               RgetHumanSize(RdownloadListTmp->sizeDisplayDownR, TdownloadsizeDisplayDownR, Rremotestat.st_size);
               strcpy(RdownloadListTmp->percent, "0");
               RdownloadListTmp->active = 'X';
               strcpy(RdownloadListTmp->username, Rusername);
               strcpy(RdownloadListTmp->password, Rpassword);
               Rsmbc_close(Rfilehandle);
             }
             break;
      }
      free(RnewName);
    }
    Rsmbc_closedir(Rdirhandle);
    return 1;
  } 

  RwinAdd = newwin(Rys, Rxs, Ry/2-Rys/2, Rx/2-Rxs/2);
  box(RwinAdd, 0, 0);
  mvwprintw(RwinAdd, 1, Rxs/2-strlen(Rm58)/2, Rm58);
  wrefresh(RwinAdd);

  if (Rtype == 'D') 
  {
    asprintf(&RnewNameR, "%s%s/", RadirRbase, Rfilename);
    RsmbDownloadDir(RnewNameR);
    free(RnewNameR);
  }
  else 
    RsmbDownloadFile(RadirRbase,Rfilename); 

  delwin(RwinAdd);
  return(0);
}

int 
RcreateFileFromDirL(char *RadirL, char *RadirR, char *Rfilename, char *Rworkgroup, char Rtype)
{
  char *RnewNameR;
  int Rys = 6;
  int Rxs = 78;
  WINDOW *RwinAdd = NULL;
  char *Rstr1;

  asprintf(&Rstr1, Rm59);

  void RsmbDownloadFile(char *RadirL, char *Rfilename)
  {
    int Rfilehandle;
    struct stat Rlocalstat;
    TTdownload *RdownloadListTmp;
    char *Rname;

    asprintf(&Rname, "%s%s", RadirL, Rfilename);
    Rfilehandle = open(to_sys(Rname), O_RDONLY, 0755);
    if (fstat(Rfilehandle, &Rlocalstat) >= 0) 
    {
         RdownloadListTmp = RgetdownloadListLast();
         if (RdownloadListTmp == NULL) 
         {
           RdownloadListTmp = Rmalloc(sizeof(TTdownload));
           RdownloadListTmp->RdownloadListP = NULL;
           RdownloadListTmp->RdownloadList = NULL;
           RdownloadList = RdownloadListTmp;
         }
         else 
         {
           RdownloadListTmp->RdownloadList = Rmalloc(sizeof(TTdownload));
           RdownloadListTmp->RdownloadList->RdownloadListP = RdownloadListTmp;
           RdownloadListTmp = RdownloadListTmp->RdownloadList;
           RdownloadListTmp->RdownloadList = NULL;
         }
         strcpy(RdownloadListTmp->groupnameR, Rworkgroup);
         strcpy(RdownloadListTmp->pathL, RadirR);
         strcpy(RdownloadListTmp->pathR, RadirL);
         RdownloadListTmp->upload = 'U';
         strcpy(RdownloadListTmp->pathRbase, RadirL);
         strcpy(RdownloadListTmp->filename, Rfilename);
         RdownloadListTmp->sizeR = Rlocalstat.st_size;
         RgetHumanSize(RdownloadListTmp->sizeDisplayR, TdownloadsizeDisplayRLen, Rlocalstat.st_size);
         RgetHumanSize(RdownloadListTmp->sizeDisplayDownR, TdownloadsizeDisplayDownR, Rlocalstat.st_size);
         strcpy(RdownloadListTmp->percent, "0");
         RdownloadListTmp->active = 'X';
         RdownloadListTmp->delayRetry = RdefaultDelayRetry;
         RdownloadListTmp->nextRetry = 0;
         strcpy(RdownloadListTmp->username, Rusername);
         strcpy(RdownloadListTmp->password, Rpassword);
    }
    free(Rname);
    close(Rfilehandle);
  }

  int 
  RsmbDownloadDir(char *Rname)
  {
    struct dirent *Rdirent;
    int Rfilehandle;
    DIR *Rdirhandle;
    char *RnewName;
    struct stat Rlocalstat;
    TTdownload *RdownloadListTmp;
    char *RnameShort;
    int Rtym;
    char *RstrT1;
    
    Rdirhandle = opendir(to_sys(Rname));
    if (Rdirhandle == NULL) 
      return(-1);
    while((Rdirent = readdir(Rdirhandle))) 
    {
      RstrT1 = from_sys(Rdirent->d_name);
      if (RstrCmp(RstrT1, ".") || RstrCmp(RstrT1, "..")) 
         continue;
      asprintf(&RnewName, "%s/%s", Rname, RstrT1); 
      switch(Rdirent->d_type) 
      {
        case DT_DIR:
             RsmbDownloadDir(RnewName);
             break;
        default:
             asprintf(&RnameShort, "%s", RnewName);
             Rtym = strlen(RnameShort);
             if (Rtym > Rxs-4) Rtym = Rxs-4;
             RnameShort[Rtym] = 0;
             mvwhline(RwinAdd, 3, 1, ' ', Rxs-2); 
             mvwprintw(RwinAdd, 3, Rxs/2-strlen(RnameShort)/2, to_scr(RnameShort));
             wrefresh(RwinAdd);
             free(RnameShort);
             
             Rfilehandle = open(to_sys(RnewName), O_RDONLY, 0755);
             if (fstat(Rfilehandle, &Rlocalstat) >= 0) 
             {
               RdownloadListTmp = RgetdownloadListLast();
               if (RdownloadListTmp == NULL) 
               {
                 RdownloadListTmp = Rmalloc(sizeof(TTdownload));
                 RdownloadList = RdownloadListTmp;
                 RdownloadListTmp->RdownloadList = NULL; 
                 RdownloadListTmp->RdownloadListP = NULL; 
               }
               else 
               {
                 RdownloadListTmp->RdownloadList = Rmalloc(sizeof(TTdownload));
                 RdownloadListTmp->RdownloadList->RdownloadListP = RdownloadListTmp;
                 RdownloadListTmp = RdownloadListTmp->RdownloadList;
                 RdownloadListTmp->RdownloadList = NULL;
               }
               strcpy(RdownloadListTmp->groupnameR, Rworkgroup);
               strcpy(RdownloadListTmp->pathL, Radir);
               strcpy(RdownloadListTmp->pathR, Rname);
               RdownloadListTmp->upload = 'U';
               strcpy(RdownloadListTmp->pathRbase, RadirL);
               strcpy(RdownloadListTmp->filename, RstrT1);
               RdownloadListTmp->sizeR = Rlocalstat.st_size;
               RgetHumanSize(RdownloadListTmp->sizeDisplayR, TdownloadsizeDisplayRLen, Rlocalstat.st_size);
               RgetHumanSize(RdownloadListTmp->sizeDisplayDownR, TdownloadsizeDisplayDownR, Rlocalstat.st_size);
               strcpy(RdownloadListTmp->percent, "0");
               RdownloadListTmp->active = 'X';
               strcpy(RdownloadListTmp->username, Rusername);
               strcpy(RdownloadListTmp->password, Rpassword);
               Rsmbc_close(Rfilehandle);
             }
             break;
      }
      free(RnewName);
    }
    closedir(Rdirhandle);
    free(Rstr1);
    return 1;
  } 

  RwinAdd = newwin(Rys, Rxs, Ry/2-Rys/2, Rx/2-Rxs/2);
  box(RwinAdd, 0, 0);
  mvwprintw(RwinAdd, 1, Rxs/2-strlen(Rstr1)/2, to_scr(Rstr1));
  wrefresh(RwinAdd);

  if (Rtype == 'D') 
  {
    asprintf(&RnewNameR, "%s%s/", RadirL, Rfilename);
    RsmbDownloadDir(RnewNameR);
    free(RnewNameR);
  }
  else 
    RsmbDownloadFile(RadirL,Rfilename); 

  delwin(RwinAdd);
  return(0);
}

int 
Rreadline(register int fd, register char *ptr, register int maxlen) 
{
  int n, rc;
  char c; 
  
  for (n = 1; n < maxlen; n++) 
  {
    if ( (rc = read(fd, &c, 1)) == 1) 
    { 
      *ptr++ = c;
      if (c == '\n')
        break;
    } 
    else if (rc == 0) 
    { 
      if (n == 1)
        return(0);
      else    
        break;
    } 
    else  
      return(-1);
  }

  *ptr = 0;
  return(n);
}

void 
RreadRcfile()
{
  char *Rfile = NULL;
  int Rfd;
  char Rva[200], Rvl[200];
  char *Rvlp = NULL;
  char Rstr[1000];
  int RstrP;
  char Rtc[20];
  int RstrRvlp, RstrRva;
  int Rline = -1;
  TText *RextT = NULL;
  char Rclr[5];
  int Rwar;

  asprintf(&Rfile, "%s/.smbc/smbcrc", from_sys(getenv("HOME")));
  if (access(Rfile, F_OK) != 0) 
  {
    printf(Rm242, Rfile);
    printf(Rm243);
    printf(Rm244);
    return;
  }
  Rfd = open(Rfile, O_RDONLY);
  if (!Rfd) 
  {
    printf(Rm245, Rfile);
    exit(0);
  }
  while (Rreadline(Rfd, Rstr, sizeof(Rstr))) 
  {
    Rline++;
    RstrP = -1;
    Rva[0] = 0; Rvl[0] = 0;
    while (Rstr[++RstrP]) 
    {
       if (Rstr[RstrP] == ' ') 
       {
         memcpy(Rva, Rstr, RstrP); memcpy(Rva+RstrP, "\0", 1);
         memcpy(Rvl, Rstr+RstrP+1, strlen(Rstr)-RstrP-1);
         if (Rstr[strlen(Rstr)] == '\n') 
            memcpy(Rvl+strlen(Rstr)-RstrP-3, "\0", 1);
         else 
            memcpy(Rvl+strlen(Rstr)-RstrP-2, "\0", 1);
         if ((Rvl[0] == '"') && (Rvl[strlen(Rvl)-1] == '"')) 
         {
           Rvl[strlen(Rvl)-1] = 0;
           Rvlp = Rvl+1;
         }
         else 
           Rvlp = Rvl;
         break;
       }
    } 
    RstrRvlp = strlen(Rvlp);
    RstrRva = strlen(Rva);
    if ((RstrRva > 0) & (RstrRvlp > 0) & (Rva[0] != '#')) 
    {
      if (RstrCmp(Rva, "username")) strcpy(Rusername, Rvlp); 
      if (RstrCmp(Rva, "password")) strcpy(Rpassword, Rvlp); 
      if (RstrCmp(Rva, "localdir")) strcpy(RadirL, Rvlp); 
      if (RstrCmp(Rva, "workgroup")) strcpy(Ragroup, Rvlp); 
      if (RstrCmp(Rva, "host")) strcpy(Rahost, Rvlp); 
      if (RstrCmp(Rva, "smbclient")) strcpy(Rsmbclient, Rvlp); 

      if (RstrCmp(Rva, "share")) 
      {
        if (Rvlp[0] == '/') 
          memcpy(Radir, Rvlp+1, strlen(Rvlp)); 
        else  
          memcpy(Radir, Rvlp, strlen(Rvlp)+1); 
      }
      if (RstrCmp(Rva, "timeout")) Rtimeout = atoi(Rvlp)*1000; 
      if (RstrCmp(Rva, "indextime")) RindexTime = atoi(Rvlp); 
      if (RstrCmp(Rva, "typeofsort-left")) RsortMethodL = atoi(Rvlp); 
      if (RstrCmp(Rva, "typeofsort-right")) RsortMethodR = atoi(Rvlp); 
      if (RstrCmp(Rva, "reversesort-left")) RsortMethodL = atoi(Rvlp); 
      if (RstrCmp(Rva, "reversesort-right")) RsortMethodR = atoi(Rvlp); 
      if (RstrCmp(Rva, "group-left")) RgroupFilesDirectoriesL = atoi(Rvlp); 
      if (RstrCmp(Rva, "group-right")) RgroupFilesDirectoriesR = atoi(Rvlp); 
      if (RstrCmp(Rva, "char-convert")) RDoCharConvertSet(atoi(Rvlp)); 
      if (RstrCmp(Rva, "retry-delay-time")) RdefaultDelayRetry = atoi(Rvlp); 
      if (RstrCmp(Rva, "askquit")) Raskquit = atoi(Rvlp); 
      if (RstrCmp(Rva, "autoresume")) {
        if (RstrCmp(Rvlp, "enable")) RaskRetry = 0; 
        if (RstrCmp(Rvlp, "disable")) RaskRetry = 1; 
      }
      if (RstrCmp(Rva, "warningdiskisfull")) 
      {
        if (RstrCmp(Rvlp, "enable")) RaskRetryDiskFull = 1; 
        if (RstrCmp(Rvlp, "disable")) RaskRetryDiskFull = 0; 
      }

      if ((RstrRva == 6) & (RstrRvlp == 14)) 
      {
        memcpy(Rtc, Rva, 5); Rtc[5] = 0;
        if ((RstrCmp(Rtc, "color")) & (isdigit(Rva[5]) > 0)) 
        {
           Rwar = Rva[5]-48;
           if ((Rwar >= 0) & (Rwar <= 2)) 
           {
             Rclr[4] = 0;
             switch(Rwar) 
             {
               case 0 : Rcolor[Rwar].realnumber = 1;
                        break;
               case 1 : Rcolor[Rwar].realnumber = 4;
                        break;
               case 2 : Rcolor[Rwar].realnumber = 5;
                        break;
             }
             memcpy(Rclr, Rvlp, 4); Rcolor[Rwar].red = atoi(Rclr);
             memcpy(Rclr, Rvlp+5, 4); Rcolor[Rwar].green = atoi(Rclr);
             memcpy(Rclr, Rvlp+10, 4); Rcolor[Rwar].blue = atoi(Rclr);
           }
        }
      }
      if ((RstrRva == 9) & (RstrRvlp > 0) & (RstrRvlp <= 10)) 
      {
        memcpy(Rtc, Rva, 8); Rtc[8] = 0;
        if ((RstrCmp(Rtc, "extcolor")) & (isdigit(Rva[8]) > 0)) 
        {
           Rwar = Rva[8]-48;
           if ((Rwar >= 0) & (Rwar <= 2)) 
           {
             if (Rext == NULL) {
               Rext = Rmalloc(sizeof(TText));
               strcpy(Rext->ext, Rvlp);
               Rext->colornr = Rwar;
               Rext->Text = NULL; 
               RextT = Rext;
             }
             else 
             {
               RextT->Text = Rmalloc(sizeof(TText));
               RextT = RextT->Text;
               strcpy(RextT->ext, Rvlp);
               RextT->colornr = Rwar;
               RextT->Text = NULL;
             }
           }
        }
      }
   
    }
  }
  close(Rfd);
  free(Rfile);
}

void 
RremoveDir(char *Rdir)
{
  DIR *Rdirhandle;
  struct dirent *Rdirent;
  char *RnewName;
  WINDOW *Rdwin;
  int Rys = 7;
  int Rxs = 60;
  int RstrS = 0;
  char *RstrT1, *RstrT2;

  Rdwin = newwin(Rys,Rxs,Ry/2-Rys/2,Rx/2-Rxs/2);
  box(Rdwin,0,0);
  mvwprintw(Rdwin, 2, Rxs/2-strlen(Rm119)/2, Rm119);
  wrefresh(Rdwin);
  Rdirhandle = opendir(to_sys(Rdir));
  while ((Rdirent = readdir(Rdirhandle))) 
  {
     RstrT2 = from_sys(Rdirent->d_name);
     if (RstrCmp(RstrT2, ".") || RstrCmp(RstrT2, "..")) 
       continue;
     asprintf(&RnewName, "%s/%s", Rdir, RstrT2);
     mvwhline(Rdwin, 4, 1, ' ', Rxs-2);
     if (strlen(RnewName) > Rxs-2) 
       RstrS = strlen(RnewName)-(Rxs-2);
     RstrT1 = to_scr(RnewName+RstrS);
     mvwprintw(Rdwin, 4, Rxs/2-strlen(RstrT1)/2, RstrT1); 
     wrefresh(Rdwin);
     switch(Rdirent->d_type) 
     {
       case DT_DIR : RremoveDir(RnewName);
                     break;
       default     : unlink(RnewName);
                     break;
     }
     free(RnewName);
  }
  closedir(Rdirhandle);
  rmdir(Rdir);
}

int 
RremoveDirR(char *Rdir)
{
  int Rdirhandle;
  struct smbc_dirent *Rdirent;
  char *RnewName, *Rstr;
  int Rstat = 0;
  WINDOW *Rdwin;
  int Rys = 7;
  int Rxs = 60;
  int RstrS = 0;
  char *RstrT1;

  Rdwin = newwin(Rys,Rxs,Ry/2-Rys/2,Rx/2-Rxs/2);
  box(Rdwin,0,0);
  mvwprintw(Rdwin, 2, Rxs/2-strlen(Rm119)/2, Rm119);
  wrefresh(Rdwin);
  if (Rdir[strlen(Rdir)-1] == '/') 
    asprintf(&Rstr, "%s", Rdir);
  else 
    asprintf(&Rstr, "%s/", Rdir);
  Rdirhandle = Rsmbc_opendir(Rstr);
  while ((Rdirent = Rsmbc_readdir(Rdirhandle))) 
  {
    if (RstrCmp(Rdirent->name, ".") || RstrCmp(Rdirent->name, "..")) 
      continue;
    asprintf(&RnewName, "%s%s", Rstr, Rdirent->name);
    mvwhline(Rdwin, 4, 1, ' ', Rxs-2);
    if (strlen(RnewName+4) > Rxs-2) 
      RstrS = strlen(RnewName+4)-(Rxs-2);
    RstrT1 = to_scr(RnewName+RstrS+4);
    mvwprintw(Rdwin, 4, Rxs/2-strlen(RstrT1)/2, RstrT1); wrefresh(Rdwin);
    switch(Rdirent->smbc_type) 
    {
       case SMBC_DIR : Rstat = RremoveDirR(RnewName);
                       break;
       default       : Rstat = Rsmbc_unlink(RnewName);
                       break;
     }
     free(RnewName);
  
  }
  Rsmbc_closedir(Rdirhandle);
  Rstat = Rsmbc_rmdir(Rdir);
  free(Rstr);
  return(Rstat);
}

void 
RopenSaveDownloadList(int Rnr)  
{
  #define RdufileName2Len 1000
  char *Rfile = NULL;
  char *Rdir = NULL;
  int Rfhandle;
  TTdownload *Rdls;
  int RdlsSize = sizeof(TTdownload);
  DIR *Rdhandle;
  struct dirent *Rsdirent;
  int RdufileNr = 0;
  int RfindF = 1;
  int RfindF2 = 1;
  char RdufileName[1000];
  char RdufileName2[RdufileName2Len];

  RDBG("smbc: RopenSaveDownloadList start\n");
  asprintf(&Rdir, "%s/.smbc/", from_sys(getenv("HOME")));
  mkdir(Rdir, 0755);
  RDBG("smbc: RopenSaveDownloadList 1\n");
  if (Rnr) 
  {         // read
    Rdhandle = opendir(Rdir);
    if (Rdhandle != NULL) 
    {
      RfindF = 1;
      while (RfindF) 
      {
        Rsdirent = readdir(Rdhandle);
        if (Rsdirent > 0) 
        {
          if (strlen(Rsdirent->d_name) >= 6) 
            if (RstrCmpIncludeFirst(Rsdirent->d_name, "dulist")) 
            {
              sprintf(RdufileName, "%s/.smbc/%s", from_sys(getenv("HOME")),Rsdirent->d_name);
              RfindF = 0;
            }
        }
        else 
          RfindF = 0; 
      }
      closedir(Rdhandle);
    }
    RdownloadList = NULL;
    if (RdufileName != NULL) 
    {
      Rfhandle = open(RdufileName, O_NONBLOCK | O_RDONLY, 0755);
      Rdls = Rmalloc(RdlsSize); 
      while (read(Rfhandle, Rdls, RdlsSize) == RdlsSize) 
      {
        if (RdownloadList == NULL) 
        {
          RdownloadList = Rmalloc(RdlsSize);
          memcpy(RdownloadList, Rdls, RdlsSize);
          RdownloadList->RdownloadList = NULL;
          RdownloadList->RdownloadListP = NULL;
        } 
        else 
        {
          RdownloadList->RdownloadList = Rmalloc(RdlsSize);
          memcpy(RdownloadList->RdownloadList, Rdls, RdlsSize);
          RdownloadList->RdownloadList->RdownloadListP = RdownloadList;
          RdownloadList->RdownloadList->RdownloadList = NULL;
          RdownloadList = RdownloadList->RdownloadList;
        }
      }
      RdownloadList = RgetdownloadListFirst();
      close(Rfhandle);
      unlink(RdufileName);
      free(Rdls);
      free(Rfile);
    }
  } 
  else 
  {           // write
    Rdls = RgetdownloadListFirst();
    RDBG("smbc : RopenSaveDownloadList Rdls == "); RDBGi((int)Rdls); RDBG("\n");
    if (Rdls != NULL) 
    {
      RfindF = 1;
      RdufileNr = 0;
      while (RfindF) 
      {
         sprintf(RdufileName, "%s%s", from_sys(getenv("HOME")), "/.smbc/");
         memcpy(RdufileName2, "dulist", 7);
         itoa(RdufileName2+strlen(RdufileName2), RdufileName2Len-strlen(RdufileName2), RdufileNr);
         strcpy(RdufileName+strlen(RdufileName), RdufileName2);
         RfindF2 = 1;
         Rdhandle = opendir(Rdir);
         while (RfindF2) 
         {
           Rsdirent = readdir(Rdhandle);
           if (Rsdirent > 0) 
           {
             if (RstrCmp(Rsdirent->d_name, RdufileName2)) 
             {
                RfindF2 = 0;
                RfindF = 1;
             }
           } 
           else 
           {
             RfindF2 = 0;
             RfindF = 0;
           }
         }
         closedir(Rdhandle);
         RdufileNr++;
      }
      Rfhandle = open(RdufileName, O_CREAT | O_NONBLOCK | O_WRONLY | O_TRUNC, 0644);
      while (Rdls) 
      {
        if (write(Rfhandle, Rdls, RdlsSize) != RdlsSize) 
        {
           printf(Rm129);
           exit(0);
        };
        Rdls = Rdls->RdownloadList;
      }
      close(Rfhandle);
    }
  }
  free(Rdir);
  RDBG("smbc: RopenSaveDownloadList finished\n");
}

int 
RsetManualyLocation(int Rsel,char *group, char *host, char *dir, char *user, char *pass)
{
  WINDOW *RwinMsg;
  int Rys, Rxs;
  int Rkey, Rii;
  char *Rmsg1;
  char *Rstrt; 
  int Rrol = 3;
  int Rxb = 0;
  char Rtgroup[RMAXGHLEN], Rthost[RMAXGHLEN], Rtdir[RMAXDIRLEN], Rtuser[RMAXGHLEN], Rtpass[RMAXGHLEN];
  char Rttgroup[RMAXGHLEN], Rtthost[RMAXGHLEN], Rttdir[RMAXDIRLEN], Rttuser[RMAXGHLEN], Rttpass[RMAXGHLEN];

  int Rdx = 0;
  int Rctrlp, Rin1, Rin2, Rfirst;
  int RmaxX;

  void Rrefresh(int Rmax, int Rsel)
  {
    int Ri;
    int Rall = strlen(Rm136)+strlen(Rm137);

    strcpy(Rttgroup, Rtgroup); 
    if (strlen(Rttgroup) > Rmax) 
      Rttgroup[Rmax] = 0;

    strcpy(Rtthost, Rthost); 
    if (strlen(Rtthost) > Rmax) 
      Rtthost[Rmax] = 0;

    strcpy(Rttdir, Rtdir); 
    if (strlen(Rttdir) > Rmax) 
      Rttdir[Rmax] = 0;

    strcpy(Rttuser, Rtuser); 
    if (strlen(Rttuser) > Rmax) 
      Rttuser[Rmax] = 0;

    for (Ri = 0; Ri<strlen(Rtpass); Ri++) 
      Rttpass[Ri] = '*'; 
    Rttpass[Ri] = 0;

    if (strlen(Rttpass) > Rmax) 
      Rttpass[Rmax] = 0;

    wattron(RwinMsg, COLOR_PAIR(2)); 
    mvwhline(RwinMsg, 3, Rdx+1, 32, Rxs-Rdx-3); 
      mvwprintw(RwinMsg, 3, Rdx+1, Rttgroup);
    mvwhline(RwinMsg, 4, Rdx+1, 32, Rxs-Rdx-3); 
      mvwprintw(RwinMsg, 4, Rdx+1, Rtthost);
    mvwhline(RwinMsg, 5, Rdx+1, 32, Rxs-Rdx-3); 
      mvwprintw(RwinMsg, 5, Rdx+1, Rttdir);
    mvwhline(RwinMsg, 6, Rdx+1, 32, Rxs-Rdx-3); 
      mvwprintw(RwinMsg, 6, Rdx+1, Rttuser);
    mvwhline(RwinMsg, 7, Rdx+1, 32, Rxs-Rdx-3); 
      mvwprintw(RwinMsg, 7, Rdx+1, Rttpass);
    wattroff(RwinMsg, COLOR_PAIR(2)); 
    switch (Rsel) 
    {
       case 1 : Rii = (Rxs-Rall)/2; 
                  mvwprintw(RwinMsg, Rys-2, Rii, "%s", Rm136);
                Rii = (Rxs-Rall)/2+strlen(Rm136)+1; 
                  wattron(RwinMsg, COLOR_PAIR(1)); 
                  mvwprintw(RwinMsg, Rys-2, Rii, "%s", Rm137); 
                  wattroff(RwinMsg, COLOR_PAIR(1)); 
                break;
       case 2 : Rii = (Rxs-Rall)/2; 
                  wattron(RwinMsg, COLOR_PAIR(1)); 
                  mvwprintw(RwinMsg, Rys-2, Rii, "%s", Rm136); 
                  wattroff(RwinMsg, COLOR_PAIR(1)); 
                Rii = (Rxs-Rall)/2+strlen(Rm136)+1; 
                  mvwprintw(RwinMsg, Rys-2, Rii, "%s", Rm137);
                break;
       case 3 : Rii = (Rxs-Rall)/2; 
                  mvwprintw(RwinMsg, Rys-2, Rii, "%s", Rm136);
                Rii = (Rxs-Rall)/2+strlen(Rm136)+1; 
                  mvwprintw(RwinMsg, Rys-2, Rii, "%s", Rm137);
                break;
    } 
  }

  //RwinRedrawWithData(); return(0);

  if (Rdx < strlen(Rm131)) 
    Rdx = strlen(Rm131)+2;

  if (Rdx < strlen(Rm168)) 
    Rdx = strlen(Rm168)+2;

  if (Rdx < strlen(Rm133)) 
    Rdx = strlen(Rm133)+2;

  if (Rdx < strlen(Rm134)) 
    Rdx = strlen(Rm134)+2;

  if (Rdx < strlen(Rm135)) 
    Rdx = strlen(Rm135)+2;

  strcpy(Rtgroup,group); 
  strcpy(Rthost,host); 

  if (strlen(dir) > 6) 
    memcpy(Rtdir, dir+strlen(Rthost)+6,strlen(dir)-strlen(Rthost)-5); 
  else 
    Rtdir[0] = 0;

  strcpy(Rtuser, user); 
  strcpy(Rtpass, pass); 

  Rys = 12; Rxs = 60;
  Rxb = Rxs/2+Rdx-3;
  RwinMsg = newwin(Rys,Rxs,Ry/2-Rys/2,Rx/2-Rxs/2);
  box(RwinMsg,0,0);

  asprintf(&Rmsg1, Rm138); 
  Rii = Rxs/2-strlen(Rm131)/2; 
  mvwprintw(RwinMsg, 1, Rii, "%s",Rmsg1); 
  free(Rmsg1);

  Rii = Rdx-strlen(Rm131); 
    mvwprintw(RwinMsg, 3, Rii, "%s", Rm131);
  Rii = Rdx-strlen(Rm168); 
    mvwprintw(RwinMsg, 4, Rii, "%s", Rm168);
  Rii = Rdx-strlen(Rm133); 
    mvwprintw(RwinMsg, 5, Rii, "%s", Rm133);
  Rii = Rdx-strlen(Rm134); 
    mvwprintw(RwinMsg, 6, Rii, "%s", Rm134);
  Rii = Rdx-strlen(Rm135); 
    mvwprintw(RwinMsg, 7, Rii, "%s", Rm135);

  Rii = 0; 
  Rrefresh(Rxb, Rrol);

  RmaxX = Rxs-Rdx-3;
  wrefresh(RwinMsg);
  nodelay(RwinMsg, 1);
  RactiveWindow = RwinMsg;
  RDBG("smbc : RsetManualyLocation RactiveWindow = RwinMsg  2\n");
  while (Rrol) {
    RtryDownloadUpload();
    if (Rrol == 3) 
    {
      Rin1 = 0; Rin2 = 0; Rfirst = 1;
      while (readlineOneCharNoDelay(RwinMsg, 3, Rdx+1, Rtgroup, RMAXGHLEN, RmaxX, 3, &Rctrlp, 1, &Rin1, &Rin2, &Rfirst) <= 0) 
        RtryDownloadUpload();
      Rrefresh(RmaxX, Rrol);
      Rin1 = 0; Rin2 = 0; Rfirst = 1;
      while (readlineOneCharNoDelay(RwinMsg, 4, Rdx+1, Rthost, RMAXGHLEN, RmaxX, 3, &Rctrlp, 1, &Rin1, &Rin2, &Rfirst) <= 0) 
        RtryDownloadUpload();
      Rrefresh(RmaxX, Rrol);
      Rin1 = 0; Rin2 = 0; Rfirst = 1;
      while (readlineOneCharNoDelay(RwinMsg, 5, Rdx+1, Rtdir, RMAXDIRLEN, RmaxX, 3, &Rctrlp, 1, &Rin1, &Rin2, &Rfirst) <= 0) 
        RtryDownloadUpload();
      Rrefresh(RmaxX, Rrol);
      Rin1 = 0; Rin2 = 0; Rfirst = 1;
      while (readlineOneCharNoDelay(RwinMsg, 6, Rdx+1, Rtuser, RMAXGHLEN, RmaxX, 3, &Rctrlp, 1, &Rin1, &Rin2, &Rfirst) <= 0) 
        RtryDownloadUpload();
      Rrefresh(RmaxX, Rrol);
      Rin1 = 0; Rin2 = 0; 
      Rfirst = 3; // first and password mode
      while (readlineOneCharNoDelay(RwinMsg, 7, Rdx+1, Rtpass, RMAXGHLEN, RmaxX, 3, &Rctrlp, 1, &Rin1, &Rin2, &Rfirst) <= 0) 
        RtryDownloadUpload();

      Rrefresh(RmaxX, --Rrol);
    } 
    else 
    {
      Rkey = mvwgetch(RwinMsg, 1,1);
      if (Rkey == 9) 
      {
        if ((--Rrol) == 0) 
          Rrol = 3;
        Rrefresh(RmaxX, Rrol);
      }
      if (Rkey == 10) 
      {
        if (Rrol == 2) 
        {
          strcpy(group, Rtgroup);
          strcpy(host, Rthost);

            if (Rtdir[0] == '/') 
              asprintf(&Rstrt, "smb://%s%s", Rahost, Rtdir);
            else 
              asprintf(&Rstrt, "smb://%s/%s", Rahost, Rtdir);
            memcpy(dir, Rstrt, strlen(Rstrt)+1);
            if (dir[strlen(dir)-1] != '/') 
            { 
              dir[strlen(dir)] = '/'; 
              dir[strlen(dir)+1] = 0; 
            }
            free(Rstrt);
          strcpy(user, Rtuser);
          strcpy(pass, Rtpass);
          delwin(RwinMsg);
          RwinRedrawWithData();
          return(1);
        }
        else 
          Rrol = 0;
      }
      if (Rkey == 'q') 
        Rrol = 0;
    }
  } 
  delwin(RwinMsg); 
  RwinRedrawWithData();
  return(0);
}

int 
RcreateDir(int select, char *Rpath)
{
  int Rys, Rxs;
  WINDOW *RwinMsg;
  const int MAXSTR = 100;
  char RdirT[MAXSTR];
  int Rrol = 3;
  char *Rstr;
  char Rkey;
  int Rin1 = 0;
  int Rin2 = 0;
  int Rfirst = 1;
  int Rctrlp;


  void 
  Rrefresh(int Rsel)
  {
    int Rall = strlen(Rm136)+strlen(Rm137);
    char *RdirTt;

    wattron(RwinMsg, COLOR_PAIR(2));
    mvwhline(RwinMsg, 3, 3, ' ', Rxs-6); 

    RdirTt = strdup(RdirT);
    if (strlen(RdirTt) > Rxs-6) 
      RdirTt[Rxs-6] = 0;
    mvwprintw(RwinMsg, 3, 3, RdirTt);

    free(RdirTt);
    wattroff(RwinMsg, COLOR_PAIR(2));
    switch(Rsel) {
      case 1 : mvwprintw(RwinMsg, Rys-2, (Rxs-Rall)/2, "%s", Rm136);
               wattron(RwinMsg, COLOR_PAIR(1)); 
               mvwprintw(RwinMsg, Rys-2, (Rxs-Rall)/2+strlen(Rm136)+1, "%s", Rm137); 
               wattroff(RwinMsg, COLOR_PAIR(1)); 
               break;
      case 2 : wattron(RwinMsg, COLOR_PAIR(1)); 
               mvwprintw(RwinMsg, Rys-2, (Rxs-Rall)/2, "%s", Rm136); 
               wattroff(RwinMsg, COLOR_PAIR(1)); 
               mvwprintw(RwinMsg, Rys-2, (Rxs-Rall)/2+strlen(Rm136)+1, "%s", Rm137);
               break;
      case 3 : mvwprintw(RwinMsg, Rys-2, (Rxs-Rall)/2, "%s", Rm136);
               mvwprintw(RwinMsg, Rys-2, (Rxs-Rall)/2+strlen(Rm136)+1, "%s", Rm137);
               break;
    }
  }

  RdirT[0] = 0;
  Rys = 8; Rxs = 50;
  RwinMsg = newwin(Rys, Rxs, Ry/2-Rys/2, Rx/2-Rxs/2);
  box(RwinMsg,0,0);

  asprintf(&Rstr, Rm139); 
  mvwprintw(RwinMsg, 1, Rxs/2-strlen(Rstr)/2, Rstr); 
  free(Rstr);

  Rrefresh(Rrol);
  nodelay(RwinMsg, 1);
  RactiveWindow = RwinMsg;
  RDBG("smbc : RcreateDir RactiveWindow = RwinMsg  2\n");
  while (Rrol) 
  {
    RtryDownloadUpload();
    if (Rrol == 3) 
    {
      Rfirst = 1;
      Rin1 = 0;
      Rin2 = 0;
      while (readlineOneCharNoDelay(RwinMsg, 3, 3, RdirT, MAXSTR, Rxs-6, 3, &Rctrlp, 1, &Rin1, &Rin2, &Rfirst) <= 0) 
        RtryDownloadUpload();
      Rrefresh(--Rrol);
    }
    Rkey = mvwgetch(RwinMsg,1,1);
    if (Rkey == 9) 
    {
      if ((--Rrol) == 0) Rrol = 3;
      Rrefresh(Rrol);
    }
    if (Rkey == 10) 
    {
      if (Rrol == 2) 
      {
        asprintf(&Rstr, "%s/%s", Rpath, RdirT);
        if (select) 
          Rsmbc_mkdir(Rstr, 0755);
        else 
          mkdir(Rstr, 0755);
        free(Rstr);
        delwin(RwinMsg);
        RwinRedrawWithData();
        return(0);
      } 
      else 
        Rrol = 0;
    }
    if (Rkey == 'q') 
      Rrol = 0;
  }
  delwin(RwinMsg);
  RwinRedrawWithData();
  return(0);
}

//
// ------------------- RmanageFindFile START ------------------------
//
int 
RmanageFindFile(char *RfindStr, char *group, char *host, char *dir, char *SelectFile, TTfind *RidxNet, int Rcount)
{
  WINDOW *RwinList = NULL;
  WINDOW *RwinTop = NULL;
  WINDOW *RwinWorkgroup = NULL;
  WINDOW *RwinHost = NULL;
  WINDOW *RwinDir = NULL;
  WINDOW *RwinFilename = NULL;
  WINDOW *RwinStatus = NULL;

  int Rkey, Rsel, RmaxY, Rx6;
  int RxWorkgroup, RxHostname, RxDir, RxFilename;
  int RxFilenameLen = 0;
  int RlFirst = 1;
  int RlSelect = 1;
  TTfind RfindIndex;
  char *Rmsg1;
  int RtxtStartX = 10;
  char Rttgroup[RMAXGHLEN], Rtthost[RMAXGHLEN], Rttdir[2000], Rttfilename[RMAXGHLEN];
  char Rtgroup[RMAXGHLEN], Rthost[RMAXGHLEN], Rtdir[2000], Rtfilename[RMAXGHLEN];
  int Rrol = 1;
  int FindListCount;
  int ret = 0;
  int Rt = 0;
  int Rctrlp = 1;
  int RctrlpPrim = Rctrlp;
  TTindexTable *Ridx = NULL;
  int Rin11  = 0;
  int Rin12  = 0;
  int Rin21  = 0;
  int Rin22  = 0;
  int Rin31  = 0;
  int Rin32  = 0;
  int Rin41  = 0;
  int Rin42  = 0;
  int Rfirst = 1;
  char *RstrT;
  int Rtl, Rtl2;

  void 
  RpaintTop(int RnoDraw)
  {
    int RmaxT = Rx-RtxtStartX-4;

    wattron(RwinTop, COLOR_PAIR(2));
    if (RnoDraw != 1) 
      mvwhline(RwinTop, 0, RtxtStartX+1, 32, RmaxT);
    if (RnoDraw != 2) 
      mvwhline(RwinTop, 1, RtxtStartX+1, 32, RmaxT);
    if (RnoDraw != 3) 
      mvwhline(RwinTop, 2, RtxtStartX+1, 32, RmaxT);
    if (RnoDraw != 4) 
      mvwhline(RwinTop, 3, RtxtStartX+1, 32, RmaxT);

    RstrT = to_scr(Rtgroup); 
    strcpy(Rttgroup, RstrT); 
    if (strlen(Rttgroup) > RmaxT) 
      Rttgroup[RmaxT] = 0;

    RstrT = to_scr(Rthost); 
    strcpy(Rtthost, RstrT); 
    if (strlen(Rtthost) > RmaxT) 
      Rtthost[RmaxT] = 0;

    RstrT = to_scr(Rtdir); 
    strcpy(Rttdir, RstrT); 
    if (strlen(Rttdir) > RmaxT) 
      Rttdir[RmaxT] = 0;

    RstrT = to_scr(Rtfilename); 
    strcpy(Rttfilename, RstrT); 
    if (strlen(Rttfilename) > RmaxT)
      Rttfilename[RmaxT] = 0;

    if (RnoDraw != 1) 
      mvwprintw(RwinTop, 0, RtxtStartX+1, Rttgroup);
    if (RnoDraw != 2) 
      mvwprintw(RwinTop, 1, RtxtStartX+1, Rtthost);
    if (RnoDraw != 3) 
      mvwprintw(RwinTop, 2, RtxtStartX+1, Rttdir);
    if (RnoDraw != 4) 
      mvwprintw(RwinTop, 3, RtxtStartX+1, Rttfilename);
    wattroff(RwinTop, COLOR_PAIR(2));
    wrefresh(RwinTop);
  }

  void 
  RpaintList(int Rfirst, int Rselect)    // Rfirst and Rselect - position in IDX not on to index file
  {
    int Rlast, Ri, Rii;
    int Rk = 0;
    TTfind RfindIndex;
    char *Rstr;
    int Ritmp;
    int RfilePos;
    TTfind *RidxWork = RidxNet;
    TTindexTable *RidxSmallWork = Ridx;

    RDBG("smbc: RpaintList start\n");
    Ritmp = RgetCountRecordIndexTable(RidxSmallWork);
    RDBG("smbc: RpaintList Ritmp = "); RDBGi(Ritmp); RDBG("\n");
    if ((Rfirst == 1) & (Ritmp <= Ry-13)) 
      Rlast = Ritmp;
    else 
      Rlast = Rfirst + Ry-13;

    RDBG("smbc: RpaintList Rfirst = "); RDBGi(Rfirst);
    RDBG(" Rlast = "); RDBGi(Rlast); RDBG("\n");
    if (RgotoNIndextTable(&RidxSmallWork,Rfirst)) 
    {
      RindexNetSetSeek(&RidxWork, RidxSmallWork->number);
      RfilePos = RidxSmallWork->number;

      mvwhline(RwinStatus, 0, 0, 32, Rx-2);
      wrefresh(RwinStatus);

      RDBG("smbc: RpaintList Rfirst: "); RDBGi(Rfirst);
      RDBG(" Rlast: "); RDBGi(Rlast); 
      RDBG(" Rselected: "); RDBGi(Rselected); 
      RDBG("\n");
      for (Ri = Rfirst; Ri <= Rlast;) 
      {
        RindexNetReadOneRecord(&RidxWork, &RfindIndex); RfilePos++;
        RDBG("smbc: RpaintList RfilePos = "); RDBGi(RfilePos);
        RDBG(" Ridx->number = "); RDBGi(RidxSmallWork->number); RDBG("\n");
        for (Rii = RfilePos; Rii <= RidxSmallWork->number; Rii++) 
        {
          RDBG("smbc: RpaintList must read one record : ");
          RDBGi(Rii); RDBG("\n");
          RindexNetReadOneRecord(&RidxWork, &RfindIndex);
          RfilePos++;
        }
        RgotoNextIndexTable(&RidxSmallWork);

        mvwhline(RwinWorkgroup, Rk, 0, 32, RxHostname-1);
        mvwhline(RwinHost, Rk, 0, 32, RxDir-RxHostname-1);
        mvwhline(RwinDir, Rk, 0, 32, RxFilename-RxDir-1);
        mvwhline(RwinFilename, Rk, 0, 32, Rx-RxFilename-2);

        if ((Ri == Rselect)) 
        {
          asprintf(&Rstr, "//%s/%s/%s", RfindIndex.host, RfindIndex.dir, RfindIndex.file);
          if (strlen(Rstr) > Rx-2) 
            Rstr[Rx-2] = 0;
          if (strlen(Rstr) > 4) 
            mvwprintw(RwinStatus, 0, 0, to_scr(Rstr));
          wrefresh(RwinStatus);
          free(Rstr);
        }
  
        if ((Ri == Rselect) && (Rrol == 2)) 
        {
          wattron(RwinWorkgroup, COLOR_PAIR(1));
          wattron(RwinHost, COLOR_PAIR(1));
          wattron(RwinDir, COLOR_PAIR(1));
          wattron(RwinFilename, COLOR_PAIR(1));
        
          mvwhline(RwinWorkgroup, Rk, 0, 32, RxHostname-1);
          mvwhline(RwinHost, Rk, 0, 32, RxDir-RxHostname-1);
          mvwhline(RwinDir, Rk, 0, 32, RxFilename-RxDir-1);
          mvwhline(RwinFilename, Rk, 0, 32, Rx-RxFilename-2);
        }
 
        if (strlen(RfindIndex.group) > RxHostname-1) 
          RfindIndex.group[RxHostname-1] = 0;
        if (strlen(RfindIndex.host) > RxDir-RxHostname-1) 
          RfindIndex.host[RxDir-RxHostname-1] = 0;
        if (strlen(RfindIndex.dir) > RxFilename-RxDir-1) 
          RfindIndex.dir[RxFilename-RxDir-1] = 0;
        if (strlen(RfindIndex.file) > Rx-RxFilename-2) 
          RfindIndex.file[Rx-RxFilename-2] = 0;

        mvwprintw(RwinWorkgroup, Rk, 0, to_scr(RfindIndex.group));
        mvwprintw(RwinHost, Rk, 0, to_scr(RfindIndex.host));
        mvwprintw(RwinDir, Rk, 0, to_scr(RfindIndex.dir));
        mvwprintw(RwinFilename, Rk, 0, to_scr(RfindIndex.file));

        if ((Ri == Rselect) && (Rrol == 2)) 
        {
          wattroff(RwinWorkgroup, COLOR_PAIR(1));
          wattroff(RwinHost, COLOR_PAIR(1));
          wattroff(RwinDir, COLOR_PAIR(1));
          wattroff(RwinFilename, COLOR_PAIR(1));
        }
        Ri++;
        Rk++;
      }
    }
    for (Ri = Rk; Ri < Ry-11; Ri++) 
    {
      mvwhline(RwinWorkgroup, Ri, 0, 32, RxHostname-1);
      mvwhline(RwinHost, Ri, 0, 32, RxDir-RxHostname-1);
      mvwhline(RwinDir, Ri, 0, 32, RxFilename-RxDir-1);
      mvwhline(RwinFilename, Ri, 0, 32, Rx-RxFilename-2);
    }
    wrefresh(RwinWorkgroup);
    wrefresh(RwinHost);
    wrefresh(RwinDir);
    wrefresh(RwinFilename);
    RDBG("\nsmbc: RpaintList finished\n");
  }

  void 
  RfindFileFromIndex()
  {
    int RidxNr = 1;
    TTfind *RidxNetWork = RidxNet;

    char Rtttgroup[RMAXGHLEN], Rttthost[RMAXGHLEN], Rtttdir[2000], Rtttfilename[RMAXGHLEN];
    char Rttttgroup[RMAXGHLEN], Rtttthost[RMAXGHLEN], Rttttdir[2000], Rttttfilename[RMAXGHLEN];
    int Rfind;

    RDBG("smbc: RfindFileFromIndex start\n");
    RlFirst = 1;
    RlSelect = 1;
    RstrToUpperCopy(Rttttgroup, Rtgroup);
    RstrToUpperCopy(Rtttthost, Rthost);
    RstrToUpperCopy(Rttttdir, Rtdir);
    RstrToUpperCopy(Rttttfilename, Rtfilename);

    RindexNetSetSeek(&RidxNetWork, 1);
    RfreeAllRecordFromIndexTable(&Ridx);
    while (RindexNetReadOneRecord(&RidxNetWork, &RfindIndex)) 
    {
      RstrToUpperCopy(Rtttgroup, RfindIndex.group); 
      RstrToUpperCopy(Rttthost, RfindIndex.host); 
      RstrToUpperCopy(Rtttdir, RfindIndex.dir); 
      RstrToUpperCopy(Rtttfilename, RfindIndex.file); 

      Rfind = 1;

      if (strlen(Rttttgroup))    
        if (!strstr(Rtttgroup, Rttttgroup)) 
          Rfind = 0;

      if (strlen(Rtttthost)) 
        if (!strstr(Rttthost, Rtttthost)) 
          Rfind = 0;

      if (strlen(Rttttdir)) 
        if (!strstr(Rtttdir, Rttttdir)) 
          Rfind = 0;

      if (strlen(Rttttfilename)) 
        if (!strstr(Rtttfilename, Rttttfilename)) 
          Rfind = 0; 
     
      if (Rfind) 
        RcreateNewRecordInIndexTable(&Ridx, RidxNr);
      RidxNr++;
    }
    RDBG("smbc: RfindFileFromIndex finished\n");
  }

  void 
  RrefreshR(int RnoDraw)
  {
     RpaintTop(RnoDraw);
     if ((Rt != 2) && (Rctrlp))
       RfindFileFromIndex();
     RpaintList(RlFirst, RlSelect);
  }

  void 
  RcreateFindFileWindow()
  {
    TTfind *RidxNetWork = RidxNet;

    if (RwinList) 
      delwin(RwinList);

    if (RwinTop) 
      delwin(RwinTop);

    if (RwinWorkgroup) 
      delwin(RwinWorkgroup);

    if (RwinHost) 
      delwin(RwinHost);

    if (RwinDir) 
      delwin(RwinDir);

    if (RwinFilename) 
      delwin(RwinFilename);

    if (RwinStatus) 
      delwin(RwinStatus);
    
    RwinList = newwin(Ry-2, Rx, 1, 0);
    RwinTop = newwin(4, Rx-2, 2, 1);
    getmaxyx(RwinMain, RmaxY, Rsel);
    if (Rx6 > Rsel-18) Rx6 = Rsel-10;
    
    box(RwinList,0,0);
    RxWorkgroup = 1;
    RxHostname = 15;
    RxDir = 30;
    RindexNetSetSeek(&RidxNetWork, 1);
    while (RindexNetReadOneRecord(&RidxNetWork, &RfindIndex)) 
    {
      if ((RxFilenameLen < strlen(RfindIndex.file)) & (RxFilenameLen < 20))
        RxFilenameLen = strlen(RfindIndex.file);
    }
    RxFilename = Rx-2-RxFilenameLen;

    RwinWorkgroup = newwin(Ry-13, RxHostname-1 , 9 , 1);
    RwinHost = newwin(Ry-13, RxDir-RxHostname-1, 9, RxHostname+1);
    RwinDir = newwin(Ry-13, RxFilename-RxDir-1, 9, RxDir+1);
    RwinFilename = newwin(Ry-13, Rx-RxFilename-2, 9, RxFilename+1);
    RwinStatus = newwin(1, Rx-2, Ry-3, 1);

    mvwprintw(RwinList, 6, RxWorkgroup, Rm140);
    mvwprintw(RwinList, 6, RxHostname+1, Rm141);
    mvwprintw(RwinList, 6, RxDir+1, Rm142);
    mvwprintw(RwinList, 6, RxFilename+1, Rm143);
    mvwvline(RwinList, 6, RxHostname, 0, Ry-11);
    mvwvline(RwinList, 6, RxDir, 0, Ry-11);
    mvwvline(RwinList, 6, RxFilename, 0, Ry-11);
    mvwhline(RwinList, 5, 1, 0, Rx-2);
    mvwhline(RwinList, 7, 1, 0, Rx-2);
    mvwhline(RwinList, Ry-5, 1, 0, Rx-2);
    wrefresh(RwinList);
    mvwprintw(RwinTop, 0, RtxtStartX-strlen(Rm144), Rm144);
    mvwprintw(RwinTop, 1, RtxtStartX-strlen(Rm145), Rm145);
    mvwprintw(RwinTop, 2, RtxtStartX-strlen(Rm146), Rm146);
    mvwprintw(RwinTop, 3, RtxtStartX-strlen(Rm147), Rm147);
    wrefresh(RwinTop);
  
    keypad(RwinList, TRUE);
    nodelay(RwinList, 1);
    RactiveWindow = RwinList;
    RDBG("smbc : RmanageFindFile RactiveWindow = RwinList  2\n");
  }

  void 
  RresizeFindFile(int RnoDraw)
  {
    if (RdoResizeFind) {
      RdoResizeFind = 0;
      RdoWindowResize();
      RcreateFindFileWindow();
      RrefreshR(RnoDraw);
    }
  }

  int 
  RdetectAndPaintStatusCtrlp()
  {
    if (Rctrlp == 2) {
      delwin(RwinList);
      delwin(RwinTop);
      delwin(RwinWorkgroup);
      delwin(RwinHost);
      delwin(RwinDir);
      delwin(RwinFilename);
      delwin(RwinStatus);
      return(1);
    }
    if (RctrlpPrim != Rctrlp) 
    {
      RstatusBar(21+Rctrlp);
      RctrlpPrim = Rctrlp;
    }
    return(0);
  }

  void 
  RfreeRmanageFindFile()
  {
    delwin(RwinList);
    delwin(RwinTop);
    delwin(RwinWorkgroup);
    delwin(RwinHost);
    delwin(RwinDir);
    delwin(RwinFilename);
    delwin(RwinStatus);
  }

  RDBG("smbc: RmanageFindFile start\n");
  Rttgroup[0] = 0;
  Rtthost[0] = 0;
  Rttdir[0] = 0;
  strcpy(Rttfilename, RfindStr);
  Rtgroup[0] = 0;
  Rthost[0] = 0;
  Rtdir[0] = 0;
  strcpy(Rtfilename, RfindStr);

  RcreateFindFileWindow();
  RlFirst = 1; RlSelect = 1;
  nodelay(RwinTop, 1);
  RactiveWindow = RwinTop;
  RDBG("smbc : RmanageFindFile RactiveWindow = RwinTop  2\n");
  while (Rrol) {
    RstatusBar(2);
    RrefreshR(0);
    Rt = 0;
    while (Rt <= 0) 
    {
      Rfirst = 1;
      RDBG("smbc : RmanageFindFile 2\n");
      Rtl = 0;
      while ((Rt = readlineOneCharNoDelay(RwinTop, 0, RtxtStartX+1, Rtgroup, RMAXGHLEN, Rx-RtxtStartX-4, 3, &Rctrlp, 1, &Rin11, &Rin12, &Rfirst)) <= 0) 
      {
        Rfirst = 1;
        RtryDownloadUpload();
        RdetectAndPaintStatusCtrlp();
        Rtl2 = strlen(Rtgroup);
        if (Rtl != Rtl2) {
          Rtl = Rtl2;
          RrefreshR(1);
          RresizeFindFile(1);
        }
      };
      if (RdetectAndPaintStatusCtrlp()) 
      {
        RfreeRmanageFindFile();
        return(ret);
      }
    }
    RrefreshR(0);
    RresizeFindFile(0);
    RfindFileFromIndex();
    RstatusBar(3);
    RresizeFindFile(0);
    RrefreshR(0);
    Rt = 0;
    while (Rt <= 0) 
    {
      Rfirst = 1;
      Rtl = 0;
      while ((Rt = readlineOneCharNoDelay(RwinTop, 1, RtxtStartX+1, Rthost, RMAXGHLEN, Rx-RtxtStartX-4, 3, &Rctrlp, 1, &Rin21, &Rin22, &Rfirst)) <= 0) 
      {
        Rfirst = 1;
        RtryDownloadUpload();
        Rtl2 = strlen(Rthost);
        RdetectAndPaintStatusCtrlp();
        if (Rtl != Rtl2) 
        {
          Rtl = Rtl2;
          RrefreshR(2);
          RresizeFindFile(2);
        }
      }
      if (RdetectAndPaintStatusCtrlp()) 
      {
        RfreeRmanageFindFile();
        return(ret);
      }
      RrefreshR(0);
      RresizeFindFile(0);
    }
    RfindFileFromIndex();
    RstatusBar(4);
    RresizeFindFile(0);
    RrefreshR(0);
    Rt = 0;
    Rtl = 0;
    while (Rt <= 0) 
    {
      Rfirst = 1;
      while ((Rt = readlineOneCharNoDelay(RwinTop, 2, RtxtStartX+1, Rtdir, RMAXGHLEN, Rx-RtxtStartX-4, 3, &Rctrlp, 1, &Rin31, &Rin32, &Rfirst)) <= 0) 
      {
        Rfirst = 1;
        RtryDownloadUpload();
        RdetectAndPaintStatusCtrlp();
        Rtl2 = strlen(Rtdir);
        if (Rtl != Rtl2) 
        {
          Rtl = Rtl2;
          RrefreshR(3);
          RresizeFindFile(3);
        }
      }
      if (RdetectAndPaintStatusCtrlp()) 
      {
        RfreeRmanageFindFile();
        return(ret);
      }
      RrefreshR(0);
      RresizeFindFile(0);
    }
    RfindFileFromIndex();
    RstatusBar(5);
    RresizeFindFile(0);
    RrefreshR(0);
    Rt = 0;
    Rtl = 0;
    while (Rt <= 0) 
    {
      Rfirst = 1;
      while ((Rt = readlineOneCharNoDelay(RwinTop, 3, RtxtStartX+1, Rtfilename, RMAXGHLEN, Rx-RtxtStartX-4, 3, &Rctrlp, 1, &Rin41, &Rin42, &Rfirst)) <= 0) 
      {
        Rfirst = 1;
        RtryDownloadUpload();
        RdetectAndPaintStatusCtrlp();
        if (Rt >= 0)
          RfindFileFromIndex();
          Rtl2 = strlen(Rtfilename);
          if (Rtl != Rtl2) 
          {
            Rtl = Rtl2;
            RrefreshR(4);
            RresizeFindFile(4);
          }
      }
      if (RdetectAndPaintStatusCtrlp()) 
      {
        RfreeRmanageFindFile();
        return(ret);
      }
      RrefreshR(0);
      RresizeFindFile(0);
    }
    RfindFileFromIndex();
    RstatusBar(6);
    Rrol = 2;
    RresizeFindFile(0);
    RrefreshR(0);
    RlFirst = 1; RlSelect = 1;
    Rt = 2;
    FindListCount = RgetCountRecordIndexTable(Ridx);
    while ((Rrol == 2) && (FindListCount > 0)) {
      while ((Rkey = mvwgetch(RwinList, 1,1)) <= 0) 
        RtryDownloadUpload();
        RresizeFindFile(0);
        if ((Rkey == 9) || (Rkey == 'i'))    // tab
        {
          Rrol = 1;
          break;
        }
        if (Rkey == KEY_DOWN || Rkey == 'o') 
        {
          if ((RlSelect+1 == RlFirst+Ry-13) && (RlFirst+Ry-13 < FindListCount+1)) 
          {
            RlFirst++;
            RlSelect++;
          }
          else 
            if (RlSelect < FindListCount) 
              RlSelect++;
          RpaintList(RlFirst, RlSelect);
        }
        if (Rkey == KEY_UP || Rkey == 'p') 
        {
          if (RlSelect > 1) 
          {
            if ((RlFirst > 1) && (RlSelect == RlFirst)) 
            { 
              RlSelect--; 
              RlFirst--;
            }
            else 
              RlSelect--;
            RpaintList(RlFirst, RlSelect);
          }
        }
        if (Rkey == KEY_NPAGE || Rkey == 'k') 
        {
          if (RlFirst+Ry-13 <= FindListCount) 
          {
            if (RlSelect+1 == RlFirst+Ry-13) 
            {
              if (RlSelect+Ry-13 < FindListCount) 
              {
                 RlFirst = RlSelect;
                 RlSelect = RlFirst+Ry-13-1;
               }
               else 
               {
                 RlFirst = FindListCount-(Ry-13);
                 RlSelect = FindListCount-1;
               }
           }
           else 
           {
              if (RlSelect+Ry-13 <= FindListCount) 
                RlSelect = RlFirst+Ry-13-1;
              else
                RlSelect = FindListCount-1;
           }
         }
         RpaintList(RlFirst,RlSelect);
        }
        if (Rkey == KEY_PPAGE || Rkey == 'l') 
        {
          if (RlSelect > 1) 
          {
            if (RlFirst == RlSelect) 
            {
              if (RlFirst-(Ry-13) < 1) 
              {
                RlFirst = 1;
                RlSelect = 1;
              }
              else 
              {
                RlFirst = RlFirst-(Ry-13)+1;
                RlSelect = RlFirst;
              }
            }
            else RlSelect = RlFirst;
            RpaintList(RlFirst,RlSelect);
          }
        }
        if (Rkey == 10)     // enter
        {
          RgotoNIndextTable(&Ridx, RlSelect);
          RindexNetSetSeek(&RidxNet, Ridx->number);
          RindexNetReadOneRecord(&RidxNet, &RfindIndex);
          strcpy(group, RfindIndex.group);
          strcpy(host, RfindIndex.host);
          asprintf(&Rmsg1, "smb://%s/%s/", RfindIndex.host, RfindIndex.dir);
          strcpy(dir, Rmsg1);
          strcpy(SelectFile, RfindIndex.file);
          free(Rmsg1);
          ret = 1;
          Rkey = 'q';
        }
        if (Rkey == 'q') 
        { 
          RfreeRmanageFindFile();
          return(ret);
        }
    } 
  }
  return(ret);
}
//
// ------------------- RmanageFindFile END ------------------------
//

void 
RcreateIndexFileOnline(int RfileFd)
{
  int Rys = 10;
  int Rxs = 76;
  WINDOW *RwinMsg, *RwinMsg2;
  char *Rstr = NULL;
  char *RstrW = NULL;
  char *RstrShare = NULL;
  char *RstrDir = NULL;
  char *RstrDir2 = NULL;
  int Rii, Rk, Rkk;
  
  RDBG("smbc: RcreateIndexFileOnline start\n");
  RwinMsg = newwin(Rys, Rxs, Ry/2-Rys/2, Rx/2-Rxs/2);
  RwinMsg2 = newwin(4, Rxs-15, Ry/2-Rys/2+2, Rx/2-Rxs/2+13);
  box(RwinMsg,0,0);
  asprintf(&Rstr, Rm148); Rii = Rxs/2-strlen(Rstr)/2; mvwprintw(RwinMsg, 1, Rii, Rstr); free(Rstr);
  mvwprintw(RwinMsg, 3, 1, Rm149);
  mvwprintw(RwinMsg, 4, 1, Rm150);
  mvwprintw(RwinMsg, 5, 1, Rm151);

  wattron(RwinMsg, COLOR_PAIR(1));
     asprintf(&Rstr, Rm137); Rii = Rxs/2-strlen(Rstr)/2; mvwprintw(RwinMsg, 7, Rii, Rstr); free(Rstr);
  wattroff(RwinMsg, COLOR_PAIR(1));

  wrefresh(RwinMsg);
  asprintf(&Rstr, "smb//%s/", Rahost);
  Rkk = 1;
  if (strlen(Radir) > strlen(Rstr)) 
  {
    RstrW = Radir+strlen(Rstr)+1;
    if (strlen(RstrW) > 0) 
    {
      if (RstrW[0] == '/') 
        RstrW++;
      Rk = strlen(RstrW) - strlen(strstr(RstrW, "/"));
      RstrShare = Rmalloc(strlen(RstrW)+1);
      memcpy(RstrShare, RstrW, Rk);
      RstrShare[Rk] = 0;
      
      RstrDir = Rmalloc(strlen(RstrW)+1);
      memcpy(RstrDir, RstrW+Rk, strlen(RstrW)-Rk+1);
      if (RstrDir[0] == '/') 
        RstrDir2 = RstrDir+1;
      Rkk = 0;
    }
  } 
  if (Rkk) {
      RstrShare = Rmalloc(1);
      RstrDir = Rmalloc(1);
      RstrShare[0] = 0;
      RstrDir[0] = 0;
      RstrDir2 = RstrDir;
  }
  RDBG("smbc: RcreateIndexFileOnline before RcreateFindListIndex(0, Ragroup, Rahost, RstrShare, RstrDir2, RwinMsg2, RfileFd)\n");
  RcreateFindListIndex(0, Ragroup, Rahost, RstrShare, RstrDir2, RwinMsg2, RfileFd);
  RDBG("smbc: RcreateIndexFileOnline after RcreateFindListIndex(0, Ragroup, Rahost, RstrShare, RstrDir2, RwinMsg2, RfileFd)\n");
  free(Rstr);
  free(RstrShare);
  free(RstrDir);

  delwin(RwinMsg2);
  delwin(RwinMsg);
  RDBG("smbc: RcreateIndexFileOnline stop\n");
}

int 
RfindFileSmb(char *dir, char *SelectFile)
{
  int RmaxX;
  int Rys, Rxs;
  WINDOW *RwinMsg;
  const int MAXSTR = 100;
  char RdirT[MAXSTR];
  int Rrol = 4;
  char Rkey;
  int ret = 0;
  int RfileFd = 0;
  char *RfileName;
  int Rcount;
  TTfind *RidxNet = NULL;
  int RdirTpos = 0;
  int Rin1 = 0;
  int Rin2 = 0;
  int Rfirst = 1;

  void 
  Rrefresh(int Rsel)
  {
    char *RdirTt;

    int Rall = strlen(Rm152)+strlen(Rm153)+strlen(Rm137)+2;

    wattron(RwinMsg, COLOR_PAIR(2));
    mvwhline(RwinMsg, 3, 3, ' ', Rxs-6); 

    RdirTt = strdup(RdirT);
    if (strlen(RdirTt) > RmaxX)
      RdirTt[RmaxX] = 0;
    mvwprintw(RwinMsg, 3, 3, to_scr(RdirTt)); 
    free(RdirTt);
    
    wattroff(RwinMsg, COLOR_PAIR(2));
    switch(Rsel) 
    {
      case 1 : mvwprintw(RwinMsg, Rys-2, (Rxs-Rall)/2, Rm152); 
               mvwprintw(RwinMsg, Rys-2, (Rxs-Rall)/2+strlen(Rm152)+1, Rm153); 

               wattron(RwinMsg, COLOR_PAIR(1)); 
               mvwprintw(RwinMsg, Rys-2, (Rxs-Rall)/2+strlen(Rm152)+strlen(Rm153)+2, Rm137); 
               wattroff(RwinMsg, COLOR_PAIR(1));
               break;  
      case 2 : mvwprintw(RwinMsg, Rys-2, (Rxs-Rall)/2, Rm152); 

               wattron(RwinMsg, COLOR_PAIR(1)); 
               mvwprintw(RwinMsg, Rys-2, (Rxs-Rall)/2+strlen(Rm152)+1, Rm153); 
               wattroff(RwinMsg, COLOR_PAIR(1));

               mvwprintw(RwinMsg, Rys-2, (Rxs-Rall)/2+strlen(Rm152)+strlen(Rm153)+2, Rm137); 
               break;
      case 3 : wattron(RwinMsg, COLOR_PAIR(1)); 
               mvwprintw(RwinMsg, Rys-2, (Rxs-Rall)/2, Rm152); 
               wattroff(RwinMsg, COLOR_PAIR(1));

               mvwprintw(RwinMsg, Rys-2, (Rxs-Rall)/2+strlen(Rm152)+1, Rm153); 
               mvwprintw(RwinMsg, Rys-2, (Rxs-Rall)/2+strlen(Rm152)+strlen(Rm153)+2, Rm137); 
               break;
      case 4 : mvwprintw(RwinMsg, Rys-2, (Rxs-Rall)/2, Rm152); 
               mvwprintw(RwinMsg, Rys-2, (Rxs-Rall)/2+strlen(Rm152)+1, Rm153); 
               mvwprintw(RwinMsg, Rys-2, (Rxs-Rall)/2+strlen(Rm152)+strlen(Rm153)+2, Rm137); 
               break;
    }
  }

  RdirT[0] = 0;
  Rys = 8; Rxs = 76;
  RmaxX = Rxs-6; 
  RwinMsg = newwin(Rys, Rxs, Ry/2-Rys/2, Rx/2-Rxs/2);
  box(RwinMsg,0,0);
  mvwprintw(RwinMsg, 1, Rxs/2-strlen(Rm154)/2, Rm154);
  Rrefresh(Rrol);
  RcancelFinding = 0;

  nodelay(RwinMsg,1);
  RactiveWindow = RwinMsg;
  RDBG("smbc : RfindFileSmb RactiveWindow = RwinMsg  2\n");
  while (Rrol) {
    RtryDownloadUpload();
    if (Rrol == 4) 
    { 
      Rfirst = 1;
      Rin1 = 0;
      Rin2 = 0;
      while (readlineOneCharNoDelay(RwinMsg, 3, 3, RdirT, MAXSTR, RmaxX,3, &RdirTpos, 1, &Rin1, &Rin2, &Rfirst) <= 0) 
        RtryDownloadUpload();
      Rrefresh(--Rrol);
    }
    Rkey = mvwgetch(RwinMsg,1,1);
    if (Rkey == 9) 
    { 
      if ((--Rrol) == 0) 
        Rrol = 4;
      Rrefresh(Rrol);
    }
    if (Rkey == 10) 
    {
      asprintf(&RfileName, "/tmp/smbc_%i_%i",  getuid(), getpid());
      if (Rrol == 2) 
      {    // slow find
        RindexFileCreate(RfileName, &RfileFd);                         // create file descriptor and remove file to other use
        RindexFileUnlink(RfileName);
        RcreateIndexFileOnline(RfileFd);
      } 
      else 
      if (Rrol == 3) 
      {    // quick find
         if (!RmakeCopyFileWithPID(RfileName, RfileNameForFindList)) 
         {
            RshowMessage(28,NULL,NULL,NULL);
            RcancelFinding = 1;
            ret = 0;
         }
         else 
         {
           RindexFileOpen(RfileName, &RfileFd);
           RindexFileUnlink(RfileName);
         }
      }
      else Rrol = 0;
      free(RfileName);
      if (RcancelFinding)
        Rrol = 0;

      if (Rrol) 
      {
        RDBG("smbc: RfindFileSmb before Rrol\n");
        Rcount = RindexFileGetCount(RfileFd);
        if (Rcount) 
        {
          RshowMessage(30, NULL, NULL, NULL);
          RloadIndexFile(RfileFd, &RidxNet);
          ret = RmanageFindFile(RdirT, Ragroup, Rahost, Radir, SelectFile, RidxNet, Rcount);
          RfreeIndexFile(&RidxNet);
          if (ret == 1) 
          {
            if (strlen(Ragroup) > 0) 
              RremoteLevel = 1;
            else 
              RremoteLevel = 0;
            if (strlen(Rahost) > 0) 
            {
              RremoteLevel = 2;
              if (strlen(index(Radir+6+strlen(Rahost),'/')) > 1)
                RremoteLevel = 3;
            }
            ret = 1;
          }
          RwinRedrawWithData();
          Rrol = 0;
        } 
        else 
        {
          RshowMessage(28, "", "", NULL); 
          Rrol = 0;
        }
      }
    }
    if (Rkey == 'q') 
      Rrol = 0;
  }
  RindexFileClose(&RfileFd);
  delwin(RwinMsg);
  RwinRedrawWithData();
  RDBG("smbc: RfindFileSmb exit with result ");
  RDBGi(ret);
  RDBG("\n");
  return(ret);
}

void 
RcreateFindListIndex(int Isave, char *Igroup, char *Ihost, char *Ipath, char *Idir, WINDOW *RwinI, int RfileFd)
{
  int Rfd;
  int RxT, RyT;
  struct smbc_dirent *Rdirent;
  char *Rstr, *Rstr2;
  int Rstr2Len;
  char *IIgroup, *IIhost, *IIpath, *IIdir, *IItmp;
    
  void RcancelCheck()
  {
    char Rch = 0;

    while (Rch != ERR) 
    {
      Rch = wgetch(RwinI);
      if (Rch == 10) 
        RcancelFinding = 1;
    }
  }

  if (!Isave) 
  {
    keypad(RwinI, TRUE);
    nodelay(RwinI, 1);
    RactiveWindow = RwinI;
    RDBG("smbc : RcreateFindFileIndex RactiveWindow = RwinI  2\n");
    RcancelCheck();
    if (RcancelFinding) 
      return;
  }

  RDBG("smbc: RcreateFindListIndex start\n");

  asprintf(&IIgroup, "%s", Igroup);
  RDBG("smbc: RcreateFindListIndex s1\n");
  asprintf(&IIhost, "%s", Ihost);
  RDBG("smbc: RcreateFindListIndex s2\n");
  asprintf(&IIdir, "%s", Idir);
  RDBG("smbc: RcreateFindListIndex s3\n");
  asprintf(&IIpath, "%s", Ipath);
  RDBG("smbc: RcreateFindListIndex s4\n");
  getmaxyx(RwinI, RyT, RxT);

  RDBG("smbc: RcreateFindListIndex s5\n");

  if (!Isave) 
  {

    RDBG("smbc: RcreateFindListIndex a1\n");
    Rstr2 = strdup(to_scr(IIgroup)); 
    Rstr2Len = strlen(Rstr2)+1;
    if (strlen(Rstr2) > RxT) 
      Rstr2[RxT] = 0;
    mvwhline(RwinI, 1, 0, 32, RxT); 
    mvwprintw(RwinI, 1, 0, Rstr2); 
    free(Rstr2);

    RDBG("smbc: RcreateFindListIndex a3\n");
    Rstr2 = strdup(to_scr(IIhost)); 
    Rstr2Len = strlen(Rstr2)+1;
    if (strlen(Rstr2) > RxT) 
      Rstr2[RxT] = 0;
    mvwhline(RwinI, 2, 0, 32, RxT); 
    mvwprintw(RwinI, 2, 0, Rstr2); 
    free(Rstr2);
  
    RDBG("smbc: RcreateFindListIndex a5\n");
    asprintf(&Rstr2, "%s%s%s", Ipath, strlen(Ipath)>0?"/":"", IIdir); 
    Rstr2Len = strlen(Rstr2)+1;
    if (strlen(Rstr2) > RxT) 
      Rstr2[RxT] = 0;
    mvwhline(RwinI, 3, 0, 32, RxT); 
    mvwprintw(RwinI, 3, 0, Rstr2); 
    free(Rstr2);

    RDBG("smbc: RcreateFindListIndex a7\n");
    wrefresh(RwinI);
    
  }

  RDBG("smbc: RcreateFindListIndex !!! 1 !!!\n");
  if (strlen(IIgroup) == 0) 
    asprintf(&Rstr, "smb://");
  else 
    if (strlen(IIhost) == 0) 
      asprintf(&Rstr, "smb://%s/", IIgroup);
     else 
      if (strlen(Ipath) == 0) 
        asprintf(&Rstr, "smb://%s/", IIhost);
      else 
        if (strlen(IIdir) == 0) 
          asprintf(&Rstr, "smb://%s/%s/", IIhost, IIpath);
          else 
          {
            asprintf(&Rstr, "smb://%s/%s/%s/", IIhost, Ipath, IIdir);
            free(IIpath);
            asprintf(&IIpath, "%s/%s", Ipath, Idir);
          }

  RDBG("smbc: RcreateFindListIndex try open : "); RDBG(Rstr); RDBG("\n");
  Rfd = Rsmbc_opendir(Rstr);
  RDBG("smbc: RcreateFindListIndex after try open\n");

  if (Rfd > 0) 
  {
    while ((Rdirent = Rsmbc_readdir(Rfd))) 
    {
      if (Rdirent != NULL) 
      {
        if ((strlen(Rdirent->name) > 0) && (!RcancelFinding)) 
        {
          if (!Isave) 
            RcancelCheck();
          if (Rdirent->name[strlen(Rdirent->name)-1] != '$') 
          {
            RDBG("smbc: RcreateFindListIndex !!! 3 !!!\n");
            asprintf(&IItmp, Rdirent->name);
            RDBG("smbc: RcreateFindListIndex !!! 4 !!! : "); RDBG(Rdirent->name); RDBG("\n");
            switch (Rdirent->smbc_type) 
            {
              case SMBC_WORKGROUP:  RDBG("smbc: RcreateFindListIndex !!! 4 - 1 !!!\n");
                                    RcreateFindListIndex(Isave, IItmp, "", "", "", RwinI, RfileFd);
                                    break;
              case SMBC_SERVER:     RDBG("smbc: RcreateFindListIndex !!! 4 - 2 !!!\n");
                                    RcreateFindListIndex(Isave, IIgroup, IItmp, "", "", RwinI, RfileFd);
                                    break;
              case SMBC_FILE_SHARE: RDBG("smbc: RcreateFindListIndex !!! 4 - 3 !!!\n");
                                    RcreateFindListIndex(Isave, IIgroup, IIhost, IItmp, "", RwinI, RfileFd);
                                    break;
              case SMBC_COMMS_SHARE:RDBG("smbc: RcreateFindListIndex !!! 4 - 4 !!!\n"); 
                                    break;
              case SMBC_DIR:        RDBG("smbc: RcreateFindListIndex !!! 4 - 5 !!!\n");
                                    if ((!RstrCmp(IItmp,".")) & (!RstrCmp(IItmp,".."))) 
                                    {
                                       RDBG("smbc: RcreateFindListIndex !!! 4 - 6 !!!\n");
                                       RcreateFindListIndex(Isave, IIgroup, IIhost, IIpath, IItmp, RwinI, RfileFd);
                                    }
                                    break;
              case SMBC_FILE:       RDBG("smbc: RcreateFindListIndex !!! 4 - 7 !!!\n");
                                    write(RfileFd, IIgroup, strlen(IIgroup)+1);
                                    write(RfileFd, IIhost, strlen(IIhost)+1);
                                    write(RfileFd, IIpath, strlen(IIpath)+1);
                                    write(RfileFd, IItmp, strlen(IItmp)+1);
                                    RDBG("smbc: RcreateFindListIndex !!! 6 !!!\n");
                                    if (!Isave) 
                                    {
                                       RDBG("smbc: RcreateFindListIndex !!! 6-1 !!!\n");
                                       asprintf(&Rstr2, IItmp); 
                                       if (strlen(Rstr2) > RxT) 
                                         Rstr2[RxT] = 0;
                                       free(Rstr2);
                                    }
                                    RDBG("smbc: RcreateFindListIndex !!! 7 !!!\n");
                                    break;
              case SMBC_LINK: 
                                    break;
            }
            RDBG("smbc: RcreateFindListIndex !!! 8 !!!\n");
            free(IItmp);
            RDBG("smbc: RcreateFindListIndex !!! 9 !!!\n");
          }
       }
      } 
    }
    smbc_closedir(Rfd);
  }
  RDBG("smbc: RcreateFindListIndex !!! 10 !!!\n");
  free(Rstr);
  free(IIgroup);
  free(IIhost);
  if (IIpath) 
    free(IIpath);
  free(IIdir);
  RDBG("smbc: RcreateFindListIndex !!! 11 !!!\n");
  return;
}

void 
RsigTerm()
{
  int Ri;

  Ri = can_change_color();
  getmaxyx(RwinMain, Ry, Rx); 
  endwin();
  kill(RchildId, SIGHUP);
  if (!Ri) 
  {
    printf(Rm156);
    printf(Rm157);
  }
  RDBG("smbc : RsigTerm Rx == "); RDBGi(Rx); RDBG(", Ry == "); RDBGi(Ry); RDBG("\n"); 
  if ((Rx < 80) || (Ry < 25)) 
    printf(Rm158, Rx, Ry);
  RopenSaveDownloadList(0);
  RDBG("smbc : RsigTerm 2\n");
  if (RlockFile > 0) 
    close(RlockFile);

  RDBG("smbc : RsigTerm 3\n");
  if (Rerror) 
  {
    printf("**********************************************************\n");
    printf(Rm159);
    printf(Rm160);
    printf("smbc@airm.net\n");
    printf("**********************************************************\n");
  }

  RdoneIconv();

  RDBG("smbc : RsigTerm 5\n");
  RdoneStrings();
  exit(0);
}

void 
RsigCHLD()
{
  waitpid(RchildId, NULL, WNOHANG);
}

void 
RcreateFindIndex(int Rl, int Rlock, char *Rstr)
{
  int RlockL;
  int RindexFileOld;
  int RmessageFilePrim;

  RDBG("smbc : RcreateFindIndex 1\n");
  if ((RchildId = fork()) == 0) 
  {
    RDBG("smbc : RcreateFindIndex child\n");
    if (RindexTime == 0) 
      exit(0);         // child
    if (Rl) 
    {
      RDBG("smbc : RcreateFindIndex child 1\n");
      if (Rlock) 
        close(Rlock);
      RDBG("smbc : RcreateFindIndex child 3\n");

      RlockL = open(to_sys(Rstr), O_RDWR | O_CREAT, 0600);
      RDBG("smbc : RcreateFindIndex child 4\n");

      RmessageFilePrim = open(to_sys(RfileNameMessagePrim), O_RDWR | O_CREAT, 0600);
      RDBG("smbc : RcreateFindIndex child 4\n");
      if (RmessageFilePrim > 0) 
      {
        RDBG("smbc : RcreateFindIndex child 5\n");
        write(RmessageFilePrim, Rm67, strlen(Rm67));
        RDBG("smbc : RcreateFindIndex child 6\n");
        close(RmessageFilePrim);
        RDBG("smbc : RcreateFindIndex child 7\n");
        rename(RfileNameMessagePrim, RfileNameMessage);
      }

      RDBG("smbc : RcreateFindIndex child 8\n");
      while (1) 
      {
        if (RlockL > 0) 
          if (!flock(RlockL, LOCK_EX | LOCK_NB)) 
             exit(0);                                // kill smbc-child when parent was killed SIGKILL

        if (RindexFileFd == 0) 
          if (RindexFileCreate(RfileNameForFindListPrim, &RindexFileFd)) 
          {
             RcreateFindListIndex(1, "","","","", NULL, RindexFileFd);

             unlink(RfileNameMessagePrim);
             RmessageFilePrim = open(to_sys(RfileNameMessagePrim), O_RDWR | O_CREAT, 0600);

             RindexFileOld = open(to_sys(RfileNameForFindList), O_RDONLY);
             RcompareTwoIndexFile(RindexFileFd, RindexFileOld, RmessageFilePrim);
             if (RindexFileOld > 0)
               close(RindexFileOld);
             close(RindexFileFd); 
             close(RmessageFilePrim);
             rename(RfileNameMessagePrim, RfileNameMessage);
             RindexFileFd = 0;
          }
        rename(RfileNameForFindListPrim, RfileNameForFindList);
        RDBG("smbc : RcreateFindIndex child 10\n");
        if (RindexTime > 1) 
          sleep(RindexTime); 
        else
          exit(0); 
      }
    } 
    else 
      exit(0);
  }
  RDBG("smbc : RcreateFindIndex parent\n");
}

/*     output:  RrightFirstI
                RrightPosI
        input:  RstrTmpI    - file name
                Rselected
*/
void 
RsetSelect(int *RFirstI, int *RPosI, char *RstrTmpI, RLTYPE Rselected)
{
  int Ri = 0;
  char *Rcmp;

  RDBG("smbc: RsetSelect start: RstrTmpI = "); RDBG(RstrTmpI); RDBG("\n");
  if (RstrTmpI == NULL) 
  {
    RDBG("smbc: RsetSelect return 0\n");
    *RFirstI = 0;
    *RPosI = 0;
    return;
  }
  if (Rselected == RLREMOTE) 
  {
    RDBG("smbc: RsetSelect : RremoteLevel = "); RDBGi(RremoteLevel); RDBG("\n");
    while (1) 
    {
      RDBG("smbc: RsetSelect : RlistRight[Ri]->col = "); RDBG(RremoteLevel == 1?RlistRight[Ri]->col4:RlistRight[Ri]->col2); RDBG("\n");

      switch (RremoteLevel) 
      {
        case (1) : 
        case (2) : Rcmp = RlistRight[Ri]->col4;
                   break;
        default  : Rcmp = RlistRight[Ri]->col2;
      }

      if (RstrCmp(Rcmp, RstrTmpI)) 
      {
        if (Ri > Ry-6) 
        {
          if (RlistRightMax-Ri < Ry-6) 
          {
            *RFirstI = RlistRightMax - (Ry-6);
            *RPosI = Ri-(*RFirstI);
          }
          else 
          {
            *RFirstI = Ri-1;
            *RPosI = 1;
          }
          RDBG("smbc: RsetSelect return 1\n");
          return; 
        }
        else 
        {
          *RPosI = Ri;
          *RFirstI = 0;
          RDBG("smbc: RsetSelect return 2\n");
          return;
        }
      }
      if (Ri+1 < RlistRightMax) 
        Ri++;
      else 
      {
        RDBG("smbc: RsetSelect return 3\n");
        return;
      }
    }
  }
  else 
  {
    while (1) 
    {
      if (RstrCmp(RlistLeft[Ri]->col2, RstrTmpI)) 
      {
        if (Ri > Ry-6) 
        {
          if (RlistLeftMax-Ri < Ry-6) 
          {
            *RFirstI = RlistLeftMax - (Ry-6);
            *RPosI = Ri-(*RFirstI);
          }
          else 
          {
            *RFirstI = Ri-1;
            *RPosI = 1;
          }
          RDBG("smbc: RsetSelect return 4\n");
          return; 
        }
        else 
        {
          *RPosI = Ri;
          *RFirstI = 0;
          RDBG("smbc: RsetSelect return 5\n");
          return;
        }
      }
      if (Ri+1 < RlistLeftMax) 
        Ri++;
      else 
      {
        RDBG("smbc: RsetSelect return 6\n");
        return;
      }
    }
  }
}

void 
RcompareTwoIndexFile(int RfdNew, int RfdOld, int RfdMessage)
{
  TTfind RfindIndexNew;
  TTfind RfindIndexOld;
  int Rfound;
  int RnewAdd = 0;
  int RnewDel = 0;
  char *RnewHosts = NULL;
  char *RoldHosts = NULL;
  char *RstrT;
  char *RstrT2;

  TThostsTable *RhostsTableNew = NULL;
  TThostsTable *RhostsTableOld = NULL;
  TThostsTable *RhostsTableNewTmp;
  TThostsTable *RhostsTableOldTmp;
  
  RDBG("smbc: RcompareTwoIndexFile start\n");
  if (RfdOld < 0) 
  {
    write(RfdMessage, Rm162, strlen(Rm162)+1);
    RDBG("smbc: RcompareTwoIndexFile return short\n");
    return;
  }
  else 
  {
    RDBG("smbc: RcompareTwoIndexFile seek files\n");
    RindexFileSetSeek(RfdNew, 1);
    RindexFileSetSeek(RfdOld, 1);

    //RDBG("smbc: RcompareTwoIndexFile while 1\n");
    while (RindexFileReadOneRecord(RfdNew, &RfindIndexNew)) 
    {
       //RDBG("smbc: RcompareTwoIndexFile while 1 - 2\n");
       if (!(RFindHostInToHostsTable(RhostsTableNew, RfindIndexNew.host)))
         RAddHostToHostsTable(&RhostsTableNew, RfindIndexNew.host);
    }

#ifdef HAVE_DEBUG
    RDBG("smbc: RcompareTwoIndexFile RhostsTableNew = ");
    RhostsTableNewTmp = RhostsTableNew;
    while (RhostsTableNewTmp) 
    {
      RDBG(RhostsTableNewTmp->name); RDBG(" ");
      RhostsTableNewTmp = RhostsTableNewTmp->next;
    }
    RDBG("\n");
#endif /* HAVE_DEBUG */    

    //RDBG("smbc: RcompareTwoIndexFile while 2\n");
    while (RindexFileReadOneRecord(RfdOld, &RfindIndexOld)) 
    {
       //RDBG("smbc: RcompareTwoIndexFile while 2 - 2\n");
       if (!(RFindHostInToHostsTable(RhostsTableOld, RfindIndexOld.host)))
         RAddHostToHostsTable(&RhostsTableOld, RfindIndexOld.host);
    }

#ifdef HAVE_DEBUG
    RDBG("smbc: RcompareTwoIndexFile RhostsTableOld = ");
    RhostsTableOldTmp = RhostsTableOld;
    while (RhostsTableOldTmp) 
    {
      RDBG(RhostsTableOldTmp->name); RDBG(" ");
      RhostsTableOldTmp = RhostsTableOldTmp->next;
    }
    RDBG("\n");
#endif /* HAVE_DEBUG */    

    /* find diference - add */
    RDBG("smbc: RcompareTwoIndexFile seek before add while\n");
    RhostsTableNewTmp = RhostsTableNew;
    while (RhostsTableNewTmp) 
    {
      //RDBG("smbc: RcompareTwoIndexFile while 1 - 1\n");
      RhostsTableOldTmp = RhostsTableOld;
      Rfound = 0;
      while (RhostsTableOldTmp && !Rfound) 
      {
        RDBG("smbc: RcompareTwoIndexFile : "); 
        RDBG(RhostsTableNewTmp->name); 
        RDBG(RstrCmp(RhostsTableNewTmp->name, RhostsTableOldTmp->name)?" == ":" != "); 
        RDBG(RhostsTableOldTmp->name);
        RDBG("\n");

        if (RstrCmp(RhostsTableNewTmp->name, RhostsTableOldTmp->name)) 
          Rfound = 1;
        else
          RhostsTableOldTmp = RhostsTableOldTmp->next;
      }
      RDBG("smbc: RcompareTwoIndexFile while after\n");
      if (!Rfound) 
      {
        //RDBG("smbc: RcompareTwoIndexFile add to RnewHosts : ");
        //RDBG(RfindIndexNewTmp.host); RDBG("\n");
        asprintf(&RstrT, "%s%s%s", RnewHosts?RnewHosts:"", RnewHosts?",":"", RhostsTableNewTmp->name);
        RnewAdd++;
        if (RnewHosts)
          free(RnewHosts);
        RnewHosts = RstrT;
      }
      RhostsTableNewTmp = RhostsTableNewTmp->next;
    } 
    RDBG("smbc: RcompareTwoIndexFile while 1, result : ");
    RDBG(RnewHosts); RDBG("\n");
    /* find diference - del */
    RDBG("smbc: RcompareTwoIndexFile seek before del while\n");
    RhostsTableOldTmp = RhostsTableOld;
    while(RhostsTableOldTmp) 
    {
      RhostsTableNewTmp = RhostsTableNew;
      Rfound = 0;
      while (RhostsTableNewTmp && !Rfound) 
      {
        if (RstrCmp(RhostsTableNewTmp->name, RhostsTableOldTmp->name)) 
          Rfound = 1;
        else
          RhostsTableNewTmp = RhostsTableNewTmp->next;
      }
      if (!Rfound) 
      {
        asprintf(&RstrT, "%s%s%s", RoldHosts?RoldHosts:"", RoldHosts?",":"", RhostsTableOldTmp->name);
        RnewDel++;
        if (RoldHosts)
          free(RoldHosts);
        RoldHosts = RstrT;
      }
      RhostsTableOldTmp = RhostsTableOldTmp->next;
    }
    RDBG("smbc: RcompareTwoIndexFile while 2, result : ");
    RDBG(RoldHosts); RDBG("\n");

    RDBG("smbc: RcompareTwoIndexFile seek before making return\n");
    if ((RnewAdd == 0) && (RnewDel == 0)) 
      write(RfdMessage, Rm162, strlen(Rm162)+1);
    else 
    {
      if (RnewAdd > 0) 
        asprintf(&RstrT, Rm164, Rm163, RnewAdd);
      if (RnewDel > 0) 
      {
        asprintf(&RstrT2, Rm165, RstrT, RnewDel); 
        free(RstrT); 
        RstrT = RstrT2;
      }
      if (RnewAdd > 0) 
      {
        asprintf(&RstrT2, Rm166, RstrT, RnewHosts, RoldHosts?",":""); 
        free(RstrT); 
        RstrT = RstrT2;
      }
      if (RnewDel > 0) 
      {
        asprintf(&RstrT2, Rm167, RstrT, RoldHosts); 
        free(RstrT); 
        RstrT = RstrT2;
      }
      write(RfdMessage, RstrT, strlen(RstrT)+1);
    }
    if (RstrT) 
      free(RstrT);
    if (RnewHosts) 
      free(RnewHosts);
    if (RoldHosts) 
      free(RoldHosts);
    RFreeHostsTable(&RhostsTableNew);
    RFreeHostsTable(&RhostsTableOld);
  }
  RDBG("smbc: RcompareTwoIndexFile finished\n");
}

void 
RcheckNewIndexFile(char *RfileName)
{
  int Rfd;
  char *Rstr = NULL;
  char *RstrT;
  char Rchar;
  struct stat Rfstat;
  int Rlen;

  Rfd = stat(RfileName, &Rfstat);
  if (Rfd == 0) 
  {
    if (RlastTimeFileMessage != Rfstat.st_ctime) 
    {
      RlastTimeFileMessage = Rfstat.st_ctime;
      Rfd = open(to_sys(RfileName), O_RDONLY);
      if (Rfd > 0) 
      {
        while (read(Rfd, &Rchar, 1) == 1) 
        {
           asprintf(&RstrT, "%s%c", Rstr?Rstr:"", Rchar);
           free(Rstr);
           Rstr = RstrT;
        }
      }
      Rlen = (strlen(Rstr)+1>Rx)?Rx:strlen(Rstr)+1;
      RstrT = Rmalloc(Rlen);
      memcpy(RstrT, Rstr, Rlen-1);
      RstrT[Rlen] = 0;

      mvwhline(RwinStatus, 0, 0, ' ', Rx);
      mvwprintw(RwinStatus,0,0, RstrT);
      wrefresh(RwinStatus);

      free(Rstr);
      free(RstrT);
      close(Rfd);
    }
  }
}

void 
RviewFile(RLTYPE Rsel, char *Rstr)
{
  WINDOW *WinView, *WinViewScroll;
  int Rkey = 0;
  int Rfilehandle = 0;
  struct stat remotestat;
  int Rsize = 0;
  off_t Rseek = 0;
  off_t RseekTmp = 0;
  int RwSize, RwReaded;
  int Rtx, Rty;
  char *Rbuf;
  int RfirstLineLen = 0;
  int RPageLen = 0;
  char RwrapView = 0;
  char Rloop;
  int Rtyt, Rtxt;

  void RreadAndPaint(WINDOW *RWin, RLTYPE Rsel, int Rhandle, off_t Rseek, int Rsize, int Rwrap)
  {
    int Rt;
    int Rix = 0;
    int Riy = 0;
    char *RbufT;

    memset(Rbuf, 0, RwSize);
    if (Rsel == RLLOCAL) 
    {
      lseek(Rhandle, Rseek, SEEK_SET);
      RwReaded = read(Rhandle, Rbuf, RwSize);
    }
    else 
    {
      Rsmbc_lseek(Rhandle, Rseek, SEEK_SET);
      RwReaded = Rsmbc_read(Rhandle, Rbuf, RwSize);
    }
    RDBG("smbc: RbufT = Rbuf;\n");
    RbufT = Rbuf;
    RwReaded = strlen(RbufT);
    memcpy(Rbuf, RbufT, RwReaded+1);
    RDBG("smbc: memcpy(Rbuf, RbufT, RwReaded+1);\n");
    
    werase(RWin);
    RPageLen = 0;
    if (RwReaded > 0) 
      for (Rt = 0; Rt < RwReaded; Rt++) 
      {
        if (Rwrap) 
        { 
          if (Riy == 0) 
          {
            if (Rix == Rtx)
              RfirstLineLen = Rix;
            else 
              RfirstLineLen = Rix+1;
          }
          if (Rix == Rtx) 
          {
            Rix = 0;
            Riy++;
          }
        } 
        if (Riy < Rty)
          RPageLen++;
        if (Rbuf[Rt] == 10) 
        {
          if ((!Rwrap) && (Riy == 0))
              RfirstLineLen = Rix+1;
          Rix = 0;
          Riy++;
        }
        else 
          mvwprintw(RWin, Riy, Rix++, "%c", Rbuf[Rt]);
      }
    wrefresh(RWin);
  }

  if (Rsel == RLLOCAL) 
  {
    Rfilehandle = open(to_sys(Rstr), O_RDONLY, 0755);
    if (Rfilehandle < 1) 
    {
      RshowMessage(7, Rstr, NULL, NULL);
      return;
    }
    fstat(Rfilehandle, &remotestat);
    Rsize = remotestat.st_size;
  } 
  else 
  {
    Rfilehandle = Rsmbc_open(Rstr, O_RDONLY, 0755);
    if (Rfilehandle < 1) 
    {
      RshowMessage(7, Rstr, NULL, NULL);
      return;
    }
    Rsmbc_fstat(Rfilehandle, &remotestat);
    Rsize = remotestat.st_size;
  }

  WinView = newwin(Ry-2,Rx,1,0);  
  WinViewScroll = newwin(Ry-4, Rx-2, 2, 1);
  getmaxyx(WinViewScroll, Rty, Rtx);
  RwSize = Rtx*Rty;
  Rbuf = Rmalloc(RwSize);
  
  box(WinView,0,0);
  RstatusBar(20);
  wrefresh(WinView);

  RreadAndPaint(WinViewScroll, Rsel, Rfilehandle, Rseek, RwSize, RwrapView);
  nodelay(RwinMain, 1);
  RactiveWindow = RwinMain;
  RDBG("smbc : RviewFile RactiveWindow = RwinMain  2\n");
  while ((Rkey = mvwgetch(RwinMain, 1,1))) 
  {
    RtryDownloadUpload();
    if ((Rkey == 267) || (Rkey == 'q'))    // F3
      break;
    if ((Rkey == 272) || (Rkey == 'w')) 
    {                                      // F8
      if (RwrapView) 
        RwrapView = 0;
      else 
        RwrapView = 1;
      RreadAndPaint(WinViewScroll, Rsel, Rfilehandle, Rseek, RwSize, RwrapView);
    }
    if ((Rkey == KEY_DOWN || Rkey == 'o')) 
    {
      if (Rseek < Rsize)
        Rseek = Rseek+RfirstLineLen;
      RreadAndPaint(WinViewScroll, Rsel, Rfilehandle, Rseek, RwSize, RwrapView);
    }
    if (Rkey == KEY_UP || Rkey == 'p') 
    {
      if (Rseek > 0) 
      {
        Rloop = 1;
        RseekTmp = Rseek;
        while (Rloop) 
        {
          RseekTmp--;
          if (Rseek - RseekTmp == 1) 
            RseekTmp--; 
          if (RseekTmp <= 0) 
            Rloop = 0;
          if (Rsel == RLLOCAL) 
          {
            lseek(Rfilehandle, RseekTmp, SEEK_SET);
            RwReaded = read(Rfilehandle, Rbuf, 1);
          }
          else 
          {
            Rsmbc_lseek(Rfilehandle, RseekTmp, SEEK_SET);
            RwReaded = Rsmbc_read(Rfilehandle, Rbuf, 1);
          }
          if (Rbuf[0] == 10) 
          {
            Rloop = 0;
            RseekTmp++;
          }
          if (Rseek - RseekTmp > Rtx)
            Rloop = 0;
        }
        Rseek = RseekTmp;
      }
      RreadAndPaint(WinViewScroll, Rsel, Rfilehandle, Rseek, RwSize, RwrapView);
    }
    if ((Rkey == KEY_NPAGE || Rkey == 'k')) 
    {
      if ((Rseek < Rsize) && (Rseek + RPageLen < Rsize)) 
        Rseek = Rseek+RPageLen;
      RreadAndPaint(WinViewScroll, Rsel, Rfilehandle, Rseek, RwSize, RwrapView);
    }
    if ((Rkey == KEY_PPAGE || Rkey == 'l')) 
    {
      if (Rseek > 0) 
      {
        Rloop = 1;
        Rtyt = 0;
        Rtxt = 0;
        RseekTmp = Rseek;
        while (Rloop) 
        {
          RseekTmp--;
          if (RseekTmp <= 0) 
            Rloop = 0;
          if (Rsel == RLLOCAL) 
          {
            lseek(Rfilehandle, RseekTmp, SEEK_SET);
            RwReaded = read(Rfilehandle, Rbuf, 1);
          }
          else 
          {
            Rsmbc_lseek(Rfilehandle, RseekTmp, SEEK_SET);
            RwReaded = Rsmbc_read(Rfilehandle, Rbuf, 1);
          }
          if ((Rbuf[0] == 10) || (Rtxt >= Rtx)) 
          {
            Rtyt++;
            Rtxt = 0;
          }
          if (Rtyt >= Rty)
             Rloop = 0;
          Rtxt++;
        }
        Rseek = RseekTmp;
      }
      RreadAndPaint(WinViewScroll, Rsel, Rfilehandle, Rseek, RwSize, RwrapView);
    }
  }
  delwin(WinView);
  delwin(WinViewScroll);
  if (Rfilehandle) 
  {
    if (Rsel == RLLOCAL) 
      close(Rfilehandle);
    else
      Rsmbc_close(Rfilehandle);
  }
}

void 
RtryReadMessage()
{
  DIR *Rdirh;
  struct dirent *Rsdirent;
  char *RfileName;
  int Rfh;
  char Rch;
  char *Rl = NULL;
  char *Rll = NULL;
  char *Rl1 = NULL;
  char *Rl2 = NULL;
  int Rfound = 1;

  // ----- read popup message START ----- 
  while (Rfound) 
  {
    Rfound = 0;
    if ((Rdirh = opendir(to_sys(RMESSAGEDIR))) > 0) 
    {
      while ((Rsdirent = readdir(Rdirh)) > 0) 
      {
        //RDBG("smbc: RtryReadMessage 1:"); RDBG(Rsdirent->d_name); RDBG(":"); RDBG(RMESSAGEFILE); RDBG("\n");
        if (RstrCmpIncludeFirst(Rsdirent->d_name, RMESSAGEFILE)) 
        {
          Rfound = 1;
          asprintf(&RfileName, "%s/%s", RMESSAGEDIR, Rsdirent->d_name);
          RDBG("smbc: RtryReadMessage found:"); RDBG(RfileName); RDBG("\n");
          if ((Rfh = open(to_sys(RfileName), O_RDONLY)) > 0) 
          {
            while (read(Rfh, &Rch, 1) == 1) 
            {
              if ((Rch == 10) && (!Rl1)) 
              {
                Rl1 = Rll;
                RDBG("smbc: RtryReadMessage Rll = "); RDBG(Rll); RDBG("\n");
                Rll = NULL;
              }
              else 
              {
                if (Rll) 
                  asprintf(&Rl, "%s%c", Rll, Rch);
                else
                  asprintf(&Rl, "%c", Rch);
                free(Rll);
                Rll = Rl;
              }
            }
            Rl2 = Rll;
            close(Rfh);
            RDBG("smbc: RtryReadMessage Rl1 = "); RDBG(Rl1); RDBG("\n");
            RDBG("smbc: RtryReadMessage Rl2 = "); RDBG(Rl2); RDBG("\n");
            RshowMessage(31, Rl1, Rl2, NULL);
            free(Rl1);
            free(Rl2);
          }
          unlink(RfileName);
          free(RfileName);
        }
      }
      closedir(Rdirh);
    }
  }
  // ----- read popup message END ----- 
}

void 
RsendWinpopupInput(char *RgroupInput)
{
  WINDOW *RwinMsg;
  int Rys, Rxs;
  int Rrol = 3;
  int Rxb = 0;
  char Rthost[RMAXGHLEN];
  char Rtmessage[RWINPOPUPMAXLEN];
  int Rdx = 12;
  int Rkey;
  int Rin1 = 0;
  int Rin2 = 0;
  int Rfirst = 1;
  int Rctrlp;
  char *RstrT1;
  
  void 
  Rrefresh(int Rmax, int Rsel)
  {
    char *Rmsg41, *Rmsg42;

    asprintf(&Rmsg41, Rm136);
    asprintf(&Rmsg42, Rm137);
    int Rall = strlen(Rmsg41)+strlen(Rmsg42);

    wattron(RwinMsg, COLOR_PAIR(2));
    RstrT1 = to_scr(Rthost);                      
    if (strlen(RstrT1) > Rmax) 
      RstrT1[Rmax] = 0;
    mvwhline(RwinMsg, 4, Rdx+1, 32, Rxs-Rdx-3); 
    mvwprintw(RwinMsg, 4, Rdx+1, RstrT1);

    RstrT1 = to_scr(Rtmessage); 
    if (strlen(RstrT1) > Rmax) 
      RstrT1[Rmax] = 0;
    mvwhline(RwinMsg, 6, Rdx+1, 32, Rxs-Rdx-3); 
    mvwprintw(RwinMsg, 6, Rdx+1, RstrT1);

    wattroff(RwinMsg, COLOR_PAIR(2));
    switch (Rsel) 
    {
       case 1 : mvwprintw(RwinMsg, Rys-2, (Rxs-Rall)/2, Rmsg41);
                wattron(RwinMsg, COLOR_PAIR(1)); 
                  mvwprintw(RwinMsg, Rys-2, (Rxs-Rall)/2+strlen(Rmsg41)+1, Rmsg42); 
                  wattroff(RwinMsg, COLOR_PAIR(1)); 
                break;
       case 2 : wattron(RwinMsg, COLOR_PAIR(1)); 
                  mvwprintw(RwinMsg, Rys-2, (Rxs-Rall)/2, Rmsg41); 
                  wattroff(RwinMsg, COLOR_PAIR(1)); 
                mvwprintw(RwinMsg, Rys-2, (Rxs-Rall)/2+strlen(Rmsg41)+1, Rmsg42);
                break;
       case 3 : mvwprintw(RwinMsg, Rys-2, (Rxs-Rall)/2, Rmsg41);
                mvwprintw(RwinMsg, Rys-2, (Rxs-Rall)/2+strlen(Rmsg41)+1, Rmsg42);
                break;
    }
    free(Rmsg41); 
    free(Rmsg42);
  }
 
  memcpy(Rthost, RgroupInput, strlen(RgroupInput)+1);
  Rtmessage[0] = 0;

  Rys = 11; Rxs = 70;
  Rxb = Rxs-Rdx-3;
  RwinMsg = newwin(Rys, Rxs, Ry/2-Rys/2, Rx/2-Rxs/2);
  box(RwinMsg,0,0);
  mvwprintw(RwinMsg, 1, Rxs/2-strlen(Rm170)/2, Rm170);
  mvwprintw(RwinMsg, 4, Rdx-strlen(Rm168), Rm168);
  mvwprintw(RwinMsg, 6, Rdx-strlen(Rm169), Rm169);
  Rrefresh(Rxb, Rrol);
  nodelay(RwinMsg, 1);
  RactiveWindow = RwinMsg;
  RDBG("smbc : RsendWinpopupMessage RactiveWindow = RwinMsg  2\n");
  while (Rrol) {
    RtryDownloadUpload();
    if (Rrol == 3) {
      Rin1 = 0;
      Rin2 = 0;
      Rfirst = 1;
      while (readlineOneCharNoDelay(RwinMsg, 4, Rdx+1, Rthost, RMAXGHLEN, Rxb, 3, &Rctrlp, 1, &Rin1, &Rin2, &Rfirst) <= 0) 
        RtryDownloadUpload();
      Rrefresh(Rxb, Rrol);
      Rin1 = 0;
      Rin2 = 0;
      Rfirst = 1;
      while (readlineOneCharNoDelay(RwinMsg, 6, Rdx+1, Rtmessage, RWINPOPUPMAXLEN, Rxb, 3, &Rctrlp, 1, &Rin1, &Rin2, &Rfirst) <= 0) 
        RtryDownloadUpload();

      Rrefresh(Rxb, --Rrol);
    }
    else 
    {
      Rkey = mvwgetch(RwinMsg, 1,1);
      if (Rkey == 9) 
      { 
        if ((--Rrol) == 0) 
          Rrol = 3;
        Rrefresh(Rxb, Rrol);
      }
      if (Rkey == 10) 
      { 
        if (Rrol == 2) 
          RsendWinpopup(Rsmbclient, Rthost, Rtmessage);
        Rrol = 0;
      }
      if (Rkey == 'q') 
        Rrol = 0;
    }
  }
  delwin(RwinMsg);
}

void 
RsigSEGV()
{
  int Rres = errno;

  RDBG("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n");
  RDBG("Fatal error, errno = ");
  RDBGi(Rres);
  RDBG(Rres == EILSEQ?" EILSEQ - Illegal byte sequence":"");
  RDBG("\n");
  RDBG("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n");
  Rerror = 1;
  RsigTerm();
  exit(Rres);
}

//
// ------------------- Rbookmark START ------------------------
//
int 
Rbookmark(RLTYPE *Riselect, char *Riagroup, char *Riahost, char *Riadir, char *RiadirL, char *Rifile, char *Riusername, char *Ripassword, char *RfileOutput)
{
  WINDOW *Rwin = NULL;
  WINDOW *RwinDel = NULL;
  WINDOW *RwinRL = NULL;
  WINDOW *RwinPath = NULL;
  int Rkey;
  TTbookmark *Rbookmarks = NULL;
  TTbookmark *RbookmarksTmp = NULL;
  int Rfirst = 0;
  int Rselect = 0;
  char *RbookmarkFileName;
  int RmaxY;
  unsigned int RcountBookmark;
  int RchangeBookmark = 0;
  int Raction = 0;
  int Riy, Rix;
  int Rcut = 0;
  
  void 
  RpaintList(int Rifirst, int Riselect)
  {
    int Rilast, Ri, Rt;
    int Rk = 0;
    TTbookmark *RbookmarksTmp = Rbookmarks;
    char *RstrTmp;
    
    RgotoXBookmark(&RbookmarksTmp, Rifirst);
    RDBG("smbc Rbookmark_RpaintList RcountBookmark = "); RDBGi(RcountBookmark); RDBG("\n");
    if ((Rifirst == 0) & (RcountBookmark <= RmaxY)) 
      Rilast = RcountBookmark;
    else 
      Rilast = Rifirst + RmaxY;

    for (Ri = Rfirst; Ri < Rilast; Ri++) 
    {
      mvwhline(RwinDel, Rk, 0, 32, 1);
      mvwhline(RwinRL, Rk, 0, 32, 1);
      mvwhline(RwinPath, Rk, 0, 32, Rix-6);
      if (Ri == Rselect) 
      {
        wattron(RwinDel, COLOR_PAIR(1));
        wattron(RwinRL, COLOR_PAIR(1));
        wattron(RwinPath, COLOR_PAIR(1));

        mvwhline(RwinDel, Rk, 0, 32, 1);
        mvwhline(RwinRL, Rk, 0, 32, 1);
        mvwhline(RwinPath, Rk, 0, 32, Rix-6);
      }
      mvwprintw(RwinDel, Rk, 0, "%c", RbookmarksTmp->del);
      mvwprintw(RwinRL, Rk, 0, "%c", RbookmarksTmp->type);

      if (RbookmarksTmp->type == 'R')
        asprintf(&RstrTmp, "%s %s%s", RbookmarksTmp->group, RbookmarksTmp->dir, RbookmarksTmp->file);
      else
        asprintf(&RstrTmp, "%s%s", RbookmarksTmp->dir, RbookmarksTmp->file);
      Rt = strlen(RstrTmp);
      if (Rt > Rix-6)
        RstrTmp[Rix-6] = 0;
      mvwprintw(RwinPath, Rk, 0, to_scr(RstrTmp));
      free(RstrTmp);

      if (Ri == Rselect) 
      {
        wattroff(RwinDel, COLOR_PAIR(1));
        wattroff(RwinRL, COLOR_PAIR(1));
        wattroff(RwinPath, COLOR_PAIR(1));
      }
      RbookmarksTmp = RbookmarksTmp->next;
      Rk++;
    }
    for (Ri = Rilast+1; Ri < Rifirst+RmaxY+1; Ri++) 
    {
      mvwhline(RwinDel, ++Rk, 0, 32, 1);
      mvwhline(RwinRL, Rk, 0, 32, 1);
      mvwhline(RwinPath, Rk, 0, 32, Rix-6);
    }
    wrefresh(RwinPath);
    wrefresh(RwinDel);
    wrefresh(RwinRL);
  }

  void 
  RcreateBookmarkWindow()
  {
    if (Rwin) 
      delwin(Rwin);
    if (RwinDel) 
      delwin(RwinDel);
    if (RwinRL) 
      delwin(RwinRL);
    if (RwinPath) 
      delwin(RwinPath);

    getmaxyx(RwinMain, Riy, Rix);
    RmaxY = Riy-6;
    Rwin = newwin(Riy-2, Rix, 1, 0);
    RwinDel = newwin(Riy-6, 1, 4, 1);
    RwinRL = newwin(Riy-6, 1, 4, 3);
    RwinPath = newwin(Riy-6, Rix-6, 4, 5);
    mvwprintw(Rwin, 1,1, Rm171);
    mvwvline(Rwin, 1, 2, 0, Riy-4);
    mvwvline(Rwin, 1, 4, 0, Riy-4);
    mvwhline(Rwin, 2, 1, 0, Rix-2);
    box(Rwin, 0, 0);
    wrefresh(Rwin);
    wrefresh(RwinDel);
    wrefresh(RwinRL);
    wrefresh(RwinPath);
    keypad(Rwin, TRUE);
    nodelay(Rwin, 1);
    RactiveWindow = Rwin;
    RDBG("smbc : RcreateBookmarkWindow RactiveWindow = Rwin  2\n");
    RstatusBar(23);
    RpaintList(Rfirst, Rselect);
  }

  void 
  RresizeBookmark()
  {
    if (RdoResizeBookmark) 
    {
      RdoResizeBookmark = 0;
      RdoWindowResize();
      RcreateBookmarkWindow();
    }
  }

  asprintf(&RbookmarkFileName, "%s/.smbc/bookmark", from_sys(getenv("HOME")));
  RopenBookmark(&Rbookmarks, RbookmarkFileName);
  RcountBookmark = RgetBookmarkCount(Rbookmarks);

  RcreateBookmarkWindow();

  while (1) 
  {
    Rkey = mvwgetch(Rwin, 1, 1);
    RtryDownloadUpload();
    RresizeBookmark();
    if (Rkey == 'q') 
      break;
    if (Rkey == 'm') 
    {
      if (Rcut) 
      {
        Rcut = 0;
        RstatusBar(23);
      }
      else 
      {
        Rcut = 1;
        RstatusBar(24);
      }
    }
    if (Rkey == 'b') 
    {
      if (!RfindInBookmark(&Rbookmarks, *Riselect == RLREMOTE?'R':'L', Riagroup, Riahost, *Riselect == RLREMOTE?Riadir:RiadirL, Rifile, Riusername, Ripassword)) {
        RaddToBookmark(&Rbookmarks, *Riselect == RLREMOTE?'R':'L', Riagroup, Riahost, *Riselect == RLREMOTE?Riadir:RiadirL, Rifile, Riusername, Ripassword);
        RchangeBookmark = 1;
      }
      else 
        RshowMessage(32, Rm172,NULL,NULL);
      break;
    }
    if (Rkey == 'd' || Rkey == KEY_DC) 
    {
       RgotoXBookmark(&Rbookmarks, Rselect);
       Rbookmarks->del = 'D';
       RchangeBookmark = 1;
       Rkey = KEY_DOWN;
    }
    if (Rkey == 'u') 
    {
       RgotoXBookmark(&Rbookmarks, Rselect);
       Rbookmarks->del = 'X';
       RchangeBookmark = 1;
       Rkey = KEY_DOWN;
    }
    if (Rkey == KEY_DOWN || Rkey == 'o') 
    {
      RgotoXBookmark(&Rbookmarks, Rselect);
      if ((Rcut) && (Rbookmarks->next)) 
      {
        RchangeBookmark = 1;
        RbookmarksTmp = Rbookmarks;
        if (Rbookmarks->previous)
          Rbookmarks->previous->next = Rbookmarks->next;
        Rbookmarks->next->previous = Rbookmarks->previous;

        Rbookmarks = Rbookmarks->next;

        RbookmarksTmp->previous = Rbookmarks;
        RbookmarksTmp->next = Rbookmarks->next;
        
        if (Rbookmarks->next)
          Rbookmarks->next->previous = RbookmarksTmp;
        Rbookmarks->next = RbookmarksTmp;
      }
      if ((Rselect+1 == Rfirst+RmaxY) & (Rfirst+RmaxY < RcountBookmark)) 
      {
        Rfirst++; 
        Rselect++;
      }
      else 
        if (Rselect < RcountBookmark-1) 
          Rselect++;
      RDBG("smbc Rbookmark Rfirst = "); RDBGi(Rfirst); RDBG(", Rselect = "); RDBGi(Rselect); RDBG("\n");
      RpaintList(Rfirst,Rselect);
    }
    if (Rkey == KEY_UP || Rkey == 'p') 
    {
      RgotoXBookmark(&Rbookmarks, Rselect);
      if ((Rcut) && (Rbookmarks->previous)) 
      {
        RchangeBookmark = 1;
        RbookmarksTmp = Rbookmarks;
        if (Rbookmarks->next)
          Rbookmarks->next->previous = Rbookmarks->previous;
        Rbookmarks->previous->next = Rbookmarks->next;

        Rbookmarks = Rbookmarks->previous;

        RbookmarksTmp->next = Rbookmarks;
        RbookmarksTmp->previous = Rbookmarks->previous;
        
        if (Rbookmarks->previous)
          Rbookmarks->previous->next = RbookmarksTmp;
        Rbookmarks->previous = RbookmarksTmp;
      }
      if (Rselect > 0) 
      {
        if ((Rfirst > 0) && (Rselect == Rfirst)) 
        { 
          Rfirst--; 
          Rselect--; 
        } 
        else 
          Rselect--;
        RpaintList(Rfirst,Rselect);
      }
    }
    if (Rkey == KEY_NPAGE || Rkey == 'k') 
    {
      if (Rfirst+RmaxY <= RcountBookmark) 
      {
        if (Rselect+1 == Rfirst+RmaxY) 
        {
           if (Rselect+RmaxY < RcountBookmark) 
           {
              Rfirst = Rselect;
              Rselect = Rfirst+RmaxY-1;
           }
           else 
           {
              Rfirst = RcountBookmark-RmaxY;
              Rselect = RcountBookmark-1;
           }
        }
        else 
        {
          if (Rselect+RmaxY <= RcountBookmark) 
            Rselect = Rfirst+RmaxY-1;
          else
            Rselect = RcountBookmark-1;
        }
      }
      RpaintList(Rfirst,Rselect);
    }
    if (Rkey == KEY_PPAGE || Rkey == 'l') 
    {
      if (Rselect > 1) 
      {
        if (Rfirst == Rselect) 
        {
          if (Rfirst - RmaxY < 1) 
          {
            Rfirst = 1;
            Rselect = 1;
          }
          else 
          {
            Rfirst = Rfirst - RmaxY + 1;
            Rselect = Rfirst;
          }
        }
        else 
          Rselect = Rfirst;
        RpaintList(Rfirst,Rselect);
      }
    }
    if (Rkey == 10 || Rkey == 'x') 
    {
      Raction = 1;
      RgotoXBookmark(&Rbookmarks, Rselect);
      if (Rbookmarks->type == 'L') 
      {
        *Riselect = RLLOCAL;
        strcpy(RiadirL, Rbookmarks->dir);
        strcpy(RfileOutput, Rbookmarks->file);
      }
      else 
      {
        *Riselect = RLREMOTE;
        strcpy(Riagroup, Rbookmarks->group);
        strcpy(Riahost, Rbookmarks->host);
        strcpy(Riadir, Rbookmarks->dir);
        strcpy(RfileOutput, Rbookmarks->file);
        strcpy(Riusername, Rbookmarks->username);
        strcpy(Ripassword, Rbookmarks->password);
      }
      break;
    }
  };
  if (RchangeBookmark)
    RsaveBookmark(Rbookmarks, RbookmarkFileName);
  delwin(Rwin);
  delwin(RwinDel);
  delwin(RwinRL);
  delwin(RwinPath);
  RfreeBookmark(Rbookmarks);
  free(RbookmarkFileName);
  return(Raction);
}
//
// ------------------- Rbookmark END ------------------------
//

/* detect smbc find index process and run them if not exist */

void 
RtryLockFileAndCreateIndexFile()
{
  if (!RlockFileFlag) 
  {
    RlockFile = open(to_sys(RsmbcLockFile), O_RDWR | O_CREAT, 0700);
    if (RlockFile > 0) 
    {
      if (!flock(RlockFile, LOCK_EX | LOCK_NB)) 
      {
        RlockFileFlag = 1;
        unlink(RfileNameForFindList);
        unlink(RfileNameMessage);
        RcreateFindIndex(RlockFileFlag, RlockFile, RsmbcLockFile);
      }
      else 
        close(RlockFile);
    }
    if (RrunFirst) 
    {
      signal(SIGCHLD, RsigCHLD);
      signal(SIGSEGV, RsigSEGV);
      signal(SIGTERM, RsigTerm);
      signal(SIGINT, RsigTerm);
      signal(SIGALRM, RsigAlarm);
      RrunFirst = 0;
    }
  }
}

int 
RtryDownloadUpload() 
{
  if (RdownloadList != NULL) 
  {
    if (!RdontDownload)
      RdownloadUpload();  
      RstatusBarStatus = 1;
      if (RactuallyNothingDownloadUpload) 
      {
        nodelay(RactiveWindow, 0);
        RDBG("smbc : RtryDownloadUpload nodelay = 0\n");
      }
      else 
      {
        nodelay(RactiveWindow, 1);
        RDBG("smbc : RtryDownloadUpload nodelay = 1\n");
      }
      return(1);
    }
    else 
    {
      if (RstatusBarStatus) 
      {
        RstatusBar(0);
        RstatusBarStatus = 0;
      }
      nodelay(RactiveWindow, 0);
      RDBG("smbc : RtryDownloadUpload nodelay = 0  2\n");
    }
  return(0);
}

void 
RsigAlarm()
{
  char RinsertChar = 1;

  /*  enter unused char to keyboard buffer
      necessery because mvwgetch may be wait for char  */

  ioctl(0, TIOCSTI, &RinsertChar);

#ifdef HAVE_DEBUG
  RDBG("smbc : RsigAlarm\n");
  RDBG("smbc : RsigAlarm RdownloadList == "); RDBGi((int)RdownloadList); RDBG("\n");
  int ifdefi = RgetdownloadListCount();
  RDBG("smbc : RsigAlarm RgetdownloadListCount() == "); RDBGi(ifdefi); RDBG("\n");
#endif /* HAVE_DEBUG */

  if (!RdontResizeWindow)
    RdoWindowResize();

  RtryLockFileAndCreateIndexFile();
  RtryReadMessage();
  RDBG("smbc : RsigAlarm 4\n");

  alarm(RCalarm);
}

int 
main(int argc,char *argv[])
{
 int Rnr;
 int Rkey;
 int Rx, Ry;
 char *RagroupT;
 char *RadirTmpPr;
 char RstrTmp[1000];
 int Ri, Rwhat;
 char *Rstr, *RstrT;
 char Ropt;
 poptContext Rpopt;
 int RnrDulist;
 char *RargMessageIn;
 char *RargFileNameIn;
 char *RargMessage = NULL;
 char *RargFileName = NULL;
 int RchangePos;
 char *Rtmps;

 struct poptOption Roptions[] = {
   { "help", 'h', POPT_ARG_NONE, NULL, 'h', 0, 0 },
   { "flush", 'f', POPT_ARG_NONE, NULL, 'f', 0, 0 },
   { "list", 'l', POPT_ARG_NONE, NULL, 'l', 0, 0 },
   { "show", 's', POPT_ARG_INT, &RnrDulist, 's', 0, 0 },
   { "sleep", 'p', POPT_ARG_NONE, NULL, 'p', 0, 0 },
   { "message", 'm', POPT_ARG_STRING, &RargMessageIn, 'm', 0, 0 },
   { "file", 'i', POPT_ARG_STRING, &RargFileNameIn, 'i', 0, 0 },
   { "version", 'V', POPT_ARG_NONE, NULL, 'V', 0, 0 },
   { NULL, 0, 0, NULL, 0, NULL, NULL }
 };

 void 
 RrefreshR()
 {
   if (Rselected == RLLOCAL) 
   {
     Rnr = RgetFileFromDirL(RadirL);
     RinitList(Rnr,0,0);
     RleftFirst = 0;
     RleftPos = 0;
     RwriteMenuTxt(RleftFirst,0,RLLOCAL,RleftPos); 
   }
   else 
   {
     switch (RremoteLevel) 
     {
        case 0: Rnr = RgetMasterList(); 
                break;
        case 1: Rnr = RgetHostsFromGroup(Ragroup); 
                break;
        case 2: Rnr = RgetSharesFromHost(Rahost); 
                break;
        case 3: Rnr = RgetFileFromDirR(Radir); 
                break;
     }
     RinitList(Rnr,RremoteLevel,1); 
     RrightFirst = 0;
     RrightPos = 0;
     RDBG("smbc: RrefreshR !!! 1 !!!\n");
     RwriteMenuTxt(RrightFirst,RremoteLevel,RLREMOTE,RrightPos);
   }
 }

// ----------------------------------------------------------------------- 
// ----------------------------------------------------------------------- 
 setlocale(LC_ALL, "");
 bindtextdomain("smbc", LOCALEDIR);
 textdomain("smbc");

 RinitIconv();
 RinitStrings();

 asprintf(&RsmbcLockFile, "%s/.smbc/debug", from_sys(getenv("HOME")));
 RinitDebug(RsmbcLockFile);

/*
 Rstr = malloc(6); Ri = 1; RgetHumanSize(Rstr, 6, Ri); printf("         %i|%s|\n", Ri, Rstr); free(Rstr);
 Rstr = malloc(6); Ri = 10; RgetHumanSize(Rstr, 6, Ri); printf("        %i|%s|\n", Ri, Rstr); free(Rstr);
 Rstr = malloc(6); Ri = 100; RgetHumanSize(Rstr, 6, Ri); printf("       %i|%s|\n", Ri, Rstr); free(Rstr);
 Rstr = malloc(6); Ri = 1000; RgetHumanSize(Rstr, 6, Ri); printf("      %i|%s|\n", Ri, Rstr); free(Rstr);
 Rstr = malloc(6); Ri = 1024; RgetHumanSize(Rstr, 6, Ri); printf("      %i|%s|\n", Ri, Rstr); free(Rstr);
 Rstr = malloc(6); Ri = 1025; RgetHumanSize(Rstr, 6, Ri); printf("      %i|%s|\n", Ri, Rstr); free(Rstr);
 Rstr = malloc(6); Ri = 5025; RgetHumanSize(Rstr, 6, Ri); printf("      %i|%s|\n", Ri, Rstr); free(Rstr);
 Rstr = malloc(6); Ri = 629145600; RgetHumanSize(Rstr, 6, Ri); printf(" %i|%s|\n", Ri, Rstr); free(Rstr);
 exit(0);
*/

 Roptions[0].descrip = Rm300;
 Roptions[1].descrip = Rm301;
 Roptions[2].descrip = Rm302;
 Roptions[3].descrip = Rm303;
 Roptions[4].descrip = Rm304;
 Roptions[5].descrip = Rm305;
 Roptions[6].descrip = Rm306;
 Roptions[7].descrip = Rm307;

 Rpopt = poptGetContext("smbc", argc, (const char **) argv, Roptions, POPT_CONTEXT_KEEP_FIRST);
 poptSetOtherOptionHelp(Rpopt, Rm173);

 while ((Ropt = poptGetNextOpt(Rpopt)) >= 0) 
 {
   if (Ropt == POPT_ERROR_BADNUMBER) 
     exit(0);
   switch (Ropt) 
   {
     case 'h': poptPrintHelp(Rpopt, stderr, 0);
               exit(0);
     case 'f': RflushAllDownloadLists();
               exit(0);
     case 'l': RlistAllDownloadLists();
               exit(0);
     case 's': RShowAllItemsFromDUlist(RnrDulist);
               exit(0);
     case 'p': RdontDownload = 1;
               break;
     case 'm': RargMessage = strdup(RargMessageIn);
               if (RsaveMessage(RargMessage, RargFileName))
                 exit(0);
               break;
     case 'i': RargFileName = strdup(RargFileNameIn);
               if (RsaveMessage(RargMessage, RargFileName))
                 exit(0);
               break;
     case 'V': RdisplayVersion();
               exit(0);
   }
 }
 if (Ropt < -1) 
 {
   fprintf(stderr, "%s: %s\n", poptBadOption(Rpopt, POPT_BADOPTION_NOALIAS), poptStrerror(Ropt));
   exit(0);
 }
 poptFreeContext(Rpopt);

 Ragroup[0] = 0;
 Rahost[0] = 0;
 Radir[0] = 0;


 free(RsmbcLockFile);
 RDBG("----start----\n");

 asprintf(&RsmbcLockFile, "%s/.smbc/smbc.lock", from_sys(getenv("HOME")));

 strcpy(RadirL, from_sys(getenv("HOME")));
 strcpy(Rusername, RGUEST);
 Rpassword[0] = 0;

 RreadRcfile(); 

 RopenSaveDownloadList(1);
 if (strlen(RadirL) > 0) 
   if (RadirL[strlen(RadirL)-1] != '/') 
     memcpy(RadirL+strlen(RadirL), "/", 2); 

 signal(SIGWINCH, RresizeHandler);

 if(Rsmbc_init(Rget_auth_data, 0) < 0) 
 {
   fprintf(stderr, Rm175, errno);
   if (errno == 2) 
     fprintf(stderr, Rm176);
   exit(0);
 }

#ifdef HAVE_SMBCCTX
 Rstatcont = Rsmbc_new_context();
 if (!Rstatcont)
     return -1;
 Rstatcont->debug = 0;
 Rstatcont->callbacks.auth_fn = Rget_auth_data;
 if (!Rsmbc_init_context(Rstatcont)) 
 {
   Rsmbc_free_context(Rstatcont, 0);
   return -1;
 }
 Rstatcont->timeout = Rtimeout;
#endif /* HAVE_SMBCCTX */

 asprintf(&RfileNameForFindList, "%s/.smbc/findfile", from_sys(getenv("HOME")));
 asprintf(&RfileNameForFindListPrim, "%s/.smbc/findfileprim", from_sys(getenv("HOME")));
 asprintf(&RfileNameMessage, "%s/.smbc/message", from_sys(getenv("HOME")));
 asprintf(&RfileNameMessagePrim, "%s/.smbc/messageprim", from_sys(getenv("HOME")));

#ifdef HAVE_SET_CONTEXT
   Rsmbc_set_context(Rstatcont);
#else /* not HAVE_SET_CONTEXT */
   printf(Rm177);
#endif /* not HAVE_SET_CONTEXT */

 RtryLockFileAndCreateIndexFile();
 
 RwriteMenu(1);
 RDBG("smbc: after RwriteMenu(1)\n");
 Rnr = RgetFileFromDirL(RadirL);
 RDBG("smbc: after Rnr = RgetFileFromDirL(RadirL);\n");
 RinitList(Rnr,0,0);
 RDBG("smbc: after RinitList(Rnr,0,0);\n");
 if ((strlen(Radir) > 0) & (strlen(Rahost) > 0) & (strlen(Ragroup) > 0)) 
 {
   RDBG("smbc: after RremoteLevel = 3\n");
   asprintf(&RagroupT, "smb://%s/%s", Rahost, Radir);
   strcpy(Radir, RagroupT);
   RDBG("smbc: after memcpy(Radir, RagroupT, strlen(RagroupT)+1);\n");
   free(RagroupT);
   if (Radir[strlen(Radir)-1] != '/') 
     memcpy(Radir+strlen(Radir), "/", 2);
   Rnr = RgetFileFromDirR(Radir);
   RremoteLevel = 3;
 } 
 else
   if ((strlen(Rahost) > 0) & (strlen(Ragroup) > 0)) 
   {
     RDBG("smbc: after RremoteLevel = 2\n");
     Rnr = RgetSharesFromHost(Rahost);
     RremoteLevel = 2;
   } 
   else
     if (strlen(Ragroup) > 0) 
     {
       RDBG("smbc: after RremoteLevel = 1\n");
       Rnr = RgetHostsFromGroup(Ragroup);
       RremoteLevel = 1;
     }
     else 
     {
       RDBG("smbc: before Rnr = RgetMasterList();\n");
       Rnr = RgetMasterList();
       RDBG("smbc: after Rnr = RgetMasterList();\n");
     };

 RinitList(Rnr,RremoteLevel,1);
 RDBG("smbc: after RinitList(Rnr,RremoteLevel,1);\n");
 RwriteMenuTxt(RleftFirst,0,RLLOCAL,RleftPos);
 RwriteMenuTxt(RrightFirst,RremoteLevel,RLREMOTE,RrightPos);
 getmaxyx(RwinRightCol2, Ry, Rx);

 keypad(RwinMain, TRUE); 
 nodelay(RwinMain, 1);
 RDBG("smbc: before main while\n");
 while ((Rkey = mvwgetch(RwinMain, 1,1))) 
 {
   RactiveWindow = RwinMain;
   RDBG("smbc : main RactiveWindow = RwinMain  2\n");
   alarm(RCalarm);
   getmaxyx(RwinRightCol2, Ry, Rx);
   /* 
    *  (v, F3) - view file, execude directory
    */
   if ((Rkey == 'v') || (Rkey == 267)) 
   {                                                  
     if (Rselected == RLLOCAL) 
     { 
       if (RlistLeft[RleftFirst+RleftPos]->col1[0] == 'F') 
       {
         asprintf(&Rstr, "%s/%s", RadirL, RlistLeft[RleftFirst+RleftPos]->col2);
         RviewFile(Rselected, Rstr);
         free(Rstr);
         wclear(RwinMain);
         RwinRedrawWithData(); 
       } 
       else 
         Rkey = 10;
     } 
     else 
     {
       if (RlistRight[RrightFirst+RrightPos]->col1[0] == 'F') 
       {
         asprintf(&Rstr, "%s/%s", Radir, RlistRight[RrightFirst+RrightPos]->col2);
         RviewFile(Rselected, Rstr);
         free(Rstr);
         wclear(RwinMain);
         RwinRedrawWithData(); 
       } 
       else 
         Rkey = 10;
     }
   }
   /* 
    *  (x, enter) - execude directory
    */
   if (Rkey == 10 || Rkey == 'x') 
   {
     if (Rselected == RLLOCAL) 
     { 
       if (RlistLeft[RleftFirst+RleftPos]->col1[0] == 'D') 
       {
          strcpy(RadirLtmp, RadirL);
          RchdirL(RadirLtmp, RlistLeft[RleftFirst+RleftPos]->col2);
          Rnr = RgetFileFromDirL(RadirLtmp);
          if (Rnr != -1) 
          {
            strcpy(RadirOld, RadirL); 
            strcpy(RadirL, RadirLtmp);
            RinitList(Rnr,0,0);

            RgetFileFromTwoDirs(&RfileNamePos, RadirOld, RadirL);
            RsetSelect(&RleftFirst, &RleftPos, RfileNamePos , RLLOCAL);
            free(RfileNamePos);

            RwriteMenuTxt(RleftFirst,0,RLLOCAL,RleftPos);
          }
       }
     }
     else 
     {
       if (RlistRight[RrightFirst+RrightPos]->col1[0] == 'D') 
       {
          if (RstrCmp(RlistRight[RrightFirst+RrightPos]->col2, "..")) 
          {
            if (RremoteLevel == 1) 
            {
               Rnr = RgetMasterList();
               RremoteLevel = 0;
               RDBG("smbc: main !!! 1-1 !!!\n");
               RinitList(Rnr,RremoteLevel,1);

               RsetSelect(&RrightFirst, &RrightPos, Ragroup , RLREMOTE);
               Ragroup[0] = 0;

               RDBG("smbc: main !!! 1-1 !!!\n");
               RwriteMenuTxt(RrightFirst,RremoteLevel,RLREMOTE,RrightPos); 
            } 
            else
              if (RremoteLevel == 2) 
              {
                 RDBG("smbc: main !!! 2-1 !!!->"); RDBG(Rahost); RDBG("\n");
                 Rnr = RgetHostsFromGroup(Ragroup);
                 RremoteLevel = 1;
                 RDBG("smbc: main !!! 2-1 !!!\n");
                 RinitList(Rnr,RremoteLevel,1);

                 RsetSelect(&RrightFirst, &RrightPos, Rahost , RLREMOTE);
                 Rahost[0] = 0;

                 RDBG("smbc: main !!! 2-1 !!!\n");
                 RwriteMenuTxt(RrightFirst,RremoteLevel,RLREMOTE,RrightPos); 
              } 
            if (RremoteLevel == 3) 
            {
              RadirTmpPr = strdup(Radir);
              strcpy(RadirTmp, Radir);
              strcpy(RadirOld, Radir);
              RchdirL(Radir, RlistRight[RrightFirst+RrightPos]->col2);
              RgetSmallPath(RadirTmp); 
              if (RstrCmp(Radir, RadirTmp)) 
              {
                 Rnr = RgetSharesFromHost(Rahost);
                 RremoteLevel = 2;
                 RDBG("smbc: main !!! 3-1 !!!\n");
                 RinitList(Rnr,RremoteLevel,1);

                 RgetFileFromTwoDirs(&RfileNamePos, RadirOld, Radir);
                 RsetSelect(&RrightFirst, &RrightPos, RfileNamePos, RLREMOTE);
                 free(RfileNamePos);
                 Radir[0] = 0;

                 RDBG("smbc: main !!! 3-2 !!!\n");
                 RwriteMenuTxt(RrightFirst,RremoteLevel,RLREMOTE,RrightPos); 
              }
              else 
              {
                Rnr = RgetFileFromDirR(Radir);
                if (Rnr != -1) 
                {
                  RDBG("smbc: main !!! 4-1 !!!\n");
                  RinitList(Rnr,RremoteLevel,1);

                  RgetFileFromTwoDirs(&RfileNamePos, RadirOld, Radir);
                  RsetSelect(&RrightFirst, &RrightPos, RfileNamePos , RLREMOTE);
                  free(RfileNamePos);

                  RDBG("smbc: main !!! 4-2 !!!\n");
                  RwriteMenuTxt(RrightFirst,RremoteLevel,RLREMOTE,RrightPos); 
                }  
                else 
                {
                  strcpy(Radir, RadirTmp);
                  RshowMessage(22,RlistRight[RrightFirst+RrightPos]->col2,"",NULL);
                }
              }
              free(RadirTmpPr);
            } 
          } 
          else 
          {
            strcpy(RadirTmp, Radir);
            sprintf(Radir+strlen(Radir), "%s/", RlistRight[RrightFirst+RrightPos]->col2);
            Rnr = RgetFileFromDirR(Radir);
            if (Rnr != -1) 
            {
              RDBG("smbc: main !!! 5-1 !!!\n");
              RinitList(Rnr,RremoteLevel,1);

              RsetSelect(&RrightFirst, &RrightPos, NULL , RLREMOTE);

              RDBG("smbc: main !!! 5-2 !!!\n");
              RwriteMenuTxt(RrightFirst,RremoteLevel,RLREMOTE,RrightPos);
              RDBG("smbc: main !!! 5-3 !!!\n");
            } 
            else 
            {
              strcpy(Radir, RadirTmp);
              RshowMessage(22,RlistRight[RrightFirst+RrightPos]->col2,"",NULL);
            }
          }
       }
       else
         if (RlistRight[RrightFirst+RrightPos]->col1[0] == 'W') 
         {
           strcpy(Ragroup, RlistRight[RrightFirst+RrightPos]->col2);
           strcpy(RadirLtmp, Ragroup);
           Rnr = RgetHostsFromGroup(Ragroup);
           if (Rnr > 0) 
           {
             RremoteLevel = 1;
             RinitList(Rnr,RremoteLevel,1);

             RgetFileFromTwoDirs(&RfileNamePos, RadirOld, RadirL);
             RsetSelect(&RrightFirst, &RrightPos, NULL , RLREMOTE);
             free(RfileNamePos);

             RwriteMenuTxt(RrightFirst,RremoteLevel,RLREMOTE,RrightPos); 
           } 
           else 
           {
             Ragroup[0] = 0;
             RshowMessage(20, RadirLtmp,"",NULL);
           }
         }
         else
           if (RlistRight[RrightFirst+RrightPos]->col1[0] == 'H') 
           {
             strcpy(Rahost, RlistRight[RrightFirst+RrightPos]->col4);
             strcpy(RadirLtmp, Rahost);
             Rnr = RgetSharesFromHost(Rahost);
             if (Rnr > 0) 
             {
               RremoteLevel = 2;
               RinitList(Rnr,RremoteLevel,1);

               RsetSelect(&RrightFirst, &RrightPos, NULL , RLREMOTE);

               RwriteMenuTxt(RrightFirst,RremoteLevel,RLREMOTE,RrightPos);
             } 
             else 
               if (Rnr == 0) 
               {
                 Rahost[0] = 0;
                 RshowMessage(21, RadirLtmp,"",NULL);
               }
           } 
           else
             if (RlistRight[RrightFirst+RrightPos]->col1[0] == 'S') 
             {
               RgetSmallPath(Radir); 
               RstrT = strdup(Radir);
               sprintf(Radir+strlen(Radir), "%s/", RlistRight[RrightFirst+RrightPos]->col4);
               Rnr = RgetFileFromDirR(Radir);
               if (Rnr > 0) 
               {
                 RremoteLevel = 3;
                 RinitList(Rnr,RremoteLevel,1);
                 RsetSelect(&RrightFirst, &RrightPos, NULL , RLREMOTE);
                 RwriteMenuTxt(RrightFirst,RremoteLevel,RLREMOTE,RrightPos);
               }
               else 
                 if (Rnr == -1)
                 {
                   RshowMessage(27, Radir,"",NULL);
                   strcpy(Radir, RstrT);
                 }
               free(RstrT);
             } 
     }
   }
   /* 
    *  (CTRL-d, F8) - delete 
    */
   if (Rkey == 4 || Rkey == 272) 
   {
    if (!RdetectScreenToSmall()) 
    {
     Rwhat = 0;
     if (Rselected == RLREMOTE) 
     {
       for (Ri = 0; Ri < RlistRightMax; Ri++) 
         if (RlistRight[Ri]->select) 
         { 
           Rwhat = 1; 
           break; 
         }
       if (Rwhat) 
       {
         if (RshowMessage(2, Rm178,"",NULL)) 
         {
           for (Ri = 0; Ri < RlistRightMax; Ri++) 
            if (RlistRight[Ri]->select) 
            { 
               char *Rstr;
               asprintf(&Rstr, "%s%s", Radir, RlistRight[Ri]->col2);
               if (RlistRight[Ri]->col1[0] == 'F') 
               {
                 if (Rsmbc_unlink(Rstr)) 
                   RshowMessage(27,Rstr,"",NULL);
               }
               else 
               {
                 if (RremoveDirR(Rstr)) 
                   RshowMessage(27,Rstr,"",NULL);
                 RwinRedrawWithData();
               }
               free(Rstr);
               Rkey = 'r';
            }
         }
       } 
       else 
       {
         if (!RstrCmp(RlistRight[RrightFirst+RrightPos]->col2,"..")) 
          if (RshowMessage(2,RlistRight[RrightFirst+RrightPos]->col2,"",NULL)) 
          {
            asprintf(&Rstr, "%s%s", Radir, RlistRight[RrightFirst+RrightPos]->col2);
            if (RlistRight[RrightFirst+RrightPos]->col1[0] == 'F') 
            {
               if (Rsmbc_unlink(Rstr)) 
                 RshowMessage(27,Rstr,"",NULL);
            }
            else 
            {
              if (RremoveDirR(Rstr)) 
                RshowMessage(27,Rstr,"",NULL);
              RwinRedrawWithData();
            }
            free(Rstr);
            Rkey = 'r';
          }
       }
     } 
     else 
     {
       for (Ri = 0; Ri < RlistLeftMax; Ri++) 
         if (RlistLeft[Ri]->select) 
         { 
           Rwhat = 1; 
           break; 
         }
       if (Rwhat) 
       {
         if (RshowMessage(2, Rm178,"",NULL)) 
         {
           for (Ri = 0; Ri < RlistLeftMax; Ri++) 
            if (RlistLeft[Ri]->select) 
            { 
               asprintf(&Rtmps, "%s%s", RadirL, RlistLeft[Ri]->col2);
               if (RlistLeft[Ri]->col1[0] == 'F') 
                 unlink(Rtmps);
               else 
               {
                 RremoveDir(Rtmps);
                 RwinRedrawWithData();
               }
               free(Rtmps);
               Rkey = 'r';
            }
         }
       } 
       else {
         if (!RstrCmp(RlistLeft[RleftFirst+RleftPos]->col2,"..")) 
          if (RshowMessage(2,RlistLeft[RleftFirst+RleftPos]->col2,"",NULL)) 
          {
            asprintf(&Rtmps, "%s%s", RadirL, RlistLeft[RleftFirst+RleftPos]->col2);
            if (RlistLeft[RleftFirst+RleftPos]->col1[0] == 'F') 
              unlink(Rtmps);
            else 
            { 
              RremoveDir(Rtmps);
              RwinRedrawWithData();
            }
            free(Rtmps);
            Rkey = 'r';
          }
       }
     }
    }
    else 
      RwinRedrawWithData();
   }
   /* 
    *  (m) - send WinPopup message
    */
   if (Rkey == 'm') 
   {
     if (!RdetectScreenToSmall()) 
     {
       if (RremoteLevel == 1)
         RsendWinpopupInput(RlistRight[RrightFirst+RrightPos]->col4);
       else 
         if (RremoteLevel > 1)
           RsendWinpopupInput(Rahost);
         else 
           RsendWinpopupInput("");
       Rkey = 'r';
     }
     RwinRedrawWithData();
   }
   /* 
    *  (g) - goto share, host or workgroup
    */
   if (Rkey == 'g') 
   {
     if (Rselected == RLREMOTE) 
     {
       if (RsetManualyLocation(1,Ragroup, Rahost, Radir,Rusername,Rpassword) == 1) 
       {
         if (strlen(Ragroup) > 0) 
           RremoteLevel = 1;
         else 
           RremoteLevel = 0;
         if (strlen(Rahost) > 0) 
         {
           RremoteLevel = 2;
           if (strlen(index(Radir+6+strlen(Rahost),'/')) > 1) 
             RremoteLevel = 3;
         }
         Rkey = 'r';
       }
     }
   }
   /* 
    *  (c, F7) - create directory
    */
   if (Rkey == 'c' || Rkey == 271) 
   {
    if (!RdetectScreenToSmall()) 
    {
     if (Rselected == RLREMOTE) 
     {
       if (RremoteLevel == 3) 
       {
         RcreateDir(Rselected,Radir);
         Rkey = 'r';  
       }
     }
     else 
     {
       RcreateDir(Rselected,RadirL);
       Rkey = 'r';
     }
    }
    else RwinRedrawWithData();
   }
   if (Rkey == 'f') 
   {
     if (!RdetectScreenToSmall()) 
     {
       if(Rselected == RLREMOTE) 
       {
         if (RfindFileSmb(Radir, RstrTmp)) 
         {
           RrefreshR();
           RsetSelect(&RrightFirst, &RrightPos, RstrTmp, Rselected);
         }
         RwriteMenuTxt(RrightFirst,RremoteLevel,RLREMOTE,RrightPos);
       }
     } 
     else 
       RwinRedrawWithData();
   }
   /* 
    *  (e) - sort change
    */
   if (Rkey == 'e') 
   {
     if (Rselected == RLREMOTE) 
     {
       RsortMethodR++;
       if (RsortMethodR > 4) 
         RsortMethodR = 1;
       RstatusBar(8+RsortMethodR);
     }
     else 
     {
       RsortMethodL++;
       if (RsortMethodL > 4) 
         RsortMethodL = 1;
       RstatusBar(8+RsortMethodL);
     }
     Rkey = 'r';
   }
   /* 
    *  (w) - sort reverse/unreverse
    */
   if (Rkey == 'w') 
   {
     if (Rselected == RLREMOTE) 
     {
       if (RsortReverseR) 
         RsortReverseR = 0;
       else 
         RsortReverseR = 1;
       RstatusBar(13);
     }
     else 
     {
       if (RsortReverseL) 
         RsortReverseL = 0;
       else 
         RsortReverseL = 1;
       RstatusBar(13);
     }
     Rkey = 'r';
   }
   /* 
    *  (t) - group/ungroup files and directories
    */
   if (Rkey == 't') 
   {
     if (Rselected == RLREMOTE) 
     {
       if (RgroupFilesDirectoriesR) 
         RgroupFilesDirectoriesR = 0;
       else 
         RgroupFilesDirectoriesR = 1;
       RstatusBar(14+RgroupFilesDirectoriesR);
     }
     else 
     {
       if (RgroupFilesDirectoriesL) 
         RgroupFilesDirectoriesL = 0;
       else 
         RgroupFilesDirectoriesL = 1;
       RstatusBar(14+RgroupFilesDirectoriesL);
     }
     Rkey = 'r';
   }
   /* 
    *  (b) - bookmark
    */
   if (Rkey == 'b') 
   {
     RstrT = NULL;
     RchangePos = 0;
     if (!RdetectScreenToSmall()) 
     {
       if (Rselected == RLREMOTE) 
       {
         if (Rbookmark(&Rselected, Ragroup, Rahost, Radir, RadirL, RlistRight[RrightFirst+RrightPos]->col2, Rusername, Rpassword, RstrTmp))
           RchangePos = 1;
       }
       else 
       {
         if (Rbookmark(&Rselected, Ragroup, Rahost, Radir, RadirL, RlistLeft[RleftFirst+RleftPos]->col2, Rusername, Rpassword, RstrTmp)) 
           RchangePos = 1;
       }
       if (RchangePos) 
       {
         RDBG("smbc main_Rbookmark : 1RremoteLevel = "); RDBGi(RremoteLevel); RDBG("\n");
         if (Rselected == RLLOCAL) 
         {
           RstrT = strdup(RstrTmp);
           Rnr = RgetFileFromDirL(RadirL);
           if (Rnr != -1) 
           {
             RinitList(Rnr,0,0);
             RsetSelect(&RleftFirst, &RleftPos, RstrT , RLLOCAL);
           }
         }
         else 
         {
           RDBG("smbc main_Rbookmark : 2RremoteLevel = "); RDBGi(RremoteLevel); RDBG("\n");
           if (strlen(Ragroup) > 0) 
             RremoteLevel = 1;
           else 
             RremoteLevel = 0;
           if (strlen(Rahost) > 0) 
           {
             RremoteLevel = 2;
             if (strlen(index(Radir+6+strlen(Rahost),'/')) > 1) 
               RremoteLevel = 3;
           }
           RDBG("smbc main_Rbookmark : 3RremoteLevel = "); RDBGi(RremoteLevel); RDBG("\n");
           switch (RremoteLevel) 
           {
             case 0: RstrT = strdup(Ragroup);
                     Rnr = RgetMasterList();
                     break;
             case 1: RstrT = strdup(Rahost);
                     Rnr = RgetHostsFromGroup(Ragroup);
                     break;
             case 2: RstrT = strdup(Radir);
                     Rnr = RgetSharesFromHost(Rahost);
                     break;
             case 3: RstrT = strdup(RstrTmp);
                     Rnr = RgetFileFromDirR(Radir);
                     break;
           } 
           if (Rnr != -1) 
           {
             RinitList(Rnr,RremoteLevel,1);
             RsetSelect(&RrightFirst, &RrightPos, RstrT , RLREMOTE);
           }
         }
         free(RstrT);
       }
     }
     RwinRedrawWithData();
   }
   /* 
    *  (r) - refresh
    */
   if (Rkey == 'r') 
     RrefreshR();
   /* 
    *  (a, insert) - select/unselect file or directory
    */
   if ((Rkey == 331) || (Rkey == 'a')) 
   {
     if (Rselected == RLREMOTE) 
     {
       if (!RstrCmp(RlistRight[RrightFirst+RrightPos]->col2, "..")) 
       {
         if (RlistRight[RrightFirst+RrightPos]->select) 
           RlistRight[RrightFirst+RrightPos]->select = 0;
         else 
           RlistRight[RrightFirst+RrightPos]->select = 1;
       }
     } 
     else 
     {
       if (!RstrCmp(RlistLeft[RleftFirst+RleftPos]->col2, "..")) 
       {
         if (RlistLeft[RleftFirst+RleftPos]->select) 
           RlistLeft[RleftFirst+RleftPos]->select = 0;
         else 
           RlistLeft[RleftFirst+RleftPos]->select = 1;
       }
     }
     Rkey = 'o';
   }
   /* 
    *  (numeric keys *, shift+8) - select/unselect all files and directories
    */
   if ((Rkey == 106) || (Rkey == 42)) 
   {
     if (Rselected == RLREMOTE) 
     {
       for (Ri = 1; Ri < RlistRightMax; Ri++) 
       {
         if (RlistRight[Ri]->select) 
           RlistRight[Ri]->select = 0;
         else 
           RlistRight[Ri]->select = 1;
       }
       RwriteMenuTxt(RrightFirst,RremoteLevel,RLREMOTE,RrightPos);
     } 
     else 
     {
       for (Ri = 1; Ri < RlistLeftMax; Ri++) 
       {
         if (RlistLeft[Ri]->select) 
           RlistLeft[Ri]->select = 0;
         else 
           RlistLeft[Ri]->select = 1;
       }
       RwriteMenuTxt(RleftFirst,0,RLLOCAL,RleftPos);
     }
   }
   /* 
    *  (numeric shift -) - unselect all files and directories
    */
   if (Rkey == 95) 
   {
     if (Rselected == RLREMOTE) 
     {
       for (Ri = 1; Ri < RlistRightMax; Ri++) 
         RlistRight[Ri]->select = 0;
       RwriteMenuTxt(RrightFirst,RremoteLevel,RLREMOTE,RrightPos);
     } 
     else 
     {
       for (Ri = 1; Ri < RlistLeftMax; Ri++) 
         RlistLeft[Ri]->select = 0;
       RwriteMenuTxt(RleftFirst,0,RLLOCAL,RleftPos);
     }
   }
   /* 
    *  (numeric shift =) - select all files and directories
    */
   if (Rkey == 43) 
   {
     if (Rselected == RLREMOTE) 
     {
       for (Ri = 1; Ri < RlistRightMax; Ri++) 
         RlistRight[Ri]->select = 1;
       RwriteMenuTxt(RrightFirst,RremoteLevel,RLREMOTE,RrightPos);
     } 
     else 
     {
       for (Ri = 1; Ri < RlistLeftMax; Ri++) 
         RlistLeft[Ri]->select = 1;
       RwriteMenuTxt(RleftFirst,0,RLLOCAL,RleftPos);
     }
   }
   /* 
    *  (o) - go down one item
    */
   if (Rkey == KEY_DOWN || Rkey == 'o') 
   {
     if (Rselected == RLLOCAL) 
     {
       if (RleftPos+1 < Ry) 
       {
         if (RleftPos+1 < RlistLeftMax) 
           RleftPos++;
       }
       else 
       { 
         if (RleftFirst+RleftPos+1 < RlistLeftMax) 
           RleftFirst++; 
       }
       RwriteMenuTxt(RleftFirst,0,RLLOCAL,RleftPos);
     }
     else 
     {
       if (RrightPos+1 < Ry) 
       {
         if (RrightPos+1 < RlistRightMax) 
           RrightPos++;
       }
       else 
       { 
         if (RrightFirst+RrightPos+1 < RlistRightMax) 
           RrightFirst++; 
       }
       RwriteMenuTxt(RrightFirst,RremoteLevel,RLREMOTE,RrightPos);
     }
   }
   /* 
    *  (p) - go up one item
    */
   if (Rkey == KEY_UP || Rkey == 'p') 
   {
     if (Rselected == RLLOCAL) 
     {
       if (RleftPos > 0) 
         RleftPos--;
       else 
       { 
         if (RleftFirst+RleftPos > 0) 
           RleftFirst--; 
       }
       RwriteMenuTxt(RleftFirst,0,RLLOCAL,RleftPos);
     }
     else 
     {
       if (RrightPos > 0) 
         RrightPos--;
       else 
       { 
         if (RrightFirst+RrightPos > 0) 
           RrightFirst--; 
       }
       RwriteMenuTxt(RrightFirst,RremoteLevel,RLREMOTE,RrightPos);
     }
   }
   /* 
    *  (u, END) - go at the bottom of the list
    */
   if (Rkey == KEY_END || Rkey == 'u') 
   {
     if (Rselected == RLLOCAL) 
     {
       if (RlistLeftMax+1 > Ry) 
       { 
         RleftFirst = RlistLeftMax-Ry; 
         RleftPos = Ry-1; 
       }
       else 
         RleftPos = RlistLeftMax-1;
       RwriteMenuTxt(RleftFirst,0,RLLOCAL,RleftPos);
     }
     else 
     {
       if (RlistRightMax+1 > Ry) 
       { 
         RrightFirst = RlistRightMax-Ry; 
         RrightPos = Ry-1; 
       }
       else 
         RrightPos = RlistRightMax-1;
       RwriteMenuTxt(RrightFirst,RremoteLevel,RLREMOTE,RrightPos);
     }
   }
   /* 
    *  (u, HOME) - go on the top of the list
    */
   if (Rkey == KEY_HOME || Rkey == 'y') 
   {
     if (Rselected == RLLOCAL) 
     {
        if ((RleftFirst != 0) || (RleftPos != 0)) 
        {
          RleftFirst = 0;
          RleftPos = 0;
          RwriteMenuTxt(RleftFirst,0,RLLOCAL,RleftPos);
        }
     }
     else 
     {
       if ((RrightFirst != 0) || (RrightPos != 0)) 
       {
         RrightFirst = 0;
         RrightPos = 0;
         RwriteMenuTxt(RrightFirst,RremoteLevel,RLREMOTE,RrightPos);
       }
     }
   }
   /* 
    *  (l, PAGE_UP) - go on the top one screenn of the list
    */
   if (Rkey == KEY_PPAGE || Rkey == 'l') 
   {
     if (Rselected == RLLOCAL) 
     {
       if (RleftFirst-Ry >= 0) 
         RleftFirst = RleftFirst-Ry;
       else 
       { 
         RleftFirst = 0; 
         RleftPos = 0; 
       }
       RwriteMenuTxt(RleftFirst,0,RLLOCAL,RleftPos);
     }
     else 
     {
       if (RrightFirst-Ry >= 0) 
         RrightFirst = RrightFirst-Ry;
       else 
       { 
         RrightFirst = 0; 
         RrightPos = 0; 
       }
       RwriteMenuTxt(RrightFirst,RremoteLevel,RLREMOTE,RrightPos);
     }
   }
   /* 
    *  (k, PAGE_DOWN) - go at the bottom one screenn of the list
    */
   if (Rkey == KEY_NPAGE || Rkey == 'k') 
   {
     if (Rselected == RLLOCAL) 
     {
       if (RleftFirst+RleftPos+1 < RlistLeftMax) 
       { 
         if (RlistLeftMax < Ry) 
           RleftPos = RlistLeftMax-1;
         else 
         { 
           if (RleftFirst+Ry+Ry > RlistLeftMax) 
           { 
             RleftFirst = RlistLeftMax-Ry;
             RleftPos = Ry-1;
           }
           else 
             RleftFirst = RleftFirst+Ry; 
         }
       }
       RwriteMenuTxt(RleftFirst,0,RLLOCAL,RleftPos);
     }
     else 
     {
       if (RrightFirst+RrightPos+1 < RlistRightMax) 
       { 
         if (RlistRightMax < Ry) 
           RrightPos = RlistRightMax-1;
         else 
         { 
           if (RrightFirst+Ry+Ry > RlistRightMax) 
           { 
             RrightFirst = RlistRightMax-Ry;
             RrightPos = Ry-1;
           }
           else 
             RrightFirst = RrightFirst+Ry; 
         }
       }
       RwriteMenuTxt(RrightFirst,RremoteLevel,RLREMOTE,RrightPos);
     }
   }
   /* 
    *  (i, TAB) - change active list
    */
   if (Rkey == 9 || Rkey == 'i') 
   {
     if (Rselected == RLREMOTE) 
       Rselected = RLLOCAL;
     else 
       Rselected = RLREMOTE;
     RwriteMenuTxt(RleftFirst,RLLOCAL,RLLOCAL,RleftPos);
     RwriteMenuTxt(RrightFirst,RremoteLevel,RLREMOTE,RrightPos);
   }
   /* 
    *  (d, F5) - download/upload
    */
   if (Rkey == 'd' || Rkey == 269) 
   {
    if (!RdetectScreenToSmall()) 
    { 
     Rwhat = 0;
     if (Rselected == RLREMOTE) 
     {
       for (Ri = 0; Ri < RlistRightMax; Ri++) 
         if (RlistRight[Ri]->select) 
         { 
           Rwhat = 1; 
           break; 
         }
       if (Rwhat) 
       {
         if (RshowMessage(23, Rm178,RadirL,NULL)) 
         {
           for (Ri = 0; Ri < RlistRightMax; Ri++) 
            if (RlistRight[Ri]->select) 
            { 
               RcreateFileFromDirR(RadirL, Radir, RlistRight[Ri]->col2, Ragroup, RlistRight[Ri]->col1[0]);
               RwinRedrawWithData();
               nodelay(RwinMain,1);
               RactiveWindow = RwinMain;
            }
         }
       } 
       else 
       {
         switch(RremoteLevel) 
         {
           case 0: RstatusBar(16);
                   break;
           case 1: RstatusBar(17);
                   break;
           case 2: RstatusBar(18);
                   break;
           case 3: if (RstrCmp(RlistRight[RrightFirst+RrightPos]->col2,"..") == 0) 
                   {
                     if (RshowMessage(23,RlistRight[RrightFirst+RrightPos]->col2,RadirL,NULL)) 
                     {
                       RcreateFileFromDirR(RadirL, Radir, RlistRight[RrightFirst+RrightPos]->col2, Ragroup, RlistRight[RrightFirst+RrightPos]->col1[0]);
                       RwinRedrawWithData();
                       nodelay(RwinMain,1);
                       RactiveWindow = RwinMain;
                     }
                   }
                   break;
         }
       }
     }
     else 
     {
       for (Ri = 0; Ri < RlistLeftMax; Ri++) 
         if (RlistLeft[Ri]->select) 
         { 
           Rwhat = 1; 
           break; 
         }
       if (Rwhat) 
       {
         if (RshowMessage(23, Rm178,Radir+4,NULL)) 
         {
           for (Ri = 0; Ri < RlistLeftMax; Ri++) 
            if (RlistLeft[Ri]->select) 
            { 
               RcreateFileFromDirL(RadirL, Radir, RlistLeft[Ri]->col2, Ragroup, RlistLeft[Ri]->col1[0]);
               RwinRedrawWithData();
               nodelay(RwinMain,1);
               RactiveWindow = RwinMain;
            }
         }
       }
       else 
       {
         switch(RremoteLevel) 
         {
           case 0: RstatusBar(19);
                   break;
           case 1: RstatusBar(16);
                   break;
           case 2: RstatusBar(17);
                   break;
           case 3: if (RstrCmp(RlistLeft[RleftFirst+RleftPos]->col2,"..") == 0) 
                   {
                     if (RshowMessage(23,RlistLeft[RleftFirst+RleftPos]->col2,Radir+4,NULL)) 
                     {
                       RcreateFileFromDirL(RadirL, Radir, RlistLeft[RleftFirst+RleftPos]->col2, Ragroup, RlistLeft[RleftFirst+RleftPos]->col1[0]);
                       RwinRedrawWithData();
                       nodelay(RwinMain,1);
                       RactiveWindow = RwinMain;
                     }
                   }
                   break;
        }
      }
     }
    } 
    else 
      RwinRedrawWithData();
   } 
   /* 
    *  (s) - show download/upload list
    */
   if (Rkey == 's') 
   {
     sleep(0);
     if (!RdetectScreenToSmall()) 
     {
       if (!RgetdownloadListCount()) 
       {
         RDBG("smbc : main s 1\n");
         RshowMessage(24,"","",NULL);
         RDBG("smbc : main s 2\n");
       }
       else 
       {
         RDBG("smbc : main s 3\n");
         RmanageList();
         RDBG("smbc : main s 4\n");
       }
       nodelay(RwinMain,1);
       RactiveWindow = RwinMain;
     }
     else
       RwinRedrawWithData();
     alarm(RCalarm);
   }
   /* 
    *  (q) - quit
    */
   if (Rkey == 'q') 
   {
     alarm(0);
     if (Raskquit?RshowMessage(3,"aa",NULL,NULL):1) 
     {
       getmaxyx(RwinMain, Ry, Rx);
       break;
     }
   }
   /* 
    *  (h) - help
    */
   if (Rkey == 'h') 
   {
     if (!RdetectScreenToSmall()) 
       RshowMessage(1,"","",NULL);
     RwinRedrawWithData();
   }
   if (RindexTime != -1) 
     RcheckNewIndexFile(RfileNameMessage);
   
   RtryDownloadUpload();
   Rkey = 0;
 };
 RDBG("----stop 1----\n");
 RfreeMasterList(); 
 RfreeSharesList(); 
 RfreeHostsList(); 
 RfreeFilesList(); 
 free(RfileNameForFindList);
 free(RfileNameForFindListPrim);
 free(RfileNameMessage);
 free(RfileNameMessagePrim);
 free(RsmbcLockFile);
 RDBG("----stop 2----\n");
 RsigTerm();
 RDBG("----stop 3----\n");
 RfreeDebug();
 return(0);
}
