/***************************************************************************
 * gee.h  -  headers for the corresponding cpp file
 *
 * Copyright (C) 2006 - 2008 Florian Richter
 ***************************************************************************/
/*
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.
   
   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef SMC_GEE_H
#define SMC_GEE_H

#include "../enemies/enemy.h"

/* *** *** *** *** *** cGee *** *** *** *** *** *** *** *** *** *** *** *** */

/*
 * Shocks you with Electro, Lava or Gift
*/
class cGee : public cEnemy
{
public:
	// constructor
	cGee( float x, float y );
	// create from stream
	cGee( CEGUI::XMLAttributes &attributes );
	// destructor
	virtual ~cGee( void );

	// init defaults
	void Init( void );
	// copy
	virtual cGee *Copy( void );

	// create from stream
	virtual void Create_from_Stream( CEGUI::XMLAttributes &attributes );
	// save to stream
	virtual void Save_to_Stream( ofstream &file );

	// load from savegame
	virtual void Load_from_Savegame( cSave_Level_Object *save_object );

	// Set Direction
	void Set_Direction( ObjectDirection dir );
	// Set Max Distance
	void Set_Max_Distance( int nmax_distance );
	// set color
	void Set_Color( DefaultColor col );

	/* downgrade state ( if already weakest state : dies )
	 * force : usually dies or a complete downgrade
	*/
	virtual void DownGrade( bool force = 0 );
	virtual void DieStep( void );

	// update
	virtual void Update( void );
	// draw
	virtual void Draw( cSurfaceRequest *request = NULL );

	// Start Movement
	void Activate( void );
	// Stop Movement
	void Stop( void );

	// generate small cloud particles ( for moving )
	void Generate_Particles( void );

	// Check if out of max distance
	bool Check_Max_Distance( void );

	// if update is valid for the current state
	virtual bool Is_Update_Valid( void );
	// if draw is valid for the current state and position
	virtual bool Is_Draw_Valid( void );

	/* Validate the given collision object
	 * returns 1 if an internal collision with this object is valid
	 * returns 2 if the given object collides with this object (blocking)
	*/
	virtual unsigned int Validate_Collision( cSprite *obj );
	// collision from player
	virtual void Handle_Collision_Player( cObjectCollision *collision );
	// collision with massive
	virtual void Handle_Collision_Massive( cObjectCollision *collision );

	// editor activation
	virtual void Editor_Activate( void );
	// editor direction option selected event
	bool Editor_Direction_Select( const CEGUI::EventArgs &event );
	// editor max distance key up event
	bool Editor_Max_Distance_Key( const CEGUI::EventArgs &event );
	// editor always fly option selected event
	bool Editor_Always_Fly_Select( const CEGUI::EventArgs &event );
	// editor wait time key up event
	bool Editor_Wait_Time_Key( const CEGUI::EventArgs &event );
	// editor fly distance key up event
	bool Editor_Fly_Distance_Key( const CEGUI::EventArgs &event );

	// color
	DefaultColor color_type;

	// destination direction velocity
	float dest_velx, dest_vely;
	// maximum distance from the startposition
	int max_distance;
	// always fly around
	bool always_fly;
	// time to wait until next movement
	float wait_time;
	// fly distance
	int fly_distance;

	// wait time counter
	float wait_time_counter;
	// fly distance counter
	float fly_distance_counter;
	// clouds particle counter
	float clouds_counter;

private:
	// Create the Name from the current settings
    void Create_Name( void );
};

/* *** *** *** *** *** *** *** *** *** *** *** *** *** *** *** *** *** */

#endif
