/***************************************************************************
 * powerup.h  -  header for the corresponding cpp file
 *
 * Copyright (C) 2003 - 2008 Florian Richter
 ***************************************************************************/
/*
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.
   
   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef SMC_POWERUP_H
#define SMC_POWERUP_H

#include "../core/globals.h"
#include "../objects/objectsprite.h"

/* *** *** *** *** *** cPowerUp *** *** *** *** *** *** *** *** *** *** *** *** */

class cPowerUp : public cImageObjectSprite
{
public:
	// constructor
	cPowerUp( float x = 0, float y = 0 );
	// destructor
	virtual ~cPowerUp( void );

	// load from savegame
	virtual void Load_from_Savegame( cSave_Level_Object *save_object );
	// save to savegame
	virtual cSave_Level_Object *Save_to_Savegame( void );

	/* draw
	 * a spawned powerup doesn't draw in editor mode
	*/
	virtual void Draw( cSurfaceRequest *request = NULL );

	// if update is valid for the current state
	virtual bool Is_Update_Valid( void );

	/* Validate the given collision object
	 * returns 1 if an internal collision with this object is valid
	 * returns 2 if the given object collides with this object (blocking)
	*/
	virtual unsigned int Validate_Collision( cSprite *obj );
	// handle moved out of Level
	virtual void Handle_out_of_Level( ObjectDirection dir );

	float counter;
};

/* *** *** *** *** *** cMushroom *** *** *** *** *** *** *** *** *** *** *** *** */

class cMushroom : public cPowerUp
{
public:
	// constructor
	cMushroom( float x, float y );
	// create from stream
	cMushroom( CEGUI::XMLAttributes &attributes );
	// destructor
	virtual ~cMushroom( void );

	// init defaults
	void Init( void );

	// copy
	virtual cMushroom *Copy( void );

	// create from stream
	virtual void Create_from_Stream( CEGUI::XMLAttributes &attributes );
	// save to stream
	virtual void Save_to_Stream( ofstream &file );

	// Set the Mushroom Type
	void Set_Type( SpriteType ntype );

	// Activates the item
	virtual void Activate( void );

	// update
	virtual void Update( void );

	// collision with massive
	virtual void Handle_Collision_Massive( cObjectCollision *collision );
	// collision from a box
	virtual void Handle_Collision_Box( ObjectDirection cdirection, GL_rect *r2 );

	// glim animation modifier
	bool glim_mod;
};

/* *** *** *** *** *** cFirePlant *** *** *** *** *** *** *** *** *** *** *** *** */

class cFirePlant : public cPowerUp
{
public:
	// constructor
	cFirePlant( float x, float y );
	// destructor
	virtual ~cFirePlant( void );

	// copy
	virtual cFirePlant *Copy( void );

	// update
	virtual void Update( void );
};

/* *** *** *** *** *** cMoon *** *** *** *** *** *** *** *** *** *** *** *** */

class cMoon : public cPowerUp
{
public:
	// constructor
	cMoon( float x, float y );
	// create from stream
	cMoon( CEGUI::XMLAttributes &attributes );
	// destructor
	virtual ~cMoon( void );

	// init defaults
	void Init( void );

	// copy
	virtual cMoon *Copy( void );

	// create from stream
	virtual void Create_from_Stream( CEGUI::XMLAttributes &attributes );
	// save to stream
	virtual void Save_to_Stream( ofstream &file );

	// update
	virtual void Update( void );

	float particle_counter;
};

/* *** *** *** *** *** *** *** *** *** *** *** *** *** *** *** *** *** */

#endif
