#include <time.h>
#include "request.h"
#include "headers.h"
#include "sms.h"

int WyslijSMS_Idea(SMS_packet *sms)
{
	char *telefon = sms->telefon;
	char *wiadomosc = sms->wiadomosc;
	char *ok = sms->potwierdzenie;
	HTTP_Request *s = new HTTP_Request("sms.idea.pl", 80,
			konfig.w3cache_host, konfig.w3cache_port);
	time_t time_p;
	struct tm *time_tm; 
	char email_addr[80], notify_addr[80], notify_flag[6];
	int ret_val;

	while (1) {
	// te dane beda w kazdym odwolaniu sie do serwera
	s->AddHeader("Host","sms.idea.pl");

	time(&time_p);
	time_tm = localtime(&time_p);

	pobierz_adres_email(email_addr, sizeof(email_addr), 
		(konfig.mailaddr) ? konfig.mailaddr : "sms@idea.pl");
	pobierz_adres_notify(notify_addr, sizeof(notify_addr), notify_flag, konfig.notifyaddr);

	Headers *form = new Headers();
	form->Add("LANGUAGE","pl");
	form->Add("NETWORK","smsc1");
	form->Add("DELIVERY_TIME","0");
	form->Add("SENDER",email_addr);
	form->Add("RECIPIENT", telefon);
	form->Add("VALIDITY_PERIOD","4");
	form->Add("DELIVERY_DATE",time_tm->tm_mday);
	form->Add("DELIVERY_MONTH",time_tm->tm_mon + 1);
	form->Add("DELIVERY_YEAR",time_tm->tm_year + 1900);
	form->Add("DELIVERY_HOUR",time_tm->tm_hour);
	form->Add("DELIVERY_MIN",time_tm->tm_min);
	form->Add("NOTIFICATION_FLAG",notify_flag);
	form->Add("NOTIFICATION_ADDRESS",notify_addr);
	form->Add("SHORT_MESSAGE",wiadomosc);
	form->Add("SUBMIT","Wyslij");

	delete s->PostData("/sendsms.asp", *form);
	delete form;

	ret_val = poprawna_odpowiedz(ok, telefon, s->GetBody());

	delete s;

	return ret_val;
	}

	throw new Exception("Blad obslugi strony www.idea.pl");
	return 0;
}
