#ifndef __socket_h
#define __socket_h

#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
 
const int MAX_MSG_LEN = 512;

class Socket
{
 protected:
     int sock, status, port;
     char *hostname;

     int virtual connect_socket();
     int bind_socket();
 public:
     typedef int AvailType;
     enum Avail_Type { SCK_READ, SCK_WRITE, SCK_EXC };

     Socket(int _sock = 0) : sock(_sock),hostname(NULL),port(-1) {};
     Socket(const char *_hostname, int _port);
     ~Socket();
     int Ok();
     int MsgAvail(AvailType mode);

     int Sock() const { return sock; };
     
     int WriteMsg(const char *fmt, ...);
     int WriteMsg(const void *buf, int buf_len);

     // odczytuje wiadomosc z gniazdka - znakiem konca bedzie takze znak
     // nowej linii '\n'
     char *ReadMsg(int max_len = MAX_MSG_LEN);
     // jesli buf_len == -1 to odczyta wszystko z gniazdka, jesli nie to 
     // tyle ile bylo w buf_len. znaczenie buf takie jak ponizej
     char *ReadAll(int &buf_len);

     // zwroci odczytany bufor danych, jesli buf!=NULL to odczyta dane do 
     // niego, jesli buf==NULL to zaalokuje nowy bufor o wielkosci buf_len lub
     // MAX_MSG_LEN gdy buf_len<=0, w buf_len zwroci ilosc odczytanych bajtow
     // w przypadku bledu zwroci NULL i buf_len=-1
     void *ReadMsg(void *buf, int &buf_len);
     int ReadMsg(int buf_len, void *buf);

};

#ifndef NO_ANYIP

class AnyIPSocket : public Socket {
protected:
	char *srcip;

	int virtual connect_socket();
	int bindaddr_socket (struct addrinfo * ai_bptr);

public:
	AnyIPSocket(const char *_hostname, int _port,char * srcip);
};

#endif // NO_ANYIP

#endif
