/*
 * kod na podstawie maila Maciej Witkowiaka <ytm@elysium.pl>
 *
 * 21.8.2004 - patch autorstwa Adriana Siemieniaka
 */

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <string>
#include "vsprintf.h"
#include "request.h"
#include "headers.h"
#include "sms.h"
#include <iostream>

using std::string;

int WyslijSMS_MiastoPlusa(SMS_packet *sms)
{
	char tel[20];
	char *telefon = sms->telefon;
	char *wiadomosc = sms->wiadomosc;
	char *ok = sms->potwierdzenie;
	int ret_val;

	while (1) {
		Headers *form, *result;
		HTTP_Request *http = new HTTP_Request("www.miastoplusa.pl", 80,
				konfig.w3cache_host, konfig.w3cache_port);

		Headers *login = http->GetData("/");
		const char *cookie = login->Header("Set-Cookie");
		if (cookie && strstr(cookie, "JSESSIONID")) {
			string jcookie = cookie;
			jcookie = jcookie.substr(0, jcookie.find(";"));
			http->AddHeader("Cookie", jcookie.c_str());
		}
		delete login;

		form = new Headers();
		form->Add("login", konfig.mplusa_login);
		form->Add("password", konfig.mplusa_pass);
		form->Add("x","0");
		form->Add("y","0");
		result = http->PostData("/auth/LoginCitizen.do", *form);
		delete result;
		delete form;

		form = new Headers();
		form->Add("smsType","10");
		form->Add("phoneNumber", telefon);
		form->Add("message", wiadomosc);
		form->Add("notifyCode", "0");
		form->Add("validity", "48");
		form->Add("sendDay", "-1");
		form->Add("sendHour", "0");
		form->Add("sendMin", "0");
		form->Add("userId", "0");
		form->Add("groupId", "0");
		form->Add("templateCategory", "0");
		form->Add("targetURL", "/sms/send_sms.jsp");

		result = http->PostData("/sms/SendSMS2.do", *form);
		
		ret_val = poprawna_odpowiedz(ok, telefon, http->GetBody());
		ret_val = 1;
		
		delete form;
		delete result;

		result = http->GetData("http://www.miastoplusa.pl/minimal/logout_frameset.jsp",0);
		delete result;

		return ret_val;
	}
	throw new Exception("Blad obslugi strony www.miastoplusa.pl");
	return 0;
}
