#!/bin/bash
#
# Copyright 2002 Pavel Machek <pavel@ucw.cz>, distribute under GPLv2
#
# Send sms to using www gateway of provider of target phone. Type "bestsms" for
# help.
#
if [ a$1 = a ];
      then
      echo bestsms [-f] number message
      echo
      echo Bestsms attempts to send sms message using recipient providers SMS
      echo gateway. Nubmer should be in +420603123456 format: +, country code,
      echo rest of number.
      echo
      echo -f attempt to send flash message
      fi

if [ a$1 = a-f ];
      then
      FLASH=yes
      shift
      fi
NUMBER=`echo $1 | sed s/+//`
TEXT="$2"

paegas()
{
      smssend paeagas `echo $NUMBER | sed "s/^42//" | sed "s/......$//"` `echo $NUMBER | sed s/^420...//` "$TEXT"
}

eurotel()
{
      smssend eurotel `echo $NUMBER | sed "s/^42//" | sed "s/......$//"` `echo $NUMBER | sed s/^420...//` "$TEXT"
}

oskar()
{
      smssend oskar `echo $NUMBER | sed s/^420...//` "$TEXT"
}

case $NUMBER in
# Czech republic
      420603*) paegas ;;
      420604*) paegas ;;
      420605*) paegas ;;
      420601*) eurotel ;;
      420602*) eurotel ;;
      420606*) eurotel ;;
      420607*) eurotel ;;
      420723*) eurotel ;;
      420724*) eurotel ;;
      420608*) oskar ;;
# mts [FIXME: not checked]
      7902*) smssend mts $NUMBER $TEXT ;;
      7905*) smssend mts $NUMBER $TEXT ;;
# germany is supported by VLF

      *)	echo Sorry, unknown prefix in $NUMBER, please find operator for that phone and extend bestsms script
              ;;
esac

