/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/* $Id: smtpguard-db.c,v 1.1.1.1 2005/11/04 07:19:35 tkitame Exp $ 
 *
 * Copyright (c) 2005 VA Linux Systems Japan, K.K. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2 of the GNU General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <dirent.h>
#include <time.h>
#include "config.h"

#ifdef SOLARIS8
#include <limits.h>
#else
#include <linux/limits.h>
#endif

#include <glib.h>
#include <libxml/tree.h>
#include <libxml/parser.h>
#include <libxml/xpath.h>
#include <libxml/xpathInternals.h>

#include "smtpguard-daemon.h"
#include "fg-protocol-xml.h"

//
// display data for verbose option
void
disp_smtpdb_data (FGSmtpInfo *fsi, idb_data_t *d)
{
	sg_debug(2, "disp_smtpdb_data: ##### data start #####");
	sg_debug(2, "disp_smtpdb_data: +++++ smtp data +++++");
	sg_debug(2, "disp_smtpdb_data: pid=%-10ld\t", fg_smtp_info_get_addr(fsi));
	sg_debug(2, "disp_smtpdb_data: ip(len=%d)      :\"%s\"", strlen(fg_smtp_info_get_addr(fsi)), fg_smtp_info_get_addr(fsi));
	if (fg_smtp_info_get_mailfrom(fsi))
		sg_debug(2, "disp_smtpdb_data: mailfrom(len=%d):\"%s\"", strlen(fg_smtp_info_get_mailfrom(fsi)), fg_smtp_info_get_mailfrom(fsi));
	if (fg_smtp_info_get_rcptto(fsi))
		sg_debug(2, "disp_smtpdb_data: rcptto(len=%d)  :\"%s\"", strlen(fg_smtp_info_get_rcptto(fsi)), fg_smtp_info_get_rcptto(fsi));
	sg_debug(2, "disp_smtpdb_data: s_flag=%-1d  ", fg_smtp_info_is_session(fsi));
	sg_debug(2, "disp_smtpdb_data: c_flag=%-1d  ", fg_smtp_info_is_mynetworks(fsi));
	sg_debug(2, "disp_smtpdb_data: h_flag=%-1d", fg_smtp_info_is_mydestination(fsi));
	sg_debug(2, "disp_smtpdb_data: waittime=%-5ld\t", fg_smtp_info_get_wait(fsi));

	sg_debug(2, "disp_smtpdb_data: message:%s",
		 fg_smtp_info_get_action_message (fsi));

	sg_debug(2, "disp_smtpdb_data: +++++ db data +++++");
	sg_debug(2, "disp_smtpdb_data: kind:%-5ld  ", d->kind);
	sg_debug(2, "disp_smtpdb_data: ip:0x%08X", d->ip);
	sg_debug(2, "disp_smtpdb_data: xtime:%-10ld  ", d->xtime);
	sg_debug(2, "disp_smtpdb_data: rtime:%-10ld  ", d->rtime);
	sg_debug(2, "disp_smtpdb_data: mtime:%-10ld", d->mtime);
	sg_debug(2, "disp_smtpdb_data: SC=%-5ld  ", d->SC);
	sg_debug(2, "disp_smtpdb_data: FC=%-5ld  ", d->FC);
	sg_debug(2, "disp_smtpdb_data: TC=%-5ld  ", d->TC);
	sg_debug(2, "disp_smtpdb_data: P=%-5ld  ", d->P);
	sg_debug(2, "disp_smtpdb_data: status:%ld", d->status);
	sg_debug(2, "disp_smtpdb_data: ##### data end #####");
}


//
// search DB
idb_data_t *
search_db(idb_t *idb, FGSmtpInfo *fsi)
{
	int	ret;
	unsigned long	now;
	idb_data_t	*d;
	struct in_addr	inp;

	// make ip adress(MSB first)
	if (!inet_aton(fg_smtp_info_get_addr(fsi), &inp)) {
		sg_err(0, "search_db: illegal ip address: %s", fg_smtp_info_get_addr(fsi));
		return NULL;
	}

	if ((d = (idb_data_t *)malloc(sizeof(idb_data_t))) == NULL) {
		sg_err(errno, "search_db: malloc");
		return NULL;
	}
	memset(d, 0, sizeof(idb_data_t));
	now = sg_time(NULL);

	// get data from DB
	if ((ret = idb_get(idb, d, inp.s_addr)) != 0 && ret != DB_NOTFOUND) {
		sg_err(0, "search_db: database error: get: %d", ret);
		free(d);
		return NULL;
	}
	else if (ret == DB_NOTFOUND) {
		d->ip = inp.s_addr;
		d->rtime = now;
		d->xtime = now + expire;
		d->status = 0;
	}
	d->mtime = now;
	if (fg_smtp_info_is_session (fsi)) d->SC++;
	if (fg_smtp_info_get_mailfrom (fsi)) d->FC++;
	if (fg_smtp_info_get_rcptto (fsi)) d->TC++;

	return d;
}


//
// update DB
int
update_db (idb_t *idb, idb_data_t *d, int flg)
{
	int	ret;

	// put data to DB
	if (flg == 1) {
		if((ret = idb_put(idb, d)) != 0) {
			sg_err(0, "update_db: database error: put: %d", ret);
			return -1;
		}
	}
	// remove data from DB
	else if (flg == 2) {
		if((ret = idb_del(idb, d->ip)) != 0 && ret != DB_NOTFOUND) {
			sg_err(0, "update_db: database error: del: %d", ret);
			return -1;
		}
	}

	return 0;
}


//
// remove files
int
remove_dir (char *dirname)
{
	char	fbuf[PATH_MAX];
	struct stat	sbuf;
	struct dirent	*pde;
	DIR	*pd;

	if ((pd = opendir(dirname)) == NULL) {
		if (errno == ENOTDIR) {
			if (remove(dirname) != 0) {
				sg_err(errno, "remove_dir: remove: %s", dirname);
				return -1;
			}
		}
		else if (errno != ENOENT) {
			sg_err(errno, "remove_dir: opendir: %s", dirname);
			return -1;
		}
	}
	else {
		while ((pde = readdir(pd)) != 0) {
			if (!strcmp(pde->d_name, ".") || !strcmp(pde->d_name, "..")) continue;
			snprintf(fbuf, sizeof(fbuf), "%s/%s", dirname, pde->d_name);
			if (stat(fbuf, &sbuf) != 0) {
				if (errno == ENOENT) continue;
				sg_err(errno, "remove_dir: stat: %s", fbuf);
				closedir(pd);
				return -1;
			}
			if (S_ISDIR(sbuf.st_mode)) {
				if (remove_dir(fbuf) != 0) {
					closedir(pd);
					return -1;
				}
			}
			if (remove(fbuf) != 0) {
				sg_err(errno, "remove: %s", fbuf);
				closedir(pd);
				return -1;
			}
		}
		if (errno != 0) {
			sg_err(errno, "readdir:  %s", dirname);
			closedir(pd);
			return -1;
		}
	}
	closedir(pd);
	return 0;
}
