/*==================================================================
 * wtbl_aweunits.h - Header for OSS AWE unit conversion functions
 *
 * Smurf Sound Font Editor
 * Copyright (C) 1999-2001 Josh Green
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA or point your web browser to http://www.gnu.org.
 *
 * To contact the author of this program:
 * Email: Josh Green <jgreen@users.sourceforge.net>
 * Smurf homepage: http://smurf.sourceforge.net
 *==================================================================*/
#ifndef __WTBL_AWEUNITS_H__
#define __WTBL_AWEUNITS_H__

#include "config.h"

#ifdef AWE_SUPPORT

#include <glib.h>

gint awe_calc_rate_offset (guint16 Hz);
gint awe_calc_delay (gint16 amount);
gint awe_calc_attack (gint16 amount);
gint awe_calc_hold (gint16 amount);
gint awe_calc_sustain (gint16 amount);
gint awe_calc_mod_sustain (gint16 amount);
gint awe_calc_decay (gint16 amount);
gint awe_calc_cutoff (gint16 amount);
gint awe_calc_filterQ (gint16 amount);
gint awe_calc_pitch_shift (gint16 amount);
gint awe_calc_modenv_cutoff (gint16 amount);
gint awe_calc_modlfo_cutoff (gint16 amount);
gint awe_calc_tremolo (gint16 amount);
gint awe_calc_freq (gint16 amount);
gint awe_calc_pan (gint16 val);
gint awe_calc_tenthpercent (gint16 val);
gint awe_calc_attenuation (gint16 amount);

#endif /* #ifdef AWE_SUPPORT */

#endif	/* __WTBL_AWEUNITS_H__ */
