/*
 * This file is part of the sn package.
 * Distribution of sn is covered by the GNU GPL. See file COPYING.
 * Copyright  1998-2000 Harold Tay.
 * Copyright  2000- Patrik Rdman.
 */

#include <stdarg.h>
#include <unistd.h>
#include "format.h"

char *progname = 0;
static char logbuf[1024];

void logv (char *fmt, va_list ap)
{
   int len = 0;

   if (progname)
   {
      for (; progname[len]; len++)
         logbuf[len] = progname[len];
      logbuf[len++] = ':';
   }
   len += formatv(logbuf + len, sizeof (logbuf) - len - 2, fmt, ap);
   logbuf[len] = '\n';
   write(2, logbuf, len + 1);
}

void log (char *fmt, ...)
{
   va_list ap;

   va_start(ap, fmt);
   logv(fmt, ap);
   va_end(ap);
}

void fail (int ex, char *fmt, ...)
{
   va_list ap;

   va_start(ap, fmt);
   logv(fmt, ap);
   _exit(ex);
}
