/* SNAC
 * Copyright (C) 1999 the Free Software Foundation
 * Authors : Matias Mutchinick, Jan Struyf
 *         
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef __AG_MATH_H__
#define __AG_MATH_H__


#include <glib.h>
#include <math.h>

#define OP_MULT		0
#define OP_DIV		1
#define OP_POW		2
#define OP_PLUS		3
#define OP_MINUS	4
#define OP_OR		5
#define OP_AND		6
#define OP_XOR		7
#define OP_SHR		8
#define OP_SHL		9

gint
ag_math_overflow(gdouble  num);

gint
ag_math_underflow(gdouble  num);


gdouble
to_radians(gdouble number, gint mode);

gdouble 
from_radians_to(gdouble number, gint mode);

gdouble 
ag_cos(gdouble arg, gint mode, gint *error);

gdouble 
ag_sin(gdouble arg, gint mode, gint *error);

gdouble 
ag_tan(gdouble arg, gint mode, gint *error);

gdouble 
ag_cosh(gdouble arg, gint mode, gint *error);

gdouble 
ag_sinh(gdouble arg, gint mode, gint *error);

gdouble 
ag_tanh(gdouble arg, gint mode, gint *error);

gdouble 
ag_acos(gdouble arg, gint mode, gint *error);

gdouble
ag_asin(gdouble arg, gint mode, gint *error);

gdouble 
ag_atan(gdouble arg, gint mode, gint *error);

gdouble 
ag_ln(gdouble arg, gint mode, gint *error);

gdouble 
ag_log(gdouble arg, gint mode, gint *error);

gdouble 
ag_exp(gdouble arg, gint mode, gint *error);

gdouble 
ag_abs(gdouble arg, gint mode, gint *error);

gdouble 
ag_neg(gdouble arg, gint mode, gint *error);

gdouble 
ag_inv(gdouble arg, gint mode, gint *error);

gdouble 
ag_sq(gdouble arg, gint mode, gint *error);

gdouble 
ag_sqrt(gdouble arg, gint mode, gint *error);

gdouble
ag_fact(gdouble arg, gint mode, gint *error);



gdouble
ag_mult(gdouble ar1, gdouble ar2, gint *error);

gdouble
ag_div(gdouble ar1, gdouble ar2, gint *error);

gdouble
ag_pow(gdouble ar1, gdouble ar2, gint *error);

gdouble
ag_plus(gdouble ar1, gdouble ar2, gint *error);

gdouble
ag_minus(gdouble ar1, gdouble ar2, gint *error);

gdouble
ag_or(gdouble ar1, gdouble ar2, gint *error);

gdouble
ag_and(gdouble ar1, gdouble ar2, gint *error);

gdouble
ag_xor(gdouble ar1, gdouble ar2, gint *error);

gdouble
ag_shr(gdouble ar1, gdouble ar2, gint *error);

gdouble
ag_shl(gdouble ar1, gdouble ar2, gint *error);

#endif /* __AG_MATH_H__ */	
