/* libgtk_s7.c */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <stdbool.h>
#include "s7.h"

#if ((!__NetBSD__) && ((_MSC_VER) || (!defined(__STC__)) || (defined(__STDC_VERSION__) && (__STDC_VERSION__ < 199901L))))
  #define __func__ __FUNCTION__
#endif

#include <string.h>
#include <stdlib.h>
#include <stdint.h>
#include <inttypes.h>

#include <glib.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>
#if (!GTK_CHECK_VERSION(3, 0, 0))
  #include <gdk/gdkkeysyms.h>
#endif
#include <glib-object.h>
#include <pango/pango.h>
#include <cairo/cairo.h>
static s7_pointer lg_true, lg_false;
static bool lg_boolean(s7_pointer val) {return(val != lg_false);}
#define lg_make_c_pointer_with_type(Sc, Type, Ptr) s7_make_c_pointer_with_type(Sc, (void *)Ptr, Type, lg_false)


static int xm_obj_tag;
static s7_pointer xm_obj_free(s7_scheme *sc, s7_pointer obj)
{
  free(s7_c_object_value(obj));
  return(NULL);
}
static s7_pointer s7_equal_xm(s7_scheme *sc, s7_pointer args)
{
  return(s7_make_boolean(sc, s7_car(args) == s7_cadr(args)));
}
static s7_pointer make_xm_obj(s7_scheme *sc, void *ptr)
{
  return(s7_make_c_object(sc, xm_obj_tag, ptr));
}
static void define_xm_obj(s7_scheme *sc)
{
  xm_obj_tag = s7_make_c_type(sc, "<gtk_s7>");
  s7_c_type_set_gc_free(sc, xm_obj_tag, xm_obj_free);
  s7_c_type_set_is_equal(sc, xm_obj_tag, s7_equal_xm);
}  

static s7_pointer guint___sym, GDateTime__sym, GtkWindowHandle__sym, GtkWindowControls__sym, GtkWidget___sym,
                  GdkTimeCoord__sym, GtkColorButton__sym, GtkViewport__sym, GtkAspectFrame__sym, GdkKeymapKey__sym,
                  GtkAlternativeTrigger__sym, GtkMnemonicTrigger__sym, GtkKeyvalTrigger__sym, gconstpointer_sym, GtkShortcutController__sym,
                  GtkNamedAction__sym, GtkSignalAction__sym, GtkShortcutFunc_sym, GtkShortcutAction__sym, GtkShortcutTrigger__sym,
                  GtkShortcut__sym, GVariantType__sym, GMenuItem__sym, GtkNative__sym, GVariant__sym,
                  GtkWidgetActionActivateFunc_sym, GtkPopover__sym, GtkTreePath___sym, GtkMenuButtonCreatePopupFunc_sym, GtkDropTargetAsync__sym,
                  gsize__sym, GtkDropTarget__sym, GtkDropControllerMotion__sym, GtkDragIcon__sym, GtkEventControllerFocus__sym,
                  GtkConstraintLayout__sym, GtkConstraintTarget__sym, GtkConstraint__sym, GtkIconPaintable__sym, GtkIconTheme__sym,
                  GtkConstraintGuide__sym, GtkEventControllerMotion__sym, GdkVulkanContext__sym, GError___sym, GdkFrameClock__sym,
                  GdkModifierType__sym, GdkToplevelLayout__sym, GdkToplevel__sym, GtkPopoverMenu__sym, GtkCenterLayout__sym,
                  GtkPopoverMenuBar__sym, GtkNoSelection__sym, GtkDragSource__sym, GdkPopupLayout__sym, GdkPopup__sym,
                  GdkDragSurface__sym, GtkPropagationLimit_sym, GtkGestureLongPress__sym, GtkScaleFormatValueFunc_sym, GdkContentProvider___sym,
                  GtkFixedLayoutChild__sym, GtkTreeDragDest__sym, GtkTreeListRow__sym, GtkTreeListModel__sym, GtkText__sym,
                  GtkSortListModel__sym, GtkSliceListModel__sym, GtkSingleSelection__sym, GtkPasswordEntry__sym, GtkMapListModel__sym,
                  GtkLayoutChild__sym, GtkGridLayoutChild__sym, GtkGridLayout__sym, GtkFlattenListModel__sym, GtkFilterListModel__sym,
                  GtkCustomAllocateFunc_sym, GtkCustomMeasureFunc_sym, GtkCustomRequestModeFunc_sym, GtkBoxLayout__sym, graphene_point_t__sym,
                  graphene_matrix_t__sym, GtkRoot__sym, GtkWidgetClass__sym, GtkLayoutManager__sym, GtkSelectionModel__sym,
                  GtkStackPage__sym, GtkNotebookPage__sym, GskTransform__sym, GtkFixed__sym, GParamSpec__sym,
                  GObjectClass__sym, GListModel__sym, GtkAssistantPage__sym, GtkAllocation__sym, GActionGroup__sym,
                  GtkWidgetPaintable__sym, GtkVideo__sym, GtkPicture__sym, gint64_sym, GtkMediaFile__sym,
                  GtkMediaControls__sym, GtkMediaStream__sym, GdkTimeCoord___sym, GtkGestureStylus__sym, GdkGLTexture__sym,
                  GdkDrag__sym, GdkDrop__sym, GdkCairoContext__sym, GdkSurface__sym, GMenu__sym,
                  GApplicationFlags_sym, GdkPaintable__sym, GdkCursor__sym, GBytes__sym, GInputStream__sym,
                  GdkContentDeserializer__sym, GdkContentSerializer__sym, GOutputStream__sym, GdkContentFormatsBuilder__sym, GString__sym,
                  GdkTexture__sym, GAsyncResult__sym, GAsyncReadyCallback_sym, GCancellable__sym, GdkContentProvider__sym,
                  GdkContentFormats__sym, GdkClipboard__sym, GdkAppLaunchContext__sym, GtkEventControllerScroll__sym, GtkEventController__sym,
                  GFile__sym, GtkCssProvider__sym, GtkStyleProvider__sym, GtkScrollbar__sym, GtkCenterBox__sym,
                  GtkCheckButton__sym, GtkDrawingAreaDrawFunc_sym, GtkShortcutLabel__sym, GtkPadActionEntry__sym, GtkPadController__sym,
                  GdkDevicePad__sym, GdkMonitor__sym, GdkDeviceTool__sym, GdkSeat__sym, GtkShortcutsWindow__sym,
                  GtkStackSidebar__sym, GtkStyleContext__sym, GdkGLContext__sym, GtkGLArea__sym, GtkPaned__sym,
                  GtkGestureZoom__sym, GtkGestureSwipe__sym, GtkGestureSingle__sym, GtkGestureRotate__sym, GtkGesturePan__sym,
                  GtkGestureDrag__sym, GdkEventSequence__sym, GtkGesture__sym, GtkActionBar__sym, GtkFlowBox__sym,
                  GtkFlowBoxChild__sym, GtkSearchBar__sym, GtkListBox__sym, GtkListBoxRow__sym, GtkHeaderBar__sym,
                  GtkRevealer__sym, GtkStack__sym, GtkStackSwitcher__sym, GtkLevelBar__sym, GtkMenuButton__sym,
                  GtkColorChooser__sym, GtkApplicationWindow__sym, GtkApplication__sym, GMenuModel__sym, GtkFontChooser__sym,
                  GtkOverlay__sym, GtkWindowGroup__sym, GIcon__sym, GtkOrientable__sym, GtkCellArea__sym,
                  GtkBorder__sym, GtkSwitch__sym, GtkScrollable__sym, GtkGrid__sym, GdkRGBA__sym,
                  GtkComboBoxText__sym, cairo_region_overlap_t_sym, cairo_rectangle_int_t__sym, double__sym, cairo_rectangle_t__sym,
                  cairo_device_t__sym, cairo_text_cluster_flags_t__sym, cairo_text_cluster_t___sym, cairo_glyph_t___sym, cairo_text_cluster_t__sym,
                  cairo_region_t__sym, GtkMessageDialog__sym, GdkDevice__sym, GtkAccessible__sym, GtkSpinner__sym,
                  GtkEntryBuffer__sym, GtkInfoBar__sym, GtkScaleButton__sym, GtkTooltip__sym, cairo_rectangle_list_t__sym,
                  void__sym, cairo_path_t__sym, cairo_destroy_func_t_sym, cairo_user_data_key_t__sym, cairo_text_extents_t__sym,
                  cairo_font_extents_t__sym, cairo_font_face_t__sym, cairo_glyph_t__sym, cairo_scaled_font_t__sym, cairo_matrix_t__sym,
                  cairo_pattern_t__sym, GtkPageRange__sym, GtkPaperSize__sym, GtkPrintSettingsFunc_sym, GtkPageSetupDoneFunc_sym,
                  GtkPrintSettings__sym, GtkPrintOperation__sym, GtkPageSetup__sym, GtkPrintContext__sym, cairo_surface_t__sym,
                  GtkRecentData__sym, GtkRecentInfo__sym, GtkRecentManager__sym, GtkLinkButton__sym, GDestroyNotify_sym,
                  GtkAssistantPageFunc_sym, GtkAssistant__sym, GValue__sym, GLogFunc_sym, PangoMatrix__sym,
                  PangoRenderer__sym, GtkFileChooserButton__sym, PangoScriptIter__sym, PangoAttrFilterFunc_sym, GtkIconViewForeachFunc_sym,
                  gchar___sym, GtkAboutDialog__sym, GtkTreeViewRowSeparatorFunc_sym, GtkCellView__sym, GtkFileChooser__sym,
                  GtkCellLayoutDataFunc_sym, GtkCellLayout__sym, GtkFileFilterFunc_sym, GtkFileFilter__sym, GSourceFunc_sym,
                  GtkEntryCompletionMatchFunc_sym, GtkFontButton__sym, GtkExpander__sym, GtkComboBox__sym, GtkTreeModelFilter__sym,
                  GdkDisplay__sym, PangoLayoutRun__sym, PangoLayoutIter__sym, PangoLayoutLine__sym, int__sym,
                  PangoItem__sym, PangoAnalysis__sym, PangoGlyphString__sym, PangoFontMap__sym, PangoFontFace__sym,
                  PangoFontFace___sym, PangoFontFamily__sym, PangoFontDescription___sym, PangoCoverage__sym, PangoFontMetrics__sym,
                  PangoFontset__sym, PangoFont__sym, PangoFontFamily___sym, PangoLogAttr__sym, PangoAttrList___sym,
                  PangoAttrIterator__sym, PangoRectangle__sym, PangoAttribute__sym, PangoColor__sym, GtkWindow__sym,
                  PangoContext__sym, AtkObject__sym, GtkTreeViewSearchEqualFunc_sym, GtkTreeViewMappingFunc_sym, GtkTreeViewColumnDropFunc_sym,
                  GList__sym, GtkTreeCellDataFunc_sym, GtkTreeStore__sym, GtkTreeIterCompareFunc_sym, GtkTreeSortable__sym,
                  GtkTreeSelectionForeachFunc_sym, GtkTreeModel___sym, GtkTreeSelectionFunc_sym, GtkTreeModelSort__sym, GtkTreeModelForeachFunc_sym,
                  GObject__sym, GtkTreeRowReference__sym, gint__sym, GtkTreeDragSource__sym, GtkToggleButton__sym,
                  PangoTabArray__sym, GtkTextView__sym, GtkTextTagTableForeach_sym, GtkTextCharPredicate_sym, GtkTextMark__sym,
                  GtkTextChildAnchor__sym, GtkTextIter__sym, GtkTextTagTable__sym, GtkTextBuffer__sym, GtkStatusbar__sym,
                  GtkSpinButton__sym, GtkSizeGroup__sym, GtkSettings__sym, GtkScrolledWindow__sym, GtkScale__sym,
                  GtkRange__sym, GtkRadioButton__sym, GSList__sym, GtkProgressBar__sym, GtkNotebook__sym,
                  PangoLanguage__sym, GtkListStore__sym, PangoLayout__sym, GtkLabel__sym, guint16__sym,
                  GtkIMContextSimple__sym, PangoAttrList__sym, GtkIMContext__sym, GtkImage__sym, GtkFrame__sym,
                  GtkEntry__sym, GtkEditable__sym, etc_sym, GtkDialog__sym, GtkCellRendererToggle__sym,
                  GtkCellRendererText__sym, GtkCellEditable__sym, GtkCalendar__sym, GtkButton__sym, GtkBox__sym,
                  GtkAdjustment__sym, GtkAccelLabel__sym, char___sym, GdkPixbufDestroyNotify_sym, GError__sym,
                  guchar__sym, GdkPixbuf__sym, GdkRectangle__sym, GtkDestroyNotify_sym, GSignalEmissionHook_sym,
                  GSignalInvocationHint__sym, guint__sym, GSignalQuery__sym, GType__sym, GSignalCMarshaller_sym,
                  gpointer_sym, GSignalAccumulator_sym, GClosureNotify_sym, GCallback_sym, GClosure__sym,
                  gunichar__sym, void_sym, GtkDrawingArea__sym, GtkIconView__sym, GtkEntryCompletion__sym,
                  GtkFileFilterInfo__sym, GtkTreeSelection__sym, GtkCellRenderer__sym, GtkTreeViewColumn__sym, GtkTreeView__sym,
                  GtkTreeIter__sym, GtkTreePath__sym, GtkTreeModel__sym, GtkTextTag__sym, lambda_data_sym,
                  GtkWidget__sym, GdkEventMotion__sym, gdouble__sym, GdkEvent__sym, cairo_t__sym,
                  cairo_font_options_t__sym, PangoFontDescription__sym, GtkMenuBar__sym, GtkEventControllerLegacy__sym, GtkCellRendererPixbuf__sym,
                  GtkSeparator__sym, GdkEventExpose__sym, GdkEventNoExpose__sym, GdkEventVisibility__sym, GdkEventButton__sym,
                  GdkEventCrossing__sym, GdkEventFocus__sym, GdkEventConfigure__sym, GdkEventProperty__sym, GdkEventSelection__sym,
                  GdkEventProximity__sym, GdkEventSetting__sym, GdkEventWindowState__sym, GdkEventDND__sym, GtkFileChooserDialog__sym,
                  GtkFileChooserWidget__sym, GtkCellRendererCombo__sym, GtkCellRendererProgress__sym, GtkCellRendererAccel__sym, GtkCellRendererSpin__sym,
                  GtkCellRendererSpinner__sym, GtkFontChooserDialog__sym, GtkFontChooserWidget__sym, GtkColorChooserDialog__sym, GtkColorWidget__sym;

#define lg_is_list(Arg) s7_is_list(sc, Arg)
static s7_scheme *cbsc = NULL;
static void lg_func2(GtkWidget* w, gpointer func_info)
{
  if (!s7_is_list(cbsc, (s7_pointer)func_info)) return;
  s7_call(cbsc, 
    s7_car((s7_pointer)func_info), 
           s7_list(cbsc, 2,
                   lg_make_c_pointer_with_type(cbsc, GtkWidget__sym, w),
                   s7_cadr((s7_pointer)func_info)));
}

static gboolean lg_timer_func(gpointer func_info)
{
  if (!s7_is_list(cbsc, (s7_pointer)func_info)) return((gboolean)0);
  return((gboolean)lg_boolean(s7_call(cbsc, 
    s7_car((s7_pointer)func_info), 
           s7_list(cbsc, 1,
                   s7_cadr((s7_pointer)func_info)))));
}

static void lg_destroy_func(gpointer func_info)
{
  if (!s7_is_list(cbsc, (s7_pointer)func_info)) return;
  s7_call(cbsc, 
    s7_cadddr((s7_pointer)func_info), 
           s7_list(cbsc, 1,
                   s7_cadr((s7_pointer)func_info)));
}

static void lg_text_tag_table_foreach(GtkTextTag* tag, gpointer func_info)
{
  if (!s7_is_list(cbsc, (s7_pointer)func_info)) return;
  s7_call(cbsc, 
    s7_car((s7_pointer)func_info), 
           s7_list(cbsc, 2,
                   lg_make_c_pointer_with_type(cbsc, GtkTextTag__sym, tag),
                   s7_cadr((s7_pointer)func_info)));
}

static gboolean lg_model_func(GtkTreeModel* model, GtkTreePath* path, GtkTreeIter* iter, gpointer func_info)
{
  if (!s7_is_list(cbsc, (s7_pointer)func_info)) return((gboolean)0);
  return((gboolean)lg_boolean(s7_call(cbsc, 
    s7_car((s7_pointer)func_info), 
           s7_list(cbsc, 4,
                   lg_make_c_pointer_with_type(cbsc, GtkTreeModel__sym, model),
                   lg_make_c_pointer_with_type(cbsc, GtkTreePath__sym, path),
                   lg_make_c_pointer_with_type(cbsc, GtkTreeIter__sym, iter),
                   s7_cadr((s7_pointer)func_info)))));
}

static void lg_tree_selection_func(GtkTreeModel* model, GtkTreePath* path, GtkTreeIter* iter, gpointer func_info)
{
  if (!s7_is_list(cbsc, (s7_pointer)func_info)) return;
  s7_call(cbsc, 
    s7_car((s7_pointer)func_info), 
           s7_list(cbsc, 4,
                   lg_make_c_pointer_with_type(cbsc, GtkTreeModel__sym, model),
                   lg_make_c_pointer_with_type(cbsc, GtkTreePath__sym, path),
                   lg_make_c_pointer_with_type(cbsc, GtkTreeIter__sym, iter),
                   s7_cadr((s7_pointer)func_info)));
}

static gboolean lg_text_char_predicate(gunichar ch, gpointer func_info)
{
  if (!s7_is_list(cbsc, (s7_pointer)func_info)) return((gboolean)0);
  return((gboolean)lg_boolean(s7_call(cbsc, 
    s7_car((s7_pointer)func_info), 
           s7_list(cbsc, 2,
                   s7_make_integer(cbsc, ch),
                   s7_cadr((s7_pointer)func_info)))));
}

static gboolean lg_tree_column(GtkTreeView* tree_view, GtkTreeViewColumn* column, GtkTreeViewColumn* prev_column, GtkTreeViewColumn* next_column, gpointer func_info)
{
  if (!s7_is_list(cbsc, (s7_pointer)func_info)) return((gboolean)0);
  return((gboolean)lg_boolean(s7_call(cbsc, 
    s7_car((s7_pointer)func_info), 
           s7_list(cbsc, 5,
                   lg_make_c_pointer_with_type(cbsc, GtkTreeView__sym, tree_view),
                   lg_make_c_pointer_with_type(cbsc, GtkTreeViewColumn__sym, column),
                   lg_make_c_pointer_with_type(cbsc, GtkTreeViewColumn__sym, prev_column),
                   lg_make_c_pointer_with_type(cbsc, GtkTreeViewColumn__sym, next_column),
                   s7_cadr((s7_pointer)func_info)))));
}

static void lg_tree_mapping(GtkTreeView* tree_view, GtkTreePath* path, gpointer func_info)
{
  if (!s7_is_list(cbsc, (s7_pointer)func_info)) return;
  s7_call(cbsc, 
    s7_car((s7_pointer)func_info), 
           s7_list(cbsc, 3,
                   lg_make_c_pointer_with_type(cbsc, GtkTreeView__sym, tree_view),
                   lg_make_c_pointer_with_type(cbsc, GtkTreePath__sym, path),
                   s7_cadr((s7_pointer)func_info)));
}

static gboolean lg_tree_search(GtkTreeModel* model, gint column, const gchar* key, GtkTreeIter* iter, gpointer func_info)
{
  if (!s7_is_list(cbsc, (s7_pointer)func_info)) return((gboolean)0);
  return((gboolean)lg_boolean(s7_call(cbsc, 
    s7_car((s7_pointer)func_info), 
           s7_list(cbsc, 5,
                   lg_make_c_pointer_with_type(cbsc, GtkTreeModel__sym, model),
                   s7_make_integer(cbsc, column),
                   s7_make_string(cbsc, key),
                   lg_make_c_pointer_with_type(cbsc, GtkTreeIter__sym, iter),
                   s7_cadr((s7_pointer)func_info)))));
}

static void lg_cell_data(GtkTreeViewColumn* tree_column, GtkCellRenderer* cell, GtkTreeModel* tree_model, GtkTreeIter* iter, gpointer func_info)
{
  if (!s7_is_list(cbsc, (s7_pointer)func_info)) return;
  s7_call(cbsc, 
    s7_car((s7_pointer)func_info), 
           s7_list(cbsc, 5,
                   lg_make_c_pointer_with_type(cbsc, GtkTreeViewColumn__sym, tree_column),
                   lg_make_c_pointer_with_type(cbsc, GtkCellRenderer__sym, cell),
                   lg_make_c_pointer_with_type(cbsc, GtkTreeModel__sym, tree_model),
                   lg_make_c_pointer_with_type(cbsc, GtkTreeIter__sym, iter),
                   s7_cadr((s7_pointer)func_info)));
}

static gint lg_iter_compare(GtkTreeModel* model, GtkTreeIter* a, GtkTreeIter* b, gpointer func_info)
{
  if (!s7_is_list(cbsc, (s7_pointer)func_info)) return((gint)0);
  return((gint)s7_integer(s7_call(cbsc, 
    s7_car((s7_pointer)func_info), 
           s7_list(cbsc, 4,
                   lg_make_c_pointer_with_type(cbsc, GtkTreeModel__sym, model),
                   lg_make_c_pointer_with_type(cbsc, GtkTreeIter__sym, a),
                   lg_make_c_pointer_with_type(cbsc, GtkTreeIter__sym, b),
                   s7_cadr((s7_pointer)func_info)))));
}

static gboolean lg_tree_selection(GtkTreeSelection* selection, GtkTreeModel* model, GtkTreePath* path, gboolean path_currently_selected, gpointer func_info)
{
  if (!s7_is_list(cbsc, (s7_pointer)func_info)) return((gboolean)0);
  return((gboolean)lg_boolean(s7_call(cbsc, 
    s7_car((s7_pointer)func_info), 
           s7_list(cbsc, 5,
                   lg_make_c_pointer_with_type(cbsc, GtkTreeSelection__sym, selection),
                   lg_make_c_pointer_with_type(cbsc, GtkTreeModel__sym, model),
                   lg_make_c_pointer_with_type(cbsc, GtkTreePath__sym, path),
                   s7_make_boolean(cbsc, path_currently_selected),
                   s7_cadr((s7_pointer)func_info)))));
}

static gboolean lg_file_filter(const GtkFileFilterInfo* info, gpointer func_info)
{
  if (!s7_is_list(cbsc, (s7_pointer)func_info)) return((gboolean)0);
  return((gboolean)lg_boolean(s7_call(cbsc, 
    s7_car((s7_pointer)func_info), 
           s7_list(cbsc, 2,
                   lg_make_c_pointer_with_type(cbsc, GtkFileFilterInfo__sym, (void *)info),
                   s7_cadr((s7_pointer)func_info)))));
}

static gboolean lg_entry_completion_match(GtkEntryCompletion* completion, const gchar* key, GtkTreeIter* iter, gpointer func_info)
{
  if (!s7_is_list(cbsc, (s7_pointer)func_info)) return((gboolean)0);
  return((gboolean)lg_boolean(s7_call(cbsc, 
    s7_car((s7_pointer)func_info), 
           s7_list(cbsc, 4,
                   lg_make_c_pointer_with_type(cbsc, GtkEntryCompletion__sym, completion),
                   s7_make_string(cbsc, key),
                   lg_make_c_pointer_with_type(cbsc, GtkTreeIter__sym, iter),
                   s7_cadr((s7_pointer)func_info)))));
}

static gboolean lg_row_separator(GtkTreeModel* model, GtkTreeIter* iter, gpointer func_info)
{
  if (!s7_is_list(cbsc, (s7_pointer)func_info)) return((gboolean)0);
  return((gboolean)lg_boolean(s7_call(cbsc, 
    s7_car((s7_pointer)func_info), 
           s7_list(cbsc, 3,
                   lg_make_c_pointer_with_type(cbsc, GtkTreeModel__sym, model),
                   lg_make_c_pointer_with_type(cbsc, GtkTreeIter__sym, iter),
                   s7_cadr((s7_pointer)func_info)))));
}

static void lg_icon_view_foreach(GtkIconView* icon_view, GtkTreePath* path, gpointer func_info)
{
  if (!s7_is_list(cbsc, (s7_pointer)func_info)) return;
  s7_call(cbsc, 
    s7_car((s7_pointer)func_info), 
           s7_list(cbsc, 3,
                   lg_make_c_pointer_with_type(cbsc, GtkIconView__sym, icon_view),
                   lg_make_c_pointer_with_type(cbsc, GtkTreePath__sym, path),
                   s7_cadr((s7_pointer)func_info)));
}

static void lg_g_message_log_func(const gchar* domain, GLogLevelFlags log_level, const gchar* message, gpointer func_info)
{
  if (!s7_is_list(cbsc, (s7_pointer)func_info)) return;
  s7_call(cbsc, 
    s7_car((s7_pointer)func_info), 
           s7_list(cbsc, 4,
                   s7_make_string(cbsc, domain),
                   s7_make_integer(cbsc, log_level),
                   s7_make_string(cbsc, message),
                   s7_cadr((s7_pointer)func_info)));
}

static gint lg_page_func(gint current_page, gpointer func_info)
{
  if (!s7_is_list(cbsc, (s7_pointer)func_info)) return((gint)0);
  return((gint)s7_integer(s7_call(cbsc, 
    s7_car((s7_pointer)func_info), 
           s7_list(cbsc, 2,
                   s7_make_integer(cbsc, current_page),
                   s7_cadr((s7_pointer)func_info)))));
}

#if GTK_CHECK_VERSION(3, 92, 0)
static void lg_draw_func(GtkDrawingArea* self, cairo_t* cr, int width, int height, gpointer func_info)
{
  if (!s7_is_list(cbsc, (s7_pointer)func_info)) return;
  s7_call(cbsc, 
    s7_car((s7_pointer)func_info), 
           s7_list(cbsc, 5,
                   lg_make_c_pointer_with_type(cbsc, GtkDrawingArea__sym, self),
                   lg_make_c_pointer_with_type(cbsc, cairo_t__sym, cr),
                   s7_make_integer(cbsc, width),
                   s7_make_integer(cbsc, height),
                   s7_cadr((s7_pointer)func_info)));
}
#endif


static gboolean lg_func3(GtkWidget *w, GdkEvent *ev, gpointer data)
{
  return(s7_call(cbsc, s7_car((s7_pointer)data),
                       s7_list(cbsc, 3, s7_make_c_pointer_with_type(cbsc, w, GtkWidget__sym, lg_false),
                                        s7_make_c_pointer_with_type(cbsc, ev, GdkEvent__sym, lg_false),
                                        (s7_is_pair(s7_cdr((s7_pointer)data))) ? (s7_cadr((s7_pointer)data)) : s7_nil(cbsc))) != lg_false);
}

static gboolean lg_func4(GtkPrintOperation *op, GtkPrintContext *context, gint page_nr, gpointer data)
{
  return(s7_call(cbsc, s7_car((s7_pointer)data),
                       s7_list(cbsc, 4, s7_make_c_pointer_with_type(cbsc, op, GtkPrintOperation__sym, lg_false),
                                        s7_make_c_pointer_with_type(cbsc, context, GtkPrintContext__sym, lg_false),
                                        s7_make_integer(cbsc, page_nr),
                                        (s7_is_pair(s7_cdr((s7_pointer)data))) ? (s7_cadr((s7_pointer)data)) : s7_nil(cbsc))) != lg_false);
}

static s7_pointer lg_g_unichar_validate(s7_scheme *sc, s7_pointer args)
{
  #define H_g_unichar_validate "gboolean g_unichar_validate(gunichar ch)"
  s7_pointer ch;
  ch = s7_car(args);
  if (!s7_is_integer(ch)) s7_wrong_type_arg_error(sc, "g_unichar_validate", 1, ch, "gunichar");
  return(s7_make_boolean(sc, g_unichar_validate((gunichar)s7_integer(ch))));
}

static s7_pointer lg_g_unichar_isalnum(s7_scheme *sc, s7_pointer args)
{
  #define H_g_unichar_isalnum "gboolean g_unichar_isalnum(gunichar c)"
  s7_pointer c;
  c = s7_car(args);
  if (!s7_is_integer(c)) s7_wrong_type_arg_error(sc, "g_unichar_isalnum", 1, c, "gunichar");
  return(s7_make_boolean(sc, g_unichar_isalnum((gunichar)s7_integer(c))));
}

static s7_pointer lg_g_unichar_isalpha(s7_scheme *sc, s7_pointer args)
{
  #define H_g_unichar_isalpha "gboolean g_unichar_isalpha(gunichar c)"
  s7_pointer c;
  c = s7_car(args);
  if (!s7_is_integer(c)) s7_wrong_type_arg_error(sc, "g_unichar_isalpha", 1, c, "gunichar");
  return(s7_make_boolean(sc, g_unichar_isalpha((gunichar)s7_integer(c))));
}

static s7_pointer lg_g_unichar_iscntrl(s7_scheme *sc, s7_pointer args)
{
  #define H_g_unichar_iscntrl "gboolean g_unichar_iscntrl(gunichar c)"
  s7_pointer c;
  c = s7_car(args);
  if (!s7_is_integer(c)) s7_wrong_type_arg_error(sc, "g_unichar_iscntrl", 1, c, "gunichar");
  return(s7_make_boolean(sc, g_unichar_iscntrl((gunichar)s7_integer(c))));
}

static s7_pointer lg_g_unichar_isdefined(s7_scheme *sc, s7_pointer args)
{
  #define H_g_unichar_isdefined "gboolean g_unichar_isdefined(gunichar c)"
  s7_pointer c;
  c = s7_car(args);
  if (!s7_is_integer(c)) s7_wrong_type_arg_error(sc, "g_unichar_isdefined", 1, c, "gunichar");
  return(s7_make_boolean(sc, g_unichar_isdefined((gunichar)s7_integer(c))));
}

static s7_pointer lg_g_unichar_isdigit(s7_scheme *sc, s7_pointer args)
{
  #define H_g_unichar_isdigit "gboolean g_unichar_isdigit(gunichar c)"
  s7_pointer c;
  c = s7_car(args);
  if (!s7_is_integer(c)) s7_wrong_type_arg_error(sc, "g_unichar_isdigit", 1, c, "gunichar");
  return(s7_make_boolean(sc, g_unichar_isdigit((gunichar)s7_integer(c))));
}

static s7_pointer lg_g_unichar_isgraph(s7_scheme *sc, s7_pointer args)
{
  #define H_g_unichar_isgraph "gboolean g_unichar_isgraph(gunichar c)"
  s7_pointer c;
  c = s7_car(args);
  if (!s7_is_integer(c)) s7_wrong_type_arg_error(sc, "g_unichar_isgraph", 1, c, "gunichar");
  return(s7_make_boolean(sc, g_unichar_isgraph((gunichar)s7_integer(c))));
}

static s7_pointer lg_g_unichar_islower(s7_scheme *sc, s7_pointer args)
{
  #define H_g_unichar_islower "gboolean g_unichar_islower(gunichar c)"
  s7_pointer c;
  c = s7_car(args);
  if (!s7_is_integer(c)) s7_wrong_type_arg_error(sc, "g_unichar_islower", 1, c, "gunichar");
  return(s7_make_boolean(sc, g_unichar_islower((gunichar)s7_integer(c))));
}

static s7_pointer lg_g_unichar_ismark(s7_scheme *sc, s7_pointer args)
{
  #define H_g_unichar_ismark "gboolean g_unichar_ismark(gunichar c)"
  s7_pointer c;
  c = s7_car(args);
  if (!s7_is_integer(c)) s7_wrong_type_arg_error(sc, "g_unichar_ismark", 1, c, "gunichar");
  return(s7_make_boolean(sc, g_unichar_ismark((gunichar)s7_integer(c))));
}

static s7_pointer lg_g_unichar_isprint(s7_scheme *sc, s7_pointer args)
{
  #define H_g_unichar_isprint "gboolean g_unichar_isprint(gunichar c)"
  s7_pointer c;
  c = s7_car(args);
  if (!s7_is_integer(c)) s7_wrong_type_arg_error(sc, "g_unichar_isprint", 1, c, "gunichar");
  return(s7_make_boolean(sc, g_unichar_isprint((gunichar)s7_integer(c))));
}

static s7_pointer lg_g_unichar_ispunct(s7_scheme *sc, s7_pointer args)
{
  #define H_g_unichar_ispunct "gboolean g_unichar_ispunct(gunichar c)"
  s7_pointer c;
  c = s7_car(args);
  if (!s7_is_integer(c)) s7_wrong_type_arg_error(sc, "g_unichar_ispunct", 1, c, "gunichar");
  return(s7_make_boolean(sc, g_unichar_ispunct((gunichar)s7_integer(c))));
}

static s7_pointer lg_g_unichar_isspace(s7_scheme *sc, s7_pointer args)
{
  #define H_g_unichar_isspace "gboolean g_unichar_isspace(gunichar c)"
  s7_pointer c;
  c = s7_car(args);
  if (!s7_is_integer(c)) s7_wrong_type_arg_error(sc, "g_unichar_isspace", 1, c, "gunichar");
  return(s7_make_boolean(sc, g_unichar_isspace((gunichar)s7_integer(c))));
}

static s7_pointer lg_g_unichar_istitle(s7_scheme *sc, s7_pointer args)
{
  #define H_g_unichar_istitle "gboolean g_unichar_istitle(gunichar c)"
  s7_pointer c;
  c = s7_car(args);
  if (!s7_is_integer(c)) s7_wrong_type_arg_error(sc, "g_unichar_istitle", 1, c, "gunichar");
  return(s7_make_boolean(sc, g_unichar_istitle((gunichar)s7_integer(c))));
}

static s7_pointer lg_g_unichar_isupper(s7_scheme *sc, s7_pointer args)
{
  #define H_g_unichar_isupper "gboolean g_unichar_isupper(gunichar c)"
  s7_pointer c;
  c = s7_car(args);
  if (!s7_is_integer(c)) s7_wrong_type_arg_error(sc, "g_unichar_isupper", 1, c, "gunichar");
  return(s7_make_boolean(sc, g_unichar_isupper((gunichar)s7_integer(c))));
}

static s7_pointer lg_g_unichar_isxdigit(s7_scheme *sc, s7_pointer args)
{
  #define H_g_unichar_isxdigit "gboolean g_unichar_isxdigit(gunichar c)"
  s7_pointer c;
  c = s7_car(args);
  if (!s7_is_integer(c)) s7_wrong_type_arg_error(sc, "g_unichar_isxdigit", 1, c, "gunichar");
  return(s7_make_boolean(sc, g_unichar_isxdigit((gunichar)s7_integer(c))));
}

static s7_pointer lg_g_unichar_iswide(s7_scheme *sc, s7_pointer args)
{
  #define H_g_unichar_iswide "gboolean g_unichar_iswide(gunichar c)"
  s7_pointer c;
  c = s7_car(args);
  if (!s7_is_integer(c)) s7_wrong_type_arg_error(sc, "g_unichar_iswide", 1, c, "gunichar");
  return(s7_make_boolean(sc, g_unichar_iswide((gunichar)s7_integer(c))));
}

static s7_pointer lg_g_unichar_iswide_cjk(s7_scheme *sc, s7_pointer args)
{
  #define H_g_unichar_iswide_cjk "gboolean g_unichar_iswide_cjk(gunichar c)"
  s7_pointer c;
  c = s7_car(args);
  if (!s7_is_integer(c)) s7_wrong_type_arg_error(sc, "g_unichar_iswide_cjk", 1, c, "gunichar");
  return(s7_make_boolean(sc, g_unichar_iswide_cjk((gunichar)s7_integer(c))));
}

static s7_pointer lg_g_unichar_iszerowidth(s7_scheme *sc, s7_pointer args)
{
  #define H_g_unichar_iszerowidth "gboolean g_unichar_iszerowidth(gunichar c)"
  s7_pointer c;
  c = s7_car(args);
  if (!s7_is_integer(c)) s7_wrong_type_arg_error(sc, "g_unichar_iszerowidth", 1, c, "gunichar");
  return(s7_make_boolean(sc, g_unichar_iszerowidth((gunichar)s7_integer(c))));
}

static s7_pointer lg_g_unichar_toupper(s7_scheme *sc, s7_pointer args)
{
  #define H_g_unichar_toupper "gunichar g_unichar_toupper(gunichar c)"
  s7_pointer c;
  c = s7_car(args);
  if (!s7_is_integer(c)) s7_wrong_type_arg_error(sc, "g_unichar_toupper", 1, c, "gunichar");
  return(s7_make_integer(sc, g_unichar_toupper((gunichar)s7_integer(c))));
}

static s7_pointer lg_g_unichar_tolower(s7_scheme *sc, s7_pointer args)
{
  #define H_g_unichar_tolower "gunichar g_unichar_tolower(gunichar c)"
  s7_pointer c;
  c = s7_car(args);
  if (!s7_is_integer(c)) s7_wrong_type_arg_error(sc, "g_unichar_tolower", 1, c, "gunichar");
  return(s7_make_integer(sc, g_unichar_tolower((gunichar)s7_integer(c))));
}

static s7_pointer lg_g_unichar_totitle(s7_scheme *sc, s7_pointer args)
{
  #define H_g_unichar_totitle "gunichar g_unichar_totitle(gunichar c)"
  s7_pointer c;
  c = s7_car(args);
  if (!s7_is_integer(c)) s7_wrong_type_arg_error(sc, "g_unichar_totitle", 1, c, "gunichar");
  return(s7_make_integer(sc, g_unichar_totitle((gunichar)s7_integer(c))));
}

static s7_pointer lg_g_unichar_digit_value(s7_scheme *sc, s7_pointer args)
{
  #define H_g_unichar_digit_value "gint g_unichar_digit_value(gunichar c)"
  s7_pointer c;
  c = s7_car(args);
  if (!s7_is_integer(c)) s7_wrong_type_arg_error(sc, "g_unichar_digit_value", 1, c, "gunichar");
  return(s7_make_integer(sc, g_unichar_digit_value((gunichar)s7_integer(c))));
}

static s7_pointer lg_g_unichar_xdigit_value(s7_scheme *sc, s7_pointer args)
{
  #define H_g_unichar_xdigit_value "gint g_unichar_xdigit_value(gunichar c)"
  s7_pointer c;
  c = s7_car(args);
  if (!s7_is_integer(c)) s7_wrong_type_arg_error(sc, "g_unichar_xdigit_value", 1, c, "gunichar");
  return(s7_make_integer(sc, g_unichar_xdigit_value((gunichar)s7_integer(c))));
}

static s7_pointer lg_g_unichar_combining_class(s7_scheme *sc, s7_pointer args)
{
  #define H_g_unichar_combining_class "gint g_unichar_combining_class(gunichar uc)"
  s7_pointer uc;
  uc = s7_car(args);
  if (!s7_is_integer(uc)) s7_wrong_type_arg_error(sc, "g_unichar_combining_class", 1, uc, "gunichar");
  return(s7_make_integer(sc, g_unichar_combining_class((gunichar)s7_integer(uc))));
}

static s7_pointer lg_g_unicode_canonical_ordering(s7_scheme *sc, s7_pointer args)
{
  #define H_g_unicode_canonical_ordering "void g_unicode_canonical_ordering(gunichar* string, gsize len)"
  s7_pointer _p;
  s7_pointer string, len;
  _p = args;
  string = s7_car(_p); _p = s7_cdr(_p);
  len = s7_car(_p);
  if (!s7_is_integer(len)) s7_wrong_type_arg_error(sc, "g_unicode_canonical_ordering", 2, len, "gsize");
  g_unicode_canonical_ordering((gunichar*)s7_c_pointer_with_type(sc, string, gunichar__sym, __func__, 0), (gsize)s7_integer(len));
  return(lg_false);
}

static s7_pointer lg_g_utf8_get_char(s7_scheme *sc, s7_pointer args)
{
  #define H_g_utf8_get_char "gunichar g_utf8_get_char(gchar* p)"
  s7_pointer p;
  p = s7_car(args);
  if (!s7_is_string(p)) s7_wrong_type_arg_error(sc, "g_utf8_get_char", 1, p, "gchar*");
  return(s7_make_integer(sc, g_utf8_get_char((const gchar*)s7_string(p))));
}

static s7_pointer lg_g_utf8_get_char_validated(s7_scheme *sc, s7_pointer args)
{
  #define H_g_utf8_get_char_validated "gunichar g_utf8_get_char_validated(gchar* p, gssize max_len)"
  s7_pointer _p;
  s7_pointer p, max_len;
  _p = args;
  p = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(p)) s7_wrong_type_arg_error(sc, "g_utf8_get_char_validated", 1, p, "gchar*");
  max_len = s7_car(_p);
  if (!s7_is_integer(max_len)) s7_wrong_type_arg_error(sc, "g_utf8_get_char_validated", 2, max_len, "gssize");
  return(s7_make_integer(sc, g_utf8_get_char_validated((const gchar*)s7_string(p), (gssize)s7_integer(max_len))));
}

static s7_pointer lg_g_utf8_prev_char(s7_scheme *sc, s7_pointer args)
{
  #define H_g_utf8_prev_char "gchar* g_utf8_prev_char(gchar* p)"
  s7_pointer p;
  p = s7_car(args);
  if (!s7_is_string(p)) s7_wrong_type_arg_error(sc, "g_utf8_prev_char", 1, p, "gchar*");
  return(s7_make_string(sc, g_utf8_prev_char((const gchar*)s7_string(p))));
}

static s7_pointer lg_g_utf8_find_next_char(s7_scheme *sc, s7_pointer args)
{
  #define H_g_utf8_find_next_char "gchar* g_utf8_find_next_char(gchar* p, gchar* end)"
  s7_pointer _p;
  s7_pointer p, end;
  _p = args;
  p = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(p)) s7_wrong_type_arg_error(sc, "g_utf8_find_next_char", 1, p, "gchar*");
  end = s7_car(_p);
  if (!s7_is_string(end)) s7_wrong_type_arg_error(sc, "g_utf8_find_next_char", 2, end, "gchar*");
  return(s7_make_string(sc, g_utf8_find_next_char((const gchar*)s7_string(p), (const gchar*)s7_string(end))));
}

static s7_pointer lg_g_utf8_find_prev_char(s7_scheme *sc, s7_pointer args)
{
  #define H_g_utf8_find_prev_char "gchar* g_utf8_find_prev_char(gchar* str, gchar* p)"
  s7_pointer _p;
  s7_pointer str, p;
  _p = args;
  str = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(str)) s7_wrong_type_arg_error(sc, "g_utf8_find_prev_char", 1, str, "gchar*");
  p = s7_car(_p);
  if (!s7_is_string(p)) s7_wrong_type_arg_error(sc, "g_utf8_find_prev_char", 2, p, "gchar*");
  return(s7_make_string(sc, g_utf8_find_prev_char((const gchar*)s7_string(str), (const gchar*)s7_string(p))));
}

static s7_pointer lg_g_utf8_strlen(s7_scheme *sc, s7_pointer args)
{
  #define H_g_utf8_strlen "glong g_utf8_strlen(gchar* p, gssize max)"
  s7_pointer _p;
  s7_pointer p, max;
  _p = args;
  p = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(p)) s7_wrong_type_arg_error(sc, "g_utf8_strlen", 1, p, "gchar*");
  max = s7_car(_p);
  if (!s7_is_integer(max)) s7_wrong_type_arg_error(sc, "g_utf8_strlen", 2, max, "gssize");
  return(s7_make_integer(sc, g_utf8_strlen((const gchar*)s7_string(p), (gssize)s7_integer(max))));
}

static s7_pointer lg_g_utf8_strchr(s7_scheme *sc, s7_pointer args)
{
  #define H_g_utf8_strchr "gchar* g_utf8_strchr(gchar* p, gssize len, gunichar c)"
  s7_pointer _p;
  s7_pointer p, len, c;
  _p = args;
  p = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(p)) s7_wrong_type_arg_error(sc, "g_utf8_strchr", 1, p, "gchar*");
  len = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(len)) s7_wrong_type_arg_error(sc, "g_utf8_strchr", 2, len, "gssize");
  c = s7_car(_p);
  if (!s7_is_integer(c)) s7_wrong_type_arg_error(sc, "g_utf8_strchr", 3, c, "gunichar");
  return(s7_make_string(sc, g_utf8_strchr((const gchar*)s7_string(p), (gssize)s7_integer(len), (gunichar)s7_integer(c))));
}

static s7_pointer lg_g_utf8_strrchr(s7_scheme *sc, s7_pointer args)
{
  #define H_g_utf8_strrchr "gchar* g_utf8_strrchr(gchar* p, gssize len, gunichar c)"
  s7_pointer _p;
  s7_pointer p, len, c;
  _p = args;
  p = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(p)) s7_wrong_type_arg_error(sc, "g_utf8_strrchr", 1, p, "gchar*");
  len = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(len)) s7_wrong_type_arg_error(sc, "g_utf8_strrchr", 2, len, "gssize");
  c = s7_car(_p);
  if (!s7_is_integer(c)) s7_wrong_type_arg_error(sc, "g_utf8_strrchr", 3, c, "gunichar");
  return(s7_make_string(sc, g_utf8_strrchr((const gchar*)s7_string(p), (gssize)s7_integer(len), (gunichar)s7_integer(c))));
}

static s7_pointer lg_g_utf8_strreverse(s7_scheme *sc, s7_pointer args)
{
  #define H_g_utf8_strreverse "gchar* g_utf8_strreverse(gchar* str, gssize len)"
  s7_pointer _p;
  s7_pointer str, len;
  _p = args;
  str = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(str)) s7_wrong_type_arg_error(sc, "g_utf8_strreverse", 1, str, "gchar*");
  len = s7_car(_p);
  if (!s7_is_integer(len)) s7_wrong_type_arg_error(sc, "g_utf8_strreverse", 2, len, "gssize");
  return(s7_make_string(sc, g_utf8_strreverse((const gchar*)s7_string(str), (gssize)s7_integer(len))));
}

static s7_pointer lg_g_utf8_validate(s7_scheme *sc, s7_pointer args)
{
  #define H_g_utf8_validate "gboolean g_utf8_validate(gchar* str, gssize max_len, gchar** [end])"
  s7_pointer _p;
  s7_pointer str, max_len;
  gchar* ref_end = NULL;
  _p = args;
  str = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(str)) s7_wrong_type_arg_error(sc, "g_utf8_validate", 1, str, "gchar*");
  max_len = s7_car(_p);
  if (!s7_is_integer(max_len)) s7_wrong_type_arg_error(sc, "g_utf8_validate", 2, max_len, "gssize");
  {
    s7_pointer res_ult;
    res_ult = s7_make_boolean(sc, g_utf8_validate((const gchar*)s7_string(str), (gssize)s7_integer(max_len), (const gchar**)&ref_end));
      return(s7_list(sc, 2, res_ult, s7_make_string(sc, ref_end)));
   }
}

static s7_pointer lg_g_utf8_strup(s7_scheme *sc, s7_pointer args)
{
  #define H_g_utf8_strup "gchar* g_utf8_strup(gchar* str, gssize len)"
  s7_pointer _p;
  s7_pointer str, len;
  _p = args;
  str = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(str)) s7_wrong_type_arg_error(sc, "g_utf8_strup", 1, str, "gchar*");
  len = s7_car(_p);
  if (!s7_is_integer(len)) s7_wrong_type_arg_error(sc, "g_utf8_strup", 2, len, "gssize");
  return(s7_make_string(sc, g_utf8_strup((const gchar*)s7_string(str), (gssize)s7_integer(len))));
}

static s7_pointer lg_g_utf8_strdown(s7_scheme *sc, s7_pointer args)
{
  #define H_g_utf8_strdown "gchar* g_utf8_strdown(gchar* str, gssize len)"
  s7_pointer _p;
  s7_pointer str, len;
  _p = args;
  str = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(str)) s7_wrong_type_arg_error(sc, "g_utf8_strdown", 1, str, "gchar*");
  len = s7_car(_p);
  if (!s7_is_integer(len)) s7_wrong_type_arg_error(sc, "g_utf8_strdown", 2, len, "gssize");
  return(s7_make_string(sc, g_utf8_strdown((const gchar*)s7_string(str), (gssize)s7_integer(len))));
}

static s7_pointer lg_g_utf8_casefold(s7_scheme *sc, s7_pointer args)
{
  #define H_g_utf8_casefold "gchar* g_utf8_casefold(gchar* str, gssize len)"
  s7_pointer _p;
  s7_pointer str, len;
  _p = args;
  str = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(str)) s7_wrong_type_arg_error(sc, "g_utf8_casefold", 1, str, "gchar*");
  len = s7_car(_p);
  if (!s7_is_integer(len)) s7_wrong_type_arg_error(sc, "g_utf8_casefold", 2, len, "gssize");
  return(s7_make_string(sc, g_utf8_casefold((const gchar*)s7_string(str), (gssize)s7_integer(len))));
}

static s7_pointer lg_g_utf8_normalize(s7_scheme *sc, s7_pointer args)
{
  #define H_g_utf8_normalize "gchar* g_utf8_normalize(gchar* str, gssize len, GNormalizeMode mode)"
  s7_pointer _p;
  s7_pointer str, len, mode;
  _p = args;
  str = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(str)) s7_wrong_type_arg_error(sc, "g_utf8_normalize", 1, str, "gchar*");
  len = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(len)) s7_wrong_type_arg_error(sc, "g_utf8_normalize", 2, len, "gssize");
  mode = s7_car(_p);
  if (!s7_is_integer(mode)) s7_wrong_type_arg_error(sc, "g_utf8_normalize", 3, mode, "GNormalizeMode");
  return(s7_make_string(sc, g_utf8_normalize((const gchar*)s7_string(str), (gssize)s7_integer(len), (GNormalizeMode)s7_integer(mode))));
}

static s7_pointer lg_g_utf8_collate(s7_scheme *sc, s7_pointer args)
{
  #define H_g_utf8_collate "gint g_utf8_collate(gchar* str1, gchar* str2)"
  s7_pointer _p;
  s7_pointer str1, str2;
  _p = args;
  str1 = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(str1)) s7_wrong_type_arg_error(sc, "g_utf8_collate", 1, str1, "gchar*");
  str2 = s7_car(_p);
  if (!s7_is_string(str2)) s7_wrong_type_arg_error(sc, "g_utf8_collate", 2, str2, "gchar*");
  return(s7_make_integer(sc, g_utf8_collate((const gchar*)s7_string(str1), (const gchar*)s7_string(str2))));
}

static s7_pointer lg_g_utf8_collate_key(s7_scheme *sc, s7_pointer args)
{
  #define H_g_utf8_collate_key "gchar* g_utf8_collate_key(gchar* str, gssize len)"
  s7_pointer _p;
  s7_pointer str, len;
  _p = args;
  str = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(str)) s7_wrong_type_arg_error(sc, "g_utf8_collate_key", 1, str, "gchar*");
  len = s7_car(_p);
  if (!s7_is_integer(len)) s7_wrong_type_arg_error(sc, "g_utf8_collate_key", 2, len, "gssize");
  return(s7_make_string(sc, g_utf8_collate_key((const gchar*)s7_string(str), (gssize)s7_integer(len))));
}

static s7_pointer lg_g_utf8_collate_key_for_filename(s7_scheme *sc, s7_pointer args)
{
  #define H_g_utf8_collate_key_for_filename "gchar* g_utf8_collate_key_for_filename(gchar* str, gssize len)"
  s7_pointer _p;
  s7_pointer str, len;
  _p = args;
  str = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(str)) s7_wrong_type_arg_error(sc, "g_utf8_collate_key_for_filename", 1, str, "gchar*");
  len = s7_car(_p);
  if (!s7_is_integer(len)) s7_wrong_type_arg_error(sc, "g_utf8_collate_key_for_filename", 2, len, "gssize");
  return(s7_make_string(sc, g_utf8_collate_key_for_filename((const gchar*)s7_string(str), (gssize)s7_integer(len))));
}

static s7_pointer lg_g_cclosure_new(s7_scheme *sc, s7_pointer args)
{
  #define H_g_cclosure_new "GClosure* g_cclosure_new(GCallback func, lambda_data func_info, GClosureNotify destroy_data)"
  s7_pointer _p;
  s7_pointer func, func_info, destroy_data;
  _p = args;
  func = s7_car(_p); _p = s7_cdr(_p);
  func_info = s7_car(_p); _p = s7_cdr(_p);
  destroy_data = s7_car(_p);
  {
    s7_pointer res_ult;
    int loc;
    s7_pointer lg_ptr = s7_list(sc, 5, func, func_info, lg_false, lg_false, lg_false);
    loc = s7_gc_protect(sc, lg_ptr);
    s7_list_set(sc, lg_ptr, 2, s7_make_integer(sc, loc));
    res_ult = lg_make_c_pointer_with_type(sc, GClosure__sym, g_cclosure_new(((s7_is_aritable(sc, func, 4)) ? (GCallback)lg_func4 : ((s7_is_aritable(sc, func, 3)) ? (GCallback)lg_func3 : (GCallback)lg_func2)), (gpointer)lg_ptr, NULL));
    return(res_ult);
   }
}

static s7_pointer lg_g_signal_newv(s7_scheme *sc, s7_pointer args)
{
  #define H_g_signal_newv "guint g_signal_newv(gchar* signal_name, GType itype, GSignalFlags signal_flags, \
GClosure* class_closure, GSignalAccumulator accumulator, gpointer accu_data, GSignalCMarshaller c_marshaller, \
GType return_type, guint n_params, GType* param_types)"
  s7_pointer _p;
  s7_pointer signal_name, itype, signal_flags, class_closure, accumulator, accu_data, c_marshaller, return_type, n_params, param_types;
  _p = args;
  signal_name = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(signal_name)) s7_wrong_type_arg_error(sc, "g_signal_newv", 1, signal_name, "gchar*");
  itype = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(itype)) s7_wrong_type_arg_error(sc, "g_signal_newv", 2, itype, "GType");
  signal_flags = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(signal_flags)) s7_wrong_type_arg_error(sc, "g_signal_newv", 3, signal_flags, "GSignalFlags");
  class_closure = s7_car(_p); _p = s7_cdr(_p);
  accumulator = s7_car(_p); _p = s7_cdr(_p);
  accu_data = s7_car(_p); _p = s7_cdr(_p);
  c_marshaller = s7_car(_p); _p = s7_cdr(_p);
  return_type = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(return_type)) s7_wrong_type_arg_error(sc, "g_signal_newv", 8, return_type, "GType");
  n_params = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(n_params)) s7_wrong_type_arg_error(sc, "g_signal_newv", 9, n_params, "guint");
  param_types = s7_car(_p);
  return(s7_make_integer(sc, g_signal_newv((gchar*)s7_string(signal_name), (GType)s7_integer(itype), (GSignalFlags)s7_integer(signal_flags), (class_closure == lg_false) ? NULL : (GClosure*)s7_c_pointer(class_closure), (GSignalAccumulator)s7_c_pointer_with_type(sc, accumulator, GSignalAccumulator_sym, __func__, 0), (gpointer)s7_c_pointer_with_type(sc, accu_data, gpointer_sym, __func__, 0), (GSignalCMarshaller)s7_c_pointer_with_type(sc, c_marshaller, GSignalCMarshaller_sym, __func__, 0), (GType)s7_integer(return_type), (guint)s7_integer(n_params), (GType*)s7_c_pointer_with_type(sc, param_types, GType__sym, __func__, 0))));
}

static s7_pointer lg_g_signal_lookup(s7_scheme *sc, s7_pointer args)
{
  #define H_g_signal_lookup "guint g_signal_lookup(gchar* name, GType itype)"
  s7_pointer _p;
  s7_pointer name, itype;
  _p = args;
  name = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(name)) s7_wrong_type_arg_error(sc, "g_signal_lookup", 1, name, "gchar*");
  itype = s7_car(_p);
  if (!s7_is_integer(itype)) s7_wrong_type_arg_error(sc, "g_signal_lookup", 2, itype, "GType");
  return(s7_make_integer(sc, g_signal_lookup((gchar*)s7_string(name), (GType)s7_integer(itype))));
}

static s7_pointer lg_g_signal_name(s7_scheme *sc, s7_pointer args)
{
  #define H_g_signal_name "gchar* g_signal_name(guint signal_id)"
  s7_pointer signal_id;
  signal_id = s7_car(args);
  if (!s7_is_integer(signal_id)) s7_wrong_type_arg_error(sc, "g_signal_name", 1, signal_id, "guint");
  return(s7_make_string(sc, g_signal_name((guint)s7_integer(signal_id))));
}

static s7_pointer lg_g_signal_query(s7_scheme *sc, s7_pointer args)
{
  #define H_g_signal_query "void g_signal_query(guint signal_id, GSignalQuery* query)"
  s7_pointer _p;
  s7_pointer signal_id, query;
  _p = args;
  signal_id = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(signal_id)) s7_wrong_type_arg_error(sc, "g_signal_query", 1, signal_id, "guint");
  query = s7_car(_p);
  g_signal_query((guint)s7_integer(signal_id), (GSignalQuery*)s7_c_pointer_with_type(sc, query, GSignalQuery__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_g_signal_list_ids(s7_scheme *sc, s7_pointer args)
{
  #define H_g_signal_list_ids "guint* g_signal_list_ids(GType itype, guint* n_ids)"
  s7_pointer _p;
  s7_pointer itype, n_ids;
  _p = args;
  itype = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(itype)) s7_wrong_type_arg_error(sc, "g_signal_list_ids", 1, itype, "GType");
  n_ids = s7_car(_p);
  return(lg_make_c_pointer_with_type(sc, guint__sym, g_signal_list_ids((GType)s7_integer(itype), (guint*)s7_c_pointer_with_type(sc, n_ids, guint__sym, __func__, 0))));
}

static s7_pointer lg_g_signal_parse_name(s7_scheme *sc, s7_pointer args)
{
  #define H_g_signal_parse_name "gboolean g_signal_parse_name(gchar* detailed_signal, GType itype, guint* [signal_id_p], \
GQuark* [detail_p], gboolean force_detail_quark)"
  s7_pointer _p;
  s7_pointer detailed_signal, itype, force_detail_quark;
  guint ref_signal_id_p;
  GQuark ref_detail_p;
  _p = args;
  detailed_signal = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(detailed_signal)) s7_wrong_type_arg_error(sc, "g_signal_parse_name", 1, detailed_signal, "gchar*");
  itype = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(itype)) s7_wrong_type_arg_error(sc, "g_signal_parse_name", 2, itype, "GType");
  force_detail_quark = s7_car(_p);
  if (!s7_is_boolean(force_detail_quark)) s7_wrong_type_arg_error(sc, "g_signal_parse_name", 5, force_detail_quark, "gboolean");
  {
    s7_pointer res_ult;
    res_ult = s7_make_boolean(sc, g_signal_parse_name((gchar*)s7_string(detailed_signal), (GType)s7_integer(itype), &ref_signal_id_p, &ref_detail_p, (gboolean)lg_boolean(force_detail_quark)));
      return(s7_list(sc, 3, res_ult, s7_make_integer(sc, ref_signal_id_p), s7_make_integer(sc, ref_detail_p)));
   }
}

static s7_pointer lg_g_signal_get_invocation_hint(s7_scheme *sc, s7_pointer args)
{
  #define H_g_signal_get_invocation_hint "GSignalInvocationHint* g_signal_get_invocation_hint(gpointer instance)"
  s7_pointer instance;
  instance = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GSignalInvocationHint__sym, g_signal_get_invocation_hint((gpointer)s7_c_pointer_with_type(sc, instance, gpointer_sym, __func__, 0))));
}

static s7_pointer lg_g_signal_stop_emission(s7_scheme *sc, s7_pointer args)
{
  #define H_g_signal_stop_emission "void g_signal_stop_emission(gpointer instance, guint signal_id, GQuark detail)"
  s7_pointer _p;
  s7_pointer instance, signal_id, detail;
  _p = args;
  instance = s7_car(_p); _p = s7_cdr(_p);
  signal_id = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(signal_id)) s7_wrong_type_arg_error(sc, "g_signal_stop_emission", 2, signal_id, "guint");
  detail = s7_car(_p);
  if (!s7_is_integer(detail)) s7_wrong_type_arg_error(sc, "g_signal_stop_emission", 3, detail, "GQuark");
  g_signal_stop_emission((gpointer)s7_c_pointer_with_type(sc, instance, gpointer_sym, __func__, 0), (guint)s7_integer(signal_id), (GQuark)s7_integer(detail));
  return(lg_false);
}

static s7_pointer lg_g_signal_stop_emission_by_name(s7_scheme *sc, s7_pointer args)
{
  #define H_g_signal_stop_emission_by_name "void g_signal_stop_emission_by_name(gpointer instance, gchar* detailed_signal)"
  s7_pointer _p;
  s7_pointer instance, detailed_signal;
  _p = args;
  instance = s7_car(_p); _p = s7_cdr(_p);
  detailed_signal = s7_car(_p);
  if (!s7_is_string(detailed_signal)) s7_wrong_type_arg_error(sc, "g_signal_stop_emission_by_name", 2, detailed_signal, "gchar*");
  g_signal_stop_emission_by_name((gpointer)s7_c_pointer_with_type(sc, instance, gpointer_sym, __func__, 0), (gchar*)s7_string(detailed_signal));
  return(lg_false);
}

static s7_pointer lg_g_signal_add_emission_hook(s7_scheme *sc, s7_pointer args)
{
  #define H_g_signal_add_emission_hook "gulong g_signal_add_emission_hook(guint signal_id, GQuark quark, \
GSignalEmissionHook hook_func, lambda_data func_info, GtkDestroyNotify data_destroy)"
  s7_pointer _p;
  s7_pointer signal_id, quark, hook_func, func_info, data_destroy;
  _p = args;
  signal_id = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(signal_id)) s7_wrong_type_arg_error(sc, "g_signal_add_emission_hook", 1, signal_id, "guint");
  quark = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(quark)) s7_wrong_type_arg_error(sc, "g_signal_add_emission_hook", 2, quark, "GQuark");
  hook_func = s7_car(_p); _p = s7_cdr(_p);
  func_info = s7_car(_p); _p = s7_cdr(_p);
  data_destroy = s7_car(_p);
  {
    s7_pointer res_ult;
    s7_pointer lg_ptr = s7_list(sc, 5, lg_false, func_info, lg_false, lg_false, lg_false);
    s7_gc_protect(sc, lg_ptr);
    s7_list_set(sc, lg_ptr, 3, data_destroy);
    res_ult = s7_make_integer(sc, g_signal_add_emission_hook((guint)s7_integer(signal_id), (GQuark)s7_integer(quark), (GSignalEmissionHook)s7_c_pointer_with_type(sc, hook_func, GSignalEmissionHook_sym, __func__, 0), (gpointer)lg_ptr, lg_destroy_func));
    return(res_ult);
   }
}

static s7_pointer lg_g_signal_remove_emission_hook(s7_scheme *sc, s7_pointer args)
{
  #define H_g_signal_remove_emission_hook "void g_signal_remove_emission_hook(guint signal_id, gulong hook_id)"
  s7_pointer _p;
  s7_pointer signal_id, hook_id;
  _p = args;
  signal_id = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(signal_id)) s7_wrong_type_arg_error(sc, "g_signal_remove_emission_hook", 1, signal_id, "guint");
  hook_id = s7_car(_p);
  if (!s7_is_integer(hook_id)) s7_wrong_type_arg_error(sc, "g_signal_remove_emission_hook", 2, hook_id, "gulong");
  g_signal_remove_emission_hook((guint)s7_integer(signal_id), (gulong)s7_integer(hook_id));
  return(lg_false);
}

static s7_pointer lg_g_signal_has_handler_pending(s7_scheme *sc, s7_pointer args)
{
  #define H_g_signal_has_handler_pending "gboolean g_signal_has_handler_pending(gpointer instance, guint signal_id, \
GQuark detail, gboolean may_be_blocked)"
  s7_pointer _p;
  s7_pointer instance, signal_id, detail, may_be_blocked;
  _p = args;
  instance = s7_car(_p); _p = s7_cdr(_p);
  signal_id = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(signal_id)) s7_wrong_type_arg_error(sc, "g_signal_has_handler_pending", 2, signal_id, "guint");
  detail = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(detail)) s7_wrong_type_arg_error(sc, "g_signal_has_handler_pending", 3, detail, "GQuark");
  may_be_blocked = s7_car(_p);
  if (!s7_is_boolean(may_be_blocked)) s7_wrong_type_arg_error(sc, "g_signal_has_handler_pending", 4, may_be_blocked, "gboolean");
  return(s7_make_boolean(sc, g_signal_has_handler_pending((gpointer)s7_c_pointer_with_type(sc, instance, gpointer_sym, __func__, 0), (guint)s7_integer(signal_id), (GQuark)s7_integer(detail), (gboolean)lg_boolean(may_be_blocked))));
}

static s7_pointer lg_g_signal_connect_closure_by_id(s7_scheme *sc, s7_pointer args)
{
  #define H_g_signal_connect_closure_by_id "gulong g_signal_connect_closure_by_id(gpointer instance, \
guint signal_id, GQuark detail, GClosure* closure, gboolean after)"
  s7_pointer _p;
  s7_pointer instance, signal_id, detail, closure, after;
  _p = args;
  instance = s7_car(_p); _p = s7_cdr(_p);
  signal_id = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(signal_id)) s7_wrong_type_arg_error(sc, "g_signal_connect_closure_by_id", 2, signal_id, "guint");
  detail = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(detail)) s7_wrong_type_arg_error(sc, "g_signal_connect_closure_by_id", 3, detail, "GQuark");
  closure = s7_car(_p); _p = s7_cdr(_p);
  after = s7_car(_p);
  if (!s7_is_boolean(after)) s7_wrong_type_arg_error(sc, "g_signal_connect_closure_by_id", 5, after, "gboolean");
  return(s7_make_integer(sc, g_signal_connect_closure_by_id((gpointer)s7_c_pointer_with_type(sc, instance, gpointer_sym, __func__, 0), (guint)s7_integer(signal_id), (GQuark)s7_integer(detail), (closure == lg_false) ? NULL : (GClosure*)s7_c_pointer(closure), (gboolean)lg_boolean(after))));
}

static s7_pointer lg_g_signal_connect_closure(s7_scheme *sc, s7_pointer args)
{
  #define H_g_signal_connect_closure "gulong g_signal_connect_closure(gpointer instance, gchar* detailed_signal, \
GClosure* closure, gboolean after)"
  s7_pointer _p;
  s7_pointer instance, detailed_signal, closure, after;
  _p = args;
  instance = s7_car(_p); _p = s7_cdr(_p);
  detailed_signal = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(detailed_signal)) s7_wrong_type_arg_error(sc, "g_signal_connect_closure", 2, detailed_signal, "gchar*");
  closure = s7_car(_p); _p = s7_cdr(_p);
  after = s7_car(_p);
  if (!s7_is_boolean(after)) s7_wrong_type_arg_error(sc, "g_signal_connect_closure", 4, after, "gboolean");
  return(s7_make_integer(sc, g_signal_connect_closure((gpointer)s7_c_pointer_with_type(sc, instance, gpointer_sym, __func__, 0), (gchar*)s7_string(detailed_signal), (closure == lg_false) ? NULL : (GClosure*)s7_c_pointer(closure), (gboolean)lg_boolean(after))));
}

static s7_pointer lg_g_signal_connect_data(s7_scheme *sc, s7_pointer args)
{
  #define H_g_signal_connect_data "gulong g_signal_connect_data(gpointer instance, gchar* detailed_signal, \
GCallback func, lambda_data func_info, GClosureNotify destroy_data, GConnectFlags connect_flags)"
  s7_pointer _p;
  s7_pointer instance, detailed_signal, func, func_info, destroy_data, connect_flags;
  _p = args;
  instance = s7_car(_p); _p = s7_cdr(_p);
  detailed_signal = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(detailed_signal)) s7_wrong_type_arg_error(sc, "g_signal_connect_data", 2, detailed_signal, "gchar*");
  func = s7_car(_p); _p = s7_cdr(_p);
  func_info = s7_car(_p); _p = s7_cdr(_p);
  destroy_data = s7_car(_p); _p = s7_cdr(_p);
  connect_flags = s7_car(_p);
  if (!s7_is_integer(connect_flags)) s7_wrong_type_arg_error(sc, "g_signal_connect_data", 6, connect_flags, "GConnectFlags");
  {
    s7_pointer res_ult;
    int loc;
    s7_pointer lg_ptr = s7_list(sc, 5, func, func_info, lg_false, lg_false, lg_false);
    loc = s7_gc_protect(sc, lg_ptr);
    s7_list_set(sc, lg_ptr, 2, s7_make_integer(sc, loc));
    res_ult = s7_make_integer(sc, g_signal_connect_data((gpointer)s7_c_pointer_with_type(sc, instance, gpointer_sym, __func__, 0), (gchar*)s7_string(detailed_signal), ((s7_is_aritable(sc, func, 4)) ? (GCallback)lg_func4 : ((s7_is_aritable(sc, func, 3)) ? (GCallback)lg_func3 : (GCallback)lg_func2)), (gpointer)lg_ptr, NULL, (GConnectFlags)s7_integer(connect_flags)));
    return(res_ult);
   }
}

static s7_pointer lg_g_signal_handler_block(s7_scheme *sc, s7_pointer args)
{
  #define H_g_signal_handler_block "void g_signal_handler_block(gpointer instance, gulong handler_id)"
  s7_pointer _p;
  s7_pointer instance, handler_id;
  _p = args;
  instance = s7_car(_p); _p = s7_cdr(_p);
  handler_id = s7_car(_p);
  if (!s7_is_integer(handler_id)) s7_wrong_type_arg_error(sc, "g_signal_handler_block", 2, handler_id, "gulong");
  g_signal_handler_block((gpointer)s7_c_pointer_with_type(sc, instance, gpointer_sym, __func__, 0), (gulong)s7_integer(handler_id));
  return(lg_false);
}

static s7_pointer lg_g_signal_handler_unblock(s7_scheme *sc, s7_pointer args)
{
  #define H_g_signal_handler_unblock "void g_signal_handler_unblock(gpointer instance, gulong handler_id)"
  s7_pointer _p;
  s7_pointer instance, handler_id;
  _p = args;
  instance = s7_car(_p); _p = s7_cdr(_p);
  handler_id = s7_car(_p);
  if (!s7_is_integer(handler_id)) s7_wrong_type_arg_error(sc, "g_signal_handler_unblock", 2, handler_id, "gulong");
  g_signal_handler_unblock((gpointer)s7_c_pointer_with_type(sc, instance, gpointer_sym, __func__, 0), (gulong)s7_integer(handler_id));
  return(lg_false);
}

static s7_pointer lg_g_signal_handler_disconnect(s7_scheme *sc, s7_pointer args)
{
  #define H_g_signal_handler_disconnect "void g_signal_handler_disconnect(gpointer instance, gulong handler_id)"
  s7_pointer _p;
  s7_pointer instance, handler_id;
  _p = args;
  instance = s7_car(_p); _p = s7_cdr(_p);
  handler_id = s7_car(_p);
  if (!s7_is_integer(handler_id)) s7_wrong_type_arg_error(sc, "g_signal_handler_disconnect", 2, handler_id, "gulong");
  g_signal_handler_disconnect((gpointer)s7_c_pointer_with_type(sc, instance, gpointer_sym, __func__, 0), (gulong)s7_integer(handler_id));
  return(lg_false);
}

static s7_pointer lg_g_signal_handler_is_connected(s7_scheme *sc, s7_pointer args)
{
  #define H_g_signal_handler_is_connected "gboolean g_signal_handler_is_connected(gpointer instance, \
gulong handler_id)"
  s7_pointer _p;
  s7_pointer instance, handler_id;
  _p = args;
  instance = s7_car(_p); _p = s7_cdr(_p);
  handler_id = s7_car(_p);
  if (!s7_is_integer(handler_id)) s7_wrong_type_arg_error(sc, "g_signal_handler_is_connected", 2, handler_id, "gulong");
  return(s7_make_boolean(sc, g_signal_handler_is_connected((gpointer)s7_c_pointer_with_type(sc, instance, gpointer_sym, __func__, 0), (gulong)s7_integer(handler_id))));
}

static s7_pointer lg_g_signal_handler_find(s7_scheme *sc, s7_pointer args)
{
  #define H_g_signal_handler_find "gulong g_signal_handler_find(gpointer instance, GSignalMatchType mask, \
guint signal_id, GQuark detail, GClosure* closure, gpointer func, gpointer data)"
  s7_pointer _p;
  s7_pointer instance, mask, signal_id, detail, closure, func, data;
  _p = args;
  instance = s7_car(_p); _p = s7_cdr(_p);
  mask = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(mask)) s7_wrong_type_arg_error(sc, "g_signal_handler_find", 2, mask, "GSignalMatchType");
  signal_id = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(signal_id)) s7_wrong_type_arg_error(sc, "g_signal_handler_find", 3, signal_id, "guint");
  detail = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(detail)) s7_wrong_type_arg_error(sc, "g_signal_handler_find", 4, detail, "GQuark");
  closure = s7_car(_p); _p = s7_cdr(_p);
  func = s7_car(_p); _p = s7_cdr(_p);
  data = s7_car(_p);
  return(s7_make_integer(sc, g_signal_handler_find((gpointer)s7_c_pointer_with_type(sc, instance, gpointer_sym, __func__, 0), (GSignalMatchType)s7_integer(mask), (guint)s7_integer(signal_id), (GQuark)s7_integer(detail), (closure == lg_false) ? NULL : (GClosure*)s7_c_pointer(closure), (gpointer)s7_c_pointer_with_type(sc, func, gpointer_sym, __func__, 0), (gpointer)s7_c_pointer_with_type(sc, data, gpointer_sym, __func__, 0))));
}

static s7_pointer lg_g_signal_handlers_block_matched(s7_scheme *sc, s7_pointer args)
{
  #define H_g_signal_handlers_block_matched "guint g_signal_handlers_block_matched(gpointer instance, \
GSignalMatchType mask, guint signal_id, GQuark detail, GClosure* closure, gpointer func, gpointer data)"
  s7_pointer _p;
  s7_pointer instance, mask, signal_id, detail, closure, func, data;
  _p = args;
  instance = s7_car(_p); _p = s7_cdr(_p);
  mask = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(mask)) s7_wrong_type_arg_error(sc, "g_signal_handlers_block_matched", 2, mask, "GSignalMatchType");
  signal_id = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(signal_id)) s7_wrong_type_arg_error(sc, "g_signal_handlers_block_matched", 3, signal_id, "guint");
  detail = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(detail)) s7_wrong_type_arg_error(sc, "g_signal_handlers_block_matched", 4, detail, "GQuark");
  closure = s7_car(_p); _p = s7_cdr(_p);
  func = s7_car(_p); _p = s7_cdr(_p);
  data = s7_car(_p);
  return(s7_make_integer(sc, g_signal_handlers_block_matched((gpointer)s7_c_pointer_with_type(sc, instance, gpointer_sym, __func__, 0), (GSignalMatchType)s7_integer(mask), (guint)s7_integer(signal_id), (GQuark)s7_integer(detail), (closure == lg_false) ? NULL : (GClosure*)s7_c_pointer(closure), (gpointer)s7_c_pointer_with_type(sc, func, gpointer_sym, __func__, 0), (gpointer)s7_c_pointer_with_type(sc, data, gpointer_sym, __func__, 0))));
}

static s7_pointer lg_g_signal_handlers_unblock_matched(s7_scheme *sc, s7_pointer args)
{
  #define H_g_signal_handlers_unblock_matched "guint g_signal_handlers_unblock_matched(gpointer instance, \
GSignalMatchType mask, guint signal_id, GQuark detail, GClosure* closure, gpointer func, gpointer data)"
  s7_pointer _p;
  s7_pointer instance, mask, signal_id, detail, closure, func, data;
  _p = args;
  instance = s7_car(_p); _p = s7_cdr(_p);
  mask = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(mask)) s7_wrong_type_arg_error(sc, "g_signal_handlers_unblock_matched", 2, mask, "GSignalMatchType");
  signal_id = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(signal_id)) s7_wrong_type_arg_error(sc, "g_signal_handlers_unblock_matched", 3, signal_id, "guint");
  detail = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(detail)) s7_wrong_type_arg_error(sc, "g_signal_handlers_unblock_matched", 4, detail, "GQuark");
  closure = s7_car(_p); _p = s7_cdr(_p);
  func = s7_car(_p); _p = s7_cdr(_p);
  data = s7_car(_p);
  return(s7_make_integer(sc, g_signal_handlers_unblock_matched((gpointer)s7_c_pointer_with_type(sc, instance, gpointer_sym, __func__, 0), (GSignalMatchType)s7_integer(mask), (guint)s7_integer(signal_id), (GQuark)s7_integer(detail), (closure == lg_false) ? NULL : (GClosure*)s7_c_pointer(closure), (gpointer)s7_c_pointer_with_type(sc, func, gpointer_sym, __func__, 0), (gpointer)s7_c_pointer_with_type(sc, data, gpointer_sym, __func__, 0))));
}

static s7_pointer lg_g_signal_handlers_disconnect_matched(s7_scheme *sc, s7_pointer args)
{
  #define H_g_signal_handlers_disconnect_matched "guint g_signal_handlers_disconnect_matched(gpointer instance, \
GSignalMatchType mask, guint signal_id, GQuark detail, GClosure* closure, gpointer func, gpointer data)"
  s7_pointer _p;
  s7_pointer instance, mask, signal_id, detail, closure, func, data;
  _p = args;
  instance = s7_car(_p); _p = s7_cdr(_p);
  mask = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(mask)) s7_wrong_type_arg_error(sc, "g_signal_handlers_disconnect_matched", 2, mask, "GSignalMatchType");
  signal_id = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(signal_id)) s7_wrong_type_arg_error(sc, "g_signal_handlers_disconnect_matched", 3, signal_id, "guint");
  detail = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(detail)) s7_wrong_type_arg_error(sc, "g_signal_handlers_disconnect_matched", 4, detail, "GQuark");
  closure = s7_car(_p); _p = s7_cdr(_p);
  func = s7_car(_p); _p = s7_cdr(_p);
  data = s7_car(_p);
  return(s7_make_integer(sc, g_signal_handlers_disconnect_matched((gpointer)s7_c_pointer_with_type(sc, instance, gpointer_sym, __func__, 0), (GSignalMatchType)s7_integer(mask), (guint)s7_integer(signal_id), (GQuark)s7_integer(detail), (closure == lg_false) ? NULL : (GClosure*)s7_c_pointer(closure), (gpointer)s7_c_pointer_with_type(sc, func, gpointer_sym, __func__, 0), (gpointer)s7_c_pointer_with_type(sc, data, gpointer_sym, __func__, 0))));
}

static s7_pointer lg_g_signal_handlers_destroy(s7_scheme *sc, s7_pointer args)
{
  #define H_g_signal_handlers_destroy "void g_signal_handlers_destroy(gpointer instance)"
  s7_pointer instance;
  instance = s7_car(args);
  g_signal_handlers_destroy((gpointer)s7_c_pointer_with_type(sc, instance, gpointer_sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_g_object_ref(s7_scheme *sc, s7_pointer args)
{
  #define H_g_object_ref "gpointer g_object_ref(gpointer object)"
  s7_pointer object;
  object = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, gpointer_sym, g_object_ref((gpointer)s7_c_pointer_with_type(sc, object, gpointer_sym, __func__, 0))));
}

static s7_pointer lg_g_object_unref(s7_scheme *sc, s7_pointer args)
{
  #define H_g_object_unref "void g_object_unref(gpointer object)"
  s7_pointer object;
  object = s7_car(args);
  g_object_unref((gpointer)s7_c_pointer_with_type(sc, object, gpointer_sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gdk_event_get_time(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_event_get_time "guint32 gdk_event_get_time(GdkEvent* event)"
  s7_pointer event;
  event = s7_car(args);
  return(s7_make_integer(sc, gdk_event_get_time((GdkEvent*)s7_c_pointer_with_type(sc, event, GdkEvent__sym, __func__, 0))));
}

static s7_pointer lg_gdk_rectangle_intersect(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_rectangle_intersect "gboolean gdk_rectangle_intersect(GdkRectangle* src1, GdkRectangle* src2, \
GdkRectangle* dest)"
  s7_pointer _p;
  s7_pointer src1, src2, dest;
  _p = args;
  src1 = s7_car(_p); _p = s7_cdr(_p);
  src2 = s7_car(_p); _p = s7_cdr(_p);
  dest = s7_car(_p);
  return(s7_make_boolean(sc, gdk_rectangle_intersect((GdkRectangle*)s7_c_pointer_with_type(sc, src1, GdkRectangle__sym, __func__, 0), (GdkRectangle*)s7_c_pointer_with_type(sc, src2, GdkRectangle__sym, __func__, 0), (GdkRectangle*)s7_c_pointer_with_type(sc, dest, GdkRectangle__sym, __func__, 0))));
}

static s7_pointer lg_gdk_rectangle_union(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_rectangle_union "void gdk_rectangle_union(GdkRectangle* src1, GdkRectangle* src2, GdkRectangle* dest)"
  s7_pointer _p;
  s7_pointer src1, src2, dest;
  _p = args;
  src1 = s7_car(_p); _p = s7_cdr(_p);
  src2 = s7_car(_p); _p = s7_cdr(_p);
  dest = s7_car(_p);
  gdk_rectangle_union((GdkRectangle*)s7_c_pointer_with_type(sc, src1, GdkRectangle__sym, __func__, 0), (GdkRectangle*)s7_c_pointer_with_type(sc, src2, GdkRectangle__sym, __func__, 0), (GdkRectangle*)s7_c_pointer_with_type(sc, dest, GdkRectangle__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gdk_keyval_name(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_keyval_name "gchar* gdk_keyval_name(guint keyval)"
  s7_pointer keyval;
  keyval = s7_car(args);
  if (!s7_is_integer(keyval)) s7_wrong_type_arg_error(sc, "gdk_keyval_name", 1, keyval, "guint");
  return(s7_make_string(sc, gdk_keyval_name((guint)s7_integer(keyval))));
}

static s7_pointer lg_gdk_keyval_from_name(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_keyval_from_name "guint gdk_keyval_from_name(gchar* keyval_name)"
  s7_pointer keyval_name;
  keyval_name = s7_car(args);
  if (!s7_is_string(keyval_name)) s7_wrong_type_arg_error(sc, "gdk_keyval_from_name", 1, keyval_name, "gchar*");
  return(s7_make_integer(sc, gdk_keyval_from_name((gchar*)s7_string(keyval_name))));
}

static s7_pointer lg_gdk_keyval_convert_case(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_keyval_convert_case "void gdk_keyval_convert_case(guint symbol, guint* [lower], guint* [upper])"
  s7_pointer _p;
  s7_pointer symbol;
  guint ref_lower;
  guint ref_upper;
  _p = args;
  symbol = s7_car(_p);
  if (!s7_is_integer(symbol)) s7_wrong_type_arg_error(sc, "gdk_keyval_convert_case", 1, symbol, "guint");
  gdk_keyval_convert_case((guint)s7_integer(symbol), &ref_lower, &ref_upper);
    return(s7_list(sc, 2, s7_make_integer(sc, ref_lower), s7_make_integer(sc, ref_upper)));
}

static s7_pointer lg_gdk_keyval_to_upper(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_keyval_to_upper "guint gdk_keyval_to_upper(guint keyval)"
  s7_pointer keyval;
  keyval = s7_car(args);
  if (!s7_is_integer(keyval)) s7_wrong_type_arg_error(sc, "gdk_keyval_to_upper", 1, keyval, "guint");
  return(s7_make_integer(sc, gdk_keyval_to_upper((guint)s7_integer(keyval))));
}

static s7_pointer lg_gdk_keyval_to_lower(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_keyval_to_lower "guint gdk_keyval_to_lower(guint keyval)"
  s7_pointer keyval;
  keyval = s7_car(args);
  if (!s7_is_integer(keyval)) s7_wrong_type_arg_error(sc, "gdk_keyval_to_lower", 1, keyval, "guint");
  return(s7_make_integer(sc, gdk_keyval_to_lower((guint)s7_integer(keyval))));
}

static s7_pointer lg_gdk_keyval_is_upper(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_keyval_is_upper "gboolean gdk_keyval_is_upper(guint keyval)"
  s7_pointer keyval;
  keyval = s7_car(args);
  if (!s7_is_integer(keyval)) s7_wrong_type_arg_error(sc, "gdk_keyval_is_upper", 1, keyval, "guint");
  return(s7_make_boolean(sc, gdk_keyval_is_upper((guint)s7_integer(keyval))));
}

static s7_pointer lg_gdk_keyval_is_lower(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_keyval_is_lower "gboolean gdk_keyval_is_lower(guint keyval)"
  s7_pointer keyval;
  keyval = s7_car(args);
  if (!s7_is_integer(keyval)) s7_wrong_type_arg_error(sc, "gdk_keyval_is_lower", 1, keyval, "guint");
  return(s7_make_boolean(sc, gdk_keyval_is_lower((guint)s7_integer(keyval))));
}

static s7_pointer lg_gdk_keyval_to_unicode(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_keyval_to_unicode "guint32 gdk_keyval_to_unicode(guint keyval)"
  s7_pointer keyval;
  keyval = s7_car(args);
  if (!s7_is_integer(keyval)) s7_wrong_type_arg_error(sc, "gdk_keyval_to_unicode", 1, keyval, "guint");
  return(s7_make_integer(sc, gdk_keyval_to_unicode((guint)s7_integer(keyval))));
}

static s7_pointer lg_gdk_unicode_to_keyval(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_unicode_to_keyval "guint gdk_unicode_to_keyval(guint32 wc)"
  s7_pointer wc;
  wc = s7_car(args);
  if (!s7_is_integer(wc)) s7_wrong_type_arg_error(sc, "gdk_unicode_to_keyval", 1, wc, "guint32");
  return(s7_make_integer(sc, gdk_unicode_to_keyval((guint32)s7_integer(wc))));
}

static s7_pointer lg_gdk_pixbuf_error_quark(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_pixbuf_error_quark "GQuark gdk_pixbuf_error_quark( void)"
  return(s7_make_integer(sc, gdk_pixbuf_error_quark()));
}

static s7_pointer lg_gdk_pixbuf_get_colorspace(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_pixbuf_get_colorspace "GdkColorspace gdk_pixbuf_get_colorspace(GdkPixbuf* pixbuf)"
  s7_pointer pixbuf;
  pixbuf = s7_car(args);
  return(s7_make_integer(sc, gdk_pixbuf_get_colorspace((GdkPixbuf*)s7_c_pointer_with_type(sc, pixbuf, GdkPixbuf__sym, __func__, 0))));
}

static s7_pointer lg_gdk_pixbuf_get_n_channels(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_pixbuf_get_n_channels "int gdk_pixbuf_get_n_channels(GdkPixbuf* pixbuf)"
  s7_pointer pixbuf;
  pixbuf = s7_car(args);
  return(s7_make_integer(sc, gdk_pixbuf_get_n_channels((GdkPixbuf*)s7_c_pointer_with_type(sc, pixbuf, GdkPixbuf__sym, __func__, 0))));
}

static s7_pointer lg_gdk_pixbuf_get_has_alpha(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_pixbuf_get_has_alpha "gboolean gdk_pixbuf_get_has_alpha(GdkPixbuf* pixbuf)"
  s7_pointer pixbuf;
  pixbuf = s7_car(args);
  return(s7_make_boolean(sc, gdk_pixbuf_get_has_alpha((GdkPixbuf*)s7_c_pointer_with_type(sc, pixbuf, GdkPixbuf__sym, __func__, 0))));
}

static s7_pointer lg_gdk_pixbuf_get_bits_per_sample(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_pixbuf_get_bits_per_sample "int gdk_pixbuf_get_bits_per_sample(GdkPixbuf* pixbuf)"
  s7_pointer pixbuf;
  pixbuf = s7_car(args);
  return(s7_make_integer(sc, gdk_pixbuf_get_bits_per_sample((GdkPixbuf*)s7_c_pointer_with_type(sc, pixbuf, GdkPixbuf__sym, __func__, 0))));
}

static s7_pointer lg_gdk_pixbuf_get_pixels(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_pixbuf_get_pixels "guchar* gdk_pixbuf_get_pixels(GdkPixbuf* pixbuf)"
  s7_pointer pixbuf;
  pixbuf = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, guchar__sym, gdk_pixbuf_get_pixels((GdkPixbuf*)s7_c_pointer_with_type(sc, pixbuf, GdkPixbuf__sym, __func__, 0))));
}

static s7_pointer lg_gdk_pixbuf_get_width(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_pixbuf_get_width "int gdk_pixbuf_get_width(GdkPixbuf* pixbuf)"
  s7_pointer pixbuf;
  pixbuf = s7_car(args);
  return(s7_make_integer(sc, gdk_pixbuf_get_width((GdkPixbuf*)s7_c_pointer_with_type(sc, pixbuf, GdkPixbuf__sym, __func__, 0))));
}

static s7_pointer lg_gdk_pixbuf_get_height(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_pixbuf_get_height "int gdk_pixbuf_get_height(GdkPixbuf* pixbuf)"
  s7_pointer pixbuf;
  pixbuf = s7_car(args);
  return(s7_make_integer(sc, gdk_pixbuf_get_height((GdkPixbuf*)s7_c_pointer_with_type(sc, pixbuf, GdkPixbuf__sym, __func__, 0))));
}

static s7_pointer lg_gdk_pixbuf_get_rowstride(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_pixbuf_get_rowstride "int gdk_pixbuf_get_rowstride(GdkPixbuf* pixbuf)"
  s7_pointer pixbuf;
  pixbuf = s7_car(args);
  return(s7_make_integer(sc, gdk_pixbuf_get_rowstride((GdkPixbuf*)s7_c_pointer_with_type(sc, pixbuf, GdkPixbuf__sym, __func__, 0))));
}

static s7_pointer lg_gdk_pixbuf_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_pixbuf_new "GdkPixbuf* gdk_pixbuf_new(GdkColorspace colorspace, gboolean has_alpha, int bits_per_sample, \
int width, int height)"
  s7_pointer _p;
  s7_pointer colorspace, has_alpha, bits_per_sample, width, height;
  _p = args;
  colorspace = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(colorspace)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_new", 1, colorspace, "GdkColorspace");
  has_alpha = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_boolean(has_alpha)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_new", 2, has_alpha, "gboolean");
  bits_per_sample = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(bits_per_sample)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_new", 3, bits_per_sample, "int");
  width = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(width)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_new", 4, width, "int");
  height = s7_car(_p);
  if (!s7_is_integer(height)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_new", 5, height, "int");
  return(lg_make_c_pointer_with_type(sc, GdkPixbuf__sym, gdk_pixbuf_new((GdkColorspace)s7_integer(colorspace), (gboolean)lg_boolean(has_alpha), (int)s7_integer(bits_per_sample), (int)s7_integer(width), (int)s7_integer(height))));
}

static s7_pointer lg_gdk_pixbuf_copy(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_pixbuf_copy "GdkPixbuf* gdk_pixbuf_copy(GdkPixbuf* pixbuf)"
  s7_pointer pixbuf;
  pixbuf = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GdkPixbuf__sym, gdk_pixbuf_copy((GdkPixbuf*)s7_c_pointer_with_type(sc, pixbuf, GdkPixbuf__sym, __func__, 0))));
}

static s7_pointer lg_gdk_pixbuf_new_subpixbuf(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_pixbuf_new_subpixbuf "GdkPixbuf* gdk_pixbuf_new_subpixbuf(GdkPixbuf* src_pixbuf, int src_x, \
int src_y, int width, int height)"
  s7_pointer _p;
  s7_pointer src_pixbuf, src_x, src_y, width, height;
  _p = args;
  src_pixbuf = s7_car(_p); _p = s7_cdr(_p);
  src_x = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(src_x)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_new_subpixbuf", 2, src_x, "int");
  src_y = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(src_y)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_new_subpixbuf", 3, src_y, "int");
  width = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(width)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_new_subpixbuf", 4, width, "int");
  height = s7_car(_p);
  if (!s7_is_integer(height)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_new_subpixbuf", 5, height, "int");
  return(lg_make_c_pointer_with_type(sc, GdkPixbuf__sym, gdk_pixbuf_new_subpixbuf((GdkPixbuf*)s7_c_pointer_with_type(sc, src_pixbuf, GdkPixbuf__sym, __func__, 0), (int)s7_integer(src_x), (int)s7_integer(src_y), (int)s7_integer(width), (int)s7_integer(height))));
}

static s7_pointer lg_gdk_pixbuf_new_from_file(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_pixbuf_new_from_file "GdkPixbuf* gdk_pixbuf_new_from_file(char* filename, GError** [error])"
  s7_pointer _p;
  s7_pointer filename;
  GError* ref_error = NULL;
  _p = args;
  filename = s7_car(_p);
  if (!s7_is_string(filename)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_new_from_file", 1, filename, "char*");
  {
    s7_pointer res_ult;
    res_ult = lg_make_c_pointer_with_type(sc, GdkPixbuf__sym, gdk_pixbuf_new_from_file((char*)s7_string(filename), &ref_error));
      return(s7_list(sc, 2, res_ult, s7_make_c_pointer(sc, ref_error)));
   }
}

static s7_pointer lg_gdk_pixbuf_new_from_data(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_pixbuf_new_from_data "GdkPixbuf* gdk_pixbuf_new_from_data(guchar* data, GdkColorspace colorspace, \
gboolean has_alpha, int bits_per_sample, int width, int height, int rowstride, GdkPixbufDestroyNotify destroy_fn, \
gpointer destroy_fn_data)"
  s7_pointer _p;
  s7_pointer data, colorspace, has_alpha, bits_per_sample, width, height, rowstride, destroy_fn, destroy_fn_data;
  _p = args;
  data = s7_car(_p); _p = s7_cdr(_p);
  colorspace = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(colorspace)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_new_from_data", 2, colorspace, "GdkColorspace");
  has_alpha = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_boolean(has_alpha)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_new_from_data", 3, has_alpha, "gboolean");
  bits_per_sample = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(bits_per_sample)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_new_from_data", 4, bits_per_sample, "int");
  width = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(width)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_new_from_data", 5, width, "int");
  height = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(height)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_new_from_data", 6, height, "int");
  rowstride = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(rowstride)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_new_from_data", 7, rowstride, "int");
  destroy_fn = s7_car(_p); _p = s7_cdr(_p);
  destroy_fn_data = s7_car(_p);
  return(lg_make_c_pointer_with_type(sc, GdkPixbuf__sym, gdk_pixbuf_new_from_data((guchar*)s7_c_pointer_with_type(sc, data, guchar__sym, __func__, 0), (GdkColorspace)s7_integer(colorspace), (gboolean)lg_boolean(has_alpha), (int)s7_integer(bits_per_sample), (int)s7_integer(width), (int)s7_integer(height), (int)s7_integer(rowstride), (GdkPixbufDestroyNotify)s7_c_pointer_with_type(sc, destroy_fn, GdkPixbufDestroyNotify_sym, __func__, 0), (gpointer)s7_c_pointer_with_type(sc, destroy_fn_data, gpointer_sym, __func__, 0))));
}

static s7_pointer lg_gdk_pixbuf_new_from_xpm_data(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_pixbuf_new_from_xpm_data "GdkPixbuf* gdk_pixbuf_new_from_xpm_data(char** data)"
  s7_pointer data;
  data = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GdkPixbuf__sym, gdk_pixbuf_new_from_xpm_data((const char**)s7_c_pointer_with_type(sc, data, char___sym, __func__, 0))));
}

static s7_pointer lg_gdk_pixbuf_fill(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_pixbuf_fill "void gdk_pixbuf_fill(GdkPixbuf* pixbuf, guint32 pixel)"
  s7_pointer _p;
  s7_pointer pixbuf, pixel;
  _p = args;
  pixbuf = s7_car(_p); _p = s7_cdr(_p);
  pixel = s7_car(_p);
  if (!s7_is_integer(pixel)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_fill", 2, pixel, "guint32");
  gdk_pixbuf_fill((GdkPixbuf*)s7_c_pointer_with_type(sc, pixbuf, GdkPixbuf__sym, __func__, 0), (guint32)s7_integer(pixel));
  return(lg_false);
}

static s7_pointer lg_gdk_pixbuf_savev(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_pixbuf_savev "gboolean gdk_pixbuf_savev(GdkPixbuf* pixbuf, char* filename, char* type, \
char** option_keys, char** option_values, GError** [error])"
  s7_pointer _p;
  s7_pointer pixbuf, filename, type, option_keys, option_values;
  GError* ref_error = NULL;
  _p = args;
  pixbuf = s7_car(_p); _p = s7_cdr(_p);
  filename = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(filename)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_savev", 2, filename, "char*");
  type = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(type)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_savev", 3, type, "char*");
  option_keys = s7_car(_p); _p = s7_cdr(_p);
  option_values = s7_car(_p);
  {
    s7_pointer res_ult;
    res_ult = s7_make_boolean(sc, gdk_pixbuf_savev((GdkPixbuf*)s7_c_pointer_with_type(sc, pixbuf, GdkPixbuf__sym, __func__, 0), (char*)s7_string(filename), (char*)s7_string(type), (char**)s7_c_pointer_with_type(sc, option_keys, char___sym, __func__, 0), (char**)s7_c_pointer_with_type(sc, option_values, char___sym, __func__, 0), &ref_error));
      return(s7_list(sc, 2, res_ult, s7_make_c_pointer(sc, ref_error)));
   }
}

static s7_pointer lg_gdk_pixbuf_add_alpha(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_pixbuf_add_alpha "GdkPixbuf* gdk_pixbuf_add_alpha(GdkPixbuf* pixbuf, gboolean substitute_color, \
guchar r, guchar g, guchar b)"
  s7_pointer _p;
  s7_pointer pixbuf, substitute_color, r, g, b;
  _p = args;
  pixbuf = s7_car(_p); _p = s7_cdr(_p);
  substitute_color = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_boolean(substitute_color)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_add_alpha", 2, substitute_color, "gboolean");
  r = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(r)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_add_alpha", 3, r, "guchar");
  g = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(g)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_add_alpha", 4, g, "guchar");
  b = s7_car(_p);
  if (!s7_is_integer(b)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_add_alpha", 5, b, "guchar");
  return(lg_make_c_pointer_with_type(sc, GdkPixbuf__sym, gdk_pixbuf_add_alpha((GdkPixbuf*)s7_c_pointer_with_type(sc, pixbuf, GdkPixbuf__sym, __func__, 0), (gboolean)lg_boolean(substitute_color), (guchar)s7_integer(r), (guchar)s7_integer(g), (guchar)s7_integer(b))));
}

static s7_pointer lg_gdk_pixbuf_copy_area(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_pixbuf_copy_area "void gdk_pixbuf_copy_area(GdkPixbuf* src_pixbuf, int src_x, int src_y, \
int width, int height, GdkPixbuf* dest_pixbuf, int dest_x, int dest_y)"
  s7_pointer _p;
  s7_pointer src_pixbuf, src_x, src_y, width, height, dest_pixbuf, dest_x, dest_y;
  _p = args;
  src_pixbuf = s7_car(_p); _p = s7_cdr(_p);
  src_x = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(src_x)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_copy_area", 2, src_x, "int");
  src_y = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(src_y)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_copy_area", 3, src_y, "int");
  width = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(width)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_copy_area", 4, width, "int");
  height = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(height)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_copy_area", 5, height, "int");
  dest_pixbuf = s7_car(_p); _p = s7_cdr(_p);
  dest_x = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(dest_x)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_copy_area", 7, dest_x, "int");
  dest_y = s7_car(_p);
  if (!s7_is_integer(dest_y)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_copy_area", 8, dest_y, "int");
  gdk_pixbuf_copy_area((GdkPixbuf*)s7_c_pointer_with_type(sc, src_pixbuf, GdkPixbuf__sym, __func__, 0), (int)s7_integer(src_x), (int)s7_integer(src_y), (int)s7_integer(width), (int)s7_integer(height), (GdkPixbuf*)s7_c_pointer_with_type(sc, dest_pixbuf, GdkPixbuf__sym, __func__, 0), (int)s7_integer(dest_x), (int)s7_integer(dest_y));
  return(lg_false);
}

static s7_pointer lg_gdk_pixbuf_saturate_and_pixelate(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_pixbuf_saturate_and_pixelate "void gdk_pixbuf_saturate_and_pixelate(GdkPixbuf* src, GdkPixbuf* dest, \
gfloat saturation, gboolean pixelate)"
  s7_pointer _p;
  s7_pointer src, dest, saturation, pixelate;
  _p = args;
  src = s7_car(_p); _p = s7_cdr(_p);
  dest = s7_car(_p); _p = s7_cdr(_p);
  saturation = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(saturation)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_saturate_and_pixelate", 3, saturation, "gfloat");
  pixelate = s7_car(_p);
  if (!s7_is_boolean(pixelate)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_saturate_and_pixelate", 4, pixelate, "gboolean");
  gdk_pixbuf_saturate_and_pixelate((GdkPixbuf*)s7_c_pointer_with_type(sc, src, GdkPixbuf__sym, __func__, 0), (GdkPixbuf*)s7_c_pointer_with_type(sc, dest, GdkPixbuf__sym, __func__, 0), (gfloat)s7_real(saturation), (gboolean)lg_boolean(pixelate));
  return(lg_false);
}

static s7_pointer lg_gdk_pixbuf_scale(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_pixbuf_scale "void gdk_pixbuf_scale(GdkPixbuf* src, GdkPixbuf* dest, int dest_x, int dest_y, \
int dest_width, int dest_height, double offset_x, double offset_y, double scale_x, double scale_y, GdkInterpType interp_type)"
  s7_pointer _p;
  s7_pointer src, dest, dest_x, dest_y, dest_width, dest_height, offset_x, offset_y, scale_x, scale_y, interp_type;
  _p = args;
  src = s7_car(_p); _p = s7_cdr(_p);
  dest = s7_car(_p); _p = s7_cdr(_p);
  dest_x = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(dest_x)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_scale", 3, dest_x, "int");
  dest_y = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(dest_y)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_scale", 4, dest_y, "int");
  dest_width = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(dest_width)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_scale", 5, dest_width, "int");
  dest_height = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(dest_height)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_scale", 6, dest_height, "int");
  offset_x = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(offset_x)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_scale", 7, offset_x, "double");
  offset_y = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(offset_y)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_scale", 8, offset_y, "double");
  scale_x = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(scale_x)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_scale", 9, scale_x, "double");
  scale_y = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(scale_y)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_scale", 10, scale_y, "double");
  interp_type = s7_car(_p);
  if (!s7_is_integer(interp_type)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_scale", 11, interp_type, "GdkInterpType");
  gdk_pixbuf_scale((GdkPixbuf*)s7_c_pointer_with_type(sc, src, GdkPixbuf__sym, __func__, 0), (GdkPixbuf*)s7_c_pointer_with_type(sc, dest, GdkPixbuf__sym, __func__, 0), (int)s7_integer(dest_x), (int)s7_integer(dest_y), (int)s7_integer(dest_width), (int)s7_integer(dest_height), (double)s7_real(offset_x), (double)s7_real(offset_y), (double)s7_real(scale_x), (double)s7_real(scale_y), (GdkInterpType)s7_integer(interp_type));
  return(lg_false);
}

static s7_pointer lg_gdk_pixbuf_composite(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_pixbuf_composite "void gdk_pixbuf_composite(GdkPixbuf* src, GdkPixbuf* dest, int dest_x, \
int dest_y, int dest_width, int dest_height, double offset_x, double offset_y, double scale_x, double scale_y, \
GdkInterpType interp_type, int overall_alpha)"
  s7_pointer _p;
  s7_pointer src, dest, dest_x, dest_y, dest_width, dest_height, offset_x, offset_y, scale_x, scale_y, interp_type, overall_alpha;
  _p = args;
  src = s7_car(_p); _p = s7_cdr(_p);
  dest = s7_car(_p); _p = s7_cdr(_p);
  dest_x = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(dest_x)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_composite", 3, dest_x, "int");
  dest_y = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(dest_y)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_composite", 4, dest_y, "int");
  dest_width = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(dest_width)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_composite", 5, dest_width, "int");
  dest_height = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(dest_height)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_composite", 6, dest_height, "int");
  offset_x = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(offset_x)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_composite", 7, offset_x, "double");
  offset_y = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(offset_y)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_composite", 8, offset_y, "double");
  scale_x = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(scale_x)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_composite", 9, scale_x, "double");
  scale_y = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(scale_y)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_composite", 10, scale_y, "double");
  interp_type = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(interp_type)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_composite", 11, interp_type, "GdkInterpType");
  overall_alpha = s7_car(_p);
  if (!s7_is_integer(overall_alpha)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_composite", 12, overall_alpha, "int");
  gdk_pixbuf_composite((GdkPixbuf*)s7_c_pointer_with_type(sc, src, GdkPixbuf__sym, __func__, 0), (GdkPixbuf*)s7_c_pointer_with_type(sc, dest, GdkPixbuf__sym, __func__, 0), (int)s7_integer(dest_x), (int)s7_integer(dest_y), (int)s7_integer(dest_width), (int)s7_integer(dest_height), (double)s7_real(offset_x), (double)s7_real(offset_y), (double)s7_real(scale_x), (double)s7_real(scale_y), (GdkInterpType)s7_integer(interp_type), (int)s7_integer(overall_alpha));
  return(lg_false);
}

static s7_pointer lg_gdk_pixbuf_composite_color(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_pixbuf_composite_color "void gdk_pixbuf_composite_color(GdkPixbuf* src, GdkPixbuf* dest, \
int dest_x, int dest_y, int dest_width, int dest_height, double offset_x, double offset_y, double scale_x, \
double scale_y, GdkInterpType interp_type, int overall_alpha, int check_x, int check_y, int check_size, \
guint32 color1, guint32 color2)"
  s7_pointer _p;
  s7_pointer src, dest, dest_x, dest_y, dest_width, dest_height, offset_x, offset_y, scale_x, scale_y, interp_type, overall_alpha, check_x, check_y, check_size, color1, color2;
  _p = args;
  src = s7_car(_p); _p = s7_cdr(_p);
  dest = s7_car(_p); _p = s7_cdr(_p);
  dest_x = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(dest_x)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_composite_color", 3, dest_x, "int");
  dest_y = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(dest_y)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_composite_color", 4, dest_y, "int");
  dest_width = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(dest_width)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_composite_color", 5, dest_width, "int");
  dest_height = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(dest_height)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_composite_color", 6, dest_height, "int");
  offset_x = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(offset_x)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_composite_color", 7, offset_x, "double");
  offset_y = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(offset_y)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_composite_color", 8, offset_y, "double");
  scale_x = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(scale_x)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_composite_color", 9, scale_x, "double");
  scale_y = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(scale_y)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_composite_color", 10, scale_y, "double");
  interp_type = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(interp_type)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_composite_color", 11, interp_type, "GdkInterpType");
  overall_alpha = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(overall_alpha)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_composite_color", 12, overall_alpha, "int");
  check_x = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(check_x)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_composite_color", 13, check_x, "int");
  check_y = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(check_y)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_composite_color", 14, check_y, "int");
  check_size = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(check_size)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_composite_color", 15, check_size, "int");
  color1 = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(color1)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_composite_color", 16, color1, "guint32");
  color2 = s7_car(_p);
  if (!s7_is_integer(color2)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_composite_color", 17, color2, "guint32");
  gdk_pixbuf_composite_color((GdkPixbuf*)s7_c_pointer_with_type(sc, src, GdkPixbuf__sym, __func__, 0), (GdkPixbuf*)s7_c_pointer_with_type(sc, dest, GdkPixbuf__sym, __func__, 0), (int)s7_integer(dest_x), (int)s7_integer(dest_y), (int)s7_integer(dest_width), (int)s7_integer(dest_height), (double)s7_real(offset_x), (double)s7_real(offset_y), (double)s7_real(scale_x), (double)s7_real(scale_y), (GdkInterpType)s7_integer(interp_type), (int)s7_integer(overall_alpha), (int)s7_integer(check_x), (int)s7_integer(check_y), (int)s7_integer(check_size), (guint32)s7_integer(color1), (guint32)s7_integer(color2));
  return(lg_false);
}

static s7_pointer lg_gdk_pixbuf_scale_simple(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_pixbuf_scale_simple "GdkPixbuf* gdk_pixbuf_scale_simple(GdkPixbuf* src, int dest_width, \
int dest_height, GdkInterpType interp_type)"
  s7_pointer _p;
  s7_pointer src, dest_width, dest_height, interp_type;
  _p = args;
  src = s7_car(_p); _p = s7_cdr(_p);
  dest_width = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(dest_width)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_scale_simple", 2, dest_width, "int");
  dest_height = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(dest_height)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_scale_simple", 3, dest_height, "int");
  interp_type = s7_car(_p);
  if (!s7_is_integer(interp_type)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_scale_simple", 4, interp_type, "GdkInterpType");
  return(lg_make_c_pointer_with_type(sc, GdkPixbuf__sym, gdk_pixbuf_scale_simple((GdkPixbuf*)s7_c_pointer_with_type(sc, src, GdkPixbuf__sym, __func__, 0), (int)s7_integer(dest_width), (int)s7_integer(dest_height), (GdkInterpType)s7_integer(interp_type))));
}

static s7_pointer lg_gdk_pixbuf_composite_color_simple(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_pixbuf_composite_color_simple "GdkPixbuf* gdk_pixbuf_composite_color_simple(GdkPixbuf* src, \
int dest_width, int dest_height, GdkInterpType interp_type, int overall_alpha, int check_size, guint32 color1, \
guint32 color2)"
  s7_pointer _p;
  s7_pointer src, dest_width, dest_height, interp_type, overall_alpha, check_size, color1, color2;
  _p = args;
  src = s7_car(_p); _p = s7_cdr(_p);
  dest_width = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(dest_width)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_composite_color_simple", 2, dest_width, "int");
  dest_height = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(dest_height)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_composite_color_simple", 3, dest_height, "int");
  interp_type = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(interp_type)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_composite_color_simple", 4, interp_type, "GdkInterpType");
  overall_alpha = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(overall_alpha)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_composite_color_simple", 5, overall_alpha, "int");
  check_size = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(check_size)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_composite_color_simple", 6, check_size, "int");
  color1 = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(color1)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_composite_color_simple", 7, color1, "guint32");
  color2 = s7_car(_p);
  if (!s7_is_integer(color2)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_composite_color_simple", 8, color2, "guint32");
  return(lg_make_c_pointer_with_type(sc, GdkPixbuf__sym, gdk_pixbuf_composite_color_simple((GdkPixbuf*)s7_c_pointer_with_type(sc, src, GdkPixbuf__sym, __func__, 0), (int)s7_integer(dest_width), (int)s7_integer(dest_height), (GdkInterpType)s7_integer(interp_type), (int)s7_integer(overall_alpha), (int)s7_integer(check_size), (guint32)s7_integer(color1), (guint32)s7_integer(color2))));
}

static s7_pointer lg_gdk_pixbuf_get_option(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_pixbuf_get_option "gchar* gdk_pixbuf_get_option(GdkPixbuf* pixbuf, gchar* key)"
  s7_pointer _p;
  s7_pointer pixbuf, key;
  _p = args;
  pixbuf = s7_car(_p); _p = s7_cdr(_p);
  key = s7_car(_p);
  if (!s7_is_string(key)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_get_option", 2, key, "gchar*");
  return(s7_make_string(sc, gdk_pixbuf_get_option((GdkPixbuf*)s7_c_pointer_with_type(sc, pixbuf, GdkPixbuf__sym, __func__, 0), (gchar*)s7_string(key))));
}

static s7_pointer lg_gtk_accel_label_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_accel_label_new "GtkWidget* gtk_accel_label_new(gchar* string)"
  s7_pointer string;
  string = s7_car(args);
  if (!s7_is_string(string)) s7_wrong_type_arg_error(sc, "gtk_accel_label_new", 1, string, "gchar*");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_accel_label_new((gchar*)s7_string(string))));
}

static s7_pointer lg_gtk_accel_label_get_accel_width(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_accel_label_get_accel_width "guint gtk_accel_label_get_accel_width(GtkAccelLabel* accel_label)"
  s7_pointer accel_label;
  accel_label = s7_car(args);
  return(s7_make_integer(sc, gtk_accel_label_get_accel_width((GtkAccelLabel*)s7_c_pointer_with_type(sc, accel_label, GtkAccelLabel__sym, __func__, 0))));
}

static s7_pointer lg_gtk_accel_label_refetch(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_accel_label_refetch "gboolean gtk_accel_label_refetch(GtkAccelLabel* accel_label)"
  s7_pointer accel_label;
  accel_label = s7_car(args);
  return(s7_make_boolean(sc, gtk_accel_label_refetch((GtkAccelLabel*)s7_c_pointer_with_type(sc, accel_label, GtkAccelLabel__sym, __func__, 0))));
}

static s7_pointer lg_gtk_adjustment_clamp_page(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_adjustment_clamp_page "void gtk_adjustment_clamp_page(GtkAdjustment* adjustment, gdouble lower, \
gdouble upper)"
  s7_pointer _p;
  s7_pointer adjustment, lower, upper;
  _p = args;
  adjustment = s7_car(_p); _p = s7_cdr(_p);
  lower = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(lower)) s7_wrong_type_arg_error(sc, "gtk_adjustment_clamp_page", 2, lower, "gdouble");
  upper = s7_car(_p);
  if (!s7_is_real(upper)) s7_wrong_type_arg_error(sc, "gtk_adjustment_clamp_page", 3, upper, "gdouble");
  gtk_adjustment_clamp_page((GtkAdjustment*)s7_c_pointer_with_type(sc, adjustment, GtkAdjustment__sym, __func__, 0), (gdouble)s7_real(lower), (gdouble)s7_real(upper));
  return(lg_false);
}

static s7_pointer lg_gtk_adjustment_get_value(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_adjustment_get_value "gdouble gtk_adjustment_get_value(GtkAdjustment* adjustment)"
  s7_pointer adjustment;
  adjustment = s7_car(args);
  return(s7_make_real(sc, gtk_adjustment_get_value((GtkAdjustment*)s7_c_pointer_with_type(sc, adjustment, GtkAdjustment__sym, __func__, 0))));
}

static s7_pointer lg_gtk_adjustment_set_value(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_adjustment_set_value "void gtk_adjustment_set_value(GtkAdjustment* adjustment, gdouble value)"
  s7_pointer _p;
  s7_pointer adjustment, value;
  _p = args;
  adjustment = s7_car(_p); _p = s7_cdr(_p);
  value = s7_car(_p);
  if (!s7_is_real(value)) s7_wrong_type_arg_error(sc, "gtk_adjustment_set_value", 2, value, "gdouble");
  gtk_adjustment_set_value((GtkAdjustment*)s7_c_pointer_with_type(sc, adjustment, GtkAdjustment__sym, __func__, 0), (gdouble)s7_real(value));
  return(lg_false);
}

static s7_pointer lg_gtk_box_set_homogeneous(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_box_set_homogeneous "void gtk_box_set_homogeneous(GtkBox* box, gboolean homogeneous)"
  s7_pointer _p;
  s7_pointer box, homogeneous;
  _p = args;
  box = s7_car(_p); _p = s7_cdr(_p);
  homogeneous = s7_car(_p);
  if (!s7_is_boolean(homogeneous)) s7_wrong_type_arg_error(sc, "gtk_box_set_homogeneous", 2, homogeneous, "gboolean");
  gtk_box_set_homogeneous((GtkBox*)s7_c_pointer_with_type(sc, box, GtkBox__sym, __func__, 0), (gboolean)lg_boolean(homogeneous));
  return(lg_false);
}

static s7_pointer lg_gtk_box_get_homogeneous(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_box_get_homogeneous "gboolean gtk_box_get_homogeneous(GtkBox* box)"
  s7_pointer box;
  box = s7_car(args);
  return(s7_make_boolean(sc, gtk_box_get_homogeneous((GtkBox*)s7_c_pointer_with_type(sc, box, GtkBox__sym, __func__, 0))));
}

static s7_pointer lg_gtk_box_set_spacing(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_box_set_spacing "void gtk_box_set_spacing(GtkBox* box, gint spacing)"
  s7_pointer _p;
  s7_pointer box, spacing;
  _p = args;
  box = s7_car(_p); _p = s7_cdr(_p);
  spacing = s7_car(_p);
  if (!s7_is_integer(spacing)) s7_wrong_type_arg_error(sc, "gtk_box_set_spacing", 2, spacing, "gint");
  gtk_box_set_spacing((GtkBox*)s7_c_pointer_with_type(sc, box, GtkBox__sym, __func__, 0), (gint)s7_integer(spacing));
  return(lg_false);
}

static s7_pointer lg_gtk_box_get_spacing(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_box_get_spacing "gint gtk_box_get_spacing(GtkBox* box)"
  s7_pointer box;
  box = s7_car(args);
  return(s7_make_integer(sc, gtk_box_get_spacing((GtkBox*)s7_c_pointer_with_type(sc, box, GtkBox__sym, __func__, 0))));
}

static s7_pointer lg_gtk_button_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_button_new "GtkWidget* gtk_button_new( void)"
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_button_new()));
}

static s7_pointer lg_gtk_button_new_with_label(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_button_new_with_label "GtkWidget* gtk_button_new_with_label(gchar* label)"
  s7_pointer label;
  label = s7_car(args);
  if (!s7_is_string(label)) s7_wrong_type_arg_error(sc, "gtk_button_new_with_label", 1, label, "gchar*");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_button_new_with_label((gchar*)s7_string(label))));
}

static s7_pointer lg_gtk_button_new_with_mnemonic(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_button_new_with_mnemonic "GtkWidget* gtk_button_new_with_mnemonic(gchar* label)"
  s7_pointer label;
  label = s7_car(args);
  if (!s7_is_string(label)) s7_wrong_type_arg_error(sc, "gtk_button_new_with_mnemonic", 1, label, "gchar*");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_button_new_with_mnemonic((gchar*)s7_string(label))));
}

static s7_pointer lg_gtk_button_set_label(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_button_set_label "void gtk_button_set_label(GtkButton* button, gchar* label)"
  s7_pointer _p;
  s7_pointer button, label;
  _p = args;
  button = s7_car(_p); _p = s7_cdr(_p);
  label = s7_car(_p);
  if (!s7_is_string(label)) s7_wrong_type_arg_error(sc, "gtk_button_set_label", 2, label, "gchar*");
  gtk_button_set_label((GtkButton*)s7_c_pointer_with_type(sc, button, GtkButton__sym, __func__, 0), (gchar*)s7_string(label));
  return(lg_false);
}

static s7_pointer lg_gtk_button_get_label(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_button_get_label "gchar* gtk_button_get_label(GtkButton* button)"
  s7_pointer button;
  button = s7_car(args);
  return(s7_make_string(sc, gtk_button_get_label((GtkButton*)s7_c_pointer_with_type(sc, button, GtkButton__sym, __func__, 0))));
}

static s7_pointer lg_gtk_button_set_use_underline(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_button_set_use_underline "void gtk_button_set_use_underline(GtkButton* button, gboolean use_underline)"
  s7_pointer _p;
  s7_pointer button, use_underline;
  _p = args;
  button = s7_car(_p); _p = s7_cdr(_p);
  use_underline = s7_car(_p);
  if (!s7_is_boolean(use_underline)) s7_wrong_type_arg_error(sc, "gtk_button_set_use_underline", 2, use_underline, "gboolean");
  gtk_button_set_use_underline((GtkButton*)s7_c_pointer_with_type(sc, button, GtkButton__sym, __func__, 0), (gboolean)lg_boolean(use_underline));
  return(lg_false);
}

static s7_pointer lg_gtk_button_get_use_underline(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_button_get_use_underline "gboolean gtk_button_get_use_underline(GtkButton* button)"
  s7_pointer button;
  button = s7_car(args);
  return(s7_make_boolean(sc, gtk_button_get_use_underline((GtkButton*)s7_c_pointer_with_type(sc, button, GtkButton__sym, __func__, 0))));
}

static s7_pointer lg_gtk_calendar_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_calendar_new "GtkWidget* gtk_calendar_new( void)"
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_calendar_new()));
}

static s7_pointer lg_gtk_calendar_clear_marks(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_calendar_clear_marks "void gtk_calendar_clear_marks(GtkCalendar* calendar)"
  s7_pointer calendar;
  calendar = s7_car(args);
  gtk_calendar_clear_marks((GtkCalendar*)s7_c_pointer_with_type(sc, calendar, GtkCalendar__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_cell_editable_start_editing(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_editable_start_editing "void gtk_cell_editable_start_editing(GtkCellEditable* cell_editable, \
GdkEvent* event)"
  s7_pointer _p;
  s7_pointer cell_editable, event;
  _p = args;
  cell_editable = s7_car(_p); _p = s7_cdr(_p);
  event = s7_car(_p);
  gtk_cell_editable_start_editing((GtkCellEditable*)s7_c_pointer_with_type(sc, cell_editable, GtkCellEditable__sym, __func__, 0), (GdkEvent*)s7_c_pointer_with_type(sc, event, GdkEvent__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_cell_editable_editing_done(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_editable_editing_done "void gtk_cell_editable_editing_done(GtkCellEditable* cell_editable)"
  s7_pointer cell_editable;
  cell_editable = s7_car(args);
  gtk_cell_editable_editing_done((GtkCellEditable*)s7_c_pointer_with_type(sc, cell_editable, GtkCellEditable__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_cell_editable_remove_widget(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_editable_remove_widget "void gtk_cell_editable_remove_widget(GtkCellEditable* cell_editable)"
  s7_pointer cell_editable;
  cell_editable = s7_car(args);
  gtk_cell_editable_remove_widget((GtkCellEditable*)s7_c_pointer_with_type(sc, cell_editable, GtkCellEditable__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_cell_renderer_activate(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_renderer_activate "gboolean gtk_cell_renderer_activate(GtkCellRenderer* cell, GdkEvent* event, \
GtkWidget* widget, gchar* path, GdkRectangle* background_area, GdkRectangle* cell_area, GtkCellRendererState flags)"
  s7_pointer _p;
  s7_pointer cell, event, widget, path, background_area, cell_area, flags;
  _p = args;
  cell = s7_car(_p); _p = s7_cdr(_p);
  event = s7_car(_p); _p = s7_cdr(_p);
  widget = s7_car(_p); _p = s7_cdr(_p);
  path = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(path)) s7_wrong_type_arg_error(sc, "gtk_cell_renderer_activate", 4, path, "gchar*");
  background_area = s7_car(_p); _p = s7_cdr(_p);
  cell_area = s7_car(_p); _p = s7_cdr(_p);
  flags = s7_car(_p);
  if (!s7_is_integer(flags)) s7_wrong_type_arg_error(sc, "gtk_cell_renderer_activate", 7, flags, "GtkCellRendererState");
  return(s7_make_boolean(sc, gtk_cell_renderer_activate((GtkCellRenderer*)s7_c_pointer_with_type(sc, cell, GtkCellRenderer__sym, __func__, 0), (GdkEvent*)s7_c_pointer_with_type(sc, event, GdkEvent__sym, __func__, 0), (GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0), (gchar*)s7_string(path), (GdkRectangle*)s7_c_pointer_with_type(sc, background_area, GdkRectangle__sym, __func__, 0), (GdkRectangle*)s7_c_pointer_with_type(sc, cell_area, GdkRectangle__sym, __func__, 0), (GtkCellRendererState)s7_integer(flags))));
}

static s7_pointer lg_gtk_cell_renderer_start_editing(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_renderer_start_editing "GtkCellEditable* gtk_cell_renderer_start_editing(GtkCellRenderer* cell, \
GdkEvent* event, GtkWidget* widget, gchar* path, GdkRectangle* background_area, GdkRectangle* cell_area, \
GtkCellRendererState flags)"
  s7_pointer _p;
  s7_pointer cell, event, widget, path, background_area, cell_area, flags;
  _p = args;
  cell = s7_car(_p); _p = s7_cdr(_p);
  event = s7_car(_p); _p = s7_cdr(_p);
  widget = s7_car(_p); _p = s7_cdr(_p);
  path = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(path)) s7_wrong_type_arg_error(sc, "gtk_cell_renderer_start_editing", 4, path, "gchar*");
  background_area = s7_car(_p); _p = s7_cdr(_p);
  cell_area = s7_car(_p); _p = s7_cdr(_p);
  flags = s7_car(_p);
  if (!s7_is_integer(flags)) s7_wrong_type_arg_error(sc, "gtk_cell_renderer_start_editing", 7, flags, "GtkCellRendererState");
  return(lg_make_c_pointer_with_type(sc, GtkCellEditable__sym, gtk_cell_renderer_start_editing((GtkCellRenderer*)s7_c_pointer_with_type(sc, cell, GtkCellRenderer__sym, __func__, 0), (GdkEvent*)s7_c_pointer_with_type(sc, event, GdkEvent__sym, __func__, 0), (GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0), (gchar*)s7_string(path), (GdkRectangle*)s7_c_pointer_with_type(sc, background_area, GdkRectangle__sym, __func__, 0), (GdkRectangle*)s7_c_pointer_with_type(sc, cell_area, GdkRectangle__sym, __func__, 0), (GtkCellRendererState)s7_integer(flags))));
}

static s7_pointer lg_gtk_cell_renderer_set_fixed_size(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_renderer_set_fixed_size "void gtk_cell_renderer_set_fixed_size(GtkCellRenderer* cell, \
gint width, gint height)"
  s7_pointer _p;
  s7_pointer cell, width, height;
  _p = args;
  cell = s7_car(_p); _p = s7_cdr(_p);
  width = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(width)) s7_wrong_type_arg_error(sc, "gtk_cell_renderer_set_fixed_size", 2, width, "gint");
  height = s7_car(_p);
  if (!s7_is_integer(height)) s7_wrong_type_arg_error(sc, "gtk_cell_renderer_set_fixed_size", 3, height, "gint");
  gtk_cell_renderer_set_fixed_size((GtkCellRenderer*)s7_c_pointer_with_type(sc, cell, GtkCellRenderer__sym, __func__, 0), (gint)s7_integer(width), (gint)s7_integer(height));
  return(lg_false);
}

static s7_pointer lg_gtk_cell_renderer_get_fixed_size(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_renderer_get_fixed_size "void gtk_cell_renderer_get_fixed_size(GtkCellRenderer* cell, \
gint* [width], gint* [height])"
  s7_pointer _p;
  s7_pointer cell;
  gint ref_width;
  gint ref_height;
  _p = args;
  cell = s7_car(_p);
  gtk_cell_renderer_get_fixed_size((GtkCellRenderer*)s7_c_pointer_with_type(sc, cell, GtkCellRenderer__sym, __func__, 0), &ref_width, &ref_height);
    return(s7_list(sc, 2, s7_make_integer(sc, ref_width), s7_make_integer(sc, ref_height)));
}

static s7_pointer lg_gtk_cell_renderer_pixbuf_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_renderer_pixbuf_new "GtkCellRenderer* gtk_cell_renderer_pixbuf_new( void)"
  return(lg_make_c_pointer_with_type(sc, GtkCellRenderer__sym, gtk_cell_renderer_pixbuf_new()));
}

static s7_pointer lg_gtk_cell_renderer_text_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_renderer_text_new "GtkCellRenderer* gtk_cell_renderer_text_new( void)"
  return(lg_make_c_pointer_with_type(sc, GtkCellRenderer__sym, gtk_cell_renderer_text_new()));
}

static s7_pointer lg_gtk_cell_renderer_text_set_fixed_height_from_font(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_renderer_text_set_fixed_height_from_font "void gtk_cell_renderer_text_set_fixed_height_from_font(GtkCellRendererText* renderer, \
gint number_of_rows)"
  s7_pointer _p;
  s7_pointer renderer, number_of_rows;
  _p = args;
  renderer = s7_car(_p); _p = s7_cdr(_p);
  number_of_rows = s7_car(_p);
  if (!s7_is_integer(number_of_rows)) s7_wrong_type_arg_error(sc, "gtk_cell_renderer_text_set_fixed_height_from_font", 2, number_of_rows, "gint");
  gtk_cell_renderer_text_set_fixed_height_from_font((GtkCellRendererText*)s7_c_pointer_with_type(sc, renderer, GtkCellRendererText__sym, __func__, 0), (gint)s7_integer(number_of_rows));
  return(lg_false);
}

static s7_pointer lg_gtk_cell_renderer_toggle_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_renderer_toggle_new "GtkCellRenderer* gtk_cell_renderer_toggle_new( void)"
  return(lg_make_c_pointer_with_type(sc, GtkCellRenderer__sym, gtk_cell_renderer_toggle_new()));
}

static s7_pointer lg_gtk_cell_renderer_toggle_get_radio(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_renderer_toggle_get_radio "gboolean gtk_cell_renderer_toggle_get_radio(GtkCellRendererToggle* toggle)"
  s7_pointer toggle;
  toggle = s7_car(args);
  return(s7_make_boolean(sc, gtk_cell_renderer_toggle_get_radio((GtkCellRendererToggle*)s7_c_pointer_with_type(sc, toggle, GtkCellRendererToggle__sym, __func__, 0))));
}

static s7_pointer lg_gtk_cell_renderer_toggle_set_radio(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_renderer_toggle_set_radio "void gtk_cell_renderer_toggle_set_radio(GtkCellRendererToggle* toggle, \
gboolean radio)"
  s7_pointer _p;
  s7_pointer toggle, radio;
  _p = args;
  toggle = s7_car(_p); _p = s7_cdr(_p);
  radio = s7_car(_p);
  if (!s7_is_boolean(radio)) s7_wrong_type_arg_error(sc, "gtk_cell_renderer_toggle_set_radio", 2, radio, "gboolean");
  gtk_cell_renderer_toggle_set_radio((GtkCellRendererToggle*)s7_c_pointer_with_type(sc, toggle, GtkCellRendererToggle__sym, __func__, 0), (gboolean)lg_boolean(radio));
  return(lg_false);
}

static s7_pointer lg_gtk_cell_renderer_toggle_get_active(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_renderer_toggle_get_active "gboolean gtk_cell_renderer_toggle_get_active(GtkCellRendererToggle* toggle)"
  s7_pointer toggle;
  toggle = s7_car(args);
  return(s7_make_boolean(sc, gtk_cell_renderer_toggle_get_active((GtkCellRendererToggle*)s7_c_pointer_with_type(sc, toggle, GtkCellRendererToggle__sym, __func__, 0))));
}

static s7_pointer lg_gtk_cell_renderer_toggle_set_active(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_renderer_toggle_set_active "void gtk_cell_renderer_toggle_set_active(GtkCellRendererToggle* toggle, \
gboolean setting)"
  s7_pointer _p;
  s7_pointer toggle, setting;
  _p = args;
  toggle = s7_car(_p); _p = s7_cdr(_p);
  setting = s7_car(_p);
  if (!s7_is_boolean(setting)) s7_wrong_type_arg_error(sc, "gtk_cell_renderer_toggle_set_active", 2, setting, "gboolean");
  gtk_cell_renderer_toggle_set_active((GtkCellRendererToggle*)s7_c_pointer_with_type(sc, toggle, GtkCellRendererToggle__sym, __func__, 0), (gboolean)lg_boolean(setting));
  return(lg_false);
}

static s7_pointer lg_gtk_check_button_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_check_button_new "GtkWidget* gtk_check_button_new( void)"
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_check_button_new()));
}

static s7_pointer lg_gtk_check_button_new_with_label(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_check_button_new_with_label "GtkWidget* gtk_check_button_new_with_label(gchar* label)"
  s7_pointer label;
  label = s7_car(args);
  if (!s7_is_string(label)) s7_wrong_type_arg_error(sc, "gtk_check_button_new_with_label", 1, label, "gchar*");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_check_button_new_with_label((gchar*)s7_string(label))));
}

static s7_pointer lg_gtk_check_button_new_with_mnemonic(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_check_button_new_with_mnemonic "GtkWidget* gtk_check_button_new_with_mnemonic(gchar* label)"
  s7_pointer label;
  label = s7_car(args);
  if (!s7_is_string(label)) s7_wrong_type_arg_error(sc, "gtk_check_button_new_with_mnemonic", 1, label, "gchar*");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_check_button_new_with_mnemonic((gchar*)s7_string(label))));
}

static s7_pointer lg_gtk_dialog_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_dialog_new "GtkWidget* gtk_dialog_new( void)"
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_dialog_new()));
}

static s7_pointer lg_gtk_dialog_add_action_widget(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_dialog_add_action_widget "void gtk_dialog_add_action_widget(GtkDialog* dialog, GtkWidget* child, \
gint response_id)"
  s7_pointer _p;
  s7_pointer dialog, child, response_id;
  _p = args;
  dialog = s7_car(_p); _p = s7_cdr(_p);
  child = s7_car(_p); _p = s7_cdr(_p);
  response_id = s7_car(_p);
  if (!s7_is_integer(response_id)) s7_wrong_type_arg_error(sc, "gtk_dialog_add_action_widget", 3, response_id, "gint");
  gtk_dialog_add_action_widget((GtkDialog*)s7_c_pointer_with_type(sc, dialog, GtkDialog__sym, __func__, 0), (GtkWidget*)s7_c_pointer_with_type(sc, child, GtkWidget__sym, __func__, 0), (gint)s7_integer(response_id));
  return(lg_false);
}

static s7_pointer lg_gtk_dialog_add_button(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_dialog_add_button "GtkWidget* gtk_dialog_add_button(GtkDialog* dialog, gchar* button_text, \
gint response_id)"
  s7_pointer _p;
  s7_pointer dialog, button_text, response_id;
  _p = args;
  dialog = s7_car(_p); _p = s7_cdr(_p);
  button_text = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(button_text)) s7_wrong_type_arg_error(sc, "gtk_dialog_add_button", 2, button_text, "gchar*");
  response_id = s7_car(_p);
  if (!s7_is_integer(response_id)) s7_wrong_type_arg_error(sc, "gtk_dialog_add_button", 3, response_id, "gint");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_dialog_add_button((GtkDialog*)s7_c_pointer_with_type(sc, dialog, GtkDialog__sym, __func__, 0), (gchar*)s7_string(button_text), (gint)s7_integer(response_id))));
}

static s7_pointer lg_gtk_dialog_add_buttons(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_dialog_add_buttons "void gtk_dialog_add_buttons(GtkDialog* dialog, etc buttons)"
  s7_pointer _p;
  s7_pointer dialog, buttons;
  _p = args;
  dialog = s7_car(_p); _p = s7_cdr(_p);
  buttons = s7_car(_p);
  if (!lg_is_list(buttons)) s7_wrong_type_arg_error(sc, "gtk_dialog_add_buttons", 2, buttons, "etc");
  {
    int etc_len = 0;
    GtkDialog* p_arg0;
    if (s7_is_list(sc, buttons)) etc_len = s7_list_length(sc, buttons);
    if (etc_len < 2) s7_out_of_range_error(sc, "gtk_dialog_add_buttons", 1, buttons, "... list must have at least 2 entries");
    if (etc_len > 10) s7_out_of_range_error(sc, "gtk_dialog_add_buttons", 1, buttons, "... list too long (max len: 10)");
    if ((etc_len % 2) != 0) s7_out_of_range_error(sc, "gtk_dialog_add_buttons", 1, buttons, "... list len must be multiple of 2");
    p_arg0 = (GtkDialog*)s7_c_pointer_with_type(sc, dialog, GtkDialog__sym, __func__, 0);
    switch (etc_len)
      {
        case 2: gtk_dialog_add_buttons(p_arg0, s7_string(s7_list_ref(sc, buttons, 0)), s7_integer(s7_list_ref(sc, buttons, 1)), NULL); break;
        case 4: gtk_dialog_add_buttons(p_arg0, s7_string(s7_list_ref(sc, buttons, 0)), s7_integer(s7_list_ref(sc, buttons, 1)), s7_string(s7_list_ref(sc, buttons, 2)), s7_integer(s7_list_ref(sc, buttons, 3)), NULL); break;
        case 6: gtk_dialog_add_buttons(p_arg0, s7_string(s7_list_ref(sc, buttons, 0)), s7_integer(s7_list_ref(sc, buttons, 1)), s7_string(s7_list_ref(sc, buttons, 2)), s7_integer(s7_list_ref(sc, buttons, 3)), s7_string(s7_list_ref(sc, buttons, 4)), s7_integer(s7_list_ref(sc, buttons, 5)), NULL); break;
        case 8: gtk_dialog_add_buttons(p_arg0, s7_string(s7_list_ref(sc, buttons, 0)), s7_integer(s7_list_ref(sc, buttons, 1)), s7_string(s7_list_ref(sc, buttons, 2)), s7_integer(s7_list_ref(sc, buttons, 3)), s7_string(s7_list_ref(sc, buttons, 4)), s7_integer(s7_list_ref(sc, buttons, 5)), s7_string(s7_list_ref(sc, buttons, 6)), s7_integer(s7_list_ref(sc, buttons, 7)), NULL); break;
        case 10: gtk_dialog_add_buttons(p_arg0, s7_string(s7_list_ref(sc, buttons, 0)), s7_integer(s7_list_ref(sc, buttons, 1)), s7_string(s7_list_ref(sc, buttons, 2)), s7_integer(s7_list_ref(sc, buttons, 3)), s7_string(s7_list_ref(sc, buttons, 4)), s7_integer(s7_list_ref(sc, buttons, 5)), s7_string(s7_list_ref(sc, buttons, 6)), s7_integer(s7_list_ref(sc, buttons, 7)), s7_string(s7_list_ref(sc, buttons, 8)), s7_integer(s7_list_ref(sc, buttons, 9)), NULL); break;
      }
    return(lg_false);
  }
}

static s7_pointer lg_gtk_dialog_set_response_sensitive(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_dialog_set_response_sensitive "void gtk_dialog_set_response_sensitive(GtkDialog* dialog, \
gint response_id, gboolean setting)"
  s7_pointer _p;
  s7_pointer dialog, response_id, setting;
  _p = args;
  dialog = s7_car(_p); _p = s7_cdr(_p);
  response_id = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(response_id)) s7_wrong_type_arg_error(sc, "gtk_dialog_set_response_sensitive", 2, response_id, "gint");
  setting = s7_car(_p);
  if (!s7_is_boolean(setting)) s7_wrong_type_arg_error(sc, "gtk_dialog_set_response_sensitive", 3, setting, "gboolean");
  gtk_dialog_set_response_sensitive((GtkDialog*)s7_c_pointer_with_type(sc, dialog, GtkDialog__sym, __func__, 0), (gint)s7_integer(response_id), (gboolean)lg_boolean(setting));
  return(lg_false);
}

static s7_pointer lg_gtk_dialog_set_default_response(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_dialog_set_default_response "void gtk_dialog_set_default_response(GtkDialog* dialog, \
gint response_id)"
  s7_pointer _p;
  s7_pointer dialog, response_id;
  _p = args;
  dialog = s7_car(_p); _p = s7_cdr(_p);
  response_id = s7_car(_p);
  if (!s7_is_integer(response_id)) s7_wrong_type_arg_error(sc, "gtk_dialog_set_default_response", 2, response_id, "gint");
  gtk_dialog_set_default_response((GtkDialog*)s7_c_pointer_with_type(sc, dialog, GtkDialog__sym, __func__, 0), (gint)s7_integer(response_id));
  return(lg_false);
}

static s7_pointer lg_gtk_dialog_response(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_dialog_response "void gtk_dialog_response(GtkDialog* dialog, gint response_id)"
  s7_pointer _p;
  s7_pointer dialog, response_id;
  _p = args;
  dialog = s7_car(_p); _p = s7_cdr(_p);
  response_id = s7_car(_p);
  if (!s7_is_integer(response_id)) s7_wrong_type_arg_error(sc, "gtk_dialog_response", 2, response_id, "gint");
  gtk_dialog_response((GtkDialog*)s7_c_pointer_with_type(sc, dialog, GtkDialog__sym, __func__, 0), (gint)s7_integer(response_id));
  return(lg_false);
}

static s7_pointer lg_gtk_drawing_area_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_drawing_area_new "GtkWidget* gtk_drawing_area_new( void)"
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_drawing_area_new()));
}

static s7_pointer lg_gtk_editable_select_region(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_editable_select_region "void gtk_editable_select_region(GtkEditable* editable, int start, \
int end)"
  s7_pointer _p;
  s7_pointer editable, start, end;
  _p = args;
  editable = s7_car(_p); _p = s7_cdr(_p);
  start = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(start)) s7_wrong_type_arg_error(sc, "gtk_editable_select_region", 2, start, "int");
  end = s7_car(_p);
  if (!s7_is_integer(end)) s7_wrong_type_arg_error(sc, "gtk_editable_select_region", 3, end, "int");
  gtk_editable_select_region((GtkEditable*)s7_c_pointer_with_type(sc, editable, GtkEditable__sym, __func__, 0), (int)s7_integer(start), (int)s7_integer(end));
  return(lg_false);
}

static s7_pointer lg_gtk_editable_get_selection_bounds(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_editable_get_selection_bounds "gboolean gtk_editable_get_selection_bounds(GtkEditable* editable, \
int* [start], int* [end])"
  s7_pointer _p;
  s7_pointer editable;
  int ref_start;
  int ref_end;
  _p = args;
  editable = s7_car(_p);
  {
    s7_pointer res_ult;
    res_ult = s7_make_boolean(sc, gtk_editable_get_selection_bounds((GtkEditable*)s7_c_pointer_with_type(sc, editable, GtkEditable__sym, __func__, 0), &ref_start, &ref_end));
      return(s7_list(sc, 3, res_ult, s7_make_integer(sc, ref_start), s7_make_integer(sc, ref_end)));
   }
}

static s7_pointer lg_gtk_editable_insert_text(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_editable_insert_text "void gtk_editable_insert_text(GtkEditable* editable, gchar* new_text, \
int new_text_length, int* [position])"
  s7_pointer _p;
  s7_pointer editable, new_text, new_text_length;
  int ref_position;
  _p = args;
  editable = s7_car(_p); _p = s7_cdr(_p);
  new_text = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(new_text)) s7_wrong_type_arg_error(sc, "gtk_editable_insert_text", 2, new_text, "gchar*");
  new_text_length = s7_car(_p);
  if (!s7_is_integer(new_text_length)) s7_wrong_type_arg_error(sc, "gtk_editable_insert_text", 3, new_text_length, "int");
  gtk_editable_insert_text((GtkEditable*)s7_c_pointer_with_type(sc, editable, GtkEditable__sym, __func__, 0), (gchar*)s7_string(new_text), (int)s7_integer(new_text_length), &ref_position);
    return(s7_list(sc, 1, s7_make_integer(sc, ref_position)));
}

static s7_pointer lg_gtk_editable_delete_text(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_editable_delete_text "void gtk_editable_delete_text(GtkEditable* editable, int start_pos, \
int end_pos)"
  s7_pointer _p;
  s7_pointer editable, start_pos, end_pos;
  _p = args;
  editable = s7_car(_p); _p = s7_cdr(_p);
  start_pos = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(start_pos)) s7_wrong_type_arg_error(sc, "gtk_editable_delete_text", 2, start_pos, "int");
  end_pos = s7_car(_p);
  if (!s7_is_integer(end_pos)) s7_wrong_type_arg_error(sc, "gtk_editable_delete_text", 3, end_pos, "int");
  gtk_editable_delete_text((GtkEditable*)s7_c_pointer_with_type(sc, editable, GtkEditable__sym, __func__, 0), (int)s7_integer(start_pos), (int)s7_integer(end_pos));
  return(lg_false);
}

static s7_pointer lg_gtk_editable_get_chars(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_editable_get_chars "gchar* gtk_editable_get_chars(GtkEditable* editable, int start_pos, \
int end_pos)"
  s7_pointer _p;
  s7_pointer editable, start_pos, end_pos;
  _p = args;
  editable = s7_car(_p); _p = s7_cdr(_p);
  start_pos = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(start_pos)) s7_wrong_type_arg_error(sc, "gtk_editable_get_chars", 2, start_pos, "int");
  end_pos = s7_car(_p);
  if (!s7_is_integer(end_pos)) s7_wrong_type_arg_error(sc, "gtk_editable_get_chars", 3, end_pos, "int");
  {
    gchar* res_ult;
    s7_pointer rtn;
    res_ult = gtk_editable_get_chars((GtkEditable*)s7_c_pointer_with_type(sc, editable, GtkEditable__sym, __func__, 0), (int)s7_integer(start_pos), (int)s7_integer(end_pos));
    rtn = s7_make_string(sc, res_ult);
    g_free(res_ult);
    return(rtn);
  }
}

static s7_pointer lg_gtk_editable_delete_selection(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_editable_delete_selection "void gtk_editable_delete_selection(GtkEditable* editable)"
  s7_pointer editable;
  editable = s7_car(args);
  gtk_editable_delete_selection((GtkEditable*)s7_c_pointer_with_type(sc, editable, GtkEditable__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_editable_set_position(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_editable_set_position "void gtk_editable_set_position(GtkEditable* editable, gint position)"
  s7_pointer _p;
  s7_pointer editable, position;
  _p = args;
  editable = s7_car(_p); _p = s7_cdr(_p);
  position = s7_car(_p);
  if (!s7_is_integer(position)) s7_wrong_type_arg_error(sc, "gtk_editable_set_position", 2, position, "gint");
  gtk_editable_set_position((GtkEditable*)s7_c_pointer_with_type(sc, editable, GtkEditable__sym, __func__, 0), (gint)s7_integer(position));
  return(lg_false);
}

static s7_pointer lg_gtk_editable_get_position(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_editable_get_position "gint gtk_editable_get_position(GtkEditable* editable)"
  s7_pointer editable;
  editable = s7_car(args);
  return(s7_make_integer(sc, gtk_editable_get_position((GtkEditable*)s7_c_pointer_with_type(sc, editable, GtkEditable__sym, __func__, 0))));
}

static s7_pointer lg_gtk_editable_set_editable(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_editable_set_editable "void gtk_editable_set_editable(GtkEditable* editable, gboolean is_editable)"
  s7_pointer _p;
  s7_pointer editable, is_editable;
  _p = args;
  editable = s7_car(_p); _p = s7_cdr(_p);
  is_editable = s7_car(_p);
  if (!s7_is_boolean(is_editable)) s7_wrong_type_arg_error(sc, "gtk_editable_set_editable", 2, is_editable, "gboolean");
  gtk_editable_set_editable((GtkEditable*)s7_c_pointer_with_type(sc, editable, GtkEditable__sym, __func__, 0), (gboolean)lg_boolean(is_editable));
  return(lg_false);
}

static s7_pointer lg_gtk_editable_get_editable(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_editable_get_editable "gboolean gtk_editable_get_editable(GtkEditable* editable)"
  s7_pointer editable;
  editable = s7_car(args);
  return(s7_make_boolean(sc, gtk_editable_get_editable((GtkEditable*)s7_c_pointer_with_type(sc, editable, GtkEditable__sym, __func__, 0))));
}

static s7_pointer lg_gtk_entry_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_new "GtkWidget* gtk_entry_new( void)"
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_entry_new()));
}

static s7_pointer lg_gtk_entry_set_visibility(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_set_visibility "void gtk_entry_set_visibility(GtkEntry* entry, gboolean visible)"
  s7_pointer _p;
  s7_pointer entry, visible;
  _p = args;
  entry = s7_car(_p); _p = s7_cdr(_p);
  visible = s7_car(_p);
  if (!s7_is_boolean(visible)) s7_wrong_type_arg_error(sc, "gtk_entry_set_visibility", 2, visible, "gboolean");
  gtk_entry_set_visibility((GtkEntry*)s7_c_pointer_with_type(sc, entry, GtkEntry__sym, __func__, 0), (gboolean)lg_boolean(visible));
  return(lg_false);
}

static s7_pointer lg_gtk_entry_get_visibility(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_get_visibility "gboolean gtk_entry_get_visibility(GtkEntry* entry)"
  s7_pointer entry;
  entry = s7_car(args);
  return(s7_make_boolean(sc, gtk_entry_get_visibility((GtkEntry*)s7_c_pointer_with_type(sc, entry, GtkEntry__sym, __func__, 0))));
}

static s7_pointer lg_gtk_entry_set_invisible_char(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_set_invisible_char "void gtk_entry_set_invisible_char(GtkEntry* entry, gunichar ch)"
  s7_pointer _p;
  s7_pointer entry, ch;
  _p = args;
  entry = s7_car(_p); _p = s7_cdr(_p);
  ch = s7_car(_p);
  if (!s7_is_integer(ch)) s7_wrong_type_arg_error(sc, "gtk_entry_set_invisible_char", 2, ch, "gunichar");
  gtk_entry_set_invisible_char((GtkEntry*)s7_c_pointer_with_type(sc, entry, GtkEntry__sym, __func__, 0), (gunichar)s7_integer(ch));
  return(lg_false);
}

static s7_pointer lg_gtk_entry_get_invisible_char(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_get_invisible_char "gunichar gtk_entry_get_invisible_char(GtkEntry* entry)"
  s7_pointer entry;
  entry = s7_car(args);
  return(s7_make_integer(sc, gtk_entry_get_invisible_char((GtkEntry*)s7_c_pointer_with_type(sc, entry, GtkEntry__sym, __func__, 0))));
}

static s7_pointer lg_gtk_entry_set_has_frame(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_set_has_frame "void gtk_entry_set_has_frame(GtkEntry* entry, gboolean setting)"
  s7_pointer _p;
  s7_pointer entry, setting;
  _p = args;
  entry = s7_car(_p); _p = s7_cdr(_p);
  setting = s7_car(_p);
  if (!s7_is_boolean(setting)) s7_wrong_type_arg_error(sc, "gtk_entry_set_has_frame", 2, setting, "gboolean");
  gtk_entry_set_has_frame((GtkEntry*)s7_c_pointer_with_type(sc, entry, GtkEntry__sym, __func__, 0), (gboolean)lg_boolean(setting));
  return(lg_false);
}

static s7_pointer lg_gtk_entry_get_has_frame(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_get_has_frame "gboolean gtk_entry_get_has_frame(GtkEntry* entry)"
  s7_pointer entry;
  entry = s7_car(args);
  return(s7_make_boolean(sc, gtk_entry_get_has_frame((GtkEntry*)s7_c_pointer_with_type(sc, entry, GtkEntry__sym, __func__, 0))));
}

static s7_pointer lg_gtk_entry_set_max_length(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_set_max_length "void gtk_entry_set_max_length(GtkEntry* entry, gint max)"
  s7_pointer _p;
  s7_pointer entry, max;
  _p = args;
  entry = s7_car(_p); _p = s7_cdr(_p);
  max = s7_car(_p);
  if (!s7_is_integer(max)) s7_wrong_type_arg_error(sc, "gtk_entry_set_max_length", 2, max, "gint");
  gtk_entry_set_max_length((GtkEntry*)s7_c_pointer_with_type(sc, entry, GtkEntry__sym, __func__, 0), (gint)s7_integer(max));
  return(lg_false);
}

static s7_pointer lg_gtk_entry_get_max_length(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_get_max_length "gint gtk_entry_get_max_length(GtkEntry* entry)"
  s7_pointer entry;
  entry = s7_car(args);
  return(s7_make_integer(sc, gtk_entry_get_max_length((GtkEntry*)s7_c_pointer_with_type(sc, entry, GtkEntry__sym, __func__, 0))));
}

static s7_pointer lg_gtk_entry_set_activates_default(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_set_activates_default "void gtk_entry_set_activates_default(GtkEntry* entry, gboolean setting)"
  s7_pointer _p;
  s7_pointer entry, setting;
  _p = args;
  entry = s7_car(_p); _p = s7_cdr(_p);
  setting = s7_car(_p);
  if (!s7_is_boolean(setting)) s7_wrong_type_arg_error(sc, "gtk_entry_set_activates_default", 2, setting, "gboolean");
  gtk_entry_set_activates_default((GtkEntry*)s7_c_pointer_with_type(sc, entry, GtkEntry__sym, __func__, 0), (gboolean)lg_boolean(setting));
  return(lg_false);
}

static s7_pointer lg_gtk_entry_get_activates_default(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_get_activates_default "gboolean gtk_entry_get_activates_default(GtkEntry* entry)"
  s7_pointer entry;
  entry = s7_car(args);
  return(s7_make_boolean(sc, gtk_entry_get_activates_default((GtkEntry*)s7_c_pointer_with_type(sc, entry, GtkEntry__sym, __func__, 0))));
}

static s7_pointer lg_gtk_fixed_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_fixed_new "GtkWidget* gtk_fixed_new( void)"
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_fixed_new()));
}

static s7_pointer lg_gtk_frame_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_frame_new "GtkWidget* gtk_frame_new(gchar* label)"
  s7_pointer label;
  label = s7_car(args);
  if (!s7_is_string(label)) s7_wrong_type_arg_error(sc, "gtk_frame_new", 1, label, "gchar*");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_frame_new((gchar*)s7_string(label))));
}

static s7_pointer lg_gtk_frame_set_label(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_frame_set_label "void gtk_frame_set_label(GtkFrame* frame, gchar* label)"
  s7_pointer _p;
  s7_pointer frame, label;
  _p = args;
  frame = s7_car(_p); _p = s7_cdr(_p);
  label = s7_car(_p);
  if (!s7_is_string(label)) s7_wrong_type_arg_error(sc, "gtk_frame_set_label", 2, label, "gchar*");
  gtk_frame_set_label((GtkFrame*)s7_c_pointer_with_type(sc, frame, GtkFrame__sym, __func__, 0), (gchar*)s7_string(label));
  return(lg_false);
}

static s7_pointer lg_gtk_frame_get_label(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_frame_get_label "gchar* gtk_frame_get_label(GtkFrame* frame)"
  s7_pointer frame;
  frame = s7_car(args);
  return(s7_make_string(sc, gtk_frame_get_label((GtkFrame*)s7_c_pointer_with_type(sc, frame, GtkFrame__sym, __func__, 0))));
}

static s7_pointer lg_gtk_frame_set_label_widget(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_frame_set_label_widget "void gtk_frame_set_label_widget(GtkFrame* frame, GtkWidget* label_widget)"
  s7_pointer _p;
  s7_pointer frame, label_widget;
  _p = args;
  frame = s7_car(_p); _p = s7_cdr(_p);
  label_widget = s7_car(_p);
  gtk_frame_set_label_widget((GtkFrame*)s7_c_pointer_with_type(sc, frame, GtkFrame__sym, __func__, 0), (GtkWidget*)s7_c_pointer_with_type(sc, label_widget, GtkWidget__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_frame_get_label_widget(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_frame_get_label_widget "GtkWidget* gtk_frame_get_label_widget(GtkFrame* frame)"
  s7_pointer frame;
  frame = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_frame_get_label_widget((GtkFrame*)s7_c_pointer_with_type(sc, frame, GtkFrame__sym, __func__, 0))));
}

static s7_pointer lg_gtk_image_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_image_new "GtkWidget* gtk_image_new( void)"
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_image_new()));
}

static s7_pointer lg_gtk_image_new_from_file(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_image_new_from_file "GtkWidget* gtk_image_new_from_file(gchar* filename)"
  s7_pointer filename;
  filename = s7_car(args);
  if (!s7_is_string(filename)) s7_wrong_type_arg_error(sc, "gtk_image_new_from_file", 1, filename, "gchar*");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_image_new_from_file((gchar*)s7_string(filename))));
}

static s7_pointer lg_gtk_image_new_from_pixbuf(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_image_new_from_pixbuf "GtkWidget* gtk_image_new_from_pixbuf(GdkPixbuf* pixbuf)"
  s7_pointer pixbuf;
  pixbuf = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_image_new_from_pixbuf((GdkPixbuf*)s7_c_pointer_with_type(sc, pixbuf, GdkPixbuf__sym, __func__, 0))));
}

static s7_pointer lg_gtk_image_set_from_file(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_image_set_from_file "void gtk_image_set_from_file(GtkImage* image, gchar* filename)"
  s7_pointer _p;
  s7_pointer image, filename;
  _p = args;
  image = s7_car(_p); _p = s7_cdr(_p);
  filename = s7_car(_p);
  if (!s7_is_string(filename)) s7_wrong_type_arg_error(sc, "gtk_image_set_from_file", 2, filename, "gchar*");
  gtk_image_set_from_file((GtkImage*)s7_c_pointer_with_type(sc, image, GtkImage__sym, __func__, 0), (gchar*)s7_string(filename));
  return(lg_false);
}

static s7_pointer lg_gtk_image_set_from_pixbuf(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_image_set_from_pixbuf "void gtk_image_set_from_pixbuf(GtkImage* image, GdkPixbuf* pixbuf)"
  s7_pointer _p;
  s7_pointer image, pixbuf;
  _p = args;
  image = s7_car(_p); _p = s7_cdr(_p);
  pixbuf = s7_car(_p);
  gtk_image_set_from_pixbuf((GtkImage*)s7_c_pointer_with_type(sc, image, GtkImage__sym, __func__, 0), (GdkPixbuf*)s7_c_pointer_with_type(sc, pixbuf, GdkPixbuf__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_image_get_storage_type(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_image_get_storage_type "GtkImageType gtk_image_get_storage_type(GtkImage* image)"
  s7_pointer image;
  image = s7_car(args);
  return(s7_make_integer(sc, gtk_image_get_storage_type((GtkImage*)s7_c_pointer_with_type(sc, image, GtkImage__sym, __func__, 0))));
}

static s7_pointer lg_gtk_im_context_get_preedit_string(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_im_context_get_preedit_string "void gtk_im_context_get_preedit_string(GtkIMContext* context, \
gchar** [str], PangoAttrList** [attrs], gint* [cursor_pos])"
  s7_pointer _p;
  s7_pointer context;
  gchar* ref_str = NULL;
  PangoAttrList* ref_attrs = NULL;
  gint ref_cursor_pos;
  _p = args;
  context = s7_car(_p);
  gtk_im_context_get_preedit_string((GtkIMContext*)s7_c_pointer_with_type(sc, context, GtkIMContext__sym, __func__, 0), &ref_str, &ref_attrs, &ref_cursor_pos);
    return(s7_list(sc, 3, s7_make_string(sc, ref_str), s7_make_c_pointer(sc, ref_attrs), s7_make_integer(sc, ref_cursor_pos)));
}

static s7_pointer lg_gtk_im_context_focus_in(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_im_context_focus_in "void gtk_im_context_focus_in(GtkIMContext* context)"
  s7_pointer context;
  context = s7_car(args);
  gtk_im_context_focus_in((GtkIMContext*)s7_c_pointer_with_type(sc, context, GtkIMContext__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_im_context_focus_out(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_im_context_focus_out "void gtk_im_context_focus_out(GtkIMContext* context)"
  s7_pointer context;
  context = s7_car(args);
  gtk_im_context_focus_out((GtkIMContext*)s7_c_pointer_with_type(sc, context, GtkIMContext__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_im_context_reset(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_im_context_reset "void gtk_im_context_reset(GtkIMContext* context)"
  s7_pointer context;
  context = s7_car(args);
  gtk_im_context_reset((GtkIMContext*)s7_c_pointer_with_type(sc, context, GtkIMContext__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_im_context_set_cursor_location(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_im_context_set_cursor_location "void gtk_im_context_set_cursor_location(GtkIMContext* context, \
GdkRectangle* area)"
  s7_pointer _p;
  s7_pointer context, area;
  _p = args;
  context = s7_car(_p); _p = s7_cdr(_p);
  area = s7_car(_p);
  gtk_im_context_set_cursor_location((GtkIMContext*)s7_c_pointer_with_type(sc, context, GtkIMContext__sym, __func__, 0), (GdkRectangle*)s7_c_pointer_with_type(sc, area, GdkRectangle__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_im_context_set_use_preedit(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_im_context_set_use_preedit "void gtk_im_context_set_use_preedit(GtkIMContext* context, \
gboolean use_preedit)"
  s7_pointer _p;
  s7_pointer context, use_preedit;
  _p = args;
  context = s7_car(_p); _p = s7_cdr(_p);
  use_preedit = s7_car(_p);
  if (!s7_is_boolean(use_preedit)) s7_wrong_type_arg_error(sc, "gtk_im_context_set_use_preedit", 2, use_preedit, "gboolean");
  gtk_im_context_set_use_preedit((GtkIMContext*)s7_c_pointer_with_type(sc, context, GtkIMContext__sym, __func__, 0), (gboolean)lg_boolean(use_preedit));
  return(lg_false);
}

static s7_pointer lg_gtk_im_context_set_surrounding(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_im_context_set_surrounding "void gtk_im_context_set_surrounding(GtkIMContext* context, \
gchar* text, gint len, gint cursor_index)"
  s7_pointer _p;
  s7_pointer context, text, len, cursor_index;
  _p = args;
  context = s7_car(_p); _p = s7_cdr(_p);
  text = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(text)) s7_wrong_type_arg_error(sc, "gtk_im_context_set_surrounding", 2, text, "gchar*");
  len = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(len)) s7_wrong_type_arg_error(sc, "gtk_im_context_set_surrounding", 3, len, "gint");
  cursor_index = s7_car(_p);
  if (!s7_is_integer(cursor_index)) s7_wrong_type_arg_error(sc, "gtk_im_context_set_surrounding", 4, cursor_index, "gint");
  gtk_im_context_set_surrounding((GtkIMContext*)s7_c_pointer_with_type(sc, context, GtkIMContext__sym, __func__, 0), (gchar*)s7_string(text), (gint)s7_integer(len), (gint)s7_integer(cursor_index));
  return(lg_false);
}

static s7_pointer lg_gtk_im_context_get_surrounding(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_im_context_get_surrounding "gboolean gtk_im_context_get_surrounding(GtkIMContext* context, \
gchar** [text], gint* [cursor_index])"
  s7_pointer _p;
  s7_pointer context;
  gchar* ref_text = NULL;
  gint ref_cursor_index;
  _p = args;
  context = s7_car(_p);
  {
    s7_pointer res_ult;
    res_ult = s7_make_boolean(sc, gtk_im_context_get_surrounding((GtkIMContext*)s7_c_pointer_with_type(sc, context, GtkIMContext__sym, __func__, 0), &ref_text, &ref_cursor_index));
      return(s7_list(sc, 3, res_ult, s7_make_string(sc, ref_text), s7_make_integer(sc, ref_cursor_index)));
   }
}

static s7_pointer lg_gtk_im_context_delete_surrounding(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_im_context_delete_surrounding "gboolean gtk_im_context_delete_surrounding(GtkIMContext* context, \
gint offset, gint n_chars)"
  s7_pointer _p;
  s7_pointer context, offset, n_chars;
  _p = args;
  context = s7_car(_p); _p = s7_cdr(_p);
  offset = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(offset)) s7_wrong_type_arg_error(sc, "gtk_im_context_delete_surrounding", 2, offset, "gint");
  n_chars = s7_car(_p);
  if (!s7_is_integer(n_chars)) s7_wrong_type_arg_error(sc, "gtk_im_context_delete_surrounding", 3, n_chars, "gint");
  return(s7_make_boolean(sc, gtk_im_context_delete_surrounding((GtkIMContext*)s7_c_pointer_with_type(sc, context, GtkIMContext__sym, __func__, 0), (gint)s7_integer(offset), (gint)s7_integer(n_chars))));
}

static s7_pointer lg_gtk_im_context_simple_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_im_context_simple_new "GtkIMContext* gtk_im_context_simple_new( void)"
  return(lg_make_c_pointer_with_type(sc, GtkIMContext__sym, gtk_im_context_simple_new()));
}

static s7_pointer lg_gtk_im_context_simple_add_table(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_im_context_simple_add_table "void gtk_im_context_simple_add_table(GtkIMContextSimple* context_simple, \
guint16* data, gint max_seq_len, gint n_seqs)"
  s7_pointer _p;
  s7_pointer context_simple, data, max_seq_len, n_seqs;
  _p = args;
  context_simple = s7_car(_p); _p = s7_cdr(_p);
  data = s7_car(_p); _p = s7_cdr(_p);
  max_seq_len = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(max_seq_len)) s7_wrong_type_arg_error(sc, "gtk_im_context_simple_add_table", 3, max_seq_len, "gint");
  n_seqs = s7_car(_p);
  if (!s7_is_integer(n_seqs)) s7_wrong_type_arg_error(sc, "gtk_im_context_simple_add_table", 4, n_seqs, "gint");
  gtk_im_context_simple_add_table((GtkIMContextSimple*)s7_c_pointer_with_type(sc, context_simple, GtkIMContextSimple__sym, __func__, 0), (guint16*)s7_c_pointer_with_type(sc, data, guint16__sym, __func__, 0), (gint)s7_integer(max_seq_len), (gint)s7_integer(n_seqs));
  return(lg_false);
}

static s7_pointer lg_gtk_label_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_label_new "GtkWidget* gtk_label_new(char* str)"
  s7_pointer str;
  str = s7_car(args);
  if (!s7_is_string(str)) s7_wrong_type_arg_error(sc, "gtk_label_new", 1, str, "char*");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_label_new((char*)s7_string(str))));
}

static s7_pointer lg_gtk_label_new_with_mnemonic(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_label_new_with_mnemonic "GtkWidget* gtk_label_new_with_mnemonic(char* str)"
  s7_pointer str;
  str = s7_car(args);
  if (!s7_is_string(str)) s7_wrong_type_arg_error(sc, "gtk_label_new_with_mnemonic", 1, str, "char*");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_label_new_with_mnemonic((char*)s7_string(str))));
}

static s7_pointer lg_gtk_label_set_text(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_label_set_text "void gtk_label_set_text(GtkLabel* label, char* str)"
  s7_pointer _p;
  s7_pointer label, str;
  _p = args;
  label = s7_car(_p); _p = s7_cdr(_p);
  str = s7_car(_p);
  if (!s7_is_string(str)) s7_wrong_type_arg_error(sc, "gtk_label_set_text", 2, str, "char*");
  gtk_label_set_text((GtkLabel*)s7_c_pointer_with_type(sc, label, GtkLabel__sym, __func__, 0), (char*)s7_string(str));
  return(lg_false);
}

static s7_pointer lg_gtk_label_get_text(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_label_get_text "gchar* gtk_label_get_text(GtkLabel* label)"
  s7_pointer label;
  label = s7_car(args);
  return(s7_make_string(sc, gtk_label_get_text((GtkLabel*)s7_c_pointer_with_type(sc, label, GtkLabel__sym, __func__, 0))));
}

static s7_pointer lg_gtk_label_set_attributes(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_label_set_attributes "void gtk_label_set_attributes(GtkLabel* label, PangoAttrList* attrs)"
  s7_pointer _p;
  s7_pointer label, attrs;
  _p = args;
  label = s7_car(_p); _p = s7_cdr(_p);
  attrs = s7_car(_p);
  gtk_label_set_attributes((GtkLabel*)s7_c_pointer_with_type(sc, label, GtkLabel__sym, __func__, 0), (PangoAttrList*)s7_c_pointer_with_type(sc, attrs, PangoAttrList__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_label_get_attributes(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_label_get_attributes "PangoAttrList* gtk_label_get_attributes(GtkLabel* label)"
  s7_pointer label;
  label = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, PangoAttrList__sym, gtk_label_get_attributes((GtkLabel*)s7_c_pointer_with_type(sc, label, GtkLabel__sym, __func__, 0))));
}

static s7_pointer lg_gtk_label_set_label(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_label_set_label "void gtk_label_set_label(GtkLabel* label, gchar* str)"
  s7_pointer _p;
  s7_pointer label, str;
  _p = args;
  label = s7_car(_p); _p = s7_cdr(_p);
  str = s7_car(_p);
  if (!s7_is_string(str)) s7_wrong_type_arg_error(sc, "gtk_label_set_label", 2, str, "gchar*");
  gtk_label_set_label((GtkLabel*)s7_c_pointer_with_type(sc, label, GtkLabel__sym, __func__, 0), (gchar*)s7_string(str));
  return(lg_false);
}

static s7_pointer lg_gtk_label_get_label(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_label_get_label "gchar* gtk_label_get_label(GtkLabel* label)"
  s7_pointer label;
  label = s7_car(args);
  return(s7_make_string(sc, gtk_label_get_label((GtkLabel*)s7_c_pointer_with_type(sc, label, GtkLabel__sym, __func__, 0))));
}

static s7_pointer lg_gtk_label_set_markup(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_label_set_markup "void gtk_label_set_markup(GtkLabel* label, gchar* str)"
  s7_pointer _p;
  s7_pointer label, str;
  _p = args;
  label = s7_car(_p); _p = s7_cdr(_p);
  str = s7_car(_p);
  if (!s7_is_string(str)) s7_wrong_type_arg_error(sc, "gtk_label_set_markup", 2, str, "gchar*");
  gtk_label_set_markup((GtkLabel*)s7_c_pointer_with_type(sc, label, GtkLabel__sym, __func__, 0), (gchar*)s7_string(str));
  return(lg_false);
}

static s7_pointer lg_gtk_label_set_use_markup(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_label_set_use_markup "void gtk_label_set_use_markup(GtkLabel* label, gboolean setting)"
  s7_pointer _p;
  s7_pointer label, setting;
  _p = args;
  label = s7_car(_p); _p = s7_cdr(_p);
  setting = s7_car(_p);
  if (!s7_is_boolean(setting)) s7_wrong_type_arg_error(sc, "gtk_label_set_use_markup", 2, setting, "gboolean");
  gtk_label_set_use_markup((GtkLabel*)s7_c_pointer_with_type(sc, label, GtkLabel__sym, __func__, 0), (gboolean)lg_boolean(setting));
  return(lg_false);
}

static s7_pointer lg_gtk_label_get_use_markup(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_label_get_use_markup "gboolean gtk_label_get_use_markup(GtkLabel* label)"
  s7_pointer label;
  label = s7_car(args);
  return(s7_make_boolean(sc, gtk_label_get_use_markup((GtkLabel*)s7_c_pointer_with_type(sc, label, GtkLabel__sym, __func__, 0))));
}

static s7_pointer lg_gtk_label_set_use_underline(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_label_set_use_underline "void gtk_label_set_use_underline(GtkLabel* label, gboolean setting)"
  s7_pointer _p;
  s7_pointer label, setting;
  _p = args;
  label = s7_car(_p); _p = s7_cdr(_p);
  setting = s7_car(_p);
  if (!s7_is_boolean(setting)) s7_wrong_type_arg_error(sc, "gtk_label_set_use_underline", 2, setting, "gboolean");
  gtk_label_set_use_underline((GtkLabel*)s7_c_pointer_with_type(sc, label, GtkLabel__sym, __func__, 0), (gboolean)lg_boolean(setting));
  return(lg_false);
}

static s7_pointer lg_gtk_label_get_use_underline(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_label_get_use_underline "gboolean gtk_label_get_use_underline(GtkLabel* label)"
  s7_pointer label;
  label = s7_car(args);
  return(s7_make_boolean(sc, gtk_label_get_use_underline((GtkLabel*)s7_c_pointer_with_type(sc, label, GtkLabel__sym, __func__, 0))));
}

static s7_pointer lg_gtk_label_set_markup_with_mnemonic(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_label_set_markup_with_mnemonic "void gtk_label_set_markup_with_mnemonic(GtkLabel* label, \
gchar* str)"
  s7_pointer _p;
  s7_pointer label, str;
  _p = args;
  label = s7_car(_p); _p = s7_cdr(_p);
  str = s7_car(_p);
  if (!s7_is_string(str)) s7_wrong_type_arg_error(sc, "gtk_label_set_markup_with_mnemonic", 2, str, "gchar*");
  gtk_label_set_markup_with_mnemonic((GtkLabel*)s7_c_pointer_with_type(sc, label, GtkLabel__sym, __func__, 0), (gchar*)s7_string(str));
  return(lg_false);
}

static s7_pointer lg_gtk_label_get_mnemonic_keyval(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_label_get_mnemonic_keyval "guint gtk_label_get_mnemonic_keyval(GtkLabel* label)"
  s7_pointer label;
  label = s7_car(args);
  return(s7_make_integer(sc, gtk_label_get_mnemonic_keyval((GtkLabel*)s7_c_pointer_with_type(sc, label, GtkLabel__sym, __func__, 0))));
}

static s7_pointer lg_gtk_label_set_mnemonic_widget(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_label_set_mnemonic_widget "void gtk_label_set_mnemonic_widget(GtkLabel* label, GtkWidget* widget)"
  s7_pointer _p;
  s7_pointer label, widget;
  _p = args;
  label = s7_car(_p); _p = s7_cdr(_p);
  widget = s7_car(_p);
  gtk_label_set_mnemonic_widget((GtkLabel*)s7_c_pointer_with_type(sc, label, GtkLabel__sym, __func__, 0), (GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_label_get_mnemonic_widget(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_label_get_mnemonic_widget "GtkWidget* gtk_label_get_mnemonic_widget(GtkLabel* label)"
  s7_pointer label;
  label = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_label_get_mnemonic_widget((GtkLabel*)s7_c_pointer_with_type(sc, label, GtkLabel__sym, __func__, 0))));
}

static s7_pointer lg_gtk_label_set_text_with_mnemonic(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_label_set_text_with_mnemonic "void gtk_label_set_text_with_mnemonic(GtkLabel* label, \
gchar* str)"
  s7_pointer _p;
  s7_pointer label, str;
  _p = args;
  label = s7_car(_p); _p = s7_cdr(_p);
  str = s7_car(_p);
  if (!s7_is_string(str)) s7_wrong_type_arg_error(sc, "gtk_label_set_text_with_mnemonic", 2, str, "gchar*");
  gtk_label_set_text_with_mnemonic((GtkLabel*)s7_c_pointer_with_type(sc, label, GtkLabel__sym, __func__, 0), (gchar*)s7_string(str));
  return(lg_false);
}

static s7_pointer lg_gtk_label_set_justify(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_label_set_justify "void gtk_label_set_justify(GtkLabel* label, GtkJustification jtype)"
  s7_pointer _p;
  s7_pointer label, jtype;
  _p = args;
  label = s7_car(_p); _p = s7_cdr(_p);
  jtype = s7_car(_p);
  if (!s7_is_integer(jtype)) s7_wrong_type_arg_error(sc, "gtk_label_set_justify", 2, jtype, "GtkJustification");
  gtk_label_set_justify((GtkLabel*)s7_c_pointer_with_type(sc, label, GtkLabel__sym, __func__, 0), (GtkJustification)s7_integer(jtype));
  return(lg_false);
}

static s7_pointer lg_gtk_label_get_justify(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_label_get_justify "GtkJustification gtk_label_get_justify(GtkLabel* label)"
  s7_pointer label;
  label = s7_car(args);
  return(s7_make_integer(sc, gtk_label_get_justify((GtkLabel*)s7_c_pointer_with_type(sc, label, GtkLabel__sym, __func__, 0))));
}

static s7_pointer lg_gtk_label_set_selectable(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_label_set_selectable "void gtk_label_set_selectable(GtkLabel* label, gboolean setting)"
  s7_pointer _p;
  s7_pointer label, setting;
  _p = args;
  label = s7_car(_p); _p = s7_cdr(_p);
  setting = s7_car(_p);
  if (!s7_is_boolean(setting)) s7_wrong_type_arg_error(sc, "gtk_label_set_selectable", 2, setting, "gboolean");
  gtk_label_set_selectable((GtkLabel*)s7_c_pointer_with_type(sc, label, GtkLabel__sym, __func__, 0), (gboolean)lg_boolean(setting));
  return(lg_false);
}

static s7_pointer lg_gtk_label_get_selectable(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_label_get_selectable "gboolean gtk_label_get_selectable(GtkLabel* label)"
  s7_pointer label;
  label = s7_car(args);
  return(s7_make_boolean(sc, gtk_label_get_selectable((GtkLabel*)s7_c_pointer_with_type(sc, label, GtkLabel__sym, __func__, 0))));
}

static s7_pointer lg_gtk_label_select_region(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_label_select_region "void gtk_label_select_region(GtkLabel* label, gint start_offset, \
gint end_offset)"
  s7_pointer _p;
  s7_pointer label, start_offset, end_offset;
  _p = args;
  label = s7_car(_p); _p = s7_cdr(_p);
  start_offset = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(start_offset)) s7_wrong_type_arg_error(sc, "gtk_label_select_region", 2, start_offset, "gint");
  end_offset = s7_car(_p);
  if (!s7_is_integer(end_offset)) s7_wrong_type_arg_error(sc, "gtk_label_select_region", 3, end_offset, "gint");
  gtk_label_select_region((GtkLabel*)s7_c_pointer_with_type(sc, label, GtkLabel__sym, __func__, 0), (gint)s7_integer(start_offset), (gint)s7_integer(end_offset));
  return(lg_false);
}

static s7_pointer lg_gtk_label_get_selection_bounds(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_label_get_selection_bounds "gboolean gtk_label_get_selection_bounds(GtkLabel* label, \
gint* [start], gint* [end])"
  s7_pointer _p;
  s7_pointer label;
  gint ref_start;
  gint ref_end;
  _p = args;
  label = s7_car(_p);
  {
    s7_pointer res_ult;
    res_ult = s7_make_boolean(sc, gtk_label_get_selection_bounds((GtkLabel*)s7_c_pointer_with_type(sc, label, GtkLabel__sym, __func__, 0), &ref_start, &ref_end));
      return(s7_list(sc, 3, res_ult, s7_make_integer(sc, ref_start), s7_make_integer(sc, ref_end)));
   }
}

static s7_pointer lg_gtk_label_get_layout(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_label_get_layout "PangoLayout* gtk_label_get_layout(GtkLabel* label)"
  s7_pointer label;
  label = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, PangoLayout__sym, gtk_label_get_layout((GtkLabel*)s7_c_pointer_with_type(sc, label, GtkLabel__sym, __func__, 0))));
}

static s7_pointer lg_gtk_label_get_layout_offsets(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_label_get_layout_offsets "void gtk_label_get_layout_offsets(GtkLabel* label, gint* [x], \
gint* [y])"
  s7_pointer _p;
  s7_pointer label;
  gint ref_x;
  gint ref_y;
  _p = args;
  label = s7_car(_p);
  gtk_label_get_layout_offsets((GtkLabel*)s7_c_pointer_with_type(sc, label, GtkLabel__sym, __func__, 0), &ref_x, &ref_y);
    return(s7_list(sc, 2, s7_make_integer(sc, ref_x), s7_make_integer(sc, ref_y)));
}

static s7_pointer lg_gtk_list_store_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_list_store_new "GtkListStore* gtk_list_store_new(gint n_columns, etc types)"
  s7_pointer _p;
  s7_pointer n_columns, types;
  _p = args;
  n_columns = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(n_columns)) s7_wrong_type_arg_error(sc, "gtk_list_store_new", 1, n_columns, "gint");
  types = s7_car(_p);
  if (!lg_is_list(types)) s7_wrong_type_arg_error(sc, "gtk_list_store_new", 2, types, "etc");
  {
    int etc_len = 0;
    GtkListStore* res_ult = NULL;
    gint p_arg0;
    if (s7_is_list(sc, types)) etc_len = s7_list_length(sc, types);
    if (etc_len < 1) s7_out_of_range_error(sc, "gtk_list_store_new", 1, types, "... list must have at least 1 entry");
    if (etc_len > 6) s7_out_of_range_error(sc, "gtk_list_store_new", 1, types, "... list too long (max len: 6)");
    p_arg0 = (gint)s7_integer(n_columns);
    switch (etc_len)
      {
        case 1: res_ult = gtk_list_store_new(p_arg0, s7_c_pointer(s7_list_ref(sc, types, 0))); break;
        case 2: res_ult = gtk_list_store_new(p_arg0, s7_c_pointer(s7_list_ref(sc, types, 0)), s7_c_pointer(s7_list_ref(sc, types, 1))); break;
        case 3: res_ult = gtk_list_store_new(p_arg0, s7_c_pointer(s7_list_ref(sc, types, 0)), s7_c_pointer(s7_list_ref(sc, types, 1)), s7_c_pointer(s7_list_ref(sc, types, 2))); break;
        case 4: res_ult = gtk_list_store_new(p_arg0, s7_c_pointer(s7_list_ref(sc, types, 0)), s7_c_pointer(s7_list_ref(sc, types, 1)), s7_c_pointer(s7_list_ref(sc, types, 2)), s7_c_pointer(s7_list_ref(sc, types, 3))); break;
        case 5: res_ult = gtk_list_store_new(p_arg0, s7_c_pointer(s7_list_ref(sc, types, 0)), s7_c_pointer(s7_list_ref(sc, types, 1)), s7_c_pointer(s7_list_ref(sc, types, 2)), s7_c_pointer(s7_list_ref(sc, types, 3)), s7_c_pointer(s7_list_ref(sc, types, 4))); break;
        case 6: res_ult = gtk_list_store_new(p_arg0, s7_c_pointer(s7_list_ref(sc, types, 0)), s7_c_pointer(s7_list_ref(sc, types, 1)), s7_c_pointer(s7_list_ref(sc, types, 2)), s7_c_pointer(s7_list_ref(sc, types, 3)), s7_c_pointer(s7_list_ref(sc, types, 4)), s7_c_pointer(s7_list_ref(sc, types, 5))); break;
      }
    return(s7_make_c_pointer(sc, res_ult));
  }
}

static s7_pointer lg_gtk_list_store_newv(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_list_store_newv "GtkListStore* gtk_list_store_newv(gint n_columns, GType* types)"
  s7_pointer _p;
  s7_pointer n_columns, types;
  _p = args;
  n_columns = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(n_columns)) s7_wrong_type_arg_error(sc, "gtk_list_store_newv", 1, n_columns, "gint");
  types = s7_car(_p);
  return(lg_make_c_pointer_with_type(sc, GtkListStore__sym, gtk_list_store_newv((gint)s7_integer(n_columns), (GType*)s7_c_pointer_with_type(sc, types, GType__sym, __func__, 0))));
}

static s7_pointer lg_gtk_list_store_set_column_types(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_list_store_set_column_types "void gtk_list_store_set_column_types(GtkListStore* list_store, \
gint n_columns, GType* types)"
  s7_pointer _p;
  s7_pointer list_store, n_columns, types;
  _p = args;
  list_store = s7_car(_p); _p = s7_cdr(_p);
  n_columns = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(n_columns)) s7_wrong_type_arg_error(sc, "gtk_list_store_set_column_types", 2, n_columns, "gint");
  types = s7_car(_p);
  gtk_list_store_set_column_types((GtkListStore*)s7_c_pointer_with_type(sc, list_store, GtkListStore__sym, __func__, 0), (gint)s7_integer(n_columns), (GType*)s7_c_pointer_with_type(sc, types, GType__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_list_store_set(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_list_store_set "void gtk_list_store_set(GtkListStore* list_store, GtkTreeIter* iter, \
etc values)"
  s7_pointer _p;
  s7_pointer list_store, iter, values;
  _p = args;
  list_store = s7_car(_p); _p = s7_cdr(_p);
  iter = s7_car(_p); _p = s7_cdr(_p);
  values = s7_car(_p);
  if (!lg_is_list(values)) s7_wrong_type_arg_error(sc, "gtk_list_store_set", 3, values, "etc");
  {
    int etc_len = 0;
    GtkListStore* p_arg0;
    GtkTreeIter* p_arg1;
    if (s7_is_list(sc, values)) etc_len = s7_list_length(sc, values);
    if (etc_len < 2) s7_out_of_range_error(sc, "gtk_list_store_set", 2, values, "... list must have at least 2 entries");
    if (etc_len > 10) s7_out_of_range_error(sc, "gtk_list_store_set", 2, values, "... list too long (max len: 10)");
    if ((etc_len % 2) != 0) s7_out_of_range_error(sc, "gtk_list_store_set", 2, values, "... list len must be multiple of 2");
    p_arg0 = (GtkListStore*)s7_c_pointer_with_type(sc, list_store, GtkListStore__sym, __func__, 0);
    p_arg1 = (GtkTreeIter*)s7_c_pointer_with_type(sc, iter, GtkTreeIter__sym, __func__, 0);
    switch (etc_len)
      {
        case 2: gtk_list_store_set(p_arg0, p_arg1, s7_integer(s7_list_ref(sc, values, 0)), s7_string(s7_list_ref(sc, values, 1)), -1); break;
        case 4: gtk_list_store_set(p_arg0, p_arg1, s7_integer(s7_list_ref(sc, values, 0)), s7_string(s7_list_ref(sc, values, 1)), s7_integer(s7_list_ref(sc, values, 2)), s7_string(s7_list_ref(sc, values, 3)), -1); break;
        case 6: gtk_list_store_set(p_arg0, p_arg1, s7_integer(s7_list_ref(sc, values, 0)), s7_string(s7_list_ref(sc, values, 1)), s7_integer(s7_list_ref(sc, values, 2)), s7_string(s7_list_ref(sc, values, 3)), s7_integer(s7_list_ref(sc, values, 4)), s7_string(s7_list_ref(sc, values, 5)), -1); break;
        case 8: gtk_list_store_set(p_arg0, p_arg1, s7_integer(s7_list_ref(sc, values, 0)), s7_string(s7_list_ref(sc, values, 1)), s7_integer(s7_list_ref(sc, values, 2)), s7_string(s7_list_ref(sc, values, 3)), s7_integer(s7_list_ref(sc, values, 4)), s7_string(s7_list_ref(sc, values, 5)), s7_integer(s7_list_ref(sc, values, 6)), s7_string(s7_list_ref(sc, values, 7)), -1); break;
        case 10: gtk_list_store_set(p_arg0, p_arg1, s7_integer(s7_list_ref(sc, values, 0)), s7_string(s7_list_ref(sc, values, 1)), s7_integer(s7_list_ref(sc, values, 2)), s7_string(s7_list_ref(sc, values, 3)), s7_integer(s7_list_ref(sc, values, 4)), s7_string(s7_list_ref(sc, values, 5)), s7_integer(s7_list_ref(sc, values, 6)), s7_string(s7_list_ref(sc, values, 7)), s7_integer(s7_list_ref(sc, values, 8)), s7_string(s7_list_ref(sc, values, 9)), -1); break;
      }
    return(lg_false);
  }
}

static s7_pointer lg_gtk_list_store_insert(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_list_store_insert "void gtk_list_store_insert(GtkListStore* list_store, GtkTreeIter* iter, \
gint position)"
  s7_pointer _p;
  s7_pointer list_store, iter, position;
  _p = args;
  list_store = s7_car(_p); _p = s7_cdr(_p);
  iter = s7_car(_p); _p = s7_cdr(_p);
  position = s7_car(_p);
  if (!s7_is_integer(position)) s7_wrong_type_arg_error(sc, "gtk_list_store_insert", 3, position, "gint");
  gtk_list_store_insert((GtkListStore*)s7_c_pointer_with_type(sc, list_store, GtkListStore__sym, __func__, 0), (GtkTreeIter*)s7_c_pointer_with_type(sc, iter, GtkTreeIter__sym, __func__, 0), (gint)s7_integer(position));
  return(lg_false);
}

static s7_pointer lg_gtk_list_store_insert_before(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_list_store_insert_before "void gtk_list_store_insert_before(GtkListStore* list_store, \
GtkTreeIter* iter, GtkTreeIter* sibling)"
  s7_pointer _p;
  s7_pointer list_store, iter, sibling;
  _p = args;
  list_store = s7_car(_p); _p = s7_cdr(_p);
  iter = s7_car(_p); _p = s7_cdr(_p);
  sibling = s7_car(_p);
  gtk_list_store_insert_before((GtkListStore*)s7_c_pointer_with_type(sc, list_store, GtkListStore__sym, __func__, 0), (GtkTreeIter*)s7_c_pointer_with_type(sc, iter, GtkTreeIter__sym, __func__, 0), (GtkTreeIter*)s7_c_pointer_with_type(sc, sibling, GtkTreeIter__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_list_store_insert_after(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_list_store_insert_after "void gtk_list_store_insert_after(GtkListStore* list_store, GtkTreeIter* iter, \
GtkTreeIter* sibling)"
  s7_pointer _p;
  s7_pointer list_store, iter, sibling;
  _p = args;
  list_store = s7_car(_p); _p = s7_cdr(_p);
  iter = s7_car(_p); _p = s7_cdr(_p);
  sibling = s7_car(_p);
  gtk_list_store_insert_after((GtkListStore*)s7_c_pointer_with_type(sc, list_store, GtkListStore__sym, __func__, 0), (GtkTreeIter*)s7_c_pointer_with_type(sc, iter, GtkTreeIter__sym, __func__, 0), (GtkTreeIter*)s7_c_pointer_with_type(sc, sibling, GtkTreeIter__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_list_store_prepend(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_list_store_prepend "void gtk_list_store_prepend(GtkListStore* list_store, GtkTreeIter* iter)"
  s7_pointer _p;
  s7_pointer list_store, iter;
  _p = args;
  list_store = s7_car(_p); _p = s7_cdr(_p);
  iter = s7_car(_p);
  gtk_list_store_prepend((GtkListStore*)s7_c_pointer_with_type(sc, list_store, GtkListStore__sym, __func__, 0), (GtkTreeIter*)s7_c_pointer_with_type(sc, iter, GtkTreeIter__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_list_store_append(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_list_store_append "void gtk_list_store_append(GtkListStore* list_store, GtkTreeIter* iter)"
  s7_pointer _p;
  s7_pointer list_store, iter;
  _p = args;
  list_store = s7_car(_p); _p = s7_cdr(_p);
  iter = s7_car(_p);
  gtk_list_store_append((GtkListStore*)s7_c_pointer_with_type(sc, list_store, GtkListStore__sym, __func__, 0), (GtkTreeIter*)s7_c_pointer_with_type(sc, iter, GtkTreeIter__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_list_store_clear(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_list_store_clear "void gtk_list_store_clear(GtkListStore* list_store)"
  s7_pointer list_store;
  list_store = s7_car(args);
  gtk_list_store_clear((GtkListStore*)s7_c_pointer_with_type(sc, list_store, GtkListStore__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_check_version(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_check_version "gchar* gtk_check_version(guint required_major, guint required_minor, guint required_micro)"
  s7_pointer _p;
  s7_pointer required_major, required_minor, required_micro;
  _p = args;
  required_major = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(required_major)) s7_wrong_type_arg_error(sc, "gtk_check_version", 1, required_major, "guint");
  required_minor = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(required_minor)) s7_wrong_type_arg_error(sc, "gtk_check_version", 2, required_minor, "guint");
  required_micro = s7_car(_p);
  if (!s7_is_integer(required_micro)) s7_wrong_type_arg_error(sc, "gtk_check_version", 3, required_micro, "guint");
    return(s7_make_string(sc, (gchar*)gtk_check_version((guint)s7_integer(required_major), (guint)s7_integer(required_minor), (guint)s7_integer(required_micro))));
}

static s7_pointer lg_gtk_disable_setlocale(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_disable_setlocale "void gtk_disable_setlocale( void)"
  gtk_disable_setlocale();
  return(lg_false);
}

static s7_pointer lg_gtk_get_default_language(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_get_default_language "PangoLanguage* gtk_get_default_language( void)"
  return(lg_make_c_pointer_with_type(sc, PangoLanguage__sym, gtk_get_default_language()));
}

static s7_pointer lg_gtk_notebook_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_notebook_new "GtkWidget* gtk_notebook_new( void)"
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_notebook_new()));
}

static s7_pointer lg_gtk_notebook_remove_page(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_notebook_remove_page "void gtk_notebook_remove_page(GtkNotebook* notebook, gint page_num)"
  s7_pointer _p;
  s7_pointer notebook, page_num;
  _p = args;
  notebook = s7_car(_p); _p = s7_cdr(_p);
  page_num = s7_car(_p);
  if (!s7_is_integer(page_num)) s7_wrong_type_arg_error(sc, "gtk_notebook_remove_page", 2, page_num, "gint");
  gtk_notebook_remove_page((GtkNotebook*)s7_c_pointer_with_type(sc, notebook, GtkNotebook__sym, __func__, 0), (gint)s7_integer(page_num));
  return(lg_false);
}

static s7_pointer lg_gtk_notebook_get_current_page(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_notebook_get_current_page "gint gtk_notebook_get_current_page(GtkNotebook* notebook)"
  s7_pointer notebook;
  notebook = s7_car(args);
  return(s7_make_integer(sc, gtk_notebook_get_current_page((GtkNotebook*)s7_c_pointer_with_type(sc, notebook, GtkNotebook__sym, __func__, 0))));
}

static s7_pointer lg_gtk_notebook_get_nth_page(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_notebook_get_nth_page "GtkWidget* gtk_notebook_get_nth_page(GtkNotebook* notebook, gint page_num)"
  s7_pointer _p;
  s7_pointer notebook, page_num;
  _p = args;
  notebook = s7_car(_p); _p = s7_cdr(_p);
  page_num = s7_car(_p);
  if (!s7_is_integer(page_num)) s7_wrong_type_arg_error(sc, "gtk_notebook_get_nth_page", 2, page_num, "gint");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_notebook_get_nth_page((GtkNotebook*)s7_c_pointer_with_type(sc, notebook, GtkNotebook__sym, __func__, 0), (gint)s7_integer(page_num))));
}

static s7_pointer lg_gtk_notebook_page_num(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_notebook_page_num "gint gtk_notebook_page_num(GtkNotebook* notebook, GtkWidget* child)"
  s7_pointer _p;
  s7_pointer notebook, child;
  _p = args;
  notebook = s7_car(_p); _p = s7_cdr(_p);
  child = s7_car(_p);
  return(s7_make_integer(sc, gtk_notebook_page_num((GtkNotebook*)s7_c_pointer_with_type(sc, notebook, GtkNotebook__sym, __func__, 0), (GtkWidget*)s7_c_pointer_with_type(sc, child, GtkWidget__sym, __func__, 0))));
}

static s7_pointer lg_gtk_notebook_set_current_page(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_notebook_set_current_page "void gtk_notebook_set_current_page(GtkNotebook* notebook, \
gint page_num)"
  s7_pointer _p;
  s7_pointer notebook, page_num;
  _p = args;
  notebook = s7_car(_p); _p = s7_cdr(_p);
  page_num = s7_car(_p);
  if (!s7_is_integer(page_num)) s7_wrong_type_arg_error(sc, "gtk_notebook_set_current_page", 2, page_num, "gint");
  gtk_notebook_set_current_page((GtkNotebook*)s7_c_pointer_with_type(sc, notebook, GtkNotebook__sym, __func__, 0), (gint)s7_integer(page_num));
  return(lg_false);
}

static s7_pointer lg_gtk_notebook_next_page(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_notebook_next_page "void gtk_notebook_next_page(GtkNotebook* notebook)"
  s7_pointer notebook;
  notebook = s7_car(args);
  gtk_notebook_next_page((GtkNotebook*)s7_c_pointer_with_type(sc, notebook, GtkNotebook__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_notebook_prev_page(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_notebook_prev_page "void gtk_notebook_prev_page(GtkNotebook* notebook)"
  s7_pointer notebook;
  notebook = s7_car(args);
  gtk_notebook_prev_page((GtkNotebook*)s7_c_pointer_with_type(sc, notebook, GtkNotebook__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_notebook_set_show_border(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_notebook_set_show_border "void gtk_notebook_set_show_border(GtkNotebook* notebook, gboolean show_border)"
  s7_pointer _p;
  s7_pointer notebook, show_border;
  _p = args;
  notebook = s7_car(_p); _p = s7_cdr(_p);
  show_border = s7_car(_p);
  if (!s7_is_boolean(show_border)) s7_wrong_type_arg_error(sc, "gtk_notebook_set_show_border", 2, show_border, "gboolean");
  gtk_notebook_set_show_border((GtkNotebook*)s7_c_pointer_with_type(sc, notebook, GtkNotebook__sym, __func__, 0), (gboolean)lg_boolean(show_border));
  return(lg_false);
}

static s7_pointer lg_gtk_notebook_get_show_border(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_notebook_get_show_border "gboolean gtk_notebook_get_show_border(GtkNotebook* notebook)"
  s7_pointer notebook;
  notebook = s7_car(args);
  return(s7_make_boolean(sc, gtk_notebook_get_show_border((GtkNotebook*)s7_c_pointer_with_type(sc, notebook, GtkNotebook__sym, __func__, 0))));
}

static s7_pointer lg_gtk_notebook_set_show_tabs(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_notebook_set_show_tabs "void gtk_notebook_set_show_tabs(GtkNotebook* notebook, gboolean show_tabs)"
  s7_pointer _p;
  s7_pointer notebook, show_tabs;
  _p = args;
  notebook = s7_car(_p); _p = s7_cdr(_p);
  show_tabs = s7_car(_p);
  if (!s7_is_boolean(show_tabs)) s7_wrong_type_arg_error(sc, "gtk_notebook_set_show_tabs", 2, show_tabs, "gboolean");
  gtk_notebook_set_show_tabs((GtkNotebook*)s7_c_pointer_with_type(sc, notebook, GtkNotebook__sym, __func__, 0), (gboolean)lg_boolean(show_tabs));
  return(lg_false);
}

static s7_pointer lg_gtk_notebook_get_show_tabs(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_notebook_get_show_tabs "gboolean gtk_notebook_get_show_tabs(GtkNotebook* notebook)"
  s7_pointer notebook;
  notebook = s7_car(args);
  return(s7_make_boolean(sc, gtk_notebook_get_show_tabs((GtkNotebook*)s7_c_pointer_with_type(sc, notebook, GtkNotebook__sym, __func__, 0))));
}

static s7_pointer lg_gtk_notebook_set_tab_pos(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_notebook_set_tab_pos "void gtk_notebook_set_tab_pos(GtkNotebook* notebook, GtkPositionType pos)"
  s7_pointer _p;
  s7_pointer notebook, pos;
  _p = args;
  notebook = s7_car(_p); _p = s7_cdr(_p);
  pos = s7_car(_p);
  if (!s7_is_integer(pos)) s7_wrong_type_arg_error(sc, "gtk_notebook_set_tab_pos", 2, pos, "GtkPositionType");
  gtk_notebook_set_tab_pos((GtkNotebook*)s7_c_pointer_with_type(sc, notebook, GtkNotebook__sym, __func__, 0), (GtkPositionType)s7_integer(pos));
  return(lg_false);
}

static s7_pointer lg_gtk_notebook_get_tab_pos(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_notebook_get_tab_pos "GtkPositionType gtk_notebook_get_tab_pos(GtkNotebook* notebook)"
  s7_pointer notebook;
  notebook = s7_car(args);
  return(s7_make_integer(sc, gtk_notebook_get_tab_pos((GtkNotebook*)s7_c_pointer_with_type(sc, notebook, GtkNotebook__sym, __func__, 0))));
}

static s7_pointer lg_gtk_notebook_set_scrollable(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_notebook_set_scrollable "void gtk_notebook_set_scrollable(GtkNotebook* notebook, gboolean scrollable)"
  s7_pointer _p;
  s7_pointer notebook, scrollable;
  _p = args;
  notebook = s7_car(_p); _p = s7_cdr(_p);
  scrollable = s7_car(_p);
  if (!s7_is_boolean(scrollable)) s7_wrong_type_arg_error(sc, "gtk_notebook_set_scrollable", 2, scrollable, "gboolean");
  gtk_notebook_set_scrollable((GtkNotebook*)s7_c_pointer_with_type(sc, notebook, GtkNotebook__sym, __func__, 0), (gboolean)lg_boolean(scrollable));
  return(lg_false);
}

static s7_pointer lg_gtk_notebook_get_scrollable(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_notebook_get_scrollable "gboolean gtk_notebook_get_scrollable(GtkNotebook* notebook)"
  s7_pointer notebook;
  notebook = s7_car(args);
  return(s7_make_boolean(sc, gtk_notebook_get_scrollable((GtkNotebook*)s7_c_pointer_with_type(sc, notebook, GtkNotebook__sym, __func__, 0))));
}

static s7_pointer lg_gtk_notebook_popup_enable(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_notebook_popup_enable "void gtk_notebook_popup_enable(GtkNotebook* notebook)"
  s7_pointer notebook;
  notebook = s7_car(args);
  gtk_notebook_popup_enable((GtkNotebook*)s7_c_pointer_with_type(sc, notebook, GtkNotebook__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_notebook_popup_disable(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_notebook_popup_disable "void gtk_notebook_popup_disable(GtkNotebook* notebook)"
  s7_pointer notebook;
  notebook = s7_car(args);
  gtk_notebook_popup_disable((GtkNotebook*)s7_c_pointer_with_type(sc, notebook, GtkNotebook__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_notebook_get_tab_label(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_notebook_get_tab_label "GtkWidget* gtk_notebook_get_tab_label(GtkNotebook* notebook, \
GtkWidget* child)"
  s7_pointer _p;
  s7_pointer notebook, child;
  _p = args;
  notebook = s7_car(_p); _p = s7_cdr(_p);
  child = s7_car(_p);
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_notebook_get_tab_label((GtkNotebook*)s7_c_pointer_with_type(sc, notebook, GtkNotebook__sym, __func__, 0), (GtkWidget*)s7_c_pointer_with_type(sc, child, GtkWidget__sym, __func__, 0))));
}

static s7_pointer lg_gtk_notebook_set_tab_label(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_notebook_set_tab_label "void gtk_notebook_set_tab_label(GtkNotebook* notebook, GtkWidget* child, \
GtkWidget* tab_label)"
  s7_pointer _p;
  s7_pointer notebook, child, tab_label;
  _p = args;
  notebook = s7_car(_p); _p = s7_cdr(_p);
  child = s7_car(_p); _p = s7_cdr(_p);
  tab_label = s7_car(_p);
  gtk_notebook_set_tab_label((GtkNotebook*)s7_c_pointer_with_type(sc, notebook, GtkNotebook__sym, __func__, 0), (GtkWidget*)s7_c_pointer_with_type(sc, child, GtkWidget__sym, __func__, 0), (GtkWidget*)s7_c_pointer_with_type(sc, tab_label, GtkWidget__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_notebook_set_tab_label_text(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_notebook_set_tab_label_text "void gtk_notebook_set_tab_label_text(GtkNotebook* notebook, \
GtkWidget* child, gchar* tab_text)"
  s7_pointer _p;
  s7_pointer notebook, child, tab_text;
  _p = args;
  notebook = s7_car(_p); _p = s7_cdr(_p);
  child = s7_car(_p); _p = s7_cdr(_p);
  tab_text = s7_car(_p);
  if (!s7_is_string(tab_text)) s7_wrong_type_arg_error(sc, "gtk_notebook_set_tab_label_text", 3, tab_text, "gchar*");
  gtk_notebook_set_tab_label_text((GtkNotebook*)s7_c_pointer_with_type(sc, notebook, GtkNotebook__sym, __func__, 0), (GtkWidget*)s7_c_pointer_with_type(sc, child, GtkWidget__sym, __func__, 0), (gchar*)s7_string(tab_text));
  return(lg_false);
}

static s7_pointer lg_gtk_notebook_get_tab_label_text(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_notebook_get_tab_label_text "gchar* gtk_notebook_get_tab_label_text(GtkNotebook* notebook, \
GtkWidget* child)"
  s7_pointer _p;
  s7_pointer notebook, child;
  _p = args;
  notebook = s7_car(_p); _p = s7_cdr(_p);
  child = s7_car(_p);
  return(s7_make_string(sc, gtk_notebook_get_tab_label_text((GtkNotebook*)s7_c_pointer_with_type(sc, notebook, GtkNotebook__sym, __func__, 0), (GtkWidget*)s7_c_pointer_with_type(sc, child, GtkWidget__sym, __func__, 0))));
}

static s7_pointer lg_gtk_notebook_get_menu_label(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_notebook_get_menu_label "GtkWidget* gtk_notebook_get_menu_label(GtkNotebook* notebook, \
GtkWidget* child)"
  s7_pointer _p;
  s7_pointer notebook, child;
  _p = args;
  notebook = s7_car(_p); _p = s7_cdr(_p);
  child = s7_car(_p);
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_notebook_get_menu_label((GtkNotebook*)s7_c_pointer_with_type(sc, notebook, GtkNotebook__sym, __func__, 0), (GtkWidget*)s7_c_pointer_with_type(sc, child, GtkWidget__sym, __func__, 0))));
}

static s7_pointer lg_gtk_notebook_set_menu_label(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_notebook_set_menu_label "void gtk_notebook_set_menu_label(GtkNotebook* notebook, GtkWidget* child, \
GtkWidget* menu_label)"
  s7_pointer _p;
  s7_pointer notebook, child, menu_label;
  _p = args;
  notebook = s7_car(_p); _p = s7_cdr(_p);
  child = s7_car(_p); _p = s7_cdr(_p);
  menu_label = s7_car(_p);
  gtk_notebook_set_menu_label((GtkNotebook*)s7_c_pointer_with_type(sc, notebook, GtkNotebook__sym, __func__, 0), (GtkWidget*)s7_c_pointer_with_type(sc, child, GtkWidget__sym, __func__, 0), (GtkWidget*)s7_c_pointer_with_type(sc, menu_label, GtkWidget__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_notebook_set_menu_label_text(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_notebook_set_menu_label_text "void gtk_notebook_set_menu_label_text(GtkNotebook* notebook, \
GtkWidget* child, gchar* menu_text)"
  s7_pointer _p;
  s7_pointer notebook, child, menu_text;
  _p = args;
  notebook = s7_car(_p); _p = s7_cdr(_p);
  child = s7_car(_p); _p = s7_cdr(_p);
  menu_text = s7_car(_p);
  if (!s7_is_string(menu_text)) s7_wrong_type_arg_error(sc, "gtk_notebook_set_menu_label_text", 3, menu_text, "gchar*");
  gtk_notebook_set_menu_label_text((GtkNotebook*)s7_c_pointer_with_type(sc, notebook, GtkNotebook__sym, __func__, 0), (GtkWidget*)s7_c_pointer_with_type(sc, child, GtkWidget__sym, __func__, 0), (gchar*)s7_string(menu_text));
  return(lg_false);
}

static s7_pointer lg_gtk_notebook_get_menu_label_text(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_notebook_get_menu_label_text "gchar* gtk_notebook_get_menu_label_text(GtkNotebook* notebook, \
GtkWidget* child)"
  s7_pointer _p;
  s7_pointer notebook, child;
  _p = args;
  notebook = s7_car(_p); _p = s7_cdr(_p);
  child = s7_car(_p);
  return(s7_make_string(sc, gtk_notebook_get_menu_label_text((GtkNotebook*)s7_c_pointer_with_type(sc, notebook, GtkNotebook__sym, __func__, 0), (GtkWidget*)s7_c_pointer_with_type(sc, child, GtkWidget__sym, __func__, 0))));
}

static s7_pointer lg_gtk_notebook_reorder_child(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_notebook_reorder_child "void gtk_notebook_reorder_child(GtkNotebook* notebook, GtkWidget* child, \
gint position)"
  s7_pointer _p;
  s7_pointer notebook, child, position;
  _p = args;
  notebook = s7_car(_p); _p = s7_cdr(_p);
  child = s7_car(_p); _p = s7_cdr(_p);
  position = s7_car(_p);
  if (!s7_is_integer(position)) s7_wrong_type_arg_error(sc, "gtk_notebook_reorder_child", 3, position, "gint");
  gtk_notebook_reorder_child((GtkNotebook*)s7_c_pointer_with_type(sc, notebook, GtkNotebook__sym, __func__, 0), (GtkWidget*)s7_c_pointer_with_type(sc, child, GtkWidget__sym, __func__, 0), (gint)s7_integer(position));
  return(lg_false);
}

static s7_pointer lg_gtk_notebook_append_page(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_notebook_append_page "gint gtk_notebook_append_page(GtkNotebook* notebook, GtkWidget* child, \
GtkWidget* tab_label)"
  s7_pointer _p;
  s7_pointer notebook, child, tab_label;
  _p = args;
  notebook = s7_car(_p); _p = s7_cdr(_p);
  child = s7_car(_p); _p = s7_cdr(_p);
  tab_label = s7_car(_p);
  return(s7_make_integer(sc, gtk_notebook_append_page((GtkNotebook*)s7_c_pointer_with_type(sc, notebook, GtkNotebook__sym, __func__, 0), (GtkWidget*)s7_c_pointer_with_type(sc, child, GtkWidget__sym, __func__, 0), (GtkWidget*)s7_c_pointer_with_type(sc, tab_label, GtkWidget__sym, __func__, 0))));
}

static s7_pointer lg_gtk_notebook_append_page_menu(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_notebook_append_page_menu "gint gtk_notebook_append_page_menu(GtkNotebook* notebook, \
GtkWidget* child, GtkWidget* tab_label, GtkWidget* menu_label)"
  s7_pointer _p;
  s7_pointer notebook, child, tab_label, menu_label;
  _p = args;
  notebook = s7_car(_p); _p = s7_cdr(_p);
  child = s7_car(_p); _p = s7_cdr(_p);
  tab_label = s7_car(_p); _p = s7_cdr(_p);
  menu_label = s7_car(_p);
  return(s7_make_integer(sc, gtk_notebook_append_page_menu((GtkNotebook*)s7_c_pointer_with_type(sc, notebook, GtkNotebook__sym, __func__, 0), (GtkWidget*)s7_c_pointer_with_type(sc, child, GtkWidget__sym, __func__, 0), (GtkWidget*)s7_c_pointer_with_type(sc, tab_label, GtkWidget__sym, __func__, 0), (GtkWidget*)s7_c_pointer_with_type(sc, menu_label, GtkWidget__sym, __func__, 0))));
}

static s7_pointer lg_gtk_notebook_prepend_page(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_notebook_prepend_page "gint gtk_notebook_prepend_page(GtkNotebook* notebook, GtkWidget* child, \
GtkWidget* tab_label)"
  s7_pointer _p;
  s7_pointer notebook, child, tab_label;
  _p = args;
  notebook = s7_car(_p); _p = s7_cdr(_p);
  child = s7_car(_p); _p = s7_cdr(_p);
  tab_label = s7_car(_p);
  return(s7_make_integer(sc, gtk_notebook_prepend_page((GtkNotebook*)s7_c_pointer_with_type(sc, notebook, GtkNotebook__sym, __func__, 0), (GtkWidget*)s7_c_pointer_with_type(sc, child, GtkWidget__sym, __func__, 0), (GtkWidget*)s7_c_pointer_with_type(sc, tab_label, GtkWidget__sym, __func__, 0))));
}

static s7_pointer lg_gtk_notebook_prepend_page_menu(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_notebook_prepend_page_menu "gint gtk_notebook_prepend_page_menu(GtkNotebook* notebook, \
GtkWidget* child, GtkWidget* tab_label, GtkWidget* menu_label)"
  s7_pointer _p;
  s7_pointer notebook, child, tab_label, menu_label;
  _p = args;
  notebook = s7_car(_p); _p = s7_cdr(_p);
  child = s7_car(_p); _p = s7_cdr(_p);
  tab_label = s7_car(_p); _p = s7_cdr(_p);
  menu_label = s7_car(_p);
  return(s7_make_integer(sc, gtk_notebook_prepend_page_menu((GtkNotebook*)s7_c_pointer_with_type(sc, notebook, GtkNotebook__sym, __func__, 0), (GtkWidget*)s7_c_pointer_with_type(sc, child, GtkWidget__sym, __func__, 0), (GtkWidget*)s7_c_pointer_with_type(sc, tab_label, GtkWidget__sym, __func__, 0), (GtkWidget*)s7_c_pointer_with_type(sc, menu_label, GtkWidget__sym, __func__, 0))));
}

static s7_pointer lg_gtk_notebook_insert_page(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_notebook_insert_page "gint gtk_notebook_insert_page(GtkNotebook* notebook, GtkWidget* child, \
GtkWidget* tab_label, gint position)"
  s7_pointer _p;
  s7_pointer notebook, child, tab_label, position;
  _p = args;
  notebook = s7_car(_p); _p = s7_cdr(_p);
  child = s7_car(_p); _p = s7_cdr(_p);
  tab_label = s7_car(_p); _p = s7_cdr(_p);
  position = s7_car(_p);
  if (!s7_is_integer(position)) s7_wrong_type_arg_error(sc, "gtk_notebook_insert_page", 4, position, "gint");
  return(s7_make_integer(sc, gtk_notebook_insert_page((GtkNotebook*)s7_c_pointer_with_type(sc, notebook, GtkNotebook__sym, __func__, 0), (GtkWidget*)s7_c_pointer_with_type(sc, child, GtkWidget__sym, __func__, 0), (GtkWidget*)s7_c_pointer_with_type(sc, tab_label, GtkWidget__sym, __func__, 0), (gint)s7_integer(position))));
}

static s7_pointer lg_gtk_notebook_insert_page_menu(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_notebook_insert_page_menu "gint gtk_notebook_insert_page_menu(GtkNotebook* notebook, \
GtkWidget* child, GtkWidget* tab_label, GtkWidget* menu_label, gint position)"
  s7_pointer _p;
  s7_pointer notebook, child, tab_label, menu_label, position;
  _p = args;
  notebook = s7_car(_p); _p = s7_cdr(_p);
  child = s7_car(_p); _p = s7_cdr(_p);
  tab_label = s7_car(_p); _p = s7_cdr(_p);
  menu_label = s7_car(_p); _p = s7_cdr(_p);
  position = s7_car(_p);
  if (!s7_is_integer(position)) s7_wrong_type_arg_error(sc, "gtk_notebook_insert_page_menu", 5, position, "gint");
  return(s7_make_integer(sc, gtk_notebook_insert_page_menu((GtkNotebook*)s7_c_pointer_with_type(sc, notebook, GtkNotebook__sym, __func__, 0), (GtkWidget*)s7_c_pointer_with_type(sc, child, GtkWidget__sym, __func__, 0), (GtkWidget*)s7_c_pointer_with_type(sc, tab_label, GtkWidget__sym, __func__, 0), (GtkWidget*)s7_c_pointer_with_type(sc, menu_label, GtkWidget__sym, __func__, 0), (gint)s7_integer(position))));
}

static s7_pointer lg_gtk_progress_bar_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_progress_bar_new "GtkWidget* gtk_progress_bar_new( void)"
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_progress_bar_new()));
}

static s7_pointer lg_gtk_progress_bar_pulse(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_progress_bar_pulse "void gtk_progress_bar_pulse(GtkProgressBar* pbar)"
  s7_pointer pbar;
  pbar = s7_car(args);
  gtk_progress_bar_pulse((GtkProgressBar*)s7_c_pointer_with_type(sc, pbar, GtkProgressBar__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_progress_bar_set_text(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_progress_bar_set_text "void gtk_progress_bar_set_text(GtkProgressBar* pbar, gchar* text)"
  s7_pointer _p;
  s7_pointer pbar, text;
  _p = args;
  pbar = s7_car(_p); _p = s7_cdr(_p);
  text = s7_car(_p);
  if (!s7_is_string(text)) s7_wrong_type_arg_error(sc, "gtk_progress_bar_set_text", 2, text, "gchar*");
  gtk_progress_bar_set_text((GtkProgressBar*)s7_c_pointer_with_type(sc, pbar, GtkProgressBar__sym, __func__, 0), (gchar*)s7_string(text));
  return(lg_false);
}

static s7_pointer lg_gtk_progress_bar_set_fraction(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_progress_bar_set_fraction "void gtk_progress_bar_set_fraction(GtkProgressBar* pbar, gdouble fraction)"
  s7_pointer _p;
  s7_pointer pbar, fraction;
  _p = args;
  pbar = s7_car(_p); _p = s7_cdr(_p);
  fraction = s7_car(_p);
  if (!s7_is_real(fraction)) s7_wrong_type_arg_error(sc, "gtk_progress_bar_set_fraction", 2, fraction, "gdouble");
  gtk_progress_bar_set_fraction((GtkProgressBar*)s7_c_pointer_with_type(sc, pbar, GtkProgressBar__sym, __func__, 0), (gdouble)s7_real(fraction));
  return(lg_false);
}

static s7_pointer lg_gtk_progress_bar_set_pulse_step(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_progress_bar_set_pulse_step "void gtk_progress_bar_set_pulse_step(GtkProgressBar* pbar, \
gdouble fraction)"
  s7_pointer _p;
  s7_pointer pbar, fraction;
  _p = args;
  pbar = s7_car(_p); _p = s7_cdr(_p);
  fraction = s7_car(_p);
  if (!s7_is_real(fraction)) s7_wrong_type_arg_error(sc, "gtk_progress_bar_set_pulse_step", 2, fraction, "gdouble");
  gtk_progress_bar_set_pulse_step((GtkProgressBar*)s7_c_pointer_with_type(sc, pbar, GtkProgressBar__sym, __func__, 0), (gdouble)s7_real(fraction));
  return(lg_false);
}

static s7_pointer lg_gtk_progress_bar_get_text(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_progress_bar_get_text "gchar* gtk_progress_bar_get_text(GtkProgressBar* pbar)"
  s7_pointer pbar;
  pbar = s7_car(args);
  return(s7_make_string(sc, gtk_progress_bar_get_text((GtkProgressBar*)s7_c_pointer_with_type(sc, pbar, GtkProgressBar__sym, __func__, 0))));
}

static s7_pointer lg_gtk_progress_bar_get_fraction(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_progress_bar_get_fraction "gdouble gtk_progress_bar_get_fraction(GtkProgressBar* pbar)"
  s7_pointer pbar;
  pbar = s7_car(args);
  return(s7_make_real(sc, gtk_progress_bar_get_fraction((GtkProgressBar*)s7_c_pointer_with_type(sc, pbar, GtkProgressBar__sym, __func__, 0))));
}

static s7_pointer lg_gtk_progress_bar_get_pulse_step(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_progress_bar_get_pulse_step "gdouble gtk_progress_bar_get_pulse_step(GtkProgressBar* pbar)"
  s7_pointer pbar;
  pbar = s7_car(args);
  return(s7_make_real(sc, gtk_progress_bar_get_pulse_step((GtkProgressBar*)s7_c_pointer_with_type(sc, pbar, GtkProgressBar__sym, __func__, 0))));
}

static s7_pointer lg_gtk_radio_button_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_radio_button_new "GtkWidget* gtk_radio_button_new(GSList* group)"
  s7_pointer group;
  group = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_radio_button_new((GSList*)s7_c_pointer_with_type(sc, group, GSList__sym, __func__, 0))));
}

static s7_pointer lg_gtk_radio_button_new_from_widget(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_radio_button_new_from_widget "GtkWidget* gtk_radio_button_new_from_widget(GtkRadioButton* group)"
  s7_pointer group;
  group = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_radio_button_new_from_widget((GtkRadioButton*)s7_c_pointer_with_type(sc, group, GtkRadioButton__sym, __func__, 0))));
}

static s7_pointer lg_gtk_radio_button_new_with_label(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_radio_button_new_with_label "GtkWidget* gtk_radio_button_new_with_label(GSList* group, \
gchar* label)"
  s7_pointer _p;
  s7_pointer group, label;
  _p = args;
  group = s7_car(_p); _p = s7_cdr(_p);
  label = s7_car(_p);
  if (!s7_is_string(label)) s7_wrong_type_arg_error(sc, "gtk_radio_button_new_with_label", 2, label, "gchar*");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_radio_button_new_with_label((GSList*)s7_c_pointer_with_type(sc, group, GSList__sym, __func__, 0), (gchar*)s7_string(label))));
}

static s7_pointer lg_gtk_radio_button_new_with_label_from_widget(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_radio_button_new_with_label_from_widget "GtkWidget* gtk_radio_button_new_with_label_from_widget(GtkRadioButton* group, \
gchar* label)"
  s7_pointer _p;
  s7_pointer group, label;
  _p = args;
  group = s7_car(_p); _p = s7_cdr(_p);
  label = s7_car(_p);
  if (!s7_is_string(label)) s7_wrong_type_arg_error(sc, "gtk_radio_button_new_with_label_from_widget", 2, label, "gchar*");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_radio_button_new_with_label_from_widget((GtkRadioButton*)s7_c_pointer_with_type(sc, group, GtkRadioButton__sym, __func__, 0), (gchar*)s7_string(label))));
}

static s7_pointer lg_gtk_radio_button_new_with_mnemonic(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_radio_button_new_with_mnemonic "GtkWidget* gtk_radio_button_new_with_mnemonic(GSList* group, \
gchar* label)"
  s7_pointer _p;
  s7_pointer group, label;
  _p = args;
  group = s7_car(_p); _p = s7_cdr(_p);
  label = s7_car(_p);
  if (!s7_is_string(label)) s7_wrong_type_arg_error(sc, "gtk_radio_button_new_with_mnemonic", 2, label, "gchar*");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_radio_button_new_with_mnemonic((GSList*)s7_c_pointer_with_type(sc, group, GSList__sym, __func__, 0), (gchar*)s7_string(label))));
}

static s7_pointer lg_gtk_radio_button_new_with_mnemonic_from_widget(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_radio_button_new_with_mnemonic_from_widget "GtkWidget* gtk_radio_button_new_with_mnemonic_from_widget(GtkRadioButton* group, \
gchar* label)"
  s7_pointer _p;
  s7_pointer group, label;
  _p = args;
  group = s7_car(_p); _p = s7_cdr(_p);
  label = s7_car(_p);
  if (!s7_is_string(label)) s7_wrong_type_arg_error(sc, "gtk_radio_button_new_with_mnemonic_from_widget", 2, label, "gchar*");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_radio_button_new_with_mnemonic_from_widget((GtkRadioButton*)s7_c_pointer_with_type(sc, group, GtkRadioButton__sym, __func__, 0), (gchar*)s7_string(label))));
}

static s7_pointer lg_gtk_radio_button_get_group(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_radio_button_get_group "GSList* gtk_radio_button_get_group(GtkRadioButton* radio_button)"
  s7_pointer radio_button;
  radio_button = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GSList__sym, gtk_radio_button_get_group((GtkRadioButton*)s7_c_pointer_with_type(sc, radio_button, GtkRadioButton__sym, __func__, 0))));
}

static s7_pointer lg_gtk_radio_button_set_group(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_radio_button_set_group "void gtk_radio_button_set_group(GtkRadioButton* radio_button, \
GSList* group)"
  s7_pointer _p;
  s7_pointer radio_button, group;
  _p = args;
  radio_button = s7_car(_p); _p = s7_cdr(_p);
  group = s7_car(_p);
  gtk_radio_button_set_group((GtkRadioButton*)s7_c_pointer_with_type(sc, radio_button, GtkRadioButton__sym, __func__, 0), (GSList*)s7_c_pointer_with_type(sc, group, GSList__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_range_set_adjustment(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_range_set_adjustment "void gtk_range_set_adjustment(GtkRange* range, GtkAdjustment* adjustment)"
  s7_pointer _p;
  s7_pointer range, adjustment;
  _p = args;
  range = s7_car(_p); _p = s7_cdr(_p);
  adjustment = s7_car(_p);
  gtk_range_set_adjustment((GtkRange*)s7_c_pointer_with_type(sc, range, GtkRange__sym, __func__, 0), (GtkAdjustment*)s7_c_pointer_with_type(sc, adjustment, GtkAdjustment__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_range_get_adjustment(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_range_get_adjustment "GtkAdjustment* gtk_range_get_adjustment(GtkRange* range)"
  s7_pointer range;
  range = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GtkAdjustment__sym, gtk_range_get_adjustment((GtkRange*)s7_c_pointer_with_type(sc, range, GtkRange__sym, __func__, 0))));
}

static s7_pointer lg_gtk_range_set_inverted(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_range_set_inverted "void gtk_range_set_inverted(GtkRange* range, gboolean setting)"
  s7_pointer _p;
  s7_pointer range, setting;
  _p = args;
  range = s7_car(_p); _p = s7_cdr(_p);
  setting = s7_car(_p);
  if (!s7_is_boolean(setting)) s7_wrong_type_arg_error(sc, "gtk_range_set_inverted", 2, setting, "gboolean");
  gtk_range_set_inverted((GtkRange*)s7_c_pointer_with_type(sc, range, GtkRange__sym, __func__, 0), (gboolean)lg_boolean(setting));
  return(lg_false);
}

static s7_pointer lg_gtk_range_get_inverted(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_range_get_inverted "gboolean gtk_range_get_inverted(GtkRange* range)"
  s7_pointer range;
  range = s7_car(args);
  return(s7_make_boolean(sc, gtk_range_get_inverted((GtkRange*)s7_c_pointer_with_type(sc, range, GtkRange__sym, __func__, 0))));
}

static s7_pointer lg_gtk_range_set_increments(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_range_set_increments "void gtk_range_set_increments(GtkRange* range, gdouble step, gdouble page)"
  s7_pointer _p;
  s7_pointer range, step, page;
  _p = args;
  range = s7_car(_p); _p = s7_cdr(_p);
  step = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(step)) s7_wrong_type_arg_error(sc, "gtk_range_set_increments", 2, step, "gdouble");
  page = s7_car(_p);
  if (!s7_is_real(page)) s7_wrong_type_arg_error(sc, "gtk_range_set_increments", 3, page, "gdouble");
  gtk_range_set_increments((GtkRange*)s7_c_pointer_with_type(sc, range, GtkRange__sym, __func__, 0), (gdouble)s7_real(step), (gdouble)s7_real(page));
  return(lg_false);
}

static s7_pointer lg_gtk_range_set_range(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_range_set_range "void gtk_range_set_range(GtkRange* range, gdouble min, gdouble max)"
  s7_pointer _p;
  s7_pointer range, min, max;
  _p = args;
  range = s7_car(_p); _p = s7_cdr(_p);
  min = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(min)) s7_wrong_type_arg_error(sc, "gtk_range_set_range", 2, min, "gdouble");
  max = s7_car(_p);
  if (!s7_is_real(max)) s7_wrong_type_arg_error(sc, "gtk_range_set_range", 3, max, "gdouble");
  gtk_range_set_range((GtkRange*)s7_c_pointer_with_type(sc, range, GtkRange__sym, __func__, 0), (gdouble)s7_real(min), (gdouble)s7_real(max));
  return(lg_false);
}

static s7_pointer lg_gtk_range_set_value(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_range_set_value "void gtk_range_set_value(GtkRange* range, gdouble value)"
  s7_pointer _p;
  s7_pointer range, value;
  _p = args;
  range = s7_car(_p); _p = s7_cdr(_p);
  value = s7_car(_p);
  if (!s7_is_real(value)) s7_wrong_type_arg_error(sc, "gtk_range_set_value", 2, value, "gdouble");
  gtk_range_set_value((GtkRange*)s7_c_pointer_with_type(sc, range, GtkRange__sym, __func__, 0), (gdouble)s7_real(value));
  return(lg_false);
}

static s7_pointer lg_gtk_range_get_value(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_range_get_value "gdouble gtk_range_get_value(GtkRange* range)"
  s7_pointer range;
  range = s7_car(args);
  return(s7_make_real(sc, gtk_range_get_value((GtkRange*)s7_c_pointer_with_type(sc, range, GtkRange__sym, __func__, 0))));
}

static s7_pointer lg_gtk_scale_set_digits(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_scale_set_digits "void gtk_scale_set_digits(GtkScale* scale, gint digits)"
  s7_pointer _p;
  s7_pointer scale, digits;
  _p = args;
  scale = s7_car(_p); _p = s7_cdr(_p);
  digits = s7_car(_p);
  if (!s7_is_integer(digits)) s7_wrong_type_arg_error(sc, "gtk_scale_set_digits", 2, digits, "gint");
  gtk_scale_set_digits((GtkScale*)s7_c_pointer_with_type(sc, scale, GtkScale__sym, __func__, 0), (gint)s7_integer(digits));
  return(lg_false);
}

static s7_pointer lg_gtk_scale_get_digits(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_scale_get_digits "gint gtk_scale_get_digits(GtkScale* scale)"
  s7_pointer scale;
  scale = s7_car(args);
  return(s7_make_integer(sc, gtk_scale_get_digits((GtkScale*)s7_c_pointer_with_type(sc, scale, GtkScale__sym, __func__, 0))));
}

static s7_pointer lg_gtk_scale_set_draw_value(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_scale_set_draw_value "void gtk_scale_set_draw_value(GtkScale* scale, gboolean draw_value)"
  s7_pointer _p;
  s7_pointer scale, draw_value;
  _p = args;
  scale = s7_car(_p); _p = s7_cdr(_p);
  draw_value = s7_car(_p);
  if (!s7_is_boolean(draw_value)) s7_wrong_type_arg_error(sc, "gtk_scale_set_draw_value", 2, draw_value, "gboolean");
  gtk_scale_set_draw_value((GtkScale*)s7_c_pointer_with_type(sc, scale, GtkScale__sym, __func__, 0), (gboolean)lg_boolean(draw_value));
  return(lg_false);
}

static s7_pointer lg_gtk_scale_get_draw_value(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_scale_get_draw_value "gboolean gtk_scale_get_draw_value(GtkScale* scale)"
  s7_pointer scale;
  scale = s7_car(args);
  return(s7_make_boolean(sc, gtk_scale_get_draw_value((GtkScale*)s7_c_pointer_with_type(sc, scale, GtkScale__sym, __func__, 0))));
}

static s7_pointer lg_gtk_scale_set_value_pos(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_scale_set_value_pos "void gtk_scale_set_value_pos(GtkScale* scale, GtkPositionType pos)"
  s7_pointer _p;
  s7_pointer scale, pos;
  _p = args;
  scale = s7_car(_p); _p = s7_cdr(_p);
  pos = s7_car(_p);
  if (!s7_is_integer(pos)) s7_wrong_type_arg_error(sc, "gtk_scale_set_value_pos", 2, pos, "GtkPositionType");
  gtk_scale_set_value_pos((GtkScale*)s7_c_pointer_with_type(sc, scale, GtkScale__sym, __func__, 0), (GtkPositionType)s7_integer(pos));
  return(lg_false);
}

static s7_pointer lg_gtk_scale_get_value_pos(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_scale_get_value_pos "GtkPositionType gtk_scale_get_value_pos(GtkScale* scale)"
  s7_pointer scale;
  scale = s7_car(args);
  return(s7_make_integer(sc, gtk_scale_get_value_pos((GtkScale*)s7_c_pointer_with_type(sc, scale, GtkScale__sym, __func__, 0))));
}

static s7_pointer lg_gtk_scrolled_window_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_scrolled_window_new "GtkWidget* gtk_scrolled_window_new(GtkAdjustment* hadjustment, GtkAdjustment* vadjustment)"
  s7_pointer _p;
  s7_pointer hadjustment, vadjustment;
  _p = args;
  hadjustment = s7_car(_p); _p = s7_cdr(_p);
  vadjustment = s7_car(_p);
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_scrolled_window_new((GtkAdjustment*)s7_c_pointer_with_type(sc, hadjustment, GtkAdjustment__sym, __func__, 0), (GtkAdjustment*)s7_c_pointer_with_type(sc, vadjustment, GtkAdjustment__sym, __func__, 0))));
}

static s7_pointer lg_gtk_scrolled_window_set_hadjustment(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_scrolled_window_set_hadjustment "void gtk_scrolled_window_set_hadjustment(GtkScrolledWindow* scrolled_window, \
GtkAdjustment* hadjustment)"
  s7_pointer _p;
  s7_pointer scrolled_window, hadjustment;
  _p = args;
  scrolled_window = s7_car(_p); _p = s7_cdr(_p);
  hadjustment = s7_car(_p);
  gtk_scrolled_window_set_hadjustment((GtkScrolledWindow*)s7_c_pointer_with_type(sc, scrolled_window, GtkScrolledWindow__sym, __func__, 0), (GtkAdjustment*)s7_c_pointer_with_type(sc, hadjustment, GtkAdjustment__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_scrolled_window_set_vadjustment(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_scrolled_window_set_vadjustment "void gtk_scrolled_window_set_vadjustment(GtkScrolledWindow* scrolled_window, \
GtkAdjustment* hadjustment)"
  s7_pointer _p;
  s7_pointer scrolled_window, hadjustment;
  _p = args;
  scrolled_window = s7_car(_p); _p = s7_cdr(_p);
  hadjustment = s7_car(_p);
  gtk_scrolled_window_set_vadjustment((GtkScrolledWindow*)s7_c_pointer_with_type(sc, scrolled_window, GtkScrolledWindow__sym, __func__, 0), (GtkAdjustment*)s7_c_pointer_with_type(sc, hadjustment, GtkAdjustment__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_scrolled_window_get_hadjustment(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_scrolled_window_get_hadjustment "GtkAdjustment* gtk_scrolled_window_get_hadjustment(GtkScrolledWindow* scrolled_window)"
  s7_pointer scrolled_window;
  scrolled_window = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GtkAdjustment__sym, gtk_scrolled_window_get_hadjustment((GtkScrolledWindow*)s7_c_pointer_with_type(sc, scrolled_window, GtkScrolledWindow__sym, __func__, 0))));
}

static s7_pointer lg_gtk_scrolled_window_get_vadjustment(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_scrolled_window_get_vadjustment "GtkAdjustment* gtk_scrolled_window_get_vadjustment(GtkScrolledWindow* scrolled_window)"
  s7_pointer scrolled_window;
  scrolled_window = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GtkAdjustment__sym, gtk_scrolled_window_get_vadjustment((GtkScrolledWindow*)s7_c_pointer_with_type(sc, scrolled_window, GtkScrolledWindow__sym, __func__, 0))));
}

static s7_pointer lg_gtk_scrolled_window_set_policy(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_scrolled_window_set_policy "void gtk_scrolled_window_set_policy(GtkScrolledWindow* scrolled_window, \
GtkPolicyType hscrollbar_policy, GtkPolicyType vscrollbar_policy)"
  s7_pointer _p;
  s7_pointer scrolled_window, hscrollbar_policy, vscrollbar_policy;
  _p = args;
  scrolled_window = s7_car(_p); _p = s7_cdr(_p);
  hscrollbar_policy = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(hscrollbar_policy)) s7_wrong_type_arg_error(sc, "gtk_scrolled_window_set_policy", 2, hscrollbar_policy, "GtkPolicyType");
  vscrollbar_policy = s7_car(_p);
  if (!s7_is_integer(vscrollbar_policy)) s7_wrong_type_arg_error(sc, "gtk_scrolled_window_set_policy", 3, vscrollbar_policy, "GtkPolicyType");
  gtk_scrolled_window_set_policy((GtkScrolledWindow*)s7_c_pointer_with_type(sc, scrolled_window, GtkScrolledWindow__sym, __func__, 0), (GtkPolicyType)s7_integer(hscrollbar_policy), (GtkPolicyType)s7_integer(vscrollbar_policy));
  return(lg_false);
}

static s7_pointer lg_gtk_scrolled_window_get_policy(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_scrolled_window_get_policy "void gtk_scrolled_window_get_policy(GtkScrolledWindow* scrolled_window, \
GtkPolicyType* [hscrollbar_policy], GtkPolicyType* [vscrollbar_policy])"
  s7_pointer _p;
  s7_pointer scrolled_window;
  GtkPolicyType ref_hscrollbar_policy;
  GtkPolicyType ref_vscrollbar_policy;
  _p = args;
  scrolled_window = s7_car(_p);
  gtk_scrolled_window_get_policy((GtkScrolledWindow*)s7_c_pointer_with_type(sc, scrolled_window, GtkScrolledWindow__sym, __func__, 0), &ref_hscrollbar_policy, &ref_vscrollbar_policy);
    return(s7_list(sc, 2, s7_make_integer(sc, ref_hscrollbar_policy), s7_make_integer(sc, ref_vscrollbar_policy)));
}

static s7_pointer lg_gtk_scrolled_window_set_placement(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_scrolled_window_set_placement "void gtk_scrolled_window_set_placement(GtkScrolledWindow* scrolled_window, \
GtkCornerType window_placement)"
  s7_pointer _p;
  s7_pointer scrolled_window, window_placement;
  _p = args;
  scrolled_window = s7_car(_p); _p = s7_cdr(_p);
  window_placement = s7_car(_p);
  if (!s7_is_integer(window_placement)) s7_wrong_type_arg_error(sc, "gtk_scrolled_window_set_placement", 2, window_placement, "GtkCornerType");
  gtk_scrolled_window_set_placement((GtkScrolledWindow*)s7_c_pointer_with_type(sc, scrolled_window, GtkScrolledWindow__sym, __func__, 0), (GtkCornerType)s7_integer(window_placement));
  return(lg_false);
}

static s7_pointer lg_gtk_scrolled_window_get_placement(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_scrolled_window_get_placement "GtkCornerType gtk_scrolled_window_get_placement(GtkScrolledWindow* scrolled_window)"
  s7_pointer scrolled_window;
  scrolled_window = s7_car(args);
  return(s7_make_integer(sc, gtk_scrolled_window_get_placement((GtkScrolledWindow*)s7_c_pointer_with_type(sc, scrolled_window, GtkScrolledWindow__sym, __func__, 0))));
}

static s7_pointer lg_gtk_settings_get_default(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_settings_get_default "GtkSettings* gtk_settings_get_default( void)"
  return(lg_make_c_pointer_with_type(sc, GtkSettings__sym, gtk_settings_get_default()));
}

static s7_pointer lg_gtk_size_group_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_size_group_new "GtkSizeGroup* gtk_size_group_new(GtkSizeGroupMode mode)"
  s7_pointer mode;
  mode = s7_car(args);
  if (!s7_is_integer(mode)) s7_wrong_type_arg_error(sc, "gtk_size_group_new", 1, mode, "GtkSizeGroupMode");
  return(lg_make_c_pointer_with_type(sc, GtkSizeGroup__sym, gtk_size_group_new((GtkSizeGroupMode)s7_integer(mode))));
}

static s7_pointer lg_gtk_size_group_set_mode(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_size_group_set_mode "void gtk_size_group_set_mode(GtkSizeGroup* size_group, GtkSizeGroupMode mode)"
  s7_pointer _p;
  s7_pointer size_group, mode;
  _p = args;
  size_group = s7_car(_p); _p = s7_cdr(_p);
  mode = s7_car(_p);
  if (!s7_is_integer(mode)) s7_wrong_type_arg_error(sc, "gtk_size_group_set_mode", 2, mode, "GtkSizeGroupMode");
  gtk_size_group_set_mode((GtkSizeGroup*)s7_c_pointer_with_type(sc, size_group, GtkSizeGroup__sym, __func__, 0), (GtkSizeGroupMode)s7_integer(mode));
  return(lg_false);
}

static s7_pointer lg_gtk_size_group_get_mode(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_size_group_get_mode "GtkSizeGroupMode gtk_size_group_get_mode(GtkSizeGroup* size_group)"
  s7_pointer size_group;
  size_group = s7_car(args);
  return(s7_make_integer(sc, gtk_size_group_get_mode((GtkSizeGroup*)s7_c_pointer_with_type(sc, size_group, GtkSizeGroup__sym, __func__, 0))));
}

static s7_pointer lg_gtk_size_group_add_widget(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_size_group_add_widget "void gtk_size_group_add_widget(GtkSizeGroup* size_group, GtkWidget* widget)"
  s7_pointer _p;
  s7_pointer size_group, widget;
  _p = args;
  size_group = s7_car(_p); _p = s7_cdr(_p);
  widget = s7_car(_p);
  gtk_size_group_add_widget((GtkSizeGroup*)s7_c_pointer_with_type(sc, size_group, GtkSizeGroup__sym, __func__, 0), (GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_size_group_remove_widget(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_size_group_remove_widget "void gtk_size_group_remove_widget(GtkSizeGroup* size_group, \
GtkWidget* widget)"
  s7_pointer _p;
  s7_pointer size_group, widget;
  _p = args;
  size_group = s7_car(_p); _p = s7_cdr(_p);
  widget = s7_car(_p);
  gtk_size_group_remove_widget((GtkSizeGroup*)s7_c_pointer_with_type(sc, size_group, GtkSizeGroup__sym, __func__, 0), (GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_spin_button_configure(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_spin_button_configure "void gtk_spin_button_configure(GtkSpinButton* spin_button, GtkAdjustment* adjustment, \
gdouble climb_rate, guint digits)"
  s7_pointer _p;
  s7_pointer spin_button, adjustment, climb_rate, digits;
  _p = args;
  spin_button = s7_car(_p); _p = s7_cdr(_p);
  adjustment = s7_car(_p); _p = s7_cdr(_p);
  climb_rate = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(climb_rate)) s7_wrong_type_arg_error(sc, "gtk_spin_button_configure", 3, climb_rate, "gdouble");
  digits = s7_car(_p);
  if (!s7_is_integer(digits)) s7_wrong_type_arg_error(sc, "gtk_spin_button_configure", 4, digits, "guint");
  gtk_spin_button_configure((GtkSpinButton*)s7_c_pointer_with_type(sc, spin_button, GtkSpinButton__sym, __func__, 0), (GtkAdjustment*)s7_c_pointer_with_type(sc, adjustment, GtkAdjustment__sym, __func__, 0), (gdouble)s7_real(climb_rate), (guint)s7_integer(digits));
  return(lg_false);
}

static s7_pointer lg_gtk_spin_button_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_spin_button_new "GtkWidget* gtk_spin_button_new(GtkAdjustment* adjustment, gdouble climb_rate, \
guint digits)"
  s7_pointer _p;
  s7_pointer adjustment, climb_rate, digits;
  _p = args;
  adjustment = s7_car(_p); _p = s7_cdr(_p);
  climb_rate = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(climb_rate)) s7_wrong_type_arg_error(sc, "gtk_spin_button_new", 2, climb_rate, "gdouble");
  digits = s7_car(_p);
  if (!s7_is_integer(digits)) s7_wrong_type_arg_error(sc, "gtk_spin_button_new", 3, digits, "guint");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_spin_button_new((GtkAdjustment*)s7_c_pointer_with_type(sc, adjustment, GtkAdjustment__sym, __func__, 0), (gdouble)s7_real(climb_rate), (guint)s7_integer(digits))));
}

static s7_pointer lg_gtk_spin_button_new_with_range(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_spin_button_new_with_range "GtkWidget* gtk_spin_button_new_with_range(gdouble min, gdouble max, \
gdouble step)"
  s7_pointer _p;
  s7_pointer min, max, step;
  _p = args;
  min = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(min)) s7_wrong_type_arg_error(sc, "gtk_spin_button_new_with_range", 1, min, "gdouble");
  max = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(max)) s7_wrong_type_arg_error(sc, "gtk_spin_button_new_with_range", 2, max, "gdouble");
  step = s7_car(_p);
  if (!s7_is_real(step)) s7_wrong_type_arg_error(sc, "gtk_spin_button_new_with_range", 3, step, "gdouble");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_spin_button_new_with_range((gdouble)s7_real(min), (gdouble)s7_real(max), (gdouble)s7_real(step))));
}

static s7_pointer lg_gtk_spin_button_set_adjustment(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_spin_button_set_adjustment "void gtk_spin_button_set_adjustment(GtkSpinButton* spin_button, \
GtkAdjustment* adjustment)"
  s7_pointer _p;
  s7_pointer spin_button, adjustment;
  _p = args;
  spin_button = s7_car(_p); _p = s7_cdr(_p);
  adjustment = s7_car(_p);
  gtk_spin_button_set_adjustment((GtkSpinButton*)s7_c_pointer_with_type(sc, spin_button, GtkSpinButton__sym, __func__, 0), (GtkAdjustment*)s7_c_pointer_with_type(sc, adjustment, GtkAdjustment__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_spin_button_get_adjustment(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_spin_button_get_adjustment "GtkAdjustment* gtk_spin_button_get_adjustment(GtkSpinButton* spin_button)"
  s7_pointer spin_button;
  spin_button = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GtkAdjustment__sym, gtk_spin_button_get_adjustment((GtkSpinButton*)s7_c_pointer_with_type(sc, spin_button, GtkSpinButton__sym, __func__, 0))));
}

static s7_pointer lg_gtk_spin_button_set_digits(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_spin_button_set_digits "void gtk_spin_button_set_digits(GtkSpinButton* spin_button, guint digits)"
  s7_pointer _p;
  s7_pointer spin_button, digits;
  _p = args;
  spin_button = s7_car(_p); _p = s7_cdr(_p);
  digits = s7_car(_p);
  if (!s7_is_integer(digits)) s7_wrong_type_arg_error(sc, "gtk_spin_button_set_digits", 2, digits, "guint");
  gtk_spin_button_set_digits((GtkSpinButton*)s7_c_pointer_with_type(sc, spin_button, GtkSpinButton__sym, __func__, 0), (guint)s7_integer(digits));
  return(lg_false);
}

static s7_pointer lg_gtk_spin_button_get_digits(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_spin_button_get_digits "guint gtk_spin_button_get_digits(GtkSpinButton* spin_button)"
  s7_pointer spin_button;
  spin_button = s7_car(args);
  return(s7_make_integer(sc, gtk_spin_button_get_digits((GtkSpinButton*)s7_c_pointer_with_type(sc, spin_button, GtkSpinButton__sym, __func__, 0))));
}

static s7_pointer lg_gtk_spin_button_set_increments(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_spin_button_set_increments "void gtk_spin_button_set_increments(GtkSpinButton* spin_button, \
gdouble step, gdouble page)"
  s7_pointer _p;
  s7_pointer spin_button, step, page;
  _p = args;
  spin_button = s7_car(_p); _p = s7_cdr(_p);
  step = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(step)) s7_wrong_type_arg_error(sc, "gtk_spin_button_set_increments", 2, step, "gdouble");
  page = s7_car(_p);
  if (!s7_is_real(page)) s7_wrong_type_arg_error(sc, "gtk_spin_button_set_increments", 3, page, "gdouble");
  gtk_spin_button_set_increments((GtkSpinButton*)s7_c_pointer_with_type(sc, spin_button, GtkSpinButton__sym, __func__, 0), (gdouble)s7_real(step), (gdouble)s7_real(page));
  return(lg_false);
}

static s7_pointer lg_gtk_spin_button_get_increments(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_spin_button_get_increments "void gtk_spin_button_get_increments(GtkSpinButton* spin_button, \
gdouble* [step], gdouble* [page])"
  s7_pointer _p;
  s7_pointer spin_button;
  gdouble ref_step;
  gdouble ref_page;
  _p = args;
  spin_button = s7_car(_p);
  gtk_spin_button_get_increments((GtkSpinButton*)s7_c_pointer_with_type(sc, spin_button, GtkSpinButton__sym, __func__, 0), &ref_step, &ref_page);
    return(s7_list(sc, 2, s7_make_real(sc, ref_step), s7_make_real(sc, ref_page)));
}

static s7_pointer lg_gtk_spin_button_set_range(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_spin_button_set_range "void gtk_spin_button_set_range(GtkSpinButton* spin_button, gdouble min, \
gdouble max)"
  s7_pointer _p;
  s7_pointer spin_button, min, max;
  _p = args;
  spin_button = s7_car(_p); _p = s7_cdr(_p);
  min = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(min)) s7_wrong_type_arg_error(sc, "gtk_spin_button_set_range", 2, min, "gdouble");
  max = s7_car(_p);
  if (!s7_is_real(max)) s7_wrong_type_arg_error(sc, "gtk_spin_button_set_range", 3, max, "gdouble");
  gtk_spin_button_set_range((GtkSpinButton*)s7_c_pointer_with_type(sc, spin_button, GtkSpinButton__sym, __func__, 0), (gdouble)s7_real(min), (gdouble)s7_real(max));
  return(lg_false);
}

static s7_pointer lg_gtk_spin_button_get_range(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_spin_button_get_range "void gtk_spin_button_get_range(GtkSpinButton* spin_button, gdouble* [min], \
gdouble* [max])"
  s7_pointer _p;
  s7_pointer spin_button;
  gdouble ref_min;
  gdouble ref_max;
  _p = args;
  spin_button = s7_car(_p);
  gtk_spin_button_get_range((GtkSpinButton*)s7_c_pointer_with_type(sc, spin_button, GtkSpinButton__sym, __func__, 0), &ref_min, &ref_max);
    return(s7_list(sc, 2, s7_make_real(sc, ref_min), s7_make_real(sc, ref_max)));
}

static s7_pointer lg_gtk_spin_button_get_value(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_spin_button_get_value "gdouble gtk_spin_button_get_value(GtkSpinButton* spin_button)"
  s7_pointer spin_button;
  spin_button = s7_car(args);
  return(s7_make_real(sc, gtk_spin_button_get_value((GtkSpinButton*)s7_c_pointer_with_type(sc, spin_button, GtkSpinButton__sym, __func__, 0))));
}

static s7_pointer lg_gtk_spin_button_get_value_as_int(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_spin_button_get_value_as_int "gint gtk_spin_button_get_value_as_int(GtkSpinButton* spin_button)"
  s7_pointer spin_button;
  spin_button = s7_car(args);
  return(s7_make_integer(sc, gtk_spin_button_get_value_as_int((GtkSpinButton*)s7_c_pointer_with_type(sc, spin_button, GtkSpinButton__sym, __func__, 0))));
}

static s7_pointer lg_gtk_spin_button_set_value(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_spin_button_set_value "void gtk_spin_button_set_value(GtkSpinButton* spin_button, gdouble value)"
  s7_pointer _p;
  s7_pointer spin_button, value;
  _p = args;
  spin_button = s7_car(_p); _p = s7_cdr(_p);
  value = s7_car(_p);
  if (!s7_is_real(value)) s7_wrong_type_arg_error(sc, "gtk_spin_button_set_value", 2, value, "gdouble");
  gtk_spin_button_set_value((GtkSpinButton*)s7_c_pointer_with_type(sc, spin_button, GtkSpinButton__sym, __func__, 0), (gdouble)s7_real(value));
  return(lg_false);
}

static s7_pointer lg_gtk_spin_button_set_update_policy(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_spin_button_set_update_policy "void gtk_spin_button_set_update_policy(GtkSpinButton* spin_button, \
GtkSpinButtonUpdatePolicy policy)"
  s7_pointer _p;
  s7_pointer spin_button, policy;
  _p = args;
  spin_button = s7_car(_p); _p = s7_cdr(_p);
  policy = s7_car(_p);
  if (!s7_is_integer(policy)) s7_wrong_type_arg_error(sc, "gtk_spin_button_set_update_policy", 2, policy, "GtkSpinButtonUpdatePolicy");
  gtk_spin_button_set_update_policy((GtkSpinButton*)s7_c_pointer_with_type(sc, spin_button, GtkSpinButton__sym, __func__, 0), (GtkSpinButtonUpdatePolicy)s7_integer(policy));
  return(lg_false);
}

static s7_pointer lg_gtk_spin_button_get_update_policy(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_spin_button_get_update_policy "GtkSpinButtonUpdatePolicy gtk_spin_button_get_update_policy(GtkSpinButton* spin_button)"
  s7_pointer spin_button;
  spin_button = s7_car(args);
  return(s7_make_integer(sc, gtk_spin_button_get_update_policy((GtkSpinButton*)s7_c_pointer_with_type(sc, spin_button, GtkSpinButton__sym, __func__, 0))));
}

static s7_pointer lg_gtk_spin_button_set_numeric(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_spin_button_set_numeric "void gtk_spin_button_set_numeric(GtkSpinButton* spin_button, \
gboolean numeric)"
  s7_pointer _p;
  s7_pointer spin_button, numeric;
  _p = args;
  spin_button = s7_car(_p); _p = s7_cdr(_p);
  numeric = s7_car(_p);
  if (!s7_is_boolean(numeric)) s7_wrong_type_arg_error(sc, "gtk_spin_button_set_numeric", 2, numeric, "gboolean");
  gtk_spin_button_set_numeric((GtkSpinButton*)s7_c_pointer_with_type(sc, spin_button, GtkSpinButton__sym, __func__, 0), (gboolean)lg_boolean(numeric));
  return(lg_false);
}

static s7_pointer lg_gtk_spin_button_get_numeric(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_spin_button_get_numeric "gboolean gtk_spin_button_get_numeric(GtkSpinButton* spin_button)"
  s7_pointer spin_button;
  spin_button = s7_car(args);
  return(s7_make_boolean(sc, gtk_spin_button_get_numeric((GtkSpinButton*)s7_c_pointer_with_type(sc, spin_button, GtkSpinButton__sym, __func__, 0))));
}

static s7_pointer lg_gtk_spin_button_spin(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_spin_button_spin "void gtk_spin_button_spin(GtkSpinButton* spin_button, GtkSpinType direction, \
gdouble increment)"
  s7_pointer _p;
  s7_pointer spin_button, direction, increment;
  _p = args;
  spin_button = s7_car(_p); _p = s7_cdr(_p);
  direction = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(direction)) s7_wrong_type_arg_error(sc, "gtk_spin_button_spin", 2, direction, "GtkSpinType");
  increment = s7_car(_p);
  if (!s7_is_real(increment)) s7_wrong_type_arg_error(sc, "gtk_spin_button_spin", 3, increment, "gdouble");
  gtk_spin_button_spin((GtkSpinButton*)s7_c_pointer_with_type(sc, spin_button, GtkSpinButton__sym, __func__, 0), (GtkSpinType)s7_integer(direction), (gdouble)s7_real(increment));
  return(lg_false);
}

static s7_pointer lg_gtk_spin_button_set_wrap(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_spin_button_set_wrap "void gtk_spin_button_set_wrap(GtkSpinButton* spin_button, gboolean wrap)"
  s7_pointer _p;
  s7_pointer spin_button, wrap;
  _p = args;
  spin_button = s7_car(_p); _p = s7_cdr(_p);
  wrap = s7_car(_p);
  if (!s7_is_boolean(wrap)) s7_wrong_type_arg_error(sc, "gtk_spin_button_set_wrap", 2, wrap, "gboolean");
  gtk_spin_button_set_wrap((GtkSpinButton*)s7_c_pointer_with_type(sc, spin_button, GtkSpinButton__sym, __func__, 0), (gboolean)lg_boolean(wrap));
  return(lg_false);
}

static s7_pointer lg_gtk_spin_button_get_wrap(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_spin_button_get_wrap "gboolean gtk_spin_button_get_wrap(GtkSpinButton* spin_button)"
  s7_pointer spin_button;
  spin_button = s7_car(args);
  return(s7_make_boolean(sc, gtk_spin_button_get_wrap((GtkSpinButton*)s7_c_pointer_with_type(sc, spin_button, GtkSpinButton__sym, __func__, 0))));
}

static s7_pointer lg_gtk_spin_button_set_snap_to_ticks(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_spin_button_set_snap_to_ticks "void gtk_spin_button_set_snap_to_ticks(GtkSpinButton* spin_button, \
gboolean snap_to_ticks)"
  s7_pointer _p;
  s7_pointer spin_button, snap_to_ticks;
  _p = args;
  spin_button = s7_car(_p); _p = s7_cdr(_p);
  snap_to_ticks = s7_car(_p);
  if (!s7_is_boolean(snap_to_ticks)) s7_wrong_type_arg_error(sc, "gtk_spin_button_set_snap_to_ticks", 2, snap_to_ticks, "gboolean");
  gtk_spin_button_set_snap_to_ticks((GtkSpinButton*)s7_c_pointer_with_type(sc, spin_button, GtkSpinButton__sym, __func__, 0), (gboolean)lg_boolean(snap_to_ticks));
  return(lg_false);
}

static s7_pointer lg_gtk_spin_button_get_snap_to_ticks(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_spin_button_get_snap_to_ticks "gboolean gtk_spin_button_get_snap_to_ticks(GtkSpinButton* spin_button)"
  s7_pointer spin_button;
  spin_button = s7_car(args);
  return(s7_make_boolean(sc, gtk_spin_button_get_snap_to_ticks((GtkSpinButton*)s7_c_pointer_with_type(sc, spin_button, GtkSpinButton__sym, __func__, 0))));
}

static s7_pointer lg_gtk_spin_button_update(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_spin_button_update "void gtk_spin_button_update(GtkSpinButton* spin_button)"
  s7_pointer spin_button;
  spin_button = s7_car(args);
  gtk_spin_button_update((GtkSpinButton*)s7_c_pointer_with_type(sc, spin_button, GtkSpinButton__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_statusbar_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_statusbar_new "GtkWidget* gtk_statusbar_new( void)"
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_statusbar_new()));
}

static s7_pointer lg_gtk_statusbar_get_context_id(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_statusbar_get_context_id "guint gtk_statusbar_get_context_id(GtkStatusbar* statusbar, \
gchar* context_description)"
  s7_pointer _p;
  s7_pointer statusbar, context_description;
  _p = args;
  statusbar = s7_car(_p); _p = s7_cdr(_p);
  context_description = s7_car(_p);
  if (!s7_is_string(context_description)) s7_wrong_type_arg_error(sc, "gtk_statusbar_get_context_id", 2, context_description, "gchar*");
  return(s7_make_integer(sc, gtk_statusbar_get_context_id((GtkStatusbar*)s7_c_pointer_with_type(sc, statusbar, GtkStatusbar__sym, __func__, 0), (gchar*)s7_string(context_description))));
}

static s7_pointer lg_gtk_statusbar_push(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_statusbar_push "guint gtk_statusbar_push(GtkStatusbar* statusbar, guint context_id, gchar* text)"
  s7_pointer _p;
  s7_pointer statusbar, context_id, text;
  _p = args;
  statusbar = s7_car(_p); _p = s7_cdr(_p);
  context_id = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(context_id)) s7_wrong_type_arg_error(sc, "gtk_statusbar_push", 2, context_id, "guint");
  text = s7_car(_p);
  if (!s7_is_string(text)) s7_wrong_type_arg_error(sc, "gtk_statusbar_push", 3, text, "gchar*");
  return(s7_make_integer(sc, gtk_statusbar_push((GtkStatusbar*)s7_c_pointer_with_type(sc, statusbar, GtkStatusbar__sym, __func__, 0), (guint)s7_integer(context_id), (gchar*)s7_string(text))));
}

static s7_pointer lg_gtk_statusbar_pop(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_statusbar_pop "void gtk_statusbar_pop(GtkStatusbar* statusbar, guint context_id)"
  s7_pointer _p;
  s7_pointer statusbar, context_id;
  _p = args;
  statusbar = s7_car(_p); _p = s7_cdr(_p);
  context_id = s7_car(_p);
  if (!s7_is_integer(context_id)) s7_wrong_type_arg_error(sc, "gtk_statusbar_pop", 2, context_id, "guint");
  gtk_statusbar_pop((GtkStatusbar*)s7_c_pointer_with_type(sc, statusbar, GtkStatusbar__sym, __func__, 0), (guint)s7_integer(context_id));
  return(lg_false);
}

static s7_pointer lg_gtk_statusbar_remove(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_statusbar_remove "void gtk_statusbar_remove(GtkStatusbar* statusbar, guint context_id, \
guint message_id)"
  s7_pointer _p;
  s7_pointer statusbar, context_id, message_id;
  _p = args;
  statusbar = s7_car(_p); _p = s7_cdr(_p);
  context_id = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(context_id)) s7_wrong_type_arg_error(sc, "gtk_statusbar_remove", 2, context_id, "guint");
  message_id = s7_car(_p);
  if (!s7_is_integer(message_id)) s7_wrong_type_arg_error(sc, "gtk_statusbar_remove", 3, message_id, "guint");
  gtk_statusbar_remove((GtkStatusbar*)s7_c_pointer_with_type(sc, statusbar, GtkStatusbar__sym, __func__, 0), (guint)s7_integer(context_id), (guint)s7_integer(message_id));
  return(lg_false);
}

static s7_pointer lg_gtk_text_buffer_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_new "GtkTextBuffer* gtk_text_buffer_new(GtkTextTagTable* table)"
  s7_pointer table;
  table = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GtkTextBuffer__sym, gtk_text_buffer_new((GtkTextTagTable*)s7_c_pointer_with_type(sc, table, GtkTextTagTable__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_buffer_get_line_count(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_get_line_count "gint gtk_text_buffer_get_line_count(GtkTextBuffer* buffer)"
  s7_pointer buffer;
  buffer = s7_car(args);
  return(s7_make_integer(sc, gtk_text_buffer_get_line_count((GtkTextBuffer*)s7_c_pointer_with_type(sc, buffer, GtkTextBuffer__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_buffer_get_char_count(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_get_char_count "gint gtk_text_buffer_get_char_count(GtkTextBuffer* buffer)"
  s7_pointer buffer;
  buffer = s7_car(args);
  return(s7_make_integer(sc, gtk_text_buffer_get_char_count((GtkTextBuffer*)s7_c_pointer_with_type(sc, buffer, GtkTextBuffer__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_buffer_get_tag_table(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_get_tag_table "GtkTextTagTable* gtk_text_buffer_get_tag_table(GtkTextBuffer* buffer)"
  s7_pointer buffer;
  buffer = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GtkTextTagTable__sym, gtk_text_buffer_get_tag_table((GtkTextBuffer*)s7_c_pointer_with_type(sc, buffer, GtkTextBuffer__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_buffer_set_text(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_set_text "void gtk_text_buffer_set_text(GtkTextBuffer* buffer, gchar* text, \
gint len)"
  s7_pointer _p;
  s7_pointer buffer, text, len;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  text = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(text)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_set_text", 2, text, "gchar*");
  len = s7_car(_p);
  if (!s7_is_integer(len)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_set_text", 3, len, "gint");
  gtk_text_buffer_set_text((GtkTextBuffer*)s7_c_pointer_with_type(sc, buffer, GtkTextBuffer__sym, __func__, 0), (gchar*)s7_string(text), (gint)s7_integer(len));
  return(lg_false);
}

static s7_pointer lg_gtk_text_buffer_insert(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_insert "void gtk_text_buffer_insert(GtkTextBuffer* buffer, GtkTextIter* iter, \
gchar* text, gint len)"
  s7_pointer _p;
  s7_pointer buffer, iter, text, len;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  iter = s7_car(_p); _p = s7_cdr(_p);
  text = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(text)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_insert", 3, text, "gchar*");
  len = s7_car(_p);
  if (!s7_is_integer(len)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_insert", 4, len, "gint");
  gtk_text_buffer_insert((GtkTextBuffer*)s7_c_pointer_with_type(sc, buffer, GtkTextBuffer__sym, __func__, 0), (GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0), (gchar*)s7_string(text), (gint)s7_integer(len));
  return(lg_false);
}

static s7_pointer lg_gtk_text_buffer_insert_at_cursor(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_insert_at_cursor "void gtk_text_buffer_insert_at_cursor(GtkTextBuffer* buffer, \
gchar* text, gint len)"
  s7_pointer _p;
  s7_pointer buffer, text, len;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  text = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(text)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_insert_at_cursor", 2, text, "gchar*");
  len = s7_car(_p);
  if (!s7_is_integer(len)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_insert_at_cursor", 3, len, "gint");
  gtk_text_buffer_insert_at_cursor((GtkTextBuffer*)s7_c_pointer_with_type(sc, buffer, GtkTextBuffer__sym, __func__, 0), (gchar*)s7_string(text), (gint)s7_integer(len));
  return(lg_false);
}

static s7_pointer lg_gtk_text_buffer_insert_interactive(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_insert_interactive "gboolean gtk_text_buffer_insert_interactive(GtkTextBuffer* buffer, \
GtkTextIter* iter, gchar* text, gint len, gboolean default_editable)"
  s7_pointer _p;
  s7_pointer buffer, iter, text, len, default_editable;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  iter = s7_car(_p); _p = s7_cdr(_p);
  text = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(text)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_insert_interactive", 3, text, "gchar*");
  len = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(len)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_insert_interactive", 4, len, "gint");
  default_editable = s7_car(_p);
  if (!s7_is_boolean(default_editable)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_insert_interactive", 5, default_editable, "gboolean");
  return(s7_make_boolean(sc, gtk_text_buffer_insert_interactive((GtkTextBuffer*)s7_c_pointer_with_type(sc, buffer, GtkTextBuffer__sym, __func__, 0), (GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0), (gchar*)s7_string(text), (gint)s7_integer(len), (gboolean)lg_boolean(default_editable))));
}

static s7_pointer lg_gtk_text_buffer_insert_interactive_at_cursor(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_insert_interactive_at_cursor "gboolean gtk_text_buffer_insert_interactive_at_cursor(GtkTextBuffer* buffer, \
gchar* text, gint len, gboolean default_editable)"
  s7_pointer _p;
  s7_pointer buffer, text, len, default_editable;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  text = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(text)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_insert_interactive_at_cursor", 2, text, "gchar*");
  len = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(len)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_insert_interactive_at_cursor", 3, len, "gint");
  default_editable = s7_car(_p);
  if (!s7_is_boolean(default_editable)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_insert_interactive_at_cursor", 4, default_editable, "gboolean");
  return(s7_make_boolean(sc, gtk_text_buffer_insert_interactive_at_cursor((GtkTextBuffer*)s7_c_pointer_with_type(sc, buffer, GtkTextBuffer__sym, __func__, 0), (gchar*)s7_string(text), (gint)s7_integer(len), (gboolean)lg_boolean(default_editable))));
}

static s7_pointer lg_gtk_text_buffer_insert_range(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_insert_range "void gtk_text_buffer_insert_range(GtkTextBuffer* buffer, GtkTextIter* iter, \
GtkTextIter* start, GtkTextIter* end)"
  s7_pointer _p;
  s7_pointer buffer, iter, start, end;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  iter = s7_car(_p); _p = s7_cdr(_p);
  start = s7_car(_p); _p = s7_cdr(_p);
  end = s7_car(_p);
  gtk_text_buffer_insert_range((GtkTextBuffer*)s7_c_pointer_with_type(sc, buffer, GtkTextBuffer__sym, __func__, 0), (GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0), (GtkTextIter*)s7_c_pointer_with_type(sc, start, GtkTextIter__sym, __func__, 0), (GtkTextIter*)s7_c_pointer_with_type(sc, end, GtkTextIter__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_text_buffer_insert_range_interactive(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_insert_range_interactive "gboolean gtk_text_buffer_insert_range_interactive(GtkTextBuffer* buffer, \
GtkTextIter* iter, GtkTextIter* start, GtkTextIter* end, gboolean default_editable)"
  s7_pointer _p;
  s7_pointer buffer, iter, start, end, default_editable;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  iter = s7_car(_p); _p = s7_cdr(_p);
  start = s7_car(_p); _p = s7_cdr(_p);
  end = s7_car(_p); _p = s7_cdr(_p);
  default_editable = s7_car(_p);
  if (!s7_is_boolean(default_editable)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_insert_range_interactive", 5, default_editable, "gboolean");
  return(s7_make_boolean(sc, gtk_text_buffer_insert_range_interactive((GtkTextBuffer*)s7_c_pointer_with_type(sc, buffer, GtkTextBuffer__sym, __func__, 0), (GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0), (GtkTextIter*)s7_c_pointer_with_type(sc, start, GtkTextIter__sym, __func__, 0), (GtkTextIter*)s7_c_pointer_with_type(sc, end, GtkTextIter__sym, __func__, 0), (gboolean)lg_boolean(default_editable))));
}

static s7_pointer lg_gtk_text_buffer_insert_with_tags(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_insert_with_tags "void gtk_text_buffer_insert_with_tags(GtkTextBuffer* buffer, \
GtkTextIter* iter, gchar* text, gint len, etc tags)"
  s7_pointer _p;
  s7_pointer buffer, iter, text, len, tags;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  iter = s7_car(_p); _p = s7_cdr(_p);
  text = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(text)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_insert_with_tags", 3, text, "gchar*");
  len = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(len)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_insert_with_tags", 4, len, "gint");
  tags = s7_car(_p);
  if (!lg_is_list(tags)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_insert_with_tags", 5, tags, "etc");
  {
    int etc_len = 0;
    GtkTextBuffer* p_arg0;
    GtkTextIter* p_arg1;
    gchar* p_arg2;
    gint p_arg3;
    if (s7_is_list(sc, tags)) etc_len = s7_list_length(sc, tags);
    if (etc_len < 1) s7_out_of_range_error(sc, "gtk_text_buffer_insert_with_tags", 4, tags, "... list must have at least 1 entry");
    if (etc_len > 6) s7_out_of_range_error(sc, "gtk_text_buffer_insert_with_tags", 4, tags, "... list too long (max len: 6)");
    p_arg0 = (GtkTextBuffer*)s7_c_pointer_with_type(sc, buffer, GtkTextBuffer__sym, __func__, 0);
    p_arg1 = (GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0);
    p_arg2 = (gchar*)s7_string(text);
    p_arg3 = (gint)s7_integer(len);
    switch (etc_len)
      {
        case 1: gtk_text_buffer_insert_with_tags(p_arg0, p_arg1, p_arg2, p_arg3, (GtkTextTag*)s7_c_pointer(s7_list_ref(sc, tags, 0)), NULL); break;
        case 2: gtk_text_buffer_insert_with_tags(p_arg0, p_arg1, p_arg2, p_arg3, (GtkTextTag*)s7_c_pointer(s7_list_ref(sc, tags, 0)), (GtkTextTag*)s7_c_pointer(s7_list_ref(sc, tags, 1)), NULL); break;
        case 3: gtk_text_buffer_insert_with_tags(p_arg0, p_arg1, p_arg2, p_arg3, (GtkTextTag*)s7_c_pointer(s7_list_ref(sc, tags, 0)), (GtkTextTag*)s7_c_pointer(s7_list_ref(sc, tags, 1)), (GtkTextTag*)s7_c_pointer(s7_list_ref(sc, tags, 2)), NULL); break;
        case 4: gtk_text_buffer_insert_with_tags(p_arg0, p_arg1, p_arg2, p_arg3, (GtkTextTag*)s7_c_pointer(s7_list_ref(sc, tags, 0)), (GtkTextTag*)s7_c_pointer(s7_list_ref(sc, tags, 1)), (GtkTextTag*)s7_c_pointer(s7_list_ref(sc, tags, 2)), (GtkTextTag*)s7_c_pointer(s7_list_ref(sc, tags, 3)), NULL); break;
        case 5: gtk_text_buffer_insert_with_tags(p_arg0, p_arg1, p_arg2, p_arg3, (GtkTextTag*)s7_c_pointer(s7_list_ref(sc, tags, 0)), (GtkTextTag*)s7_c_pointer(s7_list_ref(sc, tags, 1)), (GtkTextTag*)s7_c_pointer(s7_list_ref(sc, tags, 2)), (GtkTextTag*)s7_c_pointer(s7_list_ref(sc, tags, 3)), (GtkTextTag*)s7_c_pointer(s7_list_ref(sc, tags, 4)), NULL); break;
        case 6: gtk_text_buffer_insert_with_tags(p_arg0, p_arg1, p_arg2, p_arg3, (GtkTextTag*)s7_c_pointer(s7_list_ref(sc, tags, 0)), (GtkTextTag*)s7_c_pointer(s7_list_ref(sc, tags, 1)), (GtkTextTag*)s7_c_pointer(s7_list_ref(sc, tags, 2)), (GtkTextTag*)s7_c_pointer(s7_list_ref(sc, tags, 3)), (GtkTextTag*)s7_c_pointer(s7_list_ref(sc, tags, 4)), (GtkTextTag*)s7_c_pointer(s7_list_ref(sc, tags, 5)), NULL); break;
      }
    return(lg_false);
  }
}

static s7_pointer lg_gtk_text_buffer_insert_with_tags_by_name(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_insert_with_tags_by_name "void gtk_text_buffer_insert_with_tags_by_name(GtkTextBuffer* buffer, \
GtkTextIter* iter, gchar* text, gint len, etc tags)"
  s7_pointer _p;
  s7_pointer buffer, iter, text, len, tags;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  iter = s7_car(_p); _p = s7_cdr(_p);
  text = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(text)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_insert_with_tags_by_name", 3, text, "gchar*");
  len = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(len)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_insert_with_tags_by_name", 4, len, "gint");
  tags = s7_car(_p);
  if (!lg_is_list(tags)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_insert_with_tags_by_name", 5, tags, "etc");
  {
    int etc_len = 0;
    GtkTextBuffer* p_arg0;
    GtkTextIter* p_arg1;
    gchar* p_arg2;
    gint p_arg3;
    if (s7_is_list(sc, tags)) etc_len = s7_list_length(sc, tags);
    if (etc_len < 1) s7_out_of_range_error(sc, "gtk_text_buffer_insert_with_tags_by_name", 4, tags, "... list must have at least 1 entry");
    if (etc_len > 6) s7_out_of_range_error(sc, "gtk_text_buffer_insert_with_tags_by_name", 4, tags, "... list too long (max len: 6)");
    if ((etc_len % 2) != 0) s7_out_of_range_error(sc, "gtk_text_buffer_insert_with_tags_by_name", 4, tags, "... list len must be multiple of 2");
    p_arg0 = (GtkTextBuffer*)s7_c_pointer_with_type(sc, buffer, GtkTextBuffer__sym, __func__, 0);
    p_arg1 = (GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0);
    p_arg2 = (gchar*)s7_string(text);
    p_arg3 = (gint)s7_integer(len);
    switch (etc_len)
      {
        case 1: gtk_text_buffer_insert_with_tags_by_name(p_arg0, p_arg1, p_arg2, p_arg3, s7_string(s7_list_ref(sc, tags, 0)), NULL); break;
        case 3: gtk_text_buffer_insert_with_tags_by_name(p_arg0, p_arg1, p_arg2, p_arg3, s7_string(s7_list_ref(sc, tags, 0)), s7_integer(s7_list_ref(sc, tags, 1)), s7_string(s7_list_ref(sc, tags, 2)), NULL); break;
        case 5: gtk_text_buffer_insert_with_tags_by_name(p_arg0, p_arg1, p_arg2, p_arg3, s7_string(s7_list_ref(sc, tags, 0)), s7_integer(s7_list_ref(sc, tags, 1)), s7_string(s7_list_ref(sc, tags, 2)), s7_integer(s7_list_ref(sc, tags, 3)), s7_string(s7_list_ref(sc, tags, 4)), NULL); break;
      }
    return(lg_false);
  }
}

static s7_pointer lg_gtk_text_buffer_delete(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_delete "void gtk_text_buffer_delete(GtkTextBuffer* buffer, GtkTextIter* start, \
GtkTextIter* end)"
  s7_pointer _p;
  s7_pointer buffer, start, end;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  start = s7_car(_p); _p = s7_cdr(_p);
  end = s7_car(_p);
  gtk_text_buffer_delete((GtkTextBuffer*)s7_c_pointer_with_type(sc, buffer, GtkTextBuffer__sym, __func__, 0), (GtkTextIter*)s7_c_pointer_with_type(sc, start, GtkTextIter__sym, __func__, 0), (GtkTextIter*)s7_c_pointer_with_type(sc, end, GtkTextIter__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_text_buffer_delete_interactive(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_delete_interactive "gboolean gtk_text_buffer_delete_interactive(GtkTextBuffer* buffer, \
GtkTextIter* start_iter, GtkTextIter* end_iter, gboolean default_editable)"
  s7_pointer _p;
  s7_pointer buffer, start_iter, end_iter, default_editable;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  start_iter = s7_car(_p); _p = s7_cdr(_p);
  end_iter = s7_car(_p); _p = s7_cdr(_p);
  default_editable = s7_car(_p);
  if (!s7_is_boolean(default_editable)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_delete_interactive", 4, default_editable, "gboolean");
  return(s7_make_boolean(sc, gtk_text_buffer_delete_interactive((GtkTextBuffer*)s7_c_pointer_with_type(sc, buffer, GtkTextBuffer__sym, __func__, 0), (GtkTextIter*)s7_c_pointer_with_type(sc, start_iter, GtkTextIter__sym, __func__, 0), (GtkTextIter*)s7_c_pointer_with_type(sc, end_iter, GtkTextIter__sym, __func__, 0), (gboolean)lg_boolean(default_editable))));
}

static s7_pointer lg_gtk_text_buffer_get_text(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_get_text "gchar* gtk_text_buffer_get_text(GtkTextBuffer* buffer, GtkTextIter* start, \
GtkTextIter* end, gboolean include_hidden_chars)"
  s7_pointer _p;
  s7_pointer buffer, start, end, include_hidden_chars;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  start = s7_car(_p); _p = s7_cdr(_p);
  end = s7_car(_p); _p = s7_cdr(_p);
  include_hidden_chars = s7_car(_p);
  if (!s7_is_boolean(include_hidden_chars)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_get_text", 4, include_hidden_chars, "gboolean");
  {
    gchar* res_ult;
    s7_pointer rtn;
    res_ult = gtk_text_buffer_get_text((GtkTextBuffer*)s7_c_pointer_with_type(sc, buffer, GtkTextBuffer__sym, __func__, 0), (GtkTextIter*)s7_c_pointer_with_type(sc, start, GtkTextIter__sym, __func__, 0), (GtkTextIter*)s7_c_pointer_with_type(sc, end, GtkTextIter__sym, __func__, 0), (gboolean)lg_boolean(include_hidden_chars));
    rtn = s7_make_string(sc, res_ult);
    g_free(res_ult);
    return(rtn);
  }
}

static s7_pointer lg_gtk_text_buffer_get_slice(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_get_slice "gchar* gtk_text_buffer_get_slice(GtkTextBuffer* buffer, GtkTextIter* start, \
GtkTextIter* end, gboolean include_hidden_chars)"
  s7_pointer _p;
  s7_pointer buffer, start, end, include_hidden_chars;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  start = s7_car(_p); _p = s7_cdr(_p);
  end = s7_car(_p); _p = s7_cdr(_p);
  include_hidden_chars = s7_car(_p);
  if (!s7_is_boolean(include_hidden_chars)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_get_slice", 4, include_hidden_chars, "gboolean");
  {
    gchar* res_ult;
    s7_pointer rtn;
    res_ult = gtk_text_buffer_get_slice((GtkTextBuffer*)s7_c_pointer_with_type(sc, buffer, GtkTextBuffer__sym, __func__, 0), (GtkTextIter*)s7_c_pointer_with_type(sc, start, GtkTextIter__sym, __func__, 0), (GtkTextIter*)s7_c_pointer_with_type(sc, end, GtkTextIter__sym, __func__, 0), (gboolean)lg_boolean(include_hidden_chars));
    rtn = s7_make_string(sc, res_ult);
    g_free(res_ult);
    return(rtn);
  }
}

static s7_pointer lg_gtk_text_buffer_insert_child_anchor(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_insert_child_anchor "void gtk_text_buffer_insert_child_anchor(GtkTextBuffer* buffer, \
GtkTextIter* iter, GtkTextChildAnchor* anchor)"
  s7_pointer _p;
  s7_pointer buffer, iter, anchor;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  iter = s7_car(_p); _p = s7_cdr(_p);
  anchor = s7_car(_p);
  gtk_text_buffer_insert_child_anchor((GtkTextBuffer*)s7_c_pointer_with_type(sc, buffer, GtkTextBuffer__sym, __func__, 0), (GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0), (GtkTextChildAnchor*)s7_c_pointer_with_type(sc, anchor, GtkTextChildAnchor__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_text_buffer_create_child_anchor(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_create_child_anchor "GtkTextChildAnchor* gtk_text_buffer_create_child_anchor(GtkTextBuffer* buffer, \
GtkTextIter* iter)"
  s7_pointer _p;
  s7_pointer buffer, iter;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  iter = s7_car(_p);
  return(lg_make_c_pointer_with_type(sc, GtkTextChildAnchor__sym, gtk_text_buffer_create_child_anchor((GtkTextBuffer*)s7_c_pointer_with_type(sc, buffer, GtkTextBuffer__sym, __func__, 0), (GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_buffer_create_mark(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_create_mark "GtkTextMark* gtk_text_buffer_create_mark(GtkTextBuffer* buffer, \
gchar* mark_name, GtkTextIter* where, gboolean left_gravity)"
  s7_pointer _p;
  s7_pointer buffer, mark_name, where, left_gravity;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  mark_name = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(mark_name)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_create_mark", 2, mark_name, "gchar*");
  where = s7_car(_p); _p = s7_cdr(_p);
  left_gravity = s7_car(_p);
  if (!s7_is_boolean(left_gravity)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_create_mark", 4, left_gravity, "gboolean");
  return(lg_make_c_pointer_with_type(sc, GtkTextMark__sym, gtk_text_buffer_create_mark((GtkTextBuffer*)s7_c_pointer_with_type(sc, buffer, GtkTextBuffer__sym, __func__, 0), (gchar*)s7_string(mark_name), (GtkTextIter*)s7_c_pointer_with_type(sc, where, GtkTextIter__sym, __func__, 0), (gboolean)lg_boolean(left_gravity))));
}

static s7_pointer lg_gtk_text_buffer_move_mark(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_move_mark "void gtk_text_buffer_move_mark(GtkTextBuffer* buffer, GtkTextMark* mark, \
GtkTextIter* where)"
  s7_pointer _p;
  s7_pointer buffer, mark, where;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  mark = s7_car(_p); _p = s7_cdr(_p);
  where = s7_car(_p);
  gtk_text_buffer_move_mark((GtkTextBuffer*)s7_c_pointer_with_type(sc, buffer, GtkTextBuffer__sym, __func__, 0), (GtkTextMark*)s7_c_pointer_with_type(sc, mark, GtkTextMark__sym, __func__, 0), (GtkTextIter*)s7_c_pointer_with_type(sc, where, GtkTextIter__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_text_buffer_delete_mark(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_delete_mark "void gtk_text_buffer_delete_mark(GtkTextBuffer* buffer, GtkTextMark* mark)"
  s7_pointer _p;
  s7_pointer buffer, mark;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  mark = s7_car(_p);
  gtk_text_buffer_delete_mark((GtkTextBuffer*)s7_c_pointer_with_type(sc, buffer, GtkTextBuffer__sym, __func__, 0), (GtkTextMark*)s7_c_pointer_with_type(sc, mark, GtkTextMark__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_text_buffer_get_mark(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_get_mark "GtkTextMark* gtk_text_buffer_get_mark(GtkTextBuffer* buffer, gchar* name)"
  s7_pointer _p;
  s7_pointer buffer, name;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  name = s7_car(_p);
  if (!s7_is_string(name)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_get_mark", 2, name, "gchar*");
  return(lg_make_c_pointer_with_type(sc, GtkTextMark__sym, gtk_text_buffer_get_mark((GtkTextBuffer*)s7_c_pointer_with_type(sc, buffer, GtkTextBuffer__sym, __func__, 0), (gchar*)s7_string(name))));
}

static s7_pointer lg_gtk_text_buffer_move_mark_by_name(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_move_mark_by_name "void gtk_text_buffer_move_mark_by_name(GtkTextBuffer* buffer, \
gchar* name, GtkTextIter* where)"
  s7_pointer _p;
  s7_pointer buffer, name, where;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  name = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(name)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_move_mark_by_name", 2, name, "gchar*");
  where = s7_car(_p);
  gtk_text_buffer_move_mark_by_name((GtkTextBuffer*)s7_c_pointer_with_type(sc, buffer, GtkTextBuffer__sym, __func__, 0), (gchar*)s7_string(name), (GtkTextIter*)s7_c_pointer_with_type(sc, where, GtkTextIter__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_text_buffer_delete_mark_by_name(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_delete_mark_by_name "void gtk_text_buffer_delete_mark_by_name(GtkTextBuffer* buffer, \
gchar* name)"
  s7_pointer _p;
  s7_pointer buffer, name;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  name = s7_car(_p);
  if (!s7_is_string(name)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_delete_mark_by_name", 2, name, "gchar*");
  gtk_text_buffer_delete_mark_by_name((GtkTextBuffer*)s7_c_pointer_with_type(sc, buffer, GtkTextBuffer__sym, __func__, 0), (gchar*)s7_string(name));
  return(lg_false);
}

static s7_pointer lg_gtk_text_buffer_get_insert(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_get_insert "GtkTextMark* gtk_text_buffer_get_insert(GtkTextBuffer* buffer)"
  s7_pointer buffer;
  buffer = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GtkTextMark__sym, gtk_text_buffer_get_insert((GtkTextBuffer*)s7_c_pointer_with_type(sc, buffer, GtkTextBuffer__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_buffer_get_selection_bound(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_get_selection_bound "GtkTextMark* gtk_text_buffer_get_selection_bound(GtkTextBuffer* buffer)"
  s7_pointer buffer;
  buffer = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GtkTextMark__sym, gtk_text_buffer_get_selection_bound((GtkTextBuffer*)s7_c_pointer_with_type(sc, buffer, GtkTextBuffer__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_buffer_place_cursor(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_place_cursor "void gtk_text_buffer_place_cursor(GtkTextBuffer* buffer, GtkTextIter* where)"
  s7_pointer _p;
  s7_pointer buffer, where;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  where = s7_car(_p);
  gtk_text_buffer_place_cursor((GtkTextBuffer*)s7_c_pointer_with_type(sc, buffer, GtkTextBuffer__sym, __func__, 0), (GtkTextIter*)s7_c_pointer_with_type(sc, where, GtkTextIter__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_text_buffer_apply_tag(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_apply_tag "void gtk_text_buffer_apply_tag(GtkTextBuffer* buffer, GtkTextTag* tag, \
GtkTextIter* start, GtkTextIter* end)"
  s7_pointer _p;
  s7_pointer buffer, tag, start, end;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  tag = s7_car(_p); _p = s7_cdr(_p);
  start = s7_car(_p); _p = s7_cdr(_p);
  end = s7_car(_p);
  gtk_text_buffer_apply_tag((GtkTextBuffer*)s7_c_pointer_with_type(sc, buffer, GtkTextBuffer__sym, __func__, 0), (GtkTextTag*)s7_c_pointer_with_type(sc, tag, GtkTextTag__sym, __func__, 0), (GtkTextIter*)s7_c_pointer_with_type(sc, start, GtkTextIter__sym, __func__, 0), (GtkTextIter*)s7_c_pointer_with_type(sc, end, GtkTextIter__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_text_buffer_remove_tag(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_remove_tag "void gtk_text_buffer_remove_tag(GtkTextBuffer* buffer, GtkTextTag* tag, \
GtkTextIter* start, GtkTextIter* end)"
  s7_pointer _p;
  s7_pointer buffer, tag, start, end;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  tag = s7_car(_p); _p = s7_cdr(_p);
  start = s7_car(_p); _p = s7_cdr(_p);
  end = s7_car(_p);
  gtk_text_buffer_remove_tag((GtkTextBuffer*)s7_c_pointer_with_type(sc, buffer, GtkTextBuffer__sym, __func__, 0), (GtkTextTag*)s7_c_pointer_with_type(sc, tag, GtkTextTag__sym, __func__, 0), (GtkTextIter*)s7_c_pointer_with_type(sc, start, GtkTextIter__sym, __func__, 0), (GtkTextIter*)s7_c_pointer_with_type(sc, end, GtkTextIter__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_text_buffer_apply_tag_by_name(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_apply_tag_by_name "void gtk_text_buffer_apply_tag_by_name(GtkTextBuffer* buffer, \
gchar* name, GtkTextIter* start, GtkTextIter* end)"
  s7_pointer _p;
  s7_pointer buffer, name, start, end;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  name = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(name)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_apply_tag_by_name", 2, name, "gchar*");
  start = s7_car(_p); _p = s7_cdr(_p);
  end = s7_car(_p);
  gtk_text_buffer_apply_tag_by_name((GtkTextBuffer*)s7_c_pointer_with_type(sc, buffer, GtkTextBuffer__sym, __func__, 0), (gchar*)s7_string(name), (GtkTextIter*)s7_c_pointer_with_type(sc, start, GtkTextIter__sym, __func__, 0), (GtkTextIter*)s7_c_pointer_with_type(sc, end, GtkTextIter__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_text_buffer_remove_tag_by_name(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_remove_tag_by_name "void gtk_text_buffer_remove_tag_by_name(GtkTextBuffer* buffer, \
gchar* name, GtkTextIter* start, GtkTextIter* end)"
  s7_pointer _p;
  s7_pointer buffer, name, start, end;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  name = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(name)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_remove_tag_by_name", 2, name, "gchar*");
  start = s7_car(_p); _p = s7_cdr(_p);
  end = s7_car(_p);
  gtk_text_buffer_remove_tag_by_name((GtkTextBuffer*)s7_c_pointer_with_type(sc, buffer, GtkTextBuffer__sym, __func__, 0), (gchar*)s7_string(name), (GtkTextIter*)s7_c_pointer_with_type(sc, start, GtkTextIter__sym, __func__, 0), (GtkTextIter*)s7_c_pointer_with_type(sc, end, GtkTextIter__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_text_buffer_remove_all_tags(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_remove_all_tags "void gtk_text_buffer_remove_all_tags(GtkTextBuffer* buffer, \
GtkTextIter* start, GtkTextIter* end)"
  s7_pointer _p;
  s7_pointer buffer, start, end;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  start = s7_car(_p); _p = s7_cdr(_p);
  end = s7_car(_p);
  gtk_text_buffer_remove_all_tags((GtkTextBuffer*)s7_c_pointer_with_type(sc, buffer, GtkTextBuffer__sym, __func__, 0), (GtkTextIter*)s7_c_pointer_with_type(sc, start, GtkTextIter__sym, __func__, 0), (GtkTextIter*)s7_c_pointer_with_type(sc, end, GtkTextIter__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_text_buffer_create_tag(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_create_tag "GtkTextTag* gtk_text_buffer_create_tag(GtkTextBuffer* buffer, \
gchar* tag_name, etc tags)"
  s7_pointer _p;
  s7_pointer buffer, tag_name, tags;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  tag_name = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(tag_name)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_create_tag", 2, tag_name, "gchar*");
  tags = s7_car(_p);
  if ((!lg_is_list(tags)) && (tags != lg_false)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_create_tag", 3, tags, "etc");
  {
    int etc_len = 0;
    GtkTextTag* res_ult = NULL;
    GtkTextBuffer* p_arg0;
    gchar* p_arg1;
    if (s7_is_list(sc, tags)) etc_len = s7_list_length(sc, tags);
    if (etc_len > 6) s7_out_of_range_error(sc, "gtk_text_buffer_create_tag", 2, tags, "... list too long (max len: 6)");
    if ((etc_len % 2) != 0) s7_out_of_range_error(sc, "gtk_text_buffer_create_tag", 2, tags, "... list len must be multiple of 2");
    p_arg0 = (GtkTextBuffer*)s7_c_pointer_with_type(sc, buffer, GtkTextBuffer__sym, __func__, 0);
    p_arg1 = (gchar*)s7_string(tag_name);
    switch (etc_len)
      {
        case 0: res_ult = gtk_text_buffer_create_tag(p_arg0, p_arg1, NULL); break;
        case 2: res_ult = gtk_text_buffer_create_tag(p_arg0, p_arg1, s7_string(s7_list_ref(sc, tags, 0)), s7_c_pointer(s7_list_ref(sc, tags, 1)), NULL); break;
        case 4: res_ult = gtk_text_buffer_create_tag(p_arg0, p_arg1, s7_string(s7_list_ref(sc, tags, 0)), s7_c_pointer(s7_list_ref(sc, tags, 1)), s7_string(s7_list_ref(sc, tags, 2)), s7_c_pointer(s7_list_ref(sc, tags, 3)), NULL); break;
        case 6: res_ult = gtk_text_buffer_create_tag(p_arg0, p_arg1, s7_string(s7_list_ref(sc, tags, 0)), s7_c_pointer(s7_list_ref(sc, tags, 1)), s7_string(s7_list_ref(sc, tags, 2)), s7_c_pointer(s7_list_ref(sc, tags, 3)), s7_string(s7_list_ref(sc, tags, 4)), s7_c_pointer(s7_list_ref(sc, tags, 5)), NULL); break;
      }
    return(s7_make_c_pointer(sc, res_ult));
  }
}

static s7_pointer lg_gtk_text_buffer_get_iter_at_line_offset(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_get_iter_at_line_offset "void gtk_text_buffer_get_iter_at_line_offset(GtkTextBuffer* buffer, \
GtkTextIter* iter, gint line_number, gint char_offset)"
  s7_pointer _p;
  s7_pointer buffer, iter, line_number, char_offset;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  iter = s7_car(_p); _p = s7_cdr(_p);
  line_number = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(line_number)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_get_iter_at_line_offset", 3, line_number, "gint");
  char_offset = s7_car(_p);
  if (!s7_is_integer(char_offset)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_get_iter_at_line_offset", 4, char_offset, "gint");
  gtk_text_buffer_get_iter_at_line_offset((GtkTextBuffer*)s7_c_pointer_with_type(sc, buffer, GtkTextBuffer__sym, __func__, 0), (GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0), (gint)s7_integer(line_number), (gint)s7_integer(char_offset));
  return(lg_false);
}

static s7_pointer lg_gtk_text_buffer_get_iter_at_line_index(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_get_iter_at_line_index "void gtk_text_buffer_get_iter_at_line_index(GtkTextBuffer* buffer, \
GtkTextIter* iter, gint line_number, gint byte_index)"
  s7_pointer _p;
  s7_pointer buffer, iter, line_number, byte_index;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  iter = s7_car(_p); _p = s7_cdr(_p);
  line_number = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(line_number)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_get_iter_at_line_index", 3, line_number, "gint");
  byte_index = s7_car(_p);
  if (!s7_is_integer(byte_index)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_get_iter_at_line_index", 4, byte_index, "gint");
  gtk_text_buffer_get_iter_at_line_index((GtkTextBuffer*)s7_c_pointer_with_type(sc, buffer, GtkTextBuffer__sym, __func__, 0), (GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0), (gint)s7_integer(line_number), (gint)s7_integer(byte_index));
  return(lg_false);
}

static s7_pointer lg_gtk_text_buffer_get_iter_at_offset(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_get_iter_at_offset "void gtk_text_buffer_get_iter_at_offset(GtkTextBuffer* buffer, \
GtkTextIter* iter, gint char_offset)"
  s7_pointer _p;
  s7_pointer buffer, iter, char_offset;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  iter = s7_car(_p); _p = s7_cdr(_p);
  char_offset = s7_car(_p);
  if (!s7_is_integer(char_offset)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_get_iter_at_offset", 3, char_offset, "gint");
  gtk_text_buffer_get_iter_at_offset((GtkTextBuffer*)s7_c_pointer_with_type(sc, buffer, GtkTextBuffer__sym, __func__, 0), (GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0), (gint)s7_integer(char_offset));
  return(lg_false);
}

static s7_pointer lg_gtk_text_buffer_get_iter_at_line(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_get_iter_at_line "void gtk_text_buffer_get_iter_at_line(GtkTextBuffer* buffer, \
GtkTextIter* iter, gint line_number)"
  s7_pointer _p;
  s7_pointer buffer, iter, line_number;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  iter = s7_car(_p); _p = s7_cdr(_p);
  line_number = s7_car(_p);
  if (!s7_is_integer(line_number)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_get_iter_at_line", 3, line_number, "gint");
  gtk_text_buffer_get_iter_at_line((GtkTextBuffer*)s7_c_pointer_with_type(sc, buffer, GtkTextBuffer__sym, __func__, 0), (GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0), (gint)s7_integer(line_number));
  return(lg_false);
}

static s7_pointer lg_gtk_text_buffer_get_start_iter(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_get_start_iter "void gtk_text_buffer_get_start_iter(GtkTextBuffer* buffer, \
GtkTextIter* iter)"
  s7_pointer _p;
  s7_pointer buffer, iter;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  iter = s7_car(_p);
  gtk_text_buffer_get_start_iter((GtkTextBuffer*)s7_c_pointer_with_type(sc, buffer, GtkTextBuffer__sym, __func__, 0), (GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_text_buffer_get_end_iter(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_get_end_iter "void gtk_text_buffer_get_end_iter(GtkTextBuffer* buffer, GtkTextIter* iter)"
  s7_pointer _p;
  s7_pointer buffer, iter;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  iter = s7_car(_p);
  gtk_text_buffer_get_end_iter((GtkTextBuffer*)s7_c_pointer_with_type(sc, buffer, GtkTextBuffer__sym, __func__, 0), (GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_text_buffer_get_bounds(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_get_bounds "void gtk_text_buffer_get_bounds(GtkTextBuffer* buffer, GtkTextIter* start, \
GtkTextIter* end)"
  s7_pointer _p;
  s7_pointer buffer, start, end;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  start = s7_car(_p); _p = s7_cdr(_p);
  end = s7_car(_p);
  gtk_text_buffer_get_bounds((GtkTextBuffer*)s7_c_pointer_with_type(sc, buffer, GtkTextBuffer__sym, __func__, 0), (GtkTextIter*)s7_c_pointer_with_type(sc, start, GtkTextIter__sym, __func__, 0), (GtkTextIter*)s7_c_pointer_with_type(sc, end, GtkTextIter__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_text_buffer_get_iter_at_mark(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_get_iter_at_mark "void gtk_text_buffer_get_iter_at_mark(GtkTextBuffer* buffer, \
GtkTextIter* iter, GtkTextMark* mark)"
  s7_pointer _p;
  s7_pointer buffer, iter, mark;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  iter = s7_car(_p); _p = s7_cdr(_p);
  mark = s7_car(_p);
  gtk_text_buffer_get_iter_at_mark((GtkTextBuffer*)s7_c_pointer_with_type(sc, buffer, GtkTextBuffer__sym, __func__, 0), (GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0), (GtkTextMark*)s7_c_pointer_with_type(sc, mark, GtkTextMark__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_text_buffer_get_iter_at_child_anchor(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_get_iter_at_child_anchor "void gtk_text_buffer_get_iter_at_child_anchor(GtkTextBuffer* buffer, \
GtkTextIter* iter, GtkTextChildAnchor* anchor)"
  s7_pointer _p;
  s7_pointer buffer, iter, anchor;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  iter = s7_car(_p); _p = s7_cdr(_p);
  anchor = s7_car(_p);
  gtk_text_buffer_get_iter_at_child_anchor((GtkTextBuffer*)s7_c_pointer_with_type(sc, buffer, GtkTextBuffer__sym, __func__, 0), (GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0), (GtkTextChildAnchor*)s7_c_pointer_with_type(sc, anchor, GtkTextChildAnchor__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_text_buffer_get_modified(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_get_modified "gboolean gtk_text_buffer_get_modified(GtkTextBuffer* buffer)"
  s7_pointer buffer;
  buffer = s7_car(args);
  return(s7_make_boolean(sc, gtk_text_buffer_get_modified((GtkTextBuffer*)s7_c_pointer_with_type(sc, buffer, GtkTextBuffer__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_buffer_set_modified(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_set_modified "void gtk_text_buffer_set_modified(GtkTextBuffer* buffer, gboolean setting)"
  s7_pointer _p;
  s7_pointer buffer, setting;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  setting = s7_car(_p);
  if (!s7_is_boolean(setting)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_set_modified", 2, setting, "gboolean");
  gtk_text_buffer_set_modified((GtkTextBuffer*)s7_c_pointer_with_type(sc, buffer, GtkTextBuffer__sym, __func__, 0), (gboolean)lg_boolean(setting));
  return(lg_false);
}

static s7_pointer lg_gtk_text_buffer_get_selection_bounds(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_get_selection_bounds "gboolean gtk_text_buffer_get_selection_bounds(GtkTextBuffer* buffer, \
GtkTextIter* start, GtkTextIter* end)"
  s7_pointer _p;
  s7_pointer buffer, start, end;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  start = s7_car(_p); _p = s7_cdr(_p);
  end = s7_car(_p);
  return(s7_make_boolean(sc, gtk_text_buffer_get_selection_bounds((GtkTextBuffer*)s7_c_pointer_with_type(sc, buffer, GtkTextBuffer__sym, __func__, 0), (GtkTextIter*)s7_c_pointer_with_type(sc, start, GtkTextIter__sym, __func__, 0), (GtkTextIter*)s7_c_pointer_with_type(sc, end, GtkTextIter__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_buffer_delete_selection(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_delete_selection "gboolean gtk_text_buffer_delete_selection(GtkTextBuffer* buffer, \
gboolean interactive, gboolean default_editable)"
  s7_pointer _p;
  s7_pointer buffer, interactive, default_editable;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  interactive = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_boolean(interactive)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_delete_selection", 2, interactive, "gboolean");
  default_editable = s7_car(_p);
  if (!s7_is_boolean(default_editable)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_delete_selection", 3, default_editable, "gboolean");
  return(s7_make_boolean(sc, gtk_text_buffer_delete_selection((GtkTextBuffer*)s7_c_pointer_with_type(sc, buffer, GtkTextBuffer__sym, __func__, 0), (gboolean)lg_boolean(interactive), (gboolean)lg_boolean(default_editable))));
}

static s7_pointer lg_gtk_text_buffer_begin_user_action(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_begin_user_action "void gtk_text_buffer_begin_user_action(GtkTextBuffer* buffer)"
  s7_pointer buffer;
  buffer = s7_car(args);
  gtk_text_buffer_begin_user_action((GtkTextBuffer*)s7_c_pointer_with_type(sc, buffer, GtkTextBuffer__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_text_buffer_end_user_action(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_end_user_action "void gtk_text_buffer_end_user_action(GtkTextBuffer* buffer)"
  s7_pointer buffer;
  buffer = s7_car(args);
  gtk_text_buffer_end_user_action((GtkTextBuffer*)s7_c_pointer_with_type(sc, buffer, GtkTextBuffer__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_text_child_anchor_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_child_anchor_new "GtkTextChildAnchor* gtk_text_child_anchor_new( void)"
  return(lg_make_c_pointer_with_type(sc, GtkTextChildAnchor__sym, gtk_text_child_anchor_new()));
}

static s7_pointer lg_gtk_text_child_anchor_get_deleted(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_child_anchor_get_deleted "gboolean gtk_text_child_anchor_get_deleted(GtkTextChildAnchor* anchor)"
  s7_pointer anchor;
  anchor = s7_car(args);
  return(s7_make_boolean(sc, gtk_text_child_anchor_get_deleted((GtkTextChildAnchor*)s7_c_pointer_with_type(sc, anchor, GtkTextChildAnchor__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_iter_get_buffer(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_get_buffer "GtkTextBuffer* gtk_text_iter_get_buffer(GtkTextIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GtkTextBuffer__sym, gtk_text_iter_get_buffer((GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_iter_copy(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_copy "GtkTextIter* gtk_text_iter_copy(GtkTextIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GtkTextIter__sym, gtk_text_iter_copy((GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_iter_free(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_free "void gtk_text_iter_free(GtkTextIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  gtk_text_iter_free((GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_text_iter_get_offset(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_get_offset "gint gtk_text_iter_get_offset(GtkTextIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  return(s7_make_integer(sc, gtk_text_iter_get_offset((GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_iter_get_line(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_get_line "gint gtk_text_iter_get_line(GtkTextIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  return(s7_make_integer(sc, gtk_text_iter_get_line((GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_iter_get_line_offset(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_get_line_offset "gint gtk_text_iter_get_line_offset(GtkTextIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  return(s7_make_integer(sc, gtk_text_iter_get_line_offset((GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_iter_get_line_index(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_get_line_index "gint gtk_text_iter_get_line_index(GtkTextIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  return(s7_make_integer(sc, gtk_text_iter_get_line_index((GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_iter_get_visible_line_offset(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_get_visible_line_offset "gint gtk_text_iter_get_visible_line_offset(GtkTextIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  return(s7_make_integer(sc, gtk_text_iter_get_visible_line_offset((GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_iter_get_visible_line_index(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_get_visible_line_index "gint gtk_text_iter_get_visible_line_index(GtkTextIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  return(s7_make_integer(sc, gtk_text_iter_get_visible_line_index((GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_iter_get_char(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_get_char "gunichar gtk_text_iter_get_char(GtkTextIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  return(s7_make_integer(sc, gtk_text_iter_get_char((GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_iter_get_slice(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_get_slice "gchar* gtk_text_iter_get_slice(GtkTextIter* start, GtkTextIter* end)"
  s7_pointer _p;
  s7_pointer start, end;
  _p = args;
  start = s7_car(_p); _p = s7_cdr(_p);
  end = s7_car(_p);
  {
    gchar* res_ult;
    s7_pointer rtn;
    res_ult = gtk_text_iter_get_slice((GtkTextIter*)s7_c_pointer_with_type(sc, start, GtkTextIter__sym, __func__, 0), (GtkTextIter*)s7_c_pointer_with_type(sc, end, GtkTextIter__sym, __func__, 0));
    rtn = s7_make_string(sc, res_ult);
    g_free(res_ult);
    return(rtn);
  }
}

static s7_pointer lg_gtk_text_iter_get_text(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_get_text "gchar* gtk_text_iter_get_text(GtkTextIter* start, GtkTextIter* end)"
  s7_pointer _p;
  s7_pointer start, end;
  _p = args;
  start = s7_car(_p); _p = s7_cdr(_p);
  end = s7_car(_p);
  {
    gchar* res_ult;
    s7_pointer rtn;
    res_ult = gtk_text_iter_get_text((GtkTextIter*)s7_c_pointer_with_type(sc, start, GtkTextIter__sym, __func__, 0), (GtkTextIter*)s7_c_pointer_with_type(sc, end, GtkTextIter__sym, __func__, 0));
    rtn = s7_make_string(sc, res_ult);
    g_free(res_ult);
    return(rtn);
  }
}

static s7_pointer lg_gtk_text_iter_get_visible_slice(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_get_visible_slice "gchar* gtk_text_iter_get_visible_slice(GtkTextIter* start, \
GtkTextIter* end)"
  s7_pointer _p;
  s7_pointer start, end;
  _p = args;
  start = s7_car(_p); _p = s7_cdr(_p);
  end = s7_car(_p);
  {
    gchar* res_ult;
    s7_pointer rtn;
    res_ult = gtk_text_iter_get_visible_slice((GtkTextIter*)s7_c_pointer_with_type(sc, start, GtkTextIter__sym, __func__, 0), (GtkTextIter*)s7_c_pointer_with_type(sc, end, GtkTextIter__sym, __func__, 0));
    rtn = s7_make_string(sc, res_ult);
    g_free(res_ult);
    return(rtn);
  }
}

static s7_pointer lg_gtk_text_iter_get_visible_text(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_get_visible_text "gchar* gtk_text_iter_get_visible_text(GtkTextIter* start, \
GtkTextIter* end)"
  s7_pointer _p;
  s7_pointer start, end;
  _p = args;
  start = s7_car(_p); _p = s7_cdr(_p);
  end = s7_car(_p);
  {
    gchar* res_ult;
    s7_pointer rtn;
    res_ult = gtk_text_iter_get_visible_text((GtkTextIter*)s7_c_pointer_with_type(sc, start, GtkTextIter__sym, __func__, 0), (GtkTextIter*)s7_c_pointer_with_type(sc, end, GtkTextIter__sym, __func__, 0));
    rtn = s7_make_string(sc, res_ult);
    g_free(res_ult);
    return(rtn);
  }
}

static s7_pointer lg_gtk_text_iter_get_marks(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_get_marks "GSList* gtk_text_iter_get_marks(GtkTextIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GSList__sym, gtk_text_iter_get_marks((GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_iter_get_child_anchor(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_get_child_anchor "GtkTextChildAnchor* gtk_text_iter_get_child_anchor(GtkTextIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GtkTextChildAnchor__sym, gtk_text_iter_get_child_anchor((GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_iter_get_toggled_tags(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_get_toggled_tags "GSList* gtk_text_iter_get_toggled_tags(GtkTextIter* iter, \
gboolean toggled_on)"
  s7_pointer _p;
  s7_pointer iter, toggled_on;
  _p = args;
  iter = s7_car(_p); _p = s7_cdr(_p);
  toggled_on = s7_car(_p);
  if (!s7_is_boolean(toggled_on)) s7_wrong_type_arg_error(sc, "gtk_text_iter_get_toggled_tags", 2, toggled_on, "gboolean");
  return(lg_make_c_pointer_with_type(sc, GSList__sym, gtk_text_iter_get_toggled_tags((GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0), (gboolean)lg_boolean(toggled_on))));
}

static s7_pointer lg_gtk_text_iter_ends_tag(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_ends_tag "gboolean gtk_text_iter_ends_tag(GtkTextIter* iter, GtkTextTag* tag)"
  s7_pointer _p;
  s7_pointer iter, tag;
  _p = args;
  iter = s7_car(_p); _p = s7_cdr(_p);
  tag = s7_car(_p);
  return(s7_make_boolean(sc, gtk_text_iter_ends_tag((GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0), (GtkTextTag*)s7_c_pointer_with_type(sc, tag, GtkTextTag__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_iter_toggles_tag(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_toggles_tag "gboolean gtk_text_iter_toggles_tag(GtkTextIter* iter, GtkTextTag* tag)"
  s7_pointer _p;
  s7_pointer iter, tag;
  _p = args;
  iter = s7_car(_p); _p = s7_cdr(_p);
  tag = s7_car(_p);
  return(s7_make_boolean(sc, gtk_text_iter_toggles_tag((GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0), (GtkTextTag*)s7_c_pointer_with_type(sc, tag, GtkTextTag__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_iter_has_tag(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_has_tag "gboolean gtk_text_iter_has_tag(GtkTextIter* iter, GtkTextTag* tag)"
  s7_pointer _p;
  s7_pointer iter, tag;
  _p = args;
  iter = s7_car(_p); _p = s7_cdr(_p);
  tag = s7_car(_p);
  return(s7_make_boolean(sc, gtk_text_iter_has_tag((GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0), (GtkTextTag*)s7_c_pointer_with_type(sc, tag, GtkTextTag__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_iter_get_tags(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_get_tags "GSList* gtk_text_iter_get_tags(GtkTextIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GSList__sym, gtk_text_iter_get_tags((GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_iter_editable(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_editable "gboolean gtk_text_iter_editable(GtkTextIter* iter, gboolean default_setting)"
  s7_pointer _p;
  s7_pointer iter, default_setting;
  _p = args;
  iter = s7_car(_p); _p = s7_cdr(_p);
  default_setting = s7_car(_p);
  if (!s7_is_boolean(default_setting)) s7_wrong_type_arg_error(sc, "gtk_text_iter_editable", 2, default_setting, "gboolean");
  return(s7_make_boolean(sc, gtk_text_iter_editable((GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0), (gboolean)lg_boolean(default_setting))));
}

static s7_pointer lg_gtk_text_iter_can_insert(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_can_insert "gboolean gtk_text_iter_can_insert(GtkTextIter* iter, gboolean default_editability)"
  s7_pointer _p;
  s7_pointer iter, default_editability;
  _p = args;
  iter = s7_car(_p); _p = s7_cdr(_p);
  default_editability = s7_car(_p);
  if (!s7_is_boolean(default_editability)) s7_wrong_type_arg_error(sc, "gtk_text_iter_can_insert", 2, default_editability, "gboolean");
  return(s7_make_boolean(sc, gtk_text_iter_can_insert((GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0), (gboolean)lg_boolean(default_editability))));
}

static s7_pointer lg_gtk_text_iter_starts_word(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_starts_word "gboolean gtk_text_iter_starts_word(GtkTextIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  return(s7_make_boolean(sc, gtk_text_iter_starts_word((GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_iter_ends_word(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_ends_word "gboolean gtk_text_iter_ends_word(GtkTextIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  return(s7_make_boolean(sc, gtk_text_iter_ends_word((GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_iter_inside_word(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_inside_word "gboolean gtk_text_iter_inside_word(GtkTextIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  return(s7_make_boolean(sc, gtk_text_iter_inside_word((GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_iter_starts_sentence(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_starts_sentence "gboolean gtk_text_iter_starts_sentence(GtkTextIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  return(s7_make_boolean(sc, gtk_text_iter_starts_sentence((GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_iter_ends_sentence(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_ends_sentence "gboolean gtk_text_iter_ends_sentence(GtkTextIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  return(s7_make_boolean(sc, gtk_text_iter_ends_sentence((GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_iter_inside_sentence(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_inside_sentence "gboolean gtk_text_iter_inside_sentence(GtkTextIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  return(s7_make_boolean(sc, gtk_text_iter_inside_sentence((GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_iter_starts_line(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_starts_line "gboolean gtk_text_iter_starts_line(GtkTextIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  return(s7_make_boolean(sc, gtk_text_iter_starts_line((GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_iter_ends_line(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_ends_line "gboolean gtk_text_iter_ends_line(GtkTextIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  return(s7_make_boolean(sc, gtk_text_iter_ends_line((GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_iter_is_cursor_position(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_is_cursor_position "gboolean gtk_text_iter_is_cursor_position(GtkTextIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  return(s7_make_boolean(sc, gtk_text_iter_is_cursor_position((GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_iter_get_chars_in_line(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_get_chars_in_line "gint gtk_text_iter_get_chars_in_line(GtkTextIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  return(s7_make_integer(sc, gtk_text_iter_get_chars_in_line((GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_iter_get_bytes_in_line(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_get_bytes_in_line "gint gtk_text_iter_get_bytes_in_line(GtkTextIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  return(s7_make_integer(sc, gtk_text_iter_get_bytes_in_line((GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_iter_get_language(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_get_language "PangoLanguage* gtk_text_iter_get_language(GtkTextIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, PangoLanguage__sym, gtk_text_iter_get_language((GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_iter_is_end(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_is_end "gboolean gtk_text_iter_is_end(GtkTextIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  return(s7_make_boolean(sc, gtk_text_iter_is_end((GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_iter_is_start(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_is_start "gboolean gtk_text_iter_is_start(GtkTextIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  return(s7_make_boolean(sc, gtk_text_iter_is_start((GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_iter_forward_char(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_forward_char "gboolean gtk_text_iter_forward_char(GtkTextIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  return(s7_make_boolean(sc, gtk_text_iter_forward_char((GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_iter_backward_char(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_backward_char "gboolean gtk_text_iter_backward_char(GtkTextIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  return(s7_make_boolean(sc, gtk_text_iter_backward_char((GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_iter_forward_chars(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_forward_chars "gboolean gtk_text_iter_forward_chars(GtkTextIter* iter, gint count)"
  s7_pointer _p;
  s7_pointer iter, count;
  _p = args;
  iter = s7_car(_p); _p = s7_cdr(_p);
  count = s7_car(_p);
  if (!s7_is_integer(count)) s7_wrong_type_arg_error(sc, "gtk_text_iter_forward_chars", 2, count, "gint");
  return(s7_make_boolean(sc, gtk_text_iter_forward_chars((GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0), (gint)s7_integer(count))));
}

static s7_pointer lg_gtk_text_iter_backward_chars(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_backward_chars "gboolean gtk_text_iter_backward_chars(GtkTextIter* iter, gint count)"
  s7_pointer _p;
  s7_pointer iter, count;
  _p = args;
  iter = s7_car(_p); _p = s7_cdr(_p);
  count = s7_car(_p);
  if (!s7_is_integer(count)) s7_wrong_type_arg_error(sc, "gtk_text_iter_backward_chars", 2, count, "gint");
  return(s7_make_boolean(sc, gtk_text_iter_backward_chars((GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0), (gint)s7_integer(count))));
}

static s7_pointer lg_gtk_text_iter_forward_line(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_forward_line "gboolean gtk_text_iter_forward_line(GtkTextIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  return(s7_make_boolean(sc, gtk_text_iter_forward_line((GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_iter_backward_line(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_backward_line "gboolean gtk_text_iter_backward_line(GtkTextIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  return(s7_make_boolean(sc, gtk_text_iter_backward_line((GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_iter_forward_lines(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_forward_lines "gboolean gtk_text_iter_forward_lines(GtkTextIter* iter, gint count)"
  s7_pointer _p;
  s7_pointer iter, count;
  _p = args;
  iter = s7_car(_p); _p = s7_cdr(_p);
  count = s7_car(_p);
  if (!s7_is_integer(count)) s7_wrong_type_arg_error(sc, "gtk_text_iter_forward_lines", 2, count, "gint");
  return(s7_make_boolean(sc, gtk_text_iter_forward_lines((GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0), (gint)s7_integer(count))));
}

static s7_pointer lg_gtk_text_iter_backward_lines(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_backward_lines "gboolean gtk_text_iter_backward_lines(GtkTextIter* iter, gint count)"
  s7_pointer _p;
  s7_pointer iter, count;
  _p = args;
  iter = s7_car(_p); _p = s7_cdr(_p);
  count = s7_car(_p);
  if (!s7_is_integer(count)) s7_wrong_type_arg_error(sc, "gtk_text_iter_backward_lines", 2, count, "gint");
  return(s7_make_boolean(sc, gtk_text_iter_backward_lines((GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0), (gint)s7_integer(count))));
}

static s7_pointer lg_gtk_text_iter_forward_word_end(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_forward_word_end "gboolean gtk_text_iter_forward_word_end(GtkTextIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  return(s7_make_boolean(sc, gtk_text_iter_forward_word_end((GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_iter_backward_word_start(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_backward_word_start "gboolean gtk_text_iter_backward_word_start(GtkTextIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  return(s7_make_boolean(sc, gtk_text_iter_backward_word_start((GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_iter_forward_word_ends(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_forward_word_ends "gboolean gtk_text_iter_forward_word_ends(GtkTextIter* iter, \
gint count)"
  s7_pointer _p;
  s7_pointer iter, count;
  _p = args;
  iter = s7_car(_p); _p = s7_cdr(_p);
  count = s7_car(_p);
  if (!s7_is_integer(count)) s7_wrong_type_arg_error(sc, "gtk_text_iter_forward_word_ends", 2, count, "gint");
  return(s7_make_boolean(sc, gtk_text_iter_forward_word_ends((GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0), (gint)s7_integer(count))));
}

static s7_pointer lg_gtk_text_iter_backward_word_starts(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_backward_word_starts "gboolean gtk_text_iter_backward_word_starts(GtkTextIter* iter, \
gint count)"
  s7_pointer _p;
  s7_pointer iter, count;
  _p = args;
  iter = s7_car(_p); _p = s7_cdr(_p);
  count = s7_car(_p);
  if (!s7_is_integer(count)) s7_wrong_type_arg_error(sc, "gtk_text_iter_backward_word_starts", 2, count, "gint");
  return(s7_make_boolean(sc, gtk_text_iter_backward_word_starts((GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0), (gint)s7_integer(count))));
}

static s7_pointer lg_gtk_text_iter_forward_sentence_end(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_forward_sentence_end "gboolean gtk_text_iter_forward_sentence_end(GtkTextIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  return(s7_make_boolean(sc, gtk_text_iter_forward_sentence_end((GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_iter_backward_sentence_start(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_backward_sentence_start "gboolean gtk_text_iter_backward_sentence_start(GtkTextIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  return(s7_make_boolean(sc, gtk_text_iter_backward_sentence_start((GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_iter_forward_sentence_ends(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_forward_sentence_ends "gboolean gtk_text_iter_forward_sentence_ends(GtkTextIter* iter, \
gint count)"
  s7_pointer _p;
  s7_pointer iter, count;
  _p = args;
  iter = s7_car(_p); _p = s7_cdr(_p);
  count = s7_car(_p);
  if (!s7_is_integer(count)) s7_wrong_type_arg_error(sc, "gtk_text_iter_forward_sentence_ends", 2, count, "gint");
  return(s7_make_boolean(sc, gtk_text_iter_forward_sentence_ends((GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0), (gint)s7_integer(count))));
}

static s7_pointer lg_gtk_text_iter_backward_sentence_starts(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_backward_sentence_starts "gboolean gtk_text_iter_backward_sentence_starts(GtkTextIter* iter, \
gint count)"
  s7_pointer _p;
  s7_pointer iter, count;
  _p = args;
  iter = s7_car(_p); _p = s7_cdr(_p);
  count = s7_car(_p);
  if (!s7_is_integer(count)) s7_wrong_type_arg_error(sc, "gtk_text_iter_backward_sentence_starts", 2, count, "gint");
  return(s7_make_boolean(sc, gtk_text_iter_backward_sentence_starts((GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0), (gint)s7_integer(count))));
}

static s7_pointer lg_gtk_text_iter_forward_cursor_position(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_forward_cursor_position "gboolean gtk_text_iter_forward_cursor_position(GtkTextIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  return(s7_make_boolean(sc, gtk_text_iter_forward_cursor_position((GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_iter_backward_cursor_position(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_backward_cursor_position "gboolean gtk_text_iter_backward_cursor_position(GtkTextIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  return(s7_make_boolean(sc, gtk_text_iter_backward_cursor_position((GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_iter_forward_cursor_positions(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_forward_cursor_positions "gboolean gtk_text_iter_forward_cursor_positions(GtkTextIter* iter, \
gint count)"
  s7_pointer _p;
  s7_pointer iter, count;
  _p = args;
  iter = s7_car(_p); _p = s7_cdr(_p);
  count = s7_car(_p);
  if (!s7_is_integer(count)) s7_wrong_type_arg_error(sc, "gtk_text_iter_forward_cursor_positions", 2, count, "gint");
  return(s7_make_boolean(sc, gtk_text_iter_forward_cursor_positions((GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0), (gint)s7_integer(count))));
}

static s7_pointer lg_gtk_text_iter_backward_cursor_positions(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_backward_cursor_positions "gboolean gtk_text_iter_backward_cursor_positions(GtkTextIter* iter, \
gint count)"
  s7_pointer _p;
  s7_pointer iter, count;
  _p = args;
  iter = s7_car(_p); _p = s7_cdr(_p);
  count = s7_car(_p);
  if (!s7_is_integer(count)) s7_wrong_type_arg_error(sc, "gtk_text_iter_backward_cursor_positions", 2, count, "gint");
  return(s7_make_boolean(sc, gtk_text_iter_backward_cursor_positions((GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0), (gint)s7_integer(count))));
}

static s7_pointer lg_gtk_text_iter_set_offset(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_set_offset "void gtk_text_iter_set_offset(GtkTextIter* iter, gint char_offset)"
  s7_pointer _p;
  s7_pointer iter, char_offset;
  _p = args;
  iter = s7_car(_p); _p = s7_cdr(_p);
  char_offset = s7_car(_p);
  if (!s7_is_integer(char_offset)) s7_wrong_type_arg_error(sc, "gtk_text_iter_set_offset", 2, char_offset, "gint");
  gtk_text_iter_set_offset((GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0), (gint)s7_integer(char_offset));
  return(lg_false);
}

static s7_pointer lg_gtk_text_iter_set_line(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_set_line "void gtk_text_iter_set_line(GtkTextIter* iter, gint line_number)"
  s7_pointer _p;
  s7_pointer iter, line_number;
  _p = args;
  iter = s7_car(_p); _p = s7_cdr(_p);
  line_number = s7_car(_p);
  if (!s7_is_integer(line_number)) s7_wrong_type_arg_error(sc, "gtk_text_iter_set_line", 2, line_number, "gint");
  gtk_text_iter_set_line((GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0), (gint)s7_integer(line_number));
  return(lg_false);
}

static s7_pointer lg_gtk_text_iter_set_line_offset(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_set_line_offset "void gtk_text_iter_set_line_offset(GtkTextIter* iter, gint char_on_line)"
  s7_pointer _p;
  s7_pointer iter, char_on_line;
  _p = args;
  iter = s7_car(_p); _p = s7_cdr(_p);
  char_on_line = s7_car(_p);
  if (!s7_is_integer(char_on_line)) s7_wrong_type_arg_error(sc, "gtk_text_iter_set_line_offset", 2, char_on_line, "gint");
  gtk_text_iter_set_line_offset((GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0), (gint)s7_integer(char_on_line));
  return(lg_false);
}

static s7_pointer lg_gtk_text_iter_set_line_index(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_set_line_index "void gtk_text_iter_set_line_index(GtkTextIter* iter, gint byte_on_line)"
  s7_pointer _p;
  s7_pointer iter, byte_on_line;
  _p = args;
  iter = s7_car(_p); _p = s7_cdr(_p);
  byte_on_line = s7_car(_p);
  if (!s7_is_integer(byte_on_line)) s7_wrong_type_arg_error(sc, "gtk_text_iter_set_line_index", 2, byte_on_line, "gint");
  gtk_text_iter_set_line_index((GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0), (gint)s7_integer(byte_on_line));
  return(lg_false);
}

static s7_pointer lg_gtk_text_iter_forward_to_end(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_forward_to_end "void gtk_text_iter_forward_to_end(GtkTextIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  gtk_text_iter_forward_to_end((GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_text_iter_forward_to_line_end(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_forward_to_line_end "gboolean gtk_text_iter_forward_to_line_end(GtkTextIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  return(s7_make_boolean(sc, gtk_text_iter_forward_to_line_end((GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_iter_set_visible_line_offset(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_set_visible_line_offset "void gtk_text_iter_set_visible_line_offset(GtkTextIter* iter, \
gint char_on_line)"
  s7_pointer _p;
  s7_pointer iter, char_on_line;
  _p = args;
  iter = s7_car(_p); _p = s7_cdr(_p);
  char_on_line = s7_car(_p);
  if (!s7_is_integer(char_on_line)) s7_wrong_type_arg_error(sc, "gtk_text_iter_set_visible_line_offset", 2, char_on_line, "gint");
  gtk_text_iter_set_visible_line_offset((GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0), (gint)s7_integer(char_on_line));
  return(lg_false);
}

static s7_pointer lg_gtk_text_iter_set_visible_line_index(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_set_visible_line_index "void gtk_text_iter_set_visible_line_index(GtkTextIter* iter, \
gint byte_on_line)"
  s7_pointer _p;
  s7_pointer iter, byte_on_line;
  _p = args;
  iter = s7_car(_p); _p = s7_cdr(_p);
  byte_on_line = s7_car(_p);
  if (!s7_is_integer(byte_on_line)) s7_wrong_type_arg_error(sc, "gtk_text_iter_set_visible_line_index", 2, byte_on_line, "gint");
  gtk_text_iter_set_visible_line_index((GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0), (gint)s7_integer(byte_on_line));
  return(lg_false);
}

static s7_pointer lg_gtk_text_iter_forward_to_tag_toggle(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_forward_to_tag_toggle "gboolean gtk_text_iter_forward_to_tag_toggle(GtkTextIter* iter, \
GtkTextTag* tag)"
  s7_pointer _p;
  s7_pointer iter, tag;
  _p = args;
  iter = s7_car(_p); _p = s7_cdr(_p);
  tag = s7_car(_p);
  return(s7_make_boolean(sc, gtk_text_iter_forward_to_tag_toggle((GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0), (GtkTextTag*)s7_c_pointer_with_type(sc, tag, GtkTextTag__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_iter_backward_to_tag_toggle(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_backward_to_tag_toggle "gboolean gtk_text_iter_backward_to_tag_toggle(GtkTextIter* iter, \
GtkTextTag* tag)"
  s7_pointer _p;
  s7_pointer iter, tag;
  _p = args;
  iter = s7_car(_p); _p = s7_cdr(_p);
  tag = s7_car(_p);
  return(s7_make_boolean(sc, gtk_text_iter_backward_to_tag_toggle((GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0), (GtkTextTag*)s7_c_pointer_with_type(sc, tag, GtkTextTag__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_iter_forward_find_char(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_forward_find_char "gboolean gtk_text_iter_forward_find_char(GtkTextIter* iter, \
GtkTextCharPredicate pred, lambda_data func_info, GtkTextIter* limit)"
  s7_pointer _p;
  s7_pointer iter /* , pred */ , func_info, limit;
  _p = args;
  iter = s7_car(_p); _p = s7_cdr(_p);
  /* pred = s7_car(_p); */ _p = s7_cdr(_p);
  func_info = s7_car(_p); _p = s7_cdr(_p);
  limit = s7_car(_p);
  {
    s7_pointer res_ult;
    int loc;
    s7_pointer lg_ptr = s7_list(sc, 5, lg_false, func_info, lg_false, lg_false, lg_false);
    loc = s7_gc_protect(sc, lg_ptr);
    s7_list_set(sc, lg_ptr, 2, s7_make_integer(sc, loc));
    res_ult = s7_make_boolean(sc, gtk_text_iter_forward_find_char((GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0), lg_text_char_predicate, (gpointer)lg_ptr, (GtkTextIter*)s7_c_pointer_with_type(sc, limit, GtkTextIter__sym, __func__, 0)));
    return(res_ult);
   }
}

static s7_pointer lg_gtk_text_iter_backward_find_char(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_backward_find_char "gboolean gtk_text_iter_backward_find_char(GtkTextIter* iter, \
GtkTextCharPredicate pred, lambda_data func_info, GtkTextIter* limit)"
  s7_pointer _p;
  s7_pointer iter /* , pred */ , func_info, limit;
  _p = args;
  iter = s7_car(_p); _p = s7_cdr(_p);
  /* pred = s7_car(_p); */ _p = s7_cdr(_p);
  func_info = s7_car(_p); _p = s7_cdr(_p);
  limit = s7_car(_p);
  {
    s7_pointer res_ult;
    int loc;
    s7_pointer lg_ptr = s7_list(sc, 5, lg_false, func_info, lg_false, lg_false, lg_false);
    loc = s7_gc_protect(sc, lg_ptr);
    s7_list_set(sc, lg_ptr, 2, s7_make_integer(sc, loc));
    res_ult = s7_make_boolean(sc, gtk_text_iter_backward_find_char((GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0), lg_text_char_predicate, (gpointer)lg_ptr, (GtkTextIter*)s7_c_pointer_with_type(sc, limit, GtkTextIter__sym, __func__, 0)));
    return(res_ult);
   }
}

static s7_pointer lg_gtk_text_iter_forward_search(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_forward_search "gboolean gtk_text_iter_forward_search(GtkTextIter* iter, gchar* str, \
GtkTextSearchFlags flags, GtkTextIter* match_start, GtkTextIter* match_end, GtkTextIter* limit)"
  s7_pointer _p;
  s7_pointer iter, str, flags, match_start, match_end, limit;
  _p = args;
  iter = s7_car(_p); _p = s7_cdr(_p);
  str = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(str)) s7_wrong_type_arg_error(sc, "gtk_text_iter_forward_search", 2, str, "gchar*");
  flags = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(flags)) s7_wrong_type_arg_error(sc, "gtk_text_iter_forward_search", 3, flags, "GtkTextSearchFlags");
  match_start = s7_car(_p); _p = s7_cdr(_p);
  match_end = s7_car(_p); _p = s7_cdr(_p);
  limit = s7_car(_p);
  return(s7_make_boolean(sc, gtk_text_iter_forward_search((GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0), (gchar*)s7_string(str), (GtkTextSearchFlags)s7_integer(flags), (GtkTextIter*)s7_c_pointer_with_type(sc, match_start, GtkTextIter__sym, __func__, 0), (GtkTextIter*)s7_c_pointer_with_type(sc, match_end, GtkTextIter__sym, __func__, 0), (GtkTextIter*)s7_c_pointer_with_type(sc, limit, GtkTextIter__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_iter_backward_search(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_backward_search "gboolean gtk_text_iter_backward_search(GtkTextIter* iter, \
gchar* str, GtkTextSearchFlags flags, GtkTextIter* match_start, GtkTextIter* match_end, GtkTextIter* limit)"
  s7_pointer _p;
  s7_pointer iter, str, flags, match_start, match_end, limit;
  _p = args;
  iter = s7_car(_p); _p = s7_cdr(_p);
  str = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(str)) s7_wrong_type_arg_error(sc, "gtk_text_iter_backward_search", 2, str, "gchar*");
  flags = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(flags)) s7_wrong_type_arg_error(sc, "gtk_text_iter_backward_search", 3, flags, "GtkTextSearchFlags");
  match_start = s7_car(_p); _p = s7_cdr(_p);
  match_end = s7_car(_p); _p = s7_cdr(_p);
  limit = s7_car(_p);
  return(s7_make_boolean(sc, gtk_text_iter_backward_search((GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0), (gchar*)s7_string(str), (GtkTextSearchFlags)s7_integer(flags), (GtkTextIter*)s7_c_pointer_with_type(sc, match_start, GtkTextIter__sym, __func__, 0), (GtkTextIter*)s7_c_pointer_with_type(sc, match_end, GtkTextIter__sym, __func__, 0), (GtkTextIter*)s7_c_pointer_with_type(sc, limit, GtkTextIter__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_iter_equal(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_equal "gboolean gtk_text_iter_equal(GtkTextIter* lhs, GtkTextIter* rhs)"
  s7_pointer _p;
  s7_pointer lhs, rhs;
  _p = args;
  lhs = s7_car(_p); _p = s7_cdr(_p);
  rhs = s7_car(_p);
  return(s7_make_boolean(sc, gtk_text_iter_equal((GtkTextIter*)s7_c_pointer_with_type(sc, lhs, GtkTextIter__sym, __func__, 0), (GtkTextIter*)s7_c_pointer_with_type(sc, rhs, GtkTextIter__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_iter_compare(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_compare "gint gtk_text_iter_compare(GtkTextIter* lhs, GtkTextIter* rhs)"
  s7_pointer _p;
  s7_pointer lhs, rhs;
  _p = args;
  lhs = s7_car(_p); _p = s7_cdr(_p);
  rhs = s7_car(_p);
  return(s7_make_integer(sc, gtk_text_iter_compare((GtkTextIter*)s7_c_pointer_with_type(sc, lhs, GtkTextIter__sym, __func__, 0), (GtkTextIter*)s7_c_pointer_with_type(sc, rhs, GtkTextIter__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_iter_in_range(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_in_range "gboolean gtk_text_iter_in_range(GtkTextIter* iter, GtkTextIter* start, \
GtkTextIter* end)"
  s7_pointer _p;
  s7_pointer iter, start, end;
  _p = args;
  iter = s7_car(_p); _p = s7_cdr(_p);
  start = s7_car(_p); _p = s7_cdr(_p);
  end = s7_car(_p);
  return(s7_make_boolean(sc, gtk_text_iter_in_range((GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0), (GtkTextIter*)s7_c_pointer_with_type(sc, start, GtkTextIter__sym, __func__, 0), (GtkTextIter*)s7_c_pointer_with_type(sc, end, GtkTextIter__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_iter_order(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_order "void gtk_text_iter_order(GtkTextIter* first, GtkTextIter* second)"
  s7_pointer _p;
  s7_pointer first, second;
  _p = args;
  first = s7_car(_p); _p = s7_cdr(_p);
  second = s7_car(_p);
  gtk_text_iter_order((GtkTextIter*)s7_c_pointer_with_type(sc, first, GtkTextIter__sym, __func__, 0), (GtkTextIter*)s7_c_pointer_with_type(sc, second, GtkTextIter__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_text_mark_set_visible(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_mark_set_visible "void gtk_text_mark_set_visible(GtkTextMark* mark, gboolean setting)"
  s7_pointer _p;
  s7_pointer mark, setting;
  _p = args;
  mark = s7_car(_p); _p = s7_cdr(_p);
  setting = s7_car(_p);
  if (!s7_is_boolean(setting)) s7_wrong_type_arg_error(sc, "gtk_text_mark_set_visible", 2, setting, "gboolean");
  gtk_text_mark_set_visible((GtkTextMark*)s7_c_pointer_with_type(sc, mark, GtkTextMark__sym, __func__, 0), (gboolean)lg_boolean(setting));
  return(lg_false);
}

static s7_pointer lg_gtk_text_mark_get_visible(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_mark_get_visible "gboolean gtk_text_mark_get_visible(GtkTextMark* mark)"
  s7_pointer mark;
  mark = s7_car(args);
  return(s7_make_boolean(sc, gtk_text_mark_get_visible((GtkTextMark*)s7_c_pointer_with_type(sc, mark, GtkTextMark__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_mark_get_name(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_mark_get_name "char* gtk_text_mark_get_name(GtkTextMark* mark)"
  s7_pointer mark;
  mark = s7_car(args);
  return(s7_make_string(sc, gtk_text_mark_get_name((GtkTextMark*)s7_c_pointer_with_type(sc, mark, GtkTextMark__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_mark_get_deleted(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_mark_get_deleted "gboolean gtk_text_mark_get_deleted(GtkTextMark* mark)"
  s7_pointer mark;
  mark = s7_car(args);
  return(s7_make_boolean(sc, gtk_text_mark_get_deleted((GtkTextMark*)s7_c_pointer_with_type(sc, mark, GtkTextMark__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_mark_get_buffer(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_mark_get_buffer "GtkTextBuffer* gtk_text_mark_get_buffer(GtkTextMark* mark)"
  s7_pointer mark;
  mark = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GtkTextBuffer__sym, gtk_text_mark_get_buffer((GtkTextMark*)s7_c_pointer_with_type(sc, mark, GtkTextMark__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_mark_get_left_gravity(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_mark_get_left_gravity "gboolean gtk_text_mark_get_left_gravity(GtkTextMark* mark)"
  s7_pointer mark;
  mark = s7_car(args);
  return(s7_make_boolean(sc, gtk_text_mark_get_left_gravity((GtkTextMark*)s7_c_pointer_with_type(sc, mark, GtkTextMark__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_tag_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_tag_new "GtkTextTag* gtk_text_tag_new(gchar* name)"
  s7_pointer name;
  name = s7_car(args);
  if (!s7_is_string(name)) s7_wrong_type_arg_error(sc, "gtk_text_tag_new", 1, name, "gchar*");
  return(lg_make_c_pointer_with_type(sc, GtkTextTag__sym, gtk_text_tag_new((gchar*)s7_string(name))));
}

static s7_pointer lg_gtk_text_tag_get_priority(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_tag_get_priority "gint gtk_text_tag_get_priority(GtkTextTag* tag)"
  s7_pointer tag;
  tag = s7_car(args);
  return(s7_make_integer(sc, gtk_text_tag_get_priority((GtkTextTag*)s7_c_pointer_with_type(sc, tag, GtkTextTag__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_tag_set_priority(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_tag_set_priority "void gtk_text_tag_set_priority(GtkTextTag* tag, gint priority)"
  s7_pointer _p;
  s7_pointer tag, priority;
  _p = args;
  tag = s7_car(_p); _p = s7_cdr(_p);
  priority = s7_car(_p);
  if (!s7_is_integer(priority)) s7_wrong_type_arg_error(sc, "gtk_text_tag_set_priority", 2, priority, "gint");
  gtk_text_tag_set_priority((GtkTextTag*)s7_c_pointer_with_type(sc, tag, GtkTextTag__sym, __func__, 0), (gint)s7_integer(priority));
  return(lg_false);
}

static s7_pointer lg_gtk_text_tag_table_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_tag_table_new "GtkTextTagTable* gtk_text_tag_table_new( void)"
  return(lg_make_c_pointer_with_type(sc, GtkTextTagTable__sym, gtk_text_tag_table_new()));
}

static s7_pointer lg_gtk_text_tag_table_add(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_tag_table_add "void gtk_text_tag_table_add(GtkTextTagTable* table, GtkTextTag* tag)"
  s7_pointer _p;
  s7_pointer table, tag;
  _p = args;
  table = s7_car(_p); _p = s7_cdr(_p);
  tag = s7_car(_p);
  gtk_text_tag_table_add((GtkTextTagTable*)s7_c_pointer_with_type(sc, table, GtkTextTagTable__sym, __func__, 0), (GtkTextTag*)s7_c_pointer_with_type(sc, tag, GtkTextTag__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_text_tag_table_remove(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_tag_table_remove "void gtk_text_tag_table_remove(GtkTextTagTable* table, GtkTextTag* tag)"
  s7_pointer _p;
  s7_pointer table, tag;
  _p = args;
  table = s7_car(_p); _p = s7_cdr(_p);
  tag = s7_car(_p);
  gtk_text_tag_table_remove((GtkTextTagTable*)s7_c_pointer_with_type(sc, table, GtkTextTagTable__sym, __func__, 0), (GtkTextTag*)s7_c_pointer_with_type(sc, tag, GtkTextTag__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_text_tag_table_lookup(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_tag_table_lookup "GtkTextTag* gtk_text_tag_table_lookup(GtkTextTagTable* table, \
gchar* name)"
  s7_pointer _p;
  s7_pointer table, name;
  _p = args;
  table = s7_car(_p); _p = s7_cdr(_p);
  name = s7_car(_p);
  if (!s7_is_string(name)) s7_wrong_type_arg_error(sc, "gtk_text_tag_table_lookup", 2, name, "gchar*");
  return(lg_make_c_pointer_with_type(sc, GtkTextTag__sym, gtk_text_tag_table_lookup((GtkTextTagTable*)s7_c_pointer_with_type(sc, table, GtkTextTagTable__sym, __func__, 0), (gchar*)s7_string(name))));
}

static s7_pointer lg_gtk_text_tag_table_foreach(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_tag_table_foreach "void gtk_text_tag_table_foreach(GtkTextTagTable* table, GtkTextTagTableForeach func, \
lambda_data func_info)"
  s7_pointer _p;
  s7_pointer table, func, func_info;
  _p = args;
  table = s7_car(_p); _p = s7_cdr(_p);
  func = s7_car(_p); _p = s7_cdr(_p);
  func_info = s7_car(_p);
  {
    int loc;
    s7_pointer lg_ptr = s7_list(sc, 5, func, func_info, lg_false, lg_false, lg_false);
    loc = s7_gc_protect(sc, lg_ptr);
    s7_list_set(sc, lg_ptr, 2, s7_make_integer(sc, loc));
    gtk_text_tag_table_foreach((GtkTextTagTable*)s7_c_pointer_with_type(sc, table, GtkTextTagTable__sym, __func__, 0), lg_text_tag_table_foreach, (gpointer)lg_ptr);
    return(lg_false);
   }
}

static s7_pointer lg_gtk_text_tag_table_get_size(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_tag_table_get_size "gint gtk_text_tag_table_get_size(GtkTextTagTable* table)"
  s7_pointer table;
  table = s7_car(args);
  return(s7_make_integer(sc, gtk_text_tag_table_get_size((GtkTextTagTable*)s7_c_pointer_with_type(sc, table, GtkTextTagTable__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_view_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_new "GtkWidget* gtk_text_view_new( void)"
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_text_view_new()));
}

static s7_pointer lg_gtk_text_view_new_with_buffer(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_new_with_buffer "GtkWidget* gtk_text_view_new_with_buffer(GtkTextBuffer* buffer)"
  s7_pointer buffer;
  buffer = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_text_view_new_with_buffer((GtkTextBuffer*)s7_c_pointer_with_type(sc, buffer, GtkTextBuffer__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_view_set_buffer(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_set_buffer "void gtk_text_view_set_buffer(GtkTextView* text_view, GtkTextBuffer* buffer)"
  s7_pointer _p;
  s7_pointer text_view, buffer;
  _p = args;
  text_view = s7_car(_p); _p = s7_cdr(_p);
  buffer = s7_car(_p);
  gtk_text_view_set_buffer((GtkTextView*)s7_c_pointer_with_type(sc, text_view, GtkTextView__sym, __func__, 0), (GtkTextBuffer*)s7_c_pointer_with_type(sc, buffer, GtkTextBuffer__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_text_view_get_buffer(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_get_buffer "GtkTextBuffer* gtk_text_view_get_buffer(GtkTextView* text_view)"
  s7_pointer text_view;
  text_view = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GtkTextBuffer__sym, gtk_text_view_get_buffer((GtkTextView*)s7_c_pointer_with_type(sc, text_view, GtkTextView__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_view_scroll_to_iter(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_scroll_to_iter "gboolean gtk_text_view_scroll_to_iter(GtkTextView* text_view, \
GtkTextIter* iter, gdouble within_margin, gboolean use_align, gdouble xalign, gdouble yalign)"
  s7_pointer _p;
  s7_pointer text_view, iter, within_margin, use_align, xalign, yalign;
  _p = args;
  text_view = s7_car(_p); _p = s7_cdr(_p);
  iter = s7_car(_p); _p = s7_cdr(_p);
  within_margin = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(within_margin)) s7_wrong_type_arg_error(sc, "gtk_text_view_scroll_to_iter", 3, within_margin, "gdouble");
  use_align = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_boolean(use_align)) s7_wrong_type_arg_error(sc, "gtk_text_view_scroll_to_iter", 4, use_align, "gboolean");
  xalign = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(xalign)) s7_wrong_type_arg_error(sc, "gtk_text_view_scroll_to_iter", 5, xalign, "gdouble");
  yalign = s7_car(_p);
  if (!s7_is_real(yalign)) s7_wrong_type_arg_error(sc, "gtk_text_view_scroll_to_iter", 6, yalign, "gdouble");
  return(s7_make_boolean(sc, gtk_text_view_scroll_to_iter((GtkTextView*)s7_c_pointer_with_type(sc, text_view, GtkTextView__sym, __func__, 0), (GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0), (gdouble)s7_real(within_margin), (gboolean)lg_boolean(use_align), (gdouble)s7_real(xalign), (gdouble)s7_real(yalign))));
}

static s7_pointer lg_gtk_text_view_scroll_to_mark(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_scroll_to_mark "void gtk_text_view_scroll_to_mark(GtkTextView* text_view, GtkTextMark* mark, \
gdouble within_margin, gboolean use_align, gdouble xalign, gdouble yalign)"
  s7_pointer _p;
  s7_pointer text_view, mark, within_margin, use_align, xalign, yalign;
  _p = args;
  text_view = s7_car(_p); _p = s7_cdr(_p);
  mark = s7_car(_p); _p = s7_cdr(_p);
  within_margin = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(within_margin)) s7_wrong_type_arg_error(sc, "gtk_text_view_scroll_to_mark", 3, within_margin, "gdouble");
  use_align = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_boolean(use_align)) s7_wrong_type_arg_error(sc, "gtk_text_view_scroll_to_mark", 4, use_align, "gboolean");
  xalign = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(xalign)) s7_wrong_type_arg_error(sc, "gtk_text_view_scroll_to_mark", 5, xalign, "gdouble");
  yalign = s7_car(_p);
  if (!s7_is_real(yalign)) s7_wrong_type_arg_error(sc, "gtk_text_view_scroll_to_mark", 6, yalign, "gdouble");
  gtk_text_view_scroll_to_mark((GtkTextView*)s7_c_pointer_with_type(sc, text_view, GtkTextView__sym, __func__, 0), (GtkTextMark*)s7_c_pointer_with_type(sc, mark, GtkTextMark__sym, __func__, 0), (gdouble)s7_real(within_margin), (gboolean)lg_boolean(use_align), (gdouble)s7_real(xalign), (gdouble)s7_real(yalign));
  return(lg_false);
}

static s7_pointer lg_gtk_text_view_scroll_mark_onscreen(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_scroll_mark_onscreen "void gtk_text_view_scroll_mark_onscreen(GtkTextView* text_view, \
GtkTextMark* mark)"
  s7_pointer _p;
  s7_pointer text_view, mark;
  _p = args;
  text_view = s7_car(_p); _p = s7_cdr(_p);
  mark = s7_car(_p);
  gtk_text_view_scroll_mark_onscreen((GtkTextView*)s7_c_pointer_with_type(sc, text_view, GtkTextView__sym, __func__, 0), (GtkTextMark*)s7_c_pointer_with_type(sc, mark, GtkTextMark__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_text_view_move_mark_onscreen(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_move_mark_onscreen "gboolean gtk_text_view_move_mark_onscreen(GtkTextView* text_view, \
GtkTextMark* mark)"
  s7_pointer _p;
  s7_pointer text_view, mark;
  _p = args;
  text_view = s7_car(_p); _p = s7_cdr(_p);
  mark = s7_car(_p);
  return(s7_make_boolean(sc, gtk_text_view_move_mark_onscreen((GtkTextView*)s7_c_pointer_with_type(sc, text_view, GtkTextView__sym, __func__, 0), (GtkTextMark*)s7_c_pointer_with_type(sc, mark, GtkTextMark__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_view_place_cursor_onscreen(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_place_cursor_onscreen "gboolean gtk_text_view_place_cursor_onscreen(GtkTextView* text_view)"
  s7_pointer text_view;
  text_view = s7_car(args);
  return(s7_make_boolean(sc, gtk_text_view_place_cursor_onscreen((GtkTextView*)s7_c_pointer_with_type(sc, text_view, GtkTextView__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_view_get_visible_rect(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_get_visible_rect "void gtk_text_view_get_visible_rect(GtkTextView* text_view, \
GdkRectangle* visible_rect)"
  s7_pointer _p;
  s7_pointer text_view, visible_rect;
  _p = args;
  text_view = s7_car(_p); _p = s7_cdr(_p);
  visible_rect = s7_car(_p);
  gtk_text_view_get_visible_rect((GtkTextView*)s7_c_pointer_with_type(sc, text_view, GtkTextView__sym, __func__, 0), (GdkRectangle*)s7_c_pointer_with_type(sc, visible_rect, GdkRectangle__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_text_view_set_cursor_visible(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_set_cursor_visible "void gtk_text_view_set_cursor_visible(GtkTextView* text_view, \
gboolean setting)"
  s7_pointer _p;
  s7_pointer text_view, setting;
  _p = args;
  text_view = s7_car(_p); _p = s7_cdr(_p);
  setting = s7_car(_p);
  if (!s7_is_boolean(setting)) s7_wrong_type_arg_error(sc, "gtk_text_view_set_cursor_visible", 2, setting, "gboolean");
  gtk_text_view_set_cursor_visible((GtkTextView*)s7_c_pointer_with_type(sc, text_view, GtkTextView__sym, __func__, 0), (gboolean)lg_boolean(setting));
  return(lg_false);
}

static s7_pointer lg_gtk_text_view_get_cursor_visible(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_get_cursor_visible "gboolean gtk_text_view_get_cursor_visible(GtkTextView* text_view)"
  s7_pointer text_view;
  text_view = s7_car(args);
  return(s7_make_boolean(sc, gtk_text_view_get_cursor_visible((GtkTextView*)s7_c_pointer_with_type(sc, text_view, GtkTextView__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_view_get_iter_location(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_get_iter_location "void gtk_text_view_get_iter_location(GtkTextView* text_view, \
GtkTextIter* iter, GdkRectangle* location)"
  s7_pointer _p;
  s7_pointer text_view, iter, location;
  _p = args;
  text_view = s7_car(_p); _p = s7_cdr(_p);
  iter = s7_car(_p); _p = s7_cdr(_p);
  location = s7_car(_p);
  gtk_text_view_get_iter_location((GtkTextView*)s7_c_pointer_with_type(sc, text_view, GtkTextView__sym, __func__, 0), (GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0), (GdkRectangle*)s7_c_pointer_with_type(sc, location, GdkRectangle__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_text_view_get_line_yrange(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_get_line_yrange "void gtk_text_view_get_line_yrange(GtkTextView* text_view, \
GtkTextIter* iter, gint* [y], gint* [height])"
  s7_pointer _p;
  s7_pointer text_view, iter;
  gint ref_y;
  gint ref_height;
  _p = args;
  text_view = s7_car(_p); _p = s7_cdr(_p);
  iter = s7_car(_p);
  gtk_text_view_get_line_yrange((GtkTextView*)s7_c_pointer_with_type(sc, text_view, GtkTextView__sym, __func__, 0), (GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0), &ref_y, &ref_height);
    return(s7_list(sc, 2, s7_make_integer(sc, ref_y), s7_make_integer(sc, ref_height)));
}

static s7_pointer lg_gtk_text_view_get_line_at_y(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_get_line_at_y "void gtk_text_view_get_line_at_y(GtkTextView* text_view, GtkTextIter* target_iter, \
gint y, gint* [line_top])"
  s7_pointer _p;
  s7_pointer text_view, target_iter, y;
  gint ref_line_top;
  _p = args;
  text_view = s7_car(_p); _p = s7_cdr(_p);
  target_iter = s7_car(_p); _p = s7_cdr(_p);
  y = s7_car(_p);
  if (!s7_is_integer(y)) s7_wrong_type_arg_error(sc, "gtk_text_view_get_line_at_y", 3, y, "gint");
  gtk_text_view_get_line_at_y((GtkTextView*)s7_c_pointer_with_type(sc, text_view, GtkTextView__sym, __func__, 0), (GtkTextIter*)s7_c_pointer_with_type(sc, target_iter, GtkTextIter__sym, __func__, 0), (gint)s7_integer(y), &ref_line_top);
    return(s7_list(sc, 1, s7_make_integer(sc, ref_line_top)));
}

static s7_pointer lg_gtk_text_view_window_to_buffer_coords(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_window_to_buffer_coords "void gtk_text_view_window_to_buffer_coords(GtkTextView* text_view, \
GtkTextWindowType win, gint window_x, gint window_y, gint* [buffer_x], gint* [buffer_y])"
  s7_pointer _p;
  s7_pointer text_view, win, window_x, window_y;
  gint ref_buffer_x;
  gint ref_buffer_y;
  _p = args;
  text_view = s7_car(_p); _p = s7_cdr(_p);
  win = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(win)) s7_wrong_type_arg_error(sc, "gtk_text_view_window_to_buffer_coords", 2, win, "GtkTextWindowType");
  window_x = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(window_x)) s7_wrong_type_arg_error(sc, "gtk_text_view_window_to_buffer_coords", 3, window_x, "gint");
  window_y = s7_car(_p);
  if (!s7_is_integer(window_y)) s7_wrong_type_arg_error(sc, "gtk_text_view_window_to_buffer_coords", 4, window_y, "gint");
  gtk_text_view_window_to_buffer_coords((GtkTextView*)s7_c_pointer_with_type(sc, text_view, GtkTextView__sym, __func__, 0), (GtkTextWindowType)s7_integer(win), (gint)s7_integer(window_x), (gint)s7_integer(window_y), &ref_buffer_x, &ref_buffer_y);
    return(s7_list(sc, 2, s7_make_integer(sc, ref_buffer_x), s7_make_integer(sc, ref_buffer_y)));
}

static s7_pointer lg_gtk_text_view_forward_display_line(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_forward_display_line "gboolean gtk_text_view_forward_display_line(GtkTextView* text_view, \
GtkTextIter* iter)"
  s7_pointer _p;
  s7_pointer text_view, iter;
  _p = args;
  text_view = s7_car(_p); _p = s7_cdr(_p);
  iter = s7_car(_p);
  return(s7_make_boolean(sc, gtk_text_view_forward_display_line((GtkTextView*)s7_c_pointer_with_type(sc, text_view, GtkTextView__sym, __func__, 0), (GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_view_backward_display_line(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_backward_display_line "gboolean gtk_text_view_backward_display_line(GtkTextView* text_view, \
GtkTextIter* iter)"
  s7_pointer _p;
  s7_pointer text_view, iter;
  _p = args;
  text_view = s7_car(_p); _p = s7_cdr(_p);
  iter = s7_car(_p);
  return(s7_make_boolean(sc, gtk_text_view_backward_display_line((GtkTextView*)s7_c_pointer_with_type(sc, text_view, GtkTextView__sym, __func__, 0), (GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_view_forward_display_line_end(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_forward_display_line_end "gboolean gtk_text_view_forward_display_line_end(GtkTextView* text_view, \
GtkTextIter* iter)"
  s7_pointer _p;
  s7_pointer text_view, iter;
  _p = args;
  text_view = s7_car(_p); _p = s7_cdr(_p);
  iter = s7_car(_p);
  return(s7_make_boolean(sc, gtk_text_view_forward_display_line_end((GtkTextView*)s7_c_pointer_with_type(sc, text_view, GtkTextView__sym, __func__, 0), (GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_view_backward_display_line_start(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_backward_display_line_start "gboolean gtk_text_view_backward_display_line_start(GtkTextView* text_view, \
GtkTextIter* iter)"
  s7_pointer _p;
  s7_pointer text_view, iter;
  _p = args;
  text_view = s7_car(_p); _p = s7_cdr(_p);
  iter = s7_car(_p);
  return(s7_make_boolean(sc, gtk_text_view_backward_display_line_start((GtkTextView*)s7_c_pointer_with_type(sc, text_view, GtkTextView__sym, __func__, 0), (GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_view_starts_display_line(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_starts_display_line "gboolean gtk_text_view_starts_display_line(GtkTextView* text_view, \
GtkTextIter* iter)"
  s7_pointer _p;
  s7_pointer text_view, iter;
  _p = args;
  text_view = s7_car(_p); _p = s7_cdr(_p);
  iter = s7_car(_p);
  return(s7_make_boolean(sc, gtk_text_view_starts_display_line((GtkTextView*)s7_c_pointer_with_type(sc, text_view, GtkTextView__sym, __func__, 0), (GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_view_move_visually(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_move_visually "gboolean gtk_text_view_move_visually(GtkTextView* text_view, \
GtkTextIter* iter, gint count)"
  s7_pointer _p;
  s7_pointer text_view, iter, count;
  _p = args;
  text_view = s7_car(_p); _p = s7_cdr(_p);
  iter = s7_car(_p); _p = s7_cdr(_p);
  count = s7_car(_p);
  if (!s7_is_integer(count)) s7_wrong_type_arg_error(sc, "gtk_text_view_move_visually", 3, count, "gint");
  return(s7_make_boolean(sc, gtk_text_view_move_visually((GtkTextView*)s7_c_pointer_with_type(sc, text_view, GtkTextView__sym, __func__, 0), (GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0), (gint)s7_integer(count))));
}

static s7_pointer lg_gtk_text_view_add_child_at_anchor(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_add_child_at_anchor "void gtk_text_view_add_child_at_anchor(GtkTextView* text_view, \
GtkWidget* child, GtkTextChildAnchor* anchor)"
  s7_pointer _p;
  s7_pointer text_view, child, anchor;
  _p = args;
  text_view = s7_car(_p); _p = s7_cdr(_p);
  child = s7_car(_p); _p = s7_cdr(_p);
  anchor = s7_car(_p);
  gtk_text_view_add_child_at_anchor((GtkTextView*)s7_c_pointer_with_type(sc, text_view, GtkTextView__sym, __func__, 0), (GtkWidget*)s7_c_pointer_with_type(sc, child, GtkWidget__sym, __func__, 0), (GtkTextChildAnchor*)s7_c_pointer_with_type(sc, anchor, GtkTextChildAnchor__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_text_view_set_wrap_mode(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_set_wrap_mode "void gtk_text_view_set_wrap_mode(GtkTextView* text_view, GtkWrapMode wrap_mode)"
  s7_pointer _p;
  s7_pointer text_view, wrap_mode;
  _p = args;
  text_view = s7_car(_p); _p = s7_cdr(_p);
  wrap_mode = s7_car(_p);
  if (!s7_is_integer(wrap_mode)) s7_wrong_type_arg_error(sc, "gtk_text_view_set_wrap_mode", 2, wrap_mode, "GtkWrapMode");
  gtk_text_view_set_wrap_mode((GtkTextView*)s7_c_pointer_with_type(sc, text_view, GtkTextView__sym, __func__, 0), (GtkWrapMode)s7_integer(wrap_mode));
  return(lg_false);
}

static s7_pointer lg_gtk_text_view_get_wrap_mode(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_get_wrap_mode "GtkWrapMode gtk_text_view_get_wrap_mode(GtkTextView* text_view)"
  s7_pointer text_view;
  text_view = s7_car(args);
  return(s7_make_integer(sc, gtk_text_view_get_wrap_mode((GtkTextView*)s7_c_pointer_with_type(sc, text_view, GtkTextView__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_view_set_editable(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_set_editable "void gtk_text_view_set_editable(GtkTextView* text_view, gboolean setting)"
  s7_pointer _p;
  s7_pointer text_view, setting;
  _p = args;
  text_view = s7_car(_p); _p = s7_cdr(_p);
  setting = s7_car(_p);
  if (!s7_is_boolean(setting)) s7_wrong_type_arg_error(sc, "gtk_text_view_set_editable", 2, setting, "gboolean");
  gtk_text_view_set_editable((GtkTextView*)s7_c_pointer_with_type(sc, text_view, GtkTextView__sym, __func__, 0), (gboolean)lg_boolean(setting));
  return(lg_false);
}

static s7_pointer lg_gtk_text_view_get_editable(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_get_editable "gboolean gtk_text_view_get_editable(GtkTextView* text_view)"
  s7_pointer text_view;
  text_view = s7_car(args);
  return(s7_make_boolean(sc, gtk_text_view_get_editable((GtkTextView*)s7_c_pointer_with_type(sc, text_view, GtkTextView__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_view_set_pixels_above_lines(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_set_pixels_above_lines "void gtk_text_view_set_pixels_above_lines(GtkTextView* text_view, \
gint pixels_above_lines)"
  s7_pointer _p;
  s7_pointer text_view, pixels_above_lines;
  _p = args;
  text_view = s7_car(_p); _p = s7_cdr(_p);
  pixels_above_lines = s7_car(_p);
  if (!s7_is_integer(pixels_above_lines)) s7_wrong_type_arg_error(sc, "gtk_text_view_set_pixels_above_lines", 2, pixels_above_lines, "gint");
  gtk_text_view_set_pixels_above_lines((GtkTextView*)s7_c_pointer_with_type(sc, text_view, GtkTextView__sym, __func__, 0), (gint)s7_integer(pixels_above_lines));
  return(lg_false);
}

static s7_pointer lg_gtk_text_view_get_pixels_above_lines(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_get_pixels_above_lines "gint gtk_text_view_get_pixels_above_lines(GtkTextView* text_view)"
  s7_pointer text_view;
  text_view = s7_car(args);
  return(s7_make_integer(sc, gtk_text_view_get_pixels_above_lines((GtkTextView*)s7_c_pointer_with_type(sc, text_view, GtkTextView__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_view_set_pixels_below_lines(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_set_pixels_below_lines "void gtk_text_view_set_pixels_below_lines(GtkTextView* text_view, \
gint pixels_below_lines)"
  s7_pointer _p;
  s7_pointer text_view, pixels_below_lines;
  _p = args;
  text_view = s7_car(_p); _p = s7_cdr(_p);
  pixels_below_lines = s7_car(_p);
  if (!s7_is_integer(pixels_below_lines)) s7_wrong_type_arg_error(sc, "gtk_text_view_set_pixels_below_lines", 2, pixels_below_lines, "gint");
  gtk_text_view_set_pixels_below_lines((GtkTextView*)s7_c_pointer_with_type(sc, text_view, GtkTextView__sym, __func__, 0), (gint)s7_integer(pixels_below_lines));
  return(lg_false);
}

static s7_pointer lg_gtk_text_view_get_pixels_below_lines(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_get_pixels_below_lines "gint gtk_text_view_get_pixels_below_lines(GtkTextView* text_view)"
  s7_pointer text_view;
  text_view = s7_car(args);
  return(s7_make_integer(sc, gtk_text_view_get_pixels_below_lines((GtkTextView*)s7_c_pointer_with_type(sc, text_view, GtkTextView__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_view_set_pixels_inside_wrap(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_set_pixels_inside_wrap "void gtk_text_view_set_pixels_inside_wrap(GtkTextView* text_view, \
gint pixels_inside_wrap)"
  s7_pointer _p;
  s7_pointer text_view, pixels_inside_wrap;
  _p = args;
  text_view = s7_car(_p); _p = s7_cdr(_p);
  pixels_inside_wrap = s7_car(_p);
  if (!s7_is_integer(pixels_inside_wrap)) s7_wrong_type_arg_error(sc, "gtk_text_view_set_pixels_inside_wrap", 2, pixels_inside_wrap, "gint");
  gtk_text_view_set_pixels_inside_wrap((GtkTextView*)s7_c_pointer_with_type(sc, text_view, GtkTextView__sym, __func__, 0), (gint)s7_integer(pixels_inside_wrap));
  return(lg_false);
}

static s7_pointer lg_gtk_text_view_get_pixels_inside_wrap(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_get_pixels_inside_wrap "gint gtk_text_view_get_pixels_inside_wrap(GtkTextView* text_view)"
  s7_pointer text_view;
  text_view = s7_car(args);
  return(s7_make_integer(sc, gtk_text_view_get_pixels_inside_wrap((GtkTextView*)s7_c_pointer_with_type(sc, text_view, GtkTextView__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_view_set_justification(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_set_justification "void gtk_text_view_set_justification(GtkTextView* text_view, \
GtkJustification justification)"
  s7_pointer _p;
  s7_pointer text_view, justification;
  _p = args;
  text_view = s7_car(_p); _p = s7_cdr(_p);
  justification = s7_car(_p);
  if (!s7_is_integer(justification)) s7_wrong_type_arg_error(sc, "gtk_text_view_set_justification", 2, justification, "GtkJustification");
  gtk_text_view_set_justification((GtkTextView*)s7_c_pointer_with_type(sc, text_view, GtkTextView__sym, __func__, 0), (GtkJustification)s7_integer(justification));
  return(lg_false);
}

static s7_pointer lg_gtk_text_view_get_justification(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_get_justification "GtkJustification gtk_text_view_get_justification(GtkTextView* text_view)"
  s7_pointer text_view;
  text_view = s7_car(args);
  return(s7_make_integer(sc, gtk_text_view_get_justification((GtkTextView*)s7_c_pointer_with_type(sc, text_view, GtkTextView__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_view_set_left_margin(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_set_left_margin "void gtk_text_view_set_left_margin(GtkTextView* text_view, \
gint left_margin)"
  s7_pointer _p;
  s7_pointer text_view, left_margin;
  _p = args;
  text_view = s7_car(_p); _p = s7_cdr(_p);
  left_margin = s7_car(_p);
  if (!s7_is_integer(left_margin)) s7_wrong_type_arg_error(sc, "gtk_text_view_set_left_margin", 2, left_margin, "gint");
  gtk_text_view_set_left_margin((GtkTextView*)s7_c_pointer_with_type(sc, text_view, GtkTextView__sym, __func__, 0), (gint)s7_integer(left_margin));
  return(lg_false);
}

static s7_pointer lg_gtk_text_view_get_left_margin(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_get_left_margin "gint gtk_text_view_get_left_margin(GtkTextView* text_view)"
  s7_pointer text_view;
  text_view = s7_car(args);
  return(s7_make_integer(sc, gtk_text_view_get_left_margin((GtkTextView*)s7_c_pointer_with_type(sc, text_view, GtkTextView__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_view_set_right_margin(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_set_right_margin "void gtk_text_view_set_right_margin(GtkTextView* text_view, \
gint right_margin)"
  s7_pointer _p;
  s7_pointer text_view, right_margin;
  _p = args;
  text_view = s7_car(_p); _p = s7_cdr(_p);
  right_margin = s7_car(_p);
  if (!s7_is_integer(right_margin)) s7_wrong_type_arg_error(sc, "gtk_text_view_set_right_margin", 2, right_margin, "gint");
  gtk_text_view_set_right_margin((GtkTextView*)s7_c_pointer_with_type(sc, text_view, GtkTextView__sym, __func__, 0), (gint)s7_integer(right_margin));
  return(lg_false);
}

static s7_pointer lg_gtk_text_view_get_right_margin(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_get_right_margin "gint gtk_text_view_get_right_margin(GtkTextView* text_view)"
  s7_pointer text_view;
  text_view = s7_car(args);
  return(s7_make_integer(sc, gtk_text_view_get_right_margin((GtkTextView*)s7_c_pointer_with_type(sc, text_view, GtkTextView__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_view_set_indent(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_set_indent "void gtk_text_view_set_indent(GtkTextView* text_view, gint indent)"
  s7_pointer _p;
  s7_pointer text_view, indent;
  _p = args;
  text_view = s7_car(_p); _p = s7_cdr(_p);
  indent = s7_car(_p);
  if (!s7_is_integer(indent)) s7_wrong_type_arg_error(sc, "gtk_text_view_set_indent", 2, indent, "gint");
  gtk_text_view_set_indent((GtkTextView*)s7_c_pointer_with_type(sc, text_view, GtkTextView__sym, __func__, 0), (gint)s7_integer(indent));
  return(lg_false);
}

static s7_pointer lg_gtk_text_view_get_indent(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_get_indent "gint gtk_text_view_get_indent(GtkTextView* text_view)"
  s7_pointer text_view;
  text_view = s7_car(args);
  return(s7_make_integer(sc, gtk_text_view_get_indent((GtkTextView*)s7_c_pointer_with_type(sc, text_view, GtkTextView__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_view_set_tabs(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_set_tabs "void gtk_text_view_set_tabs(GtkTextView* text_view, PangoTabArray* tabs)"
  s7_pointer _p;
  s7_pointer text_view, tabs;
  _p = args;
  text_view = s7_car(_p); _p = s7_cdr(_p);
  tabs = s7_car(_p);
  gtk_text_view_set_tabs((GtkTextView*)s7_c_pointer_with_type(sc, text_view, GtkTextView__sym, __func__, 0), (PangoTabArray*)s7_c_pointer_with_type(sc, tabs, PangoTabArray__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_text_view_get_tabs(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_get_tabs "PangoTabArray* gtk_text_view_get_tabs(GtkTextView* text_view)"
  s7_pointer text_view;
  text_view = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, PangoTabArray__sym, gtk_text_view_get_tabs((GtkTextView*)s7_c_pointer_with_type(sc, text_view, GtkTextView__sym, __func__, 0))));
}

static s7_pointer lg_gtk_toggle_button_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_toggle_button_new "GtkWidget* gtk_toggle_button_new( void)"
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_toggle_button_new()));
}

static s7_pointer lg_gtk_toggle_button_new_with_label(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_toggle_button_new_with_label "GtkWidget* gtk_toggle_button_new_with_label(gchar* label)"
  s7_pointer label;
  label = s7_car(args);
  if (!s7_is_string(label)) s7_wrong_type_arg_error(sc, "gtk_toggle_button_new_with_label", 1, label, "gchar*");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_toggle_button_new_with_label((gchar*)s7_string(label))));
}

static s7_pointer lg_gtk_toggle_button_new_with_mnemonic(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_toggle_button_new_with_mnemonic "GtkWidget* gtk_toggle_button_new_with_mnemonic(gchar* label)"
  s7_pointer label;
  label = s7_car(args);
  if (!s7_is_string(label)) s7_wrong_type_arg_error(sc, "gtk_toggle_button_new_with_mnemonic", 1, label, "gchar*");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_toggle_button_new_with_mnemonic((gchar*)s7_string(label))));
}

static s7_pointer lg_gtk_toggle_button_set_active(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_toggle_button_set_active "void gtk_toggle_button_set_active(GtkToggleButton* toggle_button, \
gboolean is_active)"
  s7_pointer _p;
  s7_pointer toggle_button, is_active;
  _p = args;
  toggle_button = s7_car(_p); _p = s7_cdr(_p);
  is_active = s7_car(_p);
  if (!s7_is_boolean(is_active)) s7_wrong_type_arg_error(sc, "gtk_toggle_button_set_active", 2, is_active, "gboolean");
  gtk_toggle_button_set_active((GtkToggleButton*)s7_c_pointer_with_type(sc, toggle_button, GtkToggleButton__sym, __func__, 0), (gboolean)lg_boolean(is_active));
  return(lg_false);
}

static s7_pointer lg_gtk_toggle_button_get_active(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_toggle_button_get_active "gboolean gtk_toggle_button_get_active(GtkToggleButton* toggle_button)"
  s7_pointer toggle_button;
  toggle_button = s7_car(args);
  return(s7_make_boolean(sc, gtk_toggle_button_get_active((GtkToggleButton*)s7_c_pointer_with_type(sc, toggle_button, GtkToggleButton__sym, __func__, 0))));
}

static s7_pointer lg_gtk_toggle_button_toggled(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_toggle_button_toggled "void gtk_toggle_button_toggled(GtkToggleButton* toggle_button)"
  s7_pointer toggle_button;
  toggle_button = s7_car(args);
  gtk_toggle_button_toggled((GtkToggleButton*)s7_c_pointer_with_type(sc, toggle_button, GtkToggleButton__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_drag_source_row_draggable(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_drag_source_row_draggable "gboolean gtk_tree_drag_source_row_draggable(GtkTreeDragSource* drag_source, \
GtkTreePath* path)"
  s7_pointer _p;
  s7_pointer drag_source, path;
  _p = args;
  drag_source = s7_car(_p); _p = s7_cdr(_p);
  path = s7_car(_p);
  return(s7_make_boolean(sc, gtk_tree_drag_source_row_draggable((GtkTreeDragSource*)s7_c_pointer_with_type(sc, drag_source, GtkTreeDragSource__sym, __func__, 0), (GtkTreePath*)s7_c_pointer_with_type(sc, path, GtkTreePath__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_drag_source_drag_data_delete(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_drag_source_drag_data_delete "gboolean gtk_tree_drag_source_drag_data_delete(GtkTreeDragSource* drag_source, \
GtkTreePath* path)"
  s7_pointer _p;
  s7_pointer drag_source, path;
  _p = args;
  drag_source = s7_car(_p); _p = s7_cdr(_p);
  path = s7_car(_p);
  return(s7_make_boolean(sc, gtk_tree_drag_source_drag_data_delete((GtkTreeDragSource*)s7_c_pointer_with_type(sc, drag_source, GtkTreeDragSource__sym, __func__, 0), (GtkTreePath*)s7_c_pointer_with_type(sc, path, GtkTreePath__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_path_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_path_new "GtkTreePath* gtk_tree_path_new( void)"
  return(lg_make_c_pointer_with_type(sc, GtkTreePath__sym, gtk_tree_path_new()));
}

static s7_pointer lg_gtk_tree_path_new_from_string(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_path_new_from_string "GtkTreePath* gtk_tree_path_new_from_string(gchar* path)"
  s7_pointer path;
  path = s7_car(args);
  if (!s7_is_string(path)) s7_wrong_type_arg_error(sc, "gtk_tree_path_new_from_string", 1, path, "gchar*");
  return(lg_make_c_pointer_with_type(sc, GtkTreePath__sym, gtk_tree_path_new_from_string((gchar*)s7_string(path))));
}

static s7_pointer lg_gtk_tree_path_to_string(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_path_to_string "gchar* gtk_tree_path_to_string(GtkTreePath* path)"
  s7_pointer path;
  path = s7_car(args);
  {
    gchar* res_ult;
    s7_pointer rtn;
    res_ult = gtk_tree_path_to_string((GtkTreePath*)s7_c_pointer_with_type(sc, path, GtkTreePath__sym, __func__, 0));
    rtn = s7_make_string(sc, res_ult);
    g_free(res_ult);
    return(rtn);
  }
}

static s7_pointer lg_gtk_tree_path_new_first(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_path_new_first "GtkTreePath* gtk_tree_path_new_first( void)"
  return(lg_make_c_pointer_with_type(sc, GtkTreePath__sym, gtk_tree_path_new_first()));
}

static s7_pointer lg_gtk_tree_path_append_index(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_path_append_index "void gtk_tree_path_append_index(GtkTreePath* path, gint index)"
  s7_pointer _p;
  s7_pointer path, index;
  _p = args;
  path = s7_car(_p); _p = s7_cdr(_p);
  index = s7_car(_p);
  if (!s7_is_integer(index)) s7_wrong_type_arg_error(sc, "gtk_tree_path_append_index", 2, index, "gint");
  gtk_tree_path_append_index((GtkTreePath*)s7_c_pointer_with_type(sc, path, GtkTreePath__sym, __func__, 0), (gint)s7_integer(index));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_path_prepend_index(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_path_prepend_index "void gtk_tree_path_prepend_index(GtkTreePath* path, gint index)"
  s7_pointer _p;
  s7_pointer path, index;
  _p = args;
  path = s7_car(_p); _p = s7_cdr(_p);
  index = s7_car(_p);
  if (!s7_is_integer(index)) s7_wrong_type_arg_error(sc, "gtk_tree_path_prepend_index", 2, index, "gint");
  gtk_tree_path_prepend_index((GtkTreePath*)s7_c_pointer_with_type(sc, path, GtkTreePath__sym, __func__, 0), (gint)s7_integer(index));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_path_get_depth(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_path_get_depth "gint gtk_tree_path_get_depth(GtkTreePath* path)"
  s7_pointer path;
  path = s7_car(args);
  return(s7_make_integer(sc, gtk_tree_path_get_depth((GtkTreePath*)s7_c_pointer_with_type(sc, path, GtkTreePath__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_path_get_indices(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_path_get_indices "gint* gtk_tree_path_get_indices(GtkTreePath* path)"
  s7_pointer path;
  path = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, gint__sym, gtk_tree_path_get_indices((GtkTreePath*)s7_c_pointer_with_type(sc, path, GtkTreePath__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_path_free(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_path_free "void gtk_tree_path_free(GtkTreePath* path)"
  s7_pointer path;
  path = s7_car(args);
  gtk_tree_path_free((GtkTreePath*)s7_c_pointer_with_type(sc, path, GtkTreePath__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_path_copy(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_path_copy "GtkTreePath* gtk_tree_path_copy(GtkTreePath* path)"
  s7_pointer path;
  path = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GtkTreePath__sym, gtk_tree_path_copy((GtkTreePath*)s7_c_pointer_with_type(sc, path, GtkTreePath__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_path_compare(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_path_compare "gint gtk_tree_path_compare(GtkTreePath* a, GtkTreePath* b)"
  s7_pointer _p;
  s7_pointer a, b;
  _p = args;
  a = s7_car(_p); _p = s7_cdr(_p);
  b = s7_car(_p);
  return(s7_make_integer(sc, gtk_tree_path_compare((GtkTreePath*)s7_c_pointer_with_type(sc, a, GtkTreePath__sym, __func__, 0), (GtkTreePath*)s7_c_pointer_with_type(sc, b, GtkTreePath__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_path_next(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_path_next "void gtk_tree_path_next(GtkTreePath* path)"
  s7_pointer path;
  path = s7_car(args);
  gtk_tree_path_next((GtkTreePath*)s7_c_pointer_with_type(sc, path, GtkTreePath__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_path_prev(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_path_prev "gboolean gtk_tree_path_prev(GtkTreePath* path)"
  s7_pointer path;
  path = s7_car(args);
  return(s7_make_boolean(sc, gtk_tree_path_prev((GtkTreePath*)s7_c_pointer_with_type(sc, path, GtkTreePath__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_path_up(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_path_up "gboolean gtk_tree_path_up(GtkTreePath* path)"
  s7_pointer path;
  path = s7_car(args);
  return(s7_make_boolean(sc, gtk_tree_path_up((GtkTreePath*)s7_c_pointer_with_type(sc, path, GtkTreePath__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_path_down(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_path_down "void gtk_tree_path_down(GtkTreePath* path)"
  s7_pointer path;
  path = s7_car(args);
  gtk_tree_path_down((GtkTreePath*)s7_c_pointer_with_type(sc, path, GtkTreePath__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_path_is_ancestor(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_path_is_ancestor "gboolean gtk_tree_path_is_ancestor(GtkTreePath* path, GtkTreePath* descendant)"
  s7_pointer _p;
  s7_pointer path, descendant;
  _p = args;
  path = s7_car(_p); _p = s7_cdr(_p);
  descendant = s7_car(_p);
  return(s7_make_boolean(sc, gtk_tree_path_is_ancestor((GtkTreePath*)s7_c_pointer_with_type(sc, path, GtkTreePath__sym, __func__, 0), (GtkTreePath*)s7_c_pointer_with_type(sc, descendant, GtkTreePath__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_path_is_descendant(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_path_is_descendant "gboolean gtk_tree_path_is_descendant(GtkTreePath* path, GtkTreePath* ancestor)"
  s7_pointer _p;
  s7_pointer path, ancestor;
  _p = args;
  path = s7_car(_p); _p = s7_cdr(_p);
  ancestor = s7_car(_p);
  return(s7_make_boolean(sc, gtk_tree_path_is_descendant((GtkTreePath*)s7_c_pointer_with_type(sc, path, GtkTreePath__sym, __func__, 0), (GtkTreePath*)s7_c_pointer_with_type(sc, ancestor, GtkTreePath__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_row_reference_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_row_reference_new "GtkTreeRowReference* gtk_tree_row_reference_new(GtkTreeModel* model, \
GtkTreePath* path)"
  s7_pointer _p;
  s7_pointer model, path;
  _p = args;
  model = s7_car(_p); _p = s7_cdr(_p);
  path = s7_car(_p);
  return(lg_make_c_pointer_with_type(sc, GtkTreeRowReference__sym, gtk_tree_row_reference_new((GtkTreeModel*)s7_c_pointer_with_type(sc, model, GtkTreeModel__sym, __func__, 0), (GtkTreePath*)s7_c_pointer_with_type(sc, path, GtkTreePath__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_row_reference_new_proxy(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_row_reference_new_proxy "GtkTreeRowReference* gtk_tree_row_reference_new_proxy(GObject* proxy, \
GtkTreeModel* model, GtkTreePath* path)"
  s7_pointer _p;
  s7_pointer proxy, model, path;
  _p = args;
  proxy = s7_car(_p); _p = s7_cdr(_p);
  model = s7_car(_p); _p = s7_cdr(_p);
  path = s7_car(_p);
  return(lg_make_c_pointer_with_type(sc, GtkTreeRowReference__sym, gtk_tree_row_reference_new_proxy((GObject*)s7_c_pointer_with_type(sc, proxy, GObject__sym, __func__, 0), (GtkTreeModel*)s7_c_pointer_with_type(sc, model, GtkTreeModel__sym, __func__, 0), (GtkTreePath*)s7_c_pointer_with_type(sc, path, GtkTreePath__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_row_reference_get_path(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_row_reference_get_path "GtkTreePath* gtk_tree_row_reference_get_path(GtkTreeRowReference* reference)"
  s7_pointer reference;
  reference = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GtkTreePath__sym, gtk_tree_row_reference_get_path((GtkTreeRowReference*)s7_c_pointer_with_type(sc, reference, GtkTreeRowReference__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_row_reference_valid(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_row_reference_valid "gboolean gtk_tree_row_reference_valid(GtkTreeRowReference* reference)"
  s7_pointer reference;
  reference = s7_car(args);
  return(s7_make_boolean(sc, gtk_tree_row_reference_valid((GtkTreeRowReference*)s7_c_pointer_with_type(sc, reference, GtkTreeRowReference__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_row_reference_free(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_row_reference_free "void gtk_tree_row_reference_free(GtkTreeRowReference* reference)"
  s7_pointer reference;
  reference = s7_car(args);
  gtk_tree_row_reference_free((GtkTreeRowReference*)s7_c_pointer_with_type(sc, reference, GtkTreeRowReference__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_row_reference_inserted(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_row_reference_inserted "void gtk_tree_row_reference_inserted(GObject* proxy, GtkTreePath* path)"
  s7_pointer _p;
  s7_pointer proxy, path;
  _p = args;
  proxy = s7_car(_p); _p = s7_cdr(_p);
  path = s7_car(_p);
  gtk_tree_row_reference_inserted((GObject*)s7_c_pointer_with_type(sc, proxy, GObject__sym, __func__, 0), (GtkTreePath*)s7_c_pointer_with_type(sc, path, GtkTreePath__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_row_reference_deleted(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_row_reference_deleted "void gtk_tree_row_reference_deleted(GObject* proxy, GtkTreePath* path)"
  s7_pointer _p;
  s7_pointer proxy, path;
  _p = args;
  proxy = s7_car(_p); _p = s7_cdr(_p);
  path = s7_car(_p);
  gtk_tree_row_reference_deleted((GObject*)s7_c_pointer_with_type(sc, proxy, GObject__sym, __func__, 0), (GtkTreePath*)s7_c_pointer_with_type(sc, path, GtkTreePath__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_row_reference_reordered(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_row_reference_reordered "void gtk_tree_row_reference_reordered(GObject* proxy, GtkTreePath* path, \
GtkTreeIter* iter, gint* new_order)"
  s7_pointer _p;
  s7_pointer proxy, path, iter, new_order;
  _p = args;
  proxy = s7_car(_p); _p = s7_cdr(_p);
  path = s7_car(_p); _p = s7_cdr(_p);
  iter = s7_car(_p); _p = s7_cdr(_p);
  new_order = s7_car(_p);
  gtk_tree_row_reference_reordered((GObject*)s7_c_pointer_with_type(sc, proxy, GObject__sym, __func__, 0), (GtkTreePath*)s7_c_pointer_with_type(sc, path, GtkTreePath__sym, __func__, 0), (GtkTreeIter*)s7_c_pointer_with_type(sc, iter, GtkTreeIter__sym, __func__, 0), (gint*)s7_c_pointer_with_type(sc, new_order, gint__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_iter_copy(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_iter_copy "GtkTreeIter* gtk_tree_iter_copy(GtkTreeIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GtkTreeIter__sym, gtk_tree_iter_copy((GtkTreeIter*)s7_c_pointer_with_type(sc, iter, GtkTreeIter__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_iter_free(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_iter_free "void gtk_tree_iter_free(GtkTreeIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  gtk_tree_iter_free((GtkTreeIter*)s7_c_pointer_with_type(sc, iter, GtkTreeIter__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_model_get_flags(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_model_get_flags "GtkTreeModelFlags gtk_tree_model_get_flags(GtkTreeModel* tree_model)"
  s7_pointer tree_model;
  tree_model = s7_car(args);
  return(s7_make_integer(sc, gtk_tree_model_get_flags((GtkTreeModel*)s7_c_pointer_with_type(sc, tree_model, GtkTreeModel__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_model_get_n_columns(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_model_get_n_columns "gint gtk_tree_model_get_n_columns(GtkTreeModel* tree_model)"
  s7_pointer tree_model;
  tree_model = s7_car(args);
  return(s7_make_integer(sc, gtk_tree_model_get_n_columns((GtkTreeModel*)s7_c_pointer_with_type(sc, tree_model, GtkTreeModel__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_model_get_column_type(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_model_get_column_type "GType gtk_tree_model_get_column_type(GtkTreeModel* tree_model, \
gint index)"
  s7_pointer _p;
  s7_pointer tree_model, index;
  _p = args;
  tree_model = s7_car(_p); _p = s7_cdr(_p);
  index = s7_car(_p);
  if (!s7_is_integer(index)) s7_wrong_type_arg_error(sc, "gtk_tree_model_get_column_type", 2, index, "gint");
  return(s7_make_integer(sc, gtk_tree_model_get_column_type((GtkTreeModel*)s7_c_pointer_with_type(sc, tree_model, GtkTreeModel__sym, __func__, 0), (gint)s7_integer(index))));
}

static s7_pointer lg_gtk_tree_model_get_iter(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_model_get_iter "gboolean gtk_tree_model_get_iter(GtkTreeModel* tree_model, GtkTreeIter* iter, \
GtkTreePath* path)"
  s7_pointer _p;
  s7_pointer tree_model, iter, path;
  _p = args;
  tree_model = s7_car(_p); _p = s7_cdr(_p);
  iter = s7_car(_p); _p = s7_cdr(_p);
  path = s7_car(_p);
  return(s7_make_boolean(sc, gtk_tree_model_get_iter((GtkTreeModel*)s7_c_pointer_with_type(sc, tree_model, GtkTreeModel__sym, __func__, 0), (GtkTreeIter*)s7_c_pointer_with_type(sc, iter, GtkTreeIter__sym, __func__, 0), (GtkTreePath*)s7_c_pointer_with_type(sc, path, GtkTreePath__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_model_get_iter_from_string(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_model_get_iter_from_string "gboolean gtk_tree_model_get_iter_from_string(GtkTreeModel* tree_model, \
GtkTreeIter* iter, gchar* path_string)"
  s7_pointer _p;
  s7_pointer tree_model, iter, path_string;
  _p = args;
  tree_model = s7_car(_p); _p = s7_cdr(_p);
  iter = s7_car(_p); _p = s7_cdr(_p);
  path_string = s7_car(_p);
  if (!s7_is_string(path_string)) s7_wrong_type_arg_error(sc, "gtk_tree_model_get_iter_from_string", 3, path_string, "gchar*");
  return(s7_make_boolean(sc, gtk_tree_model_get_iter_from_string((GtkTreeModel*)s7_c_pointer_with_type(sc, tree_model, GtkTreeModel__sym, __func__, 0), (GtkTreeIter*)s7_c_pointer_with_type(sc, iter, GtkTreeIter__sym, __func__, 0), (gchar*)s7_string(path_string))));
}

static s7_pointer lg_gtk_tree_model_get_iter_first(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_model_get_iter_first "gboolean gtk_tree_model_get_iter_first(GtkTreeModel* tree_model, \
GtkTreeIter* iter)"
  s7_pointer _p;
  s7_pointer tree_model, iter;
  _p = args;
  tree_model = s7_car(_p); _p = s7_cdr(_p);
  iter = s7_car(_p);
  return(s7_make_boolean(sc, gtk_tree_model_get_iter_first((GtkTreeModel*)s7_c_pointer_with_type(sc, tree_model, GtkTreeModel__sym, __func__, 0), (GtkTreeIter*)s7_c_pointer_with_type(sc, iter, GtkTreeIter__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_model_get_path(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_model_get_path "GtkTreePath* gtk_tree_model_get_path(GtkTreeModel* tree_model, GtkTreeIter* iter)"
  s7_pointer _p;
  s7_pointer tree_model, iter;
  _p = args;
  tree_model = s7_car(_p); _p = s7_cdr(_p);
  iter = s7_car(_p);
  return(lg_make_c_pointer_with_type(sc, GtkTreePath__sym, gtk_tree_model_get_path((GtkTreeModel*)s7_c_pointer_with_type(sc, tree_model, GtkTreeModel__sym, __func__, 0), (GtkTreeIter*)s7_c_pointer_with_type(sc, iter, GtkTreeIter__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_model_iter_next(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_model_iter_next "gboolean gtk_tree_model_iter_next(GtkTreeModel* tree_model, GtkTreeIter* iter)"
  s7_pointer _p;
  s7_pointer tree_model, iter;
  _p = args;
  tree_model = s7_car(_p); _p = s7_cdr(_p);
  iter = s7_car(_p);
  return(s7_make_boolean(sc, gtk_tree_model_iter_next((GtkTreeModel*)s7_c_pointer_with_type(sc, tree_model, GtkTreeModel__sym, __func__, 0), (GtkTreeIter*)s7_c_pointer_with_type(sc, iter, GtkTreeIter__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_model_iter_children(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_model_iter_children "gboolean gtk_tree_model_iter_children(GtkTreeModel* tree_model, \
GtkTreeIter* iter, GtkTreeIter* parent)"
  s7_pointer _p;
  s7_pointer tree_model, iter, parent;
  _p = args;
  tree_model = s7_car(_p); _p = s7_cdr(_p);
  iter = s7_car(_p); _p = s7_cdr(_p);
  parent = s7_car(_p);
  return(s7_make_boolean(sc, gtk_tree_model_iter_children((GtkTreeModel*)s7_c_pointer_with_type(sc, tree_model, GtkTreeModel__sym, __func__, 0), (GtkTreeIter*)s7_c_pointer_with_type(sc, iter, GtkTreeIter__sym, __func__, 0), (GtkTreeIter*)s7_c_pointer_with_type(sc, parent, GtkTreeIter__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_model_iter_has_child(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_model_iter_has_child "gboolean gtk_tree_model_iter_has_child(GtkTreeModel* tree_model, \
GtkTreeIter* iter)"
  s7_pointer _p;
  s7_pointer tree_model, iter;
  _p = args;
  tree_model = s7_car(_p); _p = s7_cdr(_p);
  iter = s7_car(_p);
  return(s7_make_boolean(sc, gtk_tree_model_iter_has_child((GtkTreeModel*)s7_c_pointer_with_type(sc, tree_model, GtkTreeModel__sym, __func__, 0), (GtkTreeIter*)s7_c_pointer_with_type(sc, iter, GtkTreeIter__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_model_iter_n_children(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_model_iter_n_children "gint gtk_tree_model_iter_n_children(GtkTreeModel* tree_model, \
GtkTreeIter* iter)"
  s7_pointer _p;
  s7_pointer tree_model, iter;
  _p = args;
  tree_model = s7_car(_p); _p = s7_cdr(_p);
  iter = s7_car(_p);
  return(s7_make_integer(sc, gtk_tree_model_iter_n_children((GtkTreeModel*)s7_c_pointer_with_type(sc, tree_model, GtkTreeModel__sym, __func__, 0), (GtkTreeIter*)s7_c_pointer_with_type(sc, iter, GtkTreeIter__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_model_iter_nth_child(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_model_iter_nth_child "gboolean gtk_tree_model_iter_nth_child(GtkTreeModel* tree_model, \
GtkTreeIter* iter, GtkTreeIter* parent, gint n)"
  s7_pointer _p;
  s7_pointer tree_model, iter, parent, n;
  _p = args;
  tree_model = s7_car(_p); _p = s7_cdr(_p);
  iter = s7_car(_p); _p = s7_cdr(_p);
  parent = s7_car(_p); _p = s7_cdr(_p);
  n = s7_car(_p);
  if (!s7_is_integer(n)) s7_wrong_type_arg_error(sc, "gtk_tree_model_iter_nth_child", 4, n, "gint");
  return(s7_make_boolean(sc, gtk_tree_model_iter_nth_child((GtkTreeModel*)s7_c_pointer_with_type(sc, tree_model, GtkTreeModel__sym, __func__, 0), (GtkTreeIter*)s7_c_pointer_with_type(sc, iter, GtkTreeIter__sym, __func__, 0), (GtkTreeIter*)s7_c_pointer_with_type(sc, parent, GtkTreeIter__sym, __func__, 0), (gint)s7_integer(n))));
}

static s7_pointer lg_gtk_tree_model_iter_parent(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_model_iter_parent "gboolean gtk_tree_model_iter_parent(GtkTreeModel* tree_model, \
GtkTreeIter* iter, GtkTreeIter* child)"
  s7_pointer _p;
  s7_pointer tree_model, iter, child;
  _p = args;
  tree_model = s7_car(_p); _p = s7_cdr(_p);
  iter = s7_car(_p); _p = s7_cdr(_p);
  child = s7_car(_p);
  return(s7_make_boolean(sc, gtk_tree_model_iter_parent((GtkTreeModel*)s7_c_pointer_with_type(sc, tree_model, GtkTreeModel__sym, __func__, 0), (GtkTreeIter*)s7_c_pointer_with_type(sc, iter, GtkTreeIter__sym, __func__, 0), (GtkTreeIter*)s7_c_pointer_with_type(sc, child, GtkTreeIter__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_model_ref_node(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_model_ref_node "void gtk_tree_model_ref_node(GtkTreeModel* tree_model, GtkTreeIter* iter)"
  s7_pointer _p;
  s7_pointer tree_model, iter;
  _p = args;
  tree_model = s7_car(_p); _p = s7_cdr(_p);
  iter = s7_car(_p);
  gtk_tree_model_ref_node((GtkTreeModel*)s7_c_pointer_with_type(sc, tree_model, GtkTreeModel__sym, __func__, 0), (GtkTreeIter*)s7_c_pointer_with_type(sc, iter, GtkTreeIter__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_model_unref_node(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_model_unref_node "void gtk_tree_model_unref_node(GtkTreeModel* tree_model, GtkTreeIter* iter)"
  s7_pointer _p;
  s7_pointer tree_model, iter;
  _p = args;
  tree_model = s7_car(_p); _p = s7_cdr(_p);
  iter = s7_car(_p);
  gtk_tree_model_unref_node((GtkTreeModel*)s7_c_pointer_with_type(sc, tree_model, GtkTreeModel__sym, __func__, 0), (GtkTreeIter*)s7_c_pointer_with_type(sc, iter, GtkTreeIter__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_model_foreach(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_model_foreach "void gtk_tree_model_foreach(GtkTreeModel* model, GtkTreeModelForeachFunc func, \
lambda_data func_info)"
  s7_pointer _p;
  s7_pointer model, func, func_info;
  _p = args;
  model = s7_car(_p); _p = s7_cdr(_p);
  func = s7_car(_p); _p = s7_cdr(_p);
  func_info = s7_car(_p);
  {
    int loc;
    s7_pointer lg_ptr = s7_list(sc, 5, func, func_info, lg_false, lg_false, lg_false);
    loc = s7_gc_protect(sc, lg_ptr);
    s7_list_set(sc, lg_ptr, 2, s7_make_integer(sc, loc));
    gtk_tree_model_foreach((GtkTreeModel*)s7_c_pointer_with_type(sc, model, GtkTreeModel__sym, __func__, 0), lg_model_func, (gpointer)lg_ptr);
    return(lg_false);
   }
}

static s7_pointer lg_gtk_tree_model_row_changed(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_model_row_changed "void gtk_tree_model_row_changed(GtkTreeModel* tree_model, GtkTreePath* path, \
GtkTreeIter* iter)"
  s7_pointer _p;
  s7_pointer tree_model, path, iter;
  _p = args;
  tree_model = s7_car(_p); _p = s7_cdr(_p);
  path = s7_car(_p); _p = s7_cdr(_p);
  iter = s7_car(_p);
  gtk_tree_model_row_changed((GtkTreeModel*)s7_c_pointer_with_type(sc, tree_model, GtkTreeModel__sym, __func__, 0), (GtkTreePath*)s7_c_pointer_with_type(sc, path, GtkTreePath__sym, __func__, 0), (GtkTreeIter*)s7_c_pointer_with_type(sc, iter, GtkTreeIter__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_model_row_inserted(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_model_row_inserted "void gtk_tree_model_row_inserted(GtkTreeModel* tree_model, GtkTreePath* path, \
GtkTreeIter* iter)"
  s7_pointer _p;
  s7_pointer tree_model, path, iter;
  _p = args;
  tree_model = s7_car(_p); _p = s7_cdr(_p);
  path = s7_car(_p); _p = s7_cdr(_p);
  iter = s7_car(_p);
  gtk_tree_model_row_inserted((GtkTreeModel*)s7_c_pointer_with_type(sc, tree_model, GtkTreeModel__sym, __func__, 0), (GtkTreePath*)s7_c_pointer_with_type(sc, path, GtkTreePath__sym, __func__, 0), (GtkTreeIter*)s7_c_pointer_with_type(sc, iter, GtkTreeIter__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_model_row_has_child_toggled(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_model_row_has_child_toggled "void gtk_tree_model_row_has_child_toggled(GtkTreeModel* tree_model, \
GtkTreePath* path, GtkTreeIter* iter)"
  s7_pointer _p;
  s7_pointer tree_model, path, iter;
  _p = args;
  tree_model = s7_car(_p); _p = s7_cdr(_p);
  path = s7_car(_p); _p = s7_cdr(_p);
  iter = s7_car(_p);
  gtk_tree_model_row_has_child_toggled((GtkTreeModel*)s7_c_pointer_with_type(sc, tree_model, GtkTreeModel__sym, __func__, 0), (GtkTreePath*)s7_c_pointer_with_type(sc, path, GtkTreePath__sym, __func__, 0), (GtkTreeIter*)s7_c_pointer_with_type(sc, iter, GtkTreeIter__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_model_row_deleted(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_model_row_deleted "void gtk_tree_model_row_deleted(GtkTreeModel* tree_model, GtkTreePath* path)"
  s7_pointer _p;
  s7_pointer tree_model, path;
  _p = args;
  tree_model = s7_car(_p); _p = s7_cdr(_p);
  path = s7_car(_p);
  gtk_tree_model_row_deleted((GtkTreeModel*)s7_c_pointer_with_type(sc, tree_model, GtkTreeModel__sym, __func__, 0), (GtkTreePath*)s7_c_pointer_with_type(sc, path, GtkTreePath__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_model_rows_reordered(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_model_rows_reordered "void gtk_tree_model_rows_reordered(GtkTreeModel* tree_model, \
GtkTreePath* path, GtkTreeIter* iter, gint* new_order)"
  s7_pointer _p;
  s7_pointer tree_model, path, iter, new_order;
  _p = args;
  tree_model = s7_car(_p); _p = s7_cdr(_p);
  path = s7_car(_p); _p = s7_cdr(_p);
  iter = s7_car(_p); _p = s7_cdr(_p);
  new_order = s7_car(_p);
  gtk_tree_model_rows_reordered((GtkTreeModel*)s7_c_pointer_with_type(sc, tree_model, GtkTreeModel__sym, __func__, 0), (GtkTreePath*)s7_c_pointer_with_type(sc, path, GtkTreePath__sym, __func__, 0), (GtkTreeIter*)s7_c_pointer_with_type(sc, iter, GtkTreeIter__sym, __func__, 0), (gint*)s7_c_pointer_with_type(sc, new_order, gint__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_model_sort_new_with_model(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_model_sort_new_with_model "GtkTreeModel* gtk_tree_model_sort_new_with_model(GtkTreeModel* child_model)"
  s7_pointer child_model;
  child_model = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GtkTreeModel__sym, gtk_tree_model_sort_new_with_model((GtkTreeModel*)s7_c_pointer_with_type(sc, child_model, GtkTreeModel__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_model_sort_get_model(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_model_sort_get_model "GtkTreeModel* gtk_tree_model_sort_get_model(GtkTreeModelSort* tree_model)"
  s7_pointer tree_model;
  tree_model = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GtkTreeModel__sym, gtk_tree_model_sort_get_model((GtkTreeModelSort*)s7_c_pointer_with_type(sc, tree_model, GtkTreeModelSort__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_model_sort_convert_child_path_to_path(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_model_sort_convert_child_path_to_path "GtkTreePath* gtk_tree_model_sort_convert_child_path_to_path(GtkTreeModelSort* tree_model_sort, \
GtkTreePath* child_path)"
  s7_pointer _p;
  s7_pointer tree_model_sort, child_path;
  _p = args;
  tree_model_sort = s7_car(_p); _p = s7_cdr(_p);
  child_path = s7_car(_p);
  return(lg_make_c_pointer_with_type(sc, GtkTreePath__sym, gtk_tree_model_sort_convert_child_path_to_path((GtkTreeModelSort*)s7_c_pointer_with_type(sc, tree_model_sort, GtkTreeModelSort__sym, __func__, 0), (GtkTreePath*)s7_c_pointer_with_type(sc, child_path, GtkTreePath__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_model_sort_convert_child_iter_to_iter(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_model_sort_convert_child_iter_to_iter "void gtk_tree_model_sort_convert_child_iter_to_iter(GtkTreeModelSort* tree_model_sort, \
GtkTreeIter* sort_iter, GtkTreeIter* child_iter)"
  s7_pointer _p;
  s7_pointer tree_model_sort, sort_iter, child_iter;
  _p = args;
  tree_model_sort = s7_car(_p); _p = s7_cdr(_p);
  sort_iter = s7_car(_p); _p = s7_cdr(_p);
  child_iter = s7_car(_p);
  gtk_tree_model_sort_convert_child_iter_to_iter((GtkTreeModelSort*)s7_c_pointer_with_type(sc, tree_model_sort, GtkTreeModelSort__sym, __func__, 0), (GtkTreeIter*)s7_c_pointer_with_type(sc, sort_iter, GtkTreeIter__sym, __func__, 0), (GtkTreeIter*)s7_c_pointer_with_type(sc, child_iter, GtkTreeIter__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_model_sort_convert_path_to_child_path(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_model_sort_convert_path_to_child_path "GtkTreePath* gtk_tree_model_sort_convert_path_to_child_path(GtkTreeModelSort* tree_model_sort, \
GtkTreePath* sorted_path)"
  s7_pointer _p;
  s7_pointer tree_model_sort, sorted_path;
  _p = args;
  tree_model_sort = s7_car(_p); _p = s7_cdr(_p);
  sorted_path = s7_car(_p);
  return(lg_make_c_pointer_with_type(sc, GtkTreePath__sym, gtk_tree_model_sort_convert_path_to_child_path((GtkTreeModelSort*)s7_c_pointer_with_type(sc, tree_model_sort, GtkTreeModelSort__sym, __func__, 0), (GtkTreePath*)s7_c_pointer_with_type(sc, sorted_path, GtkTreePath__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_model_sort_convert_iter_to_child_iter(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_model_sort_convert_iter_to_child_iter "void gtk_tree_model_sort_convert_iter_to_child_iter(GtkTreeModelSort* tree_model_sort, \
GtkTreeIter* child_iter, GtkTreeIter* sorted_iter)"
  s7_pointer _p;
  s7_pointer tree_model_sort, child_iter, sorted_iter;
  _p = args;
  tree_model_sort = s7_car(_p); _p = s7_cdr(_p);
  child_iter = s7_car(_p); _p = s7_cdr(_p);
  sorted_iter = s7_car(_p);
  gtk_tree_model_sort_convert_iter_to_child_iter((GtkTreeModelSort*)s7_c_pointer_with_type(sc, tree_model_sort, GtkTreeModelSort__sym, __func__, 0), (GtkTreeIter*)s7_c_pointer_with_type(sc, child_iter, GtkTreeIter__sym, __func__, 0), (GtkTreeIter*)s7_c_pointer_with_type(sc, sorted_iter, GtkTreeIter__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_model_sort_reset_default_sort_func(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_model_sort_reset_default_sort_func "void gtk_tree_model_sort_reset_default_sort_func(GtkTreeModelSort* tree_model_sort)"
  s7_pointer tree_model_sort;
  tree_model_sort = s7_car(args);
  gtk_tree_model_sort_reset_default_sort_func((GtkTreeModelSort*)s7_c_pointer_with_type(sc, tree_model_sort, GtkTreeModelSort__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_model_sort_clear_cache(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_model_sort_clear_cache "void gtk_tree_model_sort_clear_cache(GtkTreeModelSort* tree_model_sort)"
  s7_pointer tree_model_sort;
  tree_model_sort = s7_car(args);
  gtk_tree_model_sort_clear_cache((GtkTreeModelSort*)s7_c_pointer_with_type(sc, tree_model_sort, GtkTreeModelSort__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_selection_set_mode(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_selection_set_mode "void gtk_tree_selection_set_mode(GtkTreeSelection* selection, \
GtkSelectionMode type)"
  s7_pointer _p;
  s7_pointer selection, type;
  _p = args;
  selection = s7_car(_p); _p = s7_cdr(_p);
  type = s7_car(_p);
  if (!s7_is_integer(type)) s7_wrong_type_arg_error(sc, "gtk_tree_selection_set_mode", 2, type, "GtkSelectionMode");
  gtk_tree_selection_set_mode((GtkTreeSelection*)s7_c_pointer_with_type(sc, selection, GtkTreeSelection__sym, __func__, 0), (GtkSelectionMode)s7_integer(type));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_selection_get_mode(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_selection_get_mode "GtkSelectionMode gtk_tree_selection_get_mode(GtkTreeSelection* selection)"
  s7_pointer selection;
  selection = s7_car(args);
  return(s7_make_integer(sc, gtk_tree_selection_get_mode((GtkTreeSelection*)s7_c_pointer_with_type(sc, selection, GtkTreeSelection__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_selection_set_select_function(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_selection_set_select_function "void gtk_tree_selection_set_select_function(GtkTreeSelection* selection, \
GtkTreeSelectionFunc func, lambda_data func_info, GtkDestroyNotify destroy)"
  s7_pointer _p;
  s7_pointer selection, func, func_info, destroy;
  _p = args;
  selection = s7_car(_p); _p = s7_cdr(_p);
  func = s7_car(_p); _p = s7_cdr(_p);
  func_info = s7_car(_p); _p = s7_cdr(_p);
  destroy = s7_car(_p);
  {
    s7_pointer lg_ptr = s7_list(sc, 5, func, func_info, lg_false, lg_false, lg_false);
    s7_gc_protect(sc, lg_ptr);
    s7_list_set(sc, lg_ptr, 3, destroy);
    gtk_tree_selection_set_select_function((GtkTreeSelection*)s7_c_pointer_with_type(sc, selection, GtkTreeSelection__sym, __func__, 0), lg_tree_selection, (gpointer)lg_ptr, lg_destroy_func);
    return(lg_false);
   }
}

static s7_pointer lg_gtk_tree_selection_get_user_data(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_selection_get_user_data "gpointer gtk_tree_selection_get_user_data(GtkTreeSelection* selection)"
  s7_pointer selection;
  selection = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, gpointer_sym, gtk_tree_selection_get_user_data((GtkTreeSelection*)s7_c_pointer_with_type(sc, selection, GtkTreeSelection__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_selection_get_tree_view(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_selection_get_tree_view "GtkTreeView* gtk_tree_selection_get_tree_view(GtkTreeSelection* selection)"
  s7_pointer selection;
  selection = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GtkTreeView__sym, gtk_tree_selection_get_tree_view((GtkTreeSelection*)s7_c_pointer_with_type(sc, selection, GtkTreeSelection__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_selection_get_selected(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_selection_get_selected "gboolean gtk_tree_selection_get_selected(GtkTreeSelection* selection, \
GtkTreeModel** model, GtkTreeIter* iter)"
  s7_pointer _p;
  s7_pointer selection, model, iter;
  _p = args;
  selection = s7_car(_p); _p = s7_cdr(_p);
  model = s7_car(_p); _p = s7_cdr(_p);
  iter = s7_car(_p);
  return(s7_make_boolean(sc, gtk_tree_selection_get_selected((GtkTreeSelection*)s7_c_pointer_with_type(sc, selection, GtkTreeSelection__sym, __func__, 0), (GtkTreeModel**)s7_c_pointer_with_type(sc, model, GtkTreeModel___sym, __func__, 0), (GtkTreeIter*)s7_c_pointer_with_type(sc, iter, GtkTreeIter__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_selection_selected_foreach(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_selection_selected_foreach "void gtk_tree_selection_selected_foreach(GtkTreeSelection* selection, \
GtkTreeSelectionForeachFunc func, lambda_data func_info)"
  s7_pointer _p;
  s7_pointer selection, func, func_info;
  _p = args;
  selection = s7_car(_p); _p = s7_cdr(_p);
  func = s7_car(_p); _p = s7_cdr(_p);
  func_info = s7_car(_p);
  {
    int loc;
    s7_pointer lg_ptr = s7_list(sc, 5, func, func_info, lg_false, lg_false, lg_false);
    loc = s7_gc_protect(sc, lg_ptr);
    s7_list_set(sc, lg_ptr, 2, s7_make_integer(sc, loc));
    gtk_tree_selection_selected_foreach((GtkTreeSelection*)s7_c_pointer_with_type(sc, selection, GtkTreeSelection__sym, __func__, 0), lg_tree_selection_func, (gpointer)lg_ptr);
    return(lg_false);
   }
}

static s7_pointer lg_gtk_tree_selection_select_path(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_selection_select_path "void gtk_tree_selection_select_path(GtkTreeSelection* selection, \
GtkTreePath* path)"
  s7_pointer _p;
  s7_pointer selection, path;
  _p = args;
  selection = s7_car(_p); _p = s7_cdr(_p);
  path = s7_car(_p);
  gtk_tree_selection_select_path((GtkTreeSelection*)s7_c_pointer_with_type(sc, selection, GtkTreeSelection__sym, __func__, 0), (GtkTreePath*)s7_c_pointer_with_type(sc, path, GtkTreePath__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_selection_unselect_path(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_selection_unselect_path "void gtk_tree_selection_unselect_path(GtkTreeSelection* selection, \
GtkTreePath* path)"
  s7_pointer _p;
  s7_pointer selection, path;
  _p = args;
  selection = s7_car(_p); _p = s7_cdr(_p);
  path = s7_car(_p);
  gtk_tree_selection_unselect_path((GtkTreeSelection*)s7_c_pointer_with_type(sc, selection, GtkTreeSelection__sym, __func__, 0), (GtkTreePath*)s7_c_pointer_with_type(sc, path, GtkTreePath__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_selection_select_iter(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_selection_select_iter "void gtk_tree_selection_select_iter(GtkTreeSelection* selection, \
GtkTreeIter* iter)"
  s7_pointer _p;
  s7_pointer selection, iter;
  _p = args;
  selection = s7_car(_p); _p = s7_cdr(_p);
  iter = s7_car(_p);
  gtk_tree_selection_select_iter((GtkTreeSelection*)s7_c_pointer_with_type(sc, selection, GtkTreeSelection__sym, __func__, 0), (GtkTreeIter*)s7_c_pointer_with_type(sc, iter, GtkTreeIter__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_selection_unselect_iter(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_selection_unselect_iter "void gtk_tree_selection_unselect_iter(GtkTreeSelection* selection, \
GtkTreeIter* iter)"
  s7_pointer _p;
  s7_pointer selection, iter;
  _p = args;
  selection = s7_car(_p); _p = s7_cdr(_p);
  iter = s7_car(_p);
  gtk_tree_selection_unselect_iter((GtkTreeSelection*)s7_c_pointer_with_type(sc, selection, GtkTreeSelection__sym, __func__, 0), (GtkTreeIter*)s7_c_pointer_with_type(sc, iter, GtkTreeIter__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_selection_path_is_selected(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_selection_path_is_selected "gboolean gtk_tree_selection_path_is_selected(GtkTreeSelection* selection, \
GtkTreePath* path)"
  s7_pointer _p;
  s7_pointer selection, path;
  _p = args;
  selection = s7_car(_p); _p = s7_cdr(_p);
  path = s7_car(_p);
  return(s7_make_boolean(sc, gtk_tree_selection_path_is_selected((GtkTreeSelection*)s7_c_pointer_with_type(sc, selection, GtkTreeSelection__sym, __func__, 0), (GtkTreePath*)s7_c_pointer_with_type(sc, path, GtkTreePath__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_selection_iter_is_selected(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_selection_iter_is_selected "gboolean gtk_tree_selection_iter_is_selected(GtkTreeSelection* selection, \
GtkTreeIter* iter)"
  s7_pointer _p;
  s7_pointer selection, iter;
  _p = args;
  selection = s7_car(_p); _p = s7_cdr(_p);
  iter = s7_car(_p);
  return(s7_make_boolean(sc, gtk_tree_selection_iter_is_selected((GtkTreeSelection*)s7_c_pointer_with_type(sc, selection, GtkTreeSelection__sym, __func__, 0), (GtkTreeIter*)s7_c_pointer_with_type(sc, iter, GtkTreeIter__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_selection_select_all(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_selection_select_all "void gtk_tree_selection_select_all(GtkTreeSelection* selection)"
  s7_pointer selection;
  selection = s7_car(args);
  gtk_tree_selection_select_all((GtkTreeSelection*)s7_c_pointer_with_type(sc, selection, GtkTreeSelection__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_selection_unselect_all(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_selection_unselect_all "void gtk_tree_selection_unselect_all(GtkTreeSelection* selection)"
  s7_pointer selection;
  selection = s7_car(args);
  gtk_tree_selection_unselect_all((GtkTreeSelection*)s7_c_pointer_with_type(sc, selection, GtkTreeSelection__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_selection_select_range(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_selection_select_range "void gtk_tree_selection_select_range(GtkTreeSelection* selection, \
GtkTreePath* start_path, GtkTreePath* end_path)"
  s7_pointer _p;
  s7_pointer selection, start_path, end_path;
  _p = args;
  selection = s7_car(_p); _p = s7_cdr(_p);
  start_path = s7_car(_p); _p = s7_cdr(_p);
  end_path = s7_car(_p);
  gtk_tree_selection_select_range((GtkTreeSelection*)s7_c_pointer_with_type(sc, selection, GtkTreeSelection__sym, __func__, 0), (GtkTreePath*)s7_c_pointer_with_type(sc, start_path, GtkTreePath__sym, __func__, 0), (GtkTreePath*)s7_c_pointer_with_type(sc, end_path, GtkTreePath__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_sortable_sort_column_changed(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_sortable_sort_column_changed "void gtk_tree_sortable_sort_column_changed(GtkTreeSortable* sortable)"
  s7_pointer sortable;
  sortable = s7_car(args);
  gtk_tree_sortable_sort_column_changed((GtkTreeSortable*)s7_c_pointer_with_type(sc, sortable, GtkTreeSortable__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_sortable_get_sort_column_id(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_sortable_get_sort_column_id "gboolean gtk_tree_sortable_get_sort_column_id(GtkTreeSortable* sortable, \
gint* [sort_column_id], GtkSortType* [order])"
  s7_pointer _p;
  s7_pointer sortable;
  gint ref_sort_column_id;
  GtkSortType ref_order;
  _p = args;
  sortable = s7_car(_p);
  {
    s7_pointer res_ult;
    res_ult = s7_make_boolean(sc, gtk_tree_sortable_get_sort_column_id((GtkTreeSortable*)s7_c_pointer_with_type(sc, sortable, GtkTreeSortable__sym, __func__, 0), &ref_sort_column_id, &ref_order));
      return(s7_list(sc, 3, res_ult, s7_make_integer(sc, ref_sort_column_id), s7_make_integer(sc, ref_order)));
   }
}

static s7_pointer lg_gtk_tree_sortable_set_sort_column_id(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_sortable_set_sort_column_id "void gtk_tree_sortable_set_sort_column_id(GtkTreeSortable* sortable, \
gint sort_column_id, GtkSortType order)"
  s7_pointer _p;
  s7_pointer sortable, sort_column_id, order;
  _p = args;
  sortable = s7_car(_p); _p = s7_cdr(_p);
  sort_column_id = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(sort_column_id)) s7_wrong_type_arg_error(sc, "gtk_tree_sortable_set_sort_column_id", 2, sort_column_id, "gint");
  order = s7_car(_p);
  if (!s7_is_integer(order)) s7_wrong_type_arg_error(sc, "gtk_tree_sortable_set_sort_column_id", 3, order, "GtkSortType");
  gtk_tree_sortable_set_sort_column_id((GtkTreeSortable*)s7_c_pointer_with_type(sc, sortable, GtkTreeSortable__sym, __func__, 0), (gint)s7_integer(sort_column_id), (GtkSortType)s7_integer(order));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_sortable_set_sort_func(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_sortable_set_sort_func "void gtk_tree_sortable_set_sort_func(GtkTreeSortable* sortable, \
gint sort_column_id, GtkTreeIterCompareFunc func, lambda_data func_info, GtkDestroyNotify destroy)"
  s7_pointer _p;
  s7_pointer sortable, sort_column_id, func, func_info, destroy;
  _p = args;
  sortable = s7_car(_p); _p = s7_cdr(_p);
  sort_column_id = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(sort_column_id)) s7_wrong_type_arg_error(sc, "gtk_tree_sortable_set_sort_func", 2, sort_column_id, "gint");
  func = s7_car(_p); _p = s7_cdr(_p);
  func_info = s7_car(_p); _p = s7_cdr(_p);
  destroy = s7_car(_p);
  {
    s7_pointer lg_ptr = s7_list(sc, 5, func, func_info, lg_false, lg_false, lg_false);
    s7_gc_protect(sc, lg_ptr);
    s7_list_set(sc, lg_ptr, 3, destroy);
    gtk_tree_sortable_set_sort_func((GtkTreeSortable*)s7_c_pointer_with_type(sc, sortable, GtkTreeSortable__sym, __func__, 0), (gint)s7_integer(sort_column_id), lg_iter_compare, (gpointer)lg_ptr, lg_destroy_func);
    return(lg_false);
   }
}

static s7_pointer lg_gtk_tree_sortable_set_default_sort_func(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_sortable_set_default_sort_func "void gtk_tree_sortable_set_default_sort_func(GtkTreeSortable* sortable, \
GtkTreeIterCompareFunc func, lambda_data func_info, GtkDestroyNotify destroy)"
  s7_pointer _p;
  s7_pointer sortable, func, func_info, destroy;
  _p = args;
  sortable = s7_car(_p); _p = s7_cdr(_p);
  func = s7_car(_p); _p = s7_cdr(_p);
  func_info = s7_car(_p); _p = s7_cdr(_p);
  destroy = s7_car(_p);
  {
    s7_pointer lg_ptr = s7_list(sc, 5, func, func_info, lg_false, lg_false, lg_false);
    s7_gc_protect(sc, lg_ptr);
    s7_list_set(sc, lg_ptr, 3, destroy);
    gtk_tree_sortable_set_default_sort_func((GtkTreeSortable*)s7_c_pointer_with_type(sc, sortable, GtkTreeSortable__sym, __func__, 0), lg_iter_compare, (gpointer)lg_ptr, lg_destroy_func);
    return(lg_false);
   }
}

static s7_pointer lg_gtk_tree_sortable_has_default_sort_func(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_sortable_has_default_sort_func "gboolean gtk_tree_sortable_has_default_sort_func(GtkTreeSortable* sortable)"
  s7_pointer sortable;
  sortable = s7_car(args);
  return(s7_make_boolean(sc, gtk_tree_sortable_has_default_sort_func((GtkTreeSortable*)s7_c_pointer_with_type(sc, sortable, GtkTreeSortable__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_store_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_store_new "GtkTreeStore* gtk_tree_store_new(gint n_columns, etc types)"
  s7_pointer _p;
  s7_pointer n_columns, types;
  _p = args;
  n_columns = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(n_columns)) s7_wrong_type_arg_error(sc, "gtk_tree_store_new", 1, n_columns, "gint");
  types = s7_car(_p);
  if (!lg_is_list(types)) s7_wrong_type_arg_error(sc, "gtk_tree_store_new", 2, types, "etc");
  {
    int etc_len = 0;
    GtkTreeStore* res_ult = NULL;
    gint p_arg0;
    if (s7_is_list(sc, types)) etc_len = s7_list_length(sc, types);
    if (etc_len < 1) s7_out_of_range_error(sc, "gtk_tree_store_new", 1, types, "... list must have at least 1 entry");
    if (etc_len > 6) s7_out_of_range_error(sc, "gtk_tree_store_new", 1, types, "... list too long (max len: 6)");
    p_arg0 = (gint)s7_integer(n_columns);
    switch (etc_len)
      {
        case 1: res_ult = gtk_tree_store_new(p_arg0, s7_c_pointer(s7_list_ref(sc, types, 0))); break;
        case 2: res_ult = gtk_tree_store_new(p_arg0, s7_c_pointer(s7_list_ref(sc, types, 0)), s7_c_pointer(s7_list_ref(sc, types, 1))); break;
        case 3: res_ult = gtk_tree_store_new(p_arg0, s7_c_pointer(s7_list_ref(sc, types, 0)), s7_c_pointer(s7_list_ref(sc, types, 1)), s7_c_pointer(s7_list_ref(sc, types, 2))); break;
        case 4: res_ult = gtk_tree_store_new(p_arg0, s7_c_pointer(s7_list_ref(sc, types, 0)), s7_c_pointer(s7_list_ref(sc, types, 1)), s7_c_pointer(s7_list_ref(sc, types, 2)), s7_c_pointer(s7_list_ref(sc, types, 3))); break;
        case 5: res_ult = gtk_tree_store_new(p_arg0, s7_c_pointer(s7_list_ref(sc, types, 0)), s7_c_pointer(s7_list_ref(sc, types, 1)), s7_c_pointer(s7_list_ref(sc, types, 2)), s7_c_pointer(s7_list_ref(sc, types, 3)), s7_c_pointer(s7_list_ref(sc, types, 4))); break;
        case 6: res_ult = gtk_tree_store_new(p_arg0, s7_c_pointer(s7_list_ref(sc, types, 0)), s7_c_pointer(s7_list_ref(sc, types, 1)), s7_c_pointer(s7_list_ref(sc, types, 2)), s7_c_pointer(s7_list_ref(sc, types, 3)), s7_c_pointer(s7_list_ref(sc, types, 4)), s7_c_pointer(s7_list_ref(sc, types, 5))); break;
      }
    return(s7_make_c_pointer(sc, res_ult));
  }
}

static s7_pointer lg_gtk_tree_store_newv(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_store_newv "GtkTreeStore* gtk_tree_store_newv(gint n_columns, GType* types)"
  s7_pointer _p;
  s7_pointer n_columns, types;
  _p = args;
  n_columns = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(n_columns)) s7_wrong_type_arg_error(sc, "gtk_tree_store_newv", 1, n_columns, "gint");
  types = s7_car(_p);
  return(lg_make_c_pointer_with_type(sc, GtkTreeStore__sym, gtk_tree_store_newv((gint)s7_integer(n_columns), (GType*)s7_c_pointer_with_type(sc, types, GType__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_store_set_column_types(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_store_set_column_types "void gtk_tree_store_set_column_types(GtkTreeStore* tree_store, \
gint n_columns, GType* types)"
  s7_pointer _p;
  s7_pointer tree_store, n_columns, types;
  _p = args;
  tree_store = s7_car(_p); _p = s7_cdr(_p);
  n_columns = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(n_columns)) s7_wrong_type_arg_error(sc, "gtk_tree_store_set_column_types", 2, n_columns, "gint");
  types = s7_car(_p);
  gtk_tree_store_set_column_types((GtkTreeStore*)s7_c_pointer_with_type(sc, tree_store, GtkTreeStore__sym, __func__, 0), (gint)s7_integer(n_columns), (GType*)s7_c_pointer_with_type(sc, types, GType__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_store_set(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_store_set "void gtk_tree_store_set(GtkTreeStore* tree_store, GtkTreeIter* iter, \
etc values)"
  s7_pointer _p;
  s7_pointer tree_store, iter, values;
  _p = args;
  tree_store = s7_car(_p); _p = s7_cdr(_p);
  iter = s7_car(_p); _p = s7_cdr(_p);
  values = s7_car(_p);
  if (!lg_is_list(values)) s7_wrong_type_arg_error(sc, "gtk_tree_store_set", 3, values, "etc");
  {
    int etc_len = 0;
    GtkTreeStore* p_arg0;
    GtkTreeIter* p_arg1;
    if (s7_is_list(sc, values)) etc_len = s7_list_length(sc, values);
    if (etc_len < 2) s7_out_of_range_error(sc, "gtk_tree_store_set", 2, values, "... list must have at least 2 entries");
    if (etc_len > 10) s7_out_of_range_error(sc, "gtk_tree_store_set", 2, values, "... list too long (max len: 10)");
    if ((etc_len % 2) != 0) s7_out_of_range_error(sc, "gtk_tree_store_set", 2, values, "... list len must be multiple of 2");
    p_arg0 = (GtkTreeStore*)s7_c_pointer_with_type(sc, tree_store, GtkTreeStore__sym, __func__, 0);
    p_arg1 = (GtkTreeIter*)s7_c_pointer_with_type(sc, iter, GtkTreeIter__sym, __func__, 0);
    switch (etc_len)
      {
        case 2: gtk_tree_store_set(p_arg0, p_arg1, s7_integer(s7_list_ref(sc, values, 0)), s7_string(s7_list_ref(sc, values, 1)), -1); break;
        case 4: gtk_tree_store_set(p_arg0, p_arg1, s7_integer(s7_list_ref(sc, values, 0)), s7_string(s7_list_ref(sc, values, 1)), s7_integer(s7_list_ref(sc, values, 2)), s7_string(s7_list_ref(sc, values, 3)), -1); break;
        case 6: gtk_tree_store_set(p_arg0, p_arg1, s7_integer(s7_list_ref(sc, values, 0)), s7_string(s7_list_ref(sc, values, 1)), s7_integer(s7_list_ref(sc, values, 2)), s7_string(s7_list_ref(sc, values, 3)), s7_integer(s7_list_ref(sc, values, 4)), s7_string(s7_list_ref(sc, values, 5)), -1); break;
        case 8: gtk_tree_store_set(p_arg0, p_arg1, s7_integer(s7_list_ref(sc, values, 0)), s7_string(s7_list_ref(sc, values, 1)), s7_integer(s7_list_ref(sc, values, 2)), s7_string(s7_list_ref(sc, values, 3)), s7_integer(s7_list_ref(sc, values, 4)), s7_string(s7_list_ref(sc, values, 5)), s7_integer(s7_list_ref(sc, values, 6)), s7_string(s7_list_ref(sc, values, 7)), -1); break;
        case 10: gtk_tree_store_set(p_arg0, p_arg1, s7_integer(s7_list_ref(sc, values, 0)), s7_string(s7_list_ref(sc, values, 1)), s7_integer(s7_list_ref(sc, values, 2)), s7_string(s7_list_ref(sc, values, 3)), s7_integer(s7_list_ref(sc, values, 4)), s7_string(s7_list_ref(sc, values, 5)), s7_integer(s7_list_ref(sc, values, 6)), s7_string(s7_list_ref(sc, values, 7)), s7_integer(s7_list_ref(sc, values, 8)), s7_string(s7_list_ref(sc, values, 9)), -1); break;
      }
    return(lg_false);
  }
}

static s7_pointer lg_gtk_tree_store_remove(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_store_remove "void gtk_tree_store_remove(GtkTreeStore* tree_store, GtkTreeIter* iter)"
  s7_pointer _p;
  s7_pointer tree_store, iter;
  _p = args;
  tree_store = s7_car(_p); _p = s7_cdr(_p);
  iter = s7_car(_p);
  gtk_tree_store_remove((GtkTreeStore*)s7_c_pointer_with_type(sc, tree_store, GtkTreeStore__sym, __func__, 0), (GtkTreeIter*)s7_c_pointer_with_type(sc, iter, GtkTreeIter__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_store_insert(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_store_insert "void gtk_tree_store_insert(GtkTreeStore* tree_store, GtkTreeIter* iter, \
GtkTreeIter* parent, gint position)"
  s7_pointer _p;
  s7_pointer tree_store, iter, parent, position;
  _p = args;
  tree_store = s7_car(_p); _p = s7_cdr(_p);
  iter = s7_car(_p); _p = s7_cdr(_p);
  parent = s7_car(_p); _p = s7_cdr(_p);
  position = s7_car(_p);
  if (!s7_is_integer(position)) s7_wrong_type_arg_error(sc, "gtk_tree_store_insert", 4, position, "gint");
  gtk_tree_store_insert((GtkTreeStore*)s7_c_pointer_with_type(sc, tree_store, GtkTreeStore__sym, __func__, 0), (GtkTreeIter*)s7_c_pointer_with_type(sc, iter, GtkTreeIter__sym, __func__, 0), (GtkTreeIter*)s7_c_pointer_with_type(sc, parent, GtkTreeIter__sym, __func__, 0), (gint)s7_integer(position));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_store_insert_before(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_store_insert_before "void gtk_tree_store_insert_before(GtkTreeStore* tree_store, \
GtkTreeIter* iter, GtkTreeIter* parent, GtkTreeIter* sibling)"
  s7_pointer _p;
  s7_pointer tree_store, iter, parent, sibling;
  _p = args;
  tree_store = s7_car(_p); _p = s7_cdr(_p);
  iter = s7_car(_p); _p = s7_cdr(_p);
  parent = s7_car(_p); _p = s7_cdr(_p);
  sibling = s7_car(_p);
  gtk_tree_store_insert_before((GtkTreeStore*)s7_c_pointer_with_type(sc, tree_store, GtkTreeStore__sym, __func__, 0), (GtkTreeIter*)s7_c_pointer_with_type(sc, iter, GtkTreeIter__sym, __func__, 0), (GtkTreeIter*)s7_c_pointer_with_type(sc, parent, GtkTreeIter__sym, __func__, 0), (GtkTreeIter*)s7_c_pointer_with_type(sc, sibling, GtkTreeIter__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_store_insert_after(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_store_insert_after "void gtk_tree_store_insert_after(GtkTreeStore* tree_store, GtkTreeIter* iter, \
GtkTreeIter* parent, GtkTreeIter* sibling)"
  s7_pointer _p;
  s7_pointer tree_store, iter, parent, sibling;
  _p = args;
  tree_store = s7_car(_p); _p = s7_cdr(_p);
  iter = s7_car(_p); _p = s7_cdr(_p);
  parent = s7_car(_p); _p = s7_cdr(_p);
  sibling = s7_car(_p);
  gtk_tree_store_insert_after((GtkTreeStore*)s7_c_pointer_with_type(sc, tree_store, GtkTreeStore__sym, __func__, 0), (GtkTreeIter*)s7_c_pointer_with_type(sc, iter, GtkTreeIter__sym, __func__, 0), (GtkTreeIter*)s7_c_pointer_with_type(sc, parent, GtkTreeIter__sym, __func__, 0), (GtkTreeIter*)s7_c_pointer_with_type(sc, sibling, GtkTreeIter__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_store_prepend(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_store_prepend "void gtk_tree_store_prepend(GtkTreeStore* tree_store, GtkTreeIter* iter, \
GtkTreeIter* parent)"
  s7_pointer _p;
  s7_pointer tree_store, iter, parent;
  _p = args;
  tree_store = s7_car(_p); _p = s7_cdr(_p);
  iter = s7_car(_p); _p = s7_cdr(_p);
  parent = s7_car(_p);
  gtk_tree_store_prepend((GtkTreeStore*)s7_c_pointer_with_type(sc, tree_store, GtkTreeStore__sym, __func__, 0), (GtkTreeIter*)s7_c_pointer_with_type(sc, iter, GtkTreeIter__sym, __func__, 0), (GtkTreeIter*)s7_c_pointer_with_type(sc, parent, GtkTreeIter__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_store_append(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_store_append "void gtk_tree_store_append(GtkTreeStore* tree_store, GtkTreeIter* iter, \
GtkTreeIter* parent)"
  s7_pointer _p;
  s7_pointer tree_store, iter, parent;
  _p = args;
  tree_store = s7_car(_p); _p = s7_cdr(_p);
  iter = s7_car(_p); _p = s7_cdr(_p);
  parent = s7_car(_p);
  gtk_tree_store_append((GtkTreeStore*)s7_c_pointer_with_type(sc, tree_store, GtkTreeStore__sym, __func__, 0), (GtkTreeIter*)s7_c_pointer_with_type(sc, iter, GtkTreeIter__sym, __func__, 0), (GtkTreeIter*)s7_c_pointer_with_type(sc, parent, GtkTreeIter__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_store_is_ancestor(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_store_is_ancestor "gboolean gtk_tree_store_is_ancestor(GtkTreeStore* tree_store, \
GtkTreeIter* iter, GtkTreeIter* descendant)"
  s7_pointer _p;
  s7_pointer tree_store, iter, descendant;
  _p = args;
  tree_store = s7_car(_p); _p = s7_cdr(_p);
  iter = s7_car(_p); _p = s7_cdr(_p);
  descendant = s7_car(_p);
  return(s7_make_boolean(sc, gtk_tree_store_is_ancestor((GtkTreeStore*)s7_c_pointer_with_type(sc, tree_store, GtkTreeStore__sym, __func__, 0), (GtkTreeIter*)s7_c_pointer_with_type(sc, iter, GtkTreeIter__sym, __func__, 0), (GtkTreeIter*)s7_c_pointer_with_type(sc, descendant, GtkTreeIter__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_store_iter_depth(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_store_iter_depth "gint gtk_tree_store_iter_depth(GtkTreeStore* tree_store, GtkTreeIter* iter)"
  s7_pointer _p;
  s7_pointer tree_store, iter;
  _p = args;
  tree_store = s7_car(_p); _p = s7_cdr(_p);
  iter = s7_car(_p);
  return(s7_make_integer(sc, gtk_tree_store_iter_depth((GtkTreeStore*)s7_c_pointer_with_type(sc, tree_store, GtkTreeStore__sym, __func__, 0), (GtkTreeIter*)s7_c_pointer_with_type(sc, iter, GtkTreeIter__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_store_clear(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_store_clear "void gtk_tree_store_clear(GtkTreeStore* tree_store)"
  s7_pointer tree_store;
  tree_store = s7_car(args);
  gtk_tree_store_clear((GtkTreeStore*)s7_c_pointer_with_type(sc, tree_store, GtkTreeStore__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_column_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_new "GtkTreeViewColumn* gtk_tree_view_column_new( void)"
  return(lg_make_c_pointer_with_type(sc, GtkTreeViewColumn__sym, gtk_tree_view_column_new()));
}

static s7_pointer lg_gtk_tree_view_column_new_with_attributes(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_new_with_attributes "GtkTreeViewColumn* gtk_tree_view_column_new_with_attributes(gchar* title, \
GtkCellRenderer* cell, etc attributes)"
  s7_pointer _p;
  s7_pointer title, cell, attributes;
  _p = args;
  title = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(title)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_new_with_attributes", 1, title, "gchar*");
  cell = s7_car(_p); _p = s7_cdr(_p);
  attributes = s7_car(_p);
  if (!lg_is_list(attributes)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_new_with_attributes", 3, attributes, "etc");
  {
    int etc_len = 0;
    GtkTreeViewColumn* res_ult = NULL;
    gchar* p_arg0;
    GtkCellRenderer* p_arg1;
    if (s7_is_list(sc, attributes)) etc_len = s7_list_length(sc, attributes);
    if (etc_len < 2) s7_out_of_range_error(sc, "gtk_tree_view_column_new_with_attributes", 2, attributes, "... list must have at least 2 entries");
    if (etc_len > 10) s7_out_of_range_error(sc, "gtk_tree_view_column_new_with_attributes", 2, attributes, "... list too long (max len: 10)");
    if ((etc_len % 2) != 0) s7_out_of_range_error(sc, "gtk_tree_view_column_new_with_attributes", 2, attributes, "... list len must be multiple of 2");
    p_arg0 = (gchar*)s7_string(title);
    p_arg1 = (GtkCellRenderer*)s7_c_pointer_with_type(sc, cell, GtkCellRenderer__sym, __func__, 0);
    switch (etc_len)
      {
        case 2: res_ult = gtk_tree_view_column_new_with_attributes(p_arg0, p_arg1, s7_string(s7_list_ref(sc, attributes, 0)), s7_integer(s7_list_ref(sc, attributes, 1)), NULL); break;
        case 4: res_ult = gtk_tree_view_column_new_with_attributes(p_arg0, p_arg1, s7_string(s7_list_ref(sc, attributes, 0)), s7_integer(s7_list_ref(sc, attributes, 1)), s7_string(s7_list_ref(sc, attributes, 2)), s7_integer(s7_list_ref(sc, attributes, 3)), NULL); break;
        case 6: res_ult = gtk_tree_view_column_new_with_attributes(p_arg0, p_arg1, s7_string(s7_list_ref(sc, attributes, 0)), s7_integer(s7_list_ref(sc, attributes, 1)), s7_string(s7_list_ref(sc, attributes, 2)), s7_integer(s7_list_ref(sc, attributes, 3)), s7_string(s7_list_ref(sc, attributes, 4)), s7_integer(s7_list_ref(sc, attributes, 5)), NULL); break;
        case 8: res_ult = gtk_tree_view_column_new_with_attributes(p_arg0, p_arg1, s7_string(s7_list_ref(sc, attributes, 0)), s7_integer(s7_list_ref(sc, attributes, 1)), s7_string(s7_list_ref(sc, attributes, 2)), s7_integer(s7_list_ref(sc, attributes, 3)), s7_string(s7_list_ref(sc, attributes, 4)), s7_integer(s7_list_ref(sc, attributes, 5)), s7_string(s7_list_ref(sc, attributes, 6)), s7_integer(s7_list_ref(sc, attributes, 7)), NULL); break;
        case 10: res_ult = gtk_tree_view_column_new_with_attributes(p_arg0, p_arg1, s7_string(s7_list_ref(sc, attributes, 0)), s7_integer(s7_list_ref(sc, attributes, 1)), s7_string(s7_list_ref(sc, attributes, 2)), s7_integer(s7_list_ref(sc, attributes, 3)), s7_string(s7_list_ref(sc, attributes, 4)), s7_integer(s7_list_ref(sc, attributes, 5)), s7_string(s7_list_ref(sc, attributes, 6)), s7_integer(s7_list_ref(sc, attributes, 7)), s7_string(s7_list_ref(sc, attributes, 8)), s7_integer(s7_list_ref(sc, attributes, 9)), NULL); break;
      }
    return(s7_make_c_pointer(sc, res_ult));
  }
}

static s7_pointer lg_gtk_tree_view_column_pack_start(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_pack_start "void gtk_tree_view_column_pack_start(GtkTreeViewColumn* tree_column, \
GtkCellRenderer* cell, gboolean expand)"
  s7_pointer _p;
  s7_pointer tree_column, cell, expand;
  _p = args;
  tree_column = s7_car(_p); _p = s7_cdr(_p);
  cell = s7_car(_p); _p = s7_cdr(_p);
  expand = s7_car(_p);
  if (!s7_is_boolean(expand)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_pack_start", 3, expand, "gboolean");
  gtk_tree_view_column_pack_start((GtkTreeViewColumn*)s7_c_pointer_with_type(sc, tree_column, GtkTreeViewColumn__sym, __func__, 0), (GtkCellRenderer*)s7_c_pointer_with_type(sc, cell, GtkCellRenderer__sym, __func__, 0), (gboolean)lg_boolean(expand));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_column_pack_end(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_pack_end "void gtk_tree_view_column_pack_end(GtkTreeViewColumn* tree_column, \
GtkCellRenderer* cell, gboolean expand)"
  s7_pointer _p;
  s7_pointer tree_column, cell, expand;
  _p = args;
  tree_column = s7_car(_p); _p = s7_cdr(_p);
  cell = s7_car(_p); _p = s7_cdr(_p);
  expand = s7_car(_p);
  if (!s7_is_boolean(expand)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_pack_end", 3, expand, "gboolean");
  gtk_tree_view_column_pack_end((GtkTreeViewColumn*)s7_c_pointer_with_type(sc, tree_column, GtkTreeViewColumn__sym, __func__, 0), (GtkCellRenderer*)s7_c_pointer_with_type(sc, cell, GtkCellRenderer__sym, __func__, 0), (gboolean)lg_boolean(expand));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_column_clear(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_clear "void gtk_tree_view_column_clear(GtkTreeViewColumn* tree_column)"
  s7_pointer tree_column;
  tree_column = s7_car(args);
  gtk_tree_view_column_clear((GtkTreeViewColumn*)s7_c_pointer_with_type(sc, tree_column, GtkTreeViewColumn__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_column_add_attribute(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_add_attribute "void gtk_tree_view_column_add_attribute(GtkTreeViewColumn* tree_column, \
GtkCellRenderer* cell_renderer, gchar* attribute, gint column)"
  s7_pointer _p;
  s7_pointer tree_column, cell_renderer, attribute, column;
  _p = args;
  tree_column = s7_car(_p); _p = s7_cdr(_p);
  cell_renderer = s7_car(_p); _p = s7_cdr(_p);
  attribute = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(attribute)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_add_attribute", 3, attribute, "gchar*");
  column = s7_car(_p);
  if (!s7_is_integer(column)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_add_attribute", 4, column, "gint");
  gtk_tree_view_column_add_attribute((GtkTreeViewColumn*)s7_c_pointer_with_type(sc, tree_column, GtkTreeViewColumn__sym, __func__, 0), (GtkCellRenderer*)s7_c_pointer_with_type(sc, cell_renderer, GtkCellRenderer__sym, __func__, 0), (gchar*)s7_string(attribute), (gint)s7_integer(column));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_column_set_attributes(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_set_attributes "void gtk_tree_view_column_set_attributes(GtkTreeViewColumn* tree_column, \
GtkCellRenderer* cell_renderer, etc attributes)"
  s7_pointer _p;
  s7_pointer tree_column, cell_renderer, attributes;
  _p = args;
  tree_column = s7_car(_p); _p = s7_cdr(_p);
  cell_renderer = s7_car(_p); _p = s7_cdr(_p);
  attributes = s7_car(_p);
  if (!lg_is_list(attributes)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_set_attributes", 3, attributes, "etc");
  {
    int etc_len = 0;
    GtkTreeViewColumn* p_arg0;
    GtkCellRenderer* p_arg1;
    if (s7_is_list(sc, attributes)) etc_len = s7_list_length(sc, attributes);
    if (etc_len < 2) s7_out_of_range_error(sc, "gtk_tree_view_column_set_attributes", 2, attributes, "... list must have at least 2 entries");
    if (etc_len > 10) s7_out_of_range_error(sc, "gtk_tree_view_column_set_attributes", 2, attributes, "... list too long (max len: 10)");
    if ((etc_len % 2) != 0) s7_out_of_range_error(sc, "gtk_tree_view_column_set_attributes", 2, attributes, "... list len must be multiple of 2");
    p_arg0 = (GtkTreeViewColumn*)s7_c_pointer_with_type(sc, tree_column, GtkTreeViewColumn__sym, __func__, 0);
    p_arg1 = (GtkCellRenderer*)s7_c_pointer_with_type(sc, cell_renderer, GtkCellRenderer__sym, __func__, 0);
    switch (etc_len)
      {
        case 2: gtk_tree_view_column_set_attributes(p_arg0, p_arg1, s7_string(s7_list_ref(sc, attributes, 0)), s7_integer(s7_list_ref(sc, attributes, 1)), NULL); break;
        case 4: gtk_tree_view_column_set_attributes(p_arg0, p_arg1, s7_string(s7_list_ref(sc, attributes, 0)), s7_integer(s7_list_ref(sc, attributes, 1)), s7_string(s7_list_ref(sc, attributes, 2)), s7_integer(s7_list_ref(sc, attributes, 3)), NULL); break;
        case 6: gtk_tree_view_column_set_attributes(p_arg0, p_arg1, s7_string(s7_list_ref(sc, attributes, 0)), s7_integer(s7_list_ref(sc, attributes, 1)), s7_string(s7_list_ref(sc, attributes, 2)), s7_integer(s7_list_ref(sc, attributes, 3)), s7_string(s7_list_ref(sc, attributes, 4)), s7_integer(s7_list_ref(sc, attributes, 5)), NULL); break;
        case 8: gtk_tree_view_column_set_attributes(p_arg0, p_arg1, s7_string(s7_list_ref(sc, attributes, 0)), s7_integer(s7_list_ref(sc, attributes, 1)), s7_string(s7_list_ref(sc, attributes, 2)), s7_integer(s7_list_ref(sc, attributes, 3)), s7_string(s7_list_ref(sc, attributes, 4)), s7_integer(s7_list_ref(sc, attributes, 5)), s7_string(s7_list_ref(sc, attributes, 6)), s7_integer(s7_list_ref(sc, attributes, 7)), NULL); break;
        case 10: gtk_tree_view_column_set_attributes(p_arg0, p_arg1, s7_string(s7_list_ref(sc, attributes, 0)), s7_integer(s7_list_ref(sc, attributes, 1)), s7_string(s7_list_ref(sc, attributes, 2)), s7_integer(s7_list_ref(sc, attributes, 3)), s7_string(s7_list_ref(sc, attributes, 4)), s7_integer(s7_list_ref(sc, attributes, 5)), s7_string(s7_list_ref(sc, attributes, 6)), s7_integer(s7_list_ref(sc, attributes, 7)), s7_string(s7_list_ref(sc, attributes, 8)), s7_integer(s7_list_ref(sc, attributes, 9)), NULL); break;
      }
    return(lg_false);
  }
}

static s7_pointer lg_gtk_tree_view_column_set_cell_data_func(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_set_cell_data_func "void gtk_tree_view_column_set_cell_data_func(GtkTreeViewColumn* tree_column, \
GtkCellRenderer* cell_renderer, GtkTreeCellDataFunc func, lambda_data func_info, GtkDestroyNotify destroy)"
  s7_pointer _p;
  s7_pointer tree_column, cell_renderer, func, func_info, destroy;
  _p = args;
  tree_column = s7_car(_p); _p = s7_cdr(_p);
  cell_renderer = s7_car(_p); _p = s7_cdr(_p);
  func = s7_car(_p); _p = s7_cdr(_p);
  func_info = s7_car(_p); _p = s7_cdr(_p);
  destroy = s7_car(_p);
  {
    s7_pointer lg_ptr = s7_list(sc, 5, func, func_info, lg_false, lg_false, lg_false);
    s7_gc_protect(sc, lg_ptr);
    s7_list_set(sc, lg_ptr, 3, destroy);
    gtk_tree_view_column_set_cell_data_func((GtkTreeViewColumn*)s7_c_pointer_with_type(sc, tree_column, GtkTreeViewColumn__sym, __func__, 0), (GtkCellRenderer*)s7_c_pointer_with_type(sc, cell_renderer, GtkCellRenderer__sym, __func__, 0), lg_cell_data, (gpointer)lg_ptr, lg_destroy_func);
    return(lg_false);
   }
}

static s7_pointer lg_gtk_tree_view_column_clear_attributes(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_clear_attributes "void gtk_tree_view_column_clear_attributes(GtkTreeViewColumn* tree_column, \
GtkCellRenderer* cell_renderer)"
  s7_pointer _p;
  s7_pointer tree_column, cell_renderer;
  _p = args;
  tree_column = s7_car(_p); _p = s7_cdr(_p);
  cell_renderer = s7_car(_p);
  gtk_tree_view_column_clear_attributes((GtkTreeViewColumn*)s7_c_pointer_with_type(sc, tree_column, GtkTreeViewColumn__sym, __func__, 0), (GtkCellRenderer*)s7_c_pointer_with_type(sc, cell_renderer, GtkCellRenderer__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_column_set_spacing(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_set_spacing "void gtk_tree_view_column_set_spacing(GtkTreeViewColumn* tree_column, \
gint spacing)"
  s7_pointer _p;
  s7_pointer tree_column, spacing;
  _p = args;
  tree_column = s7_car(_p); _p = s7_cdr(_p);
  spacing = s7_car(_p);
  if (!s7_is_integer(spacing)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_set_spacing", 2, spacing, "gint");
  gtk_tree_view_column_set_spacing((GtkTreeViewColumn*)s7_c_pointer_with_type(sc, tree_column, GtkTreeViewColumn__sym, __func__, 0), (gint)s7_integer(spacing));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_column_get_spacing(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_get_spacing "gint gtk_tree_view_column_get_spacing(GtkTreeViewColumn* tree_column)"
  s7_pointer tree_column;
  tree_column = s7_car(args);
  return(s7_make_integer(sc, gtk_tree_view_column_get_spacing((GtkTreeViewColumn*)s7_c_pointer_with_type(sc, tree_column, GtkTreeViewColumn__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_view_column_set_visible(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_set_visible "void gtk_tree_view_column_set_visible(GtkTreeViewColumn* tree_column, \
gboolean visible)"
  s7_pointer _p;
  s7_pointer tree_column, visible;
  _p = args;
  tree_column = s7_car(_p); _p = s7_cdr(_p);
  visible = s7_car(_p);
  if (!s7_is_boolean(visible)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_set_visible", 2, visible, "gboolean");
  gtk_tree_view_column_set_visible((GtkTreeViewColumn*)s7_c_pointer_with_type(sc, tree_column, GtkTreeViewColumn__sym, __func__, 0), (gboolean)lg_boolean(visible));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_column_get_visible(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_get_visible "gboolean gtk_tree_view_column_get_visible(GtkTreeViewColumn* tree_column)"
  s7_pointer tree_column;
  tree_column = s7_car(args);
  return(s7_make_boolean(sc, gtk_tree_view_column_get_visible((GtkTreeViewColumn*)s7_c_pointer_with_type(sc, tree_column, GtkTreeViewColumn__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_view_column_set_resizable(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_set_resizable "void gtk_tree_view_column_set_resizable(GtkTreeViewColumn* tree_column, \
gboolean resizable)"
  s7_pointer _p;
  s7_pointer tree_column, resizable;
  _p = args;
  tree_column = s7_car(_p); _p = s7_cdr(_p);
  resizable = s7_car(_p);
  if (!s7_is_boolean(resizable)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_set_resizable", 2, resizable, "gboolean");
  gtk_tree_view_column_set_resizable((GtkTreeViewColumn*)s7_c_pointer_with_type(sc, tree_column, GtkTreeViewColumn__sym, __func__, 0), (gboolean)lg_boolean(resizable));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_column_get_resizable(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_get_resizable "gboolean gtk_tree_view_column_get_resizable(GtkTreeViewColumn* tree_column)"
  s7_pointer tree_column;
  tree_column = s7_car(args);
  return(s7_make_boolean(sc, gtk_tree_view_column_get_resizable((GtkTreeViewColumn*)s7_c_pointer_with_type(sc, tree_column, GtkTreeViewColumn__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_view_column_set_sizing(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_set_sizing "void gtk_tree_view_column_set_sizing(GtkTreeViewColumn* tree_column, \
GtkTreeViewColumnSizing type)"
  s7_pointer _p;
  s7_pointer tree_column, type;
  _p = args;
  tree_column = s7_car(_p); _p = s7_cdr(_p);
  type = s7_car(_p);
  if (!s7_is_integer(type)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_set_sizing", 2, type, "GtkTreeViewColumnSizing");
  gtk_tree_view_column_set_sizing((GtkTreeViewColumn*)s7_c_pointer_with_type(sc, tree_column, GtkTreeViewColumn__sym, __func__, 0), (GtkTreeViewColumnSizing)s7_integer(type));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_column_get_sizing(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_get_sizing "GtkTreeViewColumnSizing gtk_tree_view_column_get_sizing(GtkTreeViewColumn* tree_column)"
  s7_pointer tree_column;
  tree_column = s7_car(args);
  return(s7_make_integer(sc, gtk_tree_view_column_get_sizing((GtkTreeViewColumn*)s7_c_pointer_with_type(sc, tree_column, GtkTreeViewColumn__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_view_column_get_width(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_get_width "gint gtk_tree_view_column_get_width(GtkTreeViewColumn* tree_column)"
  s7_pointer tree_column;
  tree_column = s7_car(args);
  return(s7_make_integer(sc, gtk_tree_view_column_get_width((GtkTreeViewColumn*)s7_c_pointer_with_type(sc, tree_column, GtkTreeViewColumn__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_view_column_get_fixed_width(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_get_fixed_width "gint gtk_tree_view_column_get_fixed_width(GtkTreeViewColumn* tree_column)"
  s7_pointer tree_column;
  tree_column = s7_car(args);
  return(s7_make_integer(sc, gtk_tree_view_column_get_fixed_width((GtkTreeViewColumn*)s7_c_pointer_with_type(sc, tree_column, GtkTreeViewColumn__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_view_column_set_fixed_width(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_set_fixed_width "void gtk_tree_view_column_set_fixed_width(GtkTreeViewColumn* tree_column, \
gint fixed_width)"
  s7_pointer _p;
  s7_pointer tree_column, fixed_width;
  _p = args;
  tree_column = s7_car(_p); _p = s7_cdr(_p);
  fixed_width = s7_car(_p);
  if (!s7_is_integer(fixed_width)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_set_fixed_width", 2, fixed_width, "gint");
  gtk_tree_view_column_set_fixed_width((GtkTreeViewColumn*)s7_c_pointer_with_type(sc, tree_column, GtkTreeViewColumn__sym, __func__, 0), (gint)s7_integer(fixed_width));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_column_set_min_width(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_set_min_width "void gtk_tree_view_column_set_min_width(GtkTreeViewColumn* tree_column, \
gint min_width)"
  s7_pointer _p;
  s7_pointer tree_column, min_width;
  _p = args;
  tree_column = s7_car(_p); _p = s7_cdr(_p);
  min_width = s7_car(_p);
  if (!s7_is_integer(min_width)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_set_min_width", 2, min_width, "gint");
  gtk_tree_view_column_set_min_width((GtkTreeViewColumn*)s7_c_pointer_with_type(sc, tree_column, GtkTreeViewColumn__sym, __func__, 0), (gint)s7_integer(min_width));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_column_get_min_width(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_get_min_width "gint gtk_tree_view_column_get_min_width(GtkTreeViewColumn* tree_column)"
  s7_pointer tree_column;
  tree_column = s7_car(args);
  return(s7_make_integer(sc, gtk_tree_view_column_get_min_width((GtkTreeViewColumn*)s7_c_pointer_with_type(sc, tree_column, GtkTreeViewColumn__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_view_column_set_max_width(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_set_max_width "void gtk_tree_view_column_set_max_width(GtkTreeViewColumn* tree_column, \
gint max_width)"
  s7_pointer _p;
  s7_pointer tree_column, max_width;
  _p = args;
  tree_column = s7_car(_p); _p = s7_cdr(_p);
  max_width = s7_car(_p);
  if (!s7_is_integer(max_width)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_set_max_width", 2, max_width, "gint");
  gtk_tree_view_column_set_max_width((GtkTreeViewColumn*)s7_c_pointer_with_type(sc, tree_column, GtkTreeViewColumn__sym, __func__, 0), (gint)s7_integer(max_width));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_column_get_max_width(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_get_max_width "gint gtk_tree_view_column_get_max_width(GtkTreeViewColumn* tree_column)"
  s7_pointer tree_column;
  tree_column = s7_car(args);
  return(s7_make_integer(sc, gtk_tree_view_column_get_max_width((GtkTreeViewColumn*)s7_c_pointer_with_type(sc, tree_column, GtkTreeViewColumn__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_view_column_clicked(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_clicked "void gtk_tree_view_column_clicked(GtkTreeViewColumn* tree_column)"
  s7_pointer tree_column;
  tree_column = s7_car(args);
  gtk_tree_view_column_clicked((GtkTreeViewColumn*)s7_c_pointer_with_type(sc, tree_column, GtkTreeViewColumn__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_column_set_title(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_set_title "void gtk_tree_view_column_set_title(GtkTreeViewColumn* tree_column, \
gchar* title)"
  s7_pointer _p;
  s7_pointer tree_column, title;
  _p = args;
  tree_column = s7_car(_p); _p = s7_cdr(_p);
  title = s7_car(_p);
  if (!s7_is_string(title)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_set_title", 2, title, "gchar*");
  gtk_tree_view_column_set_title((GtkTreeViewColumn*)s7_c_pointer_with_type(sc, tree_column, GtkTreeViewColumn__sym, __func__, 0), (gchar*)s7_string(title));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_column_get_title(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_get_title "gchar* gtk_tree_view_column_get_title(GtkTreeViewColumn* tree_column)"
  s7_pointer tree_column;
  tree_column = s7_car(args);
  return(s7_make_string(sc, gtk_tree_view_column_get_title((GtkTreeViewColumn*)s7_c_pointer_with_type(sc, tree_column, GtkTreeViewColumn__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_view_column_set_clickable(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_set_clickable "void gtk_tree_view_column_set_clickable(GtkTreeViewColumn* tree_column, \
gboolean clickable)"
  s7_pointer _p;
  s7_pointer tree_column, clickable;
  _p = args;
  tree_column = s7_car(_p); _p = s7_cdr(_p);
  clickable = s7_car(_p);
  if (!s7_is_boolean(clickable)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_set_clickable", 2, clickable, "gboolean");
  gtk_tree_view_column_set_clickable((GtkTreeViewColumn*)s7_c_pointer_with_type(sc, tree_column, GtkTreeViewColumn__sym, __func__, 0), (gboolean)lg_boolean(clickable));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_column_get_clickable(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_get_clickable "gboolean gtk_tree_view_column_get_clickable(GtkTreeViewColumn* tree_column)"
  s7_pointer tree_column;
  tree_column = s7_car(args);
  return(s7_make_boolean(sc, gtk_tree_view_column_get_clickable((GtkTreeViewColumn*)s7_c_pointer_with_type(sc, tree_column, GtkTreeViewColumn__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_view_column_set_widget(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_set_widget "void gtk_tree_view_column_set_widget(GtkTreeViewColumn* tree_column, \
GtkWidget* widget)"
  s7_pointer _p;
  s7_pointer tree_column, widget;
  _p = args;
  tree_column = s7_car(_p); _p = s7_cdr(_p);
  widget = s7_car(_p);
  gtk_tree_view_column_set_widget((GtkTreeViewColumn*)s7_c_pointer_with_type(sc, tree_column, GtkTreeViewColumn__sym, __func__, 0), (GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_column_get_widget(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_get_widget "GtkWidget* gtk_tree_view_column_get_widget(GtkTreeViewColumn* tree_column)"
  s7_pointer tree_column;
  tree_column = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_tree_view_column_get_widget((GtkTreeViewColumn*)s7_c_pointer_with_type(sc, tree_column, GtkTreeViewColumn__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_view_column_set_alignment(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_set_alignment "void gtk_tree_view_column_set_alignment(GtkTreeViewColumn* tree_column, \
gfloat xalign)"
  s7_pointer _p;
  s7_pointer tree_column, xalign;
  _p = args;
  tree_column = s7_car(_p); _p = s7_cdr(_p);
  xalign = s7_car(_p);
  if (!s7_is_real(xalign)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_set_alignment", 2, xalign, "gfloat");
  gtk_tree_view_column_set_alignment((GtkTreeViewColumn*)s7_c_pointer_with_type(sc, tree_column, GtkTreeViewColumn__sym, __func__, 0), (gfloat)s7_real(xalign));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_column_get_alignment(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_get_alignment "gfloat gtk_tree_view_column_get_alignment(GtkTreeViewColumn* tree_column)"
  s7_pointer tree_column;
  tree_column = s7_car(args);
  return(s7_make_real(sc, gtk_tree_view_column_get_alignment((GtkTreeViewColumn*)s7_c_pointer_with_type(sc, tree_column, GtkTreeViewColumn__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_view_column_set_reorderable(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_set_reorderable "void gtk_tree_view_column_set_reorderable(GtkTreeViewColumn* tree_column, \
gboolean reorderable)"
  s7_pointer _p;
  s7_pointer tree_column, reorderable;
  _p = args;
  tree_column = s7_car(_p); _p = s7_cdr(_p);
  reorderable = s7_car(_p);
  if (!s7_is_boolean(reorderable)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_set_reorderable", 2, reorderable, "gboolean");
  gtk_tree_view_column_set_reorderable((GtkTreeViewColumn*)s7_c_pointer_with_type(sc, tree_column, GtkTreeViewColumn__sym, __func__, 0), (gboolean)lg_boolean(reorderable));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_column_get_reorderable(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_get_reorderable "gboolean gtk_tree_view_column_get_reorderable(GtkTreeViewColumn* tree_column)"
  s7_pointer tree_column;
  tree_column = s7_car(args);
  return(s7_make_boolean(sc, gtk_tree_view_column_get_reorderable((GtkTreeViewColumn*)s7_c_pointer_with_type(sc, tree_column, GtkTreeViewColumn__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_view_column_set_sort_column_id(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_set_sort_column_id "void gtk_tree_view_column_set_sort_column_id(GtkTreeViewColumn* tree_column, \
gint sort_column_id)"
  s7_pointer _p;
  s7_pointer tree_column, sort_column_id;
  _p = args;
  tree_column = s7_car(_p); _p = s7_cdr(_p);
  sort_column_id = s7_car(_p);
  if (!s7_is_integer(sort_column_id)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_set_sort_column_id", 2, sort_column_id, "gint");
  gtk_tree_view_column_set_sort_column_id((GtkTreeViewColumn*)s7_c_pointer_with_type(sc, tree_column, GtkTreeViewColumn__sym, __func__, 0), (gint)s7_integer(sort_column_id));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_column_get_sort_column_id(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_get_sort_column_id "gint gtk_tree_view_column_get_sort_column_id(GtkTreeViewColumn* tree_column)"
  s7_pointer tree_column;
  tree_column = s7_car(args);
  return(s7_make_integer(sc, gtk_tree_view_column_get_sort_column_id((GtkTreeViewColumn*)s7_c_pointer_with_type(sc, tree_column, GtkTreeViewColumn__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_view_column_set_sort_indicator(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_set_sort_indicator "void gtk_tree_view_column_set_sort_indicator(GtkTreeViewColumn* tree_column, \
gboolean setting)"
  s7_pointer _p;
  s7_pointer tree_column, setting;
  _p = args;
  tree_column = s7_car(_p); _p = s7_cdr(_p);
  setting = s7_car(_p);
  if (!s7_is_boolean(setting)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_set_sort_indicator", 2, setting, "gboolean");
  gtk_tree_view_column_set_sort_indicator((GtkTreeViewColumn*)s7_c_pointer_with_type(sc, tree_column, GtkTreeViewColumn__sym, __func__, 0), (gboolean)lg_boolean(setting));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_column_get_sort_indicator(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_get_sort_indicator "gboolean gtk_tree_view_column_get_sort_indicator(GtkTreeViewColumn* tree_column)"
  s7_pointer tree_column;
  tree_column = s7_car(args);
  return(s7_make_boolean(sc, gtk_tree_view_column_get_sort_indicator((GtkTreeViewColumn*)s7_c_pointer_with_type(sc, tree_column, GtkTreeViewColumn__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_view_column_set_sort_order(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_set_sort_order "void gtk_tree_view_column_set_sort_order(GtkTreeViewColumn* tree_column, \
GtkSortType order)"
  s7_pointer _p;
  s7_pointer tree_column, order;
  _p = args;
  tree_column = s7_car(_p); _p = s7_cdr(_p);
  order = s7_car(_p);
  if (!s7_is_integer(order)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_set_sort_order", 2, order, "GtkSortType");
  gtk_tree_view_column_set_sort_order((GtkTreeViewColumn*)s7_c_pointer_with_type(sc, tree_column, GtkTreeViewColumn__sym, __func__, 0), (GtkSortType)s7_integer(order));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_column_get_sort_order(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_get_sort_order "GtkSortType gtk_tree_view_column_get_sort_order(GtkTreeViewColumn* tree_column)"
  s7_pointer tree_column;
  tree_column = s7_car(args);
  return(s7_make_integer(sc, gtk_tree_view_column_get_sort_order((GtkTreeViewColumn*)s7_c_pointer_with_type(sc, tree_column, GtkTreeViewColumn__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_view_column_cell_set_cell_data(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_cell_set_cell_data "void gtk_tree_view_column_cell_set_cell_data(GtkTreeViewColumn* tree_column, \
GtkTreeModel* tree_model, GtkTreeIter* iter, gboolean is_expander, gboolean is_expanded)"
  s7_pointer _p;
  s7_pointer tree_column, tree_model, iter, is_expander, is_expanded;
  _p = args;
  tree_column = s7_car(_p); _p = s7_cdr(_p);
  tree_model = s7_car(_p); _p = s7_cdr(_p);
  iter = s7_car(_p); _p = s7_cdr(_p);
  is_expander = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_boolean(is_expander)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_cell_set_cell_data", 4, is_expander, "gboolean");
  is_expanded = s7_car(_p);
  if (!s7_is_boolean(is_expanded)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_cell_set_cell_data", 5, is_expanded, "gboolean");
  gtk_tree_view_column_cell_set_cell_data((GtkTreeViewColumn*)s7_c_pointer_with_type(sc, tree_column, GtkTreeViewColumn__sym, __func__, 0), (GtkTreeModel*)s7_c_pointer_with_type(sc, tree_model, GtkTreeModel__sym, __func__, 0), (GtkTreeIter*)s7_c_pointer_with_type(sc, iter, GtkTreeIter__sym, __func__, 0), (gboolean)lg_boolean(is_expander), (gboolean)lg_boolean(is_expanded));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_column_cell_is_visible(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_cell_is_visible "gboolean gtk_tree_view_column_cell_is_visible(GtkTreeViewColumn* tree_column)"
  s7_pointer tree_column;
  tree_column = s7_car(args);
  return(s7_make_boolean(sc, gtk_tree_view_column_cell_is_visible((GtkTreeViewColumn*)s7_c_pointer_with_type(sc, tree_column, GtkTreeViewColumn__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_view_column_cell_get_position(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_cell_get_position "gboolean gtk_tree_view_column_cell_get_position(GtkTreeViewColumn* tree_column, \
GtkCellRenderer* cell_renderer, gint* [start_pos], gint* [width])"
  s7_pointer _p;
  s7_pointer tree_column, cell_renderer;
  gint ref_start_pos;
  gint ref_width;
  _p = args;
  tree_column = s7_car(_p); _p = s7_cdr(_p);
  cell_renderer = s7_car(_p);
  {
    s7_pointer res_ult;
    res_ult = s7_make_boolean(sc, gtk_tree_view_column_cell_get_position((GtkTreeViewColumn*)s7_c_pointer_with_type(sc, tree_column, GtkTreeViewColumn__sym, __func__, 0), (GtkCellRenderer*)s7_c_pointer_with_type(sc, cell_renderer, GtkCellRenderer__sym, __func__, 0), &ref_start_pos, &ref_width));
      return(s7_list(sc, 3, res_ult, s7_make_integer(sc, ref_start_pos), s7_make_integer(sc, ref_width)));
   }
}

static s7_pointer lg_gtk_tree_view_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_new "GtkWidget* gtk_tree_view_new( void)"
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_tree_view_new()));
}

static s7_pointer lg_gtk_tree_view_new_with_model(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_new_with_model "GtkWidget* gtk_tree_view_new_with_model(GtkTreeModel* model)"
  s7_pointer model;
  model = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_tree_view_new_with_model((GtkTreeModel*)s7_c_pointer_with_type(sc, model, GtkTreeModel__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_view_get_model(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_get_model "GtkTreeModel* gtk_tree_view_get_model(GtkTreeView* tree_view)"
  s7_pointer tree_view;
  tree_view = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GtkTreeModel__sym, gtk_tree_view_get_model((GtkTreeView*)s7_c_pointer_with_type(sc, tree_view, GtkTreeView__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_view_set_model(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_set_model "void gtk_tree_view_set_model(GtkTreeView* tree_view, GtkTreeModel* model)"
  s7_pointer _p;
  s7_pointer tree_view, model;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  model = s7_car(_p);
  gtk_tree_view_set_model((GtkTreeView*)s7_c_pointer_with_type(sc, tree_view, GtkTreeView__sym, __func__, 0), (GtkTreeModel*)s7_c_pointer_with_type(sc, model, GtkTreeModel__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_get_selection(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_get_selection "GtkTreeSelection* gtk_tree_view_get_selection(GtkTreeView* tree_view)"
  s7_pointer tree_view;
  tree_view = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GtkTreeSelection__sym, gtk_tree_view_get_selection((GtkTreeView*)s7_c_pointer_with_type(sc, tree_view, GtkTreeView__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_view_get_headers_visible(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_get_headers_visible "gboolean gtk_tree_view_get_headers_visible(GtkTreeView* tree_view)"
  s7_pointer tree_view;
  tree_view = s7_car(args);
  return(s7_make_boolean(sc, gtk_tree_view_get_headers_visible((GtkTreeView*)s7_c_pointer_with_type(sc, tree_view, GtkTreeView__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_view_set_headers_visible(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_set_headers_visible "void gtk_tree_view_set_headers_visible(GtkTreeView* tree_view, \
gboolean headers_visible)"
  s7_pointer _p;
  s7_pointer tree_view, headers_visible;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  headers_visible = s7_car(_p);
  if (!s7_is_boolean(headers_visible)) s7_wrong_type_arg_error(sc, "gtk_tree_view_set_headers_visible", 2, headers_visible, "gboolean");
  gtk_tree_view_set_headers_visible((GtkTreeView*)s7_c_pointer_with_type(sc, tree_view, GtkTreeView__sym, __func__, 0), (gboolean)lg_boolean(headers_visible));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_columns_autosize(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_columns_autosize "void gtk_tree_view_columns_autosize(GtkTreeView* tree_view)"
  s7_pointer tree_view;
  tree_view = s7_car(args);
  gtk_tree_view_columns_autosize((GtkTreeView*)s7_c_pointer_with_type(sc, tree_view, GtkTreeView__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_set_headers_clickable(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_set_headers_clickable "void gtk_tree_view_set_headers_clickable(GtkTreeView* tree_view, \
gboolean setting)"
  s7_pointer _p;
  s7_pointer tree_view, setting;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  setting = s7_car(_p);
  if (!s7_is_boolean(setting)) s7_wrong_type_arg_error(sc, "gtk_tree_view_set_headers_clickable", 2, setting, "gboolean");
  gtk_tree_view_set_headers_clickable((GtkTreeView*)s7_c_pointer_with_type(sc, tree_view, GtkTreeView__sym, __func__, 0), (gboolean)lg_boolean(setting));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_append_column(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_append_column "gint gtk_tree_view_append_column(GtkTreeView* tree_view, GtkTreeViewColumn* column)"
  s7_pointer _p;
  s7_pointer tree_view, column;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  column = s7_car(_p);
  return(s7_make_integer(sc, gtk_tree_view_append_column((GtkTreeView*)s7_c_pointer_with_type(sc, tree_view, GtkTreeView__sym, __func__, 0), (GtkTreeViewColumn*)s7_c_pointer_with_type(sc, column, GtkTreeViewColumn__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_view_remove_column(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_remove_column "gint gtk_tree_view_remove_column(GtkTreeView* tree_view, GtkTreeViewColumn* column)"
  s7_pointer _p;
  s7_pointer tree_view, column;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  column = s7_car(_p);
  return(s7_make_integer(sc, gtk_tree_view_remove_column((GtkTreeView*)s7_c_pointer_with_type(sc, tree_view, GtkTreeView__sym, __func__, 0), (GtkTreeViewColumn*)s7_c_pointer_with_type(sc, column, GtkTreeViewColumn__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_view_insert_column(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_insert_column "gint gtk_tree_view_insert_column(GtkTreeView* tree_view, GtkTreeViewColumn* column, \
gint position)"
  s7_pointer _p;
  s7_pointer tree_view, column, position;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  column = s7_car(_p); _p = s7_cdr(_p);
  position = s7_car(_p);
  if (!s7_is_integer(position)) s7_wrong_type_arg_error(sc, "gtk_tree_view_insert_column", 3, position, "gint");
  return(s7_make_integer(sc, gtk_tree_view_insert_column((GtkTreeView*)s7_c_pointer_with_type(sc, tree_view, GtkTreeView__sym, __func__, 0), (GtkTreeViewColumn*)s7_c_pointer_with_type(sc, column, GtkTreeViewColumn__sym, __func__, 0), (gint)s7_integer(position))));
}

static s7_pointer lg_gtk_tree_view_insert_column_with_attributes(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_insert_column_with_attributes "gint gtk_tree_view_insert_column_with_attributes(GtkTreeView* tree_view, \
gint position, gchar* title, GtkCellRenderer* cell, etc attributes)"
  s7_pointer _p;
  s7_pointer tree_view, position, title, cell, attributes;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  position = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(position)) s7_wrong_type_arg_error(sc, "gtk_tree_view_insert_column_with_attributes", 2, position, "gint");
  title = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(title)) s7_wrong_type_arg_error(sc, "gtk_tree_view_insert_column_with_attributes", 3, title, "gchar*");
  cell = s7_car(_p); _p = s7_cdr(_p);
  attributes = s7_car(_p);
  if (!lg_is_list(attributes)) s7_wrong_type_arg_error(sc, "gtk_tree_view_insert_column_with_attributes", 5, attributes, "etc");
  {
    int etc_len = 0;
    gint res_ult = 0;
    GtkTreeView* p_arg0;
    gint p_arg1;
    gchar* p_arg2;
    GtkCellRenderer* p_arg3;
    if (s7_is_list(sc, attributes)) etc_len = s7_list_length(sc, attributes);
    if (etc_len < 2) s7_out_of_range_error(sc, "gtk_tree_view_insert_column_with_attributes", 4, attributes, "... list must have at least 2 entries");
    if (etc_len > 10) s7_out_of_range_error(sc, "gtk_tree_view_insert_column_with_attributes", 4, attributes, "... list too long (max len: 10)");
    if ((etc_len % 2) != 0) s7_out_of_range_error(sc, "gtk_tree_view_insert_column_with_attributes", 4, attributes, "... list len must be multiple of 2");
    p_arg0 = (GtkTreeView*)s7_c_pointer_with_type(sc, tree_view, GtkTreeView__sym, __func__, 0);
    p_arg1 = (gint)s7_integer(position);
    p_arg2 = (gchar*)s7_string(title);
    p_arg3 = (GtkCellRenderer*)s7_c_pointer_with_type(sc, cell, GtkCellRenderer__sym, __func__, 0);
    switch (etc_len)
      {
        case 2: res_ult = gtk_tree_view_insert_column_with_attributes(p_arg0, p_arg1, p_arg2, p_arg3, s7_string(s7_list_ref(sc, attributes, 0)), s7_integer(s7_list_ref(sc, attributes, 1)), NULL); break;
        case 4: res_ult = gtk_tree_view_insert_column_with_attributes(p_arg0, p_arg1, p_arg2, p_arg3, s7_string(s7_list_ref(sc, attributes, 0)), s7_integer(s7_list_ref(sc, attributes, 1)), s7_string(s7_list_ref(sc, attributes, 2)), s7_integer(s7_list_ref(sc, attributes, 3)), NULL); break;
        case 6: res_ult = gtk_tree_view_insert_column_with_attributes(p_arg0, p_arg1, p_arg2, p_arg3, s7_string(s7_list_ref(sc, attributes, 0)), s7_integer(s7_list_ref(sc, attributes, 1)), s7_string(s7_list_ref(sc, attributes, 2)), s7_integer(s7_list_ref(sc, attributes, 3)), s7_string(s7_list_ref(sc, attributes, 4)), s7_integer(s7_list_ref(sc, attributes, 5)), NULL); break;
        case 8: res_ult = gtk_tree_view_insert_column_with_attributes(p_arg0, p_arg1, p_arg2, p_arg3, s7_string(s7_list_ref(sc, attributes, 0)), s7_integer(s7_list_ref(sc, attributes, 1)), s7_string(s7_list_ref(sc, attributes, 2)), s7_integer(s7_list_ref(sc, attributes, 3)), s7_string(s7_list_ref(sc, attributes, 4)), s7_integer(s7_list_ref(sc, attributes, 5)), s7_string(s7_list_ref(sc, attributes, 6)), s7_integer(s7_list_ref(sc, attributes, 7)), NULL); break;
        case 10: res_ult = gtk_tree_view_insert_column_with_attributes(p_arg0, p_arg1, p_arg2, p_arg3, s7_string(s7_list_ref(sc, attributes, 0)), s7_integer(s7_list_ref(sc, attributes, 1)), s7_string(s7_list_ref(sc, attributes, 2)), s7_integer(s7_list_ref(sc, attributes, 3)), s7_string(s7_list_ref(sc, attributes, 4)), s7_integer(s7_list_ref(sc, attributes, 5)), s7_string(s7_list_ref(sc, attributes, 6)), s7_integer(s7_list_ref(sc, attributes, 7)), s7_string(s7_list_ref(sc, attributes, 8)), s7_integer(s7_list_ref(sc, attributes, 9)), NULL); break;
      }
    return(s7_make_integer(sc, res_ult));
  }
}

static s7_pointer lg_gtk_tree_view_insert_column_with_data_func(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_insert_column_with_data_func "gint gtk_tree_view_insert_column_with_data_func(GtkTreeView* tree_view, \
gint position, gchar* title, GtkCellRenderer* cell, GtkTreeCellDataFunc func, lambda_data func_info, \
GtkDestroyNotify dnotify)"
  s7_pointer _p;
  s7_pointer tree_view, position, title, cell, func, func_info, dnotify;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  position = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(position)) s7_wrong_type_arg_error(sc, "gtk_tree_view_insert_column_with_data_func", 2, position, "gint");
  title = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(title)) s7_wrong_type_arg_error(sc, "gtk_tree_view_insert_column_with_data_func", 3, title, "gchar*");
  cell = s7_car(_p); _p = s7_cdr(_p);
  func = s7_car(_p); _p = s7_cdr(_p);
  func_info = s7_car(_p); _p = s7_cdr(_p);
  dnotify = s7_car(_p);
  {
    s7_pointer res_ult;
    s7_pointer lg_ptr = s7_list(sc, 5, func, func_info, lg_false, lg_false, lg_false);
    s7_gc_protect(sc, lg_ptr);
    s7_list_set(sc, lg_ptr, 3, dnotify);
    res_ult = s7_make_integer(sc, gtk_tree_view_insert_column_with_data_func((GtkTreeView*)s7_c_pointer_with_type(sc, tree_view, GtkTreeView__sym, __func__, 0), (gint)s7_integer(position), (gchar*)s7_string(title), (GtkCellRenderer*)s7_c_pointer_with_type(sc, cell, GtkCellRenderer__sym, __func__, 0), lg_cell_data, (gpointer)lg_ptr, lg_destroy_func));
    return(res_ult);
   }
}

static s7_pointer lg_gtk_tree_view_get_column(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_get_column "GtkTreeViewColumn* gtk_tree_view_get_column(GtkTreeView* tree_view, \
gint n)"
  s7_pointer _p;
  s7_pointer tree_view, n;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  n = s7_car(_p);
  if (!s7_is_integer(n)) s7_wrong_type_arg_error(sc, "gtk_tree_view_get_column", 2, n, "gint");
  return(lg_make_c_pointer_with_type(sc, GtkTreeViewColumn__sym, gtk_tree_view_get_column((GtkTreeView*)s7_c_pointer_with_type(sc, tree_view, GtkTreeView__sym, __func__, 0), (gint)s7_integer(n))));
}

static s7_pointer lg_gtk_tree_view_get_columns(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_get_columns "GList* gtk_tree_view_get_columns(GtkTreeView* tree_view)"
  s7_pointer tree_view;
  tree_view = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GList__sym, gtk_tree_view_get_columns((GtkTreeView*)s7_c_pointer_with_type(sc, tree_view, GtkTreeView__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_view_move_column_after(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_move_column_after "void gtk_tree_view_move_column_after(GtkTreeView* tree_view, \
GtkTreeViewColumn* column, GtkTreeViewColumn* base_column)"
  s7_pointer _p;
  s7_pointer tree_view, column, base_column;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  column = s7_car(_p); _p = s7_cdr(_p);
  base_column = s7_car(_p);
  gtk_tree_view_move_column_after((GtkTreeView*)s7_c_pointer_with_type(sc, tree_view, GtkTreeView__sym, __func__, 0), (GtkTreeViewColumn*)s7_c_pointer_with_type(sc, column, GtkTreeViewColumn__sym, __func__, 0), (GtkTreeViewColumn*)s7_c_pointer_with_type(sc, base_column, GtkTreeViewColumn__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_set_expander_column(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_set_expander_column "void gtk_tree_view_set_expander_column(GtkTreeView* tree_view, \
GtkTreeViewColumn* column)"
  s7_pointer _p;
  s7_pointer tree_view, column;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  column = s7_car(_p);
  gtk_tree_view_set_expander_column((GtkTreeView*)s7_c_pointer_with_type(sc, tree_view, GtkTreeView__sym, __func__, 0), (GtkTreeViewColumn*)s7_c_pointer_with_type(sc, column, GtkTreeViewColumn__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_get_expander_column(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_get_expander_column "GtkTreeViewColumn* gtk_tree_view_get_expander_column(GtkTreeView* tree_view)"
  s7_pointer tree_view;
  tree_view = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GtkTreeViewColumn__sym, gtk_tree_view_get_expander_column((GtkTreeView*)s7_c_pointer_with_type(sc, tree_view, GtkTreeView__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_view_set_column_drag_function(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_set_column_drag_function "void gtk_tree_view_set_column_drag_function(GtkTreeView* tree_view, \
GtkTreeViewColumnDropFunc func, lambda_data func_info, GtkDestroyNotify destroy)"
  s7_pointer _p;
  s7_pointer tree_view, func, func_info, destroy;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  func = s7_car(_p); _p = s7_cdr(_p);
  func_info = s7_car(_p); _p = s7_cdr(_p);
  destroy = s7_car(_p);
  {
    int loc;
    s7_pointer lg_ptr = s7_list(sc, 5, func, func_info, lg_false, lg_false, lg_false);
    loc = s7_gc_protect(sc, lg_ptr);
    s7_list_set(sc, lg_ptr, 2, s7_make_integer(sc, loc));
    s7_list_set(sc, lg_ptr, 3, destroy);
    gtk_tree_view_set_column_drag_function((GtkTreeView*)s7_c_pointer_with_type(sc, tree_view, GtkTreeView__sym, __func__, 0), lg_tree_column, (gpointer)lg_ptr, lg_destroy_func);
    return(lg_false);
   }
}

static s7_pointer lg_gtk_tree_view_scroll_to_point(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_scroll_to_point "void gtk_tree_view_scroll_to_point(GtkTreeView* tree_view, \
gint tree_x, gint tree_y)"
  s7_pointer _p;
  s7_pointer tree_view, tree_x, tree_y;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  tree_x = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(tree_x)) s7_wrong_type_arg_error(sc, "gtk_tree_view_scroll_to_point", 2, tree_x, "gint");
  tree_y = s7_car(_p);
  if (!s7_is_integer(tree_y)) s7_wrong_type_arg_error(sc, "gtk_tree_view_scroll_to_point", 3, tree_y, "gint");
  gtk_tree_view_scroll_to_point((GtkTreeView*)s7_c_pointer_with_type(sc, tree_view, GtkTreeView__sym, __func__, 0), (gint)s7_integer(tree_x), (gint)s7_integer(tree_y));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_scroll_to_cell(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_scroll_to_cell "void gtk_tree_view_scroll_to_cell(GtkTreeView* tree_view, GtkTreePath* path, \
GtkTreeViewColumn* column, gboolean use_align, gfloat row_align, gfloat col_align)"
  s7_pointer _p;
  s7_pointer tree_view, path, column, use_align, row_align, col_align;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  path = s7_car(_p); _p = s7_cdr(_p);
  column = s7_car(_p); _p = s7_cdr(_p);
  use_align = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_boolean(use_align)) s7_wrong_type_arg_error(sc, "gtk_tree_view_scroll_to_cell", 4, use_align, "gboolean");
  row_align = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(row_align)) s7_wrong_type_arg_error(sc, "gtk_tree_view_scroll_to_cell", 5, row_align, "gfloat");
  col_align = s7_car(_p);
  if (!s7_is_real(col_align)) s7_wrong_type_arg_error(sc, "gtk_tree_view_scroll_to_cell", 6, col_align, "gfloat");
  gtk_tree_view_scroll_to_cell((GtkTreeView*)s7_c_pointer_with_type(sc, tree_view, GtkTreeView__sym, __func__, 0), (GtkTreePath*)s7_c_pointer_with_type(sc, path, GtkTreePath__sym, __func__, 0), (GtkTreeViewColumn*)s7_c_pointer_with_type(sc, column, GtkTreeViewColumn__sym, __func__, 0), (gboolean)lg_boolean(use_align), (gfloat)s7_real(row_align), (gfloat)s7_real(col_align));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_row_activated(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_row_activated "void gtk_tree_view_row_activated(GtkTreeView* tree_view, GtkTreePath* path, \
GtkTreeViewColumn* column)"
  s7_pointer _p;
  s7_pointer tree_view, path, column;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  path = s7_car(_p); _p = s7_cdr(_p);
  column = s7_car(_p);
  gtk_tree_view_row_activated((GtkTreeView*)s7_c_pointer_with_type(sc, tree_view, GtkTreeView__sym, __func__, 0), (GtkTreePath*)s7_c_pointer_with_type(sc, path, GtkTreePath__sym, __func__, 0), (GtkTreeViewColumn*)s7_c_pointer_with_type(sc, column, GtkTreeViewColumn__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_expand_all(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_expand_all "void gtk_tree_view_expand_all(GtkTreeView* tree_view)"
  s7_pointer tree_view;
  tree_view = s7_car(args);
  gtk_tree_view_expand_all((GtkTreeView*)s7_c_pointer_with_type(sc, tree_view, GtkTreeView__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_collapse_all(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_collapse_all "void gtk_tree_view_collapse_all(GtkTreeView* tree_view)"
  s7_pointer tree_view;
  tree_view = s7_car(args);
  gtk_tree_view_collapse_all((GtkTreeView*)s7_c_pointer_with_type(sc, tree_view, GtkTreeView__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_expand_row(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_expand_row "gboolean gtk_tree_view_expand_row(GtkTreeView* tree_view, GtkTreePath* path, \
gboolean open_all)"
  s7_pointer _p;
  s7_pointer tree_view, path, open_all;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  path = s7_car(_p); _p = s7_cdr(_p);
  open_all = s7_car(_p);
  if (!s7_is_boolean(open_all)) s7_wrong_type_arg_error(sc, "gtk_tree_view_expand_row", 3, open_all, "gboolean");
  return(s7_make_boolean(sc, gtk_tree_view_expand_row((GtkTreeView*)s7_c_pointer_with_type(sc, tree_view, GtkTreeView__sym, __func__, 0), (GtkTreePath*)s7_c_pointer_with_type(sc, path, GtkTreePath__sym, __func__, 0), (gboolean)lg_boolean(open_all))));
}

static s7_pointer lg_gtk_tree_view_collapse_row(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_collapse_row "gboolean gtk_tree_view_collapse_row(GtkTreeView* tree_view, GtkTreePath* path)"
  s7_pointer _p;
  s7_pointer tree_view, path;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  path = s7_car(_p);
  return(s7_make_boolean(sc, gtk_tree_view_collapse_row((GtkTreeView*)s7_c_pointer_with_type(sc, tree_view, GtkTreeView__sym, __func__, 0), (GtkTreePath*)s7_c_pointer_with_type(sc, path, GtkTreePath__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_view_map_expanded_rows(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_map_expanded_rows "void gtk_tree_view_map_expanded_rows(GtkTreeView* tree_view, \
GtkTreeViewMappingFunc func, lambda_data func_info)"
  s7_pointer _p;
  s7_pointer tree_view, func, func_info;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  func = s7_car(_p); _p = s7_cdr(_p);
  func_info = s7_car(_p);
  {
    int loc;
    s7_pointer lg_ptr = s7_list(sc, 5, func, func_info, lg_false, lg_false, lg_false);
    loc = s7_gc_protect(sc, lg_ptr);
    s7_list_set(sc, lg_ptr, 2, s7_make_integer(sc, loc));
    gtk_tree_view_map_expanded_rows((GtkTreeView*)s7_c_pointer_with_type(sc, tree_view, GtkTreeView__sym, __func__, 0), lg_tree_mapping, (gpointer)lg_ptr);
    return(lg_false);
   }
}

static s7_pointer lg_gtk_tree_view_row_expanded(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_row_expanded "gboolean gtk_tree_view_row_expanded(GtkTreeView* tree_view, GtkTreePath* path)"
  s7_pointer _p;
  s7_pointer tree_view, path;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  path = s7_car(_p);
  return(s7_make_boolean(sc, gtk_tree_view_row_expanded((GtkTreeView*)s7_c_pointer_with_type(sc, tree_view, GtkTreeView__sym, __func__, 0), (GtkTreePath*)s7_c_pointer_with_type(sc, path, GtkTreePath__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_view_set_reorderable(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_set_reorderable "void gtk_tree_view_set_reorderable(GtkTreeView* tree_view, \
gboolean reorderable)"
  s7_pointer _p;
  s7_pointer tree_view, reorderable;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  reorderable = s7_car(_p);
  if (!s7_is_boolean(reorderable)) s7_wrong_type_arg_error(sc, "gtk_tree_view_set_reorderable", 2, reorderable, "gboolean");
  gtk_tree_view_set_reorderable((GtkTreeView*)s7_c_pointer_with_type(sc, tree_view, GtkTreeView__sym, __func__, 0), (gboolean)lg_boolean(reorderable));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_get_reorderable(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_get_reorderable "gboolean gtk_tree_view_get_reorderable(GtkTreeView* tree_view)"
  s7_pointer tree_view;
  tree_view = s7_car(args);
  return(s7_make_boolean(sc, gtk_tree_view_get_reorderable((GtkTreeView*)s7_c_pointer_with_type(sc, tree_view, GtkTreeView__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_view_set_cursor(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_set_cursor "void gtk_tree_view_set_cursor(GtkTreeView* tree_view, GtkTreePath* path, \
GtkTreeViewColumn* focus_column, gboolean start_editing)"
  s7_pointer _p;
  s7_pointer tree_view, path, focus_column, start_editing;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  path = s7_car(_p); _p = s7_cdr(_p);
  focus_column = s7_car(_p); _p = s7_cdr(_p);
  start_editing = s7_car(_p);
  if (!s7_is_boolean(start_editing)) s7_wrong_type_arg_error(sc, "gtk_tree_view_set_cursor", 4, start_editing, "gboolean");
  gtk_tree_view_set_cursor((GtkTreeView*)s7_c_pointer_with_type(sc, tree_view, GtkTreeView__sym, __func__, 0), (GtkTreePath*)s7_c_pointer_with_type(sc, path, GtkTreePath__sym, __func__, 0), (GtkTreeViewColumn*)s7_c_pointer_with_type(sc, focus_column, GtkTreeViewColumn__sym, __func__, 0), (gboolean)lg_boolean(start_editing));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_get_cursor(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_get_cursor "void gtk_tree_view_get_cursor(GtkTreeView* tree_view, GtkTreePath** [path], \
GtkTreeViewColumn** [focus_column])"
  s7_pointer _p;
  s7_pointer tree_view;
  GtkTreePath* ref_path = NULL;
  GtkTreeViewColumn* ref_focus_column = NULL;
  _p = args;
  tree_view = s7_car(_p);
  gtk_tree_view_get_cursor((GtkTreeView*)s7_c_pointer_with_type(sc, tree_view, GtkTreeView__sym, __func__, 0), &ref_path, &ref_focus_column);
    return(s7_list(sc, 2, s7_make_c_pointer(sc, ref_path), s7_make_c_pointer(sc, ref_focus_column)));
}

static s7_pointer lg_gtk_tree_view_get_path_at_pos(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_get_path_at_pos "gboolean gtk_tree_view_get_path_at_pos(GtkTreeView* tree_view, \
gint x, gint y, GtkTreePath** [path], GtkTreeViewColumn** [column], gint* [cell_x], gint* [cell_y])"
  s7_pointer _p;
  s7_pointer tree_view, x, y;
  GtkTreePath* ref_path = NULL;
  GtkTreeViewColumn* ref_column = NULL;
  gint ref_cell_x;
  gint ref_cell_y;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  x = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(x)) s7_wrong_type_arg_error(sc, "gtk_tree_view_get_path_at_pos", 2, x, "gint");
  y = s7_car(_p);
  if (!s7_is_integer(y)) s7_wrong_type_arg_error(sc, "gtk_tree_view_get_path_at_pos", 3, y, "gint");
  {
    s7_pointer res_ult;
    res_ult = s7_make_boolean(sc, gtk_tree_view_get_path_at_pos((GtkTreeView*)s7_c_pointer_with_type(sc, tree_view, GtkTreeView__sym, __func__, 0), (gint)s7_integer(x), (gint)s7_integer(y), &ref_path, &ref_column, &ref_cell_x, &ref_cell_y));
      return(s7_list(sc, 5, res_ult, s7_make_c_pointer(sc, ref_path), s7_make_c_pointer(sc, ref_column), s7_make_integer(sc, ref_cell_x), s7_make_integer(sc, ref_cell_y)));
   }
}

static s7_pointer lg_gtk_tree_view_get_cell_area(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_get_cell_area "void gtk_tree_view_get_cell_area(GtkTreeView* tree_view, GtkTreePath* path, \
GtkTreeViewColumn* column, GdkRectangle* rect)"
  s7_pointer _p;
  s7_pointer tree_view, path, column, rect;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  path = s7_car(_p); _p = s7_cdr(_p);
  column = s7_car(_p); _p = s7_cdr(_p);
  rect = s7_car(_p);
  gtk_tree_view_get_cell_area((GtkTreeView*)s7_c_pointer_with_type(sc, tree_view, GtkTreeView__sym, __func__, 0), (GtkTreePath*)s7_c_pointer_with_type(sc, path, GtkTreePath__sym, __func__, 0), (GtkTreeViewColumn*)s7_c_pointer_with_type(sc, column, GtkTreeViewColumn__sym, __func__, 0), (GdkRectangle*)s7_c_pointer_with_type(sc, rect, GdkRectangle__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_get_background_area(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_get_background_area "void gtk_tree_view_get_background_area(GtkTreeView* tree_view, \
GtkTreePath* path, GtkTreeViewColumn* column, GdkRectangle* rect)"
  s7_pointer _p;
  s7_pointer tree_view, path, column, rect;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  path = s7_car(_p); _p = s7_cdr(_p);
  column = s7_car(_p); _p = s7_cdr(_p);
  rect = s7_car(_p);
  gtk_tree_view_get_background_area((GtkTreeView*)s7_c_pointer_with_type(sc, tree_view, GtkTreeView__sym, __func__, 0), (GtkTreePath*)s7_c_pointer_with_type(sc, path, GtkTreePath__sym, __func__, 0), (GtkTreeViewColumn*)s7_c_pointer_with_type(sc, column, GtkTreeViewColumn__sym, __func__, 0), (GdkRectangle*)s7_c_pointer_with_type(sc, rect, GdkRectangle__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_get_visible_rect(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_get_visible_rect "void gtk_tree_view_get_visible_rect(GtkTreeView* tree_view, \
GdkRectangle* visible_rect)"
  s7_pointer _p;
  s7_pointer tree_view, visible_rect;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  visible_rect = s7_car(_p);
  gtk_tree_view_get_visible_rect((GtkTreeView*)s7_c_pointer_with_type(sc, tree_view, GtkTreeView__sym, __func__, 0), (GdkRectangle*)s7_c_pointer_with_type(sc, visible_rect, GdkRectangle__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_unset_rows_drag_source(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_unset_rows_drag_source "void gtk_tree_view_unset_rows_drag_source(GtkTreeView* tree_view)"
  s7_pointer tree_view;
  tree_view = s7_car(args);
  gtk_tree_view_unset_rows_drag_source((GtkTreeView*)s7_c_pointer_with_type(sc, tree_view, GtkTreeView__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_get_dest_row_at_pos(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_get_dest_row_at_pos "gboolean gtk_tree_view_get_dest_row_at_pos(GtkTreeView* tree_view, \
gint drag_x, gint drag_y, GtkTreePath** [path], GtkTreeViewDropPosition* [pos])"
  s7_pointer _p;
  s7_pointer tree_view, drag_x, drag_y;
  GtkTreePath* ref_path = NULL;
  GtkTreeViewDropPosition ref_pos;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  drag_x = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(drag_x)) s7_wrong_type_arg_error(sc, "gtk_tree_view_get_dest_row_at_pos", 2, drag_x, "gint");
  drag_y = s7_car(_p);
  if (!s7_is_integer(drag_y)) s7_wrong_type_arg_error(sc, "gtk_tree_view_get_dest_row_at_pos", 3, drag_y, "gint");
  {
    s7_pointer res_ult;
    res_ult = s7_make_boolean(sc, gtk_tree_view_get_dest_row_at_pos((GtkTreeView*)s7_c_pointer_with_type(sc, tree_view, GtkTreeView__sym, __func__, 0), (gint)s7_integer(drag_x), (gint)s7_integer(drag_y), &ref_path, &ref_pos));
      return(s7_list(sc, 3, res_ult, s7_make_c_pointer(sc, ref_path), s7_make_integer(sc, ref_pos)));
   }
}

static s7_pointer lg_gtk_tree_view_set_enable_search(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_set_enable_search "void gtk_tree_view_set_enable_search(GtkTreeView* tree_view, \
gboolean enable_search)"
  s7_pointer _p;
  s7_pointer tree_view, enable_search;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  enable_search = s7_car(_p);
  if (!s7_is_boolean(enable_search)) s7_wrong_type_arg_error(sc, "gtk_tree_view_set_enable_search", 2, enable_search, "gboolean");
  gtk_tree_view_set_enable_search((GtkTreeView*)s7_c_pointer_with_type(sc, tree_view, GtkTreeView__sym, __func__, 0), (gboolean)lg_boolean(enable_search));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_get_enable_search(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_get_enable_search "gboolean gtk_tree_view_get_enable_search(GtkTreeView* tree_view)"
  s7_pointer tree_view;
  tree_view = s7_car(args);
  return(s7_make_boolean(sc, gtk_tree_view_get_enable_search((GtkTreeView*)s7_c_pointer_with_type(sc, tree_view, GtkTreeView__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_view_get_search_column(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_get_search_column "gint gtk_tree_view_get_search_column(GtkTreeView* tree_view)"
  s7_pointer tree_view;
  tree_view = s7_car(args);
  return(s7_make_integer(sc, gtk_tree_view_get_search_column((GtkTreeView*)s7_c_pointer_with_type(sc, tree_view, GtkTreeView__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_view_set_search_column(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_set_search_column "void gtk_tree_view_set_search_column(GtkTreeView* tree_view, \
gint column)"
  s7_pointer _p;
  s7_pointer tree_view, column;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  column = s7_car(_p);
  if (!s7_is_integer(column)) s7_wrong_type_arg_error(sc, "gtk_tree_view_set_search_column", 2, column, "gint");
  gtk_tree_view_set_search_column((GtkTreeView*)s7_c_pointer_with_type(sc, tree_view, GtkTreeView__sym, __func__, 0), (gint)s7_integer(column));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_get_search_equal_func(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_get_search_equal_func "GtkTreeViewSearchEqualFunc gtk_tree_view_get_search_equal_func(GtkTreeView* tree_view)"
  s7_pointer tree_view;
  tree_view = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GtkTreeViewSearchEqualFunc_sym, gtk_tree_view_get_search_equal_func((GtkTreeView*)s7_c_pointer_with_type(sc, tree_view, GtkTreeView__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_view_set_search_equal_func(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_set_search_equal_func "void gtk_tree_view_set_search_equal_func(GtkTreeView* tree_view, \
GtkTreeViewSearchEqualFunc func, lambda_data func_info, GtkDestroyNotify search_destroy)"
  s7_pointer _p;
  s7_pointer tree_view, func, func_info, search_destroy;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  func = s7_car(_p); _p = s7_cdr(_p);
  func_info = s7_car(_p); _p = s7_cdr(_p);
  search_destroy = s7_car(_p);
  {
    int loc;
    s7_pointer lg_ptr = s7_list(sc, 5, func, func_info, lg_false, lg_false, lg_false);
    loc = s7_gc_protect(sc, lg_ptr);
    s7_list_set(sc, lg_ptr, 2, s7_make_integer(sc, loc));
    s7_list_set(sc, lg_ptr, 3, search_destroy);
    gtk_tree_view_set_search_equal_func((GtkTreeView*)s7_c_pointer_with_type(sc, tree_view, GtkTreeView__sym, __func__, 0), lg_tree_search, (gpointer)lg_ptr, lg_destroy_func);
    return(lg_false);
   }
}

static s7_pointer lg_gtk_viewport_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_viewport_new "GtkWidget* gtk_viewport_new(GtkAdjustment* hadjustment, GtkAdjustment* vadjustment)"
  s7_pointer _p;
  s7_pointer hadjustment, vadjustment;
  _p = args;
  hadjustment = s7_car(_p); _p = s7_cdr(_p);
  vadjustment = s7_car(_p);
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_viewport_new((GtkAdjustment*)s7_c_pointer_with_type(sc, hadjustment, GtkAdjustment__sym, __func__, 0), (GtkAdjustment*)s7_c_pointer_with_type(sc, vadjustment, GtkAdjustment__sym, __func__, 0))));
}

static s7_pointer lg_gtk_widget_unparent(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_unparent "void gtk_widget_unparent(GtkWidget* widget)"
  s7_pointer widget;
  widget = s7_car(args);
  gtk_widget_unparent((GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_widget_show(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_show "void gtk_widget_show(GtkWidget* widget)"
  s7_pointer widget;
  widget = s7_car(args);
  gtk_widget_show((GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_widget_hide(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_hide "void gtk_widget_hide(GtkWidget* widget)"
  s7_pointer widget;
  widget = s7_car(args);
  gtk_widget_hide((GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_widget_map(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_map "void gtk_widget_map(GtkWidget* widget)"
  s7_pointer widget;
  widget = s7_car(args);
  gtk_widget_map((GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_widget_unmap(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_unmap "void gtk_widget_unmap(GtkWidget* widget)"
  s7_pointer widget;
  widget = s7_car(args);
  gtk_widget_unmap((GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_widget_realize(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_realize "void gtk_widget_realize(GtkWidget* widget)"
  s7_pointer widget;
  widget = s7_car(args);
  gtk_widget_realize((GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_widget_unrealize(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_unrealize "void gtk_widget_unrealize(GtkWidget* widget)"
  s7_pointer widget;
  widget = s7_car(args);
  gtk_widget_unrealize((GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_widget_queue_draw(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_queue_draw "void gtk_widget_queue_draw(GtkWidget* widget)"
  s7_pointer widget;
  widget = s7_car(args);
  gtk_widget_queue_draw((GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_widget_queue_resize(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_queue_resize "void gtk_widget_queue_resize(GtkWidget* widget)"
  s7_pointer widget;
  widget = s7_car(args);
  gtk_widget_queue_resize((GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_widget_mnemonic_activate(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_mnemonic_activate "gboolean gtk_widget_mnemonic_activate(GtkWidget* widget, gboolean group_cycling)"
  s7_pointer _p;
  s7_pointer widget, group_cycling;
  _p = args;
  widget = s7_car(_p); _p = s7_cdr(_p);
  group_cycling = s7_car(_p);
  if (!s7_is_boolean(group_cycling)) s7_wrong_type_arg_error(sc, "gtk_widget_mnemonic_activate", 2, group_cycling, "gboolean");
  return(s7_make_boolean(sc, gtk_widget_mnemonic_activate((GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0), (gboolean)lg_boolean(group_cycling))));
}

static s7_pointer lg_gtk_widget_activate(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_activate "gboolean gtk_widget_activate(GtkWidget* widget)"
  s7_pointer widget;
  widget = s7_car(args);
  return(s7_make_boolean(sc, gtk_widget_activate((GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0))));
}

static s7_pointer lg_gtk_widget_is_focus(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_is_focus "gboolean gtk_widget_is_focus(GtkWidget* widget)"
  s7_pointer widget;
  widget = s7_car(args);
  return(s7_make_boolean(sc, gtk_widget_is_focus((GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0))));
}

static s7_pointer lg_gtk_widget_set_name(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_set_name "void gtk_widget_set_name(GtkWidget* widget, gchar* name)"
  s7_pointer _p;
  s7_pointer widget, name;
  _p = args;
  widget = s7_car(_p); _p = s7_cdr(_p);
  name = s7_car(_p);
  if (!s7_is_string(name)) s7_wrong_type_arg_error(sc, "gtk_widget_set_name", 2, name, "gchar*");
  gtk_widget_set_name((GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0), (gchar*)s7_string(name));
  return(lg_false);
}

static s7_pointer lg_gtk_widget_get_name(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_get_name "gchar* gtk_widget_get_name(GtkWidget* widget)"
  s7_pointer widget;
  widget = s7_car(args);
  return(s7_make_string(sc, gtk_widget_get_name((GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0))));
}

static s7_pointer lg_gtk_widget_set_sensitive(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_set_sensitive "void gtk_widget_set_sensitive(GtkWidget* widget, gboolean sensitive)"
  s7_pointer _p;
  s7_pointer widget, sensitive;
  _p = args;
  widget = s7_car(_p); _p = s7_cdr(_p);
  sensitive = s7_car(_p);
  if (!s7_is_boolean(sensitive)) s7_wrong_type_arg_error(sc, "gtk_widget_set_sensitive", 2, sensitive, "gboolean");
  gtk_widget_set_sensitive((GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0), (gboolean)lg_boolean(sensitive));
  return(lg_false);
}

static s7_pointer lg_gtk_widget_set_parent(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_set_parent "void gtk_widget_set_parent(GtkWidget* widget, GtkWidget* parent)"
  s7_pointer _p;
  s7_pointer widget, parent;
  _p = args;
  widget = s7_car(_p); _p = s7_cdr(_p);
  parent = s7_car(_p);
  gtk_widget_set_parent((GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0), (GtkWidget*)s7_c_pointer_with_type(sc, parent, GtkWidget__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_widget_set_child_visible(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_set_child_visible "void gtk_widget_set_child_visible(GtkWidget* widget, gboolean is_visible)"
  s7_pointer _p;
  s7_pointer widget, is_visible;
  _p = args;
  widget = s7_car(_p); _p = s7_cdr(_p);
  is_visible = s7_car(_p);
  if (!s7_is_boolean(is_visible)) s7_wrong_type_arg_error(sc, "gtk_widget_set_child_visible", 2, is_visible, "gboolean");
  gtk_widget_set_child_visible((GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0), (gboolean)lg_boolean(is_visible));
  return(lg_false);
}

static s7_pointer lg_gtk_widget_get_child_visible(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_get_child_visible "gboolean gtk_widget_get_child_visible(GtkWidget* widget)"
  s7_pointer widget;
  widget = s7_car(args);
  return(s7_make_boolean(sc, gtk_widget_get_child_visible((GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0))));
}

static s7_pointer lg_gtk_widget_get_parent(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_get_parent "GtkWidget* gtk_widget_get_parent(GtkWidget* widget)"
  s7_pointer widget;
  widget = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_widget_get_parent((GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0))));
}

static s7_pointer lg_gtk_widget_child_focus(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_child_focus "gboolean gtk_widget_child_focus(GtkWidget* widget, GtkDirectionType direction)"
  s7_pointer _p;
  s7_pointer widget, direction;
  _p = args;
  widget = s7_car(_p); _p = s7_cdr(_p);
  direction = s7_car(_p);
  if (!s7_is_integer(direction)) s7_wrong_type_arg_error(sc, "gtk_widget_child_focus", 2, direction, "GtkDirectionType");
  return(s7_make_boolean(sc, gtk_widget_child_focus((GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0), (GtkDirectionType)s7_integer(direction))));
}

static s7_pointer lg_gtk_widget_set_size_request(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_set_size_request "void gtk_widget_set_size_request(GtkWidget* widget, gint width, \
gint height)"
  s7_pointer _p;
  s7_pointer widget, width, height;
  _p = args;
  widget = s7_car(_p); _p = s7_cdr(_p);
  width = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(width)) s7_wrong_type_arg_error(sc, "gtk_widget_set_size_request", 2, width, "gint");
  height = s7_car(_p);
  if (!s7_is_integer(height)) s7_wrong_type_arg_error(sc, "gtk_widget_set_size_request", 3, height, "gint");
  gtk_widget_set_size_request((GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0), (gint)s7_integer(width), (gint)s7_integer(height));
  return(lg_false);
}

static s7_pointer lg_gtk_widget_get_size_request(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_get_size_request "void gtk_widget_get_size_request(GtkWidget* widget, gint* [width], \
gint* [height])"
  s7_pointer _p;
  s7_pointer widget;
  gint ref_width;
  gint ref_height;
  _p = args;
  widget = s7_car(_p);
  gtk_widget_get_size_request((GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0), &ref_width, &ref_height);
    return(s7_list(sc, 2, s7_make_integer(sc, ref_width), s7_make_integer(sc, ref_height)));
}

static s7_pointer lg_gtk_widget_get_ancestor(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_get_ancestor "GtkWidget* gtk_widget_get_ancestor(GtkWidget* widget, GType widget_type)"
  s7_pointer _p;
  s7_pointer widget, widget_type;
  _p = args;
  widget = s7_car(_p); _p = s7_cdr(_p);
  widget_type = s7_car(_p);
  if (!s7_is_integer(widget_type)) s7_wrong_type_arg_error(sc, "gtk_widget_get_ancestor", 2, widget_type, "GType");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_widget_get_ancestor((GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0), (GType)s7_integer(widget_type))));
}

static s7_pointer lg_gtk_widget_get_settings(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_get_settings "GtkSettings* gtk_widget_get_settings(GtkWidget* widget)"
  s7_pointer widget;
  widget = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GtkSettings__sym, gtk_widget_get_settings((GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0))));
}

static s7_pointer lg_gtk_widget_get_accessible(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_get_accessible "AtkObject* gtk_widget_get_accessible(GtkWidget* widget)"
  s7_pointer widget;
  widget = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, AtkObject__sym, gtk_widget_get_accessible((GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0))));
}

static s7_pointer lg_gtk_widget_is_ancestor(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_is_ancestor "gboolean gtk_widget_is_ancestor(GtkWidget* widget, GtkWidget* ancestor)"
  s7_pointer _p;
  s7_pointer widget, ancestor;
  _p = args;
  widget = s7_car(_p); _p = s7_cdr(_p);
  ancestor = s7_car(_p);
  return(s7_make_boolean(sc, gtk_widget_is_ancestor((GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0), (GtkWidget*)s7_c_pointer_with_type(sc, ancestor, GtkWidget__sym, __func__, 0))));
}

static s7_pointer lg_gtk_widget_create_pango_context(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_create_pango_context "PangoContext* gtk_widget_create_pango_context(GtkWidget* widget)"
  s7_pointer widget;
  widget = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, PangoContext__sym, gtk_widget_create_pango_context((GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0))));
}

static s7_pointer lg_gtk_widget_get_pango_context(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_get_pango_context "PangoContext* gtk_widget_get_pango_context(GtkWidget* widget)"
  s7_pointer widget;
  widget = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, PangoContext__sym, gtk_widget_get_pango_context((GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0))));
}

static s7_pointer lg_gtk_widget_create_pango_layout(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_create_pango_layout "PangoLayout* gtk_widget_create_pango_layout(GtkWidget* widget, \
gchar* text)"
  s7_pointer _p;
  s7_pointer widget, text;
  _p = args;
  widget = s7_car(_p); _p = s7_cdr(_p);
  text = s7_car(_p);
  if (!s7_is_string(text)) s7_wrong_type_arg_error(sc, "gtk_widget_create_pango_layout", 2, text, "gchar*");
  return(lg_make_c_pointer_with_type(sc, PangoLayout__sym, gtk_widget_create_pango_layout((GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0), (gchar*)s7_string(text))));
}

static s7_pointer lg_gtk_widget_set_direction(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_set_direction "void gtk_widget_set_direction(GtkWidget* widget, GtkTextDirection dir)"
  s7_pointer _p;
  s7_pointer widget, dir;
  _p = args;
  widget = s7_car(_p); _p = s7_cdr(_p);
  dir = s7_car(_p);
  if (!s7_is_integer(dir)) s7_wrong_type_arg_error(sc, "gtk_widget_set_direction", 2, dir, "GtkTextDirection");
  gtk_widget_set_direction((GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0), (GtkTextDirection)s7_integer(dir));
  return(lg_false);
}

static s7_pointer lg_gtk_widget_get_direction(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_get_direction "GtkTextDirection gtk_widget_get_direction(GtkWidget* widget)"
  s7_pointer widget;
  widget = s7_car(args);
  return(s7_make_integer(sc, gtk_widget_get_direction((GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0))));
}

static s7_pointer lg_gtk_widget_set_default_direction(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_set_default_direction "void gtk_widget_set_default_direction(GtkTextDirection dir)"
  s7_pointer dir;
  dir = s7_car(args);
  if (!s7_is_integer(dir)) s7_wrong_type_arg_error(sc, "gtk_widget_set_default_direction", 1, dir, "GtkTextDirection");
  gtk_widget_set_default_direction((GtkTextDirection)s7_integer(dir));
  return(lg_false);
}

static s7_pointer lg_gtk_widget_get_default_direction(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_get_default_direction "GtkTextDirection gtk_widget_get_default_direction( void)"
  return(s7_make_integer(sc, gtk_widget_get_default_direction()));
}

static s7_pointer lg_gtk_window_is_active(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_window_is_active "gboolean gtk_window_is_active(GtkWindow* window)"
  s7_pointer window;
  window = s7_car(args);
  return(s7_make_boolean(sc, gtk_window_is_active((GtkWindow*)s7_c_pointer_with_type(sc, window, GtkWindow__sym, __func__, 0))));
}

static s7_pointer lg_gtk_window_set_title(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_window_set_title "void gtk_window_set_title(GtkWindow* window, gchar* title)"
  s7_pointer _p;
  s7_pointer window, title;
  _p = args;
  window = s7_car(_p); _p = s7_cdr(_p);
  title = s7_car(_p);
  if (!s7_is_string(title)) s7_wrong_type_arg_error(sc, "gtk_window_set_title", 2, title, "gchar*");
  gtk_window_set_title((GtkWindow*)s7_c_pointer_with_type(sc, window, GtkWindow__sym, __func__, 0), (gchar*)s7_string(title));
  return(lg_false);
}

static s7_pointer lg_gtk_window_set_auto_startup_notification(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_window_set_auto_startup_notification "void gtk_window_set_auto_startup_notification(gboolean setting)"
  s7_pointer setting;
  setting = s7_car(args);
  if (!s7_is_boolean(setting)) s7_wrong_type_arg_error(sc, "gtk_window_set_auto_startup_notification", 1, setting, "gboolean");
  gtk_window_set_auto_startup_notification((gboolean)lg_boolean(setting));
  return(lg_false);
}

static s7_pointer lg_gtk_window_get_title(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_window_get_title "gchar* gtk_window_get_title(GtkWindow* window)"
  s7_pointer window;
  window = s7_car(args);
  return(s7_make_string(sc, gtk_window_get_title((GtkWindow*)s7_c_pointer_with_type(sc, window, GtkWindow__sym, __func__, 0))));
}

static s7_pointer lg_gtk_window_set_focus(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_window_set_focus "void gtk_window_set_focus(GtkWindow* window, GtkWidget* focus)"
  s7_pointer _p;
  s7_pointer window, focus;
  _p = args;
  window = s7_car(_p); _p = s7_cdr(_p);
  focus = s7_car(_p);
  gtk_window_set_focus((GtkWindow*)s7_c_pointer_with_type(sc, window, GtkWindow__sym, __func__, 0), (GtkWidget*)s7_c_pointer_with_type(sc, focus, GtkWidget__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_window_get_focus(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_window_get_focus "GtkWidget* gtk_window_get_focus(GtkWindow* window)"
  s7_pointer window;
  window = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_window_get_focus((GtkWindow*)s7_c_pointer_with_type(sc, window, GtkWindow__sym, __func__, 0))));
}

static s7_pointer lg_gtk_window_set_transient_for(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_window_set_transient_for "void gtk_window_set_transient_for(GtkWindow* window, GtkWindow* parent)"
  s7_pointer _p;
  s7_pointer window, parent;
  _p = args;
  window = s7_car(_p); _p = s7_cdr(_p);
  parent = s7_car(_p);
  gtk_window_set_transient_for((GtkWindow*)s7_c_pointer_with_type(sc, window, GtkWindow__sym, __func__, 0), (GtkWindow*)s7_c_pointer_with_type(sc, parent, GtkWindow__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_window_get_transient_for(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_window_get_transient_for "GtkWindow* gtk_window_get_transient_for(GtkWindow* window)"
  s7_pointer window;
  window = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GtkWindow__sym, gtk_window_get_transient_for((GtkWindow*)s7_c_pointer_with_type(sc, window, GtkWindow__sym, __func__, 0))));
}

static s7_pointer lg_gtk_window_set_destroy_with_parent(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_window_set_destroy_with_parent "void gtk_window_set_destroy_with_parent(GtkWindow* window, \
gboolean setting)"
  s7_pointer _p;
  s7_pointer window, setting;
  _p = args;
  window = s7_car(_p); _p = s7_cdr(_p);
  setting = s7_car(_p);
  if (!s7_is_boolean(setting)) s7_wrong_type_arg_error(sc, "gtk_window_set_destroy_with_parent", 2, setting, "gboolean");
  gtk_window_set_destroy_with_parent((GtkWindow*)s7_c_pointer_with_type(sc, window, GtkWindow__sym, __func__, 0), (gboolean)lg_boolean(setting));
  return(lg_false);
}

static s7_pointer lg_gtk_window_get_destroy_with_parent(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_window_get_destroy_with_parent "gboolean gtk_window_get_destroy_with_parent(GtkWindow* window)"
  s7_pointer window;
  window = s7_car(args);
  return(s7_make_boolean(sc, gtk_window_get_destroy_with_parent((GtkWindow*)s7_c_pointer_with_type(sc, window, GtkWindow__sym, __func__, 0))));
}

static s7_pointer lg_gtk_window_set_resizable(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_window_set_resizable "void gtk_window_set_resizable(GtkWindow* window, gboolean resizable)"
  s7_pointer _p;
  s7_pointer window, resizable;
  _p = args;
  window = s7_car(_p); _p = s7_cdr(_p);
  resizable = s7_car(_p);
  if (!s7_is_boolean(resizable)) s7_wrong_type_arg_error(sc, "gtk_window_set_resizable", 2, resizable, "gboolean");
  gtk_window_set_resizable((GtkWindow*)s7_c_pointer_with_type(sc, window, GtkWindow__sym, __func__, 0), (gboolean)lg_boolean(resizable));
  return(lg_false);
}

static s7_pointer lg_gtk_window_get_resizable(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_window_get_resizable "gboolean gtk_window_get_resizable(GtkWindow* window)"
  s7_pointer window;
  window = s7_car(args);
  return(s7_make_boolean(sc, gtk_window_get_resizable((GtkWindow*)s7_c_pointer_with_type(sc, window, GtkWindow__sym, __func__, 0))));
}

static s7_pointer lg_gtk_window_set_decorated(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_window_set_decorated "void gtk_window_set_decorated(GtkWindow* window, gboolean setting)"
  s7_pointer _p;
  s7_pointer window, setting;
  _p = args;
  window = s7_car(_p); _p = s7_cdr(_p);
  setting = s7_car(_p);
  if (!s7_is_boolean(setting)) s7_wrong_type_arg_error(sc, "gtk_window_set_decorated", 2, setting, "gboolean");
  gtk_window_set_decorated((GtkWindow*)s7_c_pointer_with_type(sc, window, GtkWindow__sym, __func__, 0), (gboolean)lg_boolean(setting));
  return(lg_false);
}

static s7_pointer lg_gtk_window_get_decorated(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_window_get_decorated "gboolean gtk_window_get_decorated(GtkWindow* window)"
  s7_pointer window;
  window = s7_car(args);
  return(s7_make_boolean(sc, gtk_window_get_decorated((GtkWindow*)s7_c_pointer_with_type(sc, window, GtkWindow__sym, __func__, 0))));
}

static s7_pointer lg_gtk_window_set_modal(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_window_set_modal "void gtk_window_set_modal(GtkWindow* window, gboolean modal)"
  s7_pointer _p;
  s7_pointer window, modal;
  _p = args;
  window = s7_car(_p); _p = s7_cdr(_p);
  modal = s7_car(_p);
  if (!s7_is_boolean(modal)) s7_wrong_type_arg_error(sc, "gtk_window_set_modal", 2, modal, "gboolean");
  gtk_window_set_modal((GtkWindow*)s7_c_pointer_with_type(sc, window, GtkWindow__sym, __func__, 0), (gboolean)lg_boolean(modal));
  return(lg_false);
}

static s7_pointer lg_gtk_window_get_modal(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_window_get_modal "gboolean gtk_window_get_modal(GtkWindow* window)"
  s7_pointer window;
  window = s7_car(args);
  return(s7_make_boolean(sc, gtk_window_get_modal((GtkWindow*)s7_c_pointer_with_type(sc, window, GtkWindow__sym, __func__, 0))));
}

static s7_pointer lg_gtk_window_list_toplevels(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_window_list_toplevels "GList* gtk_window_list_toplevels( void)"
  return(lg_make_c_pointer_with_type(sc, GList__sym, gtk_window_list_toplevels()));
}

static s7_pointer lg_gtk_window_present(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_window_present "void gtk_window_present(GtkWindow* window)"
  s7_pointer window;
  window = s7_car(args);
  gtk_window_present((GtkWindow*)s7_c_pointer_with_type(sc, window, GtkWindow__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_window_maximize(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_window_maximize "void gtk_window_maximize(GtkWindow* window)"
  s7_pointer window;
  window = s7_car(args);
  gtk_window_maximize((GtkWindow*)s7_c_pointer_with_type(sc, window, GtkWindow__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_window_unmaximize(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_window_unmaximize "void gtk_window_unmaximize(GtkWindow* window)"
  s7_pointer window;
  window = s7_car(args);
  gtk_window_unmaximize((GtkWindow*)s7_c_pointer_with_type(sc, window, GtkWindow__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_window_set_default_size(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_window_set_default_size "void gtk_window_set_default_size(GtkWindow* window, gint width, \
gint height)"
  s7_pointer _p;
  s7_pointer window, width, height;
  _p = args;
  window = s7_car(_p); _p = s7_cdr(_p);
  width = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(width)) s7_wrong_type_arg_error(sc, "gtk_window_set_default_size", 2, width, "gint");
  height = s7_car(_p);
  if (!s7_is_integer(height)) s7_wrong_type_arg_error(sc, "gtk_window_set_default_size", 3, height, "gint");
  gtk_window_set_default_size((GtkWindow*)s7_c_pointer_with_type(sc, window, GtkWindow__sym, __func__, 0), (gint)s7_integer(width), (gint)s7_integer(height));
  return(lg_false);
}

static s7_pointer lg_gtk_window_get_default_size(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_window_get_default_size "void gtk_window_get_default_size(GtkWindow* window, gint* [width], \
gint* [height])"
  s7_pointer _p;
  s7_pointer window;
  gint ref_width;
  gint ref_height;
  _p = args;
  window = s7_car(_p);
  gtk_window_get_default_size((GtkWindow*)s7_c_pointer_with_type(sc, window, GtkWindow__sym, __func__, 0), &ref_width, &ref_height);
    return(s7_list(sc, 2, s7_make_integer(sc, ref_width), s7_make_integer(sc, ref_height)));
}

static s7_pointer lg_gtk_window_resize(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_window_resize "void gtk_window_resize(GtkWindow* window, gint width, gint height)"
  s7_pointer _p;
  s7_pointer window, width, height;
  _p = args;
  window = s7_car(_p); _p = s7_cdr(_p);
  width = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(width)) s7_wrong_type_arg_error(sc, "gtk_window_resize", 2, width, "gint");
  height = s7_car(_p);
  if (!s7_is_integer(height)) s7_wrong_type_arg_error(sc, "gtk_window_resize", 3, height, "gint");
  gtk_window_resize((GtkWindow*)s7_c_pointer_with_type(sc, window, GtkWindow__sym, __func__, 0), (gint)s7_integer(width), (gint)s7_integer(height));
  return(lg_false);
}

static s7_pointer lg_gtk_window_get_size(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_window_get_size "void gtk_window_get_size(GtkWindow* window, gint* [width], gint* [height])"
  s7_pointer _p;
  s7_pointer window;
  gint ref_width;
  gint ref_height;
  _p = args;
  window = s7_car(_p);
  gtk_window_get_size((GtkWindow*)s7_c_pointer_with_type(sc, window, GtkWindow__sym, __func__, 0), &ref_width, &ref_height);
    return(s7_list(sc, 2, s7_make_integer(sc, ref_width), s7_make_integer(sc, ref_height)));
}

static s7_pointer lg_pango_color_copy(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_color_copy "PangoColor* pango_color_copy(PangoColor* src)"
  s7_pointer src;
  src = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, PangoColor__sym, pango_color_copy((PangoColor*)s7_c_pointer_with_type(sc, src, PangoColor__sym, __func__, 0))));
}

static s7_pointer lg_pango_color_free(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_color_free "void pango_color_free(PangoColor* color)"
  s7_pointer color;
  color = s7_car(args);
  pango_color_free((PangoColor*)s7_c_pointer_with_type(sc, color, PangoColor__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_pango_color_parse(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_color_parse "gboolean pango_color_parse(PangoColor* color, char* spec)"
  s7_pointer _p;
  s7_pointer color, spec;
  _p = args;
  color = s7_car(_p); _p = s7_cdr(_p);
  spec = s7_car(_p);
  if (!s7_is_string(spec)) s7_wrong_type_arg_error(sc, "pango_color_parse", 2, spec, "char*");
  return(s7_make_boolean(sc, pango_color_parse((PangoColor*)s7_c_pointer_with_type(sc, color, PangoColor__sym, __func__, 0), (char*)s7_string(spec))));
}

static s7_pointer lg_pango_attr_type_register(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_attr_type_register "PangoAttrType pango_attr_type_register(gchar* name)"
  s7_pointer name;
  name = s7_car(args);
  if (!s7_is_string(name)) s7_wrong_type_arg_error(sc, "pango_attr_type_register", 1, name, "gchar*");
  return(s7_make_integer(sc, pango_attr_type_register((gchar*)s7_string(name))));
}

static s7_pointer lg_pango_attribute_copy(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_attribute_copy "PangoAttribute* pango_attribute_copy(PangoAttribute* attr)"
  s7_pointer attr;
  attr = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, PangoAttribute__sym, pango_attribute_copy((PangoAttribute*)s7_c_pointer_with_type(sc, attr, PangoAttribute__sym, __func__, 0))));
}

static s7_pointer lg_pango_attribute_destroy(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_attribute_destroy "void pango_attribute_destroy(PangoAttribute* attr)"
  s7_pointer attr;
  attr = s7_car(args);
  pango_attribute_destroy((PangoAttribute*)s7_c_pointer_with_type(sc, attr, PangoAttribute__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_pango_attribute_equal(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_attribute_equal "gboolean pango_attribute_equal(PangoAttribute* attr1, PangoAttribute* attr2)"
  s7_pointer _p;
  s7_pointer attr1, attr2;
  _p = args;
  attr1 = s7_car(_p); _p = s7_cdr(_p);
  attr2 = s7_car(_p);
  return(s7_make_boolean(sc, pango_attribute_equal((PangoAttribute*)s7_c_pointer_with_type(sc, attr1, PangoAttribute__sym, __func__, 0), (PangoAttribute*)s7_c_pointer_with_type(sc, attr2, PangoAttribute__sym, __func__, 0))));
}

static s7_pointer lg_pango_attr_language_new(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_attr_language_new "PangoAttribute* pango_attr_language_new(PangoLanguage* language)"
  s7_pointer language;
  language = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, PangoAttribute__sym, pango_attr_language_new((PangoLanguage*)s7_c_pointer_with_type(sc, language, PangoLanguage__sym, __func__, 0))));
}

static s7_pointer lg_pango_attr_family_new(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_attr_family_new "PangoAttribute* pango_attr_family_new(char* family)"
  s7_pointer family;
  family = s7_car(args);
  if (!s7_is_string(family)) s7_wrong_type_arg_error(sc, "pango_attr_family_new", 1, family, "char*");
  return(lg_make_c_pointer_with_type(sc, PangoAttribute__sym, pango_attr_family_new((char*)s7_string(family))));
}

static s7_pointer lg_pango_attr_foreground_new(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_attr_foreground_new "PangoAttribute* pango_attr_foreground_new(guint16 red, guint16 green, \
guint16 blue)"
  s7_pointer _p;
  s7_pointer red, green, blue;
  _p = args;
  red = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(red)) s7_wrong_type_arg_error(sc, "pango_attr_foreground_new", 1, red, "guint16");
  green = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(green)) s7_wrong_type_arg_error(sc, "pango_attr_foreground_new", 2, green, "guint16");
  blue = s7_car(_p);
  if (!s7_is_integer(blue)) s7_wrong_type_arg_error(sc, "pango_attr_foreground_new", 3, blue, "guint16");
  return(lg_make_c_pointer_with_type(sc, PangoAttribute__sym, pango_attr_foreground_new((guint16)s7_integer(red), (guint16)s7_integer(green), (guint16)s7_integer(blue))));
}

static s7_pointer lg_pango_attr_background_new(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_attr_background_new "PangoAttribute* pango_attr_background_new(guint16 red, guint16 green, \
guint16 blue)"
  s7_pointer _p;
  s7_pointer red, green, blue;
  _p = args;
  red = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(red)) s7_wrong_type_arg_error(sc, "pango_attr_background_new", 1, red, "guint16");
  green = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(green)) s7_wrong_type_arg_error(sc, "pango_attr_background_new", 2, green, "guint16");
  blue = s7_car(_p);
  if (!s7_is_integer(blue)) s7_wrong_type_arg_error(sc, "pango_attr_background_new", 3, blue, "guint16");
  return(lg_make_c_pointer_with_type(sc, PangoAttribute__sym, pango_attr_background_new((guint16)s7_integer(red), (guint16)s7_integer(green), (guint16)s7_integer(blue))));
}

static s7_pointer lg_pango_attr_size_new(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_attr_size_new "PangoAttribute* pango_attr_size_new(int size)"
  s7_pointer size;
  size = s7_car(args);
  if (!s7_is_integer(size)) s7_wrong_type_arg_error(sc, "pango_attr_size_new", 1, size, "int");
  return(lg_make_c_pointer_with_type(sc, PangoAttribute__sym, pango_attr_size_new((int)s7_integer(size))));
}

static s7_pointer lg_pango_attr_style_new(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_attr_style_new "PangoAttribute* pango_attr_style_new(PangoStyle style)"
  s7_pointer style;
  style = s7_car(args);
  if (!s7_is_integer(style)) s7_wrong_type_arg_error(sc, "pango_attr_style_new", 1, style, "PangoStyle");
  return(lg_make_c_pointer_with_type(sc, PangoAttribute__sym, pango_attr_style_new((PangoStyle)s7_integer(style))));
}

static s7_pointer lg_pango_attr_weight_new(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_attr_weight_new "PangoAttribute* pango_attr_weight_new(PangoWeight weight)"
  s7_pointer weight;
  weight = s7_car(args);
  if (!s7_is_integer(weight)) s7_wrong_type_arg_error(sc, "pango_attr_weight_new", 1, weight, "PangoWeight");
  return(lg_make_c_pointer_with_type(sc, PangoAttribute__sym, pango_attr_weight_new((PangoWeight)s7_integer(weight))));
}

static s7_pointer lg_pango_attr_variant_new(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_attr_variant_new "PangoAttribute* pango_attr_variant_new(PangoVariant variant)"
  s7_pointer variant;
  variant = s7_car(args);
  if (!s7_is_integer(variant)) s7_wrong_type_arg_error(sc, "pango_attr_variant_new", 1, variant, "PangoVariant");
  return(lg_make_c_pointer_with_type(sc, PangoAttribute__sym, pango_attr_variant_new((PangoVariant)s7_integer(variant))));
}

static s7_pointer lg_pango_attr_stretch_new(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_attr_stretch_new "PangoAttribute* pango_attr_stretch_new(PangoStretch stretch)"
  s7_pointer stretch;
  stretch = s7_car(args);
  if (!s7_is_integer(stretch)) s7_wrong_type_arg_error(sc, "pango_attr_stretch_new", 1, stretch, "PangoStretch");
  return(lg_make_c_pointer_with_type(sc, PangoAttribute__sym, pango_attr_stretch_new((PangoStretch)s7_integer(stretch))));
}

static s7_pointer lg_pango_attr_font_desc_new(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_attr_font_desc_new "PangoAttribute* pango_attr_font_desc_new(PangoFontDescription* desc)"
  s7_pointer desc;
  desc = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, PangoAttribute__sym, pango_attr_font_desc_new((PangoFontDescription*)s7_c_pointer_with_type(sc, desc, PangoFontDescription__sym, __func__, 0))));
}

static s7_pointer lg_pango_attr_underline_new(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_attr_underline_new "PangoAttribute* pango_attr_underline_new(PangoUnderline underline)"
  s7_pointer underline;
  underline = s7_car(args);
  if (!s7_is_integer(underline)) s7_wrong_type_arg_error(sc, "pango_attr_underline_new", 1, underline, "PangoUnderline");
  return(lg_make_c_pointer_with_type(sc, PangoAttribute__sym, pango_attr_underline_new((PangoUnderline)s7_integer(underline))));
}

static s7_pointer lg_pango_attr_strikethrough_new(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_attr_strikethrough_new "PangoAttribute* pango_attr_strikethrough_new(gboolean strikethrough)"
  s7_pointer strikethrough;
  strikethrough = s7_car(args);
  if (!s7_is_boolean(strikethrough)) s7_wrong_type_arg_error(sc, "pango_attr_strikethrough_new", 1, strikethrough, "gboolean");
  return(lg_make_c_pointer_with_type(sc, PangoAttribute__sym, pango_attr_strikethrough_new((gboolean)lg_boolean(strikethrough))));
}

static s7_pointer lg_pango_attr_rise_new(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_attr_rise_new "PangoAttribute* pango_attr_rise_new(int rise)"
  s7_pointer rise;
  rise = s7_car(args);
  if (!s7_is_integer(rise)) s7_wrong_type_arg_error(sc, "pango_attr_rise_new", 1, rise, "int");
  return(lg_make_c_pointer_with_type(sc, PangoAttribute__sym, pango_attr_rise_new((int)s7_integer(rise))));
}

static s7_pointer lg_pango_attr_shape_new(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_attr_shape_new "PangoAttribute* pango_attr_shape_new(PangoRectangle* ink_rect, PangoRectangle* logical_rect)"
  s7_pointer _p;
  s7_pointer ink_rect, logical_rect;
  _p = args;
  ink_rect = s7_car(_p); _p = s7_cdr(_p);
  logical_rect = s7_car(_p);
  return(lg_make_c_pointer_with_type(sc, PangoAttribute__sym, pango_attr_shape_new((PangoRectangle*)s7_c_pointer_with_type(sc, ink_rect, PangoRectangle__sym, __func__, 0), (PangoRectangle*)s7_c_pointer_with_type(sc, logical_rect, PangoRectangle__sym, __func__, 0))));
}

static s7_pointer lg_pango_attr_scale_new(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_attr_scale_new "PangoAttribute* pango_attr_scale_new(double scale_factor)"
  s7_pointer scale_factor;
  scale_factor = s7_car(args);
  if (!s7_is_real(scale_factor)) s7_wrong_type_arg_error(sc, "pango_attr_scale_new", 1, scale_factor, "double");
  return(lg_make_c_pointer_with_type(sc, PangoAttribute__sym, pango_attr_scale_new((double)s7_real(scale_factor))));
}

static s7_pointer lg_pango_attr_list_new(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_attr_list_new "PangoAttrList* pango_attr_list_new( void)"
  return(lg_make_c_pointer_with_type(sc, PangoAttrList__sym, pango_attr_list_new()));
}

static s7_pointer lg_pango_attr_list_unref(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_attr_list_unref "void pango_attr_list_unref(PangoAttrList* list)"
  s7_pointer list;
  list = s7_car(args);
  pango_attr_list_unref((PangoAttrList*)s7_c_pointer_with_type(sc, list, PangoAttrList__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_pango_attr_list_copy(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_attr_list_copy "PangoAttrList* pango_attr_list_copy(PangoAttrList* list)"
  s7_pointer list;
  list = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, PangoAttrList__sym, pango_attr_list_copy((PangoAttrList*)s7_c_pointer_with_type(sc, list, PangoAttrList__sym, __func__, 0))));
}

static s7_pointer lg_pango_attr_list_insert(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_attr_list_insert "void pango_attr_list_insert(PangoAttrList* list, PangoAttribute* attr)"
  s7_pointer _p;
  s7_pointer list, attr;
  _p = args;
  list = s7_car(_p); _p = s7_cdr(_p);
  attr = s7_car(_p);
  pango_attr_list_insert((PangoAttrList*)s7_c_pointer_with_type(sc, list, PangoAttrList__sym, __func__, 0), (PangoAttribute*)s7_c_pointer_with_type(sc, attr, PangoAttribute__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_pango_attr_list_insert_before(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_attr_list_insert_before "void pango_attr_list_insert_before(PangoAttrList* list, PangoAttribute* attr)"
  s7_pointer _p;
  s7_pointer list, attr;
  _p = args;
  list = s7_car(_p); _p = s7_cdr(_p);
  attr = s7_car(_p);
  pango_attr_list_insert_before((PangoAttrList*)s7_c_pointer_with_type(sc, list, PangoAttrList__sym, __func__, 0), (PangoAttribute*)s7_c_pointer_with_type(sc, attr, PangoAttribute__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_pango_attr_list_change(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_attr_list_change "void pango_attr_list_change(PangoAttrList* list, PangoAttribute* attr)"
  s7_pointer _p;
  s7_pointer list, attr;
  _p = args;
  list = s7_car(_p); _p = s7_cdr(_p);
  attr = s7_car(_p);
  pango_attr_list_change((PangoAttrList*)s7_c_pointer_with_type(sc, list, PangoAttrList__sym, __func__, 0), (PangoAttribute*)s7_c_pointer_with_type(sc, attr, PangoAttribute__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_pango_attr_list_splice(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_attr_list_splice "void pango_attr_list_splice(PangoAttrList* list, PangoAttrList* other, \
gint pos, gint len)"
  s7_pointer _p;
  s7_pointer list, other, pos, len;
  _p = args;
  list = s7_car(_p); _p = s7_cdr(_p);
  other = s7_car(_p); _p = s7_cdr(_p);
  pos = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(pos)) s7_wrong_type_arg_error(sc, "pango_attr_list_splice", 3, pos, "gint");
  len = s7_car(_p);
  if (!s7_is_integer(len)) s7_wrong_type_arg_error(sc, "pango_attr_list_splice", 4, len, "gint");
  pango_attr_list_splice((PangoAttrList*)s7_c_pointer_with_type(sc, list, PangoAttrList__sym, __func__, 0), (PangoAttrList*)s7_c_pointer_with_type(sc, other, PangoAttrList__sym, __func__, 0), (gint)s7_integer(pos), (gint)s7_integer(len));
  return(lg_false);
}

static s7_pointer lg_pango_attr_list_get_iterator(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_attr_list_get_iterator "PangoAttrIterator* pango_attr_list_get_iterator(PangoAttrList* list)"
  s7_pointer list;
  list = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, PangoAttrIterator__sym, pango_attr_list_get_iterator((PangoAttrList*)s7_c_pointer_with_type(sc, list, PangoAttrList__sym, __func__, 0))));
}

static s7_pointer lg_pango_attr_iterator_range(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_attr_iterator_range "void pango_attr_iterator_range(PangoAttrIterator* iterator, gint* [start], \
gint* [end])"
  s7_pointer _p;
  s7_pointer iterator;
  gint ref_start;
  gint ref_end;
  _p = args;
  iterator = s7_car(_p);
  pango_attr_iterator_range((PangoAttrIterator*)s7_c_pointer_with_type(sc, iterator, PangoAttrIterator__sym, __func__, 0), &ref_start, &ref_end);
    return(s7_list(sc, 2, s7_make_integer(sc, ref_start), s7_make_integer(sc, ref_end)));
}

static s7_pointer lg_pango_attr_iterator_next(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_attr_iterator_next "gboolean pango_attr_iterator_next(PangoAttrIterator* iterator)"
  s7_pointer iterator;
  iterator = s7_car(args);
  return(s7_make_boolean(sc, pango_attr_iterator_next((PangoAttrIterator*)s7_c_pointer_with_type(sc, iterator, PangoAttrIterator__sym, __func__, 0))));
}

static s7_pointer lg_pango_attr_iterator_copy(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_attr_iterator_copy "PangoAttrIterator* pango_attr_iterator_copy(PangoAttrIterator* iterator)"
  s7_pointer iterator;
  iterator = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, PangoAttrIterator__sym, pango_attr_iterator_copy((PangoAttrIterator*)s7_c_pointer_with_type(sc, iterator, PangoAttrIterator__sym, __func__, 0))));
}

static s7_pointer lg_pango_attr_iterator_destroy(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_attr_iterator_destroy "void pango_attr_iterator_destroy(PangoAttrIterator* iterator)"
  s7_pointer iterator;
  iterator = s7_car(args);
  pango_attr_iterator_destroy((PangoAttrIterator*)s7_c_pointer_with_type(sc, iterator, PangoAttrIterator__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_pango_attr_iterator_get(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_attr_iterator_get "PangoAttribute* pango_attr_iterator_get(PangoAttrIterator* iterator, \
PangoAttrType type)"
  s7_pointer _p;
  s7_pointer iterator, type;
  _p = args;
  iterator = s7_car(_p); _p = s7_cdr(_p);
  type = s7_car(_p);
  if (!s7_is_integer(type)) s7_wrong_type_arg_error(sc, "pango_attr_iterator_get", 2, type, "PangoAttrType");
  return(lg_make_c_pointer_with_type(sc, PangoAttribute__sym, pango_attr_iterator_get((PangoAttrIterator*)s7_c_pointer_with_type(sc, iterator, PangoAttrIterator__sym, __func__, 0), (PangoAttrType)s7_integer(type))));
}

static s7_pointer lg_pango_attr_iterator_get_font(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_attr_iterator_get_font "void pango_attr_iterator_get_font(PangoAttrIterator* iterator, \
PangoFontDescription* desc, PangoLanguage** [language], GSList** [extra_attrs])"
  s7_pointer _p;
  s7_pointer iterator, desc;
  PangoLanguage* ref_language = NULL;
  GSList* ref_extra_attrs = NULL;
  _p = args;
  iterator = s7_car(_p); _p = s7_cdr(_p);
  desc = s7_car(_p);
  pango_attr_iterator_get_font((PangoAttrIterator*)s7_c_pointer_with_type(sc, iterator, PangoAttrIterator__sym, __func__, 0), (PangoFontDescription*)s7_c_pointer_with_type(sc, desc, PangoFontDescription__sym, __func__, 0), &ref_language, &ref_extra_attrs);
    return(s7_list(sc, 2, s7_make_c_pointer(sc, ref_language), s7_make_c_pointer(sc, ref_extra_attrs)));
}

static s7_pointer lg_pango_parse_markup(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_parse_markup "gboolean pango_parse_markup(char* markup_text, int length, gunichar accel_marker, \
PangoAttrList** attr_list, char** text, gunichar* accel_char, GError** [error])"
  s7_pointer _p;
  s7_pointer markup_text, length, accel_marker, attr_list, text, accel_char;
  GError* ref_error = NULL;
  _p = args;
  markup_text = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(markup_text)) s7_wrong_type_arg_error(sc, "pango_parse_markup", 1, markup_text, "char*");
  length = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(length)) s7_wrong_type_arg_error(sc, "pango_parse_markup", 2, length, "int");
  accel_marker = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(accel_marker)) s7_wrong_type_arg_error(sc, "pango_parse_markup", 3, accel_marker, "gunichar");
  attr_list = s7_car(_p); _p = s7_cdr(_p);
  text = s7_car(_p); _p = s7_cdr(_p);
  accel_char = s7_car(_p);
  {
    s7_pointer res_ult;
    res_ult = s7_make_boolean(sc, pango_parse_markup((char*)s7_string(markup_text), (int)s7_integer(length), (gunichar)s7_integer(accel_marker), (PangoAttrList**)s7_c_pointer_with_type(sc, attr_list, PangoAttrList___sym, __func__, 0), (char**)s7_c_pointer_with_type(sc, text, char___sym, __func__, 0), (gunichar*)s7_c_pointer_with_type(sc, accel_char, gunichar__sym, __func__, 0), &ref_error));
      return(s7_list(sc, 2, res_ult, s7_make_c_pointer(sc, ref_error)));
   }
}

static s7_pointer lg_pango_find_paragraph_boundary(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_find_paragraph_boundary "void pango_find_paragraph_boundary(gchar* text, gint length, \
gint* [paragraph_delimiter_index], gint* [next_paragraph_start])"
  s7_pointer _p;
  s7_pointer text, length;
  gint ref_paragraph_delimiter_index;
  gint ref_next_paragraph_start;
  _p = args;
  text = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(text)) s7_wrong_type_arg_error(sc, "pango_find_paragraph_boundary", 1, text, "gchar*");
  length = s7_car(_p);
  if (!s7_is_integer(length)) s7_wrong_type_arg_error(sc, "pango_find_paragraph_boundary", 2, length, "gint");
  pango_find_paragraph_boundary((gchar*)s7_string(text), (gint)s7_integer(length), &ref_paragraph_delimiter_index, &ref_next_paragraph_start);
    return(s7_list(sc, 2, s7_make_integer(sc, ref_paragraph_delimiter_index), s7_make_integer(sc, ref_next_paragraph_start)));
}

static s7_pointer lg_pango_get_log_attrs(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_get_log_attrs "void pango_get_log_attrs(char* text, int length, int level, PangoLanguage* language, \
PangoLogAttr* log_attrs, int attrs_len)"
  s7_pointer _p;
  s7_pointer text, length, level, language, log_attrs, attrs_len;
  _p = args;
  text = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(text)) s7_wrong_type_arg_error(sc, "pango_get_log_attrs", 1, text, "char*");
  length = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(length)) s7_wrong_type_arg_error(sc, "pango_get_log_attrs", 2, length, "int");
  level = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(level)) s7_wrong_type_arg_error(sc, "pango_get_log_attrs", 3, level, "int");
  language = s7_car(_p); _p = s7_cdr(_p);
  log_attrs = s7_car(_p); _p = s7_cdr(_p);
  attrs_len = s7_car(_p);
  if (!s7_is_integer(attrs_len)) s7_wrong_type_arg_error(sc, "pango_get_log_attrs", 6, attrs_len, "int");
  pango_get_log_attrs((char*)s7_string(text), (int)s7_integer(length), (int)s7_integer(level), (PangoLanguage*)s7_c_pointer_with_type(sc, language, PangoLanguage__sym, __func__, 0), (PangoLogAttr*)s7_c_pointer_with_type(sc, log_attrs, PangoLogAttr__sym, __func__, 0), (int)s7_integer(attrs_len));
  return(lg_false);
}

static s7_pointer lg_pango_context_list_families(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_context_list_families "void pango_context_list_families(PangoContext* context, PangoFontFamily*** [families], \
int* [n_families])"
  s7_pointer _p;
  s7_pointer context;
  PangoFontFamily** ref_families = NULL;
  int ref_n_families;
  _p = args;
  context = s7_car(_p);
  pango_context_list_families((PangoContext*)s7_c_pointer_with_type(sc, context, PangoContext__sym, __func__, 0), &ref_families, &ref_n_families);
    return(s7_list(sc, 2, s7_make_c_pointer(sc, ref_families), s7_make_integer(sc, ref_n_families)));
}

static s7_pointer lg_pango_context_load_font(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_context_load_font "PangoFont* pango_context_load_font(PangoContext* context, PangoFontDescription* desc)"
  s7_pointer _p;
  s7_pointer context, desc;
  _p = args;
  context = s7_car(_p); _p = s7_cdr(_p);
  desc = s7_car(_p);
  return(lg_make_c_pointer_with_type(sc, PangoFont__sym, pango_context_load_font((PangoContext*)s7_c_pointer_with_type(sc, context, PangoContext__sym, __func__, 0), (PangoFontDescription*)s7_c_pointer_with_type(sc, desc, PangoFontDescription__sym, __func__, 0))));
}

static s7_pointer lg_pango_context_load_fontset(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_context_load_fontset "PangoFontset* pango_context_load_fontset(PangoContext* context, \
PangoFontDescription* desc, PangoLanguage* language)"
  s7_pointer _p;
  s7_pointer context, desc, language;
  _p = args;
  context = s7_car(_p); _p = s7_cdr(_p);
  desc = s7_car(_p); _p = s7_cdr(_p);
  language = s7_car(_p);
  return(lg_make_c_pointer_with_type(sc, PangoFontset__sym, pango_context_load_fontset((PangoContext*)s7_c_pointer_with_type(sc, context, PangoContext__sym, __func__, 0), (PangoFontDescription*)s7_c_pointer_with_type(sc, desc, PangoFontDescription__sym, __func__, 0), (PangoLanguage*)s7_c_pointer_with_type(sc, language, PangoLanguage__sym, __func__, 0))));
}

static s7_pointer lg_pango_context_get_metrics(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_context_get_metrics "PangoFontMetrics* pango_context_get_metrics(PangoContext* context, \
PangoFontDescription* desc, PangoLanguage* language)"
  s7_pointer _p;
  s7_pointer context, desc, language;
  _p = args;
  context = s7_car(_p); _p = s7_cdr(_p);
  desc = s7_car(_p); _p = s7_cdr(_p);
  language = s7_car(_p);
  return(lg_make_c_pointer_with_type(sc, PangoFontMetrics__sym, pango_context_get_metrics((PangoContext*)s7_c_pointer_with_type(sc, context, PangoContext__sym, __func__, 0), (PangoFontDescription*)s7_c_pointer_with_type(sc, desc, PangoFontDescription__sym, __func__, 0), (PangoLanguage*)s7_c_pointer_with_type(sc, language, PangoLanguage__sym, __func__, 0))));
}

static s7_pointer lg_pango_context_set_font_description(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_context_set_font_description "void pango_context_set_font_description(PangoContext* context, \
PangoFontDescription* desc)"
  s7_pointer _p;
  s7_pointer context, desc;
  _p = args;
  context = s7_car(_p); _p = s7_cdr(_p);
  desc = s7_car(_p);
  pango_context_set_font_description((PangoContext*)s7_c_pointer_with_type(sc, context, PangoContext__sym, __func__, 0), (PangoFontDescription*)s7_c_pointer_with_type(sc, desc, PangoFontDescription__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_pango_context_get_font_description(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_context_get_font_description "PangoFontDescription* pango_context_get_font_description(PangoContext* context)"
  s7_pointer context;
  context = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, PangoFontDescription__sym, pango_context_get_font_description((PangoContext*)s7_c_pointer_with_type(sc, context, PangoContext__sym, __func__, 0))));
}

static s7_pointer lg_pango_context_get_language(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_context_get_language "PangoLanguage* pango_context_get_language(PangoContext* context)"
  s7_pointer context;
  context = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, PangoLanguage__sym, pango_context_get_language((PangoContext*)s7_c_pointer_with_type(sc, context, PangoContext__sym, __func__, 0))));
}

static s7_pointer lg_pango_context_set_language(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_context_set_language "void pango_context_set_language(PangoContext* context, PangoLanguage* language)"
  s7_pointer _p;
  s7_pointer context, language;
  _p = args;
  context = s7_car(_p); _p = s7_cdr(_p);
  language = s7_car(_p);
  pango_context_set_language((PangoContext*)s7_c_pointer_with_type(sc, context, PangoContext__sym, __func__, 0), (PangoLanguage*)s7_c_pointer_with_type(sc, language, PangoLanguage__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_pango_context_set_base_dir(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_context_set_base_dir "void pango_context_set_base_dir(PangoContext* context, PangoDirection direction)"
  s7_pointer _p;
  s7_pointer context, direction;
  _p = args;
  context = s7_car(_p); _p = s7_cdr(_p);
  direction = s7_car(_p);
  if (!s7_is_integer(direction)) s7_wrong_type_arg_error(sc, "pango_context_set_base_dir", 2, direction, "PangoDirection");
  pango_context_set_base_dir((PangoContext*)s7_c_pointer_with_type(sc, context, PangoContext__sym, __func__, 0), (PangoDirection)s7_integer(direction));
  return(lg_false);
}

static s7_pointer lg_pango_context_get_base_dir(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_context_get_base_dir "PangoDirection pango_context_get_base_dir(PangoContext* context)"
  s7_pointer context;
  context = s7_car(args);
  return(s7_make_integer(sc, pango_context_get_base_dir((PangoContext*)s7_c_pointer_with_type(sc, context, PangoContext__sym, __func__, 0))));
}

static s7_pointer lg_pango_itemize(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_itemize "GList* pango_itemize(PangoContext* context, char* text, int start_index, int length, \
PangoAttrList* attrs, PangoAttrIterator* cached_iter)"
  s7_pointer _p;
  s7_pointer context, text, start_index, length, attrs, cached_iter;
  _p = args;
  context = s7_car(_p); _p = s7_cdr(_p);
  text = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(text)) s7_wrong_type_arg_error(sc, "pango_itemize", 2, text, "char*");
  start_index = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(start_index)) s7_wrong_type_arg_error(sc, "pango_itemize", 3, start_index, "int");
  length = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(length)) s7_wrong_type_arg_error(sc, "pango_itemize", 4, length, "int");
  attrs = s7_car(_p); _p = s7_cdr(_p);
  cached_iter = s7_car(_p);
  return(lg_make_c_pointer_with_type(sc, GList__sym, pango_itemize((PangoContext*)s7_c_pointer_with_type(sc, context, PangoContext__sym, __func__, 0), (char*)s7_string(text), (int)s7_integer(start_index), (int)s7_integer(length), (PangoAttrList*)s7_c_pointer_with_type(sc, attrs, PangoAttrList__sym, __func__, 0), (PangoAttrIterator*)s7_c_pointer_with_type(sc, cached_iter, PangoAttrIterator__sym, __func__, 0))));
}

static s7_pointer lg_pango_coverage_new(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_coverage_new "PangoCoverage* pango_coverage_new( void)"
  return(lg_make_c_pointer_with_type(sc, PangoCoverage__sym, pango_coverage_new()));
}

static s7_pointer lg_pango_coverage_ref(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_coverage_ref "PangoCoverage* pango_coverage_ref(PangoCoverage* coverage)"
  s7_pointer coverage;
  coverage = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, PangoCoverage__sym, pango_coverage_ref((PangoCoverage*)s7_c_pointer_with_type(sc, coverage, PangoCoverage__sym, __func__, 0))));
}

static s7_pointer lg_pango_coverage_unref(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_coverage_unref "void pango_coverage_unref(PangoCoverage* coverage)"
  s7_pointer coverage;
  coverage = s7_car(args);
  pango_coverage_unref((PangoCoverage*)s7_c_pointer_with_type(sc, coverage, PangoCoverage__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_pango_coverage_copy(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_coverage_copy "PangoCoverage* pango_coverage_copy(PangoCoverage* coverage)"
  s7_pointer coverage;
  coverage = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, PangoCoverage__sym, pango_coverage_copy((PangoCoverage*)s7_c_pointer_with_type(sc, coverage, PangoCoverage__sym, __func__, 0))));
}

static s7_pointer lg_pango_coverage_get(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_coverage_get "PangoCoverageLevel pango_coverage_get(PangoCoverage* coverage, int index)"
  s7_pointer _p;
  s7_pointer coverage, index;
  _p = args;
  coverage = s7_car(_p); _p = s7_cdr(_p);
  index = s7_car(_p);
  if (!s7_is_integer(index)) s7_wrong_type_arg_error(sc, "pango_coverage_get", 2, index, "int");
  return(s7_make_integer(sc, pango_coverage_get((PangoCoverage*)s7_c_pointer_with_type(sc, coverage, PangoCoverage__sym, __func__, 0), (int)s7_integer(index))));
}

static s7_pointer lg_pango_coverage_set(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_coverage_set "void pango_coverage_set(PangoCoverage* coverage, int index, PangoCoverageLevel level)"
  s7_pointer _p;
  s7_pointer coverage, index, level;
  _p = args;
  coverage = s7_car(_p); _p = s7_cdr(_p);
  index = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(index)) s7_wrong_type_arg_error(sc, "pango_coverage_set", 2, index, "int");
  level = s7_car(_p);
  if (!s7_is_integer(level)) s7_wrong_type_arg_error(sc, "pango_coverage_set", 3, level, "PangoCoverageLevel");
  pango_coverage_set((PangoCoverage*)s7_c_pointer_with_type(sc, coverage, PangoCoverage__sym, __func__, 0), (int)s7_integer(index), (PangoCoverageLevel)s7_integer(level));
  return(lg_false);
}

static s7_pointer lg_pango_font_description_new(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_description_new "PangoFontDescription* pango_font_description_new( void)"
  return(lg_make_c_pointer_with_type(sc, PangoFontDescription__sym, pango_font_description_new()));
}

static s7_pointer lg_pango_font_description_copy(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_description_copy "PangoFontDescription* pango_font_description_copy(PangoFontDescription* desc)"
  s7_pointer desc;
  desc = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, PangoFontDescription__sym, pango_font_description_copy((PangoFontDescription*)s7_c_pointer_with_type(sc, desc, PangoFontDescription__sym, __func__, 0))));
}

static s7_pointer lg_pango_font_description_copy_static(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_description_copy_static "PangoFontDescription* pango_font_description_copy_static(PangoFontDescription* desc)"
  s7_pointer desc;
  desc = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, PangoFontDescription__sym, pango_font_description_copy_static((PangoFontDescription*)s7_c_pointer_with_type(sc, desc, PangoFontDescription__sym, __func__, 0))));
}

static s7_pointer lg_pango_font_description_hash(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_description_hash "guint pango_font_description_hash(PangoFontDescription* desc)"
  s7_pointer desc;
  desc = s7_car(args);
  return(s7_make_integer(sc, pango_font_description_hash((PangoFontDescription*)s7_c_pointer_with_type(sc, desc, PangoFontDescription__sym, __func__, 0))));
}

static s7_pointer lg_pango_font_description_equal(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_description_equal "gboolean pango_font_description_equal(PangoFontDescription* desc1, \
PangoFontDescription* desc2)"
  s7_pointer _p;
  s7_pointer desc1, desc2;
  _p = args;
  desc1 = s7_car(_p); _p = s7_cdr(_p);
  desc2 = s7_car(_p);
  return(s7_make_boolean(sc, pango_font_description_equal((PangoFontDescription*)s7_c_pointer_with_type(sc, desc1, PangoFontDescription__sym, __func__, 0), (PangoFontDescription*)s7_c_pointer_with_type(sc, desc2, PangoFontDescription__sym, __func__, 0))));
}

static s7_pointer lg_pango_font_description_free(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_description_free "void pango_font_description_free(PangoFontDescription* desc)"
  s7_pointer desc;
  desc = s7_car(args);
  pango_font_description_free((PangoFontDescription*)s7_c_pointer_with_type(sc, desc, PangoFontDescription__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_pango_font_descriptions_free(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_descriptions_free "void pango_font_descriptions_free(PangoFontDescription** descs, \
int n_descs)"
  s7_pointer _p;
  s7_pointer descs, n_descs;
  _p = args;
  descs = s7_car(_p); _p = s7_cdr(_p);
  n_descs = s7_car(_p);
  if (!s7_is_integer(n_descs)) s7_wrong_type_arg_error(sc, "pango_font_descriptions_free", 2, n_descs, "int");
  pango_font_descriptions_free((PangoFontDescription**)s7_c_pointer_with_type(sc, descs, PangoFontDescription___sym, __func__, 0), (int)s7_integer(n_descs));
  return(lg_false);
}

static s7_pointer lg_pango_font_description_set_family(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_description_set_family "void pango_font_description_set_family(PangoFontDescription* desc, \
char* family)"
  s7_pointer _p;
  s7_pointer desc, family;
  _p = args;
  desc = s7_car(_p); _p = s7_cdr(_p);
  family = s7_car(_p);
  if (!s7_is_string(family)) s7_wrong_type_arg_error(sc, "pango_font_description_set_family", 2, family, "char*");
  pango_font_description_set_family((PangoFontDescription*)s7_c_pointer_with_type(sc, desc, PangoFontDescription__sym, __func__, 0), (char*)s7_string(family));
  return(lg_false);
}

static s7_pointer lg_pango_font_description_set_family_static(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_description_set_family_static "void pango_font_description_set_family_static(PangoFontDescription* desc, \
char* family)"
  s7_pointer _p;
  s7_pointer desc, family;
  _p = args;
  desc = s7_car(_p); _p = s7_cdr(_p);
  family = s7_car(_p);
  if (!s7_is_string(family)) s7_wrong_type_arg_error(sc, "pango_font_description_set_family_static", 2, family, "char*");
  pango_font_description_set_family_static((PangoFontDescription*)s7_c_pointer_with_type(sc, desc, PangoFontDescription__sym, __func__, 0), (char*)s7_string(family));
  return(lg_false);
}

static s7_pointer lg_pango_font_description_get_family(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_description_get_family "char* pango_font_description_get_family(PangoFontDescription* desc)"
  s7_pointer desc;
  desc = s7_car(args);
  return(s7_make_string(sc, pango_font_description_get_family((PangoFontDescription*)s7_c_pointer_with_type(sc, desc, PangoFontDescription__sym, __func__, 0))));
}

static s7_pointer lg_pango_font_description_set_style(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_description_set_style "void pango_font_description_set_style(PangoFontDescription* desc, \
PangoStyle style)"
  s7_pointer _p;
  s7_pointer desc, style;
  _p = args;
  desc = s7_car(_p); _p = s7_cdr(_p);
  style = s7_car(_p);
  if (!s7_is_integer(style)) s7_wrong_type_arg_error(sc, "pango_font_description_set_style", 2, style, "PangoStyle");
  pango_font_description_set_style((PangoFontDescription*)s7_c_pointer_with_type(sc, desc, PangoFontDescription__sym, __func__, 0), (PangoStyle)s7_integer(style));
  return(lg_false);
}

static s7_pointer lg_pango_font_description_get_style(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_description_get_style "PangoStyle pango_font_description_get_style(PangoFontDescription* desc)"
  s7_pointer desc;
  desc = s7_car(args);
  return(s7_make_integer(sc, pango_font_description_get_style((PangoFontDescription*)s7_c_pointer_with_type(sc, desc, PangoFontDescription__sym, __func__, 0))));
}

static s7_pointer lg_pango_font_description_set_variant(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_description_set_variant "void pango_font_description_set_variant(PangoFontDescription* desc, \
PangoVariant variant)"
  s7_pointer _p;
  s7_pointer desc, variant;
  _p = args;
  desc = s7_car(_p); _p = s7_cdr(_p);
  variant = s7_car(_p);
  if (!s7_is_integer(variant)) s7_wrong_type_arg_error(sc, "pango_font_description_set_variant", 2, variant, "PangoVariant");
  pango_font_description_set_variant((PangoFontDescription*)s7_c_pointer_with_type(sc, desc, PangoFontDescription__sym, __func__, 0), (PangoVariant)s7_integer(variant));
  return(lg_false);
}

static s7_pointer lg_pango_font_description_get_variant(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_description_get_variant "PangoVariant pango_font_description_get_variant(PangoFontDescription* desc)"
  s7_pointer desc;
  desc = s7_car(args);
  return(s7_make_integer(sc, pango_font_description_get_variant((PangoFontDescription*)s7_c_pointer_with_type(sc, desc, PangoFontDescription__sym, __func__, 0))));
}

static s7_pointer lg_pango_font_description_set_weight(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_description_set_weight "void pango_font_description_set_weight(PangoFontDescription* desc, \
PangoWeight weight)"
  s7_pointer _p;
  s7_pointer desc, weight;
  _p = args;
  desc = s7_car(_p); _p = s7_cdr(_p);
  weight = s7_car(_p);
  if (!s7_is_integer(weight)) s7_wrong_type_arg_error(sc, "pango_font_description_set_weight", 2, weight, "PangoWeight");
  pango_font_description_set_weight((PangoFontDescription*)s7_c_pointer_with_type(sc, desc, PangoFontDescription__sym, __func__, 0), (PangoWeight)s7_integer(weight));
  return(lg_false);
}

static s7_pointer lg_pango_font_description_get_weight(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_description_get_weight "PangoWeight pango_font_description_get_weight(PangoFontDescription* desc)"
  s7_pointer desc;
  desc = s7_car(args);
  return(s7_make_integer(sc, pango_font_description_get_weight((PangoFontDescription*)s7_c_pointer_with_type(sc, desc, PangoFontDescription__sym, __func__, 0))));
}

static s7_pointer lg_pango_font_description_set_stretch(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_description_set_stretch "void pango_font_description_set_stretch(PangoFontDescription* desc, \
PangoStretch stretch)"
  s7_pointer _p;
  s7_pointer desc, stretch;
  _p = args;
  desc = s7_car(_p); _p = s7_cdr(_p);
  stretch = s7_car(_p);
  if (!s7_is_integer(stretch)) s7_wrong_type_arg_error(sc, "pango_font_description_set_stretch", 2, stretch, "PangoStretch");
  pango_font_description_set_stretch((PangoFontDescription*)s7_c_pointer_with_type(sc, desc, PangoFontDescription__sym, __func__, 0), (PangoStretch)s7_integer(stretch));
  return(lg_false);
}

static s7_pointer lg_pango_font_description_get_stretch(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_description_get_stretch "PangoStretch pango_font_description_get_stretch(PangoFontDescription* desc)"
  s7_pointer desc;
  desc = s7_car(args);
  return(s7_make_integer(sc, pango_font_description_get_stretch((PangoFontDescription*)s7_c_pointer_with_type(sc, desc, PangoFontDescription__sym, __func__, 0))));
}

static s7_pointer lg_pango_font_description_set_size(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_description_set_size "void pango_font_description_set_size(PangoFontDescription* desc, \
gint size)"
  s7_pointer _p;
  s7_pointer desc, size;
  _p = args;
  desc = s7_car(_p); _p = s7_cdr(_p);
  size = s7_car(_p);
  if (!s7_is_integer(size)) s7_wrong_type_arg_error(sc, "pango_font_description_set_size", 2, size, "gint");
  pango_font_description_set_size((PangoFontDescription*)s7_c_pointer_with_type(sc, desc, PangoFontDescription__sym, __func__, 0), (gint)s7_integer(size));
  return(lg_false);
}

static s7_pointer lg_pango_font_description_get_size(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_description_get_size "gint pango_font_description_get_size(PangoFontDescription* desc)"
  s7_pointer desc;
  desc = s7_car(args);
  return(s7_make_integer(sc, pango_font_description_get_size((PangoFontDescription*)s7_c_pointer_with_type(sc, desc, PangoFontDescription__sym, __func__, 0))));
}

static s7_pointer lg_pango_font_description_get_set_fields(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_description_get_set_fields "PangoFontMask pango_font_description_get_set_fields(PangoFontDescription* desc)"
  s7_pointer desc;
  desc = s7_car(args);
  return(s7_make_integer(sc, pango_font_description_get_set_fields((PangoFontDescription*)s7_c_pointer_with_type(sc, desc, PangoFontDescription__sym, __func__, 0))));
}

static s7_pointer lg_pango_font_description_unset_fields(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_description_unset_fields "void pango_font_description_unset_fields(PangoFontDescription* desc, \
PangoFontMask to_unset)"
  s7_pointer _p;
  s7_pointer desc, to_unset;
  _p = args;
  desc = s7_car(_p); _p = s7_cdr(_p);
  to_unset = s7_car(_p);
  if (!s7_is_integer(to_unset)) s7_wrong_type_arg_error(sc, "pango_font_description_unset_fields", 2, to_unset, "PangoFontMask");
  pango_font_description_unset_fields((PangoFontDescription*)s7_c_pointer_with_type(sc, desc, PangoFontDescription__sym, __func__, 0), (PangoFontMask)s7_integer(to_unset));
  return(lg_false);
}

static s7_pointer lg_pango_font_description_merge(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_description_merge "void pango_font_description_merge(PangoFontDescription* desc, \
PangoFontDescription* desc_to_merge, gboolean replace_existing)"
  s7_pointer _p;
  s7_pointer desc, desc_to_merge, replace_existing;
  _p = args;
  desc = s7_car(_p); _p = s7_cdr(_p);
  desc_to_merge = s7_car(_p); _p = s7_cdr(_p);
  replace_existing = s7_car(_p);
  if (!s7_is_boolean(replace_existing)) s7_wrong_type_arg_error(sc, "pango_font_description_merge", 3, replace_existing, "gboolean");
  pango_font_description_merge((PangoFontDescription*)s7_c_pointer_with_type(sc, desc, PangoFontDescription__sym, __func__, 0), (PangoFontDescription*)s7_c_pointer_with_type(sc, desc_to_merge, PangoFontDescription__sym, __func__, 0), (gboolean)lg_boolean(replace_existing));
  return(lg_false);
}

static s7_pointer lg_pango_font_description_merge_static(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_description_merge_static "void pango_font_description_merge_static(PangoFontDescription* desc, \
PangoFontDescription* desc_to_merge, gboolean replace_existing)"
  s7_pointer _p;
  s7_pointer desc, desc_to_merge, replace_existing;
  _p = args;
  desc = s7_car(_p); _p = s7_cdr(_p);
  desc_to_merge = s7_car(_p); _p = s7_cdr(_p);
  replace_existing = s7_car(_p);
  if (!s7_is_boolean(replace_existing)) s7_wrong_type_arg_error(sc, "pango_font_description_merge_static", 3, replace_existing, "gboolean");
  pango_font_description_merge_static((PangoFontDescription*)s7_c_pointer_with_type(sc, desc, PangoFontDescription__sym, __func__, 0), (PangoFontDescription*)s7_c_pointer_with_type(sc, desc_to_merge, PangoFontDescription__sym, __func__, 0), (gboolean)lg_boolean(replace_existing));
  return(lg_false);
}

static s7_pointer lg_pango_font_description_better_match(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_description_better_match "gboolean pango_font_description_better_match(PangoFontDescription* desc, \
PangoFontDescription* old_match, PangoFontDescription* new_match)"
  s7_pointer _p;
  s7_pointer desc, old_match, new_match;
  _p = args;
  desc = s7_car(_p); _p = s7_cdr(_p);
  old_match = s7_car(_p); _p = s7_cdr(_p);
  new_match = s7_car(_p);
  return(s7_make_boolean(sc, pango_font_description_better_match((PangoFontDescription*)s7_c_pointer_with_type(sc, desc, PangoFontDescription__sym, __func__, 0), (PangoFontDescription*)s7_c_pointer_with_type(sc, old_match, PangoFontDescription__sym, __func__, 0), (PangoFontDescription*)s7_c_pointer_with_type(sc, new_match, PangoFontDescription__sym, __func__, 0))));
}

static s7_pointer lg_pango_font_description_from_string(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_description_from_string "PangoFontDescription* pango_font_description_from_string(char* str)"
  s7_pointer str;
  str = s7_car(args);
  if (!s7_is_string(str)) s7_wrong_type_arg_error(sc, "pango_font_description_from_string", 1, str, "char*");
  return(lg_make_c_pointer_with_type(sc, PangoFontDescription__sym, pango_font_description_from_string((char*)s7_string(str))));
}

static s7_pointer lg_pango_font_description_to_string(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_description_to_string "char* pango_font_description_to_string(PangoFontDescription* desc)"
  s7_pointer desc;
  desc = s7_car(args);
  {
    char* res_ult;
    s7_pointer rtn;
    res_ult = pango_font_description_to_string((PangoFontDescription*)s7_c_pointer_with_type(sc, desc, PangoFontDescription__sym, __func__, 0));
    rtn = s7_make_string(sc, res_ult);
    g_free(res_ult);
    return(rtn);
  }
}

static s7_pointer lg_pango_font_description_to_filename(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_description_to_filename "char* pango_font_description_to_filename(PangoFontDescription* desc)"
  s7_pointer desc;
  desc = s7_car(args);
  {
    char* res_ult;
    s7_pointer rtn;
    res_ult = pango_font_description_to_filename((PangoFontDescription*)s7_c_pointer_with_type(sc, desc, PangoFontDescription__sym, __func__, 0));
    rtn = s7_make_string(sc, res_ult);
    g_free(res_ult);
    return(rtn);
  }
}

static s7_pointer lg_pango_font_metrics_ref(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_metrics_ref "PangoFontMetrics* pango_font_metrics_ref(PangoFontMetrics* metrics)"
  s7_pointer metrics;
  metrics = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, PangoFontMetrics__sym, pango_font_metrics_ref((PangoFontMetrics*)s7_c_pointer_with_type(sc, metrics, PangoFontMetrics__sym, __func__, 0))));
}

static s7_pointer lg_pango_font_metrics_unref(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_metrics_unref "void pango_font_metrics_unref(PangoFontMetrics* metrics)"
  s7_pointer metrics;
  metrics = s7_car(args);
  pango_font_metrics_unref((PangoFontMetrics*)s7_c_pointer_with_type(sc, metrics, PangoFontMetrics__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_pango_font_metrics_get_ascent(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_metrics_get_ascent "int pango_font_metrics_get_ascent(PangoFontMetrics* metrics)"
  s7_pointer metrics;
  metrics = s7_car(args);
  return(s7_make_integer(sc, pango_font_metrics_get_ascent((PangoFontMetrics*)s7_c_pointer_with_type(sc, metrics, PangoFontMetrics__sym, __func__, 0))));
}

static s7_pointer lg_pango_font_metrics_get_descent(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_metrics_get_descent "int pango_font_metrics_get_descent(PangoFontMetrics* metrics)"
  s7_pointer metrics;
  metrics = s7_car(args);
  return(s7_make_integer(sc, pango_font_metrics_get_descent((PangoFontMetrics*)s7_c_pointer_with_type(sc, metrics, PangoFontMetrics__sym, __func__, 0))));
}

static s7_pointer lg_pango_font_metrics_get_approximate_char_width(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_metrics_get_approximate_char_width "int pango_font_metrics_get_approximate_char_width(PangoFontMetrics* metrics)"
  s7_pointer metrics;
  metrics = s7_car(args);
  return(s7_make_integer(sc, pango_font_metrics_get_approximate_char_width((PangoFontMetrics*)s7_c_pointer_with_type(sc, metrics, PangoFontMetrics__sym, __func__, 0))));
}

static s7_pointer lg_pango_font_metrics_get_approximate_digit_width(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_metrics_get_approximate_digit_width "int pango_font_metrics_get_approximate_digit_width(PangoFontMetrics* metrics)"
  s7_pointer metrics;
  metrics = s7_car(args);
  return(s7_make_integer(sc, pango_font_metrics_get_approximate_digit_width((PangoFontMetrics*)s7_c_pointer_with_type(sc, metrics, PangoFontMetrics__sym, __func__, 0))));
}

static s7_pointer lg_pango_font_family_list_faces(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_family_list_faces "void pango_font_family_list_faces(PangoFontFamily* family, \
PangoFontFace*** [faces], int* [n_faces])"
  s7_pointer _p;
  s7_pointer family;
  PangoFontFace** ref_faces = NULL;
  int ref_n_faces;
  _p = args;
  family = s7_car(_p);
  pango_font_family_list_faces((PangoFontFamily*)s7_c_pointer_with_type(sc, family, PangoFontFamily__sym, __func__, 0), &ref_faces, &ref_n_faces);
    return(s7_list(sc, 2, s7_make_c_pointer(sc, ref_faces), s7_make_integer(sc, ref_n_faces)));
}

static s7_pointer lg_pango_font_family_get_name(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_family_get_name "char* pango_font_family_get_name(PangoFontFamily* family)"
  s7_pointer family;
  family = s7_car(args);
  return(s7_make_string(sc, pango_font_family_get_name((PangoFontFamily*)s7_c_pointer_with_type(sc, family, PangoFontFamily__sym, __func__, 0))));
}

static s7_pointer lg_pango_font_face_describe(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_face_describe "PangoFontDescription* pango_font_face_describe(PangoFontFace* face)"
  s7_pointer face;
  face = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, PangoFontDescription__sym, pango_font_face_describe((PangoFontFace*)s7_c_pointer_with_type(sc, face, PangoFontFace__sym, __func__, 0))));
}

static s7_pointer lg_pango_font_face_get_face_name(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_face_get_face_name "char* pango_font_face_get_face_name(PangoFontFace* face)"
  s7_pointer face;
  face = s7_car(args);
  return(s7_make_string(sc, pango_font_face_get_face_name((PangoFontFace*)s7_c_pointer_with_type(sc, face, PangoFontFace__sym, __func__, 0))));
}

static s7_pointer lg_pango_font_describe(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_describe "PangoFontDescription* pango_font_describe(PangoFont* font)"
  s7_pointer font;
  font = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, PangoFontDescription__sym, pango_font_describe((PangoFont*)s7_c_pointer_with_type(sc, font, PangoFont__sym, __func__, 0))));
}

static s7_pointer lg_pango_font_get_coverage(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_get_coverage "PangoCoverage* pango_font_get_coverage(PangoFont* font, PangoLanguage* language)"
  s7_pointer _p;
  s7_pointer font, language;
  _p = args;
  font = s7_car(_p); _p = s7_cdr(_p);
  language = s7_car(_p);
  return(lg_make_c_pointer_with_type(sc, PangoCoverage__sym, pango_font_get_coverage((PangoFont*)s7_c_pointer_with_type(sc, font, PangoFont__sym, __func__, 0), (PangoLanguage*)s7_c_pointer_with_type(sc, language, PangoLanguage__sym, __func__, 0))));
}

static s7_pointer lg_pango_font_get_metrics(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_get_metrics "PangoFontMetrics* pango_font_get_metrics(PangoFont* font, PangoLanguage* language)"
  s7_pointer _p;
  s7_pointer font, language;
  _p = args;
  font = s7_car(_p); _p = s7_cdr(_p);
  language = s7_car(_p);
  return(lg_make_c_pointer_with_type(sc, PangoFontMetrics__sym, pango_font_get_metrics((PangoFont*)s7_c_pointer_with_type(sc, font, PangoFont__sym, __func__, 0), (PangoLanguage*)s7_c_pointer_with_type(sc, language, PangoLanguage__sym, __func__, 0))));
}

static s7_pointer lg_pango_font_get_glyph_extents(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_get_glyph_extents "void pango_font_get_glyph_extents(PangoFont* font, PangoGlyph glyph, \
PangoRectangle* ink_rect, PangoRectangle* logical_rect)"
  s7_pointer _p;
  s7_pointer font, glyph, ink_rect, logical_rect;
  _p = args;
  font = s7_car(_p); _p = s7_cdr(_p);
  glyph = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(glyph)) s7_wrong_type_arg_error(sc, "pango_font_get_glyph_extents", 2, glyph, "PangoGlyph");
  ink_rect = s7_car(_p); _p = s7_cdr(_p);
  logical_rect = s7_car(_p);
  pango_font_get_glyph_extents((PangoFont*)s7_c_pointer_with_type(sc, font, PangoFont__sym, __func__, 0), (PangoGlyph)s7_integer(glyph), (PangoRectangle*)s7_c_pointer_with_type(sc, ink_rect, PangoRectangle__sym, __func__, 0), (PangoRectangle*)s7_c_pointer_with_type(sc, logical_rect, PangoRectangle__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_pango_font_map_load_font(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_map_load_font "PangoFont* pango_font_map_load_font(PangoFontMap* fontmap, PangoContext* context, \
PangoFontDescription* desc)"
  s7_pointer _p;
  s7_pointer fontmap, context, desc;
  _p = args;
  fontmap = s7_car(_p); _p = s7_cdr(_p);
  context = s7_car(_p); _p = s7_cdr(_p);
  desc = s7_car(_p);
  return(lg_make_c_pointer_with_type(sc, PangoFont__sym, pango_font_map_load_font((PangoFontMap*)s7_c_pointer_with_type(sc, fontmap, PangoFontMap__sym, __func__, 0), (PangoContext*)s7_c_pointer_with_type(sc, context, PangoContext__sym, __func__, 0), (PangoFontDescription*)s7_c_pointer_with_type(sc, desc, PangoFontDescription__sym, __func__, 0))));
}

static s7_pointer lg_pango_font_map_load_fontset(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_map_load_fontset "PangoFontset* pango_font_map_load_fontset(PangoFontMap* fontmap, \
PangoContext* context, PangoFontDescription* desc, PangoLanguage* language)"
  s7_pointer _p;
  s7_pointer fontmap, context, desc, language;
  _p = args;
  fontmap = s7_car(_p); _p = s7_cdr(_p);
  context = s7_car(_p); _p = s7_cdr(_p);
  desc = s7_car(_p); _p = s7_cdr(_p);
  language = s7_car(_p);
  return(lg_make_c_pointer_with_type(sc, PangoFontset__sym, pango_font_map_load_fontset((PangoFontMap*)s7_c_pointer_with_type(sc, fontmap, PangoFontMap__sym, __func__, 0), (PangoContext*)s7_c_pointer_with_type(sc, context, PangoContext__sym, __func__, 0), (PangoFontDescription*)s7_c_pointer_with_type(sc, desc, PangoFontDescription__sym, __func__, 0), (PangoLanguage*)s7_c_pointer_with_type(sc, language, PangoLanguage__sym, __func__, 0))));
}

static s7_pointer lg_pango_font_map_list_families(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_map_list_families "void pango_font_map_list_families(PangoFontMap* fontmap, PangoFontFamily*** [families], \
int* [n_families])"
  s7_pointer _p;
  s7_pointer fontmap;
  PangoFontFamily** ref_families = NULL;
  int ref_n_families;
  _p = args;
  fontmap = s7_car(_p);
  pango_font_map_list_families((PangoFontMap*)s7_c_pointer_with_type(sc, fontmap, PangoFontMap__sym, __func__, 0), &ref_families, &ref_n_families);
    return(s7_list(sc, 2, s7_make_c_pointer(sc, ref_families), s7_make_integer(sc, ref_n_families)));
}

static s7_pointer lg_pango_glyph_string_new(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_glyph_string_new "PangoGlyphString* pango_glyph_string_new( void)"
  return(lg_make_c_pointer_with_type(sc, PangoGlyphString__sym, pango_glyph_string_new()));
}

static s7_pointer lg_pango_glyph_string_set_size(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_glyph_string_set_size "void pango_glyph_string_set_size(PangoGlyphString* string, gint new_len)"
  s7_pointer _p;
  s7_pointer string, new_len;
  _p = args;
  string = s7_car(_p); _p = s7_cdr(_p);
  new_len = s7_car(_p);
  if (!s7_is_integer(new_len)) s7_wrong_type_arg_error(sc, "pango_glyph_string_set_size", 2, new_len, "gint");
  pango_glyph_string_set_size((PangoGlyphString*)s7_c_pointer_with_type(sc, string, PangoGlyphString__sym, __func__, 0), (gint)s7_integer(new_len));
  return(lg_false);
}

static s7_pointer lg_pango_glyph_string_copy(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_glyph_string_copy "PangoGlyphString* pango_glyph_string_copy(PangoGlyphString* string)"
  s7_pointer string;
  string = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, PangoGlyphString__sym, pango_glyph_string_copy((PangoGlyphString*)s7_c_pointer_with_type(sc, string, PangoGlyphString__sym, __func__, 0))));
}

static s7_pointer lg_pango_glyph_string_free(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_glyph_string_free "void pango_glyph_string_free(PangoGlyphString* string)"
  s7_pointer string;
  string = s7_car(args);
  pango_glyph_string_free((PangoGlyphString*)s7_c_pointer_with_type(sc, string, PangoGlyphString__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_pango_glyph_string_extents(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_glyph_string_extents "void pango_glyph_string_extents(PangoGlyphString* glyphs, PangoFont* font, \
PangoRectangle* ink_rect, PangoRectangle* logical_rect)"
  s7_pointer _p;
  s7_pointer glyphs, font, ink_rect, logical_rect;
  _p = args;
  glyphs = s7_car(_p); _p = s7_cdr(_p);
  font = s7_car(_p); _p = s7_cdr(_p);
  ink_rect = s7_car(_p); _p = s7_cdr(_p);
  logical_rect = s7_car(_p);
  pango_glyph_string_extents((PangoGlyphString*)s7_c_pointer_with_type(sc, glyphs, PangoGlyphString__sym, __func__, 0), (PangoFont*)s7_c_pointer_with_type(sc, font, PangoFont__sym, __func__, 0), (PangoRectangle*)s7_c_pointer_with_type(sc, ink_rect, PangoRectangle__sym, __func__, 0), (PangoRectangle*)s7_c_pointer_with_type(sc, logical_rect, PangoRectangle__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_pango_glyph_string_extents_range(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_glyph_string_extents_range "void pango_glyph_string_extents_range(PangoGlyphString* glyphs, \
int start, int end, PangoFont* font, PangoRectangle* ink_rect, PangoRectangle* logical_rect)"
  s7_pointer _p;
  s7_pointer glyphs, start, end, font, ink_rect, logical_rect;
  _p = args;
  glyphs = s7_car(_p); _p = s7_cdr(_p);
  start = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(start)) s7_wrong_type_arg_error(sc, "pango_glyph_string_extents_range", 2, start, "int");
  end = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(end)) s7_wrong_type_arg_error(sc, "pango_glyph_string_extents_range", 3, end, "int");
  font = s7_car(_p); _p = s7_cdr(_p);
  ink_rect = s7_car(_p); _p = s7_cdr(_p);
  logical_rect = s7_car(_p);
  pango_glyph_string_extents_range((PangoGlyphString*)s7_c_pointer_with_type(sc, glyphs, PangoGlyphString__sym, __func__, 0), (int)s7_integer(start), (int)s7_integer(end), (PangoFont*)s7_c_pointer_with_type(sc, font, PangoFont__sym, __func__, 0), (PangoRectangle*)s7_c_pointer_with_type(sc, ink_rect, PangoRectangle__sym, __func__, 0), (PangoRectangle*)s7_c_pointer_with_type(sc, logical_rect, PangoRectangle__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_pango_glyph_string_get_logical_widths(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_glyph_string_get_logical_widths "void pango_glyph_string_get_logical_widths(PangoGlyphString* glyphs, \
char* text, int length, int embedding_level, int* [logical_widths])"
  s7_pointer _p;
  s7_pointer glyphs, text, length, embedding_level;
  int ref_logical_widths;
  _p = args;
  glyphs = s7_car(_p); _p = s7_cdr(_p);
  text = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(text)) s7_wrong_type_arg_error(sc, "pango_glyph_string_get_logical_widths", 2, text, "char*");
  length = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(length)) s7_wrong_type_arg_error(sc, "pango_glyph_string_get_logical_widths", 3, length, "int");
  embedding_level = s7_car(_p);
  if (!s7_is_integer(embedding_level)) s7_wrong_type_arg_error(sc, "pango_glyph_string_get_logical_widths", 4, embedding_level, "int");
  pango_glyph_string_get_logical_widths((PangoGlyphString*)s7_c_pointer_with_type(sc, glyphs, PangoGlyphString__sym, __func__, 0), (char*)s7_string(text), (int)s7_integer(length), (int)s7_integer(embedding_level), &ref_logical_widths);
    return(s7_list(sc, 1, s7_make_integer(sc, ref_logical_widths)));
}

static s7_pointer lg_pango_glyph_string_index_to_x(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_glyph_string_index_to_x "void pango_glyph_string_index_to_x(PangoGlyphString* glyphs, \
char* text, int length, PangoAnalysis* analysis, int index, gboolean trailing, int* [x_pos])"
  s7_pointer _p;
  s7_pointer glyphs, text, length, analysis, index, trailing;
  int ref_x_pos;
  _p = args;
  glyphs = s7_car(_p); _p = s7_cdr(_p);
  text = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(text)) s7_wrong_type_arg_error(sc, "pango_glyph_string_index_to_x", 2, text, "char*");
  length = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(length)) s7_wrong_type_arg_error(sc, "pango_glyph_string_index_to_x", 3, length, "int");
  analysis = s7_car(_p); _p = s7_cdr(_p);
  index = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(index)) s7_wrong_type_arg_error(sc, "pango_glyph_string_index_to_x", 5, index, "int");
  trailing = s7_car(_p);
  if (!s7_is_boolean(trailing)) s7_wrong_type_arg_error(sc, "pango_glyph_string_index_to_x", 6, trailing, "gboolean");
  pango_glyph_string_index_to_x((PangoGlyphString*)s7_c_pointer_with_type(sc, glyphs, PangoGlyphString__sym, __func__, 0), (char*)s7_string(text), (int)s7_integer(length), (PangoAnalysis*)s7_c_pointer_with_type(sc, analysis, PangoAnalysis__sym, __func__, 0), (int)s7_integer(index), (gboolean)lg_boolean(trailing), &ref_x_pos);
    return(s7_list(sc, 1, s7_make_integer(sc, ref_x_pos)));
}

static s7_pointer lg_pango_glyph_string_x_to_index(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_glyph_string_x_to_index "void pango_glyph_string_x_to_index(PangoGlyphString* glyphs, \
char* text, int length, PangoAnalysis* analysis, int x_pos, int* [index], int* [trailing])"
  s7_pointer _p;
  s7_pointer glyphs, text, length, analysis, x_pos;
  int ref_index;
  int ref_trailing;
  _p = args;
  glyphs = s7_car(_p); _p = s7_cdr(_p);
  text = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(text)) s7_wrong_type_arg_error(sc, "pango_glyph_string_x_to_index", 2, text, "char*");
  length = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(length)) s7_wrong_type_arg_error(sc, "pango_glyph_string_x_to_index", 3, length, "int");
  analysis = s7_car(_p); _p = s7_cdr(_p);
  x_pos = s7_car(_p);
  if (!s7_is_integer(x_pos)) s7_wrong_type_arg_error(sc, "pango_glyph_string_x_to_index", 5, x_pos, "int");
  pango_glyph_string_x_to_index((PangoGlyphString*)s7_c_pointer_with_type(sc, glyphs, PangoGlyphString__sym, __func__, 0), (char*)s7_string(text), (int)s7_integer(length), (PangoAnalysis*)s7_c_pointer_with_type(sc, analysis, PangoAnalysis__sym, __func__, 0), (int)s7_integer(x_pos), &ref_index, &ref_trailing);
    return(s7_list(sc, 2, s7_make_integer(sc, ref_index), s7_make_integer(sc, ref_trailing)));
}

static s7_pointer lg_pango_shape(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_shape "void pango_shape(gchar* text, gint length, PangoAnalysis* analysis, PangoGlyphString* glyphs)"
  s7_pointer _p;
  s7_pointer text, length, analysis, glyphs;
  _p = args;
  text = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(text)) s7_wrong_type_arg_error(sc, "pango_shape", 1, text, "gchar*");
  length = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(length)) s7_wrong_type_arg_error(sc, "pango_shape", 2, length, "gint");
  analysis = s7_car(_p); _p = s7_cdr(_p);
  glyphs = s7_car(_p);
  pango_shape((gchar*)s7_string(text), (gint)s7_integer(length), (PangoAnalysis*)s7_c_pointer_with_type(sc, analysis, PangoAnalysis__sym, __func__, 0), (PangoGlyphString*)s7_c_pointer_with_type(sc, glyphs, PangoGlyphString__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_pango_reorder_items(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_reorder_items "GList* pango_reorder_items(GList* logical_items)"
  s7_pointer logical_items;
  logical_items = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GList__sym, pango_reorder_items((GList*)s7_c_pointer_with_type(sc, logical_items, GList__sym, __func__, 0))));
}

static s7_pointer lg_pango_item_new(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_item_new "PangoItem* pango_item_new( void)"
  return(lg_make_c_pointer_with_type(sc, PangoItem__sym, pango_item_new()));
}

static s7_pointer lg_pango_item_copy(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_item_copy "PangoItem* pango_item_copy(PangoItem* item)"
  s7_pointer item;
  item = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, PangoItem__sym, pango_item_copy((PangoItem*)s7_c_pointer_with_type(sc, item, PangoItem__sym, __func__, 0))));
}

static s7_pointer lg_pango_item_free(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_item_free "void pango_item_free(PangoItem* item)"
  s7_pointer item;
  item = s7_car(args);
  pango_item_free((PangoItem*)s7_c_pointer_with_type(sc, item, PangoItem__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_pango_item_split(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_item_split "PangoItem* pango_item_split(PangoItem* orig, int split_index, int split_offset)"
  s7_pointer _p;
  s7_pointer orig, split_index, split_offset;
  _p = args;
  orig = s7_car(_p); _p = s7_cdr(_p);
  split_index = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(split_index)) s7_wrong_type_arg_error(sc, "pango_item_split", 2, split_index, "int");
  split_offset = s7_car(_p);
  if (!s7_is_integer(split_offset)) s7_wrong_type_arg_error(sc, "pango_item_split", 3, split_offset, "int");
  return(lg_make_c_pointer_with_type(sc, PangoItem__sym, pango_item_split((PangoItem*)s7_c_pointer_with_type(sc, orig, PangoItem__sym, __func__, 0), (int)s7_integer(split_index), (int)s7_integer(split_offset))));
}

static s7_pointer lg_pango_layout_new(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_new "PangoLayout* pango_layout_new(PangoContext* context)"
  s7_pointer context;
  context = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, PangoLayout__sym, pango_layout_new((PangoContext*)s7_c_pointer_with_type(sc, context, PangoContext__sym, __func__, 0))));
}

static s7_pointer lg_pango_layout_copy(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_copy "PangoLayout* pango_layout_copy(PangoLayout* src)"
  s7_pointer src;
  src = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, PangoLayout__sym, pango_layout_copy((PangoLayout*)s7_c_pointer_with_type(sc, src, PangoLayout__sym, __func__, 0))));
}

static s7_pointer lg_pango_layout_get_context(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_get_context "PangoContext* pango_layout_get_context(PangoLayout* layout)"
  s7_pointer layout;
  layout = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, PangoContext__sym, pango_layout_get_context((PangoLayout*)s7_c_pointer_with_type(sc, layout, PangoLayout__sym, __func__, 0))));
}

static s7_pointer lg_pango_layout_set_attributes(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_set_attributes "void pango_layout_set_attributes(PangoLayout* layout, PangoAttrList* attrs)"
  s7_pointer _p;
  s7_pointer layout, attrs;
  _p = args;
  layout = s7_car(_p); _p = s7_cdr(_p);
  attrs = s7_car(_p);
  pango_layout_set_attributes((PangoLayout*)s7_c_pointer_with_type(sc, layout, PangoLayout__sym, __func__, 0), (PangoAttrList*)s7_c_pointer_with_type(sc, attrs, PangoAttrList__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_pango_layout_get_attributes(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_get_attributes "PangoAttrList* pango_layout_get_attributes(PangoLayout* layout)"
  s7_pointer layout;
  layout = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, PangoAttrList__sym, pango_layout_get_attributes((PangoLayout*)s7_c_pointer_with_type(sc, layout, PangoLayout__sym, __func__, 0))));
}

static s7_pointer lg_pango_layout_set_text(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_set_text "void pango_layout_set_text(PangoLayout* layout, char* text, int length)"
  s7_pointer _p;
  s7_pointer layout, text, length;
  _p = args;
  layout = s7_car(_p); _p = s7_cdr(_p);
  text = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(text)) s7_wrong_type_arg_error(sc, "pango_layout_set_text", 2, text, "char*");
  length = s7_car(_p);
  if (!s7_is_integer(length)) s7_wrong_type_arg_error(sc, "pango_layout_set_text", 3, length, "int");
  pango_layout_set_text((PangoLayout*)s7_c_pointer_with_type(sc, layout, PangoLayout__sym, __func__, 0), (char*)s7_string(text), (int)s7_integer(length));
  return(lg_false);
}

static s7_pointer lg_pango_layout_get_text(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_get_text "char* pango_layout_get_text(PangoLayout* layout)"
  s7_pointer layout;
  layout = s7_car(args);
  return(s7_make_string(sc, pango_layout_get_text((PangoLayout*)s7_c_pointer_with_type(sc, layout, PangoLayout__sym, __func__, 0))));
}

static s7_pointer lg_pango_layout_set_markup(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_set_markup "void pango_layout_set_markup(PangoLayout* layout, char* markup, \
int length)"
  s7_pointer _p;
  s7_pointer layout, markup, length;
  _p = args;
  layout = s7_car(_p); _p = s7_cdr(_p);
  markup = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(markup)) s7_wrong_type_arg_error(sc, "pango_layout_set_markup", 2, markup, "char*");
  length = s7_car(_p);
  if (!s7_is_integer(length)) s7_wrong_type_arg_error(sc, "pango_layout_set_markup", 3, length, "int");
  pango_layout_set_markup((PangoLayout*)s7_c_pointer_with_type(sc, layout, PangoLayout__sym, __func__, 0), (char*)s7_string(markup), (int)s7_integer(length));
  return(lg_false);
}

static s7_pointer lg_pango_layout_set_markup_with_accel(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_set_markup_with_accel "void pango_layout_set_markup_with_accel(PangoLayout* layout, \
char* markup, int length, gunichar accel_marker, gunichar* accel_char)"
  s7_pointer _p;
  s7_pointer layout, markup, length, accel_marker, accel_char;
  _p = args;
  layout = s7_car(_p); _p = s7_cdr(_p);
  markup = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(markup)) s7_wrong_type_arg_error(sc, "pango_layout_set_markup_with_accel", 2, markup, "char*");
  length = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(length)) s7_wrong_type_arg_error(sc, "pango_layout_set_markup_with_accel", 3, length, "int");
  accel_marker = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(accel_marker)) s7_wrong_type_arg_error(sc, "pango_layout_set_markup_with_accel", 4, accel_marker, "gunichar");
  accel_char = s7_car(_p);
  pango_layout_set_markup_with_accel((PangoLayout*)s7_c_pointer_with_type(sc, layout, PangoLayout__sym, __func__, 0), (char*)s7_string(markup), (int)s7_integer(length), (gunichar)s7_integer(accel_marker), (gunichar*)s7_c_pointer_with_type(sc, accel_char, gunichar__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_pango_layout_set_font_description(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_set_font_description "void pango_layout_set_font_description(PangoLayout* layout, \
PangoFontDescription* desc)"
  s7_pointer _p;
  s7_pointer layout, desc;
  _p = args;
  layout = s7_car(_p); _p = s7_cdr(_p);
  desc = s7_car(_p);
  pango_layout_set_font_description((PangoLayout*)s7_c_pointer_with_type(sc, layout, PangoLayout__sym, __func__, 0), (PangoFontDescription*)s7_c_pointer_with_type(sc, desc, PangoFontDescription__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_pango_layout_set_width(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_set_width "void pango_layout_set_width(PangoLayout* layout, int width)"
  s7_pointer _p;
  s7_pointer layout, width;
  _p = args;
  layout = s7_car(_p); _p = s7_cdr(_p);
  width = s7_car(_p);
  if (!s7_is_integer(width)) s7_wrong_type_arg_error(sc, "pango_layout_set_width", 2, width, "int");
  pango_layout_set_width((PangoLayout*)s7_c_pointer_with_type(sc, layout, PangoLayout__sym, __func__, 0), (int)s7_integer(width));
  return(lg_false);
}

static s7_pointer lg_pango_layout_get_width(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_get_width "int pango_layout_get_width(PangoLayout* layout)"
  s7_pointer layout;
  layout = s7_car(args);
  return(s7_make_integer(sc, pango_layout_get_width((PangoLayout*)s7_c_pointer_with_type(sc, layout, PangoLayout__sym, __func__, 0))));
}

static s7_pointer lg_pango_layout_set_wrap(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_set_wrap "void pango_layout_set_wrap(PangoLayout* layout, PangoWrapMode wrap)"
  s7_pointer _p;
  s7_pointer layout, wrap;
  _p = args;
  layout = s7_car(_p); _p = s7_cdr(_p);
  wrap = s7_car(_p);
  if (!s7_is_integer(wrap)) s7_wrong_type_arg_error(sc, "pango_layout_set_wrap", 2, wrap, "PangoWrapMode");
  pango_layout_set_wrap((PangoLayout*)s7_c_pointer_with_type(sc, layout, PangoLayout__sym, __func__, 0), (PangoWrapMode)s7_integer(wrap));
  return(lg_false);
}

static s7_pointer lg_pango_layout_get_wrap(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_get_wrap "PangoWrapMode pango_layout_get_wrap(PangoLayout* layout)"
  s7_pointer layout;
  layout = s7_car(args);
  return(s7_make_integer(sc, pango_layout_get_wrap((PangoLayout*)s7_c_pointer_with_type(sc, layout, PangoLayout__sym, __func__, 0))));
}

static s7_pointer lg_pango_layout_set_indent(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_set_indent "void pango_layout_set_indent(PangoLayout* layout, int indent)"
  s7_pointer _p;
  s7_pointer layout, indent;
  _p = args;
  layout = s7_car(_p); _p = s7_cdr(_p);
  indent = s7_car(_p);
  if (!s7_is_integer(indent)) s7_wrong_type_arg_error(sc, "pango_layout_set_indent", 2, indent, "int");
  pango_layout_set_indent((PangoLayout*)s7_c_pointer_with_type(sc, layout, PangoLayout__sym, __func__, 0), (int)s7_integer(indent));
  return(lg_false);
}

static s7_pointer lg_pango_layout_get_indent(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_get_indent "int pango_layout_get_indent(PangoLayout* layout)"
  s7_pointer layout;
  layout = s7_car(args);
  return(s7_make_integer(sc, pango_layout_get_indent((PangoLayout*)s7_c_pointer_with_type(sc, layout, PangoLayout__sym, __func__, 0))));
}

static s7_pointer lg_pango_layout_set_spacing(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_set_spacing "void pango_layout_set_spacing(PangoLayout* layout, int spacing)"
  s7_pointer _p;
  s7_pointer layout, spacing;
  _p = args;
  layout = s7_car(_p); _p = s7_cdr(_p);
  spacing = s7_car(_p);
  if (!s7_is_integer(spacing)) s7_wrong_type_arg_error(sc, "pango_layout_set_spacing", 2, spacing, "int");
  pango_layout_set_spacing((PangoLayout*)s7_c_pointer_with_type(sc, layout, PangoLayout__sym, __func__, 0), (int)s7_integer(spacing));
  return(lg_false);
}

static s7_pointer lg_pango_layout_get_spacing(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_get_spacing "int pango_layout_get_spacing(PangoLayout* layout)"
  s7_pointer layout;
  layout = s7_car(args);
  return(s7_make_integer(sc, pango_layout_get_spacing((PangoLayout*)s7_c_pointer_with_type(sc, layout, PangoLayout__sym, __func__, 0))));
}

static s7_pointer lg_pango_layout_set_justify(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_set_justify "void pango_layout_set_justify(PangoLayout* layout, gboolean justify)"
  s7_pointer _p;
  s7_pointer layout, justify;
  _p = args;
  layout = s7_car(_p); _p = s7_cdr(_p);
  justify = s7_car(_p);
  if (!s7_is_boolean(justify)) s7_wrong_type_arg_error(sc, "pango_layout_set_justify", 2, justify, "gboolean");
  pango_layout_set_justify((PangoLayout*)s7_c_pointer_with_type(sc, layout, PangoLayout__sym, __func__, 0), (gboolean)lg_boolean(justify));
  return(lg_false);
}

static s7_pointer lg_pango_layout_get_justify(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_get_justify "gboolean pango_layout_get_justify(PangoLayout* layout)"
  s7_pointer layout;
  layout = s7_car(args);
  return(s7_make_boolean(sc, pango_layout_get_justify((PangoLayout*)s7_c_pointer_with_type(sc, layout, PangoLayout__sym, __func__, 0))));
}

static s7_pointer lg_pango_layout_set_alignment(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_set_alignment "void pango_layout_set_alignment(PangoLayout* layout, PangoAlignment alignment)"
  s7_pointer _p;
  s7_pointer layout, alignment;
  _p = args;
  layout = s7_car(_p); _p = s7_cdr(_p);
  alignment = s7_car(_p);
  if (!s7_is_integer(alignment)) s7_wrong_type_arg_error(sc, "pango_layout_set_alignment", 2, alignment, "PangoAlignment");
  pango_layout_set_alignment((PangoLayout*)s7_c_pointer_with_type(sc, layout, PangoLayout__sym, __func__, 0), (PangoAlignment)s7_integer(alignment));
  return(lg_false);
}

static s7_pointer lg_pango_layout_get_alignment(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_get_alignment "PangoAlignment pango_layout_get_alignment(PangoLayout* layout)"
  s7_pointer layout;
  layout = s7_car(args);
  return(s7_make_integer(sc, pango_layout_get_alignment((PangoLayout*)s7_c_pointer_with_type(sc, layout, PangoLayout__sym, __func__, 0))));
}

static s7_pointer lg_pango_layout_set_tabs(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_set_tabs "void pango_layout_set_tabs(PangoLayout* layout, PangoTabArray* tabs)"
  s7_pointer _p;
  s7_pointer layout, tabs;
  _p = args;
  layout = s7_car(_p); _p = s7_cdr(_p);
  tabs = s7_car(_p);
  pango_layout_set_tabs((PangoLayout*)s7_c_pointer_with_type(sc, layout, PangoLayout__sym, __func__, 0), (PangoTabArray*)s7_c_pointer_with_type(sc, tabs, PangoTabArray__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_pango_layout_get_tabs(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_get_tabs "PangoTabArray* pango_layout_get_tabs(PangoLayout* layout)"
  s7_pointer layout;
  layout = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, PangoTabArray__sym, pango_layout_get_tabs((PangoLayout*)s7_c_pointer_with_type(sc, layout, PangoLayout__sym, __func__, 0))));
}

static s7_pointer lg_pango_layout_set_single_paragraph_mode(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_set_single_paragraph_mode "void pango_layout_set_single_paragraph_mode(PangoLayout* layout, \
gboolean setting)"
  s7_pointer _p;
  s7_pointer layout, setting;
  _p = args;
  layout = s7_car(_p); _p = s7_cdr(_p);
  setting = s7_car(_p);
  if (!s7_is_boolean(setting)) s7_wrong_type_arg_error(sc, "pango_layout_set_single_paragraph_mode", 2, setting, "gboolean");
  pango_layout_set_single_paragraph_mode((PangoLayout*)s7_c_pointer_with_type(sc, layout, PangoLayout__sym, __func__, 0), (gboolean)lg_boolean(setting));
  return(lg_false);
}

static s7_pointer lg_pango_layout_get_single_paragraph_mode(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_get_single_paragraph_mode "gboolean pango_layout_get_single_paragraph_mode(PangoLayout* layout)"
  s7_pointer layout;
  layout = s7_car(args);
  return(s7_make_boolean(sc, pango_layout_get_single_paragraph_mode((PangoLayout*)s7_c_pointer_with_type(sc, layout, PangoLayout__sym, __func__, 0))));
}

static s7_pointer lg_pango_layout_context_changed(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_context_changed "void pango_layout_context_changed(PangoLayout* layout)"
  s7_pointer layout;
  layout = s7_car(args);
  pango_layout_context_changed((PangoLayout*)s7_c_pointer_with_type(sc, layout, PangoLayout__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_pango_layout_get_log_attrs(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_get_log_attrs "void pango_layout_get_log_attrs(PangoLayout* layout, PangoLogAttr** [attrs], \
gint* [n_attrs])"
  s7_pointer _p;
  s7_pointer layout;
  PangoLogAttr* ref_attrs = NULL;
  gint ref_n_attrs;
  _p = args;
  layout = s7_car(_p);
  pango_layout_get_log_attrs((PangoLayout*)s7_c_pointer_with_type(sc, layout, PangoLayout__sym, __func__, 0), &ref_attrs, &ref_n_attrs);
    return(s7_list(sc, 2, s7_make_c_pointer(sc, ref_attrs), s7_make_integer(sc, ref_n_attrs)));
}

static s7_pointer lg_pango_layout_index_to_pos(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_index_to_pos "void pango_layout_index_to_pos(PangoLayout* layout, int index, \
PangoRectangle* pos)"
  s7_pointer _p;
  s7_pointer layout, index, pos;
  _p = args;
  layout = s7_car(_p); _p = s7_cdr(_p);
  index = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(index)) s7_wrong_type_arg_error(sc, "pango_layout_index_to_pos", 2, index, "int");
  pos = s7_car(_p);
  pango_layout_index_to_pos((PangoLayout*)s7_c_pointer_with_type(sc, layout, PangoLayout__sym, __func__, 0), (int)s7_integer(index), (PangoRectangle*)s7_c_pointer_with_type(sc, pos, PangoRectangle__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_pango_layout_get_cursor_pos(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_get_cursor_pos "void pango_layout_get_cursor_pos(PangoLayout* layout, int index, \
PangoRectangle* strong_pos, PangoRectangle* weak_pos)"
  s7_pointer _p;
  s7_pointer layout, index, strong_pos, weak_pos;
  _p = args;
  layout = s7_car(_p); _p = s7_cdr(_p);
  index = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(index)) s7_wrong_type_arg_error(sc, "pango_layout_get_cursor_pos", 2, index, "int");
  strong_pos = s7_car(_p); _p = s7_cdr(_p);
  weak_pos = s7_car(_p);
  pango_layout_get_cursor_pos((PangoLayout*)s7_c_pointer_with_type(sc, layout, PangoLayout__sym, __func__, 0), (int)s7_integer(index), (PangoRectangle*)s7_c_pointer_with_type(sc, strong_pos, PangoRectangle__sym, __func__, 0), (PangoRectangle*)s7_c_pointer_with_type(sc, weak_pos, PangoRectangle__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_pango_layout_move_cursor_visually(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_move_cursor_visually "void pango_layout_move_cursor_visually(PangoLayout* layout, \
gboolean strong, int old_index, int old_trailing, int direction, int* new_index, int* new_trailing)"
  s7_pointer _p;
  s7_pointer layout, strong, old_index, old_trailing, direction, new_index, new_trailing;
  _p = args;
  layout = s7_car(_p); _p = s7_cdr(_p);
  strong = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_boolean(strong)) s7_wrong_type_arg_error(sc, "pango_layout_move_cursor_visually", 2, strong, "gboolean");
  old_index = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(old_index)) s7_wrong_type_arg_error(sc, "pango_layout_move_cursor_visually", 3, old_index, "int");
  old_trailing = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(old_trailing)) s7_wrong_type_arg_error(sc, "pango_layout_move_cursor_visually", 4, old_trailing, "int");
  direction = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(direction)) s7_wrong_type_arg_error(sc, "pango_layout_move_cursor_visually", 5, direction, "int");
  new_index = s7_car(_p); _p = s7_cdr(_p);
  new_trailing = s7_car(_p);
  pango_layout_move_cursor_visually((PangoLayout*)s7_c_pointer_with_type(sc, layout, PangoLayout__sym, __func__, 0), (gboolean)lg_boolean(strong), (int)s7_integer(old_index), (int)s7_integer(old_trailing), (int)s7_integer(direction), (int*)s7_c_pointer_with_type(sc, new_index, int__sym, __func__, 0), (int*)s7_c_pointer_with_type(sc, new_trailing, int__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_pango_layout_xy_to_index(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_xy_to_index "gboolean pango_layout_xy_to_index(PangoLayout* layout, int x, int y, \
int* [index], int* [trailing])"
  s7_pointer _p;
  s7_pointer layout, x, y;
  int ref_index;
  int ref_trailing;
  _p = args;
  layout = s7_car(_p); _p = s7_cdr(_p);
  x = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(x)) s7_wrong_type_arg_error(sc, "pango_layout_xy_to_index", 2, x, "int");
  y = s7_car(_p);
  if (!s7_is_integer(y)) s7_wrong_type_arg_error(sc, "pango_layout_xy_to_index", 3, y, "int");
  {
    s7_pointer res_ult;
    res_ult = s7_make_boolean(sc, pango_layout_xy_to_index((PangoLayout*)s7_c_pointer_with_type(sc, layout, PangoLayout__sym, __func__, 0), (int)s7_integer(x), (int)s7_integer(y), &ref_index, &ref_trailing));
      return(s7_list(sc, 3, res_ult, s7_make_integer(sc, ref_index), s7_make_integer(sc, ref_trailing)));
   }
}

static s7_pointer lg_pango_layout_get_extents(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_get_extents "void pango_layout_get_extents(PangoLayout* layout, PangoRectangle* ink_rect, \
PangoRectangle* logical_rect)"
  s7_pointer _p;
  s7_pointer layout, ink_rect, logical_rect;
  _p = args;
  layout = s7_car(_p); _p = s7_cdr(_p);
  ink_rect = s7_car(_p); _p = s7_cdr(_p);
  logical_rect = s7_car(_p);
  pango_layout_get_extents((PangoLayout*)s7_c_pointer_with_type(sc, layout, PangoLayout__sym, __func__, 0), (PangoRectangle*)s7_c_pointer_with_type(sc, ink_rect, PangoRectangle__sym, __func__, 0), (PangoRectangle*)s7_c_pointer_with_type(sc, logical_rect, PangoRectangle__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_pango_layout_get_pixel_extents(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_get_pixel_extents "void pango_layout_get_pixel_extents(PangoLayout* layout, \
PangoRectangle* ink_rect, PangoRectangle* logical_rect)"
  s7_pointer _p;
  s7_pointer layout, ink_rect, logical_rect;
  _p = args;
  layout = s7_car(_p); _p = s7_cdr(_p);
  ink_rect = s7_car(_p); _p = s7_cdr(_p);
  logical_rect = s7_car(_p);
  pango_layout_get_pixel_extents((PangoLayout*)s7_c_pointer_with_type(sc, layout, PangoLayout__sym, __func__, 0), (PangoRectangle*)s7_c_pointer_with_type(sc, ink_rect, PangoRectangle__sym, __func__, 0), (PangoRectangle*)s7_c_pointer_with_type(sc, logical_rect, PangoRectangle__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_pango_layout_get_size(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_get_size "void pango_layout_get_size(PangoLayout* layout, int* [width], int* [height])"
  s7_pointer _p;
  s7_pointer layout;
  int ref_width;
  int ref_height;
  _p = args;
  layout = s7_car(_p);
  pango_layout_get_size((PangoLayout*)s7_c_pointer_with_type(sc, layout, PangoLayout__sym, __func__, 0), &ref_width, &ref_height);
    return(s7_list(sc, 2, s7_make_integer(sc, ref_width), s7_make_integer(sc, ref_height)));
}

static s7_pointer lg_pango_layout_get_pixel_size(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_get_pixel_size "void pango_layout_get_pixel_size(PangoLayout* layout, int* [width], \
int* [height])"
  s7_pointer _p;
  s7_pointer layout;
  int ref_width;
  int ref_height;
  _p = args;
  layout = s7_car(_p);
  pango_layout_get_pixel_size((PangoLayout*)s7_c_pointer_with_type(sc, layout, PangoLayout__sym, __func__, 0), &ref_width, &ref_height);
    return(s7_list(sc, 2, s7_make_integer(sc, ref_width), s7_make_integer(sc, ref_height)));
}

static s7_pointer lg_pango_layout_get_line_count(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_get_line_count "int pango_layout_get_line_count(PangoLayout* layout)"
  s7_pointer layout;
  layout = s7_car(args);
  return(s7_make_integer(sc, pango_layout_get_line_count((PangoLayout*)s7_c_pointer_with_type(sc, layout, PangoLayout__sym, __func__, 0))));
}

static s7_pointer lg_pango_layout_get_line(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_get_line "PangoLayoutLine* pango_layout_get_line(PangoLayout* layout, int line)"
  s7_pointer _p;
  s7_pointer layout, line;
  _p = args;
  layout = s7_car(_p); _p = s7_cdr(_p);
  line = s7_car(_p);
  if (!s7_is_integer(line)) s7_wrong_type_arg_error(sc, "pango_layout_get_line", 2, line, "int");
  return(lg_make_c_pointer_with_type(sc, PangoLayoutLine__sym, pango_layout_get_line((PangoLayout*)s7_c_pointer_with_type(sc, layout, PangoLayout__sym, __func__, 0), (int)s7_integer(line))));
}

static s7_pointer lg_pango_layout_get_lines(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_get_lines "GSList* pango_layout_get_lines(PangoLayout* layout)"
  s7_pointer layout;
  layout = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GSList__sym, pango_layout_get_lines((PangoLayout*)s7_c_pointer_with_type(sc, layout, PangoLayout__sym, __func__, 0))));
}

static s7_pointer lg_pango_layout_line_unref(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_line_unref "void pango_layout_line_unref(PangoLayoutLine* line)"
  s7_pointer line;
  line = s7_car(args);
  pango_layout_line_unref((PangoLayoutLine*)s7_c_pointer_with_type(sc, line, PangoLayoutLine__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_pango_layout_line_x_to_index(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_line_x_to_index "gboolean pango_layout_line_x_to_index(PangoLayoutLine* line, \
int x_pos, int* [index], int* [trailing])"
  s7_pointer _p;
  s7_pointer line, x_pos;
  int ref_index;
  int ref_trailing;
  _p = args;
  line = s7_car(_p); _p = s7_cdr(_p);
  x_pos = s7_car(_p);
  if (!s7_is_integer(x_pos)) s7_wrong_type_arg_error(sc, "pango_layout_line_x_to_index", 2, x_pos, "int");
  {
    s7_pointer res_ult;
    res_ult = s7_make_boolean(sc, pango_layout_line_x_to_index((PangoLayoutLine*)s7_c_pointer_with_type(sc, line, PangoLayoutLine__sym, __func__, 0), (int)s7_integer(x_pos), &ref_index, &ref_trailing));
      return(s7_list(sc, 3, res_ult, s7_make_integer(sc, ref_index), s7_make_integer(sc, ref_trailing)));
   }
}

static s7_pointer lg_pango_layout_line_index_to_x(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_line_index_to_x "void pango_layout_line_index_to_x(PangoLayoutLine* line, int index, \
gboolean trailing, int* [x_pos])"
  s7_pointer _p;
  s7_pointer line, index, trailing;
  int ref_x_pos;
  _p = args;
  line = s7_car(_p); _p = s7_cdr(_p);
  index = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(index)) s7_wrong_type_arg_error(sc, "pango_layout_line_index_to_x", 2, index, "int");
  trailing = s7_car(_p);
  if (!s7_is_boolean(trailing)) s7_wrong_type_arg_error(sc, "pango_layout_line_index_to_x", 3, trailing, "gboolean");
  pango_layout_line_index_to_x((PangoLayoutLine*)s7_c_pointer_with_type(sc, line, PangoLayoutLine__sym, __func__, 0), (int)s7_integer(index), (gboolean)lg_boolean(trailing), &ref_x_pos);
    return(s7_list(sc, 1, s7_make_integer(sc, ref_x_pos)));
}

static s7_pointer lg_pango_layout_line_get_x_ranges(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_line_get_x_ranges "void pango_layout_line_get_x_ranges(PangoLayoutLine* line, \
int start_index, int end_index, int** [ranges], int* [n_ranges])"
  s7_pointer _p;
  s7_pointer line, start_index, end_index;
  int* ref_ranges = NULL;
  int ref_n_ranges;
  _p = args;
  line = s7_car(_p); _p = s7_cdr(_p);
  start_index = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(start_index)) s7_wrong_type_arg_error(sc, "pango_layout_line_get_x_ranges", 2, start_index, "int");
  end_index = s7_car(_p);
  if (!s7_is_integer(end_index)) s7_wrong_type_arg_error(sc, "pango_layout_line_get_x_ranges", 3, end_index, "int");
  pango_layout_line_get_x_ranges((PangoLayoutLine*)s7_c_pointer_with_type(sc, line, PangoLayoutLine__sym, __func__, 0), (int)s7_integer(start_index), (int)s7_integer(end_index), &ref_ranges, &ref_n_ranges);
    return(s7_list(sc, 2, s7_make_c_pointer(sc, ref_ranges), s7_make_integer(sc, ref_n_ranges)));
}

static s7_pointer lg_pango_layout_line_get_extents(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_line_get_extents "void pango_layout_line_get_extents(PangoLayoutLine* line, \
PangoRectangle* ink_rect, PangoRectangle* logical_rect)"
  s7_pointer _p;
  s7_pointer line, ink_rect, logical_rect;
  _p = args;
  line = s7_car(_p); _p = s7_cdr(_p);
  ink_rect = s7_car(_p); _p = s7_cdr(_p);
  logical_rect = s7_car(_p);
  pango_layout_line_get_extents((PangoLayoutLine*)s7_c_pointer_with_type(sc, line, PangoLayoutLine__sym, __func__, 0), (PangoRectangle*)s7_c_pointer_with_type(sc, ink_rect, PangoRectangle__sym, __func__, 0), (PangoRectangle*)s7_c_pointer_with_type(sc, logical_rect, PangoRectangle__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_pango_layout_line_get_pixel_extents(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_line_get_pixel_extents "void pango_layout_line_get_pixel_extents(PangoLayoutLine* layout_line, \
PangoRectangle* ink_rect, PangoRectangle* logical_rect)"
  s7_pointer _p;
  s7_pointer layout_line, ink_rect, logical_rect;
  _p = args;
  layout_line = s7_car(_p); _p = s7_cdr(_p);
  ink_rect = s7_car(_p); _p = s7_cdr(_p);
  logical_rect = s7_car(_p);
  pango_layout_line_get_pixel_extents((PangoLayoutLine*)s7_c_pointer_with_type(sc, layout_line, PangoLayoutLine__sym, __func__, 0), (PangoRectangle*)s7_c_pointer_with_type(sc, ink_rect, PangoRectangle__sym, __func__, 0), (PangoRectangle*)s7_c_pointer_with_type(sc, logical_rect, PangoRectangle__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_pango_layout_get_iter(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_get_iter "PangoLayoutIter* pango_layout_get_iter(PangoLayout* layout)"
  s7_pointer layout;
  layout = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, PangoLayoutIter__sym, pango_layout_get_iter((PangoLayout*)s7_c_pointer_with_type(sc, layout, PangoLayout__sym, __func__, 0))));
}

static s7_pointer lg_pango_layout_iter_free(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_iter_free "void pango_layout_iter_free(PangoLayoutIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  pango_layout_iter_free((PangoLayoutIter*)s7_c_pointer_with_type(sc, iter, PangoLayoutIter__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_pango_layout_iter_get_index(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_iter_get_index "int pango_layout_iter_get_index(PangoLayoutIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  return(s7_make_integer(sc, pango_layout_iter_get_index((PangoLayoutIter*)s7_c_pointer_with_type(sc, iter, PangoLayoutIter__sym, __func__, 0))));
}

static s7_pointer lg_pango_layout_iter_get_run(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_iter_get_run "PangoLayoutRun* pango_layout_iter_get_run(PangoLayoutIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, PangoLayoutRun__sym, pango_layout_iter_get_run((PangoLayoutIter*)s7_c_pointer_with_type(sc, iter, PangoLayoutIter__sym, __func__, 0))));
}

static s7_pointer lg_pango_layout_iter_get_line(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_iter_get_line "PangoLayoutLine* pango_layout_iter_get_line(PangoLayoutIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, PangoLayoutLine__sym, pango_layout_iter_get_line((PangoLayoutIter*)s7_c_pointer_with_type(sc, iter, PangoLayoutIter__sym, __func__, 0))));
}

static s7_pointer lg_pango_layout_iter_at_last_line(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_iter_at_last_line "gboolean pango_layout_iter_at_last_line(PangoLayoutIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  return(s7_make_boolean(sc, pango_layout_iter_at_last_line((PangoLayoutIter*)s7_c_pointer_with_type(sc, iter, PangoLayoutIter__sym, __func__, 0))));
}

static s7_pointer lg_pango_layout_iter_next_char(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_iter_next_char "gboolean pango_layout_iter_next_char(PangoLayoutIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  return(s7_make_boolean(sc, pango_layout_iter_next_char((PangoLayoutIter*)s7_c_pointer_with_type(sc, iter, PangoLayoutIter__sym, __func__, 0))));
}

static s7_pointer lg_pango_layout_iter_next_cluster(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_iter_next_cluster "gboolean pango_layout_iter_next_cluster(PangoLayoutIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  return(s7_make_boolean(sc, pango_layout_iter_next_cluster((PangoLayoutIter*)s7_c_pointer_with_type(sc, iter, PangoLayoutIter__sym, __func__, 0))));
}

static s7_pointer lg_pango_layout_iter_next_run(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_iter_next_run "gboolean pango_layout_iter_next_run(PangoLayoutIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  return(s7_make_boolean(sc, pango_layout_iter_next_run((PangoLayoutIter*)s7_c_pointer_with_type(sc, iter, PangoLayoutIter__sym, __func__, 0))));
}

static s7_pointer lg_pango_layout_iter_next_line(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_iter_next_line "gboolean pango_layout_iter_next_line(PangoLayoutIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  return(s7_make_boolean(sc, pango_layout_iter_next_line((PangoLayoutIter*)s7_c_pointer_with_type(sc, iter, PangoLayoutIter__sym, __func__, 0))));
}

static s7_pointer lg_pango_layout_iter_get_char_extents(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_iter_get_char_extents "void pango_layout_iter_get_char_extents(PangoLayoutIter* iter, \
PangoRectangle* logical_rect)"
  s7_pointer _p;
  s7_pointer iter, logical_rect;
  _p = args;
  iter = s7_car(_p); _p = s7_cdr(_p);
  logical_rect = s7_car(_p);
  pango_layout_iter_get_char_extents((PangoLayoutIter*)s7_c_pointer_with_type(sc, iter, PangoLayoutIter__sym, __func__, 0), (PangoRectangle*)s7_c_pointer_with_type(sc, logical_rect, PangoRectangle__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_pango_layout_iter_get_cluster_extents(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_iter_get_cluster_extents "void pango_layout_iter_get_cluster_extents(PangoLayoutIter* iter, \
PangoRectangle* ink_rect, PangoRectangle* logical_rect)"
  s7_pointer _p;
  s7_pointer iter, ink_rect, logical_rect;
  _p = args;
  iter = s7_car(_p); _p = s7_cdr(_p);
  ink_rect = s7_car(_p); _p = s7_cdr(_p);
  logical_rect = s7_car(_p);
  pango_layout_iter_get_cluster_extents((PangoLayoutIter*)s7_c_pointer_with_type(sc, iter, PangoLayoutIter__sym, __func__, 0), (PangoRectangle*)s7_c_pointer_with_type(sc, ink_rect, PangoRectangle__sym, __func__, 0), (PangoRectangle*)s7_c_pointer_with_type(sc, logical_rect, PangoRectangle__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_pango_layout_iter_get_run_extents(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_iter_get_run_extents "void pango_layout_iter_get_run_extents(PangoLayoutIter* iter, \
PangoRectangle* ink_rect, PangoRectangle* logical_rect)"
  s7_pointer _p;
  s7_pointer iter, ink_rect, logical_rect;
  _p = args;
  iter = s7_car(_p); _p = s7_cdr(_p);
  ink_rect = s7_car(_p); _p = s7_cdr(_p);
  logical_rect = s7_car(_p);
  pango_layout_iter_get_run_extents((PangoLayoutIter*)s7_c_pointer_with_type(sc, iter, PangoLayoutIter__sym, __func__, 0), (PangoRectangle*)s7_c_pointer_with_type(sc, ink_rect, PangoRectangle__sym, __func__, 0), (PangoRectangle*)s7_c_pointer_with_type(sc, logical_rect, PangoRectangle__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_pango_layout_iter_get_line_extents(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_iter_get_line_extents "void pango_layout_iter_get_line_extents(PangoLayoutIter* iter, \
PangoRectangle* ink_rect, PangoRectangle* logical_rect)"
  s7_pointer _p;
  s7_pointer iter, ink_rect, logical_rect;
  _p = args;
  iter = s7_car(_p); _p = s7_cdr(_p);
  ink_rect = s7_car(_p); _p = s7_cdr(_p);
  logical_rect = s7_car(_p);
  pango_layout_iter_get_line_extents((PangoLayoutIter*)s7_c_pointer_with_type(sc, iter, PangoLayoutIter__sym, __func__, 0), (PangoRectangle*)s7_c_pointer_with_type(sc, ink_rect, PangoRectangle__sym, __func__, 0), (PangoRectangle*)s7_c_pointer_with_type(sc, logical_rect, PangoRectangle__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_pango_layout_iter_get_line_yrange(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_iter_get_line_yrange "void pango_layout_iter_get_line_yrange(PangoLayoutIter* iter, \
int* [y0], int* [y1])"
  s7_pointer _p;
  s7_pointer iter;
  int ref_y0;
  int ref_y1;
  _p = args;
  iter = s7_car(_p);
  pango_layout_iter_get_line_yrange((PangoLayoutIter*)s7_c_pointer_with_type(sc, iter, PangoLayoutIter__sym, __func__, 0), &ref_y0, &ref_y1);
    return(s7_list(sc, 2, s7_make_integer(sc, ref_y0), s7_make_integer(sc, ref_y1)));
}

static s7_pointer lg_pango_layout_iter_get_layout_extents(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_iter_get_layout_extents "void pango_layout_iter_get_layout_extents(PangoLayoutIter* iter, \
PangoRectangle* ink_rect, PangoRectangle* logical_rect)"
  s7_pointer _p;
  s7_pointer iter, ink_rect, logical_rect;
  _p = args;
  iter = s7_car(_p); _p = s7_cdr(_p);
  ink_rect = s7_car(_p); _p = s7_cdr(_p);
  logical_rect = s7_car(_p);
  pango_layout_iter_get_layout_extents((PangoLayoutIter*)s7_c_pointer_with_type(sc, iter, PangoLayoutIter__sym, __func__, 0), (PangoRectangle*)s7_c_pointer_with_type(sc, ink_rect, PangoRectangle__sym, __func__, 0), (PangoRectangle*)s7_c_pointer_with_type(sc, logical_rect, PangoRectangle__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_pango_layout_iter_get_baseline(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_iter_get_baseline "int pango_layout_iter_get_baseline(PangoLayoutIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  return(s7_make_integer(sc, pango_layout_iter_get_baseline((PangoLayoutIter*)s7_c_pointer_with_type(sc, iter, PangoLayoutIter__sym, __func__, 0))));
}

static s7_pointer lg_pango_language_from_string(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_language_from_string "PangoLanguage* pango_language_from_string(char* language)"
  s7_pointer language;
  language = s7_car(args);
  if (!s7_is_string(language)) s7_wrong_type_arg_error(sc, "pango_language_from_string", 1, language, "char*");
  return(lg_make_c_pointer_with_type(sc, PangoLanguage__sym, pango_language_from_string((char*)s7_string(language))));
}

static s7_pointer lg_pango_language_matches(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_language_matches "gboolean pango_language_matches(PangoLanguage* language, char* range_list)"
  s7_pointer _p;
  s7_pointer language, range_list;
  _p = args;
  language = s7_car(_p); _p = s7_cdr(_p);
  range_list = s7_car(_p);
  if (!s7_is_string(range_list)) s7_wrong_type_arg_error(sc, "pango_language_matches", 2, range_list, "char*");
  return(s7_make_boolean(sc, pango_language_matches((PangoLanguage*)s7_c_pointer_with_type(sc, language, PangoLanguage__sym, __func__, 0), (char*)s7_string(range_list))));
}

static s7_pointer lg_G_OBJECT_TYPE(s7_scheme *sc, s7_pointer args)
{
  #define H_G_OBJECT_TYPE "GType G_OBJECT_TYPE(GObject* object)"
  s7_pointer object;
  object = s7_car(args);
  return(s7_make_integer(sc, G_OBJECT_TYPE((GObject*)s7_c_pointer_with_type(sc, object, GObject__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_model_get_string_from_iter(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_model_get_string_from_iter "gchar* gtk_tree_model_get_string_from_iter(GtkTreeModel* tree_model, \
GtkTreeIter* iter)"
  s7_pointer _p;
  s7_pointer tree_model, iter;
  _p = args;
  tree_model = s7_car(_p); _p = s7_cdr(_p);
  iter = s7_car(_p);
  {
    gchar* res_ult;
    s7_pointer rtn;
    res_ult = gtk_tree_model_get_string_from_iter((GtkTreeModel*)s7_c_pointer_with_type(sc, tree_model, GtkTreeModel__sym, __func__, 0), (GtkTreeIter*)s7_c_pointer_with_type(sc, iter, GtkTreeIter__sym, __func__, 0));
    rtn = s7_make_string(sc, res_ult);
    g_free(res_ult);
    return(rtn);
  }
}

static s7_pointer lg_gtk_tree_model_sort_iter_is_valid(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_model_sort_iter_is_valid "gboolean gtk_tree_model_sort_iter_is_valid(GtkTreeModelSort* tree_model_sort, \
GtkTreeIter* iter)"
  s7_pointer _p;
  s7_pointer tree_model_sort, iter;
  _p = args;
  tree_model_sort = s7_car(_p); _p = s7_cdr(_p);
  iter = s7_car(_p);
  return(s7_make_boolean(sc, gtk_tree_model_sort_iter_is_valid((GtkTreeModelSort*)s7_c_pointer_with_type(sc, tree_model_sort, GtkTreeModelSort__sym, __func__, 0), (GtkTreeIter*)s7_c_pointer_with_type(sc, iter, GtkTreeIter__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_view_expand_to_path(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_expand_to_path "void gtk_tree_view_expand_to_path(GtkTreeView* tree_view, GtkTreePath* path)"
  s7_pointer _p;
  s7_pointer tree_view, path;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  path = s7_car(_p);
  gtk_tree_view_expand_to_path((GtkTreeView*)s7_c_pointer_with_type(sc, tree_view, GtkTreeView__sym, __func__, 0), (GtkTreePath*)s7_c_pointer_with_type(sc, path, GtkTreePath__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_selection_get_selected_rows(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_selection_get_selected_rows "GList* gtk_tree_selection_get_selected_rows(GtkTreeSelection* selection, \
GtkTreeModel** model)"
  s7_pointer _p;
  s7_pointer selection, model;
  _p = args;
  selection = s7_car(_p); _p = s7_cdr(_p);
  model = s7_car(_p);
  return(lg_make_c_pointer_with_type(sc, GList__sym, gtk_tree_selection_get_selected_rows((GtkTreeSelection*)s7_c_pointer_with_type(sc, selection, GtkTreeSelection__sym, __func__, 0), (GtkTreeModel**)s7_c_pointer_with_type(sc, model, GtkTreeModel___sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_selection_count_selected_rows(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_selection_count_selected_rows "int gtk_tree_selection_count_selected_rows(GtkTreeSelection* selection)"
  s7_pointer selection;
  selection = s7_car(args);
  return(s7_make_integer(sc, gtk_tree_selection_count_selected_rows((GtkTreeSelection*)s7_c_pointer_with_type(sc, selection, GtkTreeSelection__sym, __func__, 0))));
}

static s7_pointer lg_gtk_notebook_get_n_pages(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_notebook_get_n_pages "int gtk_notebook_get_n_pages(GtkNotebook* notebook)"
  s7_pointer notebook;
  notebook = s7_car(args);
  return(s7_make_integer(sc, gtk_notebook_get_n_pages((GtkNotebook*)s7_c_pointer_with_type(sc, notebook, GtkNotebook__sym, __func__, 0))));
}

static s7_pointer lg_gtk_list_store_reorder(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_list_store_reorder "void gtk_list_store_reorder(GtkListStore* store, int* new_order)"
  s7_pointer _p;
  s7_pointer store, new_order;
  _p = args;
  store = s7_car(_p); _p = s7_cdr(_p);
  new_order = s7_car(_p);
  gtk_list_store_reorder((GtkListStore*)s7_c_pointer_with_type(sc, store, GtkListStore__sym, __func__, 0), (int*)s7_c_pointer_with_type(sc, new_order, int__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_list_store_swap(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_list_store_swap "void gtk_list_store_swap(GtkListStore* store, GtkTreeIter* a, GtkTreeIter* b)"
  s7_pointer _p;
  s7_pointer store, a, b;
  _p = args;
  store = s7_car(_p); _p = s7_cdr(_p);
  a = s7_car(_p); _p = s7_cdr(_p);
  b = s7_car(_p);
  gtk_list_store_swap((GtkListStore*)s7_c_pointer_with_type(sc, store, GtkListStore__sym, __func__, 0), (GtkTreeIter*)s7_c_pointer_with_type(sc, a, GtkTreeIter__sym, __func__, 0), (GtkTreeIter*)s7_c_pointer_with_type(sc, b, GtkTreeIter__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_list_store_move_after(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_list_store_move_after "void gtk_list_store_move_after(GtkListStore* store, GtkTreeIter* iter, \
GtkTreeIter* position)"
  s7_pointer _p;
  s7_pointer store, iter, position;
  _p = args;
  store = s7_car(_p); _p = s7_cdr(_p);
  iter = s7_car(_p); _p = s7_cdr(_p);
  position = s7_car(_p);
  gtk_list_store_move_after((GtkListStore*)s7_c_pointer_with_type(sc, store, GtkListStore__sym, __func__, 0), (GtkTreeIter*)s7_c_pointer_with_type(sc, iter, GtkTreeIter__sym, __func__, 0), (GtkTreeIter*)s7_c_pointer_with_type(sc, position, GtkTreeIter__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_list_store_move_before(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_list_store_move_before "void gtk_list_store_move_before(GtkListStore* store, GtkTreeIter* iter, \
GtkTreeIter* position)"
  s7_pointer _p;
  s7_pointer store, iter, position;
  _p = args;
  store = s7_car(_p); _p = s7_cdr(_p);
  iter = s7_car(_p); _p = s7_cdr(_p);
  position = s7_car(_p);
  gtk_list_store_move_before((GtkListStore*)s7_c_pointer_with_type(sc, store, GtkListStore__sym, __func__, 0), (GtkTreeIter*)s7_c_pointer_with_type(sc, iter, GtkTreeIter__sym, __func__, 0), (GtkTreeIter*)s7_c_pointer_with_type(sc, position, GtkTreeIter__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_store_reorder(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_store_reorder "void gtk_tree_store_reorder(GtkTreeStore* tree_store, GtkTreeIter* parent, \
int* new_order)"
  s7_pointer _p;
  s7_pointer tree_store, parent, new_order;
  _p = args;
  tree_store = s7_car(_p); _p = s7_cdr(_p);
  parent = s7_car(_p); _p = s7_cdr(_p);
  new_order = s7_car(_p);
  gtk_tree_store_reorder((GtkTreeStore*)s7_c_pointer_with_type(sc, tree_store, GtkTreeStore__sym, __func__, 0), (GtkTreeIter*)s7_c_pointer_with_type(sc, parent, GtkTreeIter__sym, __func__, 0), (int*)s7_c_pointer_with_type(sc, new_order, int__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_store_swap(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_store_swap "void gtk_tree_store_swap(GtkTreeStore* tree_store, GtkTreeIter* a, GtkTreeIter* b)"
  s7_pointer _p;
  s7_pointer tree_store, a, b;
  _p = args;
  tree_store = s7_car(_p); _p = s7_cdr(_p);
  a = s7_car(_p); _p = s7_cdr(_p);
  b = s7_car(_p);
  gtk_tree_store_swap((GtkTreeStore*)s7_c_pointer_with_type(sc, tree_store, GtkTreeStore__sym, __func__, 0), (GtkTreeIter*)s7_c_pointer_with_type(sc, a, GtkTreeIter__sym, __func__, 0), (GtkTreeIter*)s7_c_pointer_with_type(sc, b, GtkTreeIter__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gdk_display_open(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_display_open "GdkDisplay* gdk_display_open(gchar* display_name)"
  s7_pointer display_name;
  display_name = s7_car(args);
  if (!s7_is_string(display_name)) s7_wrong_type_arg_error(sc, "gdk_display_open", 1, display_name, "gchar*");
  return(lg_make_c_pointer_with_type(sc, GdkDisplay__sym, gdk_display_open((gchar*)s7_string(display_name))));
}

static s7_pointer lg_gdk_display_get_name(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_display_get_name "gchar* gdk_display_get_name(GdkDisplay* display)"
  s7_pointer display;
  display = s7_car(args);
  return(s7_make_string(sc, gdk_display_get_name((GdkDisplay*)s7_c_pointer_with_type(sc, display, GdkDisplay__sym, __func__, 0))));
}

static s7_pointer lg_gdk_display_beep(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_display_beep "void gdk_display_beep(GdkDisplay* display)"
  s7_pointer display;
  display = s7_car(args);
  gdk_display_beep((GdkDisplay*)s7_c_pointer_with_type(sc, display, GdkDisplay__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gdk_display_sync(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_display_sync "void gdk_display_sync(GdkDisplay* display)"
  s7_pointer display;
  display = s7_car(args);
  gdk_display_sync((GdkDisplay*)s7_c_pointer_with_type(sc, display, GdkDisplay__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gdk_display_close(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_display_close "void gdk_display_close(GdkDisplay* display)"
  s7_pointer display;
  display = s7_car(args);
  gdk_display_close((GdkDisplay*)s7_c_pointer_with_type(sc, display, GdkDisplay__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gdk_display_put_event(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_display_put_event "void gdk_display_put_event(GdkDisplay* display, GdkEvent* event)"
  s7_pointer _p;
  s7_pointer display, event;
  _p = args;
  display = s7_car(_p); _p = s7_cdr(_p);
  event = s7_car(_p);
  gdk_display_put_event((GdkDisplay*)s7_c_pointer_with_type(sc, display, GdkDisplay__sym, __func__, 0), (GdkEvent*)s7_c_pointer_with_type(sc, event, GdkEvent__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gdk_display_get_default(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_display_get_default "GdkDisplay* gdk_display_get_default( void)"
  return(lg_make_c_pointer_with_type(sc, GdkDisplay__sym, gdk_display_get_default()));
}

static s7_pointer lg_gtk_widget_get_display(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_get_display "GdkDisplay* gtk_widget_get_display(GtkWidget* widget)"
  s7_pointer widget;
  widget = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GdkDisplay__sym, gtk_widget_get_display((GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0))));
}

static s7_pointer lg_g_list_free(s7_scheme *sc, s7_pointer args)
{
  #define H_g_list_free "void g_list_free(GList* list)"
  s7_pointer list;
  list = s7_car(args);
  g_list_free((GList*)s7_c_pointer_with_type(sc, list, GList__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_g_list_reverse(s7_scheme *sc, s7_pointer args)
{
  #define H_g_list_reverse "GList* g_list_reverse(GList* list)"
  s7_pointer list;
  list = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GList__sym, g_list_reverse((GList*)s7_c_pointer_with_type(sc, list, GList__sym, __func__, 0))));
}

static s7_pointer lg_g_list_copy(s7_scheme *sc, s7_pointer args)
{
  #define H_g_list_copy "GList* g_list_copy(GList* list)"
  s7_pointer list;
  list = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GList__sym, g_list_copy((GList*)s7_c_pointer_with_type(sc, list, GList__sym, __func__, 0))));
}

static s7_pointer lg_g_list_last(s7_scheme *sc, s7_pointer args)
{
  #define H_g_list_last "GList* g_list_last(GList* list)"
  s7_pointer list;
  list = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GList__sym, g_list_last((GList*)s7_c_pointer_with_type(sc, list, GList__sym, __func__, 0))));
}

static s7_pointer lg_g_list_first(s7_scheme *sc, s7_pointer args)
{
  #define H_g_list_first "GList* g_list_first(GList* list)"
  s7_pointer list;
  list = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GList__sym, g_list_first((GList*)s7_c_pointer_with_type(sc, list, GList__sym, __func__, 0))));
}

static s7_pointer lg_g_list_length(s7_scheme *sc, s7_pointer args)
{
  #define H_g_list_length "guint g_list_length(GList* list)"
  s7_pointer list;
  list = s7_car(args);
  return(s7_make_integer(sc, g_list_length((GList*)s7_c_pointer_with_type(sc, list, GList__sym, __func__, 0))));
}

static s7_pointer lg_g_free(s7_scheme *sc, s7_pointer args)
{
  #define H_g_free "void g_free(gpointer mem)"
  s7_pointer mem;
  mem = s7_car(args);
  g_free((gpointer)s7_c_pointer_with_type(sc, mem, gpointer_sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_g_list_remove_link(s7_scheme *sc, s7_pointer args)
{
  #define H_g_list_remove_link "GList* g_list_remove_link(GList* list, GList* llink)"
  s7_pointer _p;
  s7_pointer list, llink;
  _p = args;
  list = s7_car(_p); _p = s7_cdr(_p);
  llink = s7_car(_p);
  return(lg_make_c_pointer_with_type(sc, GList__sym, g_list_remove_link((GList*)s7_c_pointer_with_type(sc, list, GList__sym, __func__, 0), (GList*)s7_c_pointer_with_type(sc, llink, GList__sym, __func__, 0))));
}

static s7_pointer lg_g_object_get_data(s7_scheme *sc, s7_pointer args)
{
  #define H_g_object_get_data "gpointer g_object_get_data(GObject* object, gchar* key)"
  s7_pointer _p;
  s7_pointer object, key;
  _p = args;
  object = s7_car(_p); _p = s7_cdr(_p);
  key = s7_car(_p);
  if (!s7_is_string(key)) s7_wrong_type_arg_error(sc, "g_object_get_data", 2, key, "gchar*");
  return(lg_make_c_pointer_with_type(sc, gpointer_sym, g_object_get_data((GObject*)s7_c_pointer_with_type(sc, object, GObject__sym, __func__, 0), (const gchar*)s7_string(key))));
}

static s7_pointer lg_g_object_set_data(s7_scheme *sc, s7_pointer args)
{
  #define H_g_object_set_data "void g_object_set_data(GObject* object, gchar* key, gpointer data)"
  s7_pointer _p;
  s7_pointer object, key, data;
  _p = args;
  object = s7_car(_p); _p = s7_cdr(_p);
  key = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(key)) s7_wrong_type_arg_error(sc, "g_object_set_data", 2, key, "gchar*");
  data = s7_car(_p);
  g_object_set_data((GObject*)s7_c_pointer_with_type(sc, object, GObject__sym, __func__, 0), (const gchar*)s7_string(key), (gpointer)s7_c_pointer_with_type(sc, data, gpointer_sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gdk_display_flush(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_display_flush "void gdk_display_flush(GdkDisplay* display)"
  s7_pointer display;
  display = s7_car(args);
  gdk_display_flush((GdkDisplay*)s7_c_pointer_with_type(sc, display, GdkDisplay__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_entry_set_completion(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_set_completion "void gtk_entry_set_completion(GtkEntry* entry, GtkEntryCompletion* completion)"
  s7_pointer _p;
  s7_pointer entry, completion;
  _p = args;
  entry = s7_car(_p); _p = s7_cdr(_p);
  completion = s7_car(_p);
  gtk_entry_set_completion((GtkEntry*)s7_c_pointer_with_type(sc, entry, GtkEntry__sym, __func__, 0), (GtkEntryCompletion*)s7_c_pointer_with_type(sc, completion, GtkEntryCompletion__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_entry_get_completion(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_get_completion "GtkEntryCompletion* gtk_entry_get_completion(GtkEntry* entry)"
  s7_pointer entry;
  entry = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GtkEntryCompletion__sym, gtk_entry_get_completion((GtkEntry*)s7_c_pointer_with_type(sc, entry, GtkEntry__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_buffer_select_range(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_select_range "void gtk_text_buffer_select_range(GtkTextBuffer* buffer, GtkTextIter* ins, \
GtkTextIter* bound)"
  s7_pointer _p;
  s7_pointer buffer, ins, bound;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  ins = s7_car(_p); _p = s7_cdr(_p);
  bound = s7_car(_p);
  gtk_text_buffer_select_range((GtkTextBuffer*)s7_c_pointer_with_type(sc, buffer, GtkTextBuffer__sym, __func__, 0), (GtkTextIter*)s7_c_pointer_with_type(sc, ins, GtkTextIter__sym, __func__, 0), (GtkTextIter*)s7_c_pointer_with_type(sc, bound, GtkTextIter__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_text_view_set_overwrite(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_set_overwrite "void gtk_text_view_set_overwrite(GtkTextView* text_view, gboolean overwrite)"
  s7_pointer _p;
  s7_pointer text_view, overwrite;
  _p = args;
  text_view = s7_car(_p); _p = s7_cdr(_p);
  overwrite = s7_car(_p);
  if (!s7_is_boolean(overwrite)) s7_wrong_type_arg_error(sc, "gtk_text_view_set_overwrite", 2, overwrite, "gboolean");
  gtk_text_view_set_overwrite((GtkTextView*)s7_c_pointer_with_type(sc, text_view, GtkTextView__sym, __func__, 0), (gboolean)lg_boolean(overwrite));
  return(lg_false);
}

static s7_pointer lg_gtk_text_view_get_overwrite(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_get_overwrite "gboolean gtk_text_view_get_overwrite(GtkTextView* text_view)"
  s7_pointer text_view;
  text_view = s7_car(args);
  return(s7_make_boolean(sc, gtk_text_view_get_overwrite((GtkTextView*)s7_c_pointer_with_type(sc, text_view, GtkTextView__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_view_set_accepts_tab(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_set_accepts_tab "void gtk_text_view_set_accepts_tab(GtkTextView* text_view, \
gboolean accepts_tab)"
  s7_pointer _p;
  s7_pointer text_view, accepts_tab;
  _p = args;
  text_view = s7_car(_p); _p = s7_cdr(_p);
  accepts_tab = s7_car(_p);
  if (!s7_is_boolean(accepts_tab)) s7_wrong_type_arg_error(sc, "gtk_text_view_set_accepts_tab", 2, accepts_tab, "gboolean");
  gtk_text_view_set_accepts_tab((GtkTextView*)s7_c_pointer_with_type(sc, text_view, GtkTextView__sym, __func__, 0), (gboolean)lg_boolean(accepts_tab));
  return(lg_false);
}

static s7_pointer lg_gtk_text_view_get_accepts_tab(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_get_accepts_tab "gboolean gtk_text_view_get_accepts_tab(GtkTextView* text_view)"
  s7_pointer text_view;
  text_view = s7_car(args);
  return(s7_make_boolean(sc, gtk_text_view_get_accepts_tab((GtkTextView*)s7_c_pointer_with_type(sc, text_view, GtkTextView__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_view_column_set_expand(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_set_expand "void gtk_tree_view_column_set_expand(GtkTreeViewColumn* tree_column, \
gboolean expand)"
  s7_pointer _p;
  s7_pointer tree_column, expand;
  _p = args;
  tree_column = s7_car(_p); _p = s7_cdr(_p);
  expand = s7_car(_p);
  if (!s7_is_boolean(expand)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_set_expand", 2, expand, "gboolean");
  gtk_tree_view_column_set_expand((GtkTreeViewColumn*)s7_c_pointer_with_type(sc, tree_column, GtkTreeViewColumn__sym, __func__, 0), (gboolean)lg_boolean(expand));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_column_get_expand(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_get_expand "gboolean gtk_tree_view_column_get_expand(GtkTreeViewColumn* tree_column)"
  s7_pointer tree_column;
  tree_column = s7_car(args);
  return(s7_make_boolean(sc, gtk_tree_view_column_get_expand((GtkTreeViewColumn*)s7_c_pointer_with_type(sc, tree_column, GtkTreeViewColumn__sym, __func__, 0))));
}

static s7_pointer lg_gtk_file_chooser_dialog_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_file_chooser_dialog_new "GtkWidget* gtk_file_chooser_dialog_new(gchar* title, GtkWindow* parent, \
GtkFileChooserAction action, etc buttons)"
  s7_pointer _p;
  s7_pointer title, parent, action, buttons;
  _p = args;
  title = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(title)) s7_wrong_type_arg_error(sc, "gtk_file_chooser_dialog_new", 1, title, "gchar*");
  parent = s7_car(_p); _p = s7_cdr(_p);
  action = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(action)) s7_wrong_type_arg_error(sc, "gtk_file_chooser_dialog_new", 3, action, "GtkFileChooserAction");
  buttons = s7_car(_p);
  if ((!lg_is_list(buttons)) && (buttons != lg_false)) s7_wrong_type_arg_error(sc, "gtk_file_chooser_dialog_new", 4, buttons, "etc");
  {
    int etc_len = 0;
    GtkWidget* res_ult = NULL;
    gchar* p_arg0;
    GtkWindow* p_arg1;
    GtkFileChooserAction p_arg2;
    if (s7_is_list(sc, buttons)) etc_len = s7_list_length(sc, buttons);
    if (etc_len > 10) s7_out_of_range_error(sc, "gtk_file_chooser_dialog_new", 3, buttons, "... list too long (max len: 10)");
    if ((etc_len % 2) != 0) s7_out_of_range_error(sc, "gtk_file_chooser_dialog_new", 3, buttons, "... list len must be multiple of 2");
    p_arg0 = (gchar*)s7_string(title);
    p_arg1 = (GtkWindow*)s7_c_pointer_with_type(sc, parent, GtkWindow__sym, __func__, 0);
    p_arg2 = (GtkFileChooserAction)s7_integer(action);
    switch (etc_len)
      {
        case 0: res_ult = gtk_file_chooser_dialog_new(p_arg0, p_arg1, p_arg2, NULL, NULL); break;
        case 2: res_ult = gtk_file_chooser_dialog_new(p_arg0, p_arg1, p_arg2, s7_string(s7_list_ref(sc, buttons, 0)), s7_integer(s7_list_ref(sc, buttons, 1)), NULL); break;
        case 4: res_ult = gtk_file_chooser_dialog_new(p_arg0, p_arg1, p_arg2, s7_string(s7_list_ref(sc, buttons, 0)), s7_integer(s7_list_ref(sc, buttons, 1)), s7_string(s7_list_ref(sc, buttons, 2)), s7_integer(s7_list_ref(sc, buttons, 3)), NULL); break;
        case 6: res_ult = gtk_file_chooser_dialog_new(p_arg0, p_arg1, p_arg2, s7_string(s7_list_ref(sc, buttons, 0)), s7_integer(s7_list_ref(sc, buttons, 1)), s7_string(s7_list_ref(sc, buttons, 2)), s7_integer(s7_list_ref(sc, buttons, 3)), s7_string(s7_list_ref(sc, buttons, 4)), s7_integer(s7_list_ref(sc, buttons, 5)), NULL); break;
        case 8: res_ult = gtk_file_chooser_dialog_new(p_arg0, p_arg1, p_arg2, s7_string(s7_list_ref(sc, buttons, 0)), s7_integer(s7_list_ref(sc, buttons, 1)), s7_string(s7_list_ref(sc, buttons, 2)), s7_integer(s7_list_ref(sc, buttons, 3)), s7_string(s7_list_ref(sc, buttons, 4)), s7_integer(s7_list_ref(sc, buttons, 5)), s7_string(s7_list_ref(sc, buttons, 6)), s7_integer(s7_list_ref(sc, buttons, 7)), NULL); break;
        case 10: res_ult = gtk_file_chooser_dialog_new(p_arg0, p_arg1, p_arg2, s7_string(s7_list_ref(sc, buttons, 0)), s7_integer(s7_list_ref(sc, buttons, 1)), s7_string(s7_list_ref(sc, buttons, 2)), s7_integer(s7_list_ref(sc, buttons, 3)), s7_string(s7_list_ref(sc, buttons, 4)), s7_integer(s7_list_ref(sc, buttons, 5)), s7_string(s7_list_ref(sc, buttons, 6)), s7_integer(s7_list_ref(sc, buttons, 7)), s7_string(s7_list_ref(sc, buttons, 8)), s7_integer(s7_list_ref(sc, buttons, 9)), NULL); break;
      }
    return(s7_make_c_pointer(sc, res_ult));
  }
}

static s7_pointer lg_gtk_file_chooser_widget_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_file_chooser_widget_new "GtkWidget* gtk_file_chooser_widget_new(GtkFileChooserAction action)"
  s7_pointer action;
  action = s7_car(args);
  if (!s7_is_integer(action)) s7_wrong_type_arg_error(sc, "gtk_file_chooser_widget_new", 1, action, "GtkFileChooserAction");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_file_chooser_widget_new((GtkFileChooserAction)s7_integer(action))));
}

static s7_pointer lg_gtk_tree_model_filter_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_model_filter_new "GtkTreeModel* gtk_tree_model_filter_new(GtkTreeModel* child_model, \
GtkTreePath* root)"
  s7_pointer _p;
  s7_pointer child_model, root;
  _p = args;
  child_model = s7_car(_p); _p = s7_cdr(_p);
  root = s7_car(_p);
  return(lg_make_c_pointer_with_type(sc, GtkTreeModel__sym, gtk_tree_model_filter_new((GtkTreeModel*)s7_c_pointer_with_type(sc, child_model, GtkTreeModel__sym, __func__, 0), (GtkTreePath*)s7_c_pointer_with_type(sc, root, GtkTreePath__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_model_filter_set_visible_column(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_model_filter_set_visible_column "void gtk_tree_model_filter_set_visible_column(GtkTreeModelFilter* filter, \
gint column)"
  s7_pointer _p;
  s7_pointer filter, column;
  _p = args;
  filter = s7_car(_p); _p = s7_cdr(_p);
  column = s7_car(_p);
  if (!s7_is_integer(column)) s7_wrong_type_arg_error(sc, "gtk_tree_model_filter_set_visible_column", 2, column, "gint");
  gtk_tree_model_filter_set_visible_column((GtkTreeModelFilter*)s7_c_pointer_with_type(sc, filter, GtkTreeModelFilter__sym, __func__, 0), (gint)s7_integer(column));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_model_filter_get_model(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_model_filter_get_model "GtkTreeModel* gtk_tree_model_filter_get_model(GtkTreeModelFilter* filter)"
  s7_pointer filter;
  filter = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GtkTreeModel__sym, gtk_tree_model_filter_get_model((GtkTreeModelFilter*)s7_c_pointer_with_type(sc, filter, GtkTreeModelFilter__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_model_filter_convert_iter_to_child_iter(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_model_filter_convert_iter_to_child_iter "void gtk_tree_model_filter_convert_iter_to_child_iter(GtkTreeModelFilter* filter, \
GtkTreeIter* child_iter, GtkTreeIter* filter_iter)"
  s7_pointer _p;
  s7_pointer filter, child_iter, filter_iter;
  _p = args;
  filter = s7_car(_p); _p = s7_cdr(_p);
  child_iter = s7_car(_p); _p = s7_cdr(_p);
  filter_iter = s7_car(_p);
  gtk_tree_model_filter_convert_iter_to_child_iter((GtkTreeModelFilter*)s7_c_pointer_with_type(sc, filter, GtkTreeModelFilter__sym, __func__, 0), (GtkTreeIter*)s7_c_pointer_with_type(sc, child_iter, GtkTreeIter__sym, __func__, 0), (GtkTreeIter*)s7_c_pointer_with_type(sc, filter_iter, GtkTreeIter__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_model_filter_convert_child_path_to_path(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_model_filter_convert_child_path_to_path "GtkTreePath* gtk_tree_model_filter_convert_child_path_to_path(GtkTreeModelFilter* filter, \
GtkTreePath* child_path)"
  s7_pointer _p;
  s7_pointer filter, child_path;
  _p = args;
  filter = s7_car(_p); _p = s7_cdr(_p);
  child_path = s7_car(_p);
  return(lg_make_c_pointer_with_type(sc, GtkTreePath__sym, gtk_tree_model_filter_convert_child_path_to_path((GtkTreeModelFilter*)s7_c_pointer_with_type(sc, filter, GtkTreeModelFilter__sym, __func__, 0), (GtkTreePath*)s7_c_pointer_with_type(sc, child_path, GtkTreePath__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_model_filter_convert_path_to_child_path(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_model_filter_convert_path_to_child_path "GtkTreePath* gtk_tree_model_filter_convert_path_to_child_path(GtkTreeModelFilter* path, \
GtkTreePath* filter_path)"
  s7_pointer _p;
  s7_pointer path, filter_path;
  _p = args;
  path = s7_car(_p); _p = s7_cdr(_p);
  filter_path = s7_car(_p);
  return(lg_make_c_pointer_with_type(sc, GtkTreePath__sym, gtk_tree_model_filter_convert_path_to_child_path((GtkTreeModelFilter*)s7_c_pointer_with_type(sc, path, GtkTreeModelFilter__sym, __func__, 0), (GtkTreePath*)s7_c_pointer_with_type(sc, filter_path, GtkTreePath__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_model_filter_refilter(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_model_filter_refilter "void gtk_tree_model_filter_refilter(GtkTreeModelFilter* filter)"
  s7_pointer filter;
  filter = s7_car(args);
  gtk_tree_model_filter_refilter((GtkTreeModelFilter*)s7_c_pointer_with_type(sc, filter, GtkTreeModelFilter__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_model_filter_clear_cache(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_model_filter_clear_cache "void gtk_tree_model_filter_clear_cache(GtkTreeModelFilter* filter)"
  s7_pointer filter;
  filter = s7_car(args);
  gtk_tree_model_filter_clear_cache((GtkTreeModelFilter*)s7_c_pointer_with_type(sc, filter, GtkTreeModelFilter__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_combo_box_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_combo_box_new "GtkWidget* gtk_combo_box_new( void)"
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_combo_box_new()));
}

static s7_pointer lg_gtk_combo_box_new_with_model(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_combo_box_new_with_model "GtkWidget* gtk_combo_box_new_with_model(GtkTreeModel* model)"
  s7_pointer model;
  model = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_combo_box_new_with_model((GtkTreeModel*)s7_c_pointer_with_type(sc, model, GtkTreeModel__sym, __func__, 0))));
}

static s7_pointer lg_gtk_combo_box_set_model(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_combo_box_set_model "void gtk_combo_box_set_model(GtkComboBox* combo_box, GtkTreeModel* model)"
  s7_pointer _p;
  s7_pointer combo_box, model;
  _p = args;
  combo_box = s7_car(_p); _p = s7_cdr(_p);
  model = s7_car(_p);
  gtk_combo_box_set_model((GtkComboBox*)s7_c_pointer_with_type(sc, combo_box, GtkComboBox__sym, __func__, 0), (GtkTreeModel*)s7_c_pointer_with_type(sc, model, GtkTreeModel__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_combo_box_get_active(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_combo_box_get_active "gint gtk_combo_box_get_active(GtkComboBox* combo_box)"
  s7_pointer combo_box;
  combo_box = s7_car(args);
  return(s7_make_integer(sc, gtk_combo_box_get_active((GtkComboBox*)s7_c_pointer_with_type(sc, combo_box, GtkComboBox__sym, __func__, 0))));
}

static s7_pointer lg_gtk_combo_box_set_active(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_combo_box_set_active "void gtk_combo_box_set_active(GtkComboBox* combo_box, gint index)"
  s7_pointer _p;
  s7_pointer combo_box, index;
  _p = args;
  combo_box = s7_car(_p); _p = s7_cdr(_p);
  index = s7_car(_p);
  if (!s7_is_integer(index)) s7_wrong_type_arg_error(sc, "gtk_combo_box_set_active", 2, index, "gint");
  gtk_combo_box_set_active((GtkComboBox*)s7_c_pointer_with_type(sc, combo_box, GtkComboBox__sym, __func__, 0), (gint)s7_integer(index));
  return(lg_false);
}

static s7_pointer lg_gtk_combo_box_get_active_iter(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_combo_box_get_active_iter "gboolean gtk_combo_box_get_active_iter(GtkComboBox* combo_box, \
GtkTreeIter* iter)"
  s7_pointer _p;
  s7_pointer combo_box, iter;
  _p = args;
  combo_box = s7_car(_p); _p = s7_cdr(_p);
  iter = s7_car(_p);
  return(s7_make_boolean(sc, gtk_combo_box_get_active_iter((GtkComboBox*)s7_c_pointer_with_type(sc, combo_box, GtkComboBox__sym, __func__, 0), (GtkTreeIter*)s7_c_pointer_with_type(sc, iter, GtkTreeIter__sym, __func__, 0))));
}

static s7_pointer lg_gtk_combo_box_set_active_iter(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_combo_box_set_active_iter "void gtk_combo_box_set_active_iter(GtkComboBox* combo_box, \
GtkTreeIter* iter)"
  s7_pointer _p;
  s7_pointer combo_box, iter;
  _p = args;
  combo_box = s7_car(_p); _p = s7_cdr(_p);
  iter = s7_car(_p);
  gtk_combo_box_set_active_iter((GtkComboBox*)s7_c_pointer_with_type(sc, combo_box, GtkComboBox__sym, __func__, 0), (GtkTreeIter*)s7_c_pointer_with_type(sc, iter, GtkTreeIter__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_combo_box_get_model(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_combo_box_get_model "GtkTreeModel* gtk_combo_box_get_model(GtkComboBox* combo_box)"
  s7_pointer combo_box;
  combo_box = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GtkTreeModel__sym, gtk_combo_box_get_model((GtkComboBox*)s7_c_pointer_with_type(sc, combo_box, GtkComboBox__sym, __func__, 0))));
}

static s7_pointer lg_gtk_expander_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_expander_new "GtkWidget* gtk_expander_new(gchar* label)"
  s7_pointer label;
  label = s7_car(args);
  if (!s7_is_string(label)) s7_wrong_type_arg_error(sc, "gtk_expander_new", 1, label, "gchar*");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_expander_new((gchar*)s7_string(label))));
}

static s7_pointer lg_gtk_expander_new_with_mnemonic(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_expander_new_with_mnemonic "GtkWidget* gtk_expander_new_with_mnemonic(gchar* label)"
  s7_pointer label;
  label = s7_car(args);
  if (!s7_is_string(label)) s7_wrong_type_arg_error(sc, "gtk_expander_new_with_mnemonic", 1, label, "gchar*");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_expander_new_with_mnemonic((gchar*)s7_string(label))));
}

static s7_pointer lg_gtk_expander_set_expanded(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_expander_set_expanded "void gtk_expander_set_expanded(GtkExpander* expander, gboolean expanded)"
  s7_pointer _p;
  s7_pointer expander, expanded;
  _p = args;
  expander = s7_car(_p); _p = s7_cdr(_p);
  expanded = s7_car(_p);
  if (!s7_is_boolean(expanded)) s7_wrong_type_arg_error(sc, "gtk_expander_set_expanded", 2, expanded, "gboolean");
  gtk_expander_set_expanded((GtkExpander*)s7_c_pointer_with_type(sc, expander, GtkExpander__sym, __func__, 0), (gboolean)lg_boolean(expanded));
  return(lg_false);
}

static s7_pointer lg_gtk_expander_get_expanded(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_expander_get_expanded "gboolean gtk_expander_get_expanded(GtkExpander* expander)"
  s7_pointer expander;
  expander = s7_car(args);
  return(s7_make_boolean(sc, gtk_expander_get_expanded((GtkExpander*)s7_c_pointer_with_type(sc, expander, GtkExpander__sym, __func__, 0))));
}

static s7_pointer lg_gtk_expander_set_label(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_expander_set_label "void gtk_expander_set_label(GtkExpander* expander, gchar* label)"
  s7_pointer _p;
  s7_pointer expander, label;
  _p = args;
  expander = s7_car(_p); _p = s7_cdr(_p);
  label = s7_car(_p);
  if (!s7_is_string(label)) s7_wrong_type_arg_error(sc, "gtk_expander_set_label", 2, label, "gchar*");
  gtk_expander_set_label((GtkExpander*)s7_c_pointer_with_type(sc, expander, GtkExpander__sym, __func__, 0), (gchar*)s7_string(label));
  return(lg_false);
}

static s7_pointer lg_gtk_expander_get_label(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_expander_get_label "gchar* gtk_expander_get_label(GtkExpander* expander)"
  s7_pointer expander;
  expander = s7_car(args);
  return(s7_make_string(sc, gtk_expander_get_label((GtkExpander*)s7_c_pointer_with_type(sc, expander, GtkExpander__sym, __func__, 0))));
}

static s7_pointer lg_gtk_expander_set_use_underline(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_expander_set_use_underline "void gtk_expander_set_use_underline(GtkExpander* expander, \
gboolean use_underline)"
  s7_pointer _p;
  s7_pointer expander, use_underline;
  _p = args;
  expander = s7_car(_p); _p = s7_cdr(_p);
  use_underline = s7_car(_p);
  if (!s7_is_boolean(use_underline)) s7_wrong_type_arg_error(sc, "gtk_expander_set_use_underline", 2, use_underline, "gboolean");
  gtk_expander_set_use_underline((GtkExpander*)s7_c_pointer_with_type(sc, expander, GtkExpander__sym, __func__, 0), (gboolean)lg_boolean(use_underline));
  return(lg_false);
}

static s7_pointer lg_gtk_expander_get_use_underline(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_expander_get_use_underline "gboolean gtk_expander_get_use_underline(GtkExpander* expander)"
  s7_pointer expander;
  expander = s7_car(args);
  return(s7_make_boolean(sc, gtk_expander_get_use_underline((GtkExpander*)s7_c_pointer_with_type(sc, expander, GtkExpander__sym, __func__, 0))));
}

static s7_pointer lg_gtk_expander_set_label_widget(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_expander_set_label_widget "void gtk_expander_set_label_widget(GtkExpander* expander, \
GtkWidget* label_widget)"
  s7_pointer _p;
  s7_pointer expander, label_widget;
  _p = args;
  expander = s7_car(_p); _p = s7_cdr(_p);
  label_widget = s7_car(_p);
  gtk_expander_set_label_widget((GtkExpander*)s7_c_pointer_with_type(sc, expander, GtkExpander__sym, __func__, 0), (GtkWidget*)s7_c_pointer_with_type(sc, label_widget, GtkWidget__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_expander_get_label_widget(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_expander_get_label_widget "GtkWidget* gtk_expander_get_label_widget(GtkExpander* expander)"
  s7_pointer expander;
  expander = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_expander_get_label_widget((GtkExpander*)s7_c_pointer_with_type(sc, expander, GtkExpander__sym, __func__, 0))));
}

static s7_pointer lg_gtk_expander_set_use_markup(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_expander_set_use_markup "void gtk_expander_set_use_markup(GtkExpander* expander, gboolean use_markup)"
  s7_pointer _p;
  s7_pointer expander, use_markup;
  _p = args;
  expander = s7_car(_p); _p = s7_cdr(_p);
  use_markup = s7_car(_p);
  if (!s7_is_boolean(use_markup)) s7_wrong_type_arg_error(sc, "gtk_expander_set_use_markup", 2, use_markup, "gboolean");
  gtk_expander_set_use_markup((GtkExpander*)s7_c_pointer_with_type(sc, expander, GtkExpander__sym, __func__, 0), (gboolean)lg_boolean(use_markup));
  return(lg_false);
}

static s7_pointer lg_gtk_expander_get_use_markup(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_expander_get_use_markup "gboolean gtk_expander_get_use_markup(GtkExpander* expander)"
  s7_pointer expander;
  expander = s7_car(args);
  return(s7_make_boolean(sc, gtk_expander_get_use_markup((GtkExpander*)s7_c_pointer_with_type(sc, expander, GtkExpander__sym, __func__, 0))));
}

static s7_pointer lg_gtk_font_button_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_font_button_new "GtkWidget* gtk_font_button_new( void)"
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_font_button_new()));
}

static s7_pointer lg_gtk_font_button_new_with_font(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_font_button_new_with_font "GtkWidget* gtk_font_button_new_with_font(gchar* fontname)"
  s7_pointer fontname;
  fontname = s7_car(args);
  if (!s7_is_string(fontname)) s7_wrong_type_arg_error(sc, "gtk_font_button_new_with_font", 1, fontname, "gchar*");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_font_button_new_with_font((gchar*)s7_string(fontname))));
}

static s7_pointer lg_gtk_font_button_get_title(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_font_button_get_title "gchar* gtk_font_button_get_title(GtkFontButton* font_button)"
  s7_pointer font_button;
  font_button = s7_car(args);
  return(s7_make_string(sc, gtk_font_button_get_title((GtkFontButton*)s7_c_pointer_with_type(sc, font_button, GtkFontButton__sym, __func__, 0))));
}

static s7_pointer lg_gtk_font_button_set_title(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_font_button_set_title "void gtk_font_button_set_title(GtkFontButton* font_button, gchar* title)"
  s7_pointer _p;
  s7_pointer font_button, title;
  _p = args;
  font_button = s7_car(_p); _p = s7_cdr(_p);
  title = s7_car(_p);
  if (!s7_is_string(title)) s7_wrong_type_arg_error(sc, "gtk_font_button_set_title", 2, title, "gchar*");
  gtk_font_button_set_title((GtkFontButton*)s7_c_pointer_with_type(sc, font_button, GtkFontButton__sym, __func__, 0), (gchar*)s7_string(title));
  return(lg_false);
}

static s7_pointer lg_gtk_font_button_get_use_font(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_font_button_get_use_font "gboolean gtk_font_button_get_use_font(GtkFontButton* font_button)"
  s7_pointer font_button;
  font_button = s7_car(args);
  return(s7_make_boolean(sc, gtk_font_button_get_use_font((GtkFontButton*)s7_c_pointer_with_type(sc, font_button, GtkFontButton__sym, __func__, 0))));
}

static s7_pointer lg_gtk_font_button_set_use_font(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_font_button_set_use_font "void gtk_font_button_set_use_font(GtkFontButton* font_button, \
gboolean use_font)"
  s7_pointer _p;
  s7_pointer font_button, use_font;
  _p = args;
  font_button = s7_car(_p); _p = s7_cdr(_p);
  use_font = s7_car(_p);
  if (!s7_is_boolean(use_font)) s7_wrong_type_arg_error(sc, "gtk_font_button_set_use_font", 2, use_font, "gboolean");
  gtk_font_button_set_use_font((GtkFontButton*)s7_c_pointer_with_type(sc, font_button, GtkFontButton__sym, __func__, 0), (gboolean)lg_boolean(use_font));
  return(lg_false);
}

static s7_pointer lg_gtk_font_button_get_use_size(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_font_button_get_use_size "gboolean gtk_font_button_get_use_size(GtkFontButton* font_button)"
  s7_pointer font_button;
  font_button = s7_car(args);
  return(s7_make_boolean(sc, gtk_font_button_get_use_size((GtkFontButton*)s7_c_pointer_with_type(sc, font_button, GtkFontButton__sym, __func__, 0))));
}

static s7_pointer lg_gtk_font_button_set_use_size(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_font_button_set_use_size "void gtk_font_button_set_use_size(GtkFontButton* font_button, \
gboolean use_size)"
  s7_pointer _p;
  s7_pointer font_button, use_size;
  _p = args;
  font_button = s7_car(_p); _p = s7_cdr(_p);
  use_size = s7_car(_p);
  if (!s7_is_boolean(use_size)) s7_wrong_type_arg_error(sc, "gtk_font_button_set_use_size", 2, use_size, "gboolean");
  gtk_font_button_set_use_size((GtkFontButton*)s7_c_pointer_with_type(sc, font_button, GtkFontButton__sym, __func__, 0), (gboolean)lg_boolean(use_size));
  return(lg_false);
}

static s7_pointer lg_gtk_entry_completion_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_completion_new "GtkEntryCompletion* gtk_entry_completion_new( void)"
  return(lg_make_c_pointer_with_type(sc, GtkEntryCompletion__sym, gtk_entry_completion_new()));
}

static s7_pointer lg_gtk_entry_completion_get_entry(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_completion_get_entry "GtkWidget* gtk_entry_completion_get_entry(GtkEntryCompletion* entry)"
  s7_pointer entry;
  entry = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_entry_completion_get_entry((GtkEntryCompletion*)s7_c_pointer_with_type(sc, entry, GtkEntryCompletion__sym, __func__, 0))));
}

static s7_pointer lg_gtk_entry_completion_set_model(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_completion_set_model "void gtk_entry_completion_set_model(GtkEntryCompletion* completion, \
GtkTreeModel* model)"
  s7_pointer _p;
  s7_pointer completion, model;
  _p = args;
  completion = s7_car(_p); _p = s7_cdr(_p);
  model = s7_car(_p);
  gtk_entry_completion_set_model((GtkEntryCompletion*)s7_c_pointer_with_type(sc, completion, GtkEntryCompletion__sym, __func__, 0), (GtkTreeModel*)s7_c_pointer_with_type(sc, model, GtkTreeModel__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_entry_completion_get_model(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_completion_get_model "GtkTreeModel* gtk_entry_completion_get_model(GtkEntryCompletion* completion)"
  s7_pointer completion;
  completion = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GtkTreeModel__sym, gtk_entry_completion_get_model((GtkEntryCompletion*)s7_c_pointer_with_type(sc, completion, GtkEntryCompletion__sym, __func__, 0))));
}

static s7_pointer lg_gtk_entry_completion_set_match_func(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_completion_set_match_func "void gtk_entry_completion_set_match_func(GtkEntryCompletion* completion, \
GtkEntryCompletionMatchFunc func, lambda_data func_info, GtkDestroyNotify func_notify)"
  s7_pointer _p;
  s7_pointer completion, func, func_info, func_notify;
  _p = args;
  completion = s7_car(_p); _p = s7_cdr(_p);
  func = s7_car(_p); _p = s7_cdr(_p);
  func_info = s7_car(_p); _p = s7_cdr(_p);
  func_notify = s7_car(_p);
  {
    s7_pointer lg_ptr = s7_list(sc, 5, func, func_info, lg_false, lg_false, lg_false);
    s7_gc_protect(sc, lg_ptr);
    s7_list_set(sc, lg_ptr, 3, func_notify);
    gtk_entry_completion_set_match_func((GtkEntryCompletion*)s7_c_pointer_with_type(sc, completion, GtkEntryCompletion__sym, __func__, 0), lg_entry_completion_match, (gpointer)lg_ptr, lg_destroy_func);
    return(lg_false);
   }
}

static s7_pointer lg_gtk_entry_completion_set_minimum_key_length(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_completion_set_minimum_key_length "void gtk_entry_completion_set_minimum_key_length(GtkEntryCompletion* completion, \
gint length)"
  s7_pointer _p;
  s7_pointer completion, length;
  _p = args;
  completion = s7_car(_p); _p = s7_cdr(_p);
  length = s7_car(_p);
  if (!s7_is_integer(length)) s7_wrong_type_arg_error(sc, "gtk_entry_completion_set_minimum_key_length", 2, length, "gint");
  gtk_entry_completion_set_minimum_key_length((GtkEntryCompletion*)s7_c_pointer_with_type(sc, completion, GtkEntryCompletion__sym, __func__, 0), (gint)s7_integer(length));
  return(lg_false);
}

static s7_pointer lg_gtk_entry_completion_get_minimum_key_length(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_completion_get_minimum_key_length "gint gtk_entry_completion_get_minimum_key_length(GtkEntryCompletion* completion)"
  s7_pointer completion;
  completion = s7_car(args);
  return(s7_make_integer(sc, gtk_entry_completion_get_minimum_key_length((GtkEntryCompletion*)s7_c_pointer_with_type(sc, completion, GtkEntryCompletion__sym, __func__, 0))));
}

static s7_pointer lg_gtk_entry_completion_complete(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_completion_complete "void gtk_entry_completion_complete(GtkEntryCompletion* completion)"
  s7_pointer completion;
  completion = s7_car(args);
  gtk_entry_completion_complete((GtkEntryCompletion*)s7_c_pointer_with_type(sc, completion, GtkEntryCompletion__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_entry_completion_insert_action_text(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_completion_insert_action_text "void gtk_entry_completion_insert_action_text(GtkEntryCompletion* completion, \
gint index, gchar* text)"
  s7_pointer _p;
  s7_pointer completion, index, text;
  _p = args;
  completion = s7_car(_p); _p = s7_cdr(_p);
  index = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(index)) s7_wrong_type_arg_error(sc, "gtk_entry_completion_insert_action_text", 2, index, "gint");
  text = s7_car(_p);
  if (!s7_is_string(text)) s7_wrong_type_arg_error(sc, "gtk_entry_completion_insert_action_text", 3, text, "gchar*");
  gtk_entry_completion_insert_action_text((GtkEntryCompletion*)s7_c_pointer_with_type(sc, completion, GtkEntryCompletion__sym, __func__, 0), (gint)s7_integer(index), (gchar*)s7_string(text));
  return(lg_false);
}

static s7_pointer lg_gtk_entry_completion_insert_action_markup(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_completion_insert_action_markup "void gtk_entry_completion_insert_action_markup(GtkEntryCompletion* completion, \
gint index, gchar* markup)"
  s7_pointer _p;
  s7_pointer completion, index, markup;
  _p = args;
  completion = s7_car(_p); _p = s7_cdr(_p);
  index = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(index)) s7_wrong_type_arg_error(sc, "gtk_entry_completion_insert_action_markup", 2, index, "gint");
  markup = s7_car(_p);
  if (!s7_is_string(markup)) s7_wrong_type_arg_error(sc, "gtk_entry_completion_insert_action_markup", 3, markup, "gchar*");
  gtk_entry_completion_insert_action_markup((GtkEntryCompletion*)s7_c_pointer_with_type(sc, completion, GtkEntryCompletion__sym, __func__, 0), (gint)s7_integer(index), (gchar*)s7_string(markup));
  return(lg_false);
}

static s7_pointer lg_gtk_entry_completion_delete_action(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_completion_delete_action "void gtk_entry_completion_delete_action(GtkEntryCompletion* completion, \
gint index)"
  s7_pointer _p;
  s7_pointer completion, index;
  _p = args;
  completion = s7_car(_p); _p = s7_cdr(_p);
  index = s7_car(_p);
  if (!s7_is_integer(index)) s7_wrong_type_arg_error(sc, "gtk_entry_completion_delete_action", 2, index, "gint");
  gtk_entry_completion_delete_action((GtkEntryCompletion*)s7_c_pointer_with_type(sc, completion, GtkEntryCompletion__sym, __func__, 0), (gint)s7_integer(index));
  return(lg_false);
}

static s7_pointer lg_gtk_entry_completion_set_text_column(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_completion_set_text_column "void gtk_entry_completion_set_text_column(GtkEntryCompletion* completion, \
gint column)"
  s7_pointer _p;
  s7_pointer completion, column;
  _p = args;
  completion = s7_car(_p); _p = s7_cdr(_p);
  column = s7_car(_p);
  if (!s7_is_integer(column)) s7_wrong_type_arg_error(sc, "gtk_entry_completion_set_text_column", 2, column, "gint");
  gtk_entry_completion_set_text_column((GtkEntryCompletion*)s7_c_pointer_with_type(sc, completion, GtkEntryCompletion__sym, __func__, 0), (gint)s7_integer(column));
  return(lg_false);
}

static s7_pointer lg_g_timeout_add_full(s7_scheme *sc, s7_pointer args)
{
  #define H_g_timeout_add_full "guint g_timeout_add_full(gint priority, guint interval, GSourceFunc func, \
lambda_data func_info, GtkDestroyNotify notify)"
  s7_pointer _p;
  s7_pointer priority, interval, func, func_info, notify;
  _p = args;
  priority = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(priority)) s7_wrong_type_arg_error(sc, "g_timeout_add_full", 1, priority, "gint");
  interval = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(interval)) s7_wrong_type_arg_error(sc, "g_timeout_add_full", 2, interval, "guint");
  func = s7_car(_p); _p = s7_cdr(_p);
  func_info = s7_car(_p); _p = s7_cdr(_p);
  notify = s7_car(_p);
  {
    s7_pointer res_ult;
    int loc;
    s7_pointer lg_ptr = s7_list(sc, 5, func, func_info, lg_false, lg_false, lg_false);
    loc = s7_gc_protect(sc, lg_ptr);
    s7_list_set(sc, lg_ptr, 2, s7_make_integer(sc, loc));
    s7_list_set(sc, lg_ptr, 3, notify);
    res_ult = s7_make_integer(sc, g_timeout_add_full((gint)s7_integer(priority), (guint)s7_integer(interval), lg_timer_func, (gpointer)lg_ptr, lg_destroy_func));
    return(res_ult);
   }
}

static s7_pointer lg_g_timeout_add(s7_scheme *sc, s7_pointer args)
{
  #define H_g_timeout_add "guint g_timeout_add(guint interval, GSourceFunc func, lambda_data func_info)"
  s7_pointer _p;
  s7_pointer interval, func, func_info;
  _p = args;
  interval = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(interval)) s7_wrong_type_arg_error(sc, "g_timeout_add", 1, interval, "guint");
  func = s7_car(_p); _p = s7_cdr(_p);
  func_info = s7_car(_p);
  {
    s7_pointer res_ult;
    int loc;
    s7_pointer lg_ptr = s7_list(sc, 5, func, func_info, lg_false, lg_false, lg_false);
    loc = s7_gc_protect(sc, lg_ptr);
    s7_list_set(sc, lg_ptr, 2, s7_make_integer(sc, loc));
    res_ult = s7_make_integer(sc, g_timeout_add((guint)s7_integer(interval), lg_timer_func, (gpointer)lg_ptr));
    return(res_ult);
   }
}

static s7_pointer lg_g_idle_add(s7_scheme *sc, s7_pointer args)
{
  #define H_g_idle_add "guint g_idle_add(GSourceFunc func, lambda_data func_info)"
  s7_pointer _p;
  s7_pointer func, func_info;
  _p = args;
  func = s7_car(_p); _p = s7_cdr(_p);
  func_info = s7_car(_p);
  {
    s7_pointer res_ult;
    int loc;
    s7_pointer lg_ptr = s7_list(sc, 5, func, func_info, lg_false, lg_false, lg_false);
    loc = s7_gc_protect(sc, lg_ptr);
    s7_list_set(sc, lg_ptr, 2, s7_make_integer(sc, loc));
    res_ult = s7_make_integer(sc, g_idle_add(lg_timer_func, (gpointer)lg_ptr));
    return(res_ult);
   }
}

static s7_pointer lg_g_idle_add_full(s7_scheme *sc, s7_pointer args)
{
  #define H_g_idle_add_full "guint g_idle_add_full(gint priority, GSourceFunc func, lambda_data func_info, \
GtkDestroyNotify notify)"
  s7_pointer _p;
  s7_pointer priority, func, func_info, notify;
  _p = args;
  priority = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(priority)) s7_wrong_type_arg_error(sc, "g_idle_add_full", 1, priority, "gint");
  func = s7_car(_p); _p = s7_cdr(_p);
  func_info = s7_car(_p); _p = s7_cdr(_p);
  notify = s7_car(_p);
  {
    s7_pointer res_ult;
    int loc;
    s7_pointer lg_ptr = s7_list(sc, 5, func, func_info, lg_false, lg_false, lg_false);
    loc = s7_gc_protect(sc, lg_ptr);
    s7_list_set(sc, lg_ptr, 2, s7_make_integer(sc, loc));
    s7_list_set(sc, lg_ptr, 3, notify);
    res_ult = s7_make_integer(sc, g_idle_add_full((gint)s7_integer(priority), lg_timer_func, (gpointer)lg_ptr, lg_destroy_func));
    return(res_ult);
   }
}

static s7_pointer lg_g_idle_remove_by_data(s7_scheme *sc, s7_pointer args)
{
  #define H_g_idle_remove_by_data "gboolean g_idle_remove_by_data(gpointer data)"
  s7_pointer data;
  data = s7_car(args);
  return(s7_make_boolean(sc, g_idle_remove_by_data((gpointer)s7_c_pointer_with_type(sc, data, gpointer_sym, __func__, 0))));
}

static s7_pointer lg_g_source_remove(s7_scheme *sc, s7_pointer args)
{
  #define H_g_source_remove "gboolean g_source_remove(guint tag)"
  s7_pointer tag;
  tag = s7_car(args);
  if (!s7_is_integer(tag)) s7_wrong_type_arg_error(sc, "g_source_remove", 1, tag, "guint");
  return(s7_make_boolean(sc, g_source_remove((guint)s7_integer(tag))));
}

static s7_pointer lg_gtk_file_filter_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_file_filter_new "GtkFileFilter* gtk_file_filter_new( void)"
  return(lg_make_c_pointer_with_type(sc, GtkFileFilter__sym, gtk_file_filter_new()));
}

static s7_pointer lg_gtk_file_filter_set_name(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_file_filter_set_name "void gtk_file_filter_set_name(GtkFileFilter* filter, gchar* name)"
  s7_pointer _p;
  s7_pointer filter, name;
  _p = args;
  filter = s7_car(_p); _p = s7_cdr(_p);
  name = s7_car(_p);
  if (!s7_is_string(name)) s7_wrong_type_arg_error(sc, "gtk_file_filter_set_name", 2, name, "gchar*");
  gtk_file_filter_set_name((GtkFileFilter*)s7_c_pointer_with_type(sc, filter, GtkFileFilter__sym, __func__, 0), (gchar*)s7_string(name));
  return(lg_false);
}

static s7_pointer lg_gtk_file_filter_get_name(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_file_filter_get_name "gchar* gtk_file_filter_get_name(GtkFileFilter* filter)"
  s7_pointer filter;
  filter = s7_car(args);
  return(s7_make_string(sc, gtk_file_filter_get_name((GtkFileFilter*)s7_c_pointer_with_type(sc, filter, GtkFileFilter__sym, __func__, 0))));
}

static s7_pointer lg_gtk_file_filter_add_mime_type(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_file_filter_add_mime_type "void gtk_file_filter_add_mime_type(GtkFileFilter* filter, \
gchar* mime_type)"
  s7_pointer _p;
  s7_pointer filter, mime_type;
  _p = args;
  filter = s7_car(_p); _p = s7_cdr(_p);
  mime_type = s7_car(_p);
  if (!s7_is_string(mime_type)) s7_wrong_type_arg_error(sc, "gtk_file_filter_add_mime_type", 2, mime_type, "gchar*");
  gtk_file_filter_add_mime_type((GtkFileFilter*)s7_c_pointer_with_type(sc, filter, GtkFileFilter__sym, __func__, 0), (gchar*)s7_string(mime_type));
  return(lg_false);
}

static s7_pointer lg_gtk_file_filter_add_pattern(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_file_filter_add_pattern "void gtk_file_filter_add_pattern(GtkFileFilter* filter, gchar* pattern)"
  s7_pointer _p;
  s7_pointer filter, pattern;
  _p = args;
  filter = s7_car(_p); _p = s7_cdr(_p);
  pattern = s7_car(_p);
  if (!s7_is_string(pattern)) s7_wrong_type_arg_error(sc, "gtk_file_filter_add_pattern", 2, pattern, "gchar*");
  gtk_file_filter_add_pattern((GtkFileFilter*)s7_c_pointer_with_type(sc, filter, GtkFileFilter__sym, __func__, 0), (gchar*)s7_string(pattern));
  return(lg_false);
}

static s7_pointer lg_gtk_file_filter_add_custom(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_file_filter_add_custom "void gtk_file_filter_add_custom(GtkFileFilter* filter, GtkFileFilterFlags needed, \
GtkFileFilterFunc func, lambda_data func_info, GtkDestroyNotify notify)"
  s7_pointer _p;
  s7_pointer filter, needed, func, func_info, notify;
  _p = args;
  filter = s7_car(_p); _p = s7_cdr(_p);
  needed = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(needed)) s7_wrong_type_arg_error(sc, "gtk_file_filter_add_custom", 2, needed, "GtkFileFilterFlags");
  func = s7_car(_p); _p = s7_cdr(_p);
  func_info = s7_car(_p); _p = s7_cdr(_p);
  notify = s7_car(_p);
  {
    s7_pointer lg_ptr = s7_list(sc, 5, func, func_info, lg_false, lg_false, lg_false);
    s7_gc_protect(sc, lg_ptr);
    s7_list_set(sc, lg_ptr, 3, notify);
    gtk_file_filter_add_custom((GtkFileFilter*)s7_c_pointer_with_type(sc, filter, GtkFileFilter__sym, __func__, 0), (GtkFileFilterFlags)s7_integer(needed), lg_file_filter, (gpointer)lg_ptr, lg_destroy_func);
    return(lg_false);
   }
}

static s7_pointer lg_gtk_file_filter_get_needed(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_file_filter_get_needed "GtkFileFilterFlags gtk_file_filter_get_needed(GtkFileFilter* filter)"
  s7_pointer filter;
  filter = s7_car(args);
  return(s7_make_integer(sc, gtk_file_filter_get_needed((GtkFileFilter*)s7_c_pointer_with_type(sc, filter, GtkFileFilter__sym, __func__, 0))));
}

static s7_pointer lg_gtk_file_filter_filter(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_file_filter_filter "gboolean gtk_file_filter_filter(GtkFileFilter* filter, GtkFileFilterInfo* filter_info)"
  s7_pointer _p;
  s7_pointer filter, filter_info;
  _p = args;
  filter = s7_car(_p); _p = s7_cdr(_p);
  filter_info = s7_car(_p);
  return(s7_make_boolean(sc, gtk_file_filter_filter((GtkFileFilter*)s7_c_pointer_with_type(sc, filter, GtkFileFilter__sym, __func__, 0), (GtkFileFilterInfo*)s7_c_pointer_with_type(sc, filter_info, GtkFileFilterInfo__sym, __func__, 0))));
}

static s7_pointer lg_gtk_cell_layout_pack_start(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_layout_pack_start "void gtk_cell_layout_pack_start(GtkCellLayout* cell_layout, GtkCellRenderer* cell, \
gboolean expand)"
  s7_pointer _p;
  s7_pointer cell_layout, cell, expand;
  _p = args;
  cell_layout = s7_car(_p); _p = s7_cdr(_p);
  cell = s7_car(_p); _p = s7_cdr(_p);
  expand = s7_car(_p);
  if (!s7_is_boolean(expand)) s7_wrong_type_arg_error(sc, "gtk_cell_layout_pack_start", 3, expand, "gboolean");
  gtk_cell_layout_pack_start((GtkCellLayout*)s7_c_pointer_with_type(sc, cell_layout, GtkCellLayout__sym, __func__, 0), (GtkCellRenderer*)s7_c_pointer_with_type(sc, cell, GtkCellRenderer__sym, __func__, 0), (gboolean)lg_boolean(expand));
  return(lg_false);
}

static s7_pointer lg_gtk_cell_layout_pack_end(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_layout_pack_end "void gtk_cell_layout_pack_end(GtkCellLayout* cell_layout, GtkCellRenderer* cell, \
gboolean expand)"
  s7_pointer _p;
  s7_pointer cell_layout, cell, expand;
  _p = args;
  cell_layout = s7_car(_p); _p = s7_cdr(_p);
  cell = s7_car(_p); _p = s7_cdr(_p);
  expand = s7_car(_p);
  if (!s7_is_boolean(expand)) s7_wrong_type_arg_error(sc, "gtk_cell_layout_pack_end", 3, expand, "gboolean");
  gtk_cell_layout_pack_end((GtkCellLayout*)s7_c_pointer_with_type(sc, cell_layout, GtkCellLayout__sym, __func__, 0), (GtkCellRenderer*)s7_c_pointer_with_type(sc, cell, GtkCellRenderer__sym, __func__, 0), (gboolean)lg_boolean(expand));
  return(lg_false);
}

static s7_pointer lg_gtk_cell_layout_clear(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_layout_clear "void gtk_cell_layout_clear(GtkCellLayout* cell_layout)"
  s7_pointer cell_layout;
  cell_layout = s7_car(args);
  gtk_cell_layout_clear((GtkCellLayout*)s7_c_pointer_with_type(sc, cell_layout, GtkCellLayout__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_cell_layout_set_attributes(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_layout_set_attributes "void gtk_cell_layout_set_attributes(GtkCellLayout* cell_layout, \
GtkCellRenderer* cell, etc attributes)"
  s7_pointer _p;
  s7_pointer cell_layout, cell, attributes;
  _p = args;
  cell_layout = s7_car(_p); _p = s7_cdr(_p);
  cell = s7_car(_p); _p = s7_cdr(_p);
  attributes = s7_car(_p);
  if (!lg_is_list(attributes)) s7_wrong_type_arg_error(sc, "gtk_cell_layout_set_attributes", 3, attributes, "etc");
  {
    int etc_len = 0;
    GtkCellLayout* p_arg0;
    GtkCellRenderer* p_arg1;
    if (s7_is_list(sc, attributes)) etc_len = s7_list_length(sc, attributes);
    if (etc_len < 2) s7_out_of_range_error(sc, "gtk_cell_layout_set_attributes", 2, attributes, "... list must have at least 2 entries");
    if (etc_len > 10) s7_out_of_range_error(sc, "gtk_cell_layout_set_attributes", 2, attributes, "... list too long (max len: 10)");
    if ((etc_len % 2) != 0) s7_out_of_range_error(sc, "gtk_cell_layout_set_attributes", 2, attributes, "... list len must be multiple of 2");
    p_arg0 = (GtkCellLayout*)s7_c_pointer_with_type(sc, cell_layout, GtkCellLayout__sym, __func__, 0);
    p_arg1 = (GtkCellRenderer*)s7_c_pointer_with_type(sc, cell, GtkCellRenderer__sym, __func__, 0);
    switch (etc_len)
      {
        case 2: gtk_cell_layout_set_attributes(p_arg0, p_arg1, s7_string(s7_list_ref(sc, attributes, 0)), s7_integer(s7_list_ref(sc, attributes, 1)), NULL); break;
        case 4: gtk_cell_layout_set_attributes(p_arg0, p_arg1, s7_string(s7_list_ref(sc, attributes, 0)), s7_integer(s7_list_ref(sc, attributes, 1)), s7_string(s7_list_ref(sc, attributes, 2)), s7_integer(s7_list_ref(sc, attributes, 3)), NULL); break;
        case 6: gtk_cell_layout_set_attributes(p_arg0, p_arg1, s7_string(s7_list_ref(sc, attributes, 0)), s7_integer(s7_list_ref(sc, attributes, 1)), s7_string(s7_list_ref(sc, attributes, 2)), s7_integer(s7_list_ref(sc, attributes, 3)), s7_string(s7_list_ref(sc, attributes, 4)), s7_integer(s7_list_ref(sc, attributes, 5)), NULL); break;
        case 8: gtk_cell_layout_set_attributes(p_arg0, p_arg1, s7_string(s7_list_ref(sc, attributes, 0)), s7_integer(s7_list_ref(sc, attributes, 1)), s7_string(s7_list_ref(sc, attributes, 2)), s7_integer(s7_list_ref(sc, attributes, 3)), s7_string(s7_list_ref(sc, attributes, 4)), s7_integer(s7_list_ref(sc, attributes, 5)), s7_string(s7_list_ref(sc, attributes, 6)), s7_integer(s7_list_ref(sc, attributes, 7)), NULL); break;
        case 10: gtk_cell_layout_set_attributes(p_arg0, p_arg1, s7_string(s7_list_ref(sc, attributes, 0)), s7_integer(s7_list_ref(sc, attributes, 1)), s7_string(s7_list_ref(sc, attributes, 2)), s7_integer(s7_list_ref(sc, attributes, 3)), s7_string(s7_list_ref(sc, attributes, 4)), s7_integer(s7_list_ref(sc, attributes, 5)), s7_string(s7_list_ref(sc, attributes, 6)), s7_integer(s7_list_ref(sc, attributes, 7)), s7_string(s7_list_ref(sc, attributes, 8)), s7_integer(s7_list_ref(sc, attributes, 9)), NULL); break;
      }
    return(lg_false);
  }
}

static s7_pointer lg_gtk_cell_layout_add_attribute(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_layout_add_attribute "void gtk_cell_layout_add_attribute(GtkCellLayout* cell_layout, \
GtkCellRenderer* cell, gchar* attribute, gint column)"
  s7_pointer _p;
  s7_pointer cell_layout, cell, attribute, column;
  _p = args;
  cell_layout = s7_car(_p); _p = s7_cdr(_p);
  cell = s7_car(_p); _p = s7_cdr(_p);
  attribute = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(attribute)) s7_wrong_type_arg_error(sc, "gtk_cell_layout_add_attribute", 3, attribute, "gchar*");
  column = s7_car(_p);
  if (!s7_is_integer(column)) s7_wrong_type_arg_error(sc, "gtk_cell_layout_add_attribute", 4, column, "gint");
  gtk_cell_layout_add_attribute((GtkCellLayout*)s7_c_pointer_with_type(sc, cell_layout, GtkCellLayout__sym, __func__, 0), (GtkCellRenderer*)s7_c_pointer_with_type(sc, cell, GtkCellRenderer__sym, __func__, 0), (gchar*)s7_string(attribute), (gint)s7_integer(column));
  return(lg_false);
}

static s7_pointer lg_gtk_cell_layout_set_cell_data_func(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_layout_set_cell_data_func "void gtk_cell_layout_set_cell_data_func(GtkCellLayout* cell_layout, \
GtkCellRenderer* cell, GtkCellLayoutDataFunc func, lambda_data func_info, GtkDestroyNotify destroy)"
  s7_pointer _p;
  s7_pointer cell_layout, cell, func, func_info, destroy;
  _p = args;
  cell_layout = s7_car(_p); _p = s7_cdr(_p);
  cell = s7_car(_p); _p = s7_cdr(_p);
  func = s7_car(_p); _p = s7_cdr(_p);
  func_info = s7_car(_p); _p = s7_cdr(_p);
  destroy = s7_car(_p);
  {
    s7_pointer lg_ptr = s7_list(sc, 5, func, func_info, lg_false, lg_false, lg_false);
    s7_gc_protect(sc, lg_ptr);
    s7_list_set(sc, lg_ptr, 3, destroy);
    gtk_cell_layout_set_cell_data_func((GtkCellLayout*)s7_c_pointer_with_type(sc, cell_layout, GtkCellLayout__sym, __func__, 0), (GtkCellRenderer*)s7_c_pointer_with_type(sc, cell, GtkCellRenderer__sym, __func__, 0), (GtkCellLayoutDataFunc)s7_c_pointer_with_type(sc, func, GtkCellLayoutDataFunc_sym, __func__, 0), (gpointer)lg_ptr, lg_destroy_func);
    return(lg_false);
   }
}

static s7_pointer lg_gtk_cell_layout_clear_attributes(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_layout_clear_attributes "void gtk_cell_layout_clear_attributes(GtkCellLayout* cell_layout, \
GtkCellRenderer* cell)"
  s7_pointer _p;
  s7_pointer cell_layout, cell;
  _p = args;
  cell_layout = s7_car(_p); _p = s7_cdr(_p);
  cell = s7_car(_p);
  gtk_cell_layout_clear_attributes((GtkCellLayout*)s7_c_pointer_with_type(sc, cell_layout, GtkCellLayout__sym, __func__, 0), (GtkCellRenderer*)s7_c_pointer_with_type(sc, cell, GtkCellRenderer__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_file_chooser_set_action(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_file_chooser_set_action "void gtk_file_chooser_set_action(GtkFileChooser* chooser, GtkFileChooserAction action)"
  s7_pointer _p;
  s7_pointer chooser, action;
  _p = args;
  chooser = s7_car(_p); _p = s7_cdr(_p);
  action = s7_car(_p);
  if (!s7_is_integer(action)) s7_wrong_type_arg_error(sc, "gtk_file_chooser_set_action", 2, action, "GtkFileChooserAction");
  gtk_file_chooser_set_action((GtkFileChooser*)s7_c_pointer_with_type(sc, chooser, GtkFileChooser__sym, __func__, 0), (GtkFileChooserAction)s7_integer(action));
  return(lg_false);
}

static s7_pointer lg_gtk_file_chooser_get_action(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_file_chooser_get_action "GtkFileChooserAction gtk_file_chooser_get_action(GtkFileChooser* chooser)"
  s7_pointer chooser;
  chooser = s7_car(args);
  return(s7_make_integer(sc, gtk_file_chooser_get_action((GtkFileChooser*)s7_c_pointer_with_type(sc, chooser, GtkFileChooser__sym, __func__, 0))));
}

static s7_pointer lg_gtk_list_store_remove(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_list_store_remove "gboolean gtk_list_store_remove(GtkListStore* list_store, GtkTreeIter* iter)"
  s7_pointer _p;
  s7_pointer list_store, iter;
  _p = args;
  list_store = s7_car(_p); _p = s7_cdr(_p);
  iter = s7_car(_p);
  return(s7_make_boolean(sc, gtk_list_store_remove((GtkListStore*)s7_c_pointer_with_type(sc, list_store, GtkListStore__sym, __func__, 0), (GtkTreeIter*)s7_c_pointer_with_type(sc, iter, GtkTreeIter__sym, __func__, 0))));
}

static s7_pointer lg_gtk_cell_layout_reorder(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_layout_reorder "void gtk_cell_layout_reorder(GtkCellLayout* cell_layout, GtkCellRenderer* cell, \
gint position)"
  s7_pointer _p;
  s7_pointer cell_layout, cell, position;
  _p = args;
  cell_layout = s7_car(_p); _p = s7_cdr(_p);
  cell = s7_car(_p); _p = s7_cdr(_p);
  position = s7_car(_p);
  if (!s7_is_integer(position)) s7_wrong_type_arg_error(sc, "gtk_cell_layout_reorder", 3, position, "gint");
  gtk_cell_layout_reorder((GtkCellLayout*)s7_c_pointer_with_type(sc, cell_layout, GtkCellLayout__sym, __func__, 0), (GtkCellRenderer*)s7_c_pointer_with_type(sc, cell, GtkCellRenderer__sym, __func__, 0), (gint)s7_integer(position));
  return(lg_false);
}

static s7_pointer lg_g_list_nth_data(s7_scheme *sc, s7_pointer args)
{
  #define H_g_list_nth_data "gpointer g_list_nth_data(GList* list, guint n)"
  s7_pointer _p;
  s7_pointer list, n;
  _p = args;
  list = s7_car(_p); _p = s7_cdr(_p);
  n = s7_car(_p);
  if (!s7_is_integer(n)) s7_wrong_type_arg_error(sc, "g_list_nth_data", 2, n, "guint");
  return(lg_make_c_pointer_with_type(sc, gpointer_sym, g_list_nth_data((GList*)s7_c_pointer_with_type(sc, list, GList__sym, __func__, 0), (guint)s7_integer(n))));
}

static s7_pointer lg_gtk_combo_box_popup(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_combo_box_popup "void gtk_combo_box_popup(GtkComboBox* combo_box)"
  s7_pointer combo_box;
  combo_box = s7_car(args);
  gtk_combo_box_popup((GtkComboBox*)s7_c_pointer_with_type(sc, combo_box, GtkComboBox__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_combo_box_popdown(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_combo_box_popdown "void gtk_combo_box_popdown(GtkComboBox* combo_box)"
  s7_pointer combo_box;
  combo_box = s7_car(args);
  gtk_combo_box_popdown((GtkComboBox*)s7_c_pointer_with_type(sc, combo_box, GtkComboBox__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_scale_get_layout(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_scale_get_layout "PangoLayout* gtk_scale_get_layout(GtkScale* scale)"
  s7_pointer scale;
  scale = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, PangoLayout__sym, gtk_scale_get_layout((GtkScale*)s7_c_pointer_with_type(sc, scale, GtkScale__sym, __func__, 0))));
}

static s7_pointer lg_gtk_scale_get_layout_offsets(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_scale_get_layout_offsets "void gtk_scale_get_layout_offsets(GtkScale* scale, gint* [x], \
gint* [y])"
  s7_pointer _p;
  s7_pointer scale;
  gint ref_x;
  gint ref_y;
  _p = args;
  scale = s7_car(_p);
  gtk_scale_get_layout_offsets((GtkScale*)s7_c_pointer_with_type(sc, scale, GtkScale__sym, __func__, 0), &ref_x, &ref_y);
    return(s7_list(sc, 2, s7_make_integer(sc, ref_x), s7_make_integer(sc, ref_y)));
}

static s7_pointer lg_gtk_entry_set_alignment(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_set_alignment "void gtk_entry_set_alignment(GtkEntry* entry, gfloat xalign)"
  s7_pointer _p;
  s7_pointer entry, xalign;
  _p = args;
  entry = s7_car(_p); _p = s7_cdr(_p);
  xalign = s7_car(_p);
  if (!s7_is_real(xalign)) s7_wrong_type_arg_error(sc, "gtk_entry_set_alignment", 2, xalign, "gfloat");
  gtk_entry_set_alignment((GtkEntry*)s7_c_pointer_with_type(sc, entry, GtkEntry__sym, __func__, 0), (gfloat)s7_real(xalign));
  return(lg_false);
}

static s7_pointer lg_gtk_entry_get_alignment(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_get_alignment "gfloat gtk_entry_get_alignment(GtkEntry* entry)"
  s7_pointer entry;
  entry = s7_car(args);
  return(s7_make_real(sc, gtk_entry_get_alignment((GtkEntry*)s7_c_pointer_with_type(sc, entry, GtkEntry__sym, __func__, 0))));
}

static s7_pointer lg_gtk_widget_list_mnemonic_labels(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_list_mnemonic_labels "GList* gtk_widget_list_mnemonic_labels(GtkWidget* widget)"
  s7_pointer widget;
  widget = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GList__sym, gtk_widget_list_mnemonic_labels((GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0))));
}

static s7_pointer lg_gtk_widget_add_mnemonic_label(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_add_mnemonic_label "void gtk_widget_add_mnemonic_label(GtkWidget* widget, GtkWidget* label)"
  s7_pointer _p;
  s7_pointer widget, label;
  _p = args;
  widget = s7_car(_p); _p = s7_cdr(_p);
  label = s7_car(_p);
  gtk_widget_add_mnemonic_label((GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0), (GtkWidget*)s7_c_pointer_with_type(sc, label, GtkWidget__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_widget_remove_mnemonic_label(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_remove_mnemonic_label "void gtk_widget_remove_mnemonic_label(GtkWidget* widget, \
GtkWidget* label)"
  s7_pointer _p;
  s7_pointer widget, label;
  _p = args;
  widget = s7_car(_p); _p = s7_cdr(_p);
  label = s7_car(_p);
  gtk_widget_remove_mnemonic_label((GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0), (GtkWidget*)s7_c_pointer_with_type(sc, label, GtkWidget__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_g_quark_from_string(s7_scheme *sc, s7_pointer args)
{
  #define H_g_quark_from_string "GQuark g_quark_from_string(gchar* string)"
  s7_pointer string;
  string = s7_car(args);
  if (!s7_is_string(string)) s7_wrong_type_arg_error(sc, "g_quark_from_string", 1, string, "gchar*");
  return(s7_make_integer(sc, g_quark_from_string((gchar*)s7_string(string))));
}

static s7_pointer lg_g_quark_to_string(s7_scheme *sc, s7_pointer args)
{
  #define H_g_quark_to_string "gchar* g_quark_to_string(GQuark quark)"
  s7_pointer quark;
  quark = s7_car(args);
  if (!s7_is_integer(quark)) s7_wrong_type_arg_error(sc, "g_quark_to_string", 1, quark, "GQuark");
  return(s7_make_string(sc, g_quark_to_string((GQuark)s7_integer(quark))));
}

static s7_pointer lg_gtk_cell_view_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_view_new "GtkWidget* gtk_cell_view_new( void)"
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_cell_view_new()));
}

static s7_pointer lg_gtk_cell_view_new_with_text(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_view_new_with_text "GtkWidget* gtk_cell_view_new_with_text(gchar* text)"
  s7_pointer text;
  text = s7_car(args);
  if (!s7_is_string(text)) s7_wrong_type_arg_error(sc, "gtk_cell_view_new_with_text", 1, text, "gchar*");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_cell_view_new_with_text((gchar*)s7_string(text))));
}

static s7_pointer lg_gtk_cell_view_new_with_markup(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_view_new_with_markup "GtkWidget* gtk_cell_view_new_with_markup(gchar* markup)"
  s7_pointer markup;
  markup = s7_car(args);
  if (!s7_is_string(markup)) s7_wrong_type_arg_error(sc, "gtk_cell_view_new_with_markup", 1, markup, "gchar*");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_cell_view_new_with_markup((gchar*)s7_string(markup))));
}

static s7_pointer lg_gtk_cell_view_set_model(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_view_set_model "void gtk_cell_view_set_model(GtkCellView* cell_view, GtkTreeModel* model)"
  s7_pointer _p;
  s7_pointer cell_view, model;
  _p = args;
  cell_view = s7_car(_p); _p = s7_cdr(_p);
  model = s7_car(_p);
  gtk_cell_view_set_model((GtkCellView*)s7_c_pointer_with_type(sc, cell_view, GtkCellView__sym, __func__, 0), (GtkTreeModel*)s7_c_pointer_with_type(sc, model, GtkTreeModel__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_cell_view_set_displayed_row(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_view_set_displayed_row "void gtk_cell_view_set_displayed_row(GtkCellView* cell_view, \
GtkTreePath* path)"
  s7_pointer _p;
  s7_pointer cell_view, path;
  _p = args;
  cell_view = s7_car(_p); _p = s7_cdr(_p);
  path = s7_car(_p);
  gtk_cell_view_set_displayed_row((GtkCellView*)s7_c_pointer_with_type(sc, cell_view, GtkCellView__sym, __func__, 0), (GtkTreePath*)s7_c_pointer_with_type(sc, path, GtkTreePath__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_cell_view_get_displayed_row(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_view_get_displayed_row "GtkTreePath* gtk_cell_view_get_displayed_row(GtkCellView* cell_view)"
  s7_pointer cell_view;
  cell_view = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GtkTreePath__sym, gtk_cell_view_get_displayed_row((GtkCellView*)s7_c_pointer_with_type(sc, cell_view, GtkCellView__sym, __func__, 0))));
}

static s7_pointer lg_gtk_entry_completion_insert_prefix(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_completion_insert_prefix "void gtk_entry_completion_insert_prefix(GtkEntryCompletion* completion)"
  s7_pointer completion;
  completion = s7_car(args);
  gtk_entry_completion_insert_prefix((GtkEntryCompletion*)s7_c_pointer_with_type(sc, completion, GtkEntryCompletion__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_entry_completion_set_inline_completion(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_completion_set_inline_completion "void gtk_entry_completion_set_inline_completion(GtkEntryCompletion* completion, \
gboolean inline_completion)"
  s7_pointer _p;
  s7_pointer completion, inline_completion;
  _p = args;
  completion = s7_car(_p); _p = s7_cdr(_p);
  inline_completion = s7_car(_p);
  if (!s7_is_boolean(inline_completion)) s7_wrong_type_arg_error(sc, "gtk_entry_completion_set_inline_completion", 2, inline_completion, "gboolean");
  gtk_entry_completion_set_inline_completion((GtkEntryCompletion*)s7_c_pointer_with_type(sc, completion, GtkEntryCompletion__sym, __func__, 0), (gboolean)lg_boolean(inline_completion));
  return(lg_false);
}

static s7_pointer lg_gtk_entry_completion_get_inline_completion(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_completion_get_inline_completion "gboolean gtk_entry_completion_get_inline_completion(GtkEntryCompletion* completion)"
  s7_pointer completion;
  completion = s7_car(args);
  return(s7_make_boolean(sc, gtk_entry_completion_get_inline_completion((GtkEntryCompletion*)s7_c_pointer_with_type(sc, completion, GtkEntryCompletion__sym, __func__, 0))));
}

static s7_pointer lg_gtk_entry_completion_set_popup_completion(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_completion_set_popup_completion "void gtk_entry_completion_set_popup_completion(GtkEntryCompletion* completion, \
gboolean popup_completion)"
  s7_pointer _p;
  s7_pointer completion, popup_completion;
  _p = args;
  completion = s7_car(_p); _p = s7_cdr(_p);
  popup_completion = s7_car(_p);
  if (!s7_is_boolean(popup_completion)) s7_wrong_type_arg_error(sc, "gtk_entry_completion_set_popup_completion", 2, popup_completion, "gboolean");
  gtk_entry_completion_set_popup_completion((GtkEntryCompletion*)s7_c_pointer_with_type(sc, completion, GtkEntryCompletion__sym, __func__, 0), (gboolean)lg_boolean(popup_completion));
  return(lg_false);
}

static s7_pointer lg_gtk_entry_completion_get_popup_completion(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_completion_get_popup_completion "gboolean gtk_entry_completion_get_popup_completion(GtkEntryCompletion* completion)"
  s7_pointer completion;
  completion = s7_car(args);
  return(s7_make_boolean(sc, gtk_entry_completion_get_popup_completion((GtkEntryCompletion*)s7_c_pointer_with_type(sc, completion, GtkEntryCompletion__sym, __func__, 0))));
}

static s7_pointer lg_gtk_entry_completion_get_text_column(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_completion_get_text_column "gint gtk_entry_completion_get_text_column(GtkEntryCompletion* completion)"
  s7_pointer completion;
  completion = s7_car(args);
  return(s7_make_integer(sc, gtk_entry_completion_get_text_column((GtkEntryCompletion*)s7_c_pointer_with_type(sc, completion, GtkEntryCompletion__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_view_set_fixed_height_mode(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_set_fixed_height_mode "void gtk_tree_view_set_fixed_height_mode(GtkTreeView* tree_view, \
gboolean enable)"
  s7_pointer _p;
  s7_pointer tree_view, enable;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  enable = s7_car(_p);
  if (!s7_is_boolean(enable)) s7_wrong_type_arg_error(sc, "gtk_tree_view_set_fixed_height_mode", 2, enable, "gboolean");
  gtk_tree_view_set_fixed_height_mode((GtkTreeView*)s7_c_pointer_with_type(sc, tree_view, GtkTreeView__sym, __func__, 0), (gboolean)lg_boolean(enable));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_get_fixed_height_mode(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_get_fixed_height_mode "gboolean gtk_tree_view_get_fixed_height_mode(GtkTreeView* tree_view)"
  s7_pointer tree_view;
  tree_view = s7_car(args);
  return(s7_make_boolean(sc, gtk_tree_view_get_fixed_height_mode((GtkTreeView*)s7_c_pointer_with_type(sc, tree_view, GtkTreeView__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_view_set_hover_selection(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_set_hover_selection "void gtk_tree_view_set_hover_selection(GtkTreeView* tree_view, \
gboolean hover)"
  s7_pointer _p;
  s7_pointer tree_view, hover;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  hover = s7_car(_p);
  if (!s7_is_boolean(hover)) s7_wrong_type_arg_error(sc, "gtk_tree_view_set_hover_selection", 2, hover, "gboolean");
  gtk_tree_view_set_hover_selection((GtkTreeView*)s7_c_pointer_with_type(sc, tree_view, GtkTreeView__sym, __func__, 0), (gboolean)lg_boolean(hover));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_get_hover_selection(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_get_hover_selection "gboolean gtk_tree_view_get_hover_selection(GtkTreeView* tree_view)"
  s7_pointer tree_view;
  tree_view = s7_car(args);
  return(s7_make_boolean(sc, gtk_tree_view_get_hover_selection((GtkTreeView*)s7_c_pointer_with_type(sc, tree_view, GtkTreeView__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_view_set_row_separator_func(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_set_row_separator_func "void gtk_tree_view_set_row_separator_func(GtkTreeView* tree_view, \
GtkTreeViewRowSeparatorFunc func, lambda_data func_info, GtkDestroyNotify destroy)"
  s7_pointer _p;
  s7_pointer tree_view, func, func_info, destroy;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  func = s7_car(_p); _p = s7_cdr(_p);
  func_info = s7_car(_p); _p = s7_cdr(_p);
  destroy = s7_car(_p);
  {
    s7_pointer lg_ptr = s7_list(sc, 5, func, func_info, lg_false, lg_false, lg_false);
    s7_gc_protect(sc, lg_ptr);
    s7_list_set(sc, lg_ptr, 3, destroy);
    gtk_tree_view_set_row_separator_func((GtkTreeView*)s7_c_pointer_with_type(sc, tree_view, GtkTreeView__sym, __func__, 0), lg_row_separator, (gpointer)lg_ptr, lg_destroy_func);
    return(lg_false);
   }
}

static s7_pointer lg_gtk_window_set_icon_name(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_window_set_icon_name "void gtk_window_set_icon_name(GtkWindow* window, gchar* name)"
  s7_pointer _p;
  s7_pointer window, name;
  _p = args;
  window = s7_car(_p); _p = s7_cdr(_p);
  name = s7_car(_p);
  if (!s7_is_string(name)) s7_wrong_type_arg_error(sc, "gtk_window_set_icon_name", 2, name, "gchar*");
  gtk_window_set_icon_name((GtkWindow*)s7_c_pointer_with_type(sc, window, GtkWindow__sym, __func__, 0), (gchar*)s7_string(name));
  return(lg_false);
}

static s7_pointer lg_gtk_window_get_icon_name(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_window_get_icon_name "gchar* gtk_window_get_icon_name(GtkWindow* window)"
  s7_pointer window;
  window = s7_car(args);
  return(s7_make_string(sc, gtk_window_get_icon_name((GtkWindow*)s7_c_pointer_with_type(sc, window, GtkWindow__sym, __func__, 0))));
}

static s7_pointer lg_gtk_window_set_default_icon_name(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_window_set_default_icon_name "void gtk_window_set_default_icon_name(gchar* name)"
  s7_pointer name;
  name = s7_car(args);
  if (!s7_is_string(name)) s7_wrong_type_arg_error(sc, "gtk_window_set_default_icon_name", 1, name, "gchar*");
  gtk_window_set_default_icon_name((gchar*)s7_string(name));
  return(lg_false);
}

static s7_pointer lg_gtk_about_dialog_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_about_dialog_new "GtkWidget* gtk_about_dialog_new( void)"
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_about_dialog_new()));
}

static s7_pointer lg_gtk_about_dialog_get_version(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_about_dialog_get_version "gchar* gtk_about_dialog_get_version(GtkAboutDialog* about)"
  s7_pointer about;
  about = s7_car(args);
  return(s7_make_string(sc, gtk_about_dialog_get_version((GtkAboutDialog*)s7_c_pointer_with_type(sc, about, GtkAboutDialog__sym, __func__, 0))));
}

static s7_pointer lg_gtk_about_dialog_set_version(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_about_dialog_set_version "void gtk_about_dialog_set_version(GtkAboutDialog* about, gchar* version)"
  s7_pointer _p;
  s7_pointer about, version;
  _p = args;
  about = s7_car(_p); _p = s7_cdr(_p);
  version = s7_car(_p);
  if (!s7_is_string(version)) s7_wrong_type_arg_error(sc, "gtk_about_dialog_set_version", 2, version, "gchar*");
  gtk_about_dialog_set_version((GtkAboutDialog*)s7_c_pointer_with_type(sc, about, GtkAboutDialog__sym, __func__, 0), (gchar*)s7_string(version));
  return(lg_false);
}

static s7_pointer lg_gtk_about_dialog_get_copyright(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_about_dialog_get_copyright "gchar* gtk_about_dialog_get_copyright(GtkAboutDialog* about)"
  s7_pointer about;
  about = s7_car(args);
  return(s7_make_string(sc, gtk_about_dialog_get_copyright((GtkAboutDialog*)s7_c_pointer_with_type(sc, about, GtkAboutDialog__sym, __func__, 0))));
}

static s7_pointer lg_gtk_about_dialog_set_copyright(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_about_dialog_set_copyright "void gtk_about_dialog_set_copyright(GtkAboutDialog* about, \
gchar* copyright)"
  s7_pointer _p;
  s7_pointer about, copyright;
  _p = args;
  about = s7_car(_p); _p = s7_cdr(_p);
  copyright = s7_car(_p);
  if (!s7_is_string(copyright)) s7_wrong_type_arg_error(sc, "gtk_about_dialog_set_copyright", 2, copyright, "gchar*");
  gtk_about_dialog_set_copyright((GtkAboutDialog*)s7_c_pointer_with_type(sc, about, GtkAboutDialog__sym, __func__, 0), (gchar*)s7_string(copyright));
  return(lg_false);
}

static s7_pointer lg_gtk_about_dialog_get_comments(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_about_dialog_get_comments "gchar* gtk_about_dialog_get_comments(GtkAboutDialog* about)"
  s7_pointer about;
  about = s7_car(args);
  return(s7_make_string(sc, gtk_about_dialog_get_comments((GtkAboutDialog*)s7_c_pointer_with_type(sc, about, GtkAboutDialog__sym, __func__, 0))));
}

static s7_pointer lg_gtk_about_dialog_set_comments(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_about_dialog_set_comments "void gtk_about_dialog_set_comments(GtkAboutDialog* about, \
gchar* comments)"
  s7_pointer _p;
  s7_pointer about, comments;
  _p = args;
  about = s7_car(_p); _p = s7_cdr(_p);
  comments = s7_car(_p);
  if (!s7_is_string(comments)) s7_wrong_type_arg_error(sc, "gtk_about_dialog_set_comments", 2, comments, "gchar*");
  gtk_about_dialog_set_comments((GtkAboutDialog*)s7_c_pointer_with_type(sc, about, GtkAboutDialog__sym, __func__, 0), (gchar*)s7_string(comments));
  return(lg_false);
}

static s7_pointer lg_gtk_about_dialog_get_website(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_about_dialog_get_website "gchar* gtk_about_dialog_get_website(GtkAboutDialog* about)"
  s7_pointer about;
  about = s7_car(args);
  return(s7_make_string(sc, gtk_about_dialog_get_website((GtkAboutDialog*)s7_c_pointer_with_type(sc, about, GtkAboutDialog__sym, __func__, 0))));
}

static s7_pointer lg_gtk_about_dialog_set_website(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_about_dialog_set_website "void gtk_about_dialog_set_website(GtkAboutDialog* about, gchar* website)"
  s7_pointer _p;
  s7_pointer about, website;
  _p = args;
  about = s7_car(_p); _p = s7_cdr(_p);
  website = s7_car(_p);
  if (!s7_is_string(website)) s7_wrong_type_arg_error(sc, "gtk_about_dialog_set_website", 2, website, "gchar*");
  gtk_about_dialog_set_website((GtkAboutDialog*)s7_c_pointer_with_type(sc, about, GtkAboutDialog__sym, __func__, 0), (gchar*)s7_string(website));
  return(lg_false);
}

static s7_pointer lg_gtk_about_dialog_get_website_label(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_about_dialog_get_website_label "gchar* gtk_about_dialog_get_website_label(GtkAboutDialog* about)"
  s7_pointer about;
  about = s7_car(args);
  return(s7_make_string(sc, gtk_about_dialog_get_website_label((GtkAboutDialog*)s7_c_pointer_with_type(sc, about, GtkAboutDialog__sym, __func__, 0))));
}

static s7_pointer lg_gtk_about_dialog_set_website_label(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_about_dialog_set_website_label "void gtk_about_dialog_set_website_label(GtkAboutDialog* about, \
gchar* website_label)"
  s7_pointer _p;
  s7_pointer about, website_label;
  _p = args;
  about = s7_car(_p); _p = s7_cdr(_p);
  website_label = s7_car(_p);
  if (!s7_is_string(website_label)) s7_wrong_type_arg_error(sc, "gtk_about_dialog_set_website_label", 2, website_label, "gchar*");
  gtk_about_dialog_set_website_label((GtkAboutDialog*)s7_c_pointer_with_type(sc, about, GtkAboutDialog__sym, __func__, 0), (gchar*)s7_string(website_label));
  return(lg_false);
}

static s7_pointer lg_gtk_about_dialog_get_authors(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_about_dialog_get_authors "gchar** gtk_about_dialog_get_authors(GtkAboutDialog* about)"
  s7_pointer about;
  about = s7_car(args);
    return(lg_make_c_pointer_with_type(sc, gchar___sym, (gchar**)gtk_about_dialog_get_authors((GtkAboutDialog*)s7_c_pointer_with_type(sc, about, GtkAboutDialog__sym, __func__, 0))));
}

static s7_pointer lg_gtk_about_dialog_set_authors(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_about_dialog_set_authors "void gtk_about_dialog_set_authors(GtkAboutDialog* about, gchar** authors)"
  s7_pointer _p;
  s7_pointer about, authors;
  _p = args;
  about = s7_car(_p); _p = s7_cdr(_p);
  authors = s7_car(_p);
  gtk_about_dialog_set_authors((GtkAboutDialog*)s7_c_pointer_with_type(sc, about, GtkAboutDialog__sym, __func__, 0), (const gchar**)s7_c_pointer_with_type(sc, authors, gchar___sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_about_dialog_get_documenters(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_about_dialog_get_documenters "gchar** gtk_about_dialog_get_documenters(GtkAboutDialog* about)"
  s7_pointer about;
  about = s7_car(args);
    return(lg_make_c_pointer_with_type(sc, gchar___sym, (gchar**)gtk_about_dialog_get_documenters((GtkAboutDialog*)s7_c_pointer_with_type(sc, about, GtkAboutDialog__sym, __func__, 0))));
}

static s7_pointer lg_gtk_about_dialog_set_documenters(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_about_dialog_set_documenters "void gtk_about_dialog_set_documenters(GtkAboutDialog* about, \
gchar** documenters)"
  s7_pointer _p;
  s7_pointer about, documenters;
  _p = args;
  about = s7_car(_p); _p = s7_cdr(_p);
  documenters = s7_car(_p);
  gtk_about_dialog_set_documenters((GtkAboutDialog*)s7_c_pointer_with_type(sc, about, GtkAboutDialog__sym, __func__, 0), (const gchar**)s7_c_pointer_with_type(sc, documenters, gchar___sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_about_dialog_get_artists(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_about_dialog_get_artists "gchar** gtk_about_dialog_get_artists(GtkAboutDialog* about)"
  s7_pointer about;
  about = s7_car(args);
    return(lg_make_c_pointer_with_type(sc, gchar___sym, (gchar**)gtk_about_dialog_get_artists((GtkAboutDialog*)s7_c_pointer_with_type(sc, about, GtkAboutDialog__sym, __func__, 0))));
}

static s7_pointer lg_gtk_about_dialog_set_artists(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_about_dialog_set_artists "void gtk_about_dialog_set_artists(GtkAboutDialog* about, gchar** artists)"
  s7_pointer _p;
  s7_pointer about, artists;
  _p = args;
  about = s7_car(_p); _p = s7_cdr(_p);
  artists = s7_car(_p);
  gtk_about_dialog_set_artists((GtkAboutDialog*)s7_c_pointer_with_type(sc, about, GtkAboutDialog__sym, __func__, 0), (const gchar**)s7_c_pointer_with_type(sc, artists, gchar___sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_about_dialog_get_translator_credits(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_about_dialog_get_translator_credits "gchar* gtk_about_dialog_get_translator_credits(GtkAboutDialog* about)"
  s7_pointer about;
  about = s7_car(args);
  return(s7_make_string(sc, gtk_about_dialog_get_translator_credits((GtkAboutDialog*)s7_c_pointer_with_type(sc, about, GtkAboutDialog__sym, __func__, 0))));
}

static s7_pointer lg_gtk_about_dialog_set_translator_credits(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_about_dialog_set_translator_credits "void gtk_about_dialog_set_translator_credits(GtkAboutDialog* about, \
gchar* translator_credits)"
  s7_pointer _p;
  s7_pointer about, translator_credits;
  _p = args;
  about = s7_car(_p); _p = s7_cdr(_p);
  translator_credits = s7_car(_p);
  if (!s7_is_string(translator_credits)) s7_wrong_type_arg_error(sc, "gtk_about_dialog_set_translator_credits", 2, translator_credits, "gchar*");
  gtk_about_dialog_set_translator_credits((GtkAboutDialog*)s7_c_pointer_with_type(sc, about, GtkAboutDialog__sym, __func__, 0), (gchar*)s7_string(translator_credits));
  return(lg_false);
}

static s7_pointer lg_gtk_about_dialog_get_program_name(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_about_dialog_get_program_name "gchar* gtk_about_dialog_get_program_name(GtkAboutDialog* about)"
  s7_pointer about;
  about = s7_car(args);
  return(s7_make_string(sc, gtk_about_dialog_get_program_name((GtkAboutDialog*)s7_c_pointer_with_type(sc, about, GtkAboutDialog__sym, __func__, 0))));
}

static s7_pointer lg_gtk_about_dialog_set_program_name(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_about_dialog_set_program_name "void gtk_about_dialog_set_program_name(GtkAboutDialog* about, \
gchar* name)"
  s7_pointer _p;
  s7_pointer about, name;
  _p = args;
  about = s7_car(_p); _p = s7_cdr(_p);
  name = s7_car(_p);
  if (!s7_is_string(name)) s7_wrong_type_arg_error(sc, "gtk_about_dialog_set_program_name", 2, name, "gchar*");
  gtk_about_dialog_set_program_name((GtkAboutDialog*)s7_c_pointer_with_type(sc, about, GtkAboutDialog__sym, __func__, 0), (gchar*)s7_string(name));
  return(lg_false);
}

static s7_pointer lg_gtk_icon_view_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_new "GtkWidget* gtk_icon_view_new( void)"
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_icon_view_new()));
}

static s7_pointer lg_gtk_icon_view_new_with_model(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_new_with_model "GtkWidget* gtk_icon_view_new_with_model(GtkTreeModel* model)"
  s7_pointer model;
  model = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_icon_view_new_with_model((GtkTreeModel*)s7_c_pointer_with_type(sc, model, GtkTreeModel__sym, __func__, 0))));
}

static s7_pointer lg_gtk_icon_view_set_model(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_set_model "void gtk_icon_view_set_model(GtkIconView* icon_view, GtkTreeModel* model)"
  s7_pointer _p;
  s7_pointer icon_view, model;
  _p = args;
  icon_view = s7_car(_p); _p = s7_cdr(_p);
  model = s7_car(_p);
  gtk_icon_view_set_model((GtkIconView*)s7_c_pointer_with_type(sc, icon_view, GtkIconView__sym, __func__, 0), (GtkTreeModel*)s7_c_pointer_with_type(sc, model, GtkTreeModel__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_icon_view_get_model(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_get_model "GtkTreeModel* gtk_icon_view_get_model(GtkIconView* icon_view)"
  s7_pointer icon_view;
  icon_view = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GtkTreeModel__sym, gtk_icon_view_get_model((GtkIconView*)s7_c_pointer_with_type(sc, icon_view, GtkIconView__sym, __func__, 0))));
}

static s7_pointer lg_gtk_icon_view_set_text_column(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_set_text_column "void gtk_icon_view_set_text_column(GtkIconView* icon_view, \
gint column)"
  s7_pointer _p;
  s7_pointer icon_view, column;
  _p = args;
  icon_view = s7_car(_p); _p = s7_cdr(_p);
  column = s7_car(_p);
  if (!s7_is_integer(column)) s7_wrong_type_arg_error(sc, "gtk_icon_view_set_text_column", 2, column, "gint");
  gtk_icon_view_set_text_column((GtkIconView*)s7_c_pointer_with_type(sc, icon_view, GtkIconView__sym, __func__, 0), (gint)s7_integer(column));
  return(lg_false);
}

static s7_pointer lg_gtk_icon_view_get_text_column(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_get_text_column "gint gtk_icon_view_get_text_column(GtkIconView* icon_view)"
  s7_pointer icon_view;
  icon_view = s7_car(args);
  return(s7_make_integer(sc, gtk_icon_view_get_text_column((GtkIconView*)s7_c_pointer_with_type(sc, icon_view, GtkIconView__sym, __func__, 0))));
}

static s7_pointer lg_gtk_icon_view_set_markup_column(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_set_markup_column "void gtk_icon_view_set_markup_column(GtkIconView* icon_view, \
gint column)"
  s7_pointer _p;
  s7_pointer icon_view, column;
  _p = args;
  icon_view = s7_car(_p); _p = s7_cdr(_p);
  column = s7_car(_p);
  if (!s7_is_integer(column)) s7_wrong_type_arg_error(sc, "gtk_icon_view_set_markup_column", 2, column, "gint");
  gtk_icon_view_set_markup_column((GtkIconView*)s7_c_pointer_with_type(sc, icon_view, GtkIconView__sym, __func__, 0), (gint)s7_integer(column));
  return(lg_false);
}

static s7_pointer lg_gtk_icon_view_get_markup_column(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_get_markup_column "gint gtk_icon_view_get_markup_column(GtkIconView* icon_view)"
  s7_pointer icon_view;
  icon_view = s7_car(args);
  return(s7_make_integer(sc, gtk_icon_view_get_markup_column((GtkIconView*)s7_c_pointer_with_type(sc, icon_view, GtkIconView__sym, __func__, 0))));
}

static s7_pointer lg_gtk_icon_view_set_pixbuf_column(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_set_pixbuf_column "void gtk_icon_view_set_pixbuf_column(GtkIconView* icon_view, \
gint column)"
  s7_pointer _p;
  s7_pointer icon_view, column;
  _p = args;
  icon_view = s7_car(_p); _p = s7_cdr(_p);
  column = s7_car(_p);
  if (!s7_is_integer(column)) s7_wrong_type_arg_error(sc, "gtk_icon_view_set_pixbuf_column", 2, column, "gint");
  gtk_icon_view_set_pixbuf_column((GtkIconView*)s7_c_pointer_with_type(sc, icon_view, GtkIconView__sym, __func__, 0), (gint)s7_integer(column));
  return(lg_false);
}

static s7_pointer lg_gtk_icon_view_get_pixbuf_column(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_get_pixbuf_column "gint gtk_icon_view_get_pixbuf_column(GtkIconView* icon_view)"
  s7_pointer icon_view;
  icon_view = s7_car(args);
  return(s7_make_integer(sc, gtk_icon_view_get_pixbuf_column((GtkIconView*)s7_c_pointer_with_type(sc, icon_view, GtkIconView__sym, __func__, 0))));
}

static s7_pointer lg_gtk_icon_view_get_path_at_pos(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_get_path_at_pos "GtkTreePath* gtk_icon_view_get_path_at_pos(GtkIconView* icon_view, \
gint x, gint y)"
  s7_pointer _p;
  s7_pointer icon_view, x, y;
  _p = args;
  icon_view = s7_car(_p); _p = s7_cdr(_p);
  x = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(x)) s7_wrong_type_arg_error(sc, "gtk_icon_view_get_path_at_pos", 2, x, "gint");
  y = s7_car(_p);
  if (!s7_is_integer(y)) s7_wrong_type_arg_error(sc, "gtk_icon_view_get_path_at_pos", 3, y, "gint");
  return(lg_make_c_pointer_with_type(sc, GtkTreePath__sym, gtk_icon_view_get_path_at_pos((GtkIconView*)s7_c_pointer_with_type(sc, icon_view, GtkIconView__sym, __func__, 0), (gint)s7_integer(x), (gint)s7_integer(y))));
}

static s7_pointer lg_gtk_icon_view_selected_foreach(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_selected_foreach "void gtk_icon_view_selected_foreach(GtkIconView* icon_view, \
GtkIconViewForeachFunc func, lambda_data func_info)"
  s7_pointer _p;
  s7_pointer icon_view, func, func_info;
  _p = args;
  icon_view = s7_car(_p); _p = s7_cdr(_p);
  func = s7_car(_p); _p = s7_cdr(_p);
  func_info = s7_car(_p);
  {
    s7_pointer lg_ptr = s7_list(sc, 5, func, func_info, lg_false, lg_false, lg_false);
    s7_gc_protect(sc, lg_ptr);
    gtk_icon_view_selected_foreach((GtkIconView*)s7_c_pointer_with_type(sc, icon_view, GtkIconView__sym, __func__, 0), lg_icon_view_foreach, (gpointer)lg_ptr);
    return(lg_false);
   }
}

static s7_pointer lg_gtk_icon_view_set_selection_mode(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_set_selection_mode "void gtk_icon_view_set_selection_mode(GtkIconView* icon_view, \
GtkSelectionMode mode)"
  s7_pointer _p;
  s7_pointer icon_view, mode;
  _p = args;
  icon_view = s7_car(_p); _p = s7_cdr(_p);
  mode = s7_car(_p);
  if (!s7_is_integer(mode)) s7_wrong_type_arg_error(sc, "gtk_icon_view_set_selection_mode", 2, mode, "GtkSelectionMode");
  gtk_icon_view_set_selection_mode((GtkIconView*)s7_c_pointer_with_type(sc, icon_view, GtkIconView__sym, __func__, 0), (GtkSelectionMode)s7_integer(mode));
  return(lg_false);
}

static s7_pointer lg_gtk_icon_view_get_selection_mode(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_get_selection_mode "GtkSelectionMode gtk_icon_view_get_selection_mode(GtkIconView* icon_view)"
  s7_pointer icon_view;
  icon_view = s7_car(args);
  return(s7_make_integer(sc, gtk_icon_view_get_selection_mode((GtkIconView*)s7_c_pointer_with_type(sc, icon_view, GtkIconView__sym, __func__, 0))));
}

static s7_pointer lg_gtk_icon_view_select_path(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_select_path "void gtk_icon_view_select_path(GtkIconView* icon_view, GtkTreePath* path)"
  s7_pointer _p;
  s7_pointer icon_view, path;
  _p = args;
  icon_view = s7_car(_p); _p = s7_cdr(_p);
  path = s7_car(_p);
  gtk_icon_view_select_path((GtkIconView*)s7_c_pointer_with_type(sc, icon_view, GtkIconView__sym, __func__, 0), (GtkTreePath*)s7_c_pointer_with_type(sc, path, GtkTreePath__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_icon_view_unselect_path(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_unselect_path "void gtk_icon_view_unselect_path(GtkIconView* icon_view, GtkTreePath* path)"
  s7_pointer _p;
  s7_pointer icon_view, path;
  _p = args;
  icon_view = s7_car(_p); _p = s7_cdr(_p);
  path = s7_car(_p);
  gtk_icon_view_unselect_path((GtkIconView*)s7_c_pointer_with_type(sc, icon_view, GtkIconView__sym, __func__, 0), (GtkTreePath*)s7_c_pointer_with_type(sc, path, GtkTreePath__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_icon_view_path_is_selected(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_path_is_selected "gboolean gtk_icon_view_path_is_selected(GtkIconView* icon_view, \
GtkTreePath* path)"
  s7_pointer _p;
  s7_pointer icon_view, path;
  _p = args;
  icon_view = s7_car(_p); _p = s7_cdr(_p);
  path = s7_car(_p);
  return(s7_make_boolean(sc, gtk_icon_view_path_is_selected((GtkIconView*)s7_c_pointer_with_type(sc, icon_view, GtkIconView__sym, __func__, 0), (GtkTreePath*)s7_c_pointer_with_type(sc, path, GtkTreePath__sym, __func__, 0))));
}

static s7_pointer lg_gtk_icon_view_get_selected_items(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_get_selected_items "GList* gtk_icon_view_get_selected_items(GtkIconView* icon_view)"
  s7_pointer icon_view;
  icon_view = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GList__sym, gtk_icon_view_get_selected_items((GtkIconView*)s7_c_pointer_with_type(sc, icon_view, GtkIconView__sym, __func__, 0))));
}

static s7_pointer lg_gtk_icon_view_select_all(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_select_all "void gtk_icon_view_select_all(GtkIconView* icon_view)"
  s7_pointer icon_view;
  icon_view = s7_car(args);
  gtk_icon_view_select_all((GtkIconView*)s7_c_pointer_with_type(sc, icon_view, GtkIconView__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_icon_view_unselect_all(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_unselect_all "void gtk_icon_view_unselect_all(GtkIconView* icon_view)"
  s7_pointer icon_view;
  icon_view = s7_car(args);
  gtk_icon_view_unselect_all((GtkIconView*)s7_c_pointer_with_type(sc, icon_view, GtkIconView__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_icon_view_item_activated(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_item_activated "void gtk_icon_view_item_activated(GtkIconView* icon_view, GtkTreePath* path)"
  s7_pointer _p;
  s7_pointer icon_view, path;
  _p = args;
  icon_view = s7_car(_p); _p = s7_cdr(_p);
  path = s7_car(_p);
  gtk_icon_view_item_activated((GtkIconView*)s7_c_pointer_with_type(sc, icon_view, GtkIconView__sym, __func__, 0), (GtkTreePath*)s7_c_pointer_with_type(sc, path, GtkTreePath__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_cell_renderer_combo_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_renderer_combo_new "GtkCellRenderer* gtk_cell_renderer_combo_new( void)"
  return(lg_make_c_pointer_with_type(sc, GtkCellRenderer__sym, gtk_cell_renderer_combo_new()));
}

static s7_pointer lg_gtk_cell_renderer_progress_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_renderer_progress_new "GtkCellRenderer* gtk_cell_renderer_progress_new( void)"
  return(lg_make_c_pointer_with_type(sc, GtkCellRenderer__sym, gtk_cell_renderer_progress_new()));
}

static s7_pointer lg_gtk_combo_box_set_row_separator_func(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_combo_box_set_row_separator_func "void gtk_combo_box_set_row_separator_func(GtkComboBox* combo_box, \
GtkTreeViewRowSeparatorFunc func, lambda_data func_info, GtkDestroyNotify destroy)"
  s7_pointer _p;
  s7_pointer combo_box, func, func_info, destroy;
  _p = args;
  combo_box = s7_car(_p); _p = s7_cdr(_p);
  func = s7_car(_p); _p = s7_cdr(_p);
  func_info = s7_car(_p); _p = s7_cdr(_p);
  destroy = s7_car(_p);
  {
    s7_pointer lg_ptr = s7_list(sc, 5, func, func_info, lg_false, lg_false, lg_false);
    s7_gc_protect(sc, lg_ptr);
    s7_list_set(sc, lg_ptr, 3, destroy);
    gtk_combo_box_set_row_separator_func((GtkComboBox*)s7_c_pointer_with_type(sc, combo_box, GtkComboBox__sym, __func__, 0), lg_row_separator, (gpointer)lg_ptr, lg_destroy_func);
    return(lg_false);
   }
}

static s7_pointer lg_gtk_label_set_ellipsize(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_label_set_ellipsize "void gtk_label_set_ellipsize(GtkLabel* label, PangoEllipsizeMode mode)"
  s7_pointer _p;
  s7_pointer label, mode;
  _p = args;
  label = s7_car(_p); _p = s7_cdr(_p);
  mode = s7_car(_p);
  if (!s7_is_integer(mode)) s7_wrong_type_arg_error(sc, "gtk_label_set_ellipsize", 2, mode, "PangoEllipsizeMode");
  gtk_label_set_ellipsize((GtkLabel*)s7_c_pointer_with_type(sc, label, GtkLabel__sym, __func__, 0), (PangoEllipsizeMode)s7_integer(mode));
  return(lg_false);
}

static s7_pointer lg_gtk_label_get_ellipsize(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_label_get_ellipsize "PangoEllipsizeMode gtk_label_get_ellipsize(GtkLabel* label)"
  s7_pointer label;
  label = s7_car(args);
  return(s7_make_integer(sc, gtk_label_get_ellipsize((GtkLabel*)s7_c_pointer_with_type(sc, label, GtkLabel__sym, __func__, 0))));
}

static s7_pointer lg_pango_attr_fallback_new(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_attr_fallback_new "PangoAttribute* pango_attr_fallback_new(gboolean enable_fallback)"
  s7_pointer enable_fallback;
  enable_fallback = s7_car(args);
  if (!s7_is_boolean(enable_fallback)) s7_wrong_type_arg_error(sc, "pango_attr_fallback_new", 1, enable_fallback, "gboolean");
  return(lg_make_c_pointer_with_type(sc, PangoAttribute__sym, pango_attr_fallback_new((gboolean)lg_boolean(enable_fallback))));
}

static s7_pointer lg_pango_attr_letter_spacing_new(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_attr_letter_spacing_new "PangoAttribute* pango_attr_letter_spacing_new(int letter_spacing)"
  s7_pointer letter_spacing;
  letter_spacing = s7_car(args);
  if (!s7_is_integer(letter_spacing)) s7_wrong_type_arg_error(sc, "pango_attr_letter_spacing_new", 1, letter_spacing, "int");
  return(lg_make_c_pointer_with_type(sc, PangoAttribute__sym, pango_attr_letter_spacing_new((int)s7_integer(letter_spacing))));
}

static s7_pointer lg_pango_attr_list_filter(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_attr_list_filter "PangoAttrList* pango_attr_list_filter(PangoAttrList* list, PangoAttrFilterFunc func, \
gpointer data)"
  s7_pointer _p;
  s7_pointer list, func, data;
  _p = args;
  list = s7_car(_p); _p = s7_cdr(_p);
  func = s7_car(_p); _p = s7_cdr(_p);
  data = s7_car(_p);
  return(lg_make_c_pointer_with_type(sc, PangoAttrList__sym, pango_attr_list_filter((PangoAttrList*)s7_c_pointer_with_type(sc, list, PangoAttrList__sym, __func__, 0), (PangoAttrFilterFunc)s7_c_pointer_with_type(sc, func, PangoAttrFilterFunc_sym, __func__, 0), (gpointer)s7_c_pointer_with_type(sc, data, gpointer_sym, __func__, 0))));
}

static s7_pointer lg_pango_attr_iterator_get_attrs(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_attr_iterator_get_attrs "GSList* pango_attr_iterator_get_attrs(PangoAttrIterator* iterator)"
  s7_pointer iterator;
  iterator = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GSList__sym, pango_attr_iterator_get_attrs((PangoAttrIterator*)s7_c_pointer_with_type(sc, iterator, PangoAttrIterator__sym, __func__, 0))));
}

static s7_pointer lg_pango_font_metrics_get_underline_position(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_metrics_get_underline_position "int pango_font_metrics_get_underline_position(PangoFontMetrics* metrics)"
  s7_pointer metrics;
  metrics = s7_car(args);
  return(s7_make_integer(sc, pango_font_metrics_get_underline_position((PangoFontMetrics*)s7_c_pointer_with_type(sc, metrics, PangoFontMetrics__sym, __func__, 0))));
}

static s7_pointer lg_pango_font_metrics_get_underline_thickness(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_metrics_get_underline_thickness "int pango_font_metrics_get_underline_thickness(PangoFontMetrics* metrics)"
  s7_pointer metrics;
  metrics = s7_car(args);
  return(s7_make_integer(sc, pango_font_metrics_get_underline_thickness((PangoFontMetrics*)s7_c_pointer_with_type(sc, metrics, PangoFontMetrics__sym, __func__, 0))));
}

static s7_pointer lg_pango_font_metrics_get_strikethrough_position(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_metrics_get_strikethrough_position "int pango_font_metrics_get_strikethrough_position(PangoFontMetrics* metrics)"
  s7_pointer metrics;
  metrics = s7_car(args);
  return(s7_make_integer(sc, pango_font_metrics_get_strikethrough_position((PangoFontMetrics*)s7_c_pointer_with_type(sc, metrics, PangoFontMetrics__sym, __func__, 0))));
}

static s7_pointer lg_pango_font_metrics_get_strikethrough_thickness(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_metrics_get_strikethrough_thickness "int pango_font_metrics_get_strikethrough_thickness(PangoFontMetrics* metrics)"
  s7_pointer metrics;
  metrics = s7_car(args);
  return(s7_make_integer(sc, pango_font_metrics_get_strikethrough_thickness((PangoFontMetrics*)s7_c_pointer_with_type(sc, metrics, PangoFontMetrics__sym, __func__, 0))));
}

static s7_pointer lg_pango_font_family_is_monospace(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_family_is_monospace "gboolean pango_font_family_is_monospace(PangoFontFamily* family)"
  s7_pointer family;
  family = s7_car(args);
  return(s7_make_boolean(sc, pango_font_family_is_monospace((PangoFontFamily*)s7_c_pointer_with_type(sc, family, PangoFontFamily__sym, __func__, 0))));
}

static s7_pointer lg_pango_font_face_list_sizes(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_face_list_sizes "void pango_font_face_list_sizes(PangoFontFace* face, int** [sizes], \
int* [n_sizes])"
  s7_pointer _p;
  s7_pointer face;
  int* ref_sizes = NULL;
  int ref_n_sizes;
  _p = args;
  face = s7_car(_p);
  pango_font_face_list_sizes((PangoFontFace*)s7_c_pointer_with_type(sc, face, PangoFontFace__sym, __func__, 0), &ref_sizes, &ref_n_sizes);
    return(s7_list(sc, 2, s7_make_c_pointer(sc, ref_sizes), s7_make_integer(sc, ref_n_sizes)));
}

static s7_pointer lg_pango_layout_set_auto_dir(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_set_auto_dir "void pango_layout_set_auto_dir(PangoLayout* layout, gboolean auto_dir)"
  s7_pointer _p;
  s7_pointer layout, auto_dir;
  _p = args;
  layout = s7_car(_p); _p = s7_cdr(_p);
  auto_dir = s7_car(_p);
  if (!s7_is_boolean(auto_dir)) s7_wrong_type_arg_error(sc, "pango_layout_set_auto_dir", 2, auto_dir, "gboolean");
  pango_layout_set_auto_dir((PangoLayout*)s7_c_pointer_with_type(sc, layout, PangoLayout__sym, __func__, 0), (gboolean)lg_boolean(auto_dir));
  return(lg_false);
}

static s7_pointer lg_pango_layout_get_auto_dir(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_get_auto_dir "gboolean pango_layout_get_auto_dir(PangoLayout* layout)"
  s7_pointer layout;
  layout = s7_car(args);
  return(s7_make_boolean(sc, pango_layout_get_auto_dir((PangoLayout*)s7_c_pointer_with_type(sc, layout, PangoLayout__sym, __func__, 0))));
}

static s7_pointer lg_pango_script_iter_new(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_script_iter_new "PangoScriptIter* pango_script_iter_new(char* text, int length)"
  s7_pointer _p;
  s7_pointer text, length;
  _p = args;
  text = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(text)) s7_wrong_type_arg_error(sc, "pango_script_iter_new", 1, text, "char*");
  length = s7_car(_p);
  if (!s7_is_integer(length)) s7_wrong_type_arg_error(sc, "pango_script_iter_new", 2, length, "int");
  return(lg_make_c_pointer_with_type(sc, PangoScriptIter__sym, pango_script_iter_new((char*)s7_string(text), (int)s7_integer(length))));
}

static s7_pointer lg_pango_script_iter_get_range(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_script_iter_get_range "void pango_script_iter_get_range(PangoScriptIter* iter, char** [start], \
char** [end], PangoScript* [script])"
  s7_pointer _p;
  s7_pointer iter;
  char* ref_start = NULL;
  char* ref_end = NULL;
  PangoScript ref_script;
  _p = args;
  iter = s7_car(_p);
  pango_script_iter_get_range((PangoScriptIter*)s7_c_pointer_with_type(sc, iter, PangoScriptIter__sym, __func__, 0), (const char**)&ref_start, (const char**)&ref_end, &ref_script);
    return(s7_list(sc, 3, s7_make_string(sc, ref_start), s7_make_string(sc, ref_end), s7_make_integer(sc, ref_script)));
}

static s7_pointer lg_pango_script_iter_next(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_script_iter_next "gboolean pango_script_iter_next(PangoScriptIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  return(s7_make_boolean(sc, pango_script_iter_next((PangoScriptIter*)s7_c_pointer_with_type(sc, iter, PangoScriptIter__sym, __func__, 0))));
}

static s7_pointer lg_pango_script_iter_free(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_script_iter_free "void pango_script_iter_free(PangoScriptIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  pango_script_iter_free((PangoScriptIter*)s7_c_pointer_with_type(sc, iter, PangoScriptIter__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_file_chooser_button_new_with_dialog(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_file_chooser_button_new_with_dialog "GtkWidget* gtk_file_chooser_button_new_with_dialog(GtkWidget* dialog)"
  s7_pointer dialog;
  dialog = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_file_chooser_button_new_with_dialog((GtkWidget*)s7_c_pointer_with_type(sc, dialog, GtkWidget__sym, __func__, 0))));
}

static s7_pointer lg_gtk_file_chooser_button_get_title(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_file_chooser_button_get_title "gchar* gtk_file_chooser_button_get_title(GtkFileChooserButton* button)"
  s7_pointer button;
  button = s7_car(args);
  return(s7_make_string(sc, gtk_file_chooser_button_get_title((GtkFileChooserButton*)s7_c_pointer_with_type(sc, button, GtkFileChooserButton__sym, __func__, 0))));
}

static s7_pointer lg_gtk_file_chooser_button_set_title(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_file_chooser_button_set_title "void gtk_file_chooser_button_set_title(GtkFileChooserButton* button, \
gchar* title)"
  s7_pointer _p;
  s7_pointer button, title;
  _p = args;
  button = s7_car(_p); _p = s7_cdr(_p);
  title = s7_car(_p);
  if (!s7_is_string(title)) s7_wrong_type_arg_error(sc, "gtk_file_chooser_button_set_title", 2, title, "gchar*");
  gtk_file_chooser_button_set_title((GtkFileChooserButton*)s7_c_pointer_with_type(sc, button, GtkFileChooserButton__sym, __func__, 0), (gchar*)s7_string(title));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_set_hover_expand(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_set_hover_expand "void gtk_tree_view_set_hover_expand(GtkTreeView* tree_view, \
gboolean expand)"
  s7_pointer _p;
  s7_pointer tree_view, expand;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  expand = s7_car(_p);
  if (!s7_is_boolean(expand)) s7_wrong_type_arg_error(sc, "gtk_tree_view_set_hover_expand", 2, expand, "gboolean");
  gtk_tree_view_set_hover_expand((GtkTreeView*)s7_c_pointer_with_type(sc, tree_view, GtkTreeView__sym, __func__, 0), (gboolean)lg_boolean(expand));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_get_hover_expand(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_get_hover_expand "gboolean gtk_tree_view_get_hover_expand(GtkTreeView* tree_view)"
  s7_pointer tree_view;
  tree_view = s7_car(args);
  return(s7_make_boolean(sc, gtk_tree_view_get_hover_expand((GtkTreeView*)s7_c_pointer_with_type(sc, tree_view, GtkTreeView__sym, __func__, 0))));
}

static s7_pointer lg_gtk_about_dialog_get_logo_icon_name(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_about_dialog_get_logo_icon_name "gchar* gtk_about_dialog_get_logo_icon_name(GtkAboutDialog* about)"
  s7_pointer about;
  about = s7_car(args);
  return(s7_make_string(sc, gtk_about_dialog_get_logo_icon_name((GtkAboutDialog*)s7_c_pointer_with_type(sc, about, GtkAboutDialog__sym, __func__, 0))));
}

static s7_pointer lg_gtk_about_dialog_set_logo_icon_name(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_about_dialog_set_logo_icon_name "void gtk_about_dialog_set_logo_icon_name(GtkAboutDialog* about, \
gchar* icon_name)"
  s7_pointer _p;
  s7_pointer about, icon_name;
  _p = args;
  about = s7_car(_p); _p = s7_cdr(_p);
  icon_name = s7_car(_p);
  if (!s7_is_string(icon_name)) s7_wrong_type_arg_error(sc, "gtk_about_dialog_set_logo_icon_name", 2, icon_name, "gchar*");
  gtk_about_dialog_set_logo_icon_name((GtkAboutDialog*)s7_c_pointer_with_type(sc, about, GtkAboutDialog__sym, __func__, 0), (gchar*)s7_string(icon_name));
  return(lg_false);
}

static s7_pointer lg_gtk_accelerator_get_label(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_accelerator_get_label "gchar* gtk_accelerator_get_label(guint accelerator_key, GdkModifierType accelerator_mods)"
  s7_pointer _p;
  s7_pointer accelerator_key, accelerator_mods;
  _p = args;
  accelerator_key = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(accelerator_key)) s7_wrong_type_arg_error(sc, "gtk_accelerator_get_label", 1, accelerator_key, "guint");
  accelerator_mods = s7_car(_p);
  if (!s7_is_integer(accelerator_mods)) s7_wrong_type_arg_error(sc, "gtk_accelerator_get_label", 2, accelerator_mods, "GdkModifierType");
  {
    gchar* res_ult;
    s7_pointer rtn;
    res_ult = gtk_accelerator_get_label((guint)s7_integer(accelerator_key), (GdkModifierType)s7_integer(accelerator_mods));
    rtn = s7_make_string(sc, res_ult);
    g_free(res_ult);
    return(rtn);
  }
}

static s7_pointer lg_gtk_file_chooser_button_get_width_chars(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_file_chooser_button_get_width_chars "gint gtk_file_chooser_button_get_width_chars(GtkFileChooserButton* button)"
  s7_pointer button;
  button = s7_car(args);
  return(s7_make_integer(sc, gtk_file_chooser_button_get_width_chars((GtkFileChooserButton*)s7_c_pointer_with_type(sc, button, GtkFileChooserButton__sym, __func__, 0))));
}

static s7_pointer lg_gtk_file_chooser_button_set_width_chars(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_file_chooser_button_set_width_chars "void gtk_file_chooser_button_set_width_chars(GtkFileChooserButton* button, \
gint n_chars)"
  s7_pointer _p;
  s7_pointer button, n_chars;
  _p = args;
  button = s7_car(_p); _p = s7_cdr(_p);
  n_chars = s7_car(_p);
  if (!s7_is_integer(n_chars)) s7_wrong_type_arg_error(sc, "gtk_file_chooser_button_set_width_chars", 2, n_chars, "gint");
  gtk_file_chooser_button_set_width_chars((GtkFileChooserButton*)s7_c_pointer_with_type(sc, button, GtkFileChooserButton__sym, __func__, 0), (gint)s7_integer(n_chars));
  return(lg_false);
}

static s7_pointer lg_gtk_image_set_pixel_size(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_image_set_pixel_size "void gtk_image_set_pixel_size(GtkImage* image, gint pixel_size)"
  s7_pointer _p;
  s7_pointer image, pixel_size;
  _p = args;
  image = s7_car(_p); _p = s7_cdr(_p);
  pixel_size = s7_car(_p);
  if (!s7_is_integer(pixel_size)) s7_wrong_type_arg_error(sc, "gtk_image_set_pixel_size", 2, pixel_size, "gint");
  gtk_image_set_pixel_size((GtkImage*)s7_c_pointer_with_type(sc, image, GtkImage__sym, __func__, 0), (gint)s7_integer(pixel_size));
  return(lg_false);
}

static s7_pointer lg_gtk_image_get_pixel_size(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_image_get_pixel_size "gint gtk_image_get_pixel_size(GtkImage* image)"
  s7_pointer image;
  image = s7_car(args);
  return(s7_make_integer(sc, gtk_image_get_pixel_size((GtkImage*)s7_c_pointer_with_type(sc, image, GtkImage__sym, __func__, 0))));
}

static s7_pointer lg_gtk_label_set_width_chars(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_label_set_width_chars "void gtk_label_set_width_chars(GtkLabel* label, gint n_chars)"
  s7_pointer _p;
  s7_pointer label, n_chars;
  _p = args;
  label = s7_car(_p); _p = s7_cdr(_p);
  n_chars = s7_car(_p);
  if (!s7_is_integer(n_chars)) s7_wrong_type_arg_error(sc, "gtk_label_set_width_chars", 2, n_chars, "gint");
  gtk_label_set_width_chars((GtkLabel*)s7_c_pointer_with_type(sc, label, GtkLabel__sym, __func__, 0), (gint)s7_integer(n_chars));
  return(lg_false);
}

static s7_pointer lg_gtk_label_get_width_chars(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_label_get_width_chars "gint gtk_label_get_width_chars(GtkLabel* label)"
  s7_pointer label;
  label = s7_car(args);
  return(s7_make_integer(sc, gtk_label_get_width_chars((GtkLabel*)s7_c_pointer_with_type(sc, label, GtkLabel__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_buffer_backspace(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_backspace "gboolean gtk_text_buffer_backspace(GtkTextBuffer* buffer, GtkTextIter* iter, \
gboolean interactive, gboolean default_editable)"
  s7_pointer _p;
  s7_pointer buffer, iter, interactive, default_editable;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  iter = s7_car(_p); _p = s7_cdr(_p);
  interactive = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_boolean(interactive)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_backspace", 3, interactive, "gboolean");
  default_editable = s7_car(_p);
  if (!s7_is_boolean(default_editable)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_backspace", 4, default_editable, "gboolean");
  return(s7_make_boolean(sc, gtk_text_buffer_backspace((GtkTextBuffer*)s7_c_pointer_with_type(sc, buffer, GtkTextBuffer__sym, __func__, 0), (GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0), (gboolean)lg_boolean(interactive), (gboolean)lg_boolean(default_editable))));
}

static s7_pointer lg_gtk_file_filter_add_pixbuf_formats(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_file_filter_add_pixbuf_formats "void gtk_file_filter_add_pixbuf_formats(GtkFileFilter* filter)"
  s7_pointer filter;
  filter = s7_car(args);
  gtk_file_filter_add_pixbuf_formats((GtkFileFilter*)s7_c_pointer_with_type(sc, filter, GtkFileFilter__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_label_set_single_line_mode(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_label_set_single_line_mode "void gtk_label_set_single_line_mode(GtkLabel* label, gboolean single_line_mode)"
  s7_pointer _p;
  s7_pointer label, single_line_mode;
  _p = args;
  label = s7_car(_p); _p = s7_cdr(_p);
  single_line_mode = s7_car(_p);
  if (!s7_is_boolean(single_line_mode)) s7_wrong_type_arg_error(sc, "gtk_label_set_single_line_mode", 2, single_line_mode, "gboolean");
  gtk_label_set_single_line_mode((GtkLabel*)s7_c_pointer_with_type(sc, label, GtkLabel__sym, __func__, 0), (gboolean)lg_boolean(single_line_mode));
  return(lg_false);
}

static s7_pointer lg_gtk_label_get_single_line_mode(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_label_get_single_line_mode "gboolean gtk_label_get_single_line_mode(GtkLabel* label)"
  s7_pointer label;
  label = s7_car(args);
  return(s7_make_boolean(sc, gtk_label_get_single_line_mode((GtkLabel*)s7_c_pointer_with_type(sc, label, GtkLabel__sym, __func__, 0))));
}

static s7_pointer lg_gtk_progress_bar_set_ellipsize(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_progress_bar_set_ellipsize "void gtk_progress_bar_set_ellipsize(GtkProgressBar* pbar, \
PangoEllipsizeMode mode)"
  s7_pointer _p;
  s7_pointer pbar, mode;
  _p = args;
  pbar = s7_car(_p); _p = s7_cdr(_p);
  mode = s7_car(_p);
  if (!s7_is_integer(mode)) s7_wrong_type_arg_error(sc, "gtk_progress_bar_set_ellipsize", 2, mode, "PangoEllipsizeMode");
  gtk_progress_bar_set_ellipsize((GtkProgressBar*)s7_c_pointer_with_type(sc, pbar, GtkProgressBar__sym, __func__, 0), (PangoEllipsizeMode)s7_integer(mode));
  return(lg_false);
}

static s7_pointer lg_gtk_progress_bar_get_ellipsize(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_progress_bar_get_ellipsize "PangoEllipsizeMode gtk_progress_bar_get_ellipsize(GtkProgressBar* pbar)"
  s7_pointer pbar;
  pbar = s7_car(args);
  return(s7_make_integer(sc, gtk_progress_bar_get_ellipsize((GtkProgressBar*)s7_c_pointer_with_type(sc, pbar, GtkProgressBar__sym, __func__, 0))));
}

static s7_pointer lg_pango_attr_underline_color_new(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_attr_underline_color_new "PangoAttribute* pango_attr_underline_color_new(guint16 red, \
guint16 green, guint16 blue)"
  s7_pointer _p;
  s7_pointer red, green, blue;
  _p = args;
  red = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(red)) s7_wrong_type_arg_error(sc, "pango_attr_underline_color_new", 1, red, "guint16");
  green = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(green)) s7_wrong_type_arg_error(sc, "pango_attr_underline_color_new", 2, green, "guint16");
  blue = s7_car(_p);
  if (!s7_is_integer(blue)) s7_wrong_type_arg_error(sc, "pango_attr_underline_color_new", 3, blue, "guint16");
  return(lg_make_c_pointer_with_type(sc, PangoAttribute__sym, pango_attr_underline_color_new((guint16)s7_integer(red), (guint16)s7_integer(green), (guint16)s7_integer(blue))));
}

static s7_pointer lg_pango_attr_strikethrough_color_new(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_attr_strikethrough_color_new "PangoAttribute* pango_attr_strikethrough_color_new(guint16 red, \
guint16 green, guint16 blue)"
  s7_pointer _p;
  s7_pointer red, green, blue;
  _p = args;
  red = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(red)) s7_wrong_type_arg_error(sc, "pango_attr_strikethrough_color_new", 1, red, "guint16");
  green = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(green)) s7_wrong_type_arg_error(sc, "pango_attr_strikethrough_color_new", 2, green, "guint16");
  blue = s7_car(_p);
  if (!s7_is_integer(blue)) s7_wrong_type_arg_error(sc, "pango_attr_strikethrough_color_new", 3, blue, "guint16");
  return(lg_make_c_pointer_with_type(sc, PangoAttribute__sym, pango_attr_strikethrough_color_new((guint16)s7_integer(red), (guint16)s7_integer(green), (guint16)s7_integer(blue))));
}

static s7_pointer lg_pango_renderer_draw_layout(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_renderer_draw_layout "void pango_renderer_draw_layout(PangoRenderer* renderer, PangoLayout* layout, \
int x, int y)"
  s7_pointer _p;
  s7_pointer renderer, layout, x, y;
  _p = args;
  renderer = s7_car(_p); _p = s7_cdr(_p);
  layout = s7_car(_p); _p = s7_cdr(_p);
  x = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(x)) s7_wrong_type_arg_error(sc, "pango_renderer_draw_layout", 3, x, "int");
  y = s7_car(_p);
  if (!s7_is_integer(y)) s7_wrong_type_arg_error(sc, "pango_renderer_draw_layout", 4, y, "int");
  pango_renderer_draw_layout((PangoRenderer*)s7_c_pointer_with_type(sc, renderer, PangoRenderer__sym, __func__, 0), (PangoLayout*)s7_c_pointer_with_type(sc, layout, PangoLayout__sym, __func__, 0), (int)s7_integer(x), (int)s7_integer(y));
  return(lg_false);
}

static s7_pointer lg_pango_renderer_draw_layout_line(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_renderer_draw_layout_line "void pango_renderer_draw_layout_line(PangoRenderer* renderer, \
PangoLayoutLine* line, int x, int y)"
  s7_pointer _p;
  s7_pointer renderer, line, x, y;
  _p = args;
  renderer = s7_car(_p); _p = s7_cdr(_p);
  line = s7_car(_p); _p = s7_cdr(_p);
  x = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(x)) s7_wrong_type_arg_error(sc, "pango_renderer_draw_layout_line", 3, x, "int");
  y = s7_car(_p);
  if (!s7_is_integer(y)) s7_wrong_type_arg_error(sc, "pango_renderer_draw_layout_line", 4, y, "int");
  pango_renderer_draw_layout_line((PangoRenderer*)s7_c_pointer_with_type(sc, renderer, PangoRenderer__sym, __func__, 0), (PangoLayoutLine*)s7_c_pointer_with_type(sc, line, PangoLayoutLine__sym, __func__, 0), (int)s7_integer(x), (int)s7_integer(y));
  return(lg_false);
}

static s7_pointer lg_pango_renderer_draw_glyphs(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_renderer_draw_glyphs "void pango_renderer_draw_glyphs(PangoRenderer* renderer, PangoFont* font, \
PangoGlyphString* glyphs, int x, int y)"
  s7_pointer _p;
  s7_pointer renderer, font, glyphs, x, y;
  _p = args;
  renderer = s7_car(_p); _p = s7_cdr(_p);
  font = s7_car(_p); _p = s7_cdr(_p);
  glyphs = s7_car(_p); _p = s7_cdr(_p);
  x = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(x)) s7_wrong_type_arg_error(sc, "pango_renderer_draw_glyphs", 4, x, "int");
  y = s7_car(_p);
  if (!s7_is_integer(y)) s7_wrong_type_arg_error(sc, "pango_renderer_draw_glyphs", 5, y, "int");
  pango_renderer_draw_glyphs((PangoRenderer*)s7_c_pointer_with_type(sc, renderer, PangoRenderer__sym, __func__, 0), (PangoFont*)s7_c_pointer_with_type(sc, font, PangoFont__sym, __func__, 0), (PangoGlyphString*)s7_c_pointer_with_type(sc, glyphs, PangoGlyphString__sym, __func__, 0), (int)s7_integer(x), (int)s7_integer(y));
  return(lg_false);
}

static s7_pointer lg_pango_renderer_draw_rectangle(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_renderer_draw_rectangle "void pango_renderer_draw_rectangle(PangoRenderer* renderer, \
PangoRenderPart part, int x, int y, int width, int height)"
  s7_pointer _p;
  s7_pointer renderer, part, x, y, width, height;
  _p = args;
  renderer = s7_car(_p); _p = s7_cdr(_p);
  part = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(part)) s7_wrong_type_arg_error(sc, "pango_renderer_draw_rectangle", 2, part, "PangoRenderPart");
  x = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(x)) s7_wrong_type_arg_error(sc, "pango_renderer_draw_rectangle", 3, x, "int");
  y = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(y)) s7_wrong_type_arg_error(sc, "pango_renderer_draw_rectangle", 4, y, "int");
  width = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(width)) s7_wrong_type_arg_error(sc, "pango_renderer_draw_rectangle", 5, width, "int");
  height = s7_car(_p);
  if (!s7_is_integer(height)) s7_wrong_type_arg_error(sc, "pango_renderer_draw_rectangle", 6, height, "int");
  pango_renderer_draw_rectangle((PangoRenderer*)s7_c_pointer_with_type(sc, renderer, PangoRenderer__sym, __func__, 0), (PangoRenderPart)s7_integer(part), (int)s7_integer(x), (int)s7_integer(y), (int)s7_integer(width), (int)s7_integer(height));
  return(lg_false);
}

static s7_pointer lg_pango_renderer_draw_error_underline(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_renderer_draw_error_underline "void pango_renderer_draw_error_underline(PangoRenderer* renderer, \
int x, int y, int width, int height)"
  s7_pointer _p;
  s7_pointer renderer, x, y, width, height;
  _p = args;
  renderer = s7_car(_p); _p = s7_cdr(_p);
  x = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(x)) s7_wrong_type_arg_error(sc, "pango_renderer_draw_error_underline", 2, x, "int");
  y = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(y)) s7_wrong_type_arg_error(sc, "pango_renderer_draw_error_underline", 3, y, "int");
  width = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(width)) s7_wrong_type_arg_error(sc, "pango_renderer_draw_error_underline", 4, width, "int");
  height = s7_car(_p);
  if (!s7_is_integer(height)) s7_wrong_type_arg_error(sc, "pango_renderer_draw_error_underline", 5, height, "int");
  pango_renderer_draw_error_underline((PangoRenderer*)s7_c_pointer_with_type(sc, renderer, PangoRenderer__sym, __func__, 0), (int)s7_integer(x), (int)s7_integer(y), (int)s7_integer(width), (int)s7_integer(height));
  return(lg_false);
}

static s7_pointer lg_pango_renderer_draw_trapezoid(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_renderer_draw_trapezoid "void pango_renderer_draw_trapezoid(PangoRenderer* renderer, \
PangoRenderPart part, double y1, double x11, double x21, double y2, double x12, double x22)"
  s7_pointer _p;
  s7_pointer renderer, part, y1, x11, x21, y2, x12, x22;
  _p = args;
  renderer = s7_car(_p); _p = s7_cdr(_p);
  part = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(part)) s7_wrong_type_arg_error(sc, "pango_renderer_draw_trapezoid", 2, part, "PangoRenderPart");
  y1 = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(y1)) s7_wrong_type_arg_error(sc, "pango_renderer_draw_trapezoid", 3, y1, "double");
  x11 = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(x11)) s7_wrong_type_arg_error(sc, "pango_renderer_draw_trapezoid", 4, x11, "double");
  x21 = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(x21)) s7_wrong_type_arg_error(sc, "pango_renderer_draw_trapezoid", 5, x21, "double");
  y2 = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(y2)) s7_wrong_type_arg_error(sc, "pango_renderer_draw_trapezoid", 6, y2, "double");
  x12 = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(x12)) s7_wrong_type_arg_error(sc, "pango_renderer_draw_trapezoid", 7, x12, "double");
  x22 = s7_car(_p);
  if (!s7_is_real(x22)) s7_wrong_type_arg_error(sc, "pango_renderer_draw_trapezoid", 8, x22, "double");
  pango_renderer_draw_trapezoid((PangoRenderer*)s7_c_pointer_with_type(sc, renderer, PangoRenderer__sym, __func__, 0), (PangoRenderPart)s7_integer(part), (double)s7_real(y1), (double)s7_real(x11), (double)s7_real(x21), (double)s7_real(y2), (double)s7_real(x12), (double)s7_real(x22));
  return(lg_false);
}

static s7_pointer lg_pango_renderer_draw_glyph(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_renderer_draw_glyph "void pango_renderer_draw_glyph(PangoRenderer* renderer, PangoFont* font, \
PangoGlyph glyph, double x, double y)"
  s7_pointer _p;
  s7_pointer renderer, font, glyph, x, y;
  _p = args;
  renderer = s7_car(_p); _p = s7_cdr(_p);
  font = s7_car(_p); _p = s7_cdr(_p);
  glyph = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(glyph)) s7_wrong_type_arg_error(sc, "pango_renderer_draw_glyph", 3, glyph, "PangoGlyph");
  x = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(x)) s7_wrong_type_arg_error(sc, "pango_renderer_draw_glyph", 4, x, "double");
  y = s7_car(_p);
  if (!s7_is_real(y)) s7_wrong_type_arg_error(sc, "pango_renderer_draw_glyph", 5, y, "double");
  pango_renderer_draw_glyph((PangoRenderer*)s7_c_pointer_with_type(sc, renderer, PangoRenderer__sym, __func__, 0), (PangoFont*)s7_c_pointer_with_type(sc, font, PangoFont__sym, __func__, 0), (PangoGlyph)s7_integer(glyph), (double)s7_real(x), (double)s7_real(y));
  return(lg_false);
}

static s7_pointer lg_pango_renderer_activate(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_renderer_activate "void pango_renderer_activate(PangoRenderer* renderer)"
  s7_pointer renderer;
  renderer = s7_car(args);
  pango_renderer_activate((PangoRenderer*)s7_c_pointer_with_type(sc, renderer, PangoRenderer__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_pango_renderer_deactivate(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_renderer_deactivate "void pango_renderer_deactivate(PangoRenderer* renderer)"
  s7_pointer renderer;
  renderer = s7_car(args);
  pango_renderer_deactivate((PangoRenderer*)s7_c_pointer_with_type(sc, renderer, PangoRenderer__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_pango_renderer_part_changed(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_renderer_part_changed "void pango_renderer_part_changed(PangoRenderer* renderer, PangoRenderPart part)"
  s7_pointer _p;
  s7_pointer renderer, part;
  _p = args;
  renderer = s7_car(_p); _p = s7_cdr(_p);
  part = s7_car(_p);
  if (!s7_is_integer(part)) s7_wrong_type_arg_error(sc, "pango_renderer_part_changed", 2, part, "PangoRenderPart");
  pango_renderer_part_changed((PangoRenderer*)s7_c_pointer_with_type(sc, renderer, PangoRenderer__sym, __func__, 0), (PangoRenderPart)s7_integer(part));
  return(lg_false);
}

static s7_pointer lg_pango_renderer_set_color(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_renderer_set_color "void pango_renderer_set_color(PangoRenderer* renderer, PangoRenderPart part, \
PangoColor* color)"
  s7_pointer _p;
  s7_pointer renderer, part, color;
  _p = args;
  renderer = s7_car(_p); _p = s7_cdr(_p);
  part = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(part)) s7_wrong_type_arg_error(sc, "pango_renderer_set_color", 2, part, "PangoRenderPart");
  color = s7_car(_p);
  pango_renderer_set_color((PangoRenderer*)s7_c_pointer_with_type(sc, renderer, PangoRenderer__sym, __func__, 0), (PangoRenderPart)s7_integer(part), (PangoColor*)s7_c_pointer_with_type(sc, color, PangoColor__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_pango_renderer_get_color(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_renderer_get_color "PangoColor* pango_renderer_get_color(PangoRenderer* renderer, PangoRenderPart part)"
  s7_pointer _p;
  s7_pointer renderer, part;
  _p = args;
  renderer = s7_car(_p); _p = s7_cdr(_p);
  part = s7_car(_p);
  if (!s7_is_integer(part)) s7_wrong_type_arg_error(sc, "pango_renderer_get_color", 2, part, "PangoRenderPart");
  return(lg_make_c_pointer_with_type(sc, PangoColor__sym, pango_renderer_get_color((PangoRenderer*)s7_c_pointer_with_type(sc, renderer, PangoRenderer__sym, __func__, 0), (PangoRenderPart)s7_integer(part))));
}

static s7_pointer lg_pango_renderer_set_matrix(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_renderer_set_matrix "void pango_renderer_set_matrix(PangoRenderer* renderer, PangoMatrix* matrix)"
  s7_pointer _p;
  s7_pointer renderer, matrix;
  _p = args;
  renderer = s7_car(_p); _p = s7_cdr(_p);
  matrix = s7_car(_p);
  pango_renderer_set_matrix((PangoRenderer*)s7_c_pointer_with_type(sc, renderer, PangoRenderer__sym, __func__, 0), (PangoMatrix*)s7_c_pointer_with_type(sc, matrix, PangoMatrix__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_g_log_set_handler(s7_scheme *sc, s7_pointer args)
{
  #define H_g_log_set_handler "guint g_log_set_handler(gchar* log_domain, GLogLevelFlags log_levels, \
GLogFunc func, lambda_data func_info)"
  s7_pointer _p;
  s7_pointer log_domain, log_levels, func, func_info;
  _p = args;
  log_domain = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(log_domain)) s7_wrong_type_arg_error(sc, "g_log_set_handler", 1, log_domain, "gchar*");
  log_levels = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(log_levels)) s7_wrong_type_arg_error(sc, "g_log_set_handler", 2, log_levels, "GLogLevelFlags");
  func = s7_car(_p); _p = s7_cdr(_p);
  func_info = s7_car(_p);
  {
    s7_pointer res_ult;
    s7_pointer lg_ptr = s7_list(sc, 5, func, func_info, lg_false, lg_false, lg_false);
    s7_gc_protect(sc, lg_ptr);
    res_ult = s7_make_integer(sc, g_log_set_handler((gchar*)s7_string(log_domain), (GLogLevelFlags)s7_integer(log_levels), lg_g_message_log_func, (gpointer)lg_ptr));
    return(res_ult);
   }
}

static s7_pointer lg_g_log_remove_handler(s7_scheme *sc, s7_pointer args)
{
  #define H_g_log_remove_handler "void g_log_remove_handler(gchar* log_domain, guint handler_id)"
  s7_pointer _p;
  s7_pointer log_domain, handler_id;
  _p = args;
  log_domain = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(log_domain)) s7_wrong_type_arg_error(sc, "g_log_remove_handler", 1, log_domain, "gchar*");
  handler_id = s7_car(_p);
  if (!s7_is_integer(handler_id)) s7_wrong_type_arg_error(sc, "g_log_remove_handler", 2, handler_id, "guint");
  g_log_remove_handler((gchar*)s7_string(log_domain), (guint)s7_integer(handler_id));
  return(lg_false);
}

static s7_pointer lg_gtk_cell_renderer_stop_editing(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_renderer_stop_editing "void gtk_cell_renderer_stop_editing(GtkCellRenderer* cell, \
gboolean canceled)"
  s7_pointer _p;
  s7_pointer cell, canceled;
  _p = args;
  cell = s7_car(_p); _p = s7_cdr(_p);
  canceled = s7_car(_p);
  if (!s7_is_boolean(canceled)) s7_wrong_type_arg_error(sc, "gtk_cell_renderer_stop_editing", 2, canceled, "gboolean");
  gtk_cell_renderer_stop_editing((GtkCellRenderer*)s7_c_pointer_with_type(sc, cell, GtkCellRenderer__sym, __func__, 0), (gboolean)lg_boolean(canceled));
  return(lg_false);
}

static s7_pointer lg_gtk_file_chooser_button_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_file_chooser_button_new "GtkWidget* gtk_file_chooser_button_new(gchar* title, GtkFileChooserAction action)"
  s7_pointer _p;
  s7_pointer title, action;
  _p = args;
  title = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(title)) s7_wrong_type_arg_error(sc, "gtk_file_chooser_button_new", 1, title, "gchar*");
  action = s7_car(_p);
  if (!s7_is_integer(action)) s7_wrong_type_arg_error(sc, "gtk_file_chooser_button_new", 2, action, "GtkFileChooserAction");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_file_chooser_button_new((const gchar*)s7_string(title), (GtkFileChooserAction)s7_integer(action))));
}

static s7_pointer lg_gtk_icon_view_set_columns(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_set_columns "void gtk_icon_view_set_columns(GtkIconView* icon_view, gint columns)"
  s7_pointer _p;
  s7_pointer icon_view, columns;
  _p = args;
  icon_view = s7_car(_p); _p = s7_cdr(_p);
  columns = s7_car(_p);
  if (!s7_is_integer(columns)) s7_wrong_type_arg_error(sc, "gtk_icon_view_set_columns", 2, columns, "gint");
  gtk_icon_view_set_columns((GtkIconView*)s7_c_pointer_with_type(sc, icon_view, GtkIconView__sym, __func__, 0), (gint)s7_integer(columns));
  return(lg_false);
}

static s7_pointer lg_gtk_icon_view_get_columns(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_get_columns "gint gtk_icon_view_get_columns(GtkIconView* icon_view)"
  s7_pointer icon_view;
  icon_view = s7_car(args);
  return(s7_make_integer(sc, gtk_icon_view_get_columns((GtkIconView*)s7_c_pointer_with_type(sc, icon_view, GtkIconView__sym, __func__, 0))));
}

static s7_pointer lg_gtk_icon_view_set_item_width(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_set_item_width "void gtk_icon_view_set_item_width(GtkIconView* icon_view, gint item_width)"
  s7_pointer _p;
  s7_pointer icon_view, item_width;
  _p = args;
  icon_view = s7_car(_p); _p = s7_cdr(_p);
  item_width = s7_car(_p);
  if (!s7_is_integer(item_width)) s7_wrong_type_arg_error(sc, "gtk_icon_view_set_item_width", 2, item_width, "gint");
  gtk_icon_view_set_item_width((GtkIconView*)s7_c_pointer_with_type(sc, icon_view, GtkIconView__sym, __func__, 0), (gint)s7_integer(item_width));
  return(lg_false);
}

static s7_pointer lg_gtk_icon_view_get_item_width(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_get_item_width "gint gtk_icon_view_get_item_width(GtkIconView* icon_view)"
  s7_pointer icon_view;
  icon_view = s7_car(args);
  return(s7_make_integer(sc, gtk_icon_view_get_item_width((GtkIconView*)s7_c_pointer_with_type(sc, icon_view, GtkIconView__sym, __func__, 0))));
}

static s7_pointer lg_gtk_icon_view_set_spacing(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_set_spacing "void gtk_icon_view_set_spacing(GtkIconView* icon_view, gint spacing)"
  s7_pointer _p;
  s7_pointer icon_view, spacing;
  _p = args;
  icon_view = s7_car(_p); _p = s7_cdr(_p);
  spacing = s7_car(_p);
  if (!s7_is_integer(spacing)) s7_wrong_type_arg_error(sc, "gtk_icon_view_set_spacing", 2, spacing, "gint");
  gtk_icon_view_set_spacing((GtkIconView*)s7_c_pointer_with_type(sc, icon_view, GtkIconView__sym, __func__, 0), (gint)s7_integer(spacing));
  return(lg_false);
}

static s7_pointer lg_gtk_icon_view_get_spacing(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_get_spacing "gint gtk_icon_view_get_spacing(GtkIconView* icon_view)"
  s7_pointer icon_view;
  icon_view = s7_car(args);
  return(s7_make_integer(sc, gtk_icon_view_get_spacing((GtkIconView*)s7_c_pointer_with_type(sc, icon_view, GtkIconView__sym, __func__, 0))));
}

static s7_pointer lg_gtk_icon_view_set_row_spacing(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_set_row_spacing "void gtk_icon_view_set_row_spacing(GtkIconView* icon_view, \
gint row_spacing)"
  s7_pointer _p;
  s7_pointer icon_view, row_spacing;
  _p = args;
  icon_view = s7_car(_p); _p = s7_cdr(_p);
  row_spacing = s7_car(_p);
  if (!s7_is_integer(row_spacing)) s7_wrong_type_arg_error(sc, "gtk_icon_view_set_row_spacing", 2, row_spacing, "gint");
  gtk_icon_view_set_row_spacing((GtkIconView*)s7_c_pointer_with_type(sc, icon_view, GtkIconView__sym, __func__, 0), (gint)s7_integer(row_spacing));
  return(lg_false);
}

static s7_pointer lg_gtk_icon_view_get_row_spacing(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_get_row_spacing "gint gtk_icon_view_get_row_spacing(GtkIconView* icon_view)"
  s7_pointer icon_view;
  icon_view = s7_car(args);
  return(s7_make_integer(sc, gtk_icon_view_get_row_spacing((GtkIconView*)s7_c_pointer_with_type(sc, icon_view, GtkIconView__sym, __func__, 0))));
}

static s7_pointer lg_gtk_icon_view_set_column_spacing(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_set_column_spacing "void gtk_icon_view_set_column_spacing(GtkIconView* icon_view, \
gint column_spacing)"
  s7_pointer _p;
  s7_pointer icon_view, column_spacing;
  _p = args;
  icon_view = s7_car(_p); _p = s7_cdr(_p);
  column_spacing = s7_car(_p);
  if (!s7_is_integer(column_spacing)) s7_wrong_type_arg_error(sc, "gtk_icon_view_set_column_spacing", 2, column_spacing, "gint");
  gtk_icon_view_set_column_spacing((GtkIconView*)s7_c_pointer_with_type(sc, icon_view, GtkIconView__sym, __func__, 0), (gint)s7_integer(column_spacing));
  return(lg_false);
}

static s7_pointer lg_gtk_icon_view_get_column_spacing(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_get_column_spacing "gint gtk_icon_view_get_column_spacing(GtkIconView* icon_view)"
  s7_pointer icon_view;
  icon_view = s7_car(args);
  return(s7_make_integer(sc, gtk_icon_view_get_column_spacing((GtkIconView*)s7_c_pointer_with_type(sc, icon_view, GtkIconView__sym, __func__, 0))));
}

static s7_pointer lg_gtk_icon_view_set_margin(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_set_margin "void gtk_icon_view_set_margin(GtkIconView* icon_view, gint margin)"
  s7_pointer _p;
  s7_pointer icon_view, margin;
  _p = args;
  icon_view = s7_car(_p); _p = s7_cdr(_p);
  margin = s7_car(_p);
  if (!s7_is_integer(margin)) s7_wrong_type_arg_error(sc, "gtk_icon_view_set_margin", 2, margin, "gint");
  gtk_icon_view_set_margin((GtkIconView*)s7_c_pointer_with_type(sc, icon_view, GtkIconView__sym, __func__, 0), (gint)s7_integer(margin));
  return(lg_false);
}

static s7_pointer lg_gtk_icon_view_get_margin(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_get_margin "gint gtk_icon_view_get_margin(GtkIconView* icon_view)"
  s7_pointer icon_view;
  icon_view = s7_car(args);
  return(s7_make_integer(sc, gtk_icon_view_get_margin((GtkIconView*)s7_c_pointer_with_type(sc, icon_view, GtkIconView__sym, __func__, 0))));
}

static s7_pointer lg_gtk_label_set_max_width_chars(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_label_set_max_width_chars "void gtk_label_set_max_width_chars(GtkLabel* label, gint n_chars)"
  s7_pointer _p;
  s7_pointer label, n_chars;
  _p = args;
  label = s7_car(_p); _p = s7_cdr(_p);
  n_chars = s7_car(_p);
  if (!s7_is_integer(n_chars)) s7_wrong_type_arg_error(sc, "gtk_label_set_max_width_chars", 2, n_chars, "gint");
  gtk_label_set_max_width_chars((GtkLabel*)s7_c_pointer_with_type(sc, label, GtkLabel__sym, __func__, 0), (gint)s7_integer(n_chars));
  return(lg_false);
}

static s7_pointer lg_gtk_label_get_max_width_chars(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_label_get_max_width_chars "gint gtk_label_get_max_width_chars(GtkLabel* label)"
  s7_pointer label;
  label = s7_car(args);
  return(s7_make_integer(sc, gtk_label_get_max_width_chars((GtkLabel*)s7_c_pointer_with_type(sc, label, GtkLabel__sym, __func__, 0))));
}

static s7_pointer lg_gtk_list_store_insert_with_values(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_list_store_insert_with_values "void gtk_list_store_insert_with_values(GtkListStore* list_store, \
GtkTreeIter* iter, gint position, ...)"
  s7_pointer _p;
  s7_pointer list_store, iter, position;
  _p = args;
  list_store = s7_car(_p); _p = s7_cdr(_p);
  iter = s7_car(_p); _p = s7_cdr(_p);
  position = s7_car(_p);
  if (!s7_is_integer(position)) s7_wrong_type_arg_error(sc, "gtk_list_store_insert_with_values", 3, position, "gint");
  gtk_list_store_insert_with_values((GtkListStore*)s7_c_pointer_with_type(sc, list_store, GtkListStore__sym, __func__, 0), (GtkTreeIter*)s7_c_pointer_with_type(sc, iter, GtkTreeIter__sym, __func__, 0), (gint)s7_integer(position));
  return(lg_false);
}

static s7_pointer lg_gtk_list_store_insert_with_valuesv(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_list_store_insert_with_valuesv "void gtk_list_store_insert_with_valuesv(GtkListStore* list_store, \
GtkTreeIter* iter, gint position, gint* columns, GValue* values, gint n_values)"
  s7_pointer _p;
  s7_pointer list_store, iter, position, columns, values, n_values;
  _p = args;
  list_store = s7_car(_p); _p = s7_cdr(_p);
  iter = s7_car(_p); _p = s7_cdr(_p);
  position = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(position)) s7_wrong_type_arg_error(sc, "gtk_list_store_insert_with_valuesv", 3, position, "gint");
  columns = s7_car(_p); _p = s7_cdr(_p);
  values = s7_car(_p); _p = s7_cdr(_p);
  n_values = s7_car(_p);
  if (!s7_is_integer(n_values)) s7_wrong_type_arg_error(sc, "gtk_list_store_insert_with_valuesv", 6, n_values, "gint");
  gtk_list_store_insert_with_valuesv((GtkListStore*)s7_c_pointer_with_type(sc, list_store, GtkListStore__sym, __func__, 0), (GtkTreeIter*)s7_c_pointer_with_type(sc, iter, GtkTreeIter__sym, __func__, 0), (gint)s7_integer(position), (gint*)s7_c_pointer_with_type(sc, columns, gint__sym, __func__, 0), (GValue*)s7_c_pointer_with_type(sc, values, GValue__sym, __func__, 0), (gint)s7_integer(n_values));
  return(lg_false);
}

static s7_pointer lg_pango_attr_size_new_absolute(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_attr_size_new_absolute "PangoAttribute* pango_attr_size_new_absolute(int size)"
  s7_pointer size;
  size = s7_car(args);
  if (!s7_is_integer(size)) s7_wrong_type_arg_error(sc, "pango_attr_size_new_absolute", 1, size, "int");
  return(lg_make_c_pointer_with_type(sc, PangoAttribute__sym, pango_attr_size_new_absolute((int)s7_integer(size))));
}

static s7_pointer lg_pango_font_description_set_absolute_size(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_description_set_absolute_size "void pango_font_description_set_absolute_size(PangoFontDescription* desc, \
double size)"
  s7_pointer _p;
  s7_pointer desc, size;
  _p = args;
  desc = s7_car(_p); _p = s7_cdr(_p);
  size = s7_car(_p);
  if (!s7_is_real(size)) s7_wrong_type_arg_error(sc, "pango_font_description_set_absolute_size", 2, size, "double");
  pango_font_description_set_absolute_size((PangoFontDescription*)s7_c_pointer_with_type(sc, desc, PangoFontDescription__sym, __func__, 0), (double)s7_real(size));
  return(lg_false);
}

static s7_pointer lg_pango_layout_get_font_description(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_get_font_description "PangoFontDescription* pango_layout_get_font_description(PangoLayout* layout)"
  s7_pointer layout;
  layout = s7_car(args);
    return(lg_make_c_pointer_with_type(sc, PangoFontDescription__sym, (PangoFontDescription*)pango_layout_get_font_description((PangoLayout*)s7_c_pointer_with_type(sc, layout, PangoLayout__sym, __func__, 0))));
}

static s7_pointer lg_gtk_dialog_get_response_for_widget(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_dialog_get_response_for_widget "gint gtk_dialog_get_response_for_widget(GtkDialog* dialog, \
GtkWidget* widget)"
  s7_pointer _p;
  s7_pointer dialog, widget;
  _p = args;
  dialog = s7_car(_p); _p = s7_cdr(_p);
  widget = s7_car(_p);
  return(s7_make_integer(sc, gtk_dialog_get_response_for_widget((GtkDialog*)s7_c_pointer_with_type(sc, dialog, GtkDialog__sym, __func__, 0), (GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0))));
}

static s7_pointer lg_gtk_entry_completion_set_popup_set_width(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_completion_set_popup_set_width "void gtk_entry_completion_set_popup_set_width(GtkEntryCompletion* completion, \
gboolean popup_set_width)"
  s7_pointer _p;
  s7_pointer completion, popup_set_width;
  _p = args;
  completion = s7_car(_p); _p = s7_cdr(_p);
  popup_set_width = s7_car(_p);
  if (!s7_is_boolean(popup_set_width)) s7_wrong_type_arg_error(sc, "gtk_entry_completion_set_popup_set_width", 2, popup_set_width, "gboolean");
  gtk_entry_completion_set_popup_set_width((GtkEntryCompletion*)s7_c_pointer_with_type(sc, completion, GtkEntryCompletion__sym, __func__, 0), (gboolean)lg_boolean(popup_set_width));
  return(lg_false);
}

static s7_pointer lg_gtk_entry_completion_get_popup_set_width(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_completion_get_popup_set_width "gboolean gtk_entry_completion_get_popup_set_width(GtkEntryCompletion* completion)"
  s7_pointer completion;
  completion = s7_car(args);
  return(s7_make_boolean(sc, gtk_entry_completion_get_popup_set_width((GtkEntryCompletion*)s7_c_pointer_with_type(sc, completion, GtkEntryCompletion__sym, __func__, 0))));
}

static s7_pointer lg_gtk_entry_completion_set_popup_single_match(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_completion_set_popup_single_match "void gtk_entry_completion_set_popup_single_match(GtkEntryCompletion* completion, \
gboolean popup_single_match)"
  s7_pointer _p;
  s7_pointer completion, popup_single_match;
  _p = args;
  completion = s7_car(_p); _p = s7_cdr(_p);
  popup_single_match = s7_car(_p);
  if (!s7_is_boolean(popup_single_match)) s7_wrong_type_arg_error(sc, "gtk_entry_completion_set_popup_single_match", 2, popup_single_match, "gboolean");
  gtk_entry_completion_set_popup_single_match((GtkEntryCompletion*)s7_c_pointer_with_type(sc, completion, GtkEntryCompletion__sym, __func__, 0), (gboolean)lg_boolean(popup_single_match));
  return(lg_false);
}

static s7_pointer lg_gtk_entry_completion_get_popup_single_match(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_completion_get_popup_single_match "gboolean gtk_entry_completion_get_popup_single_match(GtkEntryCompletion* completion)"
  s7_pointer completion;
  completion = s7_car(args);
  return(s7_make_boolean(sc, gtk_entry_completion_get_popup_single_match((GtkEntryCompletion*)s7_c_pointer_with_type(sc, completion, GtkEntryCompletion__sym, __func__, 0))));
}

static s7_pointer lg_gtk_icon_view_get_item_at_pos(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_get_item_at_pos "gboolean gtk_icon_view_get_item_at_pos(GtkIconView* icon_view, \
gint x, gint y, GtkTreePath** [path], GtkCellRenderer** [cell])"
  s7_pointer _p;
  s7_pointer icon_view, x, y;
  GtkTreePath* ref_path = NULL;
  GtkCellRenderer* ref_cell = NULL;
  _p = args;
  icon_view = s7_car(_p); _p = s7_cdr(_p);
  x = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(x)) s7_wrong_type_arg_error(sc, "gtk_icon_view_get_item_at_pos", 2, x, "gint");
  y = s7_car(_p);
  if (!s7_is_integer(y)) s7_wrong_type_arg_error(sc, "gtk_icon_view_get_item_at_pos", 3, y, "gint");
  {
    s7_pointer res_ult;
    res_ult = s7_make_boolean(sc, gtk_icon_view_get_item_at_pos((GtkIconView*)s7_c_pointer_with_type(sc, icon_view, GtkIconView__sym, __func__, 0), (gint)s7_integer(x), (gint)s7_integer(y), &ref_path, &ref_cell));
      return(s7_list(sc, 3, res_ult, s7_make_c_pointer(sc, ref_path), s7_make_c_pointer(sc, ref_cell)));
   }
}

static s7_pointer lg_gtk_icon_view_get_visible_range(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_get_visible_range "gboolean gtk_icon_view_get_visible_range(GtkIconView* icon_view, \
GtkTreePath** [start_path], GtkTreePath** [end_path])"
  s7_pointer _p;
  s7_pointer icon_view;
  GtkTreePath* ref_start_path = NULL;
  GtkTreePath* ref_end_path = NULL;
  _p = args;
  icon_view = s7_car(_p);
  {
    s7_pointer res_ult;
    res_ult = s7_make_boolean(sc, gtk_icon_view_get_visible_range((GtkIconView*)s7_c_pointer_with_type(sc, icon_view, GtkIconView__sym, __func__, 0), &ref_start_path, &ref_end_path));
      return(s7_list(sc, 3, res_ult, s7_make_c_pointer(sc, ref_start_path), s7_make_c_pointer(sc, ref_end_path)));
   }
}

static s7_pointer lg_gtk_icon_view_set_cursor(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_set_cursor "void gtk_icon_view_set_cursor(GtkIconView* icon_view, GtkTreePath* path, \
GtkCellRenderer* cell, gboolean start_editing)"
  s7_pointer _p;
  s7_pointer icon_view, path, cell, start_editing;
  _p = args;
  icon_view = s7_car(_p); _p = s7_cdr(_p);
  path = s7_car(_p); _p = s7_cdr(_p);
  cell = s7_car(_p); _p = s7_cdr(_p);
  start_editing = s7_car(_p);
  if (!s7_is_boolean(start_editing)) s7_wrong_type_arg_error(sc, "gtk_icon_view_set_cursor", 4, start_editing, "gboolean");
  gtk_icon_view_set_cursor((GtkIconView*)s7_c_pointer_with_type(sc, icon_view, GtkIconView__sym, __func__, 0), (GtkTreePath*)s7_c_pointer_with_type(sc, path, GtkTreePath__sym, __func__, 0), (GtkCellRenderer*)s7_c_pointer_with_type(sc, cell, GtkCellRenderer__sym, __func__, 0), (gboolean)lg_boolean(start_editing));
  return(lg_false);
}

static s7_pointer lg_gtk_icon_view_get_cursor(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_get_cursor "gboolean gtk_icon_view_get_cursor(GtkIconView* icon_view, GtkTreePath** [path], \
GtkCellRenderer** [cell])"
  s7_pointer _p;
  s7_pointer icon_view;
  GtkTreePath* ref_path = NULL;
  GtkCellRenderer* ref_cell = NULL;
  _p = args;
  icon_view = s7_car(_p);
  {
    s7_pointer res_ult;
    res_ult = s7_make_boolean(sc, gtk_icon_view_get_cursor((GtkIconView*)s7_c_pointer_with_type(sc, icon_view, GtkIconView__sym, __func__, 0), &ref_path, &ref_cell));
      return(s7_list(sc, 3, res_ult, s7_make_c_pointer(sc, ref_path), s7_make_c_pointer(sc, ref_cell)));
   }
}

static s7_pointer lg_gtk_icon_view_scroll_to_path(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_scroll_to_path "void gtk_icon_view_scroll_to_path(GtkIconView* icon_view, GtkTreePath* path, \
gboolean use_align, gfloat row_align, gfloat col_align)"
  s7_pointer _p;
  s7_pointer icon_view, path, use_align, row_align, col_align;
  _p = args;
  icon_view = s7_car(_p); _p = s7_cdr(_p);
  path = s7_car(_p); _p = s7_cdr(_p);
  use_align = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_boolean(use_align)) s7_wrong_type_arg_error(sc, "gtk_icon_view_scroll_to_path", 3, use_align, "gboolean");
  row_align = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(row_align)) s7_wrong_type_arg_error(sc, "gtk_icon_view_scroll_to_path", 4, row_align, "gfloat");
  col_align = s7_car(_p);
  if (!s7_is_real(col_align)) s7_wrong_type_arg_error(sc, "gtk_icon_view_scroll_to_path", 5, col_align, "gfloat");
  gtk_icon_view_scroll_to_path((GtkIconView*)s7_c_pointer_with_type(sc, icon_view, GtkIconView__sym, __func__, 0), (GtkTreePath*)s7_c_pointer_with_type(sc, path, GtkTreePath__sym, __func__, 0), (gboolean)lg_boolean(use_align), (gfloat)s7_real(row_align), (gfloat)s7_real(col_align));
  return(lg_false);
}

static s7_pointer lg_gtk_icon_view_unset_model_drag_source(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_unset_model_drag_source "void gtk_icon_view_unset_model_drag_source(GtkIconView* icon_view)"
  s7_pointer icon_view;
  icon_view = s7_car(args);
  gtk_icon_view_unset_model_drag_source((GtkIconView*)s7_c_pointer_with_type(sc, icon_view, GtkIconView__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_icon_view_set_reorderable(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_set_reorderable "void gtk_icon_view_set_reorderable(GtkIconView* icon_view, \
gboolean reorderable)"
  s7_pointer _p;
  s7_pointer icon_view, reorderable;
  _p = args;
  icon_view = s7_car(_p); _p = s7_cdr(_p);
  reorderable = s7_car(_p);
  if (!s7_is_boolean(reorderable)) s7_wrong_type_arg_error(sc, "gtk_icon_view_set_reorderable", 2, reorderable, "gboolean");
  gtk_icon_view_set_reorderable((GtkIconView*)s7_c_pointer_with_type(sc, icon_view, GtkIconView__sym, __func__, 0), (gboolean)lg_boolean(reorderable));
  return(lg_false);
}

static s7_pointer lg_gtk_icon_view_get_reorderable(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_get_reorderable "gboolean gtk_icon_view_get_reorderable(GtkIconView* icon_view)"
  s7_pointer icon_view;
  icon_view = s7_car(args);
  return(s7_make_boolean(sc, gtk_icon_view_get_reorderable((GtkIconView*)s7_c_pointer_with_type(sc, icon_view, GtkIconView__sym, __func__, 0))));
}

static s7_pointer lg_gtk_icon_view_get_dest_item_at_pos(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_get_dest_item_at_pos "gboolean gtk_icon_view_get_dest_item_at_pos(GtkIconView* icon_view, \
gint drag_x, gint drag_y, GtkTreePath** [path], GtkIconViewDropPosition* [pos])"
  s7_pointer _p;
  s7_pointer icon_view, drag_x, drag_y;
  GtkTreePath* ref_path = NULL;
  GtkIconViewDropPosition ref_pos;
  _p = args;
  icon_view = s7_car(_p); _p = s7_cdr(_p);
  drag_x = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(drag_x)) s7_wrong_type_arg_error(sc, "gtk_icon_view_get_dest_item_at_pos", 2, drag_x, "gint");
  drag_y = s7_car(_p);
  if (!s7_is_integer(drag_y)) s7_wrong_type_arg_error(sc, "gtk_icon_view_get_dest_item_at_pos", 3, drag_y, "gint");
  {
    s7_pointer res_ult;
    res_ult = s7_make_boolean(sc, gtk_icon_view_get_dest_item_at_pos((GtkIconView*)s7_c_pointer_with_type(sc, icon_view, GtkIconView__sym, __func__, 0), (gint)s7_integer(drag_x), (gint)s7_integer(drag_y), &ref_path, &ref_pos));
      return(s7_list(sc, 3, res_ult, s7_make_c_pointer(sc, ref_path), s7_make_integer(sc, ref_pos)));
   }
}

static s7_pointer lg_gtk_image_clear(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_image_clear "void gtk_image_clear(GtkImage* image)"
  s7_pointer image;
  image = s7_car(args);
  gtk_image_clear((GtkImage*)s7_c_pointer_with_type(sc, image, GtkImage__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_text_iter_forward_visible_line(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_forward_visible_line "gboolean gtk_text_iter_forward_visible_line(GtkTextIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  return(s7_make_boolean(sc, gtk_text_iter_forward_visible_line((GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_iter_backward_visible_line(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_backward_visible_line "gboolean gtk_text_iter_backward_visible_line(GtkTextIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  return(s7_make_boolean(sc, gtk_text_iter_backward_visible_line((GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_iter_forward_visible_lines(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_forward_visible_lines "gboolean gtk_text_iter_forward_visible_lines(GtkTextIter* iter, \
gint count)"
  s7_pointer _p;
  s7_pointer iter, count;
  _p = args;
  iter = s7_car(_p); _p = s7_cdr(_p);
  count = s7_car(_p);
  if (!s7_is_integer(count)) s7_wrong_type_arg_error(sc, "gtk_text_iter_forward_visible_lines", 2, count, "gint");
  return(s7_make_boolean(sc, gtk_text_iter_forward_visible_lines((GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0), (gint)s7_integer(count))));
}

static s7_pointer lg_gtk_text_iter_backward_visible_lines(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_backward_visible_lines "gboolean gtk_text_iter_backward_visible_lines(GtkTextIter* iter, \
gint count)"
  s7_pointer _p;
  s7_pointer iter, count;
  _p = args;
  iter = s7_car(_p); _p = s7_cdr(_p);
  count = s7_car(_p);
  if (!s7_is_integer(count)) s7_wrong_type_arg_error(sc, "gtk_text_iter_backward_visible_lines", 2, count, "gint");
  return(s7_make_boolean(sc, gtk_text_iter_backward_visible_lines((GtkTextIter*)s7_c_pointer_with_type(sc, iter, GtkTextIter__sym, __func__, 0), (gint)s7_integer(count))));
}

static s7_pointer lg_gtk_window_present_with_time(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_window_present_with_time "void gtk_window_present_with_time(GtkWindow* window, guint32 timestamp)"
  s7_pointer _p;
  s7_pointer window, timestamp;
  _p = args;
  window = s7_car(_p); _p = s7_cdr(_p);
  timestamp = s7_car(_p);
  if (!s7_is_integer(timestamp)) s7_wrong_type_arg_error(sc, "gtk_window_present_with_time", 2, timestamp, "guint32");
  gtk_window_present_with_time((GtkWindow*)s7_c_pointer_with_type(sc, window, GtkWindow__sym, __func__, 0), (guint32)s7_integer(timestamp));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_row_reference_get_model(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_row_reference_get_model "GtkTreeModel* gtk_tree_row_reference_get_model(GtkTreeRowReference* reference)"
  s7_pointer reference;
  reference = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GtkTreeModel__sym, gtk_tree_row_reference_get_model((GtkTreeRowReference*)s7_c_pointer_with_type(sc, reference, GtkTreeRowReference__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_view_column_queue_resize(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_queue_resize "void gtk_tree_view_column_queue_resize(GtkTreeViewColumn* tree_column)"
  s7_pointer tree_column;
  tree_column = s7_car(args);
  gtk_tree_view_column_queue_resize((GtkTreeViewColumn*)s7_c_pointer_with_type(sc, tree_column, GtkTreeViewColumn__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_get_visible_range(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_get_visible_range "gboolean gtk_tree_view_get_visible_range(GtkTreeView* tree_view, \
GtkTreePath** [start_path], GtkTreePath** [end_path])"
  s7_pointer _p;
  s7_pointer tree_view;
  GtkTreePath* ref_start_path = NULL;
  GtkTreePath* ref_end_path = NULL;
  _p = args;
  tree_view = s7_car(_p);
  {
    s7_pointer res_ult;
    res_ult = s7_make_boolean(sc, gtk_tree_view_get_visible_range((GtkTreeView*)s7_c_pointer_with_type(sc, tree_view, GtkTreeView__sym, __func__, 0), &ref_start_path, &ref_end_path));
      return(s7_list(sc, 3, res_ult, s7_make_c_pointer(sc, ref_start_path), s7_make_c_pointer(sc, ref_end_path)));
   }
}

static s7_pointer lg_pango_attr_list_ref(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_attr_list_ref "PangoAttrList* pango_attr_list_ref(PangoAttrList* list)"
  s7_pointer list;
  list = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, PangoAttrList__sym, pango_attr_list_ref((PangoAttrList*)s7_c_pointer_with_type(sc, list, PangoAttrList__sym, __func__, 0))));
}

static s7_pointer lg_pango_layout_line_ref(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_line_ref "PangoLayoutLine* pango_layout_line_ref(PangoLayoutLine* line)"
  s7_pointer line;
  line = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, PangoLayoutLine__sym, pango_layout_line_ref((PangoLayoutLine*)s7_c_pointer_with_type(sc, line, PangoLayoutLine__sym, __func__, 0))));
}

static s7_pointer lg_pango_layout_index_to_line_x(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_index_to_line_x "void pango_layout_index_to_line_x(PangoLayout* layout, int index_, \
gboolean trailing, int* [line], int* [x_pos])"
  s7_pointer _p;
  s7_pointer layout, index_, trailing;
  int ref_line;
  int ref_x_pos;
  _p = args;
  layout = s7_car(_p); _p = s7_cdr(_p);
  index_ = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(index_)) s7_wrong_type_arg_error(sc, "pango_layout_index_to_line_x", 2, index_, "int");
  trailing = s7_car(_p);
  if (!s7_is_boolean(trailing)) s7_wrong_type_arg_error(sc, "pango_layout_index_to_line_x", 3, trailing, "gboolean");
  pango_layout_index_to_line_x((PangoLayout*)s7_c_pointer_with_type(sc, layout, PangoLayout__sym, __func__, 0), (int)s7_integer(index_), (gboolean)lg_boolean(trailing), &ref_line, &ref_x_pos);
    return(s7_list(sc, 2, s7_make_integer(sc, ref_line), s7_make_integer(sc, ref_x_pos)));
}

static s7_pointer lg_gdk_display_supports_input_shapes(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_display_supports_input_shapes "gboolean gdk_display_supports_input_shapes(GdkDisplay* display)"
  s7_pointer display;
  display = s7_car(args);
  return(s7_make_boolean(sc, gdk_display_supports_input_shapes((GdkDisplay*)s7_c_pointer_with_type(sc, display, GdkDisplay__sym, __func__, 0))));
}

static s7_pointer lg_gtk_notebook_get_tab_reorderable(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_notebook_get_tab_reorderable "gboolean gtk_notebook_get_tab_reorderable(GtkNotebook* notebook, \
GtkWidget* child)"
  s7_pointer _p;
  s7_pointer notebook, child;
  _p = args;
  notebook = s7_car(_p); _p = s7_cdr(_p);
  child = s7_car(_p);
  return(s7_make_boolean(sc, gtk_notebook_get_tab_reorderable((GtkNotebook*)s7_c_pointer_with_type(sc, notebook, GtkNotebook__sym, __func__, 0), (GtkWidget*)s7_c_pointer_with_type(sc, child, GtkWidget__sym, __func__, 0))));
}

static s7_pointer lg_gtk_notebook_set_tab_reorderable(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_notebook_set_tab_reorderable "void gtk_notebook_set_tab_reorderable(GtkNotebook* notebook, \
GtkWidget* child, gboolean reorderable)"
  s7_pointer _p;
  s7_pointer notebook, child, reorderable;
  _p = args;
  notebook = s7_car(_p); _p = s7_cdr(_p);
  child = s7_car(_p); _p = s7_cdr(_p);
  reorderable = s7_car(_p);
  if (!s7_is_boolean(reorderable)) s7_wrong_type_arg_error(sc, "gtk_notebook_set_tab_reorderable", 3, reorderable, "gboolean");
  gtk_notebook_set_tab_reorderable((GtkNotebook*)s7_c_pointer_with_type(sc, notebook, GtkNotebook__sym, __func__, 0), (GtkWidget*)s7_c_pointer_with_type(sc, child, GtkWidget__sym, __func__, 0), (gboolean)lg_boolean(reorderable));
  return(lg_false);
}

static s7_pointer lg_gtk_notebook_get_tab_detachable(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_notebook_get_tab_detachable "gboolean gtk_notebook_get_tab_detachable(GtkNotebook* notebook, \
GtkWidget* child)"
  s7_pointer _p;
  s7_pointer notebook, child;
  _p = args;
  notebook = s7_car(_p); _p = s7_cdr(_p);
  child = s7_car(_p);
  return(s7_make_boolean(sc, gtk_notebook_get_tab_detachable((GtkNotebook*)s7_c_pointer_with_type(sc, notebook, GtkNotebook__sym, __func__, 0), (GtkWidget*)s7_c_pointer_with_type(sc, child, GtkWidget__sym, __func__, 0))));
}

static s7_pointer lg_gtk_notebook_set_tab_detachable(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_notebook_set_tab_detachable "void gtk_notebook_set_tab_detachable(GtkNotebook* notebook, \
GtkWidget* child, gboolean detachable)"
  s7_pointer _p;
  s7_pointer notebook, child, detachable;
  _p = args;
  notebook = s7_car(_p); _p = s7_cdr(_p);
  child = s7_car(_p); _p = s7_cdr(_p);
  detachable = s7_car(_p);
  if (!s7_is_boolean(detachable)) s7_wrong_type_arg_error(sc, "gtk_notebook_set_tab_detachable", 3, detachable, "gboolean");
  gtk_notebook_set_tab_detachable((GtkNotebook*)s7_c_pointer_with_type(sc, notebook, GtkNotebook__sym, __func__, 0), (GtkWidget*)s7_c_pointer_with_type(sc, child, GtkWidget__sym, __func__, 0), (gboolean)lg_boolean(detachable));
  return(lg_false);
}

static s7_pointer lg_gtk_scrolled_window_unset_placement(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_scrolled_window_unset_placement "void gtk_scrolled_window_unset_placement(GtkScrolledWindow* scrolled_window)"
  s7_pointer scrolled_window;
  scrolled_window = s7_car(args);
  gtk_scrolled_window_unset_placement((GtkScrolledWindow*)s7_c_pointer_with_type(sc, scrolled_window, GtkScrolledWindow__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_size_group_get_widgets(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_size_group_get_widgets "GSList* gtk_size_group_get_widgets(GtkSizeGroup* size_group)"
  s7_pointer size_group;
  size_group = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GSList__sym, gtk_size_group_get_widgets((GtkSizeGroup*)s7_c_pointer_with_type(sc, size_group, GtkSizeGroup__sym, __func__, 0))));
}

static s7_pointer lg_gtk_text_buffer_get_has_selection(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_get_has_selection "gboolean gtk_text_buffer_get_has_selection(GtkTextBuffer* buffer)"
  s7_pointer buffer;
  buffer = s7_car(args);
  return(s7_make_boolean(sc, gtk_text_buffer_get_has_selection((GtkTextBuffer*)s7_c_pointer_with_type(sc, buffer, GtkTextBuffer__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_view_get_headers_clickable(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_get_headers_clickable "gboolean gtk_tree_view_get_headers_clickable(GtkTreeView* tree_view)"
  s7_pointer tree_view;
  tree_view = s7_car(args);
  return(s7_make_boolean(sc, gtk_tree_view_get_headers_clickable((GtkTreeView*)s7_c_pointer_with_type(sc, tree_view, GtkTreeView__sym, __func__, 0))));
}

static s7_pointer lg_gtk_window_set_deletable(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_window_set_deletable "void gtk_window_set_deletable(GtkWindow* window, gboolean setting)"
  s7_pointer _p;
  s7_pointer window, setting;
  _p = args;
  window = s7_car(_p); _p = s7_cdr(_p);
  setting = s7_car(_p);
  if (!s7_is_boolean(setting)) s7_wrong_type_arg_error(sc, "gtk_window_set_deletable", 2, setting, "gboolean");
  gtk_window_set_deletable((GtkWindow*)s7_c_pointer_with_type(sc, window, GtkWindow__sym, __func__, 0), (gboolean)lg_boolean(setting));
  return(lg_false);
}

static s7_pointer lg_gtk_window_get_deletable(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_window_get_deletable "gboolean gtk_window_get_deletable(GtkWindow* window)"
  s7_pointer window;
  window = s7_car(args);
  return(s7_make_boolean(sc, gtk_window_get_deletable((GtkWindow*)s7_c_pointer_with_type(sc, window, GtkWindow__sym, __func__, 0))));
}

static s7_pointer lg_gtk_assistant_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_assistant_new "GtkWidget* gtk_assistant_new( void)"
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_assistant_new()));
}

static s7_pointer lg_gtk_assistant_get_current_page(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_assistant_get_current_page "gint gtk_assistant_get_current_page(GtkAssistant* assistant)"
  s7_pointer assistant;
  assistant = s7_car(args);
  return(s7_make_integer(sc, gtk_assistant_get_current_page((GtkAssistant*)s7_c_pointer_with_type(sc, assistant, GtkAssistant__sym, __func__, 0))));
}

static s7_pointer lg_gtk_assistant_set_current_page(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_assistant_set_current_page "void gtk_assistant_set_current_page(GtkAssistant* assistant, \
gint page_num)"
  s7_pointer _p;
  s7_pointer assistant, page_num;
  _p = args;
  assistant = s7_car(_p); _p = s7_cdr(_p);
  page_num = s7_car(_p);
  if (!s7_is_integer(page_num)) s7_wrong_type_arg_error(sc, "gtk_assistant_set_current_page", 2, page_num, "gint");
  gtk_assistant_set_current_page((GtkAssistant*)s7_c_pointer_with_type(sc, assistant, GtkAssistant__sym, __func__, 0), (gint)s7_integer(page_num));
  return(lg_false);
}

static s7_pointer lg_gtk_assistant_get_n_pages(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_assistant_get_n_pages "gint gtk_assistant_get_n_pages(GtkAssistant* assistant)"
  s7_pointer assistant;
  assistant = s7_car(args);
  return(s7_make_integer(sc, gtk_assistant_get_n_pages((GtkAssistant*)s7_c_pointer_with_type(sc, assistant, GtkAssistant__sym, __func__, 0))));
}

static s7_pointer lg_gtk_assistant_get_nth_page(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_assistant_get_nth_page "GtkWidget* gtk_assistant_get_nth_page(GtkAssistant* assistant, \
gint page_num)"
  s7_pointer _p;
  s7_pointer assistant, page_num;
  _p = args;
  assistant = s7_car(_p); _p = s7_cdr(_p);
  page_num = s7_car(_p);
  if (!s7_is_integer(page_num)) s7_wrong_type_arg_error(sc, "gtk_assistant_get_nth_page", 2, page_num, "gint");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_assistant_get_nth_page((GtkAssistant*)s7_c_pointer_with_type(sc, assistant, GtkAssistant__sym, __func__, 0), (gint)s7_integer(page_num))));
}

static s7_pointer lg_gtk_assistant_prepend_page(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_assistant_prepend_page "gint gtk_assistant_prepend_page(GtkAssistant* assistant, GtkWidget* page)"
  s7_pointer _p;
  s7_pointer assistant, page;
  _p = args;
  assistant = s7_car(_p); _p = s7_cdr(_p);
  page = s7_car(_p);
  return(s7_make_integer(sc, gtk_assistant_prepend_page((GtkAssistant*)s7_c_pointer_with_type(sc, assistant, GtkAssistant__sym, __func__, 0), (GtkWidget*)s7_c_pointer_with_type(sc, page, GtkWidget__sym, __func__, 0))));
}

static s7_pointer lg_gtk_assistant_append_page(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_assistant_append_page "gint gtk_assistant_append_page(GtkAssistant* assistant, GtkWidget* page)"
  s7_pointer _p;
  s7_pointer assistant, page;
  _p = args;
  assistant = s7_car(_p); _p = s7_cdr(_p);
  page = s7_car(_p);
  return(s7_make_integer(sc, gtk_assistant_append_page((GtkAssistant*)s7_c_pointer_with_type(sc, assistant, GtkAssistant__sym, __func__, 0), (GtkWidget*)s7_c_pointer_with_type(sc, page, GtkWidget__sym, __func__, 0))));
}

static s7_pointer lg_gtk_assistant_insert_page(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_assistant_insert_page "gint gtk_assistant_insert_page(GtkAssistant* assistant, GtkWidget* page, \
gint position)"
  s7_pointer _p;
  s7_pointer assistant, page, position;
  _p = args;
  assistant = s7_car(_p); _p = s7_cdr(_p);
  page = s7_car(_p); _p = s7_cdr(_p);
  position = s7_car(_p);
  if (!s7_is_integer(position)) s7_wrong_type_arg_error(sc, "gtk_assistant_insert_page", 3, position, "gint");
  return(s7_make_integer(sc, gtk_assistant_insert_page((GtkAssistant*)s7_c_pointer_with_type(sc, assistant, GtkAssistant__sym, __func__, 0), (GtkWidget*)s7_c_pointer_with_type(sc, page, GtkWidget__sym, __func__, 0), (gint)s7_integer(position))));
}

static s7_pointer lg_gtk_assistant_set_forward_page_func(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_assistant_set_forward_page_func "void gtk_assistant_set_forward_page_func(GtkAssistant* assistant, \
GtkAssistantPageFunc page_func, lambda_data func_info, GDestroyNotify destroy)"
  s7_pointer _p;
  s7_pointer assistant /* , page_func */ , func_info, destroy;
  _p = args;
  assistant = s7_car(_p); _p = s7_cdr(_p);
  /* page_func = s7_car(_p); */ _p = s7_cdr(_p);
  func_info = s7_car(_p); _p = s7_cdr(_p);
  destroy = s7_car(_p);
  {
    s7_pointer lg_ptr = s7_list(sc, 5, lg_false, func_info, lg_false, lg_false, lg_false);
    s7_gc_protect(sc, lg_ptr);
    s7_list_set(sc, lg_ptr, 3, destroy);
    gtk_assistant_set_forward_page_func((GtkAssistant*)s7_c_pointer_with_type(sc, assistant, GtkAssistant__sym, __func__, 0), lg_page_func, (gpointer)lg_ptr, lg_destroy_func);
    return(lg_false);
   }
}

static s7_pointer lg_gtk_assistant_set_page_type(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_assistant_set_page_type "void gtk_assistant_set_page_type(GtkAssistant* assistant, GtkWidget* page, \
GtkAssistantPageType type)"
  s7_pointer _p;
  s7_pointer assistant, page, type;
  _p = args;
  assistant = s7_car(_p); _p = s7_cdr(_p);
  page = s7_car(_p); _p = s7_cdr(_p);
  type = s7_car(_p);
  if (!s7_is_integer(type)) s7_wrong_type_arg_error(sc, "gtk_assistant_set_page_type", 3, type, "GtkAssistantPageType");
  gtk_assistant_set_page_type((GtkAssistant*)s7_c_pointer_with_type(sc, assistant, GtkAssistant__sym, __func__, 0), (GtkWidget*)s7_c_pointer_with_type(sc, page, GtkWidget__sym, __func__, 0), (GtkAssistantPageType)s7_integer(type));
  return(lg_false);
}

static s7_pointer lg_gtk_assistant_get_page_type(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_assistant_get_page_type "GtkAssistantPageType gtk_assistant_get_page_type(GtkAssistant* assistant, \
GtkWidget* page)"
  s7_pointer _p;
  s7_pointer assistant, page;
  _p = args;
  assistant = s7_car(_p); _p = s7_cdr(_p);
  page = s7_car(_p);
  return(s7_make_integer(sc, gtk_assistant_get_page_type((GtkAssistant*)s7_c_pointer_with_type(sc, assistant, GtkAssistant__sym, __func__, 0), (GtkWidget*)s7_c_pointer_with_type(sc, page, GtkWidget__sym, __func__, 0))));
}

static s7_pointer lg_gtk_assistant_set_page_title(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_assistant_set_page_title "void gtk_assistant_set_page_title(GtkAssistant* assistant, \
GtkWidget* page, gchar* title)"
  s7_pointer _p;
  s7_pointer assistant, page, title;
  _p = args;
  assistant = s7_car(_p); _p = s7_cdr(_p);
  page = s7_car(_p); _p = s7_cdr(_p);
  title = s7_car(_p);
  if (!s7_is_string(title)) s7_wrong_type_arg_error(sc, "gtk_assistant_set_page_title", 3, title, "gchar*");
  gtk_assistant_set_page_title((GtkAssistant*)s7_c_pointer_with_type(sc, assistant, GtkAssistant__sym, __func__, 0), (GtkWidget*)s7_c_pointer_with_type(sc, page, GtkWidget__sym, __func__, 0), (gchar*)s7_string(title));
  return(lg_false);
}

static s7_pointer lg_gtk_assistant_get_page_title(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_assistant_get_page_title "gchar* gtk_assistant_get_page_title(GtkAssistant* assistant, \
GtkWidget* page)"
  s7_pointer _p;
  s7_pointer assistant, page;
  _p = args;
  assistant = s7_car(_p); _p = s7_cdr(_p);
  page = s7_car(_p);
  return(s7_make_string(sc, gtk_assistant_get_page_title((GtkAssistant*)s7_c_pointer_with_type(sc, assistant, GtkAssistant__sym, __func__, 0), (GtkWidget*)s7_c_pointer_with_type(sc, page, GtkWidget__sym, __func__, 0))));
}

static s7_pointer lg_gtk_assistant_set_page_complete(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_assistant_set_page_complete "void gtk_assistant_set_page_complete(GtkAssistant* assistant, \
GtkWidget* page, gboolean complete)"
  s7_pointer _p;
  s7_pointer assistant, page, complete;
  _p = args;
  assistant = s7_car(_p); _p = s7_cdr(_p);
  page = s7_car(_p); _p = s7_cdr(_p);
  complete = s7_car(_p);
  if (!s7_is_boolean(complete)) s7_wrong_type_arg_error(sc, "gtk_assistant_set_page_complete", 3, complete, "gboolean");
  gtk_assistant_set_page_complete((GtkAssistant*)s7_c_pointer_with_type(sc, assistant, GtkAssistant__sym, __func__, 0), (GtkWidget*)s7_c_pointer_with_type(sc, page, GtkWidget__sym, __func__, 0), (gboolean)lg_boolean(complete));
  return(lg_false);
}

static s7_pointer lg_gtk_assistant_get_page_complete(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_assistant_get_page_complete "gboolean gtk_assistant_get_page_complete(GtkAssistant* assistant, \
GtkWidget* page)"
  s7_pointer _p;
  s7_pointer assistant, page;
  _p = args;
  assistant = s7_car(_p); _p = s7_cdr(_p);
  page = s7_car(_p);
  return(s7_make_boolean(sc, gtk_assistant_get_page_complete((GtkAssistant*)s7_c_pointer_with_type(sc, assistant, GtkAssistant__sym, __func__, 0), (GtkWidget*)s7_c_pointer_with_type(sc, page, GtkWidget__sym, __func__, 0))));
}

static s7_pointer lg_gtk_assistant_add_action_widget(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_assistant_add_action_widget "void gtk_assistant_add_action_widget(GtkAssistant* assistant, \
GtkWidget* child)"
  s7_pointer _p;
  s7_pointer assistant, child;
  _p = args;
  assistant = s7_car(_p); _p = s7_cdr(_p);
  child = s7_car(_p);
  gtk_assistant_add_action_widget((GtkAssistant*)s7_c_pointer_with_type(sc, assistant, GtkAssistant__sym, __func__, 0), (GtkWidget*)s7_c_pointer_with_type(sc, child, GtkWidget__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_assistant_remove_action_widget(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_assistant_remove_action_widget "void gtk_assistant_remove_action_widget(GtkAssistant* assistant, \
GtkWidget* child)"
  s7_pointer _p;
  s7_pointer assistant, child;
  _p = args;
  assistant = s7_car(_p); _p = s7_cdr(_p);
  child = s7_car(_p);
  gtk_assistant_remove_action_widget((GtkAssistant*)s7_c_pointer_with_type(sc, assistant, GtkAssistant__sym, __func__, 0), (GtkWidget*)s7_c_pointer_with_type(sc, child, GtkWidget__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_assistant_update_buttons_state(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_assistant_update_buttons_state "void gtk_assistant_update_buttons_state(GtkAssistant* assistant)"
  s7_pointer assistant;
  assistant = s7_car(args);
  gtk_assistant_update_buttons_state((GtkAssistant*)s7_c_pointer_with_type(sc, assistant, GtkAssistant__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_cell_renderer_accel_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_renderer_accel_new "GtkCellRenderer* gtk_cell_renderer_accel_new( void)"
  return(lg_make_c_pointer_with_type(sc, GtkCellRenderer__sym, gtk_cell_renderer_accel_new()));
}

static s7_pointer lg_gtk_cell_renderer_spin_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_renderer_spin_new "GtkCellRenderer* gtk_cell_renderer_spin_new( void)"
  return(lg_make_c_pointer_with_type(sc, GtkCellRenderer__sym, gtk_cell_renderer_spin_new()));
}

static s7_pointer lg_gtk_link_button_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_link_button_new "GtkWidget* gtk_link_button_new(gchar* uri)"
  s7_pointer uri;
  uri = s7_car(args);
  if (!s7_is_string(uri)) s7_wrong_type_arg_error(sc, "gtk_link_button_new", 1, uri, "gchar*");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_link_button_new((gchar*)s7_string(uri))));
}

static s7_pointer lg_gtk_link_button_new_with_label(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_link_button_new_with_label "GtkWidget* gtk_link_button_new_with_label(gchar* uri, gchar* label)"
  s7_pointer _p;
  s7_pointer uri, label;
  _p = args;
  uri = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(uri)) s7_wrong_type_arg_error(sc, "gtk_link_button_new_with_label", 1, uri, "gchar*");
  label = s7_car(_p);
  if (!s7_is_string(label)) s7_wrong_type_arg_error(sc, "gtk_link_button_new_with_label", 2, label, "gchar*");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_link_button_new_with_label((gchar*)s7_string(uri), (gchar*)s7_string(label))));
}

static s7_pointer lg_gtk_link_button_get_uri(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_link_button_get_uri "gchar* gtk_link_button_get_uri(GtkLinkButton* link_button)"
  s7_pointer link_button;
  link_button = s7_car(args);
  return(s7_make_string(sc, gtk_link_button_get_uri((GtkLinkButton*)s7_c_pointer_with_type(sc, link_button, GtkLinkButton__sym, __func__, 0))));
}

static s7_pointer lg_gtk_link_button_set_uri(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_link_button_set_uri "void gtk_link_button_set_uri(GtkLinkButton* link_button, gchar* uri)"
  s7_pointer _p;
  s7_pointer link_button, uri;
  _p = args;
  link_button = s7_car(_p); _p = s7_cdr(_p);
  uri = s7_car(_p);
  if (!s7_is_string(uri)) s7_wrong_type_arg_error(sc, "gtk_link_button_set_uri", 2, uri, "gchar*");
  gtk_link_button_set_uri((GtkLinkButton*)s7_c_pointer_with_type(sc, link_button, GtkLinkButton__sym, __func__, 0), (gchar*)s7_string(uri));
  return(lg_false);
}

static s7_pointer lg_gtk_recent_manager_error_quark(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_recent_manager_error_quark "GQuark gtk_recent_manager_error_quark( void)"
  return(s7_make_integer(sc, gtk_recent_manager_error_quark()));
}

static s7_pointer lg_gtk_recent_manager_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_recent_manager_new "GtkRecentManager* gtk_recent_manager_new( void)"
  return(lg_make_c_pointer_with_type(sc, GtkRecentManager__sym, gtk_recent_manager_new()));
}

static s7_pointer lg_gtk_recent_manager_get_default(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_recent_manager_get_default "GtkRecentManager* gtk_recent_manager_get_default( void)"
  return(lg_make_c_pointer_with_type(sc, GtkRecentManager__sym, gtk_recent_manager_get_default()));
}

static s7_pointer lg_gtk_recent_manager_remove_item(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_recent_manager_remove_item "gboolean gtk_recent_manager_remove_item(GtkRecentManager* manager, \
gchar* uri, GError** [error])"
  s7_pointer _p;
  s7_pointer manager, uri;
  GError* ref_error = NULL;
  _p = args;
  manager = s7_car(_p); _p = s7_cdr(_p);
  uri = s7_car(_p);
  if (!s7_is_string(uri)) s7_wrong_type_arg_error(sc, "gtk_recent_manager_remove_item", 2, uri, "gchar*");
  {
    s7_pointer res_ult;
    res_ult = s7_make_boolean(sc, gtk_recent_manager_remove_item((GtkRecentManager*)s7_c_pointer_with_type(sc, manager, GtkRecentManager__sym, __func__, 0), (gchar*)s7_string(uri), &ref_error));
      return(s7_list(sc, 2, res_ult, s7_make_c_pointer(sc, ref_error)));
   }
}

static s7_pointer lg_gtk_recent_manager_lookup_item(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_recent_manager_lookup_item "GtkRecentInfo* gtk_recent_manager_lookup_item(GtkRecentManager* manager, \
gchar* uri, GError** [error])"
  s7_pointer _p;
  s7_pointer manager, uri;
  GError* ref_error = NULL;
  _p = args;
  manager = s7_car(_p); _p = s7_cdr(_p);
  uri = s7_car(_p);
  if (!s7_is_string(uri)) s7_wrong_type_arg_error(sc, "gtk_recent_manager_lookup_item", 2, uri, "gchar*");
  {
    s7_pointer res_ult;
    res_ult = lg_make_c_pointer_with_type(sc, GtkRecentInfo__sym, gtk_recent_manager_lookup_item((GtkRecentManager*)s7_c_pointer_with_type(sc, manager, GtkRecentManager__sym, __func__, 0), (gchar*)s7_string(uri), &ref_error));
      return(s7_list(sc, 2, res_ult, s7_make_c_pointer(sc, ref_error)));
   }
}

static s7_pointer lg_gtk_recent_manager_has_item(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_recent_manager_has_item "gboolean gtk_recent_manager_has_item(GtkRecentManager* manager, \
gchar* uri)"
  s7_pointer _p;
  s7_pointer manager, uri;
  _p = args;
  manager = s7_car(_p); _p = s7_cdr(_p);
  uri = s7_car(_p);
  if (!s7_is_string(uri)) s7_wrong_type_arg_error(sc, "gtk_recent_manager_has_item", 2, uri, "gchar*");
  return(s7_make_boolean(sc, gtk_recent_manager_has_item((GtkRecentManager*)s7_c_pointer_with_type(sc, manager, GtkRecentManager__sym, __func__, 0), (gchar*)s7_string(uri))));
}

static s7_pointer lg_gtk_recent_manager_move_item(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_recent_manager_move_item "gboolean gtk_recent_manager_move_item(GtkRecentManager* manager, \
gchar* uri, gchar* new_uri, GError** [error])"
  s7_pointer _p;
  s7_pointer manager, uri, new_uri;
  GError* ref_error = NULL;
  _p = args;
  manager = s7_car(_p); _p = s7_cdr(_p);
  uri = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(uri)) s7_wrong_type_arg_error(sc, "gtk_recent_manager_move_item", 2, uri, "gchar*");
  new_uri = s7_car(_p);
  if (!s7_is_string(new_uri)) s7_wrong_type_arg_error(sc, "gtk_recent_manager_move_item", 3, new_uri, "gchar*");
  {
    s7_pointer res_ult;
    res_ult = s7_make_boolean(sc, gtk_recent_manager_move_item((GtkRecentManager*)s7_c_pointer_with_type(sc, manager, GtkRecentManager__sym, __func__, 0), (gchar*)s7_string(uri), (gchar*)s7_string(new_uri), &ref_error));
      return(s7_list(sc, 2, res_ult, s7_make_c_pointer(sc, ref_error)));
   }
}

static s7_pointer lg_gtk_recent_manager_get_items(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_recent_manager_get_items "GList* gtk_recent_manager_get_items(GtkRecentManager* manager)"
  s7_pointer manager;
  manager = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GList__sym, gtk_recent_manager_get_items((GtkRecentManager*)s7_c_pointer_with_type(sc, manager, GtkRecentManager__sym, __func__, 0))));
}

static s7_pointer lg_gtk_recent_manager_purge_items(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_recent_manager_purge_items "gint gtk_recent_manager_purge_items(GtkRecentManager* manager, \
GError** [error])"
  s7_pointer _p;
  s7_pointer manager;
  GError* ref_error = NULL;
  _p = args;
  manager = s7_car(_p);
  {
    s7_pointer res_ult;
    res_ult = s7_make_integer(sc, gtk_recent_manager_purge_items((GtkRecentManager*)s7_c_pointer_with_type(sc, manager, GtkRecentManager__sym, __func__, 0), &ref_error));
      return(s7_list(sc, 2, res_ult, s7_make_c_pointer(sc, ref_error)));
   }
}

static s7_pointer lg_gtk_recent_info_ref(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_recent_info_ref "GtkRecentInfo* gtk_recent_info_ref(GtkRecentInfo* info)"
  s7_pointer info;
  info = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GtkRecentInfo__sym, gtk_recent_info_ref((GtkRecentInfo*)s7_c_pointer_with_type(sc, info, GtkRecentInfo__sym, __func__, 0))));
}

static s7_pointer lg_gtk_recent_info_unref(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_recent_info_unref "void gtk_recent_info_unref(GtkRecentInfo* info)"
  s7_pointer info;
  info = s7_car(args);
  gtk_recent_info_unref((GtkRecentInfo*)s7_c_pointer_with_type(sc, info, GtkRecentInfo__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_recent_info_get_uri(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_recent_info_get_uri "gchar* gtk_recent_info_get_uri(GtkRecentInfo* info)"
  s7_pointer info;
  info = s7_car(args);
  return(s7_make_string(sc, gtk_recent_info_get_uri((GtkRecentInfo*)s7_c_pointer_with_type(sc, info, GtkRecentInfo__sym, __func__, 0))));
}

static s7_pointer lg_gtk_recent_info_get_display_name(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_recent_info_get_display_name "gchar* gtk_recent_info_get_display_name(GtkRecentInfo* info)"
  s7_pointer info;
  info = s7_car(args);
    return(s7_make_string(sc, (gchar*)gtk_recent_info_get_display_name((GtkRecentInfo*)s7_c_pointer_with_type(sc, info, GtkRecentInfo__sym, __func__, 0))));
}

static s7_pointer lg_gtk_recent_info_get_description(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_recent_info_get_description "gchar* gtk_recent_info_get_description(GtkRecentInfo* info)"
  s7_pointer info;
  info = s7_car(args);
    return(s7_make_string(sc, (gchar*)gtk_recent_info_get_description((GtkRecentInfo*)s7_c_pointer_with_type(sc, info, GtkRecentInfo__sym, __func__, 0))));
}

static s7_pointer lg_gtk_recent_info_get_mime_type(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_recent_info_get_mime_type "gchar* gtk_recent_info_get_mime_type(GtkRecentInfo* info)"
  s7_pointer info;
  info = s7_car(args);
    return(s7_make_string(sc, (gchar*)gtk_recent_info_get_mime_type((GtkRecentInfo*)s7_c_pointer_with_type(sc, info, GtkRecentInfo__sym, __func__, 0))));
}

static s7_pointer lg_gtk_recent_info_get_added(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_recent_info_get_added "time_t gtk_recent_info_get_added(GtkRecentInfo* info)"
  s7_pointer info;
  info = s7_car(args);
  return(s7_make_integer(sc, gtk_recent_info_get_added((GtkRecentInfo*)s7_c_pointer_with_type(sc, info, GtkRecentInfo__sym, __func__, 0))));
}

static s7_pointer lg_gtk_recent_info_get_modified(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_recent_info_get_modified "time_t gtk_recent_info_get_modified(GtkRecentInfo* info)"
  s7_pointer info;
  info = s7_car(args);
  return(s7_make_integer(sc, gtk_recent_info_get_modified((GtkRecentInfo*)s7_c_pointer_with_type(sc, info, GtkRecentInfo__sym, __func__, 0))));
}

static s7_pointer lg_gtk_recent_info_get_visited(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_recent_info_get_visited "time_t gtk_recent_info_get_visited(GtkRecentInfo* info)"
  s7_pointer info;
  info = s7_car(args);
  return(s7_make_integer(sc, gtk_recent_info_get_visited((GtkRecentInfo*)s7_c_pointer_with_type(sc, info, GtkRecentInfo__sym, __func__, 0))));
}

static s7_pointer lg_gtk_recent_info_get_private_hint(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_recent_info_get_private_hint "gboolean gtk_recent_info_get_private_hint(GtkRecentInfo* info)"
  s7_pointer info;
  info = s7_car(args);
  return(s7_make_boolean(sc, gtk_recent_info_get_private_hint((GtkRecentInfo*)s7_c_pointer_with_type(sc, info, GtkRecentInfo__sym, __func__, 0))));
}

static s7_pointer lg_gtk_recent_info_get_applications(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_recent_info_get_applications "gchar** gtk_recent_info_get_applications(GtkRecentInfo* info, \
gsize* [length])"
  s7_pointer _p;
  s7_pointer info;
  gsize ref_length;
  _p = args;
  info = s7_car(_p);
  {
    s7_pointer res_ult;
    res_ult = lg_make_c_pointer_with_type(sc, gchar___sym, gtk_recent_info_get_applications((GtkRecentInfo*)s7_c_pointer_with_type(sc, info, GtkRecentInfo__sym, __func__, 0), &ref_length));
      return(s7_list(sc, 2, res_ult, s7_make_integer(sc, ref_length)));
   }
}

static s7_pointer lg_gtk_recent_info_last_application(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_recent_info_last_application "gchar* gtk_recent_info_last_application(GtkRecentInfo* info)"
  s7_pointer info;
  info = s7_car(args);
  return(s7_make_string(sc, gtk_recent_info_last_application((GtkRecentInfo*)s7_c_pointer_with_type(sc, info, GtkRecentInfo__sym, __func__, 0))));
}

static s7_pointer lg_gtk_recent_info_has_application(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_recent_info_has_application "gboolean gtk_recent_info_has_application(GtkRecentInfo* info, \
gchar* app_name)"
  s7_pointer _p;
  s7_pointer info, app_name;
  _p = args;
  info = s7_car(_p); _p = s7_cdr(_p);
  app_name = s7_car(_p);
  if (!s7_is_string(app_name)) s7_wrong_type_arg_error(sc, "gtk_recent_info_has_application", 2, app_name, "gchar*");
  return(s7_make_boolean(sc, gtk_recent_info_has_application((GtkRecentInfo*)s7_c_pointer_with_type(sc, info, GtkRecentInfo__sym, __func__, 0), (gchar*)s7_string(app_name))));
}

static s7_pointer lg_gtk_recent_info_get_groups(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_recent_info_get_groups "gchar** gtk_recent_info_get_groups(GtkRecentInfo* info, gsize* [length])"
  s7_pointer _p;
  s7_pointer info;
  gsize ref_length;
  _p = args;
  info = s7_car(_p);
  {
    s7_pointer res_ult;
    res_ult = lg_make_c_pointer_with_type(sc, gchar___sym, gtk_recent_info_get_groups((GtkRecentInfo*)s7_c_pointer_with_type(sc, info, GtkRecentInfo__sym, __func__, 0), &ref_length));
      return(s7_list(sc, 2, res_ult, s7_make_integer(sc, ref_length)));
   }
}

static s7_pointer lg_gtk_recent_info_has_group(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_recent_info_has_group "gboolean gtk_recent_info_has_group(GtkRecentInfo* info, gchar* group_name)"
  s7_pointer _p;
  s7_pointer info, group_name;
  _p = args;
  info = s7_car(_p); _p = s7_cdr(_p);
  group_name = s7_car(_p);
  if (!s7_is_string(group_name)) s7_wrong_type_arg_error(sc, "gtk_recent_info_has_group", 2, group_name, "gchar*");
  return(s7_make_boolean(sc, gtk_recent_info_has_group((GtkRecentInfo*)s7_c_pointer_with_type(sc, info, GtkRecentInfo__sym, __func__, 0), (gchar*)s7_string(group_name))));
}

static s7_pointer lg_gtk_recent_info_get_short_name(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_recent_info_get_short_name "gchar* gtk_recent_info_get_short_name(GtkRecentInfo* info)"
  s7_pointer info;
  info = s7_car(args);
  return(s7_make_string(sc, gtk_recent_info_get_short_name((GtkRecentInfo*)s7_c_pointer_with_type(sc, info, GtkRecentInfo__sym, __func__, 0))));
}

static s7_pointer lg_gtk_recent_info_get_uri_display(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_recent_info_get_uri_display "gchar* gtk_recent_info_get_uri_display(GtkRecentInfo* info)"
  s7_pointer info;
  info = s7_car(args);
  return(s7_make_string(sc, gtk_recent_info_get_uri_display((GtkRecentInfo*)s7_c_pointer_with_type(sc, info, GtkRecentInfo__sym, __func__, 0))));
}

static s7_pointer lg_gtk_recent_info_get_age(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_recent_info_get_age "gint gtk_recent_info_get_age(GtkRecentInfo* info)"
  s7_pointer info;
  info = s7_car(args);
  return(s7_make_integer(sc, gtk_recent_info_get_age((GtkRecentInfo*)s7_c_pointer_with_type(sc, info, GtkRecentInfo__sym, __func__, 0))));
}

static s7_pointer lg_gtk_recent_info_is_local(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_recent_info_is_local "gboolean gtk_recent_info_is_local(GtkRecentInfo* info)"
  s7_pointer info;
  info = s7_car(args);
  return(s7_make_boolean(sc, gtk_recent_info_is_local((GtkRecentInfo*)s7_c_pointer_with_type(sc, info, GtkRecentInfo__sym, __func__, 0))));
}

static s7_pointer lg_gtk_recent_info_exists(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_recent_info_exists "gboolean gtk_recent_info_exists(GtkRecentInfo* info)"
  s7_pointer info;
  info = s7_car(args);
  return(s7_make_boolean(sc, gtk_recent_info_exists((GtkRecentInfo*)s7_c_pointer_with_type(sc, info, GtkRecentInfo__sym, __func__, 0))));
}

static s7_pointer lg_gtk_recent_info_match(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_recent_info_match "gboolean gtk_recent_info_match(GtkRecentInfo* info_a, GtkRecentInfo* info_b)"
  s7_pointer _p;
  s7_pointer info_a, info_b;
  _p = args;
  info_a = s7_car(_p); _p = s7_cdr(_p);
  info_b = s7_car(_p);
  return(s7_make_boolean(sc, gtk_recent_info_match((GtkRecentInfo*)s7_c_pointer_with_type(sc, info_a, GtkRecentInfo__sym, __func__, 0), (GtkRecentInfo*)s7_c_pointer_with_type(sc, info_b, GtkRecentInfo__sym, __func__, 0))));
}

static s7_pointer lg_gtk_recent_manager_add_item(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_recent_manager_add_item "gboolean gtk_recent_manager_add_item(GtkRecentManager* manager, \
gchar* uri)"
  s7_pointer _p;
  s7_pointer manager, uri;
  _p = args;
  manager = s7_car(_p); _p = s7_cdr(_p);
  uri = s7_car(_p);
  if (!s7_is_string(uri)) s7_wrong_type_arg_error(sc, "gtk_recent_manager_add_item", 2, uri, "gchar*");
  return(s7_make_boolean(sc, gtk_recent_manager_add_item((GtkRecentManager*)s7_c_pointer_with_type(sc, manager, GtkRecentManager__sym, __func__, 0), (gchar*)s7_string(uri))));
}

static s7_pointer lg_gtk_recent_manager_add_full(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_recent_manager_add_full "gboolean gtk_recent_manager_add_full(GtkRecentManager* manager, \
gchar* uri, GtkRecentData* recent_data)"
  s7_pointer _p;
  s7_pointer manager, uri, recent_data;
  _p = args;
  manager = s7_car(_p); _p = s7_cdr(_p);
  uri = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(uri)) s7_wrong_type_arg_error(sc, "gtk_recent_manager_add_full", 2, uri, "gchar*");
  recent_data = s7_car(_p);
  return(s7_make_boolean(sc, gtk_recent_manager_add_full((GtkRecentManager*)s7_c_pointer_with_type(sc, manager, GtkRecentManager__sym, __func__, 0), (gchar*)s7_string(uri), (GtkRecentData*)s7_c_pointer_with_type(sc, recent_data, GtkRecentData__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_model_filter_convert_child_iter_to_iter(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_model_filter_convert_child_iter_to_iter "gboolean gtk_tree_model_filter_convert_child_iter_to_iter(GtkTreeModelFilter* filter, \
GtkTreeIter* filter_iter, GtkTreeIter* child_iter)"
  s7_pointer _p;
  s7_pointer filter, filter_iter, child_iter;
  _p = args;
  filter = s7_car(_p); _p = s7_cdr(_p);
  filter_iter = s7_car(_p); _p = s7_cdr(_p);
  child_iter = s7_car(_p);
  return(s7_make_boolean(sc, gtk_tree_model_filter_convert_child_iter_to_iter((GtkTreeModelFilter*)s7_c_pointer_with_type(sc, filter, GtkTreeModelFilter__sym, __func__, 0), (GtkTreeIter*)s7_c_pointer_with_type(sc, filter_iter, GtkTreeIter__sym, __func__, 0), (GtkTreeIter*)s7_c_pointer_with_type(sc, child_iter, GtkTreeIter__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_view_get_grid_lines(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_get_grid_lines "GtkTreeViewGridLines gtk_tree_view_get_grid_lines(GtkTreeView* tree_view)"
  s7_pointer tree_view;
  tree_view = s7_car(args);
  return(s7_make_integer(sc, gtk_tree_view_get_grid_lines((GtkTreeView*)s7_c_pointer_with_type(sc, tree_view, GtkTreeView__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_view_set_grid_lines(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_set_grid_lines "void gtk_tree_view_set_grid_lines(GtkTreeView* tree_view, GtkTreeViewGridLines grid_lines)"
  s7_pointer _p;
  s7_pointer tree_view, grid_lines;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  grid_lines = s7_car(_p);
  if (!s7_is_integer(grid_lines)) s7_wrong_type_arg_error(sc, "gtk_tree_view_set_grid_lines", 2, grid_lines, "GtkTreeViewGridLines");
  gtk_tree_view_set_grid_lines((GtkTreeView*)s7_c_pointer_with_type(sc, tree_view, GtkTreeView__sym, __func__, 0), (GtkTreeViewGridLines)s7_integer(grid_lines));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_get_enable_tree_lines(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_get_enable_tree_lines "gboolean gtk_tree_view_get_enable_tree_lines(GtkTreeView* tree_view)"
  s7_pointer tree_view;
  tree_view = s7_car(args);
  return(s7_make_boolean(sc, gtk_tree_view_get_enable_tree_lines((GtkTreeView*)s7_c_pointer_with_type(sc, tree_view, GtkTreeView__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_view_set_enable_tree_lines(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_set_enable_tree_lines "void gtk_tree_view_set_enable_tree_lines(GtkTreeView* tree_view, \
gboolean enabled)"
  s7_pointer _p;
  s7_pointer tree_view, enabled;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  enabled = s7_car(_p);
  if (!s7_is_boolean(enabled)) s7_wrong_type_arg_error(sc, "gtk_tree_view_set_enable_tree_lines", 2, enabled, "gboolean");
  gtk_tree_view_set_enable_tree_lines((GtkTreeView*)s7_c_pointer_with_type(sc, tree_view, GtkTreeView__sym, __func__, 0), (gboolean)lg_boolean(enabled));
  return(lg_false);
}

static s7_pointer lg_gtk_print_context_get_cairo_context(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_context_get_cairo_context "cairo_t* gtk_print_context_get_cairo_context(GtkPrintContext* context)"
  s7_pointer context;
  context = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, cairo_t__sym, gtk_print_context_get_cairo_context((GtkPrintContext*)s7_c_pointer_with_type(sc, context, GtkPrintContext__sym, __func__, 0))));
}

static s7_pointer lg_gtk_print_context_get_page_setup(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_context_get_page_setup "GtkPageSetup* gtk_print_context_get_page_setup(GtkPrintContext* context)"
  s7_pointer context;
  context = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GtkPageSetup__sym, gtk_print_context_get_page_setup((GtkPrintContext*)s7_c_pointer_with_type(sc, context, GtkPrintContext__sym, __func__, 0))));
}

static s7_pointer lg_gtk_print_context_get_width(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_context_get_width "gdouble gtk_print_context_get_width(GtkPrintContext* context)"
  s7_pointer context;
  context = s7_car(args);
  return(s7_make_real(sc, gtk_print_context_get_width((GtkPrintContext*)s7_c_pointer_with_type(sc, context, GtkPrintContext__sym, __func__, 0))));
}

static s7_pointer lg_gtk_print_context_get_height(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_context_get_height "gdouble gtk_print_context_get_height(GtkPrintContext* context)"
  s7_pointer context;
  context = s7_car(args);
  return(s7_make_real(sc, gtk_print_context_get_height((GtkPrintContext*)s7_c_pointer_with_type(sc, context, GtkPrintContext__sym, __func__, 0))));
}

static s7_pointer lg_gtk_print_context_get_dpi_x(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_context_get_dpi_x "gdouble gtk_print_context_get_dpi_x(GtkPrintContext* context)"
  s7_pointer context;
  context = s7_car(args);
  return(s7_make_real(sc, gtk_print_context_get_dpi_x((GtkPrintContext*)s7_c_pointer_with_type(sc, context, GtkPrintContext__sym, __func__, 0))));
}

static s7_pointer lg_gtk_print_context_get_dpi_y(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_context_get_dpi_y "gdouble gtk_print_context_get_dpi_y(GtkPrintContext* context)"
  s7_pointer context;
  context = s7_car(args);
  return(s7_make_real(sc, gtk_print_context_get_dpi_y((GtkPrintContext*)s7_c_pointer_with_type(sc, context, GtkPrintContext__sym, __func__, 0))));
}

static s7_pointer lg_gtk_print_context_create_pango_context(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_context_create_pango_context "PangoContext* gtk_print_context_create_pango_context(GtkPrintContext* context)"
  s7_pointer context;
  context = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, PangoContext__sym, gtk_print_context_create_pango_context((GtkPrintContext*)s7_c_pointer_with_type(sc, context, GtkPrintContext__sym, __func__, 0))));
}

static s7_pointer lg_gtk_print_context_create_pango_layout(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_context_create_pango_layout "PangoLayout* gtk_print_context_create_pango_layout(GtkPrintContext* context)"
  s7_pointer context;
  context = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, PangoLayout__sym, gtk_print_context_create_pango_layout((GtkPrintContext*)s7_c_pointer_with_type(sc, context, GtkPrintContext__sym, __func__, 0))));
}

static s7_pointer lg_gtk_print_context_set_cairo_context(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_context_set_cairo_context "void gtk_print_context_set_cairo_context(GtkPrintContext* context, \
cairo_t* cr, double dpi_x, double dpi_y)"
  s7_pointer _p;
  s7_pointer context, cr, dpi_x, dpi_y;
  _p = args;
  context = s7_car(_p); _p = s7_cdr(_p);
  cr = s7_car(_p); _p = s7_cdr(_p);
  dpi_x = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(dpi_x)) s7_wrong_type_arg_error(sc, "gtk_print_context_set_cairo_context", 3, dpi_x, "double");
  dpi_y = s7_car(_p);
  if (!s7_is_real(dpi_y)) s7_wrong_type_arg_error(sc, "gtk_print_context_set_cairo_context", 4, dpi_y, "double");
  gtk_print_context_set_cairo_context((GtkPrintContext*)s7_c_pointer_with_type(sc, context, GtkPrintContext__sym, __func__, 0), (cairo_t*)s7_c_pointer_with_type(sc, cr, cairo_t__sym, __func__, 0), (double)s7_real(dpi_x), (double)s7_real(dpi_y));
  return(lg_false);
}

static s7_pointer lg_gtk_print_operation_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_operation_new "GtkPrintOperation* gtk_print_operation_new( void)"
  return(lg_make_c_pointer_with_type(sc, GtkPrintOperation__sym, gtk_print_operation_new()));
}

static s7_pointer lg_gtk_print_operation_set_default_page_setup(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_operation_set_default_page_setup "void gtk_print_operation_set_default_page_setup(GtkPrintOperation* op, \
GtkPageSetup* default_page_setup)"
  s7_pointer _p;
  s7_pointer op, default_page_setup;
  _p = args;
  op = s7_car(_p); _p = s7_cdr(_p);
  default_page_setup = s7_car(_p);
  gtk_print_operation_set_default_page_setup((GtkPrintOperation*)s7_c_pointer_with_type(sc, op, GtkPrintOperation__sym, __func__, 0), (GtkPageSetup*)s7_c_pointer_with_type(sc, default_page_setup, GtkPageSetup__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_print_operation_get_default_page_setup(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_operation_get_default_page_setup "GtkPageSetup* gtk_print_operation_get_default_page_setup(GtkPrintOperation* op)"
  s7_pointer op;
  op = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GtkPageSetup__sym, gtk_print_operation_get_default_page_setup((GtkPrintOperation*)s7_c_pointer_with_type(sc, op, GtkPrintOperation__sym, __func__, 0))));
}

static s7_pointer lg_gtk_print_operation_set_print_settings(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_operation_set_print_settings "void gtk_print_operation_set_print_settings(GtkPrintOperation* op, \
GtkPrintSettings* print_settings)"
  s7_pointer _p;
  s7_pointer op, print_settings;
  _p = args;
  op = s7_car(_p); _p = s7_cdr(_p);
  print_settings = s7_car(_p);
  gtk_print_operation_set_print_settings((GtkPrintOperation*)s7_c_pointer_with_type(sc, op, GtkPrintOperation__sym, __func__, 0), (GtkPrintSettings*)s7_c_pointer_with_type(sc, print_settings, GtkPrintSettings__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_print_operation_get_print_settings(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_operation_get_print_settings "GtkPrintSettings* gtk_print_operation_get_print_settings(GtkPrintOperation* op)"
  s7_pointer op;
  op = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GtkPrintSettings__sym, gtk_print_operation_get_print_settings((GtkPrintOperation*)s7_c_pointer_with_type(sc, op, GtkPrintOperation__sym, __func__, 0))));
}

static s7_pointer lg_gtk_print_operation_set_job_name(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_operation_set_job_name "void gtk_print_operation_set_job_name(GtkPrintOperation* op, \
gchar* job_name)"
  s7_pointer _p;
  s7_pointer op, job_name;
  _p = args;
  op = s7_car(_p); _p = s7_cdr(_p);
  job_name = s7_car(_p);
  if (!s7_is_string(job_name)) s7_wrong_type_arg_error(sc, "gtk_print_operation_set_job_name", 2, job_name, "gchar*");
  gtk_print_operation_set_job_name((GtkPrintOperation*)s7_c_pointer_with_type(sc, op, GtkPrintOperation__sym, __func__, 0), (gchar*)s7_string(job_name));
  return(lg_false);
}

static s7_pointer lg_gtk_print_operation_set_n_pages(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_operation_set_n_pages "void gtk_print_operation_set_n_pages(GtkPrintOperation* op, \
gint n_pages)"
  s7_pointer _p;
  s7_pointer op, n_pages;
  _p = args;
  op = s7_car(_p); _p = s7_cdr(_p);
  n_pages = s7_car(_p);
  if (!s7_is_integer(n_pages)) s7_wrong_type_arg_error(sc, "gtk_print_operation_set_n_pages", 2, n_pages, "gint");
  gtk_print_operation_set_n_pages((GtkPrintOperation*)s7_c_pointer_with_type(sc, op, GtkPrintOperation__sym, __func__, 0), (gint)s7_integer(n_pages));
  return(lg_false);
}

static s7_pointer lg_gtk_print_operation_set_current_page(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_operation_set_current_page "void gtk_print_operation_set_current_page(GtkPrintOperation* op, \
gint current_page)"
  s7_pointer _p;
  s7_pointer op, current_page;
  _p = args;
  op = s7_car(_p); _p = s7_cdr(_p);
  current_page = s7_car(_p);
  if (!s7_is_integer(current_page)) s7_wrong_type_arg_error(sc, "gtk_print_operation_set_current_page", 2, current_page, "gint");
  gtk_print_operation_set_current_page((GtkPrintOperation*)s7_c_pointer_with_type(sc, op, GtkPrintOperation__sym, __func__, 0), (gint)s7_integer(current_page));
  return(lg_false);
}

static s7_pointer lg_gtk_print_operation_set_use_full_page(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_operation_set_use_full_page "void gtk_print_operation_set_use_full_page(GtkPrintOperation* op, \
gboolean full_page)"
  s7_pointer _p;
  s7_pointer op, full_page;
  _p = args;
  op = s7_car(_p); _p = s7_cdr(_p);
  full_page = s7_car(_p);
  if (!s7_is_boolean(full_page)) s7_wrong_type_arg_error(sc, "gtk_print_operation_set_use_full_page", 2, full_page, "gboolean");
  gtk_print_operation_set_use_full_page((GtkPrintOperation*)s7_c_pointer_with_type(sc, op, GtkPrintOperation__sym, __func__, 0), (gboolean)lg_boolean(full_page));
  return(lg_false);
}

static s7_pointer lg_gtk_print_operation_set_unit(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_operation_set_unit "void gtk_print_operation_set_unit(GtkPrintOperation* op, GtkUnit unit)"
  s7_pointer _p;
  s7_pointer op, unit;
  _p = args;
  op = s7_car(_p); _p = s7_cdr(_p);
  unit = s7_car(_p);
  if (!s7_is_integer(unit)) s7_wrong_type_arg_error(sc, "gtk_print_operation_set_unit", 2, unit, "GtkUnit");
  gtk_print_operation_set_unit((GtkPrintOperation*)s7_c_pointer_with_type(sc, op, GtkPrintOperation__sym, __func__, 0), (GtkUnit)s7_integer(unit));
  return(lg_false);
}

static s7_pointer lg_gtk_print_operation_set_export_filename(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_operation_set_export_filename "void gtk_print_operation_set_export_filename(GtkPrintOperation* op, \
gchar* filename)"
  s7_pointer _p;
  s7_pointer op, filename;
  _p = args;
  op = s7_car(_p); _p = s7_cdr(_p);
  filename = s7_car(_p);
  if (!s7_is_string(filename)) s7_wrong_type_arg_error(sc, "gtk_print_operation_set_export_filename", 2, filename, "gchar*");
  gtk_print_operation_set_export_filename((GtkPrintOperation*)s7_c_pointer_with_type(sc, op, GtkPrintOperation__sym, __func__, 0), (gchar*)s7_string(filename));
  return(lg_false);
}

static s7_pointer lg_gtk_print_operation_set_track_print_status(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_operation_set_track_print_status "void gtk_print_operation_set_track_print_status(GtkPrintOperation* op, \
gboolean track_status)"
  s7_pointer _p;
  s7_pointer op, track_status;
  _p = args;
  op = s7_car(_p); _p = s7_cdr(_p);
  track_status = s7_car(_p);
  if (!s7_is_boolean(track_status)) s7_wrong_type_arg_error(sc, "gtk_print_operation_set_track_print_status", 2, track_status, "gboolean");
  gtk_print_operation_set_track_print_status((GtkPrintOperation*)s7_c_pointer_with_type(sc, op, GtkPrintOperation__sym, __func__, 0), (gboolean)lg_boolean(track_status));
  return(lg_false);
}

static s7_pointer lg_gtk_print_operation_set_show_progress(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_operation_set_show_progress "void gtk_print_operation_set_show_progress(GtkPrintOperation* op, \
gboolean show_progress)"
  s7_pointer _p;
  s7_pointer op, show_progress;
  _p = args;
  op = s7_car(_p); _p = s7_cdr(_p);
  show_progress = s7_car(_p);
  if (!s7_is_boolean(show_progress)) s7_wrong_type_arg_error(sc, "gtk_print_operation_set_show_progress", 2, show_progress, "gboolean");
  gtk_print_operation_set_show_progress((GtkPrintOperation*)s7_c_pointer_with_type(sc, op, GtkPrintOperation__sym, __func__, 0), (gboolean)lg_boolean(show_progress));
  return(lg_false);
}

static s7_pointer lg_gtk_print_operation_set_allow_async(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_operation_set_allow_async "void gtk_print_operation_set_allow_async(GtkPrintOperation* op, \
gboolean allow_async)"
  s7_pointer _p;
  s7_pointer op, allow_async;
  _p = args;
  op = s7_car(_p); _p = s7_cdr(_p);
  allow_async = s7_car(_p);
  if (!s7_is_boolean(allow_async)) s7_wrong_type_arg_error(sc, "gtk_print_operation_set_allow_async", 2, allow_async, "gboolean");
  gtk_print_operation_set_allow_async((GtkPrintOperation*)s7_c_pointer_with_type(sc, op, GtkPrintOperation__sym, __func__, 0), (gboolean)lg_boolean(allow_async));
  return(lg_false);
}

static s7_pointer lg_gtk_print_operation_set_custom_tab_label(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_operation_set_custom_tab_label "void gtk_print_operation_set_custom_tab_label(GtkPrintOperation* op, \
gchar* label)"
  s7_pointer _p;
  s7_pointer op, label;
  _p = args;
  op = s7_car(_p); _p = s7_cdr(_p);
  label = s7_car(_p);
  if (!s7_is_string(label)) s7_wrong_type_arg_error(sc, "gtk_print_operation_set_custom_tab_label", 2, label, "gchar*");
  gtk_print_operation_set_custom_tab_label((GtkPrintOperation*)s7_c_pointer_with_type(sc, op, GtkPrintOperation__sym, __func__, 0), (gchar*)s7_string(label));
  return(lg_false);
}

static s7_pointer lg_gtk_print_operation_run(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_operation_run "GtkPrintOperationResult gtk_print_operation_run(GtkPrintOperation* op, \
GtkPrintOperationAction action, GtkWindow* parent, GError** [error])"
  s7_pointer _p;
  s7_pointer op, action, parent;
  GError* ref_error = NULL;
  _p = args;
  op = s7_car(_p); _p = s7_cdr(_p);
  action = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(action)) s7_wrong_type_arg_error(sc, "gtk_print_operation_run", 2, action, "GtkPrintOperationAction");
  parent = s7_car(_p);
  {
    s7_pointer res_ult;
    res_ult = s7_make_integer(sc, gtk_print_operation_run((GtkPrintOperation*)s7_c_pointer_with_type(sc, op, GtkPrintOperation__sym, __func__, 0), (GtkPrintOperationAction)s7_integer(action), (GtkWindow*)s7_c_pointer_with_type(sc, parent, GtkWindow__sym, __func__, 0), &ref_error));
      return(s7_list(sc, 2, res_ult, s7_make_c_pointer(sc, ref_error)));
   }
}

static s7_pointer lg_gtk_print_operation_get_error(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_operation_get_error "void gtk_print_operation_get_error(GtkPrintOperation* op, \
GError** [error])"
  s7_pointer _p;
  s7_pointer op;
  GError* ref_error = NULL;
  _p = args;
  op = s7_car(_p);
  gtk_print_operation_get_error((GtkPrintOperation*)s7_c_pointer_with_type(sc, op, GtkPrintOperation__sym, __func__, 0), &ref_error);
    return(s7_list(sc, 1, s7_make_c_pointer(sc, ref_error)));
}

static s7_pointer lg_gtk_print_operation_get_status(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_operation_get_status "GtkPrintStatus gtk_print_operation_get_status(GtkPrintOperation* op)"
  s7_pointer op;
  op = s7_car(args);
  return(s7_make_integer(sc, gtk_print_operation_get_status((GtkPrintOperation*)s7_c_pointer_with_type(sc, op, GtkPrintOperation__sym, __func__, 0))));
}

static s7_pointer lg_gtk_print_operation_get_status_string(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_operation_get_status_string "gchar* gtk_print_operation_get_status_string(GtkPrintOperation* op)"
  s7_pointer op;
  op = s7_car(args);
  return(s7_make_string(sc, gtk_print_operation_get_status_string((GtkPrintOperation*)s7_c_pointer_with_type(sc, op, GtkPrintOperation__sym, __func__, 0))));
}

static s7_pointer lg_gtk_print_operation_is_finished(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_operation_is_finished "gboolean gtk_print_operation_is_finished(GtkPrintOperation* op)"
  s7_pointer op;
  op = s7_car(args);
  return(s7_make_boolean(sc, gtk_print_operation_is_finished((GtkPrintOperation*)s7_c_pointer_with_type(sc, op, GtkPrintOperation__sym, __func__, 0))));
}

static s7_pointer lg_gtk_print_operation_cancel(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_operation_cancel "void gtk_print_operation_cancel(GtkPrintOperation* op)"
  s7_pointer op;
  op = s7_car(args);
  gtk_print_operation_cancel((GtkPrintOperation*)s7_c_pointer_with_type(sc, op, GtkPrintOperation__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_print_run_page_setup_dialog(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_run_page_setup_dialog "GtkPageSetup* gtk_print_run_page_setup_dialog(GtkWindow* parent, \
GtkPageSetup* page_setup, GtkPrintSettings* settings)"
  s7_pointer _p;
  s7_pointer parent, page_setup, settings;
  _p = args;
  parent = s7_car(_p); _p = s7_cdr(_p);
  page_setup = s7_car(_p); _p = s7_cdr(_p);
  settings = s7_car(_p);
  return(lg_make_c_pointer_with_type(sc, GtkPageSetup__sym, gtk_print_run_page_setup_dialog((GtkWindow*)s7_c_pointer_with_type(sc, parent, GtkWindow__sym, __func__, 0), (GtkPageSetup*)s7_c_pointer_with_type(sc, page_setup, GtkPageSetup__sym, __func__, 0), (GtkPrintSettings*)s7_c_pointer_with_type(sc, settings, GtkPrintSettings__sym, __func__, 0))));
}

static s7_pointer lg_gtk_print_run_page_setup_dialog_async(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_run_page_setup_dialog_async "void gtk_print_run_page_setup_dialog_async(GtkWindow* parent, \
GtkPageSetup* page_setup, GtkPrintSettings* settings, GtkPageSetupDoneFunc done_cb, gpointer data)"
  s7_pointer _p;
  s7_pointer parent, page_setup, settings, done_cb, data;
  _p = args;
  parent = s7_car(_p); _p = s7_cdr(_p);
  page_setup = s7_car(_p); _p = s7_cdr(_p);
  settings = s7_car(_p); _p = s7_cdr(_p);
  done_cb = s7_car(_p); _p = s7_cdr(_p);
  data = s7_car(_p);
  gtk_print_run_page_setup_dialog_async((GtkWindow*)s7_c_pointer_with_type(sc, parent, GtkWindow__sym, __func__, 0), (GtkPageSetup*)s7_c_pointer_with_type(sc, page_setup, GtkPageSetup__sym, __func__, 0), (GtkPrintSettings*)s7_c_pointer_with_type(sc, settings, GtkPrintSettings__sym, __func__, 0), (GtkPageSetupDoneFunc)s7_c_pointer_with_type(sc, done_cb, GtkPageSetupDoneFunc_sym, __func__, 0), (gpointer)s7_c_pointer_with_type(sc, data, gpointer_sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_print_settings_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_settings_new "GtkPrintSettings* gtk_print_settings_new( void)"
  return(lg_make_c_pointer_with_type(sc, GtkPrintSettings__sym, gtk_print_settings_new()));
}

static s7_pointer lg_gtk_print_settings_copy(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_settings_copy "GtkPrintSettings* gtk_print_settings_copy(GtkPrintSettings* other)"
  s7_pointer other;
  other = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GtkPrintSettings__sym, gtk_print_settings_copy((GtkPrintSettings*)s7_c_pointer_with_type(sc, other, GtkPrintSettings__sym, __func__, 0))));
}

static s7_pointer lg_gtk_print_settings_has_key(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_settings_has_key "gboolean gtk_print_settings_has_key(GtkPrintSettings* settings, \
gchar* key)"
  s7_pointer _p;
  s7_pointer settings, key;
  _p = args;
  settings = s7_car(_p); _p = s7_cdr(_p);
  key = s7_car(_p);
  if (!s7_is_string(key)) s7_wrong_type_arg_error(sc, "gtk_print_settings_has_key", 2, key, "gchar*");
  return(s7_make_boolean(sc, gtk_print_settings_has_key((GtkPrintSettings*)s7_c_pointer_with_type(sc, settings, GtkPrintSettings__sym, __func__, 0), (gchar*)s7_string(key))));
}

static s7_pointer lg_gtk_print_settings_get(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_settings_get "gchar* gtk_print_settings_get(GtkPrintSettings* settings, gchar* key)"
  s7_pointer _p;
  s7_pointer settings, key;
  _p = args;
  settings = s7_car(_p); _p = s7_cdr(_p);
  key = s7_car(_p);
  if (!s7_is_string(key)) s7_wrong_type_arg_error(sc, "gtk_print_settings_get", 2, key, "gchar*");
  return(s7_make_string(sc, gtk_print_settings_get((GtkPrintSettings*)s7_c_pointer_with_type(sc, settings, GtkPrintSettings__sym, __func__, 0), (gchar*)s7_string(key))));
}

static s7_pointer lg_gtk_print_settings_set(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_settings_set "void gtk_print_settings_set(GtkPrintSettings* settings, gchar* key, \
gchar* value)"
  s7_pointer _p;
  s7_pointer settings, key, value;
  _p = args;
  settings = s7_car(_p); _p = s7_cdr(_p);
  key = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(key)) s7_wrong_type_arg_error(sc, "gtk_print_settings_set", 2, key, "gchar*");
  value = s7_car(_p);
  if (!s7_is_string(value)) s7_wrong_type_arg_error(sc, "gtk_print_settings_set", 3, value, "gchar*");
  gtk_print_settings_set((GtkPrintSettings*)s7_c_pointer_with_type(sc, settings, GtkPrintSettings__sym, __func__, 0), (gchar*)s7_string(key), (gchar*)s7_string(value));
  return(lg_false);
}

static s7_pointer lg_gtk_print_settings_unset(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_settings_unset "void gtk_print_settings_unset(GtkPrintSettings* settings, gchar* key)"
  s7_pointer _p;
  s7_pointer settings, key;
  _p = args;
  settings = s7_car(_p); _p = s7_cdr(_p);
  key = s7_car(_p);
  if (!s7_is_string(key)) s7_wrong_type_arg_error(sc, "gtk_print_settings_unset", 2, key, "gchar*");
  gtk_print_settings_unset((GtkPrintSettings*)s7_c_pointer_with_type(sc, settings, GtkPrintSettings__sym, __func__, 0), (gchar*)s7_string(key));
  return(lg_false);
}

static s7_pointer lg_gtk_print_settings_foreach(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_settings_foreach "void gtk_print_settings_foreach(GtkPrintSettings* settings, GtkPrintSettingsFunc func, \
gpointer user_data)"
  s7_pointer _p;
  s7_pointer settings, func, user_data;
  _p = args;
  settings = s7_car(_p); _p = s7_cdr(_p);
  func = s7_car(_p); _p = s7_cdr(_p);
  user_data = s7_car(_p);
  gtk_print_settings_foreach((GtkPrintSettings*)s7_c_pointer_with_type(sc, settings, GtkPrintSettings__sym, __func__, 0), (GtkPrintSettingsFunc)s7_c_pointer_with_type(sc, func, GtkPrintSettingsFunc_sym, __func__, 0), (gpointer)s7_c_pointer_with_type(sc, user_data, gpointer_sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_print_settings_get_bool(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_settings_get_bool "gboolean gtk_print_settings_get_bool(GtkPrintSettings* settings, \
gchar* key)"
  s7_pointer _p;
  s7_pointer settings, key;
  _p = args;
  settings = s7_car(_p); _p = s7_cdr(_p);
  key = s7_car(_p);
  if (!s7_is_string(key)) s7_wrong_type_arg_error(sc, "gtk_print_settings_get_bool", 2, key, "gchar*");
  return(s7_make_boolean(sc, gtk_print_settings_get_bool((GtkPrintSettings*)s7_c_pointer_with_type(sc, settings, GtkPrintSettings__sym, __func__, 0), (gchar*)s7_string(key))));
}

static s7_pointer lg_gtk_print_settings_set_bool(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_settings_set_bool "void gtk_print_settings_set_bool(GtkPrintSettings* settings, \
gchar* key, gboolean value)"
  s7_pointer _p;
  s7_pointer settings, key, value;
  _p = args;
  settings = s7_car(_p); _p = s7_cdr(_p);
  key = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(key)) s7_wrong_type_arg_error(sc, "gtk_print_settings_set_bool", 2, key, "gchar*");
  value = s7_car(_p);
  if (!s7_is_boolean(value)) s7_wrong_type_arg_error(sc, "gtk_print_settings_set_bool", 3, value, "gboolean");
  gtk_print_settings_set_bool((GtkPrintSettings*)s7_c_pointer_with_type(sc, settings, GtkPrintSettings__sym, __func__, 0), (gchar*)s7_string(key), (gboolean)lg_boolean(value));
  return(lg_false);
}

static s7_pointer lg_gtk_print_settings_get_double(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_settings_get_double "gdouble gtk_print_settings_get_double(GtkPrintSettings* settings, \
gchar* key)"
  s7_pointer _p;
  s7_pointer settings, key;
  _p = args;
  settings = s7_car(_p); _p = s7_cdr(_p);
  key = s7_car(_p);
  if (!s7_is_string(key)) s7_wrong_type_arg_error(sc, "gtk_print_settings_get_double", 2, key, "gchar*");
  return(s7_make_real(sc, gtk_print_settings_get_double((GtkPrintSettings*)s7_c_pointer_with_type(sc, settings, GtkPrintSettings__sym, __func__, 0), (gchar*)s7_string(key))));
}

static s7_pointer lg_gtk_print_settings_get_double_with_default(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_settings_get_double_with_default "gdouble gtk_print_settings_get_double_with_default(GtkPrintSettings* settings, \
gchar* key, gdouble def)"
  s7_pointer _p;
  s7_pointer settings, key, def;
  _p = args;
  settings = s7_car(_p); _p = s7_cdr(_p);
  key = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(key)) s7_wrong_type_arg_error(sc, "gtk_print_settings_get_double_with_default", 2, key, "gchar*");
  def = s7_car(_p);
  if (!s7_is_real(def)) s7_wrong_type_arg_error(sc, "gtk_print_settings_get_double_with_default", 3, def, "gdouble");
  return(s7_make_real(sc, gtk_print_settings_get_double_with_default((GtkPrintSettings*)s7_c_pointer_with_type(sc, settings, GtkPrintSettings__sym, __func__, 0), (gchar*)s7_string(key), (gdouble)s7_real(def))));
}

static s7_pointer lg_gtk_print_settings_set_double(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_settings_set_double "void gtk_print_settings_set_double(GtkPrintSettings* settings, \
gchar* key, gdouble value)"
  s7_pointer _p;
  s7_pointer settings, key, value;
  _p = args;
  settings = s7_car(_p); _p = s7_cdr(_p);
  key = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(key)) s7_wrong_type_arg_error(sc, "gtk_print_settings_set_double", 2, key, "gchar*");
  value = s7_car(_p);
  if (!s7_is_real(value)) s7_wrong_type_arg_error(sc, "gtk_print_settings_set_double", 3, value, "gdouble");
  gtk_print_settings_set_double((GtkPrintSettings*)s7_c_pointer_with_type(sc, settings, GtkPrintSettings__sym, __func__, 0), (gchar*)s7_string(key), (gdouble)s7_real(value));
  return(lg_false);
}

static s7_pointer lg_gtk_print_settings_get_length(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_settings_get_length "gdouble gtk_print_settings_get_length(GtkPrintSettings* settings, \
gchar* key, GtkUnit unit)"
  s7_pointer _p;
  s7_pointer settings, key, unit;
  _p = args;
  settings = s7_car(_p); _p = s7_cdr(_p);
  key = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(key)) s7_wrong_type_arg_error(sc, "gtk_print_settings_get_length", 2, key, "gchar*");
  unit = s7_car(_p);
  if (!s7_is_integer(unit)) s7_wrong_type_arg_error(sc, "gtk_print_settings_get_length", 3, unit, "GtkUnit");
  return(s7_make_real(sc, gtk_print_settings_get_length((GtkPrintSettings*)s7_c_pointer_with_type(sc, settings, GtkPrintSettings__sym, __func__, 0), (gchar*)s7_string(key), (GtkUnit)s7_integer(unit))));
}

static s7_pointer lg_gtk_print_settings_set_length(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_settings_set_length "void gtk_print_settings_set_length(GtkPrintSettings* settings, \
gchar* key, gdouble value, GtkUnit unit)"
  s7_pointer _p;
  s7_pointer settings, key, value, unit;
  _p = args;
  settings = s7_car(_p); _p = s7_cdr(_p);
  key = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(key)) s7_wrong_type_arg_error(sc, "gtk_print_settings_set_length", 2, key, "gchar*");
  value = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(value)) s7_wrong_type_arg_error(sc, "gtk_print_settings_set_length", 3, value, "gdouble");
  unit = s7_car(_p);
  if (!s7_is_integer(unit)) s7_wrong_type_arg_error(sc, "gtk_print_settings_set_length", 4, unit, "GtkUnit");
  gtk_print_settings_set_length((GtkPrintSettings*)s7_c_pointer_with_type(sc, settings, GtkPrintSettings__sym, __func__, 0), (gchar*)s7_string(key), (gdouble)s7_real(value), (GtkUnit)s7_integer(unit));
  return(lg_false);
}

static s7_pointer lg_gtk_print_settings_get_int(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_settings_get_int "gint gtk_print_settings_get_int(GtkPrintSettings* settings, gchar* key)"
  s7_pointer _p;
  s7_pointer settings, key;
  _p = args;
  settings = s7_car(_p); _p = s7_cdr(_p);
  key = s7_car(_p);
  if (!s7_is_string(key)) s7_wrong_type_arg_error(sc, "gtk_print_settings_get_int", 2, key, "gchar*");
  return(s7_make_integer(sc, gtk_print_settings_get_int((GtkPrintSettings*)s7_c_pointer_with_type(sc, settings, GtkPrintSettings__sym, __func__, 0), (gchar*)s7_string(key))));
}

static s7_pointer lg_gtk_print_settings_get_int_with_default(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_settings_get_int_with_default "gint gtk_print_settings_get_int_with_default(GtkPrintSettings* settings, \
gchar* key, gint def)"
  s7_pointer _p;
  s7_pointer settings, key, def;
  _p = args;
  settings = s7_car(_p); _p = s7_cdr(_p);
  key = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(key)) s7_wrong_type_arg_error(sc, "gtk_print_settings_get_int_with_default", 2, key, "gchar*");
  def = s7_car(_p);
  if (!s7_is_integer(def)) s7_wrong_type_arg_error(sc, "gtk_print_settings_get_int_with_default", 3, def, "gint");
  return(s7_make_integer(sc, gtk_print_settings_get_int_with_default((GtkPrintSettings*)s7_c_pointer_with_type(sc, settings, GtkPrintSettings__sym, __func__, 0), (gchar*)s7_string(key), (gint)s7_integer(def))));
}

static s7_pointer lg_gtk_print_settings_set_int(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_settings_set_int "void gtk_print_settings_set_int(GtkPrintSettings* settings, gchar* key, \
gint value)"
  s7_pointer _p;
  s7_pointer settings, key, value;
  _p = args;
  settings = s7_car(_p); _p = s7_cdr(_p);
  key = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(key)) s7_wrong_type_arg_error(sc, "gtk_print_settings_set_int", 2, key, "gchar*");
  value = s7_car(_p);
  if (!s7_is_integer(value)) s7_wrong_type_arg_error(sc, "gtk_print_settings_set_int", 3, value, "gint");
  gtk_print_settings_set_int((GtkPrintSettings*)s7_c_pointer_with_type(sc, settings, GtkPrintSettings__sym, __func__, 0), (gchar*)s7_string(key), (gint)s7_integer(value));
  return(lg_false);
}

static s7_pointer lg_gtk_print_settings_get_printer(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_settings_get_printer "gchar* gtk_print_settings_get_printer(GtkPrintSettings* settings)"
  s7_pointer settings;
  settings = s7_car(args);
  return(s7_make_string(sc, gtk_print_settings_get_printer((GtkPrintSettings*)s7_c_pointer_with_type(sc, settings, GtkPrintSettings__sym, __func__, 0))));
}

static s7_pointer lg_gtk_print_settings_set_printer(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_settings_set_printer "void gtk_print_settings_set_printer(GtkPrintSettings* settings, \
gchar* printer)"
  s7_pointer _p;
  s7_pointer settings, printer;
  _p = args;
  settings = s7_car(_p); _p = s7_cdr(_p);
  printer = s7_car(_p);
  if (!s7_is_string(printer)) s7_wrong_type_arg_error(sc, "gtk_print_settings_set_printer", 2, printer, "gchar*");
  gtk_print_settings_set_printer((GtkPrintSettings*)s7_c_pointer_with_type(sc, settings, GtkPrintSettings__sym, __func__, 0), (gchar*)s7_string(printer));
  return(lg_false);
}

static s7_pointer lg_gtk_print_settings_get_orientation(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_settings_get_orientation "GtkPageOrientation gtk_print_settings_get_orientation(GtkPrintSettings* settings)"
  s7_pointer settings;
  settings = s7_car(args);
  return(s7_make_integer(sc, gtk_print_settings_get_orientation((GtkPrintSettings*)s7_c_pointer_with_type(sc, settings, GtkPrintSettings__sym, __func__, 0))));
}

static s7_pointer lg_gtk_print_settings_set_orientation(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_settings_set_orientation "void gtk_print_settings_set_orientation(GtkPrintSettings* settings, \
GtkPageOrientation orientation)"
  s7_pointer _p;
  s7_pointer settings, orientation;
  _p = args;
  settings = s7_car(_p); _p = s7_cdr(_p);
  orientation = s7_car(_p);
  if (!s7_is_integer(orientation)) s7_wrong_type_arg_error(sc, "gtk_print_settings_set_orientation", 2, orientation, "GtkPageOrientation");
  gtk_print_settings_set_orientation((GtkPrintSettings*)s7_c_pointer_with_type(sc, settings, GtkPrintSettings__sym, __func__, 0), (GtkPageOrientation)s7_integer(orientation));
  return(lg_false);
}

static s7_pointer lg_gtk_print_settings_get_paper_size(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_settings_get_paper_size "GtkPaperSize* gtk_print_settings_get_paper_size(GtkPrintSettings* settings)"
  s7_pointer settings;
  settings = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GtkPaperSize__sym, gtk_print_settings_get_paper_size((GtkPrintSettings*)s7_c_pointer_with_type(sc, settings, GtkPrintSettings__sym, __func__, 0))));
}

static s7_pointer lg_gtk_print_settings_set_paper_size(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_settings_set_paper_size "void gtk_print_settings_set_paper_size(GtkPrintSettings* settings, \
GtkPaperSize* paper_size)"
  s7_pointer _p;
  s7_pointer settings, paper_size;
  _p = args;
  settings = s7_car(_p); _p = s7_cdr(_p);
  paper_size = s7_car(_p);
  gtk_print_settings_set_paper_size((GtkPrintSettings*)s7_c_pointer_with_type(sc, settings, GtkPrintSettings__sym, __func__, 0), (GtkPaperSize*)s7_c_pointer_with_type(sc, paper_size, GtkPaperSize__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_print_settings_get_paper_width(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_settings_get_paper_width "gdouble gtk_print_settings_get_paper_width(GtkPrintSettings* settings, \
GtkUnit unit)"
  s7_pointer _p;
  s7_pointer settings, unit;
  _p = args;
  settings = s7_car(_p); _p = s7_cdr(_p);
  unit = s7_car(_p);
  if (!s7_is_integer(unit)) s7_wrong_type_arg_error(sc, "gtk_print_settings_get_paper_width", 2, unit, "GtkUnit");
  return(s7_make_real(sc, gtk_print_settings_get_paper_width((GtkPrintSettings*)s7_c_pointer_with_type(sc, settings, GtkPrintSettings__sym, __func__, 0), (GtkUnit)s7_integer(unit))));
}

static s7_pointer lg_gtk_print_settings_set_paper_width(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_settings_set_paper_width "void gtk_print_settings_set_paper_width(GtkPrintSettings* settings, \
gdouble width, GtkUnit unit)"
  s7_pointer _p;
  s7_pointer settings, width, unit;
  _p = args;
  settings = s7_car(_p); _p = s7_cdr(_p);
  width = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(width)) s7_wrong_type_arg_error(sc, "gtk_print_settings_set_paper_width", 2, width, "gdouble");
  unit = s7_car(_p);
  if (!s7_is_integer(unit)) s7_wrong_type_arg_error(sc, "gtk_print_settings_set_paper_width", 3, unit, "GtkUnit");
  gtk_print_settings_set_paper_width((GtkPrintSettings*)s7_c_pointer_with_type(sc, settings, GtkPrintSettings__sym, __func__, 0), (gdouble)s7_real(width), (GtkUnit)s7_integer(unit));
  return(lg_false);
}

static s7_pointer lg_gtk_print_settings_get_paper_height(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_settings_get_paper_height "gdouble gtk_print_settings_get_paper_height(GtkPrintSettings* settings, \
GtkUnit unit)"
  s7_pointer _p;
  s7_pointer settings, unit;
  _p = args;
  settings = s7_car(_p); _p = s7_cdr(_p);
  unit = s7_car(_p);
  if (!s7_is_integer(unit)) s7_wrong_type_arg_error(sc, "gtk_print_settings_get_paper_height", 2, unit, "GtkUnit");
  return(s7_make_real(sc, gtk_print_settings_get_paper_height((GtkPrintSettings*)s7_c_pointer_with_type(sc, settings, GtkPrintSettings__sym, __func__, 0), (GtkUnit)s7_integer(unit))));
}

static s7_pointer lg_gtk_print_settings_set_paper_height(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_settings_set_paper_height "void gtk_print_settings_set_paper_height(GtkPrintSettings* settings, \
gdouble height, GtkUnit unit)"
  s7_pointer _p;
  s7_pointer settings, height, unit;
  _p = args;
  settings = s7_car(_p); _p = s7_cdr(_p);
  height = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(height)) s7_wrong_type_arg_error(sc, "gtk_print_settings_set_paper_height", 2, height, "gdouble");
  unit = s7_car(_p);
  if (!s7_is_integer(unit)) s7_wrong_type_arg_error(sc, "gtk_print_settings_set_paper_height", 3, unit, "GtkUnit");
  gtk_print_settings_set_paper_height((GtkPrintSettings*)s7_c_pointer_with_type(sc, settings, GtkPrintSettings__sym, __func__, 0), (gdouble)s7_real(height), (GtkUnit)s7_integer(unit));
  return(lg_false);
}

static s7_pointer lg_gtk_print_settings_get_use_color(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_settings_get_use_color "gboolean gtk_print_settings_get_use_color(GtkPrintSettings* settings)"
  s7_pointer settings;
  settings = s7_car(args);
  return(s7_make_boolean(sc, gtk_print_settings_get_use_color((GtkPrintSettings*)s7_c_pointer_with_type(sc, settings, GtkPrintSettings__sym, __func__, 0))));
}

static s7_pointer lg_gtk_print_settings_set_use_color(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_settings_set_use_color "void gtk_print_settings_set_use_color(GtkPrintSettings* settings, \
gboolean use_color)"
  s7_pointer _p;
  s7_pointer settings, use_color;
  _p = args;
  settings = s7_car(_p); _p = s7_cdr(_p);
  use_color = s7_car(_p);
  if (!s7_is_boolean(use_color)) s7_wrong_type_arg_error(sc, "gtk_print_settings_set_use_color", 2, use_color, "gboolean");
  gtk_print_settings_set_use_color((GtkPrintSettings*)s7_c_pointer_with_type(sc, settings, GtkPrintSettings__sym, __func__, 0), (gboolean)lg_boolean(use_color));
  return(lg_false);
}

static s7_pointer lg_gtk_print_settings_get_collate(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_settings_get_collate "gboolean gtk_print_settings_get_collate(GtkPrintSettings* settings)"
  s7_pointer settings;
  settings = s7_car(args);
  return(s7_make_boolean(sc, gtk_print_settings_get_collate((GtkPrintSettings*)s7_c_pointer_with_type(sc, settings, GtkPrintSettings__sym, __func__, 0))));
}

static s7_pointer lg_gtk_print_settings_set_collate(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_settings_set_collate "void gtk_print_settings_set_collate(GtkPrintSettings* settings, \
gboolean collate)"
  s7_pointer _p;
  s7_pointer settings, collate;
  _p = args;
  settings = s7_car(_p); _p = s7_cdr(_p);
  collate = s7_car(_p);
  if (!s7_is_boolean(collate)) s7_wrong_type_arg_error(sc, "gtk_print_settings_set_collate", 2, collate, "gboolean");
  gtk_print_settings_set_collate((GtkPrintSettings*)s7_c_pointer_with_type(sc, settings, GtkPrintSettings__sym, __func__, 0), (gboolean)lg_boolean(collate));
  return(lg_false);
}

static s7_pointer lg_gtk_print_settings_get_reverse(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_settings_get_reverse "gboolean gtk_print_settings_get_reverse(GtkPrintSettings* settings)"
  s7_pointer settings;
  settings = s7_car(args);
  return(s7_make_boolean(sc, gtk_print_settings_get_reverse((GtkPrintSettings*)s7_c_pointer_with_type(sc, settings, GtkPrintSettings__sym, __func__, 0))));
}

static s7_pointer lg_gtk_print_settings_set_reverse(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_settings_set_reverse "void gtk_print_settings_set_reverse(GtkPrintSettings* settings, \
gboolean reverse)"
  s7_pointer _p;
  s7_pointer settings, reverse;
  _p = args;
  settings = s7_car(_p); _p = s7_cdr(_p);
  reverse = s7_car(_p);
  if (!s7_is_boolean(reverse)) s7_wrong_type_arg_error(sc, "gtk_print_settings_set_reverse", 2, reverse, "gboolean");
  gtk_print_settings_set_reverse((GtkPrintSettings*)s7_c_pointer_with_type(sc, settings, GtkPrintSettings__sym, __func__, 0), (gboolean)lg_boolean(reverse));
  return(lg_false);
}

static s7_pointer lg_gtk_print_settings_get_duplex(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_settings_get_duplex "GtkPrintDuplex gtk_print_settings_get_duplex(GtkPrintSettings* settings)"
  s7_pointer settings;
  settings = s7_car(args);
  return(s7_make_integer(sc, gtk_print_settings_get_duplex((GtkPrintSettings*)s7_c_pointer_with_type(sc, settings, GtkPrintSettings__sym, __func__, 0))));
}

static s7_pointer lg_gtk_print_settings_set_duplex(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_settings_set_duplex "void gtk_print_settings_set_duplex(GtkPrintSettings* settings, \
GtkPrintDuplex duplex)"
  s7_pointer _p;
  s7_pointer settings, duplex;
  _p = args;
  settings = s7_car(_p); _p = s7_cdr(_p);
  duplex = s7_car(_p);
  if (!s7_is_integer(duplex)) s7_wrong_type_arg_error(sc, "gtk_print_settings_set_duplex", 2, duplex, "GtkPrintDuplex");
  gtk_print_settings_set_duplex((GtkPrintSettings*)s7_c_pointer_with_type(sc, settings, GtkPrintSettings__sym, __func__, 0), (GtkPrintDuplex)s7_integer(duplex));
  return(lg_false);
}

static s7_pointer lg_gtk_print_settings_get_quality(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_settings_get_quality "GtkPrintQuality gtk_print_settings_get_quality(GtkPrintSettings* settings)"
  s7_pointer settings;
  settings = s7_car(args);
  return(s7_make_integer(sc, gtk_print_settings_get_quality((GtkPrintSettings*)s7_c_pointer_with_type(sc, settings, GtkPrintSettings__sym, __func__, 0))));
}

static s7_pointer lg_gtk_print_settings_set_quality(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_settings_set_quality "void gtk_print_settings_set_quality(GtkPrintSettings* settings, \
GtkPrintQuality quality)"
  s7_pointer _p;
  s7_pointer settings, quality;
  _p = args;
  settings = s7_car(_p); _p = s7_cdr(_p);
  quality = s7_car(_p);
  if (!s7_is_integer(quality)) s7_wrong_type_arg_error(sc, "gtk_print_settings_set_quality", 2, quality, "GtkPrintQuality");
  gtk_print_settings_set_quality((GtkPrintSettings*)s7_c_pointer_with_type(sc, settings, GtkPrintSettings__sym, __func__, 0), (GtkPrintQuality)s7_integer(quality));
  return(lg_false);
}

static s7_pointer lg_gtk_print_settings_get_n_copies(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_settings_get_n_copies "gint gtk_print_settings_get_n_copies(GtkPrintSettings* settings)"
  s7_pointer settings;
  settings = s7_car(args);
  return(s7_make_integer(sc, gtk_print_settings_get_n_copies((GtkPrintSettings*)s7_c_pointer_with_type(sc, settings, GtkPrintSettings__sym, __func__, 0))));
}

static s7_pointer lg_gtk_print_settings_set_n_copies(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_settings_set_n_copies "void gtk_print_settings_set_n_copies(GtkPrintSettings* settings, \
gint num_copies)"
  s7_pointer _p;
  s7_pointer settings, num_copies;
  _p = args;
  settings = s7_car(_p); _p = s7_cdr(_p);
  num_copies = s7_car(_p);
  if (!s7_is_integer(num_copies)) s7_wrong_type_arg_error(sc, "gtk_print_settings_set_n_copies", 2, num_copies, "gint");
  gtk_print_settings_set_n_copies((GtkPrintSettings*)s7_c_pointer_with_type(sc, settings, GtkPrintSettings__sym, __func__, 0), (gint)s7_integer(num_copies));
  return(lg_false);
}

static s7_pointer lg_gtk_print_settings_get_number_up(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_settings_get_number_up "gint gtk_print_settings_get_number_up(GtkPrintSettings* settings)"
  s7_pointer settings;
  settings = s7_car(args);
  return(s7_make_integer(sc, gtk_print_settings_get_number_up((GtkPrintSettings*)s7_c_pointer_with_type(sc, settings, GtkPrintSettings__sym, __func__, 0))));
}

static s7_pointer lg_gtk_print_settings_set_number_up(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_settings_set_number_up "void gtk_print_settings_set_number_up(GtkPrintSettings* settings, \
gint number_up)"
  s7_pointer _p;
  s7_pointer settings, number_up;
  _p = args;
  settings = s7_car(_p); _p = s7_cdr(_p);
  number_up = s7_car(_p);
  if (!s7_is_integer(number_up)) s7_wrong_type_arg_error(sc, "gtk_print_settings_set_number_up", 2, number_up, "gint");
  gtk_print_settings_set_number_up((GtkPrintSettings*)s7_c_pointer_with_type(sc, settings, GtkPrintSettings__sym, __func__, 0), (gint)s7_integer(number_up));
  return(lg_false);
}

static s7_pointer lg_gtk_print_settings_get_resolution(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_settings_get_resolution "gint gtk_print_settings_get_resolution(GtkPrintSettings* settings)"
  s7_pointer settings;
  settings = s7_car(args);
  return(s7_make_integer(sc, gtk_print_settings_get_resolution((GtkPrintSettings*)s7_c_pointer_with_type(sc, settings, GtkPrintSettings__sym, __func__, 0))));
}

static s7_pointer lg_gtk_print_settings_set_resolution(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_settings_set_resolution "void gtk_print_settings_set_resolution(GtkPrintSettings* settings, \
gint resolution)"
  s7_pointer _p;
  s7_pointer settings, resolution;
  _p = args;
  settings = s7_car(_p); _p = s7_cdr(_p);
  resolution = s7_car(_p);
  if (!s7_is_integer(resolution)) s7_wrong_type_arg_error(sc, "gtk_print_settings_set_resolution", 2, resolution, "gint");
  gtk_print_settings_set_resolution((GtkPrintSettings*)s7_c_pointer_with_type(sc, settings, GtkPrintSettings__sym, __func__, 0), (gint)s7_integer(resolution));
  return(lg_false);
}

static s7_pointer lg_gtk_print_settings_get_scale(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_settings_get_scale "gdouble gtk_print_settings_get_scale(GtkPrintSettings* settings)"
  s7_pointer settings;
  settings = s7_car(args);
  return(s7_make_real(sc, gtk_print_settings_get_scale((GtkPrintSettings*)s7_c_pointer_with_type(sc, settings, GtkPrintSettings__sym, __func__, 0))));
}

static s7_pointer lg_gtk_print_settings_set_scale(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_settings_set_scale "void gtk_print_settings_set_scale(GtkPrintSettings* settings, \
gdouble scale)"
  s7_pointer _p;
  s7_pointer settings, scale;
  _p = args;
  settings = s7_car(_p); _p = s7_cdr(_p);
  scale = s7_car(_p);
  if (!s7_is_real(scale)) s7_wrong_type_arg_error(sc, "gtk_print_settings_set_scale", 2, scale, "gdouble");
  gtk_print_settings_set_scale((GtkPrintSettings*)s7_c_pointer_with_type(sc, settings, GtkPrintSettings__sym, __func__, 0), (gdouble)s7_real(scale));
  return(lg_false);
}

static s7_pointer lg_gtk_print_settings_get_print_pages(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_settings_get_print_pages "GtkPrintPages gtk_print_settings_get_print_pages(GtkPrintSettings* settings)"
  s7_pointer settings;
  settings = s7_car(args);
  return(s7_make_integer(sc, gtk_print_settings_get_print_pages((GtkPrintSettings*)s7_c_pointer_with_type(sc, settings, GtkPrintSettings__sym, __func__, 0))));
}

static s7_pointer lg_gtk_print_settings_set_print_pages(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_settings_set_print_pages "void gtk_print_settings_set_print_pages(GtkPrintSettings* settings, \
GtkPrintPages pages)"
  s7_pointer _p;
  s7_pointer settings, pages;
  _p = args;
  settings = s7_car(_p); _p = s7_cdr(_p);
  pages = s7_car(_p);
  if (!s7_is_integer(pages)) s7_wrong_type_arg_error(sc, "gtk_print_settings_set_print_pages", 2, pages, "GtkPrintPages");
  gtk_print_settings_set_print_pages((GtkPrintSettings*)s7_c_pointer_with_type(sc, settings, GtkPrintSettings__sym, __func__, 0), (GtkPrintPages)s7_integer(pages));
  return(lg_false);
}

static s7_pointer lg_gtk_print_settings_get_page_ranges(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_settings_get_page_ranges "GtkPageRange* gtk_print_settings_get_page_ranges(GtkPrintSettings* settings, \
gint* num_ranges)"
  s7_pointer _p;
  s7_pointer settings, num_ranges;
  _p = args;
  settings = s7_car(_p); _p = s7_cdr(_p);
  num_ranges = s7_car(_p);
  return(lg_make_c_pointer_with_type(sc, GtkPageRange__sym, gtk_print_settings_get_page_ranges((GtkPrintSettings*)s7_c_pointer_with_type(sc, settings, GtkPrintSettings__sym, __func__, 0), (gint*)s7_c_pointer_with_type(sc, num_ranges, gint__sym, __func__, 0))));
}

static s7_pointer lg_gtk_print_settings_set_page_ranges(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_settings_set_page_ranges "void gtk_print_settings_set_page_ranges(GtkPrintSettings* settings, \
GtkPageRange* page_ranges, gint num_ranges)"
  s7_pointer _p;
  s7_pointer settings, page_ranges, num_ranges;
  _p = args;
  settings = s7_car(_p); _p = s7_cdr(_p);
  page_ranges = s7_car(_p); _p = s7_cdr(_p);
  num_ranges = s7_car(_p);
  if (!s7_is_integer(num_ranges)) s7_wrong_type_arg_error(sc, "gtk_print_settings_set_page_ranges", 3, num_ranges, "gint");
  gtk_print_settings_set_page_ranges((GtkPrintSettings*)s7_c_pointer_with_type(sc, settings, GtkPrintSettings__sym, __func__, 0), (GtkPageRange*)s7_c_pointer_with_type(sc, page_ranges, GtkPageRange__sym, __func__, 0), (gint)s7_integer(num_ranges));
  return(lg_false);
}

static s7_pointer lg_gtk_print_settings_get_page_set(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_settings_get_page_set "GtkPageSet gtk_print_settings_get_page_set(GtkPrintSettings* settings)"
  s7_pointer settings;
  settings = s7_car(args);
  return(s7_make_integer(sc, gtk_print_settings_get_page_set((GtkPrintSettings*)s7_c_pointer_with_type(sc, settings, GtkPrintSettings__sym, __func__, 0))));
}

static s7_pointer lg_gtk_print_settings_set_page_set(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_settings_set_page_set "void gtk_print_settings_set_page_set(GtkPrintSettings* settings, \
GtkPageSet page_set)"
  s7_pointer _p;
  s7_pointer settings, page_set;
  _p = args;
  settings = s7_car(_p); _p = s7_cdr(_p);
  page_set = s7_car(_p);
  if (!s7_is_integer(page_set)) s7_wrong_type_arg_error(sc, "gtk_print_settings_set_page_set", 2, page_set, "GtkPageSet");
  gtk_print_settings_set_page_set((GtkPrintSettings*)s7_c_pointer_with_type(sc, settings, GtkPrintSettings__sym, __func__, 0), (GtkPageSet)s7_integer(page_set));
  return(lg_false);
}

static s7_pointer lg_gtk_print_settings_get_default_source(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_settings_get_default_source "gchar* gtk_print_settings_get_default_source(GtkPrintSettings* settings)"
  s7_pointer settings;
  settings = s7_car(args);
  return(s7_make_string(sc, gtk_print_settings_get_default_source((GtkPrintSettings*)s7_c_pointer_with_type(sc, settings, GtkPrintSettings__sym, __func__, 0))));
}

static s7_pointer lg_gtk_print_settings_set_default_source(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_settings_set_default_source "void gtk_print_settings_set_default_source(GtkPrintSettings* settings, \
gchar* default_source)"
  s7_pointer _p;
  s7_pointer settings, default_source;
  _p = args;
  settings = s7_car(_p); _p = s7_cdr(_p);
  default_source = s7_car(_p);
  if (!s7_is_string(default_source)) s7_wrong_type_arg_error(sc, "gtk_print_settings_set_default_source", 2, default_source, "gchar*");
  gtk_print_settings_set_default_source((GtkPrintSettings*)s7_c_pointer_with_type(sc, settings, GtkPrintSettings__sym, __func__, 0), (gchar*)s7_string(default_source));
  return(lg_false);
}

static s7_pointer lg_gtk_print_settings_get_media_type(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_settings_get_media_type "gchar* gtk_print_settings_get_media_type(GtkPrintSettings* settings)"
  s7_pointer settings;
  settings = s7_car(args);
  return(s7_make_string(sc, gtk_print_settings_get_media_type((GtkPrintSettings*)s7_c_pointer_with_type(sc, settings, GtkPrintSettings__sym, __func__, 0))));
}

static s7_pointer lg_gtk_print_settings_set_media_type(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_settings_set_media_type "void gtk_print_settings_set_media_type(GtkPrintSettings* settings, \
gchar* media_type)"
  s7_pointer _p;
  s7_pointer settings, media_type;
  _p = args;
  settings = s7_car(_p); _p = s7_cdr(_p);
  media_type = s7_car(_p);
  if (!s7_is_string(media_type)) s7_wrong_type_arg_error(sc, "gtk_print_settings_set_media_type", 2, media_type, "gchar*");
  gtk_print_settings_set_media_type((GtkPrintSettings*)s7_c_pointer_with_type(sc, settings, GtkPrintSettings__sym, __func__, 0), (gchar*)s7_string(media_type));
  return(lg_false);
}

static s7_pointer lg_gtk_print_settings_get_dither(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_settings_get_dither "gchar* gtk_print_settings_get_dither(GtkPrintSettings* settings)"
  s7_pointer settings;
  settings = s7_car(args);
  return(s7_make_string(sc, gtk_print_settings_get_dither((GtkPrintSettings*)s7_c_pointer_with_type(sc, settings, GtkPrintSettings__sym, __func__, 0))));
}

static s7_pointer lg_gtk_print_settings_set_dither(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_settings_set_dither "void gtk_print_settings_set_dither(GtkPrintSettings* settings, \
gchar* dither)"
  s7_pointer _p;
  s7_pointer settings, dither;
  _p = args;
  settings = s7_car(_p); _p = s7_cdr(_p);
  dither = s7_car(_p);
  if (!s7_is_string(dither)) s7_wrong_type_arg_error(sc, "gtk_print_settings_set_dither", 2, dither, "gchar*");
  gtk_print_settings_set_dither((GtkPrintSettings*)s7_c_pointer_with_type(sc, settings, GtkPrintSettings__sym, __func__, 0), (gchar*)s7_string(dither));
  return(lg_false);
}

static s7_pointer lg_gtk_print_settings_get_finishings(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_settings_get_finishings "gchar* gtk_print_settings_get_finishings(GtkPrintSettings* settings)"
  s7_pointer settings;
  settings = s7_car(args);
  return(s7_make_string(sc, gtk_print_settings_get_finishings((GtkPrintSettings*)s7_c_pointer_with_type(sc, settings, GtkPrintSettings__sym, __func__, 0))));
}

static s7_pointer lg_gtk_print_settings_set_finishings(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_settings_set_finishings "void gtk_print_settings_set_finishings(GtkPrintSettings* settings, \
gchar* finishings)"
  s7_pointer _p;
  s7_pointer settings, finishings;
  _p = args;
  settings = s7_car(_p); _p = s7_cdr(_p);
  finishings = s7_car(_p);
  if (!s7_is_string(finishings)) s7_wrong_type_arg_error(sc, "gtk_print_settings_set_finishings", 2, finishings, "gchar*");
  gtk_print_settings_set_finishings((GtkPrintSettings*)s7_c_pointer_with_type(sc, settings, GtkPrintSettings__sym, __func__, 0), (gchar*)s7_string(finishings));
  return(lg_false);
}

static s7_pointer lg_gtk_print_settings_get_output_bin(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_settings_get_output_bin "gchar* gtk_print_settings_get_output_bin(GtkPrintSettings* settings)"
  s7_pointer settings;
  settings = s7_car(args);
  return(s7_make_string(sc, gtk_print_settings_get_output_bin((GtkPrintSettings*)s7_c_pointer_with_type(sc, settings, GtkPrintSettings__sym, __func__, 0))));
}

static s7_pointer lg_gtk_print_settings_set_output_bin(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_settings_set_output_bin "void gtk_print_settings_set_output_bin(GtkPrintSettings* settings, \
gchar* output_bin)"
  s7_pointer _p;
  s7_pointer settings, output_bin;
  _p = args;
  settings = s7_car(_p); _p = s7_cdr(_p);
  output_bin = s7_car(_p);
  if (!s7_is_string(output_bin)) s7_wrong_type_arg_error(sc, "gtk_print_settings_set_output_bin", 2, output_bin, "gchar*");
  gtk_print_settings_set_output_bin((GtkPrintSettings*)s7_c_pointer_with_type(sc, settings, GtkPrintSettings__sym, __func__, 0), (gchar*)s7_string(output_bin));
  return(lg_false);
}

static s7_pointer lg_pango_cairo_create_layout(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_cairo_create_layout "PangoLayout* pango_cairo_create_layout(cairo_t* cr)"
  s7_pointer cr;
  cr = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, PangoLayout__sym, pango_cairo_create_layout((cairo_t*)s7_c_pointer_with_type(sc, cr, cairo_t__sym, __func__, 0))));
}

static s7_pointer lg_pango_cairo_update_layout(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_cairo_update_layout "void pango_cairo_update_layout(cairo_t* cr, PangoLayout* layout)"
  s7_pointer _p;
  s7_pointer cr, layout;
  _p = args;
  cr = s7_car(_p); _p = s7_cdr(_p);
  layout = s7_car(_p);
  pango_cairo_update_layout((cairo_t*)s7_c_pointer_with_type(sc, cr, cairo_t__sym, __func__, 0), (PangoLayout*)s7_c_pointer_with_type(sc, layout, PangoLayout__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_pango_cairo_update_context(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_cairo_update_context "void pango_cairo_update_context(cairo_t* cr, PangoContext* context)"
  s7_pointer _p;
  s7_pointer cr, context;
  _p = args;
  cr = s7_car(_p); _p = s7_cdr(_p);
  context = s7_car(_p);
  pango_cairo_update_context((cairo_t*)s7_c_pointer_with_type(sc, cr, cairo_t__sym, __func__, 0), (PangoContext*)s7_c_pointer_with_type(sc, context, PangoContext__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_pango_cairo_context_set_font_options(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_cairo_context_set_font_options "void pango_cairo_context_set_font_options(PangoContext* context, \
cairo_font_options_t* options)"
  s7_pointer _p;
  s7_pointer context, options;
  _p = args;
  context = s7_car(_p); _p = s7_cdr(_p);
  options = s7_car(_p);
  pango_cairo_context_set_font_options((PangoContext*)s7_c_pointer_with_type(sc, context, PangoContext__sym, __func__, 0), (cairo_font_options_t*)s7_c_pointer_with_type(sc, options, cairo_font_options_t__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_pango_cairo_context_get_font_options(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_cairo_context_get_font_options "cairo_font_options_t* pango_cairo_context_get_font_options(PangoContext* context)"
  s7_pointer context;
  context = s7_car(args);
    return(lg_make_c_pointer_with_type(sc, cairo_font_options_t__sym, (cairo_font_options_t*)pango_cairo_context_get_font_options((PangoContext*)s7_c_pointer_with_type(sc, context, PangoContext__sym, __func__, 0))));
}

static s7_pointer lg_pango_cairo_context_set_resolution(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_cairo_context_set_resolution "void pango_cairo_context_set_resolution(PangoContext* context, \
gdouble dpi)"
  s7_pointer _p;
  s7_pointer context, dpi;
  _p = args;
  context = s7_car(_p); _p = s7_cdr(_p);
  dpi = s7_car(_p);
  if (!s7_is_real(dpi)) s7_wrong_type_arg_error(sc, "pango_cairo_context_set_resolution", 2, dpi, "gdouble");
  pango_cairo_context_set_resolution((PangoContext*)s7_c_pointer_with_type(sc, context, PangoContext__sym, __func__, 0), (gdouble)s7_real(dpi));
  return(lg_false);
}

static s7_pointer lg_pango_cairo_context_get_resolution(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_cairo_context_get_resolution "gdouble pango_cairo_context_get_resolution(PangoContext* context)"
  s7_pointer context;
  context = s7_car(args);
  return(s7_make_real(sc, pango_cairo_context_get_resolution((PangoContext*)s7_c_pointer_with_type(sc, context, PangoContext__sym, __func__, 0))));
}

static s7_pointer lg_pango_cairo_show_glyph_string(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_cairo_show_glyph_string "void pango_cairo_show_glyph_string(cairo_t* cr, PangoFont* font, \
PangoGlyphString* glyphs)"
  s7_pointer _p;
  s7_pointer cr, font, glyphs;
  _p = args;
  cr = s7_car(_p); _p = s7_cdr(_p);
  font = s7_car(_p); _p = s7_cdr(_p);
  glyphs = s7_car(_p);
  pango_cairo_show_glyph_string((cairo_t*)s7_c_pointer_with_type(sc, cr, cairo_t__sym, __func__, 0), (PangoFont*)s7_c_pointer_with_type(sc, font, PangoFont__sym, __func__, 0), (PangoGlyphString*)s7_c_pointer_with_type(sc, glyphs, PangoGlyphString__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_pango_cairo_show_layout_line(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_cairo_show_layout_line "void pango_cairo_show_layout_line(cairo_t* cr, PangoLayoutLine* line)"
  s7_pointer _p;
  s7_pointer cr, line;
  _p = args;
  cr = s7_car(_p); _p = s7_cdr(_p);
  line = s7_car(_p);
  pango_cairo_show_layout_line((cairo_t*)s7_c_pointer_with_type(sc, cr, cairo_t__sym, __func__, 0), (PangoLayoutLine*)s7_c_pointer_with_type(sc, line, PangoLayoutLine__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_pango_cairo_show_layout(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_cairo_show_layout "void pango_cairo_show_layout(cairo_t* cr, PangoLayout* layout)"
  s7_pointer _p;
  s7_pointer cr, layout;
  _p = args;
  cr = s7_car(_p); _p = s7_cdr(_p);
  layout = s7_car(_p);
  pango_cairo_show_layout((cairo_t*)s7_c_pointer_with_type(sc, cr, cairo_t__sym, __func__, 0), (PangoLayout*)s7_c_pointer_with_type(sc, layout, PangoLayout__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_pango_cairo_show_error_underline(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_cairo_show_error_underline "void pango_cairo_show_error_underline(cairo_t* cr, gdouble x, \
gdouble y, gdouble width, gdouble height)"
  s7_pointer _p;
  s7_pointer cr, x, y, width, height;
  _p = args;
  cr = s7_car(_p); _p = s7_cdr(_p);
  x = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(x)) s7_wrong_type_arg_error(sc, "pango_cairo_show_error_underline", 2, x, "gdouble");
  y = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(y)) s7_wrong_type_arg_error(sc, "pango_cairo_show_error_underline", 3, y, "gdouble");
  width = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(width)) s7_wrong_type_arg_error(sc, "pango_cairo_show_error_underline", 4, width, "gdouble");
  height = s7_car(_p);
  if (!s7_is_real(height)) s7_wrong_type_arg_error(sc, "pango_cairo_show_error_underline", 5, height, "gdouble");
  pango_cairo_show_error_underline((cairo_t*)s7_c_pointer_with_type(sc, cr, cairo_t__sym, __func__, 0), (gdouble)s7_real(x), (gdouble)s7_real(y), (gdouble)s7_real(width), (gdouble)s7_real(height));
  return(lg_false);
}

static s7_pointer lg_pango_cairo_glyph_string_path(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_cairo_glyph_string_path "void pango_cairo_glyph_string_path(cairo_t* cr, PangoFont* font, \
PangoGlyphString* glyphs)"
  s7_pointer _p;
  s7_pointer cr, font, glyphs;
  _p = args;
  cr = s7_car(_p); _p = s7_cdr(_p);
  font = s7_car(_p); _p = s7_cdr(_p);
  glyphs = s7_car(_p);
  pango_cairo_glyph_string_path((cairo_t*)s7_c_pointer_with_type(sc, cr, cairo_t__sym, __func__, 0), (PangoFont*)s7_c_pointer_with_type(sc, font, PangoFont__sym, __func__, 0), (PangoGlyphString*)s7_c_pointer_with_type(sc, glyphs, PangoGlyphString__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_pango_cairo_layout_line_path(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_cairo_layout_line_path "void pango_cairo_layout_line_path(cairo_t* cr, PangoLayoutLine* line)"
  s7_pointer _p;
  s7_pointer cr, line;
  _p = args;
  cr = s7_car(_p); _p = s7_cdr(_p);
  line = s7_car(_p);
  pango_cairo_layout_line_path((cairo_t*)s7_c_pointer_with_type(sc, cr, cairo_t__sym, __func__, 0), (PangoLayoutLine*)s7_c_pointer_with_type(sc, line, PangoLayoutLine__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_pango_cairo_layout_path(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_cairo_layout_path "void pango_cairo_layout_path(cairo_t* cr, PangoLayout* layout)"
  s7_pointer _p;
  s7_pointer cr, layout;
  _p = args;
  cr = s7_car(_p); _p = s7_cdr(_p);
  layout = s7_car(_p);
  pango_cairo_layout_path((cairo_t*)s7_c_pointer_with_type(sc, cr, cairo_t__sym, __func__, 0), (PangoLayout*)s7_c_pointer_with_type(sc, layout, PangoLayout__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_pango_cairo_error_underline_path(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_cairo_error_underline_path "void pango_cairo_error_underline_path(cairo_t* cr, gdouble x, \
gdouble y, gdouble width, gdouble height)"
  s7_pointer _p;
  s7_pointer cr, x, y, width, height;
  _p = args;
  cr = s7_car(_p); _p = s7_cdr(_p);
  x = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(x)) s7_wrong_type_arg_error(sc, "pango_cairo_error_underline_path", 2, x, "gdouble");
  y = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(y)) s7_wrong_type_arg_error(sc, "pango_cairo_error_underline_path", 3, y, "gdouble");
  width = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(width)) s7_wrong_type_arg_error(sc, "pango_cairo_error_underline_path", 4, width, "gdouble");
  height = s7_car(_p);
  if (!s7_is_real(height)) s7_wrong_type_arg_error(sc, "pango_cairo_error_underline_path", 5, height, "gdouble");
  pango_cairo_error_underline_path((cairo_t*)s7_c_pointer_with_type(sc, cr, cairo_t__sym, __func__, 0), (gdouble)s7_real(x), (gdouble)s7_real(y), (gdouble)s7_real(width), (gdouble)s7_real(height));
  return(lg_false);
}

static s7_pointer lg_gdk_cairo_set_source_pixbuf(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_cairo_set_source_pixbuf "void gdk_cairo_set_source_pixbuf(cairo_t* cr, GdkPixbuf* pixbuf, \
gdouble pixbuf_x, gdouble pixbuf_y)"
  s7_pointer _p;
  s7_pointer cr, pixbuf, pixbuf_x, pixbuf_y;
  _p = args;
  cr = s7_car(_p); _p = s7_cdr(_p);
  pixbuf = s7_car(_p); _p = s7_cdr(_p);
  pixbuf_x = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(pixbuf_x)) s7_wrong_type_arg_error(sc, "gdk_cairo_set_source_pixbuf", 3, pixbuf_x, "gdouble");
  pixbuf_y = s7_car(_p);
  if (!s7_is_real(pixbuf_y)) s7_wrong_type_arg_error(sc, "gdk_cairo_set_source_pixbuf", 4, pixbuf_y, "gdouble");
  gdk_cairo_set_source_pixbuf((cairo_t*)s7_c_pointer_with_type(sc, cr, cairo_t__sym, __func__, 0), (GdkPixbuf*)s7_c_pointer_with_type(sc, pixbuf, GdkPixbuf__sym, __func__, 0), (gdouble)s7_real(pixbuf_x), (gdouble)s7_real(pixbuf_y));
  return(lg_false);
}

static s7_pointer lg_gdk_cairo_rectangle(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_cairo_rectangle "void gdk_cairo_rectangle(cairo_t* cr, GdkRectangle* rectangle)"
  s7_pointer _p;
  s7_pointer cr, rectangle;
  _p = args;
  cr = s7_car(_p); _p = s7_cdr(_p);
  rectangle = s7_car(_p);
  gdk_cairo_rectangle((cairo_t*)s7_c_pointer_with_type(sc, cr, cairo_t__sym, __func__, 0), (GdkRectangle*)s7_c_pointer_with_type(sc, rectangle, GdkRectangle__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_cell_layout_get_cells(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_layout_get_cells "GList* gtk_cell_layout_get_cells(GtkCellLayout* cell_layout)"
  s7_pointer cell_layout;
  cell_layout = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GList__sym, gtk_cell_layout_get_cells((GtkCellLayout*)s7_c_pointer_with_type(sc, cell_layout, GtkCellLayout__sym, __func__, 0))));
}

static s7_pointer lg_gtk_entry_completion_set_inline_selection(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_completion_set_inline_selection "void gtk_entry_completion_set_inline_selection(GtkEntryCompletion* completion, \
gboolean inline_selection)"
  s7_pointer _p;
  s7_pointer completion, inline_selection;
  _p = args;
  completion = s7_car(_p); _p = s7_cdr(_p);
  inline_selection = s7_car(_p);
  if (!s7_is_boolean(inline_selection)) s7_wrong_type_arg_error(sc, "gtk_entry_completion_set_inline_selection", 2, inline_selection, "gboolean");
  gtk_entry_completion_set_inline_selection((GtkEntryCompletion*)s7_c_pointer_with_type(sc, completion, GtkEntryCompletion__sym, __func__, 0), (gboolean)lg_boolean(inline_selection));
  return(lg_false);
}

static s7_pointer lg_gtk_entry_completion_get_inline_selection(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_completion_get_inline_selection "gboolean gtk_entry_completion_get_inline_selection(GtkEntryCompletion* completion)"
  s7_pointer completion;
  completion = s7_car(args);
  return(s7_make_boolean(sc, gtk_entry_completion_get_inline_selection((GtkEntryCompletion*)s7_c_pointer_with_type(sc, completion, GtkEntryCompletion__sym, __func__, 0))));
}

static s7_pointer lg_gtk_entry_completion_get_completion_prefix(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_completion_get_completion_prefix "gchar* gtk_entry_completion_get_completion_prefix(GtkEntryCompletion* completion)"
  s7_pointer completion;
  completion = s7_car(args);
  return(s7_make_string(sc, gtk_entry_completion_get_completion_prefix((GtkEntryCompletion*)s7_c_pointer_with_type(sc, completion, GtkEntryCompletion__sym, __func__, 0))));
}

static s7_pointer lg_gtk_print_settings_new_from_file(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_settings_new_from_file "GtkPrintSettings* gtk_print_settings_new_from_file(gchar* file_name, \
GError** [error])"
  s7_pointer _p;
  s7_pointer file_name;
  GError* ref_error = NULL;
  _p = args;
  file_name = s7_car(_p);
  if (!s7_is_string(file_name)) s7_wrong_type_arg_error(sc, "gtk_print_settings_new_from_file", 1, file_name, "gchar*");
  {
    s7_pointer res_ult;
    res_ult = lg_make_c_pointer_with_type(sc, GtkPrintSettings__sym, gtk_print_settings_new_from_file((gchar*)s7_string(file_name), &ref_error));
      return(s7_list(sc, 2, res_ult, s7_make_c_pointer(sc, ref_error)));
   }
}

static s7_pointer lg_gtk_print_settings_to_file(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_settings_to_file "gboolean gtk_print_settings_to_file(GtkPrintSettings* settings, \
gchar* file_name, GError** [error])"
  s7_pointer _p;
  s7_pointer settings, file_name;
  GError* ref_error = NULL;
  _p = args;
  settings = s7_car(_p); _p = s7_cdr(_p);
  file_name = s7_car(_p);
  if (!s7_is_string(file_name)) s7_wrong_type_arg_error(sc, "gtk_print_settings_to_file", 2, file_name, "gchar*");
  {
    s7_pointer res_ult;
    res_ult = s7_make_boolean(sc, gtk_print_settings_to_file((GtkPrintSettings*)s7_c_pointer_with_type(sc, settings, GtkPrintSettings__sym, __func__, 0), (gchar*)s7_string(file_name), &ref_error));
      return(s7_list(sc, 2, res_ult, s7_make_c_pointer(sc, ref_error)));
   }
}

static s7_pointer lg_gtk_range_set_show_fill_level(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_range_set_show_fill_level "void gtk_range_set_show_fill_level(GtkRange* range,  gboolean, \
show_fill_level)"
  s7_pointer _p;
  s7_pointer range, show_fill_level;
  _p = args;
  range = s7_car(_p); _p = s7_cdr(_p);
  show_fill_level = s7_car(_p);
  if (!s7_is_boolean(show_fill_level)) s7_wrong_type_arg_error(sc, "gtk_range_set_show_fill_level", 2, show_fill_level, "gboolean");
  gtk_range_set_show_fill_level((GtkRange*)s7_c_pointer_with_type(sc, range, GtkRange__sym, __func__, 0), (gboolean)lg_boolean(show_fill_level));
  return(lg_false);
}

static s7_pointer lg_gtk_range_get_show_fill_level(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_range_get_show_fill_level "gboolean gtk_range_get_show_fill_level(GtkRange* range)"
  s7_pointer range;
  range = s7_car(args);
  return(s7_make_boolean(sc, gtk_range_get_show_fill_level((GtkRange*)s7_c_pointer_with_type(sc, range, GtkRange__sym, __func__, 0))));
}

static s7_pointer lg_gtk_range_set_restrict_to_fill_level(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_range_set_restrict_to_fill_level "void gtk_range_set_restrict_to_fill_level(GtkRange* range, \
 gboolean, restrict_to_fill_level)"
  s7_pointer _p;
  s7_pointer range, restrict_to_fill_level;
  _p = args;
  range = s7_car(_p); _p = s7_cdr(_p);
  restrict_to_fill_level = s7_car(_p);
  if (!s7_is_boolean(restrict_to_fill_level)) s7_wrong_type_arg_error(sc, "gtk_range_set_restrict_to_fill_level", 2, restrict_to_fill_level, "gboolean");
  gtk_range_set_restrict_to_fill_level((GtkRange*)s7_c_pointer_with_type(sc, range, GtkRange__sym, __func__, 0), (gboolean)lg_boolean(restrict_to_fill_level));
  return(lg_false);
}

static s7_pointer lg_gtk_range_get_restrict_to_fill_level(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_range_get_restrict_to_fill_level "gboolean gtk_range_get_restrict_to_fill_level(GtkRange* range)"
  s7_pointer range;
  range = s7_car(args);
  return(s7_make_boolean(sc, gtk_range_get_restrict_to_fill_level((GtkRange*)s7_c_pointer_with_type(sc, range, GtkRange__sym, __func__, 0))));
}

static s7_pointer lg_gtk_range_set_fill_level(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_range_set_fill_level "void gtk_range_set_fill_level(GtkRange* range,  gdouble, fill_level)"
  s7_pointer _p;
  s7_pointer range, fill_level;
  _p = args;
  range = s7_car(_p); _p = s7_cdr(_p);
  fill_level = s7_car(_p);
  if (!s7_is_real(fill_level)) s7_wrong_type_arg_error(sc, "gtk_range_set_fill_level", 2, fill_level, "gdouble");
  gtk_range_set_fill_level((GtkRange*)s7_c_pointer_with_type(sc, range, GtkRange__sym, __func__, 0), (gdouble)s7_real(fill_level));
  return(lg_false);
}

static s7_pointer lg_gtk_range_get_fill_level(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_range_get_fill_level "gdouble gtk_range_get_fill_level(GtkRange* range)"
  s7_pointer range;
  range = s7_car(args);
  return(s7_make_real(sc, gtk_range_get_fill_level((GtkRange*)s7_c_pointer_with_type(sc, range, GtkRange__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_view_set_show_expanders(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_set_show_expanders "void gtk_tree_view_set_show_expanders(GtkTreeView* tree_view, \
gboolean enabled)"
  s7_pointer _p;
  s7_pointer tree_view, enabled;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  enabled = s7_car(_p);
  if (!s7_is_boolean(enabled)) s7_wrong_type_arg_error(sc, "gtk_tree_view_set_show_expanders", 2, enabled, "gboolean");
  gtk_tree_view_set_show_expanders((GtkTreeView*)s7_c_pointer_with_type(sc, tree_view, GtkTreeView__sym, __func__, 0), (gboolean)lg_boolean(enabled));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_get_show_expanders(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_get_show_expanders "gboolean gtk_tree_view_get_show_expanders(GtkTreeView* tree_view)"
  s7_pointer tree_view;
  tree_view = s7_car(args);
  return(s7_make_boolean(sc, gtk_tree_view_get_show_expanders((GtkTreeView*)s7_c_pointer_with_type(sc, tree_view, GtkTreeView__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_view_set_level_indentation(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_set_level_indentation "void gtk_tree_view_set_level_indentation(GtkTreeView* tree_view, \
gint indentation)"
  s7_pointer _p;
  s7_pointer tree_view, indentation;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  indentation = s7_car(_p);
  if (!s7_is_integer(indentation)) s7_wrong_type_arg_error(sc, "gtk_tree_view_set_level_indentation", 2, indentation, "gint");
  gtk_tree_view_set_level_indentation((GtkTreeView*)s7_c_pointer_with_type(sc, tree_view, GtkTreeView__sym, __func__, 0), (gint)s7_integer(indentation));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_get_level_indentation(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_get_level_indentation "gint gtk_tree_view_get_level_indentation(GtkTreeView* tree_view)"
  s7_pointer tree_view;
  tree_view = s7_car(args);
  return(s7_make_integer(sc, gtk_tree_view_get_level_indentation((GtkTreeView*)s7_c_pointer_with_type(sc, tree_view, GtkTreeView__sym, __func__, 0))));
}

static s7_pointer lg_gtk_widget_keynav_failed(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_keynav_failed "gboolean gtk_widget_keynav_failed(GtkWidget* widget, GtkDirectionType direction)"
  s7_pointer _p;
  s7_pointer widget, direction;
  _p = args;
  widget = s7_car(_p); _p = s7_cdr(_p);
  direction = s7_car(_p);
  if (!s7_is_integer(direction)) s7_wrong_type_arg_error(sc, "gtk_widget_keynav_failed", 2, direction, "GtkDirectionType");
  return(s7_make_boolean(sc, gtk_widget_keynav_failed((GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0), (GtkDirectionType)s7_integer(direction))));
}

static s7_pointer lg_gtk_widget_error_bell(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_error_bell "void gtk_widget_error_bell(GtkWidget* widget)"
  s7_pointer widget;
  widget = s7_car(args);
  gtk_widget_error_bell((GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_widget_trigger_tooltip_query(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_trigger_tooltip_query "void gtk_widget_trigger_tooltip_query(GtkWidget* widget)"
  s7_pointer widget;
  widget = s7_car(args);
  gtk_widget_trigger_tooltip_query((GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_window_set_startup_id(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_window_set_startup_id "void gtk_window_set_startup_id(GtkWindow* window, gchar* startup_id)"
  s7_pointer _p;
  s7_pointer window, startup_id;
  _p = args;
  window = s7_car(_p); _p = s7_cdr(_p);
  startup_id = s7_car(_p);
  if (!s7_is_string(startup_id)) s7_wrong_type_arg_error(sc, "gtk_window_set_startup_id", 2, startup_id, "gchar*");
  gtk_window_set_startup_id((GtkWindow*)s7_c_pointer_with_type(sc, window, GtkWindow__sym, __func__, 0), (gchar*)s7_string(startup_id));
  return(lg_false);
}

static s7_pointer lg_gtk_text_buffer_add_mark(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_add_mark "void gtk_text_buffer_add_mark(GtkTextBuffer* buffer, GtkTextMark* mark, \
GtkTextIter* where)"
  s7_pointer _p;
  s7_pointer buffer, mark, where;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  mark = s7_car(_p); _p = s7_cdr(_p);
  where = s7_car(_p);
  gtk_text_buffer_add_mark((GtkTextBuffer*)s7_c_pointer_with_type(sc, buffer, GtkTextBuffer__sym, __func__, 0), (GtkTextMark*)s7_c_pointer_with_type(sc, mark, GtkTextMark__sym, __func__, 0), (GtkTextIter*)s7_c_pointer_with_type(sc, where, GtkTextIter__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_text_mark_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_mark_new "GtkTextMark* gtk_text_mark_new(gchar* name, gboolean left_gravity)"
  s7_pointer _p;
  s7_pointer name, left_gravity;
  _p = args;
  name = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(name)) s7_wrong_type_arg_error(sc, "gtk_text_mark_new", 1, name, "gchar*");
  left_gravity = s7_car(_p);
  if (!s7_is_boolean(left_gravity)) s7_wrong_type_arg_error(sc, "gtk_text_mark_new", 2, left_gravity, "gboolean");
  return(lg_make_c_pointer_with_type(sc, GtkTextMark__sym, gtk_text_mark_new((gchar*)s7_string(name), (gboolean)lg_boolean(left_gravity))));
}

static s7_pointer lg_gtk_tree_view_column_get_tree_view(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_get_tree_view "GtkWidget* gtk_tree_view_column_get_tree_view(GtkTreeViewColumn* tree_column)"
  s7_pointer tree_column;
  tree_column = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_tree_view_column_get_tree_view((GtkTreeViewColumn*)s7_c_pointer_with_type(sc, tree_column, GtkTreeViewColumn__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tooltip_set_text(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tooltip_set_text "void gtk_tooltip_set_text(GtkTooltip* tooltip, gchar* text)"
  s7_pointer _p;
  s7_pointer tooltip, text;
  _p = args;
  tooltip = s7_car(_p); _p = s7_cdr(_p);
  text = s7_car(_p);
  if (!s7_is_string(text)) s7_wrong_type_arg_error(sc, "gtk_tooltip_set_text", 2, text, "gchar*");
  gtk_tooltip_set_text((GtkTooltip*)s7_c_pointer_with_type(sc, tooltip, GtkTooltip__sym, __func__, 0), (const gchar*)s7_string(text));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_convert_widget_to_tree_coords(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_convert_widget_to_tree_coords "void gtk_tree_view_convert_widget_to_tree_coords(GtkTreeView* tree_view, \
gint wx, gint wy, gint* [tx], gint* [ty])"
  s7_pointer _p;
  s7_pointer tree_view, wx, wy;
  gint ref_tx;
  gint ref_ty;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  wx = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(wx)) s7_wrong_type_arg_error(sc, "gtk_tree_view_convert_widget_to_tree_coords", 2, wx, "gint");
  wy = s7_car(_p);
  if (!s7_is_integer(wy)) s7_wrong_type_arg_error(sc, "gtk_tree_view_convert_widget_to_tree_coords", 3, wy, "gint");
  gtk_tree_view_convert_widget_to_tree_coords((GtkTreeView*)s7_c_pointer_with_type(sc, tree_view, GtkTreeView__sym, __func__, 0), (gint)s7_integer(wx), (gint)s7_integer(wy), &ref_tx, &ref_ty);
    return(s7_list(sc, 2, s7_make_integer(sc, ref_tx), s7_make_integer(sc, ref_ty)));
}

static s7_pointer lg_gtk_tree_view_convert_tree_to_widget_coords(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_convert_tree_to_widget_coords "void gtk_tree_view_convert_tree_to_widget_coords(GtkTreeView* tree_view, \
gint tx, gint ty, gint* [wx], gint* [wy])"
  s7_pointer _p;
  s7_pointer tree_view, tx, ty;
  gint ref_wx;
  gint ref_wy;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  tx = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(tx)) s7_wrong_type_arg_error(sc, "gtk_tree_view_convert_tree_to_widget_coords", 2, tx, "gint");
  ty = s7_car(_p);
  if (!s7_is_integer(ty)) s7_wrong_type_arg_error(sc, "gtk_tree_view_convert_tree_to_widget_coords", 3, ty, "gint");
  gtk_tree_view_convert_tree_to_widget_coords((GtkTreeView*)s7_c_pointer_with_type(sc, tree_view, GtkTreeView__sym, __func__, 0), (gint)s7_integer(tx), (gint)s7_integer(ty), &ref_wx, &ref_wy);
    return(s7_list(sc, 2, s7_make_integer(sc, ref_wx), s7_make_integer(sc, ref_wy)));
}

static s7_pointer lg_gtk_tree_view_convert_widget_to_bin_window_coords(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_convert_widget_to_bin_window_coords "void gtk_tree_view_convert_widget_to_bin_window_coords(GtkTreeView* tree_view, \
gint wx, gint wy, gint* [bx], gint* [by])"
  s7_pointer _p;
  s7_pointer tree_view, wx, wy;
  gint ref_bx;
  gint ref_by;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  wx = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(wx)) s7_wrong_type_arg_error(sc, "gtk_tree_view_convert_widget_to_bin_window_coords", 2, wx, "gint");
  wy = s7_car(_p);
  if (!s7_is_integer(wy)) s7_wrong_type_arg_error(sc, "gtk_tree_view_convert_widget_to_bin_window_coords", 3, wy, "gint");
  gtk_tree_view_convert_widget_to_bin_window_coords((GtkTreeView*)s7_c_pointer_with_type(sc, tree_view, GtkTreeView__sym, __func__, 0), (gint)s7_integer(wx), (gint)s7_integer(wy), &ref_bx, &ref_by);
    return(s7_list(sc, 2, s7_make_integer(sc, ref_bx), s7_make_integer(sc, ref_by)));
}

static s7_pointer lg_gtk_tree_view_convert_bin_window_to_widget_coords(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_convert_bin_window_to_widget_coords "void gtk_tree_view_convert_bin_window_to_widget_coords(GtkTreeView* tree_view, \
gint bx, gint by, gint* [wx], gint* [wy])"
  s7_pointer _p;
  s7_pointer tree_view, bx, by;
  gint ref_wx;
  gint ref_wy;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  bx = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(bx)) s7_wrong_type_arg_error(sc, "gtk_tree_view_convert_bin_window_to_widget_coords", 2, bx, "gint");
  by = s7_car(_p);
  if (!s7_is_integer(by)) s7_wrong_type_arg_error(sc, "gtk_tree_view_convert_bin_window_to_widget_coords", 3, by, "gint");
  gtk_tree_view_convert_bin_window_to_widget_coords((GtkTreeView*)s7_c_pointer_with_type(sc, tree_view, GtkTreeView__sym, __func__, 0), (gint)s7_integer(bx), (gint)s7_integer(by), &ref_wx, &ref_wy);
    return(s7_list(sc, 2, s7_make_integer(sc, ref_wx), s7_make_integer(sc, ref_wy)));
}

static s7_pointer lg_gtk_tree_view_convert_tree_to_bin_window_coords(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_convert_tree_to_bin_window_coords "void gtk_tree_view_convert_tree_to_bin_window_coords(GtkTreeView* tree_view, \
gint tx, gint ty, gint* [bx], gint* [by])"
  s7_pointer _p;
  s7_pointer tree_view, tx, ty;
  gint ref_bx;
  gint ref_by;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  tx = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(tx)) s7_wrong_type_arg_error(sc, "gtk_tree_view_convert_tree_to_bin_window_coords", 2, tx, "gint");
  ty = s7_car(_p);
  if (!s7_is_integer(ty)) s7_wrong_type_arg_error(sc, "gtk_tree_view_convert_tree_to_bin_window_coords", 3, ty, "gint");
  gtk_tree_view_convert_tree_to_bin_window_coords((GtkTreeView*)s7_c_pointer_with_type(sc, tree_view, GtkTreeView__sym, __func__, 0), (gint)s7_integer(tx), (gint)s7_integer(ty), &ref_bx, &ref_by);
    return(s7_list(sc, 2, s7_make_integer(sc, ref_bx), s7_make_integer(sc, ref_by)));
}

static s7_pointer lg_gtk_tree_view_convert_bin_window_to_tree_coords(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_convert_bin_window_to_tree_coords "void gtk_tree_view_convert_bin_window_to_tree_coords(GtkTreeView* tree_view, \
gint bx, gint by, gint* [tx], gint* [ty])"
  s7_pointer _p;
  s7_pointer tree_view, bx, by;
  gint ref_tx;
  gint ref_ty;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  bx = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(bx)) s7_wrong_type_arg_error(sc, "gtk_tree_view_convert_bin_window_to_tree_coords", 2, bx, "gint");
  by = s7_car(_p);
  if (!s7_is_integer(by)) s7_wrong_type_arg_error(sc, "gtk_tree_view_convert_bin_window_to_tree_coords", 3, by, "gint");
  gtk_tree_view_convert_bin_window_to_tree_coords((GtkTreeView*)s7_c_pointer_with_type(sc, tree_view, GtkTreeView__sym, __func__, 0), (gint)s7_integer(bx), (gint)s7_integer(by), &ref_tx, &ref_ty);
    return(s7_list(sc, 2, s7_make_integer(sc, ref_tx), s7_make_integer(sc, ref_ty)));
}

static s7_pointer lg_gtk_widget_set_tooltip_text(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_set_tooltip_text "void gtk_widget_set_tooltip_text(GtkWidget* widget, gchar* text)"
  s7_pointer _p;
  s7_pointer widget, text;
  _p = args;
  widget = s7_car(_p); _p = s7_cdr(_p);
  text = s7_car(_p);
  if (!s7_is_string(text)) s7_wrong_type_arg_error(sc, "gtk_widget_set_tooltip_text", 2, text, "gchar*");
  gtk_widget_set_tooltip_text((GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0), (const gchar*)s7_string(text));
  return(lg_false);
}

static s7_pointer lg_gtk_widget_get_tooltip_text(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_get_tooltip_text "char* gtk_widget_get_tooltip_text(GtkWidget* widget)"
  s7_pointer widget;
  widget = s7_car(args);
  return(s7_make_string(sc, gtk_widget_get_tooltip_text((GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0))));
}

static s7_pointer lg_gtk_widget_set_tooltip_markup(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_set_tooltip_markup "void gtk_widget_set_tooltip_markup(GtkWidget* widget, char* markup)"
  s7_pointer _p;
  s7_pointer widget, markup;
  _p = args;
  widget = s7_car(_p); _p = s7_cdr(_p);
  markup = s7_car(_p);
  if (!s7_is_string(markup)) s7_wrong_type_arg_error(sc, "gtk_widget_set_tooltip_markup", 2, markup, "char*");
  gtk_widget_set_tooltip_markup((GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0), (const char*)(char*)s7_string(markup));
  return(lg_false);
}

static s7_pointer lg_gtk_widget_get_tooltip_markup(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_get_tooltip_markup "char* gtk_widget_get_tooltip_markup(GtkWidget* widget)"
  s7_pointer widget;
  widget = s7_car(args);
  return(s7_make_string(sc, gtk_widget_get_tooltip_markup((GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_view_is_rubber_banding_active(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_is_rubber_banding_active "gboolean gtk_tree_view_is_rubber_banding_active(GtkTreeView* tree_view)"
  s7_pointer tree_view;
  tree_view = s7_car(args);
  return(s7_make_boolean(sc, gtk_tree_view_is_rubber_banding_active((GtkTreeView*)s7_c_pointer_with_type(sc, tree_view, GtkTreeView__sym, __func__, 0))));
}

static s7_pointer lg_gtk_icon_view_set_tooltip_item(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_set_tooltip_item "void gtk_icon_view_set_tooltip_item(GtkIconView* icon_view, \
GtkTooltip* tooltip, GtkTreePath* path)"
  s7_pointer _p;
  s7_pointer icon_view, tooltip, path;
  _p = args;
  icon_view = s7_car(_p); _p = s7_cdr(_p);
  tooltip = s7_car(_p); _p = s7_cdr(_p);
  path = s7_car(_p);
  gtk_icon_view_set_tooltip_item((GtkIconView*)s7_c_pointer_with_type(sc, icon_view, GtkIconView__sym, __func__, 0), (GtkTooltip*)s7_c_pointer_with_type(sc, tooltip, GtkTooltip__sym, __func__, 0), (GtkTreePath*)s7_c_pointer_with_type(sc, path, GtkTreePath__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_icon_view_set_tooltip_cell(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_set_tooltip_cell "void gtk_icon_view_set_tooltip_cell(GtkIconView* icon_view, \
GtkTooltip* tooltip, GtkTreePath* path, GtkCellRenderer* cell)"
  s7_pointer _p;
  s7_pointer icon_view, tooltip, path, cell;
  _p = args;
  icon_view = s7_car(_p); _p = s7_cdr(_p);
  tooltip = s7_car(_p); _p = s7_cdr(_p);
  path = s7_car(_p); _p = s7_cdr(_p);
  cell = s7_car(_p);
  gtk_icon_view_set_tooltip_cell((GtkIconView*)s7_c_pointer_with_type(sc, icon_view, GtkIconView__sym, __func__, 0), (GtkTooltip*)s7_c_pointer_with_type(sc, tooltip, GtkTooltip__sym, __func__, 0), (GtkTreePath*)s7_c_pointer_with_type(sc, path, GtkTreePath__sym, __func__, 0), (GtkCellRenderer*)s7_c_pointer_with_type(sc, cell, GtkCellRenderer__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_icon_view_get_tooltip_context(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_get_tooltip_context "gboolean gtk_icon_view_get_tooltip_context(GtkIconView* icon_view, \
gint* [x], gint* [y], gboolean keyboard_tip, GtkTreeModel** [model], GtkTreePath** [path], GtkTreeIter* iter)"
  s7_pointer _p;
  s7_pointer icon_view, keyboard_tip, iter;
  gint ref_x;
  gint ref_y;
  GtkTreeModel* ref_model = NULL;
  GtkTreePath* ref_path = NULL;
  _p = args;
  icon_view = s7_car(_p); _p = s7_cdr(_p);
  keyboard_tip = s7_car(_p);
  if (!s7_is_boolean(keyboard_tip)) s7_wrong_type_arg_error(sc, "gtk_icon_view_get_tooltip_context", 4, keyboard_tip, "gboolean");
  iter = s7_car(_p);
  {
    s7_pointer res_ult;
    res_ult = s7_make_boolean(sc, gtk_icon_view_get_tooltip_context((GtkIconView*)s7_c_pointer_with_type(sc, icon_view, GtkIconView__sym, __func__, 0), &ref_x, &ref_y, (gboolean)lg_boolean(keyboard_tip), &ref_model, &ref_path, (GtkTreeIter*)s7_c_pointer_with_type(sc, iter, GtkTreeIter__sym, __func__, 0)));
      return(s7_list(sc, 5, res_ult, s7_make_integer(sc, ref_x), s7_make_integer(sc, ref_y), s7_make_c_pointer(sc, ref_model), s7_make_c_pointer(sc, ref_path)));
   }
}

static s7_pointer lg_gtk_icon_view_set_tooltip_column(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_set_tooltip_column "void gtk_icon_view_set_tooltip_column(GtkIconView* icon_view, \
gint column)"
  s7_pointer _p;
  s7_pointer icon_view, column;
  _p = args;
  icon_view = s7_car(_p); _p = s7_cdr(_p);
  column = s7_car(_p);
  if (!s7_is_integer(column)) s7_wrong_type_arg_error(sc, "gtk_icon_view_set_tooltip_column", 2, column, "gint");
  gtk_icon_view_set_tooltip_column((GtkIconView*)s7_c_pointer_with_type(sc, icon_view, GtkIconView__sym, __func__, 0), (gint)s7_integer(column));
  return(lg_false);
}

static s7_pointer lg_gtk_icon_view_get_tooltip_column(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_get_tooltip_column "gint gtk_icon_view_get_tooltip_column(GtkIconView* icon_view, \
)"
  s7_pointer icon_view ;
  icon_view  = s7_car(args);
  return(s7_make_integer(sc, gtk_icon_view_get_tooltip_column((GtkIconView*)s7_c_pointer_with_type(sc, icon_view , GtkIconView__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tooltip_set_tip_area(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tooltip_set_tip_area "void gtk_tooltip_set_tip_area(GtkTooltip* tooltip, GdkRectangle* rect)"
  s7_pointer _p;
  s7_pointer tooltip, rect;
  _p = args;
  tooltip = s7_car(_p); _p = s7_cdr(_p);
  rect = s7_car(_p);
  gtk_tooltip_set_tip_area((GtkTooltip*)s7_c_pointer_with_type(sc, tooltip, GtkTooltip__sym, __func__, 0), (GdkRectangle*)s7_c_pointer_with_type(sc, rect, GdkRectangle__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_set_tooltip_row(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_set_tooltip_row "void gtk_tree_view_set_tooltip_row(GtkTreeView* tree_view, \
GtkTooltip* tooltip, GtkTreePath* path)"
  s7_pointer _p;
  s7_pointer tree_view, tooltip, path;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  tooltip = s7_car(_p); _p = s7_cdr(_p);
  path = s7_car(_p);
  gtk_tree_view_set_tooltip_row((GtkTreeView*)s7_c_pointer_with_type(sc, tree_view, GtkTreeView__sym, __func__, 0), (GtkTooltip*)s7_c_pointer_with_type(sc, tooltip, GtkTooltip__sym, __func__, 0), (GtkTreePath*)s7_c_pointer_with_type(sc, path, GtkTreePath__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_set_tooltip_cell(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_set_tooltip_cell "void gtk_tree_view_set_tooltip_cell(GtkTreeView* tree_view, \
GtkTooltip* tooltip, GtkTreePath* path, GtkTreeViewColumn* column, GtkCellRenderer* cell)"
  s7_pointer _p;
  s7_pointer tree_view, tooltip, path, column, cell;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  tooltip = s7_car(_p); _p = s7_cdr(_p);
  path = s7_car(_p); _p = s7_cdr(_p);
  column = s7_car(_p); _p = s7_cdr(_p);
  cell = s7_car(_p);
  gtk_tree_view_set_tooltip_cell((GtkTreeView*)s7_c_pointer_with_type(sc, tree_view, GtkTreeView__sym, __func__, 0), (GtkTooltip*)s7_c_pointer_with_type(sc, tooltip, GtkTooltip__sym, __func__, 0), (GtkTreePath*)s7_c_pointer_with_type(sc, path, GtkTreePath__sym, __func__, 0), (GtkTreeViewColumn*)s7_c_pointer_with_type(sc, column, GtkTreeViewColumn__sym, __func__, 0), (GtkCellRenderer*)s7_c_pointer_with_type(sc, cell, GtkCellRenderer__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_get_tooltip_context(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_get_tooltip_context "gboolean gtk_tree_view_get_tooltip_context(GtkTreeView* tree_view, \
gint* [x], gint* [y], gboolean keyboard_tip, GtkTreeModel** [model], GtkTreePath** [path], GtkTreeIter* iter)"
  s7_pointer _p;
  s7_pointer tree_view, keyboard_tip, iter;
  gint ref_x;
  gint ref_y;
  GtkTreeModel* ref_model = NULL;
  GtkTreePath* ref_path = NULL;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  keyboard_tip = s7_car(_p);
  if (!s7_is_boolean(keyboard_tip)) s7_wrong_type_arg_error(sc, "gtk_tree_view_get_tooltip_context", 4, keyboard_tip, "gboolean");
  iter = s7_car(_p);
  {
    s7_pointer res_ult;
    res_ult = s7_make_boolean(sc, gtk_tree_view_get_tooltip_context((GtkTreeView*)s7_c_pointer_with_type(sc, tree_view, GtkTreeView__sym, __func__, 0), &ref_x, &ref_y, (gboolean)lg_boolean(keyboard_tip), &ref_model, &ref_path, (GtkTreeIter*)s7_c_pointer_with_type(sc, iter, GtkTreeIter__sym, __func__, 0)));
      return(s7_list(sc, 5, res_ult, s7_make_integer(sc, ref_x), s7_make_integer(sc, ref_y), s7_make_c_pointer(sc, ref_model), s7_make_c_pointer(sc, ref_path)));
   }
}

static s7_pointer lg_gtk_tree_view_set_tooltip_column(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_set_tooltip_column "void gtk_tree_view_set_tooltip_column(GtkTreeView* tree_view, \
gint column)"
  s7_pointer _p;
  s7_pointer tree_view, column;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  column = s7_car(_p);
  if (!s7_is_integer(column)) s7_wrong_type_arg_error(sc, "gtk_tree_view_set_tooltip_column", 2, column, "gint");
  gtk_tree_view_set_tooltip_column((GtkTreeView*)s7_c_pointer_with_type(sc, tree_view, GtkTreeView__sym, __func__, 0), (gint)s7_integer(column));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_get_tooltip_column(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_get_tooltip_column "gint gtk_tree_view_get_tooltip_column(GtkTreeView* tree_view, \
)"
  s7_pointer tree_view ;
  tree_view  = s7_car(args);
  return(s7_make_integer(sc, gtk_tree_view_get_tooltip_column((GtkTreeView*)s7_c_pointer_with_type(sc, tree_view , GtkTreeView__sym, __func__, 0))));
}

static s7_pointer lg_gtk_widget_set_has_tooltip(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_set_has_tooltip "void gtk_widget_set_has_tooltip(GtkWidget* widget, gboolean has_tooltip)"
  s7_pointer _p;
  s7_pointer widget, has_tooltip;
  _p = args;
  widget = s7_car(_p); _p = s7_cdr(_p);
  has_tooltip = s7_car(_p);
  if (!s7_is_boolean(has_tooltip)) s7_wrong_type_arg_error(sc, "gtk_widget_set_has_tooltip", 2, has_tooltip, "gboolean");
  gtk_widget_set_has_tooltip((GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0), (gboolean)lg_boolean(has_tooltip));
  return(lg_false);
}

static s7_pointer lg_gtk_widget_get_has_tooltip(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_get_has_tooltip "gboolean gtk_widget_get_has_tooltip(GtkWidget* widget)"
  s7_pointer widget;
  widget = s7_car(args);
  return(s7_make_boolean(sc, gtk_widget_get_has_tooltip((GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0))));
}

static s7_pointer lg_gtk_dialog_get_content_area(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_dialog_get_content_area "GtkWidget* gtk_dialog_get_content_area(GtkDialog* dialog)"
  s7_pointer dialog;
  dialog = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_dialog_get_content_area((GtkDialog*)s7_c_pointer_with_type(sc, dialog, GtkDialog__sym, __func__, 0))));
}

static s7_pointer lg_gtk_entry_set_overwrite_mode(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_set_overwrite_mode "void gtk_entry_set_overwrite_mode(GtkEntry* entry, gboolean overwrite)"
  s7_pointer _p;
  s7_pointer entry, overwrite;
  _p = args;
  entry = s7_car(_p); _p = s7_cdr(_p);
  overwrite = s7_car(_p);
  if (!s7_is_boolean(overwrite)) s7_wrong_type_arg_error(sc, "gtk_entry_set_overwrite_mode", 2, overwrite, "gboolean");
  gtk_entry_set_overwrite_mode((GtkEntry*)s7_c_pointer_with_type(sc, entry, GtkEntry__sym, __func__, 0), (gboolean)lg_boolean(overwrite));
  return(lg_false);
}

static s7_pointer lg_gtk_entry_get_overwrite_mode(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_get_overwrite_mode "gboolean gtk_entry_get_overwrite_mode(GtkEntry* entry)"
  s7_pointer entry;
  entry = s7_car(args);
  return(s7_make_boolean(sc, gtk_entry_get_overwrite_mode((GtkEntry*)s7_c_pointer_with_type(sc, entry, GtkEntry__sym, __func__, 0))));
}

static s7_pointer lg_gtk_entry_get_text_length(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_get_text_length "guint16 gtk_entry_get_text_length(GtkEntry* entry)"
  s7_pointer entry;
  entry = s7_car(args);
  return(s7_make_integer(sc, gtk_entry_get_text_length((GtkEntry*)s7_c_pointer_with_type(sc, entry, GtkEntry__sym, __func__, 0))));
}

static s7_pointer lg_gtk_scale_button_get_plus_button(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_scale_button_get_plus_button "GtkWidget* gtk_scale_button_get_plus_button(GtkScaleButton* button)"
  s7_pointer button;
  button = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_scale_button_get_plus_button((GtkScaleButton*)s7_c_pointer_with_type(sc, button, GtkScaleButton__sym, __func__, 0))));
}

static s7_pointer lg_gtk_scale_button_get_minus_button(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_scale_button_get_minus_button "GtkWidget* gtk_scale_button_get_minus_button(GtkScaleButton* button)"
  s7_pointer button;
  button = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_scale_button_get_minus_button((GtkScaleButton*)s7_c_pointer_with_type(sc, button, GtkScaleButton__sym, __func__, 0))));
}

static s7_pointer lg_gtk_scale_button_get_popup(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_scale_button_get_popup "GtkWidget* gtk_scale_button_get_popup(GtkScaleButton* button)"
  s7_pointer button;
  button = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_scale_button_get_popup((GtkScaleButton*)s7_c_pointer_with_type(sc, button, GtkScaleButton__sym, __func__, 0))));
}

static s7_pointer lg_gtk_adjustment_get_lower(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_adjustment_get_lower "gdouble gtk_adjustment_get_lower(GtkAdjustment* adjustment)"
  s7_pointer adjustment;
  adjustment = s7_car(args);
  return(s7_make_real(sc, gtk_adjustment_get_lower((GtkAdjustment*)s7_c_pointer_with_type(sc, adjustment, GtkAdjustment__sym, __func__, 0))));
}

static s7_pointer lg_gtk_adjustment_set_lower(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_adjustment_set_lower "void gtk_adjustment_set_lower(GtkAdjustment* adjustment, gdouble lower)"
  s7_pointer _p;
  s7_pointer adjustment, lower;
  _p = args;
  adjustment = s7_car(_p); _p = s7_cdr(_p);
  lower = s7_car(_p);
  if (!s7_is_real(lower)) s7_wrong_type_arg_error(sc, "gtk_adjustment_set_lower", 2, lower, "gdouble");
  gtk_adjustment_set_lower((GtkAdjustment*)s7_c_pointer_with_type(sc, adjustment, GtkAdjustment__sym, __func__, 0), (gdouble)s7_real(lower));
  return(lg_false);
}

static s7_pointer lg_gtk_adjustment_get_upper(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_adjustment_get_upper "gdouble gtk_adjustment_get_upper(GtkAdjustment* adjustment)"
  s7_pointer adjustment;
  adjustment = s7_car(args);
  return(s7_make_real(sc, gtk_adjustment_get_upper((GtkAdjustment*)s7_c_pointer_with_type(sc, adjustment, GtkAdjustment__sym, __func__, 0))));
}

static s7_pointer lg_gtk_adjustment_set_upper(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_adjustment_set_upper "void gtk_adjustment_set_upper(GtkAdjustment* adjustment, gdouble upper)"
  s7_pointer _p;
  s7_pointer adjustment, upper;
  _p = args;
  adjustment = s7_car(_p); _p = s7_cdr(_p);
  upper = s7_car(_p);
  if (!s7_is_real(upper)) s7_wrong_type_arg_error(sc, "gtk_adjustment_set_upper", 2, upper, "gdouble");
  gtk_adjustment_set_upper((GtkAdjustment*)s7_c_pointer_with_type(sc, adjustment, GtkAdjustment__sym, __func__, 0), (gdouble)s7_real(upper));
  return(lg_false);
}

static s7_pointer lg_gtk_adjustment_get_step_increment(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_adjustment_get_step_increment "gdouble gtk_adjustment_get_step_increment(GtkAdjustment* adjustment)"
  s7_pointer adjustment;
  adjustment = s7_car(args);
  return(s7_make_real(sc, gtk_adjustment_get_step_increment((GtkAdjustment*)s7_c_pointer_with_type(sc, adjustment, GtkAdjustment__sym, __func__, 0))));
}

static s7_pointer lg_gtk_adjustment_set_step_increment(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_adjustment_set_step_increment "void gtk_adjustment_set_step_increment(GtkAdjustment* adjustment, \
gdouble step_increment)"
  s7_pointer _p;
  s7_pointer adjustment, step_increment;
  _p = args;
  adjustment = s7_car(_p); _p = s7_cdr(_p);
  step_increment = s7_car(_p);
  if (!s7_is_real(step_increment)) s7_wrong_type_arg_error(sc, "gtk_adjustment_set_step_increment", 2, step_increment, "gdouble");
  gtk_adjustment_set_step_increment((GtkAdjustment*)s7_c_pointer_with_type(sc, adjustment, GtkAdjustment__sym, __func__, 0), (gdouble)s7_real(step_increment));
  return(lg_false);
}

static s7_pointer lg_gtk_adjustment_get_page_increment(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_adjustment_get_page_increment "gdouble gtk_adjustment_get_page_increment(GtkAdjustment* adjustment)"
  s7_pointer adjustment;
  adjustment = s7_car(args);
  return(s7_make_real(sc, gtk_adjustment_get_page_increment((GtkAdjustment*)s7_c_pointer_with_type(sc, adjustment, GtkAdjustment__sym, __func__, 0))));
}

static s7_pointer lg_gtk_adjustment_set_page_increment(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_adjustment_set_page_increment "void gtk_adjustment_set_page_increment(GtkAdjustment* adjustment, \
gdouble page_increment)"
  s7_pointer _p;
  s7_pointer adjustment, page_increment;
  _p = args;
  adjustment = s7_car(_p); _p = s7_cdr(_p);
  page_increment = s7_car(_p);
  if (!s7_is_real(page_increment)) s7_wrong_type_arg_error(sc, "gtk_adjustment_set_page_increment", 2, page_increment, "gdouble");
  gtk_adjustment_set_page_increment((GtkAdjustment*)s7_c_pointer_with_type(sc, adjustment, GtkAdjustment__sym, __func__, 0), (gdouble)s7_real(page_increment));
  return(lg_false);
}

static s7_pointer lg_gtk_adjustment_get_page_size(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_adjustment_get_page_size "gdouble gtk_adjustment_get_page_size(GtkAdjustment* adjustment)"
  s7_pointer adjustment;
  adjustment = s7_car(args);
  return(s7_make_real(sc, gtk_adjustment_get_page_size((GtkAdjustment*)s7_c_pointer_with_type(sc, adjustment, GtkAdjustment__sym, __func__, 0))));
}

static s7_pointer lg_gtk_adjustment_set_page_size(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_adjustment_set_page_size "void gtk_adjustment_set_page_size(GtkAdjustment* adjustment, \
gdouble page_size)"
  s7_pointer _p;
  s7_pointer adjustment, page_size;
  _p = args;
  adjustment = s7_car(_p); _p = s7_cdr(_p);
  page_size = s7_car(_p);
  if (!s7_is_real(page_size)) s7_wrong_type_arg_error(sc, "gtk_adjustment_set_page_size", 2, page_size, "gdouble");
  gtk_adjustment_set_page_size((GtkAdjustment*)s7_c_pointer_with_type(sc, adjustment, GtkAdjustment__sym, __func__, 0), (gdouble)s7_real(page_size));
  return(lg_false);
}

static s7_pointer lg_gtk_adjustment_configure(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_adjustment_configure "void gtk_adjustment_configure(GtkAdjustment* adjustment, gdouble value, \
gdouble lower, gdouble upper, gdouble step_increment, gdouble page_increment, gdouble page_size)"
  s7_pointer _p;
  s7_pointer adjustment, value, lower, upper, step_increment, page_increment, page_size;
  _p = args;
  adjustment = s7_car(_p); _p = s7_cdr(_p);
  value = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(value)) s7_wrong_type_arg_error(sc, "gtk_adjustment_configure", 2, value, "gdouble");
  lower = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(lower)) s7_wrong_type_arg_error(sc, "gtk_adjustment_configure", 3, lower, "gdouble");
  upper = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(upper)) s7_wrong_type_arg_error(sc, "gtk_adjustment_configure", 4, upper, "gdouble");
  step_increment = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(step_increment)) s7_wrong_type_arg_error(sc, "gtk_adjustment_configure", 5, step_increment, "gdouble");
  page_increment = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(page_increment)) s7_wrong_type_arg_error(sc, "gtk_adjustment_configure", 6, page_increment, "gdouble");
  page_size = s7_car(_p);
  if (!s7_is_real(page_size)) s7_wrong_type_arg_error(sc, "gtk_adjustment_configure", 7, page_size, "gdouble");
  gtk_adjustment_configure((GtkAdjustment*)s7_c_pointer_with_type(sc, adjustment, GtkAdjustment__sym, __func__, 0), (gdouble)s7_real(value), (gdouble)s7_real(lower), (gdouble)s7_real(upper), (gdouble)s7_real(step_increment), (gdouble)s7_real(page_increment), (gdouble)s7_real(page_size));
  return(lg_false);
}

static s7_pointer lg_gtk_combo_box_set_button_sensitivity(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_combo_box_set_button_sensitivity "void gtk_combo_box_set_button_sensitivity(GtkComboBox* combo_box, \
GtkSensitivityType sensitivity)"
  s7_pointer _p;
  s7_pointer combo_box, sensitivity;
  _p = args;
  combo_box = s7_car(_p); _p = s7_cdr(_p);
  sensitivity = s7_car(_p);
  if (!s7_is_integer(sensitivity)) s7_wrong_type_arg_error(sc, "gtk_combo_box_set_button_sensitivity", 2, sensitivity, "GtkSensitivityType");
  gtk_combo_box_set_button_sensitivity((GtkComboBox*)s7_c_pointer_with_type(sc, combo_box, GtkComboBox__sym, __func__, 0), (GtkSensitivityType)s7_integer(sensitivity));
  return(lg_false);
}

static s7_pointer lg_gtk_combo_box_get_button_sensitivity(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_combo_box_get_button_sensitivity "GtkSensitivityType gtk_combo_box_get_button_sensitivity(GtkComboBox* combo_box)"
  s7_pointer combo_box;
  combo_box = s7_car(args);
  return(s7_make_integer(sc, gtk_combo_box_get_button_sensitivity((GtkComboBox*)s7_c_pointer_with_type(sc, combo_box, GtkComboBox__sym, __func__, 0))));
}

static s7_pointer lg_gtk_window_get_default_widget(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_window_get_default_widget "GtkWidget* gtk_window_get_default_widget(GtkWindow* window)"
  s7_pointer window;
  window = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_window_get_default_widget((GtkWindow*)s7_c_pointer_with_type(sc, window, GtkWindow__sym, __func__, 0))));
}

static s7_pointer lg_gtk_link_button_get_visited(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_link_button_get_visited "gboolean gtk_link_button_get_visited(GtkLinkButton* link_button)"
  s7_pointer link_button;
  link_button = s7_car(args);
  return(s7_make_boolean(sc, gtk_link_button_get_visited((GtkLinkButton*)s7_c_pointer_with_type(sc, link_button, GtkLinkButton__sym, __func__, 0))));
}

static s7_pointer lg_gtk_link_button_set_visited(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_link_button_set_visited "void gtk_link_button_set_visited(GtkLinkButton* link_button, \
bool visited)"
  s7_pointer _p;
  s7_pointer link_button, visited;
  _p = args;
  link_button = s7_car(_p); _p = s7_cdr(_p);
  visited = s7_car(_p);
  if (!s7_is_boolean(visited)) s7_wrong_type_arg_error(sc, "gtk_link_button_set_visited", 2, visited, "bool");
  gtk_link_button_set_visited((GtkLinkButton*)s7_c_pointer_with_type(sc, link_button, GtkLinkButton__sym, __func__, 0), (bool)lg_boolean(visited));
  return(lg_false);
}

static s7_pointer lg_gtk_cell_view_get_model(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_view_get_model "GtkTreeModel* gtk_cell_view_get_model(GtkCellView* cell_view)"
  s7_pointer cell_view;
  cell_view = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GtkTreeModel__sym, gtk_cell_view_get_model((GtkCellView*)s7_c_pointer_with_type(sc, cell_view, GtkCellView__sym, __func__, 0))));
}

static s7_pointer lg_gtk_entry_unset_invisible_char(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_unset_invisible_char "void gtk_entry_unset_invisible_char(GtkEntry* entry)"
  s7_pointer entry;
  entry = s7_car(args);
  gtk_entry_unset_invisible_char((GtkEntry*)s7_c_pointer_with_type(sc, entry, GtkEntry__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_entry_set_progress_fraction(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_set_progress_fraction "void gtk_entry_set_progress_fraction(GtkEntry* entry, gdouble fraction)"
  s7_pointer _p;
  s7_pointer entry, fraction;
  _p = args;
  entry = s7_car(_p); _p = s7_cdr(_p);
  fraction = s7_car(_p);
  if (!s7_is_real(fraction)) s7_wrong_type_arg_error(sc, "gtk_entry_set_progress_fraction", 2, fraction, "gdouble");
  gtk_entry_set_progress_fraction((GtkEntry*)s7_c_pointer_with_type(sc, entry, GtkEntry__sym, __func__, 0), (gdouble)s7_real(fraction));
  return(lg_false);
}

static s7_pointer lg_gtk_entry_get_progress_fraction(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_get_progress_fraction "gdouble gtk_entry_get_progress_fraction(GtkEntry* entry)"
  s7_pointer entry;
  entry = s7_car(args);
  return(s7_make_real(sc, gtk_entry_get_progress_fraction((GtkEntry*)s7_c_pointer_with_type(sc, entry, GtkEntry__sym, __func__, 0))));
}

static s7_pointer lg_gtk_entry_set_progress_pulse_step(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_set_progress_pulse_step "void gtk_entry_set_progress_pulse_step(GtkEntry* entry, \
gdouble fraction)"
  s7_pointer _p;
  s7_pointer entry, fraction;
  _p = args;
  entry = s7_car(_p); _p = s7_cdr(_p);
  fraction = s7_car(_p);
  if (!s7_is_real(fraction)) s7_wrong_type_arg_error(sc, "gtk_entry_set_progress_pulse_step", 2, fraction, "gdouble");
  gtk_entry_set_progress_pulse_step((GtkEntry*)s7_c_pointer_with_type(sc, entry, GtkEntry__sym, __func__, 0), (gdouble)s7_real(fraction));
  return(lg_false);
}

static s7_pointer lg_gtk_entry_get_progress_pulse_step(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_get_progress_pulse_step "gdouble gtk_entry_get_progress_pulse_step(GtkEntry* entry)"
  s7_pointer entry;
  entry = s7_car(args);
  return(s7_make_real(sc, gtk_entry_get_progress_pulse_step((GtkEntry*)s7_c_pointer_with_type(sc, entry, GtkEntry__sym, __func__, 0))));
}

static s7_pointer lg_gtk_entry_progress_pulse(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_progress_pulse "void gtk_entry_progress_pulse(GtkEntry* entry)"
  s7_pointer entry;
  entry = s7_car(args);
  gtk_entry_progress_pulse((GtkEntry*)s7_c_pointer_with_type(sc, entry, GtkEntry__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_entry_get_icon_name(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_get_icon_name "gchar* gtk_entry_get_icon_name(GtkEntry* entry, GtkEntryIconPosition icon_pos)"
  s7_pointer _p;
  s7_pointer entry, icon_pos;
  _p = args;
  entry = s7_car(_p); _p = s7_cdr(_p);
  icon_pos = s7_car(_p);
  if (!s7_is_integer(icon_pos)) s7_wrong_type_arg_error(sc, "gtk_entry_get_icon_name", 2, icon_pos, "GtkEntryIconPosition");
  return(s7_make_string(sc, gtk_entry_get_icon_name((GtkEntry*)s7_c_pointer_with_type(sc, entry, GtkEntry__sym, __func__, 0), (GtkEntryIconPosition)s7_integer(icon_pos))));
}

static s7_pointer lg_gtk_entry_set_icon_activatable(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_set_icon_activatable "void gtk_entry_set_icon_activatable(GtkEntry* entry, GtkEntryIconPosition icon_pos, \
gboolean activatable)"
  s7_pointer _p;
  s7_pointer entry, icon_pos, activatable;
  _p = args;
  entry = s7_car(_p); _p = s7_cdr(_p);
  icon_pos = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(icon_pos)) s7_wrong_type_arg_error(sc, "gtk_entry_set_icon_activatable", 2, icon_pos, "GtkEntryIconPosition");
  activatable = s7_car(_p);
  if (!s7_is_boolean(activatable)) s7_wrong_type_arg_error(sc, "gtk_entry_set_icon_activatable", 3, activatable, "gboolean");
  gtk_entry_set_icon_activatable((GtkEntry*)s7_c_pointer_with_type(sc, entry, GtkEntry__sym, __func__, 0), (GtkEntryIconPosition)s7_integer(icon_pos), (gboolean)lg_boolean(activatable));
  return(lg_false);
}

static s7_pointer lg_gtk_entry_get_icon_activatable(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_get_icon_activatable "gboolean gtk_entry_get_icon_activatable(GtkEntry* entry, \
GtkEntryIconPosition icon_pos)"
  s7_pointer _p;
  s7_pointer entry, icon_pos;
  _p = args;
  entry = s7_car(_p); _p = s7_cdr(_p);
  icon_pos = s7_car(_p);
  if (!s7_is_integer(icon_pos)) s7_wrong_type_arg_error(sc, "gtk_entry_get_icon_activatable", 2, icon_pos, "GtkEntryIconPosition");
  return(s7_make_boolean(sc, gtk_entry_get_icon_activatable((GtkEntry*)s7_c_pointer_with_type(sc, entry, GtkEntry__sym, __func__, 0), (GtkEntryIconPosition)s7_integer(icon_pos))));
}

static s7_pointer lg_gtk_entry_set_icon_sensitive(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_set_icon_sensitive "void gtk_entry_set_icon_sensitive(GtkEntry* entry, GtkEntryIconPosition icon_pos, \
gboolean sensitive)"
  s7_pointer _p;
  s7_pointer entry, icon_pos, sensitive;
  _p = args;
  entry = s7_car(_p); _p = s7_cdr(_p);
  icon_pos = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(icon_pos)) s7_wrong_type_arg_error(sc, "gtk_entry_set_icon_sensitive", 2, icon_pos, "GtkEntryIconPosition");
  sensitive = s7_car(_p);
  if (!s7_is_boolean(sensitive)) s7_wrong_type_arg_error(sc, "gtk_entry_set_icon_sensitive", 3, sensitive, "gboolean");
  gtk_entry_set_icon_sensitive((GtkEntry*)s7_c_pointer_with_type(sc, entry, GtkEntry__sym, __func__, 0), (GtkEntryIconPosition)s7_integer(icon_pos), (gboolean)lg_boolean(sensitive));
  return(lg_false);
}

static s7_pointer lg_gtk_entry_get_icon_sensitive(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_get_icon_sensitive "gboolean gtk_entry_get_icon_sensitive(GtkEntry* entry, GtkEntryIconPosition icon_pos)"
  s7_pointer _p;
  s7_pointer entry, icon_pos;
  _p = args;
  entry = s7_car(_p); _p = s7_cdr(_p);
  icon_pos = s7_car(_p);
  if (!s7_is_integer(icon_pos)) s7_wrong_type_arg_error(sc, "gtk_entry_get_icon_sensitive", 2, icon_pos, "GtkEntryIconPosition");
  return(s7_make_boolean(sc, gtk_entry_get_icon_sensitive((GtkEntry*)s7_c_pointer_with_type(sc, entry, GtkEntry__sym, __func__, 0), (GtkEntryIconPosition)s7_integer(icon_pos))));
}

static s7_pointer lg_gtk_entry_get_icon_at_pos(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_get_icon_at_pos "gint gtk_entry_get_icon_at_pos(GtkEntry* entry, gint x, gint y)"
  s7_pointer _p;
  s7_pointer entry, x, y;
  _p = args;
  entry = s7_car(_p); _p = s7_cdr(_p);
  x = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(x)) s7_wrong_type_arg_error(sc, "gtk_entry_get_icon_at_pos", 2, x, "gint");
  y = s7_car(_p);
  if (!s7_is_integer(y)) s7_wrong_type_arg_error(sc, "gtk_entry_get_icon_at_pos", 3, y, "gint");
  return(s7_make_integer(sc, gtk_entry_get_icon_at_pos((GtkEntry*)s7_c_pointer_with_type(sc, entry, GtkEntry__sym, __func__, 0), (gint)s7_integer(x), (gint)s7_integer(y))));
}

static s7_pointer lg_gtk_entry_set_icon_tooltip_text(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_set_icon_tooltip_text "void gtk_entry_set_icon_tooltip_text(GtkEntry* entry, GtkEntryIconPosition icon_pos, \
gchar* tooltip)"
  s7_pointer _p;
  s7_pointer entry, icon_pos, tooltip;
  _p = args;
  entry = s7_car(_p); _p = s7_cdr(_p);
  icon_pos = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(icon_pos)) s7_wrong_type_arg_error(sc, "gtk_entry_set_icon_tooltip_text", 2, icon_pos, "GtkEntryIconPosition");
  tooltip = s7_car(_p);
  if (!s7_is_string(tooltip)) s7_wrong_type_arg_error(sc, "gtk_entry_set_icon_tooltip_text", 3, tooltip, "gchar*");
  gtk_entry_set_icon_tooltip_text((GtkEntry*)s7_c_pointer_with_type(sc, entry, GtkEntry__sym, __func__, 0), (GtkEntryIconPosition)s7_integer(icon_pos), (gchar*)s7_string(tooltip));
  return(lg_false);
}

static s7_pointer lg_gtk_entry_set_icon_tooltip_markup(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_set_icon_tooltip_markup "void gtk_entry_set_icon_tooltip_markup(GtkEntry* entry, \
GtkEntryIconPosition icon_pos, gchar* tooltip)"
  s7_pointer _p;
  s7_pointer entry, icon_pos, tooltip;
  _p = args;
  entry = s7_car(_p); _p = s7_cdr(_p);
  icon_pos = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(icon_pos)) s7_wrong_type_arg_error(sc, "gtk_entry_set_icon_tooltip_markup", 2, icon_pos, "GtkEntryIconPosition");
  tooltip = s7_car(_p);
  if (!s7_is_string(tooltip)) s7_wrong_type_arg_error(sc, "gtk_entry_set_icon_tooltip_markup", 3, tooltip, "gchar*");
  gtk_entry_set_icon_tooltip_markup((GtkEntry*)s7_c_pointer_with_type(sc, entry, GtkEntry__sym, __func__, 0), (GtkEntryIconPosition)s7_integer(icon_pos), (gchar*)s7_string(tooltip));
  return(lg_false);
}

static s7_pointer lg_gtk_entry_get_icon_tooltip_text(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_get_icon_tooltip_text "gchar* gtk_entry_get_icon_tooltip_text(GtkEntry* entry, \
GtkEntryIconPosition icon_pos)"
  s7_pointer _p;
  s7_pointer entry, icon_pos;
  _p = args;
  entry = s7_car(_p); _p = s7_cdr(_p);
  icon_pos = s7_car(_p);
  if (!s7_is_integer(icon_pos)) s7_wrong_type_arg_error(sc, "gtk_entry_get_icon_tooltip_text", 2, icon_pos, "GtkEntryIconPosition");
  return(s7_make_string(sc, gtk_entry_get_icon_tooltip_text((GtkEntry*)s7_c_pointer_with_type(sc, entry, GtkEntry__sym, __func__, 0), (GtkEntryIconPosition)s7_integer(icon_pos))));
}

static s7_pointer lg_gtk_entry_get_icon_tooltip_markup(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_get_icon_tooltip_markup "gchar* gtk_entry_get_icon_tooltip_markup(GtkEntry* entry, \
GtkEntryIconPosition icon_pos)"
  s7_pointer _p;
  s7_pointer entry, icon_pos;
  _p = args;
  entry = s7_car(_p); _p = s7_cdr(_p);
  icon_pos = s7_car(_p);
  if (!s7_is_integer(icon_pos)) s7_wrong_type_arg_error(sc, "gtk_entry_get_icon_tooltip_markup", 2, icon_pos, "GtkEntryIconPosition");
  return(s7_make_string(sc, gtk_entry_get_icon_tooltip_markup((GtkEntry*)s7_c_pointer_with_type(sc, entry, GtkEntry__sym, __func__, 0), (GtkEntryIconPosition)s7_integer(icon_pos))));
}

static s7_pointer lg_gtk_scale_add_mark(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_scale_add_mark "void gtk_scale_add_mark(GtkScale* scale, gdouble value, GtkPositionType position, \
gchar* markup)"
  s7_pointer _p;
  s7_pointer scale, value, position, markup;
  _p = args;
  scale = s7_car(_p); _p = s7_cdr(_p);
  value = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(value)) s7_wrong_type_arg_error(sc, "gtk_scale_add_mark", 2, value, "gdouble");
  position = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(position)) s7_wrong_type_arg_error(sc, "gtk_scale_add_mark", 3, position, "GtkPositionType");
  markup = s7_car(_p);
  if (!s7_is_string(markup)) s7_wrong_type_arg_error(sc, "gtk_scale_add_mark", 4, markup, "gchar*");
  gtk_scale_add_mark((GtkScale*)s7_c_pointer_with_type(sc, scale, GtkScale__sym, __func__, 0), (gdouble)s7_real(value), (GtkPositionType)s7_integer(position), (gchar*)s7_string(markup));
  return(lg_false);
}

static s7_pointer lg_gtk_scale_clear_marks(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_scale_clear_marks "void gtk_scale_clear_marks(GtkScale* scale)"
  s7_pointer scale;
  scale = s7_car(args);
  gtk_scale_clear_marks((GtkScale*)s7_c_pointer_with_type(sc, scale, GtkScale__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_window_get_default_icon_name(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_window_get_default_icon_name "gchar* gtk_window_get_default_icon_name( void)"
  return(s7_make_string(sc, gtk_window_get_default_icon_name()));
}

static s7_pointer lg_gtk_label_get_current_uri(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_label_get_current_uri "gchar* gtk_label_get_current_uri(GtkLabel* label)"
  s7_pointer label;
  label = s7_car(args);
  return(s7_make_string(sc, gtk_label_get_current_uri((GtkLabel*)s7_c_pointer_with_type(sc, label, GtkLabel__sym, __func__, 0))));
}

static s7_pointer lg_gtk_info_bar_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_info_bar_new "GtkWidget* gtk_info_bar_new( void)"
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_info_bar_new()));
}

static s7_pointer lg_gtk_info_bar_add_action_widget(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_info_bar_add_action_widget "void gtk_info_bar_add_action_widget(GtkInfoBar* info_bar, \
GtkWidget* child, gint response_id)"
  s7_pointer _p;
  s7_pointer info_bar, child, response_id;
  _p = args;
  info_bar = s7_car(_p); _p = s7_cdr(_p);
  child = s7_car(_p); _p = s7_cdr(_p);
  response_id = s7_car(_p);
  if (!s7_is_integer(response_id)) s7_wrong_type_arg_error(sc, "gtk_info_bar_add_action_widget", 3, response_id, "gint");
  gtk_info_bar_add_action_widget((GtkInfoBar*)s7_c_pointer_with_type(sc, info_bar, GtkInfoBar__sym, __func__, 0), (GtkWidget*)s7_c_pointer_with_type(sc, child, GtkWidget__sym, __func__, 0), (gint)s7_integer(response_id));
  return(lg_false);
}

static s7_pointer lg_gtk_info_bar_add_button(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_info_bar_add_button "GtkWidget* gtk_info_bar_add_button(GtkInfoBar* info_bar, gchar* button_text, \
gint response_id)"
  s7_pointer _p;
  s7_pointer info_bar, button_text, response_id;
  _p = args;
  info_bar = s7_car(_p); _p = s7_cdr(_p);
  button_text = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(button_text)) s7_wrong_type_arg_error(sc, "gtk_info_bar_add_button", 2, button_text, "gchar*");
  response_id = s7_car(_p);
  if (!s7_is_integer(response_id)) s7_wrong_type_arg_error(sc, "gtk_info_bar_add_button", 3, response_id, "gint");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_info_bar_add_button((GtkInfoBar*)s7_c_pointer_with_type(sc, info_bar, GtkInfoBar__sym, __func__, 0), (gchar*)s7_string(button_text), (gint)s7_integer(response_id))));
}

static s7_pointer lg_gtk_info_bar_set_response_sensitive(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_info_bar_set_response_sensitive "void gtk_info_bar_set_response_sensitive(GtkInfoBar* info_bar, \
gint response_id, gboolean setting)"
  s7_pointer _p;
  s7_pointer info_bar, response_id, setting;
  _p = args;
  info_bar = s7_car(_p); _p = s7_cdr(_p);
  response_id = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(response_id)) s7_wrong_type_arg_error(sc, "gtk_info_bar_set_response_sensitive", 2, response_id, "gint");
  setting = s7_car(_p);
  if (!s7_is_boolean(setting)) s7_wrong_type_arg_error(sc, "gtk_info_bar_set_response_sensitive", 3, setting, "gboolean");
  gtk_info_bar_set_response_sensitive((GtkInfoBar*)s7_c_pointer_with_type(sc, info_bar, GtkInfoBar__sym, __func__, 0), (gint)s7_integer(response_id), (gboolean)lg_boolean(setting));
  return(lg_false);
}

static s7_pointer lg_gtk_info_bar_set_default_response(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_info_bar_set_default_response "void gtk_info_bar_set_default_response(GtkInfoBar* info_bar, \
gint response_id)"
  s7_pointer _p;
  s7_pointer info_bar, response_id;
  _p = args;
  info_bar = s7_car(_p); _p = s7_cdr(_p);
  response_id = s7_car(_p);
  if (!s7_is_integer(response_id)) s7_wrong_type_arg_error(sc, "gtk_info_bar_set_default_response", 2, response_id, "gint");
  gtk_info_bar_set_default_response((GtkInfoBar*)s7_c_pointer_with_type(sc, info_bar, GtkInfoBar__sym, __func__, 0), (gint)s7_integer(response_id));
  return(lg_false);
}

static s7_pointer lg_gtk_info_bar_response(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_info_bar_response "void gtk_info_bar_response(GtkInfoBar* info_bar, gint response_id)"
  s7_pointer _p;
  s7_pointer info_bar, response_id;
  _p = args;
  info_bar = s7_car(_p); _p = s7_cdr(_p);
  response_id = s7_car(_p);
  if (!s7_is_integer(response_id)) s7_wrong_type_arg_error(sc, "gtk_info_bar_response", 2, response_id, "gint");
  gtk_info_bar_response((GtkInfoBar*)s7_c_pointer_with_type(sc, info_bar, GtkInfoBar__sym, __func__, 0), (gint)s7_integer(response_id));
  return(lg_false);
}

static s7_pointer lg_gtk_info_bar_set_message_type(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_info_bar_set_message_type "void gtk_info_bar_set_message_type(GtkInfoBar* info_bar, GtkMessageType message_type)"
  s7_pointer _p;
  s7_pointer info_bar, message_type;
  _p = args;
  info_bar = s7_car(_p); _p = s7_cdr(_p);
  message_type = s7_car(_p);
  if (!s7_is_integer(message_type)) s7_wrong_type_arg_error(sc, "gtk_info_bar_set_message_type", 2, message_type, "GtkMessageType");
  gtk_info_bar_set_message_type((GtkInfoBar*)s7_c_pointer_with_type(sc, info_bar, GtkInfoBar__sym, __func__, 0), (GtkMessageType)s7_integer(message_type));
  return(lg_false);
}

static s7_pointer lg_gtk_info_bar_get_message_type(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_info_bar_get_message_type "GtkMessageType gtk_info_bar_get_message_type(GtkInfoBar* info_bar)"
  s7_pointer info_bar;
  info_bar = s7_car(args);
  return(s7_make_integer(sc, gtk_info_bar_get_message_type((GtkInfoBar*)s7_c_pointer_with_type(sc, info_bar, GtkInfoBar__sym, __func__, 0))));
}

static s7_pointer lg_gtk_entry_new_with_buffer(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_new_with_buffer "GtkWidget* gtk_entry_new_with_buffer(GtkEntryBuffer* buffer)"
  s7_pointer buffer;
  buffer = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_entry_new_with_buffer((GtkEntryBuffer*)s7_c_pointer_with_type(sc, buffer, GtkEntryBuffer__sym, __func__, 0))));
}

static s7_pointer lg_gtk_entry_get_buffer(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_get_buffer "GtkEntryBuffer* gtk_entry_get_buffer(GtkEntry* entry)"
  s7_pointer entry;
  entry = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GtkEntryBuffer__sym, gtk_entry_get_buffer((GtkEntry*)s7_c_pointer_with_type(sc, entry, GtkEntry__sym, __func__, 0))));
}

static s7_pointer lg_gtk_entry_set_buffer(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_set_buffer "void gtk_entry_set_buffer(GtkEntry* entry, GtkEntryBuffer* buffer)"
  s7_pointer _p;
  s7_pointer entry, buffer;
  _p = args;
  entry = s7_car(_p); _p = s7_cdr(_p);
  buffer = s7_car(_p);
  gtk_entry_set_buffer((GtkEntry*)s7_c_pointer_with_type(sc, entry, GtkEntry__sym, __func__, 0), (GtkEntryBuffer*)s7_c_pointer_with_type(sc, buffer, GtkEntryBuffer__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_print_operation_set_embed_page_setup(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_operation_set_embed_page_setup "void gtk_print_operation_set_embed_page_setup(GtkPrintOperation* op, \
gboolean embed)"
  s7_pointer _p;
  s7_pointer op, embed;
  _p = args;
  op = s7_car(_p); _p = s7_cdr(_p);
  embed = s7_car(_p);
  if (!s7_is_boolean(embed)) s7_wrong_type_arg_error(sc, "gtk_print_operation_set_embed_page_setup", 2, embed, "gboolean");
  gtk_print_operation_set_embed_page_setup((GtkPrintOperation*)s7_c_pointer_with_type(sc, op, GtkPrintOperation__sym, __func__, 0), (gboolean)lg_boolean(embed));
  return(lg_false);
}

static s7_pointer lg_gtk_print_operation_get_embed_page_setup(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_operation_get_embed_page_setup "gboolean gtk_print_operation_get_embed_page_setup(GtkPrintOperation* op)"
  s7_pointer op;
  op = s7_car(args);
  return(s7_make_boolean(sc, gtk_print_operation_get_embed_page_setup((GtkPrintOperation*)s7_c_pointer_with_type(sc, op, GtkPrintOperation__sym, __func__, 0))));
}

static s7_pointer lg_gtk_entry_buffer_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_buffer_new "GtkEntryBuffer* gtk_entry_buffer_new(gchar* initial_chars, gint n_initial_chars)"
  s7_pointer _p;
  s7_pointer initial_chars, n_initial_chars;
  _p = args;
  initial_chars = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(initial_chars)) s7_wrong_type_arg_error(sc, "gtk_entry_buffer_new", 1, initial_chars, "gchar*");
  n_initial_chars = s7_car(_p);
  if (!s7_is_integer(n_initial_chars)) s7_wrong_type_arg_error(sc, "gtk_entry_buffer_new", 2, n_initial_chars, "gint");
  return(lg_make_c_pointer_with_type(sc, GtkEntryBuffer__sym, gtk_entry_buffer_new((gchar*)s7_string(initial_chars), (gint)s7_integer(n_initial_chars))));
}

static s7_pointer lg_gtk_entry_buffer_get_bytes(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_buffer_get_bytes "gsize gtk_entry_buffer_get_bytes(GtkEntryBuffer* buffer)"
  s7_pointer buffer;
  buffer = s7_car(args);
  return(s7_make_integer(sc, gtk_entry_buffer_get_bytes((GtkEntryBuffer*)s7_c_pointer_with_type(sc, buffer, GtkEntryBuffer__sym, __func__, 0))));
}

static s7_pointer lg_gtk_entry_buffer_get_length(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_buffer_get_length "guint gtk_entry_buffer_get_length(GtkEntryBuffer* buffer)"
  s7_pointer buffer;
  buffer = s7_car(args);
  return(s7_make_integer(sc, gtk_entry_buffer_get_length((GtkEntryBuffer*)s7_c_pointer_with_type(sc, buffer, GtkEntryBuffer__sym, __func__, 0))));
}

static s7_pointer lg_gtk_entry_buffer_get_text(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_buffer_get_text "gchar* gtk_entry_buffer_get_text(GtkEntryBuffer* buffer)"
  s7_pointer buffer;
  buffer = s7_car(args);
  return(s7_make_string(sc, gtk_entry_buffer_get_text((GtkEntryBuffer*)s7_c_pointer_with_type(sc, buffer, GtkEntryBuffer__sym, __func__, 0))));
}

static s7_pointer lg_gtk_entry_buffer_set_text(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_buffer_set_text "void gtk_entry_buffer_set_text(GtkEntryBuffer* buffer, gchar* chars, \
gint n_chars)"
  s7_pointer _p;
  s7_pointer buffer, chars, n_chars;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  chars = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(chars)) s7_wrong_type_arg_error(sc, "gtk_entry_buffer_set_text", 2, chars, "gchar*");
  n_chars = s7_car(_p);
  if (!s7_is_integer(n_chars)) s7_wrong_type_arg_error(sc, "gtk_entry_buffer_set_text", 3, n_chars, "gint");
  gtk_entry_buffer_set_text((GtkEntryBuffer*)s7_c_pointer_with_type(sc, buffer, GtkEntryBuffer__sym, __func__, 0), (gchar*)s7_string(chars), (gint)s7_integer(n_chars));
  return(lg_false);
}

static s7_pointer lg_gtk_entry_buffer_set_max_length(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_buffer_set_max_length "void gtk_entry_buffer_set_max_length(GtkEntryBuffer* buffer, \
guint max_length)"
  s7_pointer _p;
  s7_pointer buffer, max_length;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  max_length = s7_car(_p);
  if (!s7_is_integer(max_length)) s7_wrong_type_arg_error(sc, "gtk_entry_buffer_set_max_length", 2, max_length, "guint");
  gtk_entry_buffer_set_max_length((GtkEntryBuffer*)s7_c_pointer_with_type(sc, buffer, GtkEntryBuffer__sym, __func__, 0), (guint)s7_integer(max_length));
  return(lg_false);
}

static s7_pointer lg_gtk_entry_buffer_get_max_length(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_buffer_get_max_length "guint gtk_entry_buffer_get_max_length(GtkEntryBuffer* buffer)"
  s7_pointer buffer;
  buffer = s7_car(args);
  return(s7_make_integer(sc, gtk_entry_buffer_get_max_length((GtkEntryBuffer*)s7_c_pointer_with_type(sc, buffer, GtkEntryBuffer__sym, __func__, 0))));
}

static s7_pointer lg_gtk_entry_buffer_insert_text(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_buffer_insert_text "guint gtk_entry_buffer_insert_text(GtkEntryBuffer* buffer, \
guint position, gchar* chars, gint n_chars)"
  s7_pointer _p;
  s7_pointer buffer, position, chars, n_chars;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  position = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(position)) s7_wrong_type_arg_error(sc, "gtk_entry_buffer_insert_text", 2, position, "guint");
  chars = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(chars)) s7_wrong_type_arg_error(sc, "gtk_entry_buffer_insert_text", 3, chars, "gchar*");
  n_chars = s7_car(_p);
  if (!s7_is_integer(n_chars)) s7_wrong_type_arg_error(sc, "gtk_entry_buffer_insert_text", 4, n_chars, "gint");
  return(s7_make_integer(sc, gtk_entry_buffer_insert_text((GtkEntryBuffer*)s7_c_pointer_with_type(sc, buffer, GtkEntryBuffer__sym, __func__, 0), (guint)s7_integer(position), (gchar*)s7_string(chars), (gint)s7_integer(n_chars))));
}

static s7_pointer lg_gtk_entry_buffer_delete_text(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_buffer_delete_text "guint gtk_entry_buffer_delete_text(GtkEntryBuffer* buffer, \
guint position, gint n_chars)"
  s7_pointer _p;
  s7_pointer buffer, position, n_chars;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  position = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(position)) s7_wrong_type_arg_error(sc, "gtk_entry_buffer_delete_text", 2, position, "guint");
  n_chars = s7_car(_p);
  if (!s7_is_integer(n_chars)) s7_wrong_type_arg_error(sc, "gtk_entry_buffer_delete_text", 3, n_chars, "gint");
  return(s7_make_integer(sc, gtk_entry_buffer_delete_text((GtkEntryBuffer*)s7_c_pointer_with_type(sc, buffer, GtkEntryBuffer__sym, __func__, 0), (guint)s7_integer(position), (gint)s7_integer(n_chars))));
}

static s7_pointer lg_gtk_entry_buffer_emit_inserted_text(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_buffer_emit_inserted_text "void gtk_entry_buffer_emit_inserted_text(GtkEntryBuffer* buffer, \
guint position, gchar* chars, guint n_chars)"
  s7_pointer _p;
  s7_pointer buffer, position, chars, n_chars;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  position = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(position)) s7_wrong_type_arg_error(sc, "gtk_entry_buffer_emit_inserted_text", 2, position, "guint");
  chars = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(chars)) s7_wrong_type_arg_error(sc, "gtk_entry_buffer_emit_inserted_text", 3, chars, "gchar*");
  n_chars = s7_car(_p);
  if (!s7_is_integer(n_chars)) s7_wrong_type_arg_error(sc, "gtk_entry_buffer_emit_inserted_text", 4, n_chars, "guint");
  gtk_entry_buffer_emit_inserted_text((GtkEntryBuffer*)s7_c_pointer_with_type(sc, buffer, GtkEntryBuffer__sym, __func__, 0), (guint)s7_integer(position), (gchar*)s7_string(chars), (guint)s7_integer(n_chars));
  return(lg_false);
}

static s7_pointer lg_gtk_entry_buffer_emit_deleted_text(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_buffer_emit_deleted_text "void gtk_entry_buffer_emit_deleted_text(GtkEntryBuffer* buffer, \
guint position, guint n_chars)"
  s7_pointer _p;
  s7_pointer buffer, position, n_chars;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  position = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(position)) s7_wrong_type_arg_error(sc, "gtk_entry_buffer_emit_deleted_text", 2, position, "guint");
  n_chars = s7_car(_p);
  if (!s7_is_integer(n_chars)) s7_wrong_type_arg_error(sc, "gtk_entry_buffer_emit_deleted_text", 3, n_chars, "guint");
  gtk_entry_buffer_emit_deleted_text((GtkEntryBuffer*)s7_c_pointer_with_type(sc, buffer, GtkEntryBuffer__sym, __func__, 0), (guint)s7_integer(position), (guint)s7_integer(n_chars));
  return(lg_false);
}

static s7_pointer lg_gtk_cell_renderer_set_alignment(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_renderer_set_alignment "void gtk_cell_renderer_set_alignment(GtkCellRenderer* cell, \
gfloat xalign, gfloat yalign)"
  s7_pointer _p;
  s7_pointer cell, xalign, yalign;
  _p = args;
  cell = s7_car(_p); _p = s7_cdr(_p);
  xalign = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(xalign)) s7_wrong_type_arg_error(sc, "gtk_cell_renderer_set_alignment", 2, xalign, "gfloat");
  yalign = s7_car(_p);
  if (!s7_is_real(yalign)) s7_wrong_type_arg_error(sc, "gtk_cell_renderer_set_alignment", 3, yalign, "gfloat");
  gtk_cell_renderer_set_alignment((GtkCellRenderer*)s7_c_pointer_with_type(sc, cell, GtkCellRenderer__sym, __func__, 0), (gfloat)s7_real(xalign), (gfloat)s7_real(yalign));
  return(lg_false);
}

static s7_pointer lg_gtk_cell_renderer_get_alignment(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_renderer_get_alignment "void gtk_cell_renderer_get_alignment(GtkCellRenderer* cell, \
gfloat* [xalign], gfloat* [yalign])"
  s7_pointer _p;
  s7_pointer cell;
  gfloat ref_xalign;
  gfloat ref_yalign;
  _p = args;
  cell = s7_car(_p);
  gtk_cell_renderer_get_alignment((GtkCellRenderer*)s7_c_pointer_with_type(sc, cell, GtkCellRenderer__sym, __func__, 0), &ref_xalign, &ref_yalign);
    return(s7_list(sc, 2, s7_make_real(sc, ref_xalign), s7_make_real(sc, ref_yalign)));
}

static s7_pointer lg_gtk_cell_renderer_set_padding(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_renderer_set_padding "void gtk_cell_renderer_set_padding(GtkCellRenderer* cell, \
gint xpad, gint ypad)"
  s7_pointer _p;
  s7_pointer cell, xpad, ypad;
  _p = args;
  cell = s7_car(_p); _p = s7_cdr(_p);
  xpad = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(xpad)) s7_wrong_type_arg_error(sc, "gtk_cell_renderer_set_padding", 2, xpad, "gint");
  ypad = s7_car(_p);
  if (!s7_is_integer(ypad)) s7_wrong_type_arg_error(sc, "gtk_cell_renderer_set_padding", 3, ypad, "gint");
  gtk_cell_renderer_set_padding((GtkCellRenderer*)s7_c_pointer_with_type(sc, cell, GtkCellRenderer__sym, __func__, 0), (gint)s7_integer(xpad), (gint)s7_integer(ypad));
  return(lg_false);
}

static s7_pointer lg_gtk_cell_renderer_get_padding(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_renderer_get_padding "void gtk_cell_renderer_get_padding(GtkCellRenderer* cell, \
gint* [xpad], gint* [ypad])"
  s7_pointer _p;
  s7_pointer cell;
  gint ref_xpad;
  gint ref_ypad;
  _p = args;
  cell = s7_car(_p);
  gtk_cell_renderer_get_padding((GtkCellRenderer*)s7_c_pointer_with_type(sc, cell, GtkCellRenderer__sym, __func__, 0), &ref_xpad, &ref_ypad);
    return(s7_list(sc, 2, s7_make_integer(sc, ref_xpad), s7_make_integer(sc, ref_ypad)));
}

static s7_pointer lg_gtk_cell_renderer_set_visible(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_renderer_set_visible "void gtk_cell_renderer_set_visible(GtkCellRenderer* cell, \
gboolean visible)"
  s7_pointer _p;
  s7_pointer cell, visible;
  _p = args;
  cell = s7_car(_p); _p = s7_cdr(_p);
  visible = s7_car(_p);
  if (!s7_is_boolean(visible)) s7_wrong_type_arg_error(sc, "gtk_cell_renderer_set_visible", 2, visible, "gboolean");
  gtk_cell_renderer_set_visible((GtkCellRenderer*)s7_c_pointer_with_type(sc, cell, GtkCellRenderer__sym, __func__, 0), (gboolean)lg_boolean(visible));
  return(lg_false);
}

static s7_pointer lg_gtk_cell_renderer_get_visible(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_renderer_get_visible "gboolean gtk_cell_renderer_get_visible(GtkCellRenderer* cell)"
  s7_pointer cell;
  cell = s7_car(args);
  return(s7_make_boolean(sc, gtk_cell_renderer_get_visible((GtkCellRenderer*)s7_c_pointer_with_type(sc, cell, GtkCellRenderer__sym, __func__, 0))));
}

static s7_pointer lg_gtk_cell_renderer_set_sensitive(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_renderer_set_sensitive "void gtk_cell_renderer_set_sensitive(GtkCellRenderer* cell, \
gboolean sensitive)"
  s7_pointer _p;
  s7_pointer cell, sensitive;
  _p = args;
  cell = s7_car(_p); _p = s7_cdr(_p);
  sensitive = s7_car(_p);
  if (!s7_is_boolean(sensitive)) s7_wrong_type_arg_error(sc, "gtk_cell_renderer_set_sensitive", 2, sensitive, "gboolean");
  gtk_cell_renderer_set_sensitive((GtkCellRenderer*)s7_c_pointer_with_type(sc, cell, GtkCellRenderer__sym, __func__, 0), (gboolean)lg_boolean(sensitive));
  return(lg_false);
}

static s7_pointer lg_gtk_cell_renderer_get_sensitive(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_renderer_get_sensitive "gboolean gtk_cell_renderer_get_sensitive(GtkCellRenderer* cell)"
  s7_pointer cell;
  cell = s7_car(args);
  return(s7_make_boolean(sc, gtk_cell_renderer_get_sensitive((GtkCellRenderer*)s7_c_pointer_with_type(sc, cell, GtkCellRenderer__sym, __func__, 0))));
}

static s7_pointer lg_gtk_cell_renderer_toggle_get_activatable(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_renderer_toggle_get_activatable "gboolean gtk_cell_renderer_toggle_get_activatable(GtkCellRendererToggle* toggle)"
  s7_pointer toggle;
  toggle = s7_car(args);
  return(s7_make_boolean(sc, gtk_cell_renderer_toggle_get_activatable((GtkCellRendererToggle*)s7_c_pointer_with_type(sc, toggle, GtkCellRendererToggle__sym, __func__, 0))));
}

static s7_pointer lg_gtk_cell_renderer_toggle_set_activatable(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_renderer_toggle_set_activatable "void gtk_cell_renderer_toggle_set_activatable(GtkCellRendererToggle* toggle, \
gboolean setting)"
  s7_pointer _p;
  s7_pointer toggle, setting;
  _p = args;
  toggle = s7_car(_p); _p = s7_cdr(_p);
  setting = s7_car(_p);
  if (!s7_is_boolean(setting)) s7_wrong_type_arg_error(sc, "gtk_cell_renderer_toggle_set_activatable", 2, setting, "gboolean");
  gtk_cell_renderer_toggle_set_activatable((GtkCellRendererToggle*)s7_c_pointer_with_type(sc, toggle, GtkCellRendererToggle__sym, __func__, 0), (gboolean)lg_boolean(setting));
  return(lg_false);
}

static s7_pointer lg_gtk_widget_set_can_focus(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_set_can_focus "void gtk_widget_set_can_focus(GtkWidget* widget, gboolean can_focus)"
  s7_pointer _p;
  s7_pointer widget, can_focus;
  _p = args;
  widget = s7_car(_p); _p = s7_cdr(_p);
  can_focus = s7_car(_p);
  if (!s7_is_boolean(can_focus)) s7_wrong_type_arg_error(sc, "gtk_widget_set_can_focus", 2, can_focus, "gboolean");
  gtk_widget_set_can_focus((GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0), (gboolean)lg_boolean(can_focus));
  return(lg_false);
}

static s7_pointer lg_gtk_widget_get_can_focus(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_get_can_focus "gboolean gtk_widget_get_can_focus(GtkWidget* widget)"
  s7_pointer widget;
  widget = s7_car(args);
  return(s7_make_boolean(sc, gtk_widget_get_can_focus((GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0))));
}

static s7_pointer lg_gtk_widget_has_focus(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_has_focus "gboolean gtk_widget_has_focus(GtkWidget* widget)"
  s7_pointer widget;
  widget = s7_car(args);
  return(s7_make_boolean(sc, gtk_widget_has_focus((GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0))));
}

static s7_pointer lg_gtk_widget_has_default(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_has_default "gboolean gtk_widget_has_default(GtkWidget* widget)"
  s7_pointer widget;
  widget = s7_car(args);
  return(s7_make_boolean(sc, gtk_widget_has_default((GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0))));
}

static s7_pointer lg_gtk_widget_get_sensitive(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_get_sensitive "gboolean gtk_widget_get_sensitive(GtkWidget* widget)"
  s7_pointer widget;
  widget = s7_car(args);
  return(s7_make_boolean(sc, gtk_widget_get_sensitive((GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0))));
}

static s7_pointer lg_gtk_widget_is_sensitive(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_is_sensitive "gboolean gtk_widget_is_sensitive(GtkWidget* widget)"
  s7_pointer widget;
  widget = s7_car(args);
  return(s7_make_boolean(sc, gtk_widget_is_sensitive((GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0))));
}

static s7_pointer lg_gtk_icon_view_set_item_padding(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_set_item_padding "void gtk_icon_view_set_item_padding(GtkIconView* icon_view, \
gint item_padding)"
  s7_pointer _p;
  s7_pointer icon_view, item_padding;
  _p = args;
  icon_view = s7_car(_p); _p = s7_cdr(_p);
  item_padding = s7_car(_p);
  if (!s7_is_integer(item_padding)) s7_wrong_type_arg_error(sc, "gtk_icon_view_set_item_padding", 2, item_padding, "gint");
  gtk_icon_view_set_item_padding((GtkIconView*)s7_c_pointer_with_type(sc, icon_view, GtkIconView__sym, __func__, 0), (gint)s7_integer(item_padding));
  return(lg_false);
}

static s7_pointer lg_gtk_icon_view_get_item_padding(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_get_item_padding "gint gtk_icon_view_get_item_padding(GtkIconView* icon_view)"
  s7_pointer icon_view;
  icon_view = s7_car(args);
  return(s7_make_integer(sc, gtk_icon_view_get_item_padding((GtkIconView*)s7_c_pointer_with_type(sc, icon_view, GtkIconView__sym, __func__, 0))));
}

static s7_pointer lg_gtk_widget_set_visible(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_set_visible "void gtk_widget_set_visible(GtkWidget* widget, gboolean visible)"
  s7_pointer _p;
  s7_pointer widget, visible;
  _p = args;
  widget = s7_car(_p); _p = s7_cdr(_p);
  visible = s7_car(_p);
  if (!s7_is_boolean(visible)) s7_wrong_type_arg_error(sc, "gtk_widget_set_visible", 2, visible, "gboolean");
  gtk_widget_set_visible((GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0), (gboolean)lg_boolean(visible));
  return(lg_false);
}

static s7_pointer lg_gtk_widget_get_visible(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_get_visible "gboolean gtk_widget_get_visible(GtkWidget* widget)"
  s7_pointer widget;
  widget = s7_car(args);
  return(s7_make_boolean(sc, gtk_widget_get_visible((GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0))));
}

static s7_pointer lg_gtk_range_set_flippable(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_range_set_flippable "void gtk_range_set_flippable(GtkRange* range, gboolean flippable)"
  s7_pointer _p;
  s7_pointer range, flippable;
  _p = args;
  range = s7_car(_p); _p = s7_cdr(_p);
  flippable = s7_car(_p);
  if (!s7_is_boolean(flippable)) s7_wrong_type_arg_error(sc, "gtk_range_set_flippable", 2, flippable, "gboolean");
  gtk_range_set_flippable((GtkRange*)s7_c_pointer_with_type(sc, range, GtkRange__sym, __func__, 0), (gboolean)lg_boolean(flippable));
  return(lg_false);
}

static s7_pointer lg_gtk_range_get_flippable(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_range_get_flippable "gboolean gtk_range_get_flippable(GtkRange* range)"
  s7_pointer range;
  range = s7_car(args);
  return(s7_make_boolean(sc, gtk_range_get_flippable((GtkRange*)s7_c_pointer_with_type(sc, range, GtkRange__sym, __func__, 0))));
}

static s7_pointer lg_gtk_widget_is_drawable(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_is_drawable "gboolean gtk_widget_is_drawable(GtkWidget* widget)"
  s7_pointer widget;
  widget = s7_car(args);
  return(s7_make_boolean(sc, gtk_widget_is_drawable((GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0))));
}

static s7_pointer lg_gtk_widget_set_receives_default(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_set_receives_default "void gtk_widget_set_receives_default(GtkWidget* widget, \
gboolean receives_default)"
  s7_pointer _p;
  s7_pointer widget, receives_default;
  _p = args;
  widget = s7_car(_p); _p = s7_cdr(_p);
  receives_default = s7_car(_p);
  if (!s7_is_boolean(receives_default)) s7_wrong_type_arg_error(sc, "gtk_widget_set_receives_default", 2, receives_default, "gboolean");
  gtk_widget_set_receives_default((GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0), (gboolean)lg_boolean(receives_default));
  return(lg_false);
}

static s7_pointer lg_gtk_widget_get_receives_default(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_get_receives_default "gboolean gtk_widget_get_receives_default(GtkWidget* widget)"
  s7_pointer widget;
  widget = s7_car(args);
  return(s7_make_boolean(sc, gtk_widget_get_receives_default((GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0))));
}

static s7_pointer lg_gtk_dialog_get_widget_for_response(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_dialog_get_widget_for_response "GtkWidget* gtk_dialog_get_widget_for_response(GtkDialog* dialog, \
gint response_id)"
  s7_pointer _p;
  s7_pointer dialog, response_id;
  _p = args;
  dialog = s7_car(_p); _p = s7_cdr(_p);
  response_id = s7_car(_p);
  if (!s7_is_integer(response_id)) s7_wrong_type_arg_error(sc, "gtk_dialog_get_widget_for_response", 2, response_id, "gint");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_dialog_get_widget_for_response((GtkDialog*)s7_c_pointer_with_type(sc, dialog, GtkDialog__sym, __func__, 0), (gint)s7_integer(response_id))));
}

static s7_pointer lg_gtk_spinner_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_spinner_new "GtkWidget* gtk_spinner_new( void)"
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_spinner_new()));
}

static s7_pointer lg_gtk_spinner_start(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_spinner_start "void gtk_spinner_start(GtkSpinner* spinner)"
  s7_pointer spinner;
  spinner = s7_car(args);
  gtk_spinner_start((GtkSpinner*)s7_c_pointer_with_type(sc, spinner, GtkSpinner__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_spinner_stop(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_spinner_stop "void gtk_spinner_stop(GtkSpinner* spinner)"
  s7_pointer spinner;
  spinner = s7_car(args);
  gtk_spinner_stop((GtkSpinner*)s7_c_pointer_with_type(sc, spinner, GtkSpinner__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_cell_renderer_spinner_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_renderer_spinner_new "GtkCellRenderer* gtk_cell_renderer_spinner_new( void)"
  return(lg_make_c_pointer_with_type(sc, GtkCellRenderer__sym, gtk_cell_renderer_spinner_new()));
}

static s7_pointer lg_gtk_notebook_get_action_widget(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_notebook_get_action_widget "GtkWidget* gtk_notebook_get_action_widget(GtkNotebook* notebook, \
GtkPackType pack_type)"
  s7_pointer _p;
  s7_pointer notebook, pack_type;
  _p = args;
  notebook = s7_car(_p); _p = s7_cdr(_p);
  pack_type = s7_car(_p);
  if (!s7_is_integer(pack_type)) s7_wrong_type_arg_error(sc, "gtk_notebook_get_action_widget", 2, pack_type, "GtkPackType");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_notebook_get_action_widget((GtkNotebook*)s7_c_pointer_with_type(sc, notebook, GtkNotebook__sym, __func__, 0), (GtkPackType)s7_integer(pack_type))));
}

static s7_pointer lg_gtk_notebook_set_action_widget(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_notebook_set_action_widget "void gtk_notebook_set_action_widget(GtkNotebook* notebook, \
GtkWidget* widget, GtkPackType pack_type)"
  s7_pointer _p;
  s7_pointer notebook, widget, pack_type;
  _p = args;
  notebook = s7_car(_p); _p = s7_cdr(_p);
  widget = s7_car(_p); _p = s7_cdr(_p);
  pack_type = s7_car(_p);
  if (!s7_is_integer(pack_type)) s7_wrong_type_arg_error(sc, "gtk_notebook_set_action_widget", 3, pack_type, "GtkPackType");
  gtk_notebook_set_action_widget((GtkNotebook*)s7_c_pointer_with_type(sc, notebook, GtkNotebook__sym, __func__, 0), (GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0), (GtkPackType)s7_integer(pack_type));
  return(lg_false);
}

static s7_pointer lg_gtk_window_set_mnemonics_visible(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_window_set_mnemonics_visible "void gtk_window_set_mnemonics_visible(GtkWindow* window, \
gboolean setting)"
  s7_pointer _p;
  s7_pointer window, setting;
  _p = args;
  window = s7_car(_p); _p = s7_cdr(_p);
  setting = s7_car(_p);
  if (!s7_is_boolean(setting)) s7_wrong_type_arg_error(sc, "gtk_window_set_mnemonics_visible", 2, setting, "gboolean");
  gtk_window_set_mnemonics_visible((GtkWindow*)s7_c_pointer_with_type(sc, window, GtkWindow__sym, __func__, 0), (gboolean)lg_boolean(setting));
  return(lg_false);
}

static s7_pointer lg_gtk_window_get_mnemonics_visible(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_window_get_mnemonics_visible "gboolean gtk_window_get_mnemonics_visible(GtkWindow* window)"
  s7_pointer window;
  window = s7_car(args);
  return(s7_make_boolean(sc, gtk_window_get_mnemonics_visible((GtkWindow*)s7_c_pointer_with_type(sc, window, GtkWindow__sym, __func__, 0))));
}

static s7_pointer lg_gtk_range_set_slider_size_fixed(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_range_set_slider_size_fixed "void gtk_range_set_slider_size_fixed(GtkRange* range, gboolean size_fixed)"
  s7_pointer _p;
  s7_pointer range, size_fixed;
  _p = args;
  range = s7_car(_p); _p = s7_cdr(_p);
  size_fixed = s7_car(_p);
  if (!s7_is_boolean(size_fixed)) s7_wrong_type_arg_error(sc, "gtk_range_set_slider_size_fixed", 2, size_fixed, "gboolean");
  gtk_range_set_slider_size_fixed((GtkRange*)s7_c_pointer_with_type(sc, range, GtkRange__sym, __func__, 0), (gboolean)lg_boolean(size_fixed));
  return(lg_false);
}

static s7_pointer lg_gtk_range_get_slider_size_fixed(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_range_get_slider_size_fixed "gboolean gtk_range_get_slider_size_fixed(GtkRange* range)"
  s7_pointer range;
  range = s7_car(args);
  return(s7_make_boolean(sc, gtk_range_get_slider_size_fixed((GtkRange*)s7_c_pointer_with_type(sc, range, GtkRange__sym, __func__, 0))));
}

static s7_pointer lg_gtk_range_get_range_rect(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_range_get_range_rect "void gtk_range_get_range_rect(GtkRange* range, GdkRectangle* range_rect)"
  s7_pointer _p;
  s7_pointer range, range_rect;
  _p = args;
  range = s7_car(_p); _p = s7_cdr(_p);
  range_rect = s7_car(_p);
  gtk_range_get_range_rect((GtkRange*)s7_c_pointer_with_type(sc, range, GtkRange__sym, __func__, 0), (GdkRectangle*)s7_c_pointer_with_type(sc, range_rect, GdkRectangle__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_range_get_slider_range(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_range_get_slider_range "void gtk_range_get_slider_range(GtkRange* range, gint* [slider_start], \
gint* [slider_end])"
  s7_pointer _p;
  s7_pointer range;
  gint ref_slider_start;
  gint ref_slider_end;
  _p = args;
  range = s7_car(_p);
  gtk_range_get_slider_range((GtkRange*)s7_c_pointer_with_type(sc, range, GtkRange__sym, __func__, 0), &ref_slider_start, &ref_slider_end);
    return(s7_list(sc, 2, s7_make_integer(sc, ref_slider_start), s7_make_integer(sc, ref_slider_end)));
}

static s7_pointer lg_gtk_widget_get_realized(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_get_realized "gboolean gtk_widget_get_realized(GtkWidget* widget)"
  s7_pointer widget;
  widget = s7_car(args);
  return(s7_make_boolean(sc, gtk_widget_get_realized((GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0))));
}

static s7_pointer lg_gtk_widget_get_mapped(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_get_mapped "gboolean gtk_widget_get_mapped(GtkWidget* widget)"
  s7_pointer widget;
  widget = s7_car(args);
  return(s7_make_boolean(sc, gtk_widget_get_mapped((GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0))));
}

#if GTK_CHECK_VERSION(3, 0, 0)
static s7_pointer lg_gtk_accessible_get_widget(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_accessible_get_widget "GtkWidget* gtk_accessible_get_widget(GtkAccessible* accessible)"
  s7_pointer accessible;
  accessible = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_accessible_get_widget((GtkAccessible*)s7_c_pointer_with_type(sc, accessible, GtkAccessible__sym, __func__, 0))));
}

static s7_pointer lg_gdk_event_get_device(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_event_get_device "GdkDevice* gdk_event_get_device(GdkEvent* event)"
  s7_pointer event;
  event = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GdkDevice__sym, gdk_event_get_device((GdkEvent*)s7_c_pointer_with_type(sc, event, GdkEvent__sym, __func__, 0))));
}

static s7_pointer lg_gdk_events_get_distance(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_events_get_distance "gboolean gdk_events_get_distance(GdkEvent* event1, GdkEvent* event2, \
gdouble* [distance])"
  s7_pointer _p;
  s7_pointer event1, event2;
  gdouble ref_distance;
  _p = args;
  event1 = s7_car(_p); _p = s7_cdr(_p);
  event2 = s7_car(_p);
  {
    s7_pointer res_ult;
    res_ult = s7_make_boolean(sc, gdk_events_get_distance((GdkEvent*)s7_c_pointer_with_type(sc, event1, GdkEvent__sym, __func__, 0), (GdkEvent*)s7_c_pointer_with_type(sc, event2, GdkEvent__sym, __func__, 0), &ref_distance));
      return(s7_list(sc, 2, res_ult, s7_make_real(sc, ref_distance)));
   }
}

static s7_pointer lg_gdk_events_get_angle(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_events_get_angle "gboolean gdk_events_get_angle(GdkEvent* event1, GdkEvent* event2, gdouble* [angle])"
  s7_pointer _p;
  s7_pointer event1, event2;
  gdouble ref_angle;
  _p = args;
  event1 = s7_car(_p); _p = s7_cdr(_p);
  event2 = s7_car(_p);
  {
    s7_pointer res_ult;
    res_ult = s7_make_boolean(sc, gdk_events_get_angle((GdkEvent*)s7_c_pointer_with_type(sc, event1, GdkEvent__sym, __func__, 0), (GdkEvent*)s7_c_pointer_with_type(sc, event2, GdkEvent__sym, __func__, 0), &ref_angle));
      return(s7_list(sc, 2, res_ult, s7_make_real(sc, ref_angle)));
   }
}

static s7_pointer lg_gdk_events_get_center(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_events_get_center "gboolean gdk_events_get_center(GdkEvent* event1, GdkEvent* event2, \
gdouble* [x], gdouble* [y])"
  s7_pointer _p;
  s7_pointer event1, event2;
  gdouble ref_x;
  gdouble ref_y;
  _p = args;
  event1 = s7_car(_p); _p = s7_cdr(_p);
  event2 = s7_car(_p);
  {
    s7_pointer res_ult;
    res_ult = s7_make_boolean(sc, gdk_events_get_center((GdkEvent*)s7_c_pointer_with_type(sc, event1, GdkEvent__sym, __func__, 0), (GdkEvent*)s7_c_pointer_with_type(sc, event2, GdkEvent__sym, __func__, 0), &ref_x, &ref_y));
      return(s7_list(sc, 3, res_ult, s7_make_real(sc, ref_x), s7_make_real(sc, ref_y)));
   }
}

static s7_pointer lg_gtk_combo_box_popup_for_device(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_combo_box_popup_for_device "void gtk_combo_box_popup_for_device(GtkComboBox* combo_box, \
GdkDevice* device)"
  s7_pointer _p;
  s7_pointer combo_box, device;
  _p = args;
  combo_box = s7_car(_p); _p = s7_cdr(_p);
  device = s7_car(_p);
  gtk_combo_box_popup_for_device((GtkComboBox*)s7_c_pointer_with_type(sc, combo_box, GtkComboBox__sym, __func__, 0), (GdkDevice*)s7_c_pointer_with_type(sc, device, GdkDevice__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_paned_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_paned_new "GtkWidget* gtk_paned_new(GtkOrientation orientation)"
  s7_pointer orientation;
  orientation = s7_car(args);
  if (!s7_is_integer(orientation)) s7_wrong_type_arg_error(sc, "gtk_paned_new", 1, orientation, "GtkOrientation");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_paned_new((GtkOrientation)s7_integer(orientation))));
}

static s7_pointer lg_gtk_scale_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_scale_new "GtkWidget* gtk_scale_new(GtkOrientation orientation, GtkAdjustment* adjustment)"
  s7_pointer _p;
  s7_pointer orientation, adjustment;
  _p = args;
  orientation = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(orientation)) s7_wrong_type_arg_error(sc, "gtk_scale_new", 1, orientation, "GtkOrientation");
  adjustment = s7_car(_p);
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_scale_new((GtkOrientation)s7_integer(orientation), (GtkAdjustment*)s7_c_pointer_with_type(sc, adjustment, GtkAdjustment__sym, __func__, 0))));
}

static s7_pointer lg_gtk_scale_new_with_range(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_scale_new_with_range "GtkWidget* gtk_scale_new_with_range(GtkOrientation orientation, \
gdouble min, gdouble max, gdouble step)"
  s7_pointer _p;
  s7_pointer orientation, min, max, step;
  _p = args;
  orientation = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(orientation)) s7_wrong_type_arg_error(sc, "gtk_scale_new_with_range", 1, orientation, "GtkOrientation");
  min = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(min)) s7_wrong_type_arg_error(sc, "gtk_scale_new_with_range", 2, min, "gdouble");
  max = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(max)) s7_wrong_type_arg_error(sc, "gtk_scale_new_with_range", 3, max, "gdouble");
  step = s7_car(_p);
  if (!s7_is_real(step)) s7_wrong_type_arg_error(sc, "gtk_scale_new_with_range", 4, step, "gdouble");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_scale_new_with_range((GtkOrientation)s7_integer(orientation), (gdouble)s7_real(min), (gdouble)s7_real(max), (gdouble)s7_real(step))));
}

static s7_pointer lg_gtk_scrollbar_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_scrollbar_new "GtkWidget* gtk_scrollbar_new(GtkOrientation orientation, GtkAdjustment* adjustment)"
  s7_pointer _p;
  s7_pointer orientation, adjustment;
  _p = args;
  orientation = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(orientation)) s7_wrong_type_arg_error(sc, "gtk_scrollbar_new", 1, orientation, "GtkOrientation");
  adjustment = s7_car(_p);
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_scrollbar_new((GtkOrientation)s7_integer(orientation), (GtkAdjustment*)s7_c_pointer_with_type(sc, adjustment, GtkAdjustment__sym, __func__, 0))));
}

static s7_pointer lg_gtk_separator_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_separator_new "GtkWidget* gtk_separator_new(GtkOrientation orientation)"
  s7_pointer orientation;
  orientation = s7_car(args);
  if (!s7_is_integer(orientation)) s7_wrong_type_arg_error(sc, "gtk_separator_new", 1, orientation, "GtkOrientation");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_separator_new((GtkOrientation)s7_integer(orientation))));
}

static s7_pointer lg_gtk_widget_device_is_shadowed(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_device_is_shadowed "gboolean gtk_widget_device_is_shadowed(GtkWidget* widget, \
GdkDevice* device)"
  s7_pointer _p;
  s7_pointer widget, device;
  _p = args;
  widget = s7_car(_p); _p = s7_cdr(_p);
  device = s7_car(_p);
  return(s7_make_boolean(sc, gtk_widget_device_is_shadowed((GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0), (GdkDevice*)s7_c_pointer_with_type(sc, device, GdkDevice__sym, __func__, 0))));
}

static s7_pointer lg_gtk_widget_get_support_multidevice(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_get_support_multidevice "gboolean gtk_widget_get_support_multidevice(GtkWidget* widget)"
  s7_pointer widget;
  widget = s7_car(args);
  return(s7_make_boolean(sc, gtk_widget_get_support_multidevice((GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0))));
}

static s7_pointer lg_gtk_widget_set_support_multidevice(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_set_support_multidevice "void gtk_widget_set_support_multidevice(GtkWidget* widget, \
gboolean support_multidevice)"
  s7_pointer _p;
  s7_pointer widget, support_multidevice;
  _p = args;
  widget = s7_car(_p); _p = s7_cdr(_p);
  support_multidevice = s7_car(_p);
  if (!s7_is_boolean(support_multidevice)) s7_wrong_type_arg_error(sc, "gtk_widget_set_support_multidevice", 2, support_multidevice, "gboolean");
  gtk_widget_set_support_multidevice((GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0), (gboolean)lg_boolean(support_multidevice));
  return(lg_false);
}

static s7_pointer lg_gtk_icon_view_get_item_row(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_get_item_row "gint gtk_icon_view_get_item_row(GtkIconView* icon_view, GtkTreePath* path)"
  s7_pointer _p;
  s7_pointer icon_view, path;
  _p = args;
  icon_view = s7_car(_p); _p = s7_cdr(_p);
  path = s7_car(_p);
  return(s7_make_integer(sc, gtk_icon_view_get_item_row((GtkIconView*)s7_c_pointer_with_type(sc, icon_view, GtkIconView__sym, __func__, 0), (GtkTreePath*)s7_c_pointer_with_type(sc, path, GtkTreePath__sym, __func__, 0))));
}

static s7_pointer lg_gtk_icon_view_get_item_column(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_get_item_column "gint gtk_icon_view_get_item_column(GtkIconView* icon_view, \
GtkTreePath* path)"
  s7_pointer _p;
  s7_pointer icon_view, path;
  _p = args;
  icon_view = s7_car(_p); _p = s7_cdr(_p);
  path = s7_car(_p);
  return(s7_make_integer(sc, gtk_icon_view_get_item_column((GtkIconView*)s7_c_pointer_with_type(sc, icon_view, GtkIconView__sym, __func__, 0), (GtkTreePath*)s7_c_pointer_with_type(sc, path, GtkTreePath__sym, __func__, 0))));
}

static s7_pointer lg_gtk_statusbar_remove_all(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_statusbar_remove_all "void gtk_statusbar_remove_all(GtkStatusbar* statusbar, guint context_id)"
  s7_pointer _p;
  s7_pointer statusbar, context_id;
  _p = args;
  statusbar = s7_car(_p); _p = s7_cdr(_p);
  context_id = s7_car(_p);
  if (!s7_is_integer(context_id)) s7_wrong_type_arg_error(sc, "gtk_statusbar_remove_all", 2, context_id, "guint");
  gtk_statusbar_remove_all((GtkStatusbar*)s7_c_pointer_with_type(sc, statusbar, GtkStatusbar__sym, __func__, 0), (guint)s7_integer(context_id));
  return(lg_false);
}

static s7_pointer lg_gtk_window_has_group(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_window_has_group "gboolean gtk_window_has_group(GtkWindow* window)"
  s7_pointer window;
  window = s7_car(args);
  return(s7_make_boolean(sc, gtk_window_has_group((GtkWindow*)s7_c_pointer_with_type(sc, window, GtkWindow__sym, __func__, 0))));
}

static s7_pointer lg_gtk_calendar_mark_day(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_calendar_mark_day "void gtk_calendar_mark_day(GtkCalendar* calendar, guint day)"
  s7_pointer _p;
  s7_pointer calendar, day;
  _p = args;
  calendar = s7_car(_p); _p = s7_cdr(_p);
  day = s7_car(_p);
  if (!s7_is_integer(day)) s7_wrong_type_arg_error(sc, "gtk_calendar_mark_day", 2, day, "guint");
  gtk_calendar_mark_day((GtkCalendar*)s7_c_pointer_with_type(sc, calendar, GtkCalendar__sym, __func__, 0), (guint)s7_integer(day));
  return(lg_false);
}

static s7_pointer lg_gtk_calendar_unmark_day(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_calendar_unmark_day "void gtk_calendar_unmark_day(GtkCalendar* calendar, guint day)"
  s7_pointer _p;
  s7_pointer calendar, day;
  _p = args;
  calendar = s7_car(_p); _p = s7_cdr(_p);
  day = s7_car(_p);
  if (!s7_is_integer(day)) s7_wrong_type_arg_error(sc, "gtk_calendar_unmark_day", 2, day, "guint");
  gtk_calendar_unmark_day((GtkCalendar*)s7_c_pointer_with_type(sc, calendar, GtkCalendar__sym, __func__, 0), (guint)s7_integer(day));
  return(lg_false);
}

static s7_pointer lg_gtk_accessible_set_widget(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_accessible_set_widget "void gtk_accessible_set_widget(GtkAccessible* accessible, GtkWidget* widget)"
  s7_pointer _p;
  s7_pointer accessible, widget;
  _p = args;
  accessible = s7_car(_p); _p = s7_cdr(_p);
  widget = s7_car(_p);
  gtk_accessible_set_widget((GtkAccessible*)s7_c_pointer_with_type(sc, accessible, GtkAccessible__sym, __func__, 0), (GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_message_dialog_get_message_area(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_message_dialog_get_message_area "GtkWidget* gtk_message_dialog_get_message_area(GtkMessageDialog* message_dialog)"
  s7_pointer message_dialog;
  message_dialog = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_message_dialog_get_message_area((GtkMessageDialog*)s7_c_pointer_with_type(sc, message_dialog, GtkMessageDialog__sym, __func__, 0))));
}

static s7_pointer lg_gdk_pango_layout_line_get_clip_region(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_pango_layout_line_get_clip_region "cairo_region_t* gdk_pango_layout_line_get_clip_region(PangoLayoutLine* line, \
gint x_origin, gint y_origin, gint* index_ranges, gint n_ranges)"
  s7_pointer _p;
  s7_pointer line, x_origin, y_origin, index_ranges, n_ranges;
  _p = args;
  line = s7_car(_p); _p = s7_cdr(_p);
  x_origin = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(x_origin)) s7_wrong_type_arg_error(sc, "gdk_pango_layout_line_get_clip_region", 2, x_origin, "gint");
  y_origin = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(y_origin)) s7_wrong_type_arg_error(sc, "gdk_pango_layout_line_get_clip_region", 3, y_origin, "gint");
  index_ranges = s7_car(_p); _p = s7_cdr(_p);
  n_ranges = s7_car(_p);
  if (!s7_is_integer(n_ranges)) s7_wrong_type_arg_error(sc, "gdk_pango_layout_line_get_clip_region", 5, n_ranges, "gint");
  return(lg_make_c_pointer_with_type(sc, cairo_region_t__sym, gdk_pango_layout_line_get_clip_region((PangoLayoutLine*)s7_c_pointer_with_type(sc, line, PangoLayoutLine__sym, __func__, 0), (gint)s7_integer(x_origin), (gint)s7_integer(y_origin), (gint*)s7_c_pointer_with_type(sc, index_ranges, gint__sym, __func__, 0), (gint)s7_integer(n_ranges))));
}

static s7_pointer lg_gdk_pango_layout_get_clip_region(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_pango_layout_get_clip_region "cairo_region_t* gdk_pango_layout_get_clip_region(PangoLayout* layout, \
gint x_origin, gint y_origin, gint* index_ranges, gint n_ranges)"
  s7_pointer _p;
  s7_pointer layout, x_origin, y_origin, index_ranges, n_ranges;
  _p = args;
  layout = s7_car(_p); _p = s7_cdr(_p);
  x_origin = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(x_origin)) s7_wrong_type_arg_error(sc, "gdk_pango_layout_get_clip_region", 2, x_origin, "gint");
  y_origin = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(y_origin)) s7_wrong_type_arg_error(sc, "gdk_pango_layout_get_clip_region", 3, y_origin, "gint");
  index_ranges = s7_car(_p); _p = s7_cdr(_p);
  n_ranges = s7_car(_p);
  if (!s7_is_integer(n_ranges)) s7_wrong_type_arg_error(sc, "gdk_pango_layout_get_clip_region", 5, n_ranges, "gint");
  return(lg_make_c_pointer_with_type(sc, cairo_region_t__sym, gdk_pango_layout_get_clip_region((PangoLayout*)s7_c_pointer_with_type(sc, layout, PangoLayout__sym, __func__, 0), (gint)s7_integer(x_origin), (gint)s7_integer(y_origin), (gint*)s7_c_pointer_with_type(sc, index_ranges, gint__sym, __func__, 0), (gint)s7_integer(n_ranges))));
}

static s7_pointer lg_gdk_display_is_closed(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_display_is_closed "gboolean gdk_display_is_closed(GdkDisplay* display)"
  s7_pointer display;
  display = s7_car(args);
  return(s7_make_boolean(sc, gdk_display_is_closed((GdkDisplay*)s7_c_pointer_with_type(sc, display, GdkDisplay__sym, __func__, 0))));
}

static s7_pointer lg_gtk_calendar_get_day_is_marked(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_calendar_get_day_is_marked "gboolean gtk_calendar_get_day_is_marked(GtkCalendar* calendar, \
guint day)"
  s7_pointer _p;
  s7_pointer calendar, day;
  _p = args;
  calendar = s7_car(_p); _p = s7_cdr(_p);
  day = s7_car(_p);
  if (!s7_is_integer(day)) s7_wrong_type_arg_error(sc, "gtk_calendar_get_day_is_marked", 2, day, "guint");
  return(s7_make_boolean(sc, gtk_calendar_get_day_is_marked((GtkCalendar*)s7_c_pointer_with_type(sc, calendar, GtkCalendar__sym, __func__, 0), (guint)s7_integer(day))));
}

static s7_pointer lg_gtk_progress_bar_set_inverted(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_progress_bar_set_inverted "void gtk_progress_bar_set_inverted(GtkProgressBar* pbar, gboolean inverted)"
  s7_pointer _p;
  s7_pointer pbar, inverted;
  _p = args;
  pbar = s7_car(_p); _p = s7_cdr(_p);
  inverted = s7_car(_p);
  if (!s7_is_boolean(inverted)) s7_wrong_type_arg_error(sc, "gtk_progress_bar_set_inverted", 2, inverted, "gboolean");
  gtk_progress_bar_set_inverted((GtkProgressBar*)s7_c_pointer_with_type(sc, pbar, GtkProgressBar__sym, __func__, 0), (gboolean)lg_boolean(inverted));
  return(lg_false);
}

static s7_pointer lg_gtk_progress_bar_get_inverted(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_progress_bar_get_inverted "gboolean gtk_progress_bar_get_inverted(GtkProgressBar* pbar)"
  s7_pointer pbar;
  pbar = s7_car(args);
  return(s7_make_boolean(sc, gtk_progress_bar_get_inverted((GtkProgressBar*)s7_c_pointer_with_type(sc, pbar, GtkProgressBar__sym, __func__, 0))));
}

static s7_pointer lg_gtk_radio_button_join_group(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_radio_button_join_group "void gtk_radio_button_join_group(GtkRadioButton* radio_button, \
GtkRadioButton* group_source)"
  s7_pointer _p;
  s7_pointer radio_button, group_source;
  _p = args;
  radio_button = s7_car(_p); _p = s7_cdr(_p);
  group_source = s7_car(_p);
  gtk_radio_button_join_group((GtkRadioButton*)s7_c_pointer_with_type(sc, radio_button, GtkRadioButton__sym, __func__, 0), (GtkRadioButton*)s7_c_pointer_with_type(sc, group_source, GtkRadioButton__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_adjustment_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_adjustment_new "GtkAdjustment* gtk_adjustment_new(gdouble value, gdouble lower, gdouble upper, \
gdouble step_increment, gdouble page_increment, gdouble page_size)"
  s7_pointer _p;
  s7_pointer value, lower, upper, step_increment, page_increment, page_size;
  _p = args;
  value = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(value)) s7_wrong_type_arg_error(sc, "gtk_adjustment_new", 1, value, "gdouble");
  lower = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(lower)) s7_wrong_type_arg_error(sc, "gtk_adjustment_new", 2, lower, "gdouble");
  upper = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(upper)) s7_wrong_type_arg_error(sc, "gtk_adjustment_new", 3, upper, "gdouble");
  step_increment = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(step_increment)) s7_wrong_type_arg_error(sc, "gtk_adjustment_new", 4, step_increment, "gdouble");
  page_increment = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(page_increment)) s7_wrong_type_arg_error(sc, "gtk_adjustment_new", 5, page_increment, "gdouble");
  page_size = s7_car(_p);
  if (!s7_is_real(page_size)) s7_wrong_type_arg_error(sc, "gtk_adjustment_new", 6, page_size, "gdouble");
  return(lg_make_c_pointer_with_type(sc, GtkAdjustment__sym, gtk_adjustment_new((gdouble)s7_real(value), (gdouble)s7_real(lower), (gdouble)s7_real(upper), (gdouble)s7_real(step_increment), (gdouble)s7_real(page_increment), (gdouble)s7_real(page_size))));
}

static s7_pointer lg_gtk_icon_view_create_drag_icon(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_create_drag_icon "cairo_surface_t* gtk_icon_view_create_drag_icon(GtkIconView* icon_view, \
GtkTreePath* path)"
  s7_pointer _p;
  s7_pointer icon_view, path;
  _p = args;
  icon_view = s7_car(_p); _p = s7_cdr(_p);
  path = s7_car(_p);
  return(lg_make_c_pointer_with_type(sc, cairo_surface_t__sym, gtk_icon_view_create_drag_icon((GtkIconView*)s7_c_pointer_with_type(sc, icon_view, GtkIconView__sym, __func__, 0), (GtkTreePath*)s7_c_pointer_with_type(sc, path, GtkTreePath__sym, __func__, 0))));
}

static s7_pointer lg_gtk_tree_view_create_row_drag_icon(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_create_row_drag_icon "cairo_surface_t* gtk_tree_view_create_row_drag_icon(GtkTreeView* tree_view, \
GtkTreePath* path)"
  s7_pointer _p;
  s7_pointer tree_view, path;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  path = s7_car(_p);
  return(lg_make_c_pointer_with_type(sc, cairo_surface_t__sym, gtk_tree_view_create_row_drag_icon((GtkTreeView*)s7_c_pointer_with_type(sc, tree_view, GtkTreeView__sym, __func__, 0), (GtkTreePath*)s7_c_pointer_with_type(sc, path, GtkTreePath__sym, __func__, 0))));
}

static s7_pointer lg_gdk_cairo_region_create_from_surface(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_cairo_region_create_from_surface "cairo_region_t* gdk_cairo_region_create_from_surface(cairo_surface_t* surface)"
  s7_pointer surface;
  surface = s7_car(args);
  return(lg_make_c_pointer_with_type(sc, cairo_region_t__sym, gdk_cairo_region_create_from_surface((cairo_surface_t*)s7_c_pointer_with_type(sc, surface, cairo_surface_t__sym, __func__, 0))));
}

static s7_pointer lg_gtk_cell_renderer_get_request_mode(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_renderer_get_request_mode "GtkSizeRequestMode gtk_cell_renderer_get_request_mode(GtkCellRenderer* cell)"
  s7_pointer cell;
  cell = s7_car(args);
  return(s7_make_integer(sc, gtk_cell_renderer_get_request_mode((GtkCellRenderer*)s7_c_pointer_with_type(sc, cell, GtkCellRenderer__sym, __func__, 0))));
}

static s7_pointer lg_gtk_cell_renderer_get_preferred_width(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_renderer_get_preferred_width "void gtk_cell_renderer_get_preferred_width(GtkCellRenderer* cell, \
GtkWidget* widget, gint* [minimum_size], gint* [natural_size])"
  s7_pointer _p;
  s7_pointer cell, widget;
  gint ref_minimum_size;
  gint ref_natural_size;
  _p = args;
  cell = s7_car(_p); _p = s7_cdr(_p);
  widget = s7_car(_p);
  gtk_cell_renderer_get_preferred_width((GtkCellRenderer*)s7_c_pointer_with_type(sc, cell, GtkCellRenderer__sym, __func__, 0), (GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0), &ref_minimum_size, &ref_natural_size);
    return(s7_list(sc, 2, s7_make_integer(sc, ref_minimum_size), s7_make_integer(sc, ref_natural_size)));
}

static s7_pointer lg_gtk_cell_renderer_get_preferred_height_for_width(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_renderer_get_preferred_height_for_width "void gtk_cell_renderer_get_preferred_height_for_width(GtkCellRenderer* cell, \
GtkWidget* widget, gint width, gint* [minimum_height], gint* [natural_height])"
  s7_pointer _p;
  s7_pointer cell, widget, width;
  gint ref_minimum_height;
  gint ref_natural_height;
  _p = args;
  cell = s7_car(_p); _p = s7_cdr(_p);
  widget = s7_car(_p); _p = s7_cdr(_p);
  width = s7_car(_p);
  if (!s7_is_integer(width)) s7_wrong_type_arg_error(sc, "gtk_cell_renderer_get_preferred_height_for_width", 3, width, "gint");
  gtk_cell_renderer_get_preferred_height_for_width((GtkCellRenderer*)s7_c_pointer_with_type(sc, cell, GtkCellRenderer__sym, __func__, 0), (GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0), (gint)s7_integer(width), &ref_minimum_height, &ref_natural_height);
    return(s7_list(sc, 2, s7_make_integer(sc, ref_minimum_height), s7_make_integer(sc, ref_natural_height)));
}

static s7_pointer lg_gtk_cell_renderer_get_preferred_height(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_renderer_get_preferred_height "void gtk_cell_renderer_get_preferred_height(GtkCellRenderer* cell, \
GtkWidget* widget, gint* [minimum_size], gint* [natural_size])"
  s7_pointer _p;
  s7_pointer cell, widget;
  gint ref_minimum_size;
  gint ref_natural_size;
  _p = args;
  cell = s7_car(_p); _p = s7_cdr(_p);
  widget = s7_car(_p);
  gtk_cell_renderer_get_preferred_height((GtkCellRenderer*)s7_c_pointer_with_type(sc, cell, GtkCellRenderer__sym, __func__, 0), (GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0), &ref_minimum_size, &ref_natural_size);
    return(s7_list(sc, 2, s7_make_integer(sc, ref_minimum_size), s7_make_integer(sc, ref_natural_size)));
}

static s7_pointer lg_gtk_cell_renderer_get_preferred_width_for_height(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_renderer_get_preferred_width_for_height "void gtk_cell_renderer_get_preferred_width_for_height(GtkCellRenderer* cell, \
GtkWidget* widget, gint height, gint* [minimum_width], gint* [natural_width])"
  s7_pointer _p;
  s7_pointer cell, widget, height;
  gint ref_minimum_width;
  gint ref_natural_width;
  _p = args;
  cell = s7_car(_p); _p = s7_cdr(_p);
  widget = s7_car(_p); _p = s7_cdr(_p);
  height = s7_car(_p);
  if (!s7_is_integer(height)) s7_wrong_type_arg_error(sc, "gtk_cell_renderer_get_preferred_width_for_height", 3, height, "gint");
  gtk_cell_renderer_get_preferred_width_for_height((GtkCellRenderer*)s7_c_pointer_with_type(sc, cell, GtkCellRenderer__sym, __func__, 0), (GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0), (gint)s7_integer(height), &ref_minimum_width, &ref_natural_width);
    return(s7_list(sc, 2, s7_make_integer(sc, ref_minimum_width), s7_make_integer(sc, ref_natural_width)));
}

static s7_pointer lg_gtk_notebook_set_group_name(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_notebook_set_group_name "void gtk_notebook_set_group_name(GtkNotebook* notebook, gchar* group_name)"
  s7_pointer _p;
  s7_pointer notebook, group_name;
  _p = args;
  notebook = s7_car(_p); _p = s7_cdr(_p);
  group_name = s7_car(_p);
  if (!s7_is_string(group_name)) s7_wrong_type_arg_error(sc, "gtk_notebook_set_group_name", 2, group_name, "gchar*");
  gtk_notebook_set_group_name((GtkNotebook*)s7_c_pointer_with_type(sc, notebook, GtkNotebook__sym, __func__, 0), (const gchar*)s7_string(group_name));
  return(lg_false);
}

static s7_pointer lg_gtk_notebook_get_group_name(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_notebook_get_group_name "gchar* gtk_notebook_get_group_name(GtkNotebook* notebook)"
  s7_pointer notebook;
  notebook = s7_car(args);
    return(s7_make_string(sc, (gchar*)gtk_notebook_get_group_name((GtkNotebook*)s7_c_pointer_with_type(sc, notebook, GtkNotebook__sym, __func__, 0))));
}

static s7_pointer lg_gtk_widget_get_request_mode(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_get_request_mode "GtkSizeRequestMode gtk_widget_get_request_mode(GtkWidget* widget)"
  s7_pointer widget;
  widget = s7_car(args);
  return(s7_make_integer(sc, gtk_widget_get_request_mode((GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0))));
}

static s7_pointer lg_gtk_widget_get_allocated_width(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_get_allocated_width "int gtk_widget_get_allocated_width(GtkWidget* widget)"
  s7_pointer widget;
  widget = s7_car(args);
  return(s7_make_integer(sc, gtk_widget_get_allocated_width((GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0))));
}

static s7_pointer lg_gtk_widget_get_allocated_height(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_get_allocated_height "int gtk_widget_get_allocated_height(GtkWidget* widget)"
  s7_pointer widget;
  widget = s7_car(args);
  return(s7_make_integer(sc, gtk_widget_get_allocated_height((GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0))));
}

static s7_pointer lg_gtk_widget_get_halign(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_get_halign "GtkAlign gtk_widget_get_halign(GtkWidget* widget)"
  s7_pointer widget;
  widget = s7_car(args);
  return(s7_make_integer(sc, gtk_widget_get_halign((GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0))));
}

static s7_pointer lg_gtk_widget_set_halign(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_set_halign "void gtk_widget_set_halign(GtkWidget* widget, GtkAlign align)"
  s7_pointer _p;
  s7_pointer widget, align;
  _p = args;
  widget = s7_car(_p); _p = s7_cdr(_p);
  align = s7_car(_p);
  if (!s7_is_integer(align)) s7_wrong_type_arg_error(sc, "gtk_widget_set_halign", 2, align, "GtkAlign");
  gtk_widget_set_halign((GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0), (GtkAlign)s7_integer(align));
  return(lg_false);
}

static s7_pointer lg_gtk_widget_get_valign(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_get_valign "GtkAlign gtk_widget_get_valign(GtkWidget* widget)"
  s7_pointer widget;
  widget = s7_car(args);
  return(s7_make_integer(sc, gtk_widget_get_valign((GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0))));
}

static s7_pointer lg_gtk_widget_set_valign(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_set_valign "void gtk_widget_set_valign(GtkWidget* widget, GtkAlign align)"
  s7_pointer _p;
  s7_pointer widget, align;
  _p = args;
  widget = s7_car(_p); _p = s7_cdr(_p);
  align = s7_car(_p);
  if (!s7_is_integer(align)) s7_wrong_type_arg_error(sc, "gtk_widget_set_valign", 2, align, "GtkAlign");
  gtk_widget_set_valign((GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0), (GtkAlign)s7_integer(align));
  return(lg_false);
}

static s7_pointer lg_gtk_widget_get_margin_top(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_get_margin_top "gint gtk_widget_get_margin_top(GtkWidget* widget)"
  s7_pointer widget;
  widget = s7_car(args);
  return(s7_make_integer(sc, gtk_widget_get_margin_top((GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0))));
}

static s7_pointer lg_gtk_widget_set_margin_top(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_set_margin_top "void gtk_widget_set_margin_top(GtkWidget* widget, gint margin)"
  s7_pointer _p;
  s7_pointer widget, margin;
  _p = args;
  widget = s7_car(_p); _p = s7_cdr(_p);
  margin = s7_car(_p);
  if (!s7_is_integer(margin)) s7_wrong_type_arg_error(sc, "gtk_widget_set_margin_top", 2, margin, "gint");
  gtk_widget_set_margin_top((GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0), (gint)s7_integer(margin));
  return(lg_false);
}

static s7_pointer lg_gtk_widget_get_margin_bottom(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_get_margin_bottom "gint gtk_widget_get_margin_bottom(GtkWidget* widget)"
  s7_pointer widget;
  widget = s7_car(args);
  return(s7_make_integer(sc, gtk_widget_get_margin_bottom((GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0))));
}

static s7_pointer lg_gtk_widget_set_margin_bottom(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_set_margin_bottom "void gtk_widget_set_margin_bottom(GtkWidget* widget, gint margin)"
  s7_pointer _p;
  s7_pointer widget, margin;
  _p = args;
  widget = s7_car(_p); _p = s7_cdr(_p);
  margin = s7_car(_p);
  if (!s7_is_integer(margin)) s7_wrong_type_arg_error(sc, "gtk_widget_set_margin_bottom", 2, margin, "gint");
  gtk_widget_set_margin_bottom((GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0), (gint)s7_integer(margin));
  return(lg_false);
}

static s7_pointer lg_gtk_combo_box_new_with_entry(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_combo_box_new_with_entry "GtkWidget* gtk_combo_box_new_with_entry( void)"
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_combo_box_new_with_entry()));
}

static s7_pointer lg_gtk_combo_box_get_has_entry(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_combo_box_get_has_entry "gboolean gtk_combo_box_get_has_entry(GtkComboBox* combo_box)"
  s7_pointer combo_box;
  combo_box = s7_car(args);
  return(s7_make_boolean(sc, gtk_combo_box_get_has_entry((GtkComboBox*)s7_c_pointer_with_type(sc, combo_box, GtkComboBox__sym, __func__, 0))));
}

static s7_pointer lg_gtk_combo_box_set_entry_text_column(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_combo_box_set_entry_text_column "void gtk_combo_box_set_entry_text_column(GtkComboBox* combo_box, \
gint text_column)"
  s7_pointer _p;
  s7_pointer combo_box, text_column;
  _p = args;
  combo_box = s7_car(_p); _p = s7_cdr(_p);
  text_column = s7_car(_p);
  if (!s7_is_integer(text_column)) s7_wrong_type_arg_error(sc, "gtk_combo_box_set_entry_text_column", 2, text_column, "gint");
  gtk_combo_box_set_entry_text_column((GtkComboBox*)s7_c_pointer_with_type(sc, combo_box, GtkComboBox__sym, __func__, 0), (gint)s7_integer(text_column));
  return(lg_false);
}

static s7_pointer lg_gtk_combo_box_get_entry_text_column(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_combo_box_get_entry_text_column "gint gtk_combo_box_get_entry_text_column(GtkComboBox* combo_box)"
  s7_pointer combo_box;
  combo_box = s7_car(args);
  return(s7_make_integer(sc, gtk_combo_box_get_entry_text_column((GtkComboBox*)s7_c_pointer_with_type(sc, combo_box, GtkComboBox__sym, __func__, 0))));
}

static s7_pointer lg_gtk_widget_get_hexpand(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_get_hexpand "gboolean gtk_widget_get_hexpand(GtkWidget* widget)"
  s7_pointer widget;
  widget = s7_car(args);
  return(s7_make_boolean(sc, gtk_widget_get_hexpand((GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0))));
}

static s7_pointer lg_gtk_widget_set_hexpand(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_set_hexpand "void gtk_widget_set_hexpand(GtkWidget* widget, gboolean expand)"
  s7_pointer _p;
  s7_pointer widget, expand;
  _p = args;
  widget = s7_car(_p); _p = s7_cdr(_p);
  expand = s7_car(_p);
  if (!s7_is_boolean(expand)) s7_wrong_type_arg_error(sc, "gtk_widget_set_hexpand", 2, expand, "gboolean");
  gtk_widget_set_hexpand((GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0), (gboolean)lg_boolean(expand));
  return(lg_false);
}

static s7_pointer lg_gtk_widget_get_hexpand_set(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_get_hexpand_set "gboolean gtk_widget_get_hexpand_set(GtkWidget* widget)"
  s7_pointer widget;
  widget = s7_car(args);
  return(s7_make_boolean(sc, gtk_widget_get_hexpand_set((GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0))));
}

static s7_pointer lg_gtk_widget_set_hexpand_set(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_set_hexpand_set "void gtk_widget_set_hexpand_set(GtkWidget* widget, gboolean set)"
  s7_pointer _p;
  s7_pointer widget, set;
  _p = args;
  widget = s7_car(_p); _p = s7_cdr(_p);
  set = s7_car(_p);
  if (!s7_is_boolean(set)) s7_wrong_type_arg_error(sc, "gtk_widget_set_hexpand_set", 2, set, "gboolean");
  gtk_widget_set_hexpand_set((GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0), (gboolean)lg_boolean(set));
  return(lg_false);
}

static s7_pointer lg_gtk_widget_get_vexpand(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_get_vexpand "gboolean gtk_widget_get_vexpand(GtkWidget* widget)"
  s7_pointer widget;
  widget = s7_car(args);
  return(s7_make_boolean(sc, gtk_widget_get_vexpand((GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0))));
}

static s7_pointer lg_gtk_widget_set_vexpand(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_set_vexpand "void gtk_widget_set_vexpand(GtkWidget* widget, gboolean expand)"
  s7_pointer _p;
  s7_pointer widget, expand;
  _p = args;
  widget = s7_car(_p); _p = s7_cdr(_p);
  expand = s7_car(_p);
  if (!s7_is_boolean(expand)) s7_wrong_type_arg_error(sc, "gtk_widget_set_vexpand", 2, expand, "gboolean");
  gtk_widget_set_vexpand((GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0), (gboolean)lg_boolean(expand));
  return(lg_false);
}

static s7_pointer lg_gtk_widget_get_vexpand_set(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_get_vexpand_set "gboolean gtk_widget_get_vexpand_set(GtkWidget* widget)"
  s7_pointer widget;
  widget = s7_car(args);
  return(s7_make_boolean(sc, gtk_widget_get_vexpand_set((GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0))));
}

static s7_pointer lg_gtk_widget_set_vexpand_set(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_set_vexpand_set "void gtk_widget_set_vexpand_set(GtkWidget* widget, gboolean set)"
  s7_pointer _p;
  s7_pointer widget, set;
  _p = args;
  widget = s7_car(_p); _p = s7_cdr(_p);
  set = s7_car(_p);
  if (!s7_is_boolean(set)) s7_wrong_type_arg_error(sc, "gtk_widget_set_vexpand_set", 2, set, "gboolean");
  gtk_widget_set_vexpand_set((GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0), (gboolean)lg_boolean(set));
  return(lg_false);
}

static s7_pointer lg_gtk_widget_compute_expand(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_compute_expand "gboolean gtk_widget_compute_expand(GtkWidget* widget, GtkOrientation orientation)"
  s7_pointer _p;
  s7_pointer widget, orientation;
  _p = args;
  widget = s7_car(_p); _p = s7_cdr(_p);
  orientation = s7_car(_p);
  if (!s7_is_integer(orientation)) s7_wrong_type_arg_error(sc, "gtk_widget_compute_expand", 2, orientation, "GtkOrientation");
  return(s7_make_boolean(sc, gtk_widget_compute_expand((GtkWidget*)s7_c_pointer_with_type(sc, widget, GtkWidget__sym, __func__, 0), (GtkOrientation)s7_integer(orientation))));
}

static s7_pointer lg_gtk_combo_box_text_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_combo_box_text_new "GtkWidget* gtk_combo_box_text_new( void)"
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_combo_box_text_new()));
}

static s7_pointer lg_gtk_combo_box_text_new_with_entry(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_combo_box_text_new_with_entry "GtkWidget* gtk_combo_box_text_new_with_entry( void)"
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_combo_box_text_new_with_entry()));
}

static s7_pointer lg_gtk_combo_box_text_append_text(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_combo_box_text_append_text "void gtk_combo_box_text_append_text(GtkComboBoxText* combo_box, \
gchar* text)"
  s7_pointer _p;
  s7_pointer combo_box, text;
  _p = args;
  combo_box = s7_car(_p); _p = s7_cdr(_p);
  text = s7_car(_p);
  if (!s7_is_string(text)) s7_wrong_type_arg_error(sc, "gtk_combo_box_text_append_text", 2, text, "gchar*");
  gtk_combo_box_text_append_text((GtkComboBoxText*)s7_c_pointer_with_type(sc, combo_box, GtkComboBoxText__sym, __func__, 0), (const gchar*)s7_string(text));
  return(lg_false);
}

static s7_pointer lg_gtk_combo_box_text_insert_text(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_combo_box_text_insert_text "void gtk_combo_box_text_insert_text(GtkComboBoxText* combo_box, \
gint position, gchar* text)"
  s7_pointer _p;
  s7_pointer combo_box, position, text;
  _p = args;
  combo_box = s7_car(_p); _p = s7_cdr(_p);
  position = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(position)) s7_wrong_type_arg_error(sc, "gtk_combo_box_text_insert_text", 2, position, "gint");
  text = s7_car(_p);
  if (!s7_is_string(text)) s7_wrong_type_arg_error(sc, "gtk_combo_box_text_insert_text", 3, text, "gchar*");
  gtk_combo_box_text_insert_text((GtkComboBoxText*)s7_c_pointer_with_type(sc, combo_box, GtkComboBoxText__sym, __func__, 0), (gint)s7_integer(position), (const gchar*)s7_string(text));
  return(lg_false);
}

static s7_pointer lg_gtk_combo_box_text_prepend_text(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_combo_box_text_prepend_text "void gtk_combo_box_text_prepend_text(GtkComboBoxText* combo_box, \
gchar* text)"
  s7_pointer _p;
  s7_pointer combo_box, text;
  _p = args;
  combo_box = s7_car(_p); _p = s7_cdr(_p);
  text = s7_car(_p);
  if (!s7_is_string(text)) s7_wrong_type_arg_error(sc, "gtk_combo_box_text_prepend_text", 2, text, "gchar*");
  gtk_combo_box_text_prepend_text((GtkComboBoxText*)s7_c_pointer_with_type(sc, combo_box, GtkComboBoxText__sym, __func__, 0), (const gchar*)s7_string(text));
  return(lg_false);
}

static s7_pointer lg_gtk_combo_box_text_remove(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_combo_box_text_remove "void gtk_combo_box_text_remove(GtkComboBoxText* combo_box, gint position)"
  s7_pointer _p;
  s7_pointer combo_box, position;
  _p = args;
  combo_box = s7_car(_p); _p = s7_cdr(_p);
  position = s7_car(_p);
  if (!s7_is_integer(position)) s7_wrong_type_arg_error(sc, "gtk_combo_box_text_remove", 2, position, "gint");
  gtk_combo_box_text_remove((GtkComboBoxText*)s7_c_pointer_with_type(sc, combo_box, GtkComboBoxText__sym, __func__, 0), (gint)s7_integer(position));
  return(lg_false);
}

static s7_pointer lg_gtk_combo_box_text_get_active_text(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_combo_box_text_get_active_text "gchar* gtk_combo_box_text_get_active_text(GtkComboBoxText* combo_box)"
  s7_pointer combo_box;
  combo_box = s7_car(args);
  return(s7_make_string(sc, gtk_combo_box_text_get_active_text((GtkComboBoxText*)s7_c_pointer_with_type(sc, combo_box, GtkComboBoxText__sym, __func__, 0))));
}

static s7_pointer lg_gdk_cairo_set_source_rgba(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_cairo_set_source_rgba "void gdk_cairo_set_source_rgba(cairo_t* cr, GdkRGBA* rgba)"
  s7_pointer _p;
  s7_pointer cr, rgba;
  _p = args;
  cr = s7_car(_p); _p = s7_cdr(_p);
  rgba = s7_car(_p);
  gdk_cairo_set_source_rgba((cairo_t*)s7_c_pointer_with_type(sc, cr, cairo_t__sym, __func__, 0), (GdkRGBA*)s7_c_pointer_with_type(sc, rgba, GdkRGBA__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_combo_box_text_remove_all(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_combo_box_text_remove_all "void gtk_combo_box_text_remove_all(GtkComboBoxText* combo_box)"
  s7_pointer combo_box;
  combo_box = s7_car(args);
  gtk_combo_box_text_remove_all((GtkComboBoxText*)s7_c_pointer_with_type(sc, combo_box, GtkComboBoxText__sym, __func__, 0));
  return(lg_false);
}

static s7_pointer lg_gtk_combo_box_set_popup_fixed_width(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_combo_box_set_popup_fixed_width "void gtk_combo_box_set_popup_fixed_width(GtkComboBox* combo_box, \
gboolean fixed)"
  s7_pointer _p;
  s7_pointer combo_box, fixed;
  _p = args;
  combo_box = s7_car(_p); _p = s7_cdr(_p);
  fixed = s7_car(_p);
  if (!s7_is_boolean(fixed)) s7_wrong_type_arg_error(sc, "gtk_combo_box_set_popup_fixed_width", 2, fixed, "gboolean");
  gtk_combo_box_set_popup_fixed_width((GtkComboBox*)s7_c_pointer_with_type(sc, combo_box, Gtk