/*********************************************************************
anomsensor_plug.h, distributed as part of Spade v092200.1
Author: James Hoagland, Silicon Defense (hoagland@SiliconDefense.com)
copyright (c) 2000 by Silicon Defense (http://www.silicondefense.com/)
Released under GNU General Public License, see the COPYING file included
with the distribution or http://www.silicondefense.com/spice/ for details.

anomsensor_plug.h is the header file for anomsensor_plug.c.

Please send complaints, kudos, and especially improvements and bugfixes to
hoagland@SiliconDefense.com.  As described in GNU General Public License, no
warranty is expressed for this program.
*********************************************************************/

#ifndef __SPP_ANOMSENSOR_H__
#define __SPP_ANOMSENSOR_H__

#include "snort.h"
#include <netinet/in.h>
#include <signal.h>
#include <math.h>

#define SPP_ANOMSENSOR_ENABLED 1

#define ALMOST_NEVER ((size_t)3999999999)

/* at what size to discard any value in the tree; each observed instances
   adds one but it is multiplied by SCALE_FACTOR every SCALE_FREQ seconds */
/* these values are coordinated to have a half life of 3 days and to have a
   single instance discarded after a little over a week */
#define MIN_NODE_SIZE 0.18
/* the frequency of scaling */
#define SCALE_FREQ ((size_t)14400)
//#define SCALE_FREQ ALMOST_NEVER
/* the amount by which to scale */
#define SCALE_FACTOR 0.96409


typedef struct _ll_double {
	double val;
	struct _ll_double *next;
} ll_double;

typedef struct _dll_double {
	double val;
	struct _dll_double *prev;
	struct _dll_double *next;
} dll_double;

typedef struct _ll_net {
	u_long netaddr;
	u_long netmask;
	struct _ll_net *next;
} ll_net;

/* list of function prototypes for this preprocessor */
void SetupSpade();
void SpadeInit(u_char *);
void ParseSpadeArgs(char *);
void PreprocSpade(Packet *);
void SpadeHomenetInit(u_char *args);
void SpadeStatInit(u_char *args);
void ParseSpadeStatArgs(char *args);
void SpadeThreshlearnInit(u_char *args);
void ParseSpadeThreshlearnArgs(char *args);
void PreprocSpadeThreshlearn(Packet *p);
void SpadeAdaptInit(u_char *args);
void ParseSpadeAdaptArgs(char *args);
void PreprocSpadeAdapt(Packet *p);
void SpadeAdapt2Init(u_char *args);
void ParseSpadeAdapt2Args(char *args);
void PreprocSpadeAdapt2(Packet *p);
void SpadeAdapt3Init(u_char *args);
void ParseSpadeAdapt3Args(char *args);
void PreprocSpadeAdapt3(Packet *p);
void SpadeSurveyInit(u_char *args);
void ParseSpadeSurveyArgs(char *args);
void PreprocSpadeSurvey(Packet *p);
void SpadeCatchSig(int signal,void *arg);
void CleanUpSpade(int);

/* include other functions from anomsensor_plug.c */
ll_net *create_netlist(char *nets[],int count);
void do_adapt();
void do_adapt3();
double calc_new_thresh();
double thresh_from_obslists();
double anom_ave(double a[],int size);
void reset_obslist(int slot);
dll_double *new_dlink(double val);
void free_dlinks(dll_double *start);
ll_double * new_link(double val);
void free_links(ll_double *start);
double survey_ostat(double loc);
int record_maybe_skip(Packet *p);
double calc_anom(valtype val[]);
void record_packet(Packet *p,valtype val[]);
void set_new_threshold(double t);

#endif  /* ! __SPP_ANOMSENSOR_H__ */


/* $Id: anomsensor_plug.h,v 1.4 2000/09/22 17:43:54 jim Exp $ */
