/* $Id$ */
/****************************************************************************
 *
 * Copyright (C) 2005-2012 Sourcefire, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License Version 2 as
 * published by the Free Software Foundation.  You may not use, modify or
 * distribute this program under any other version of the GNU General
 * Public License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 ****************************************************************************/

// @file    active.h
// @author  Russ Combs <rcombs@sourcefire.com>

#ifndef __ACTIVE_H__
#define __ACTIVE_H__

#include "decode.h"
#include "snort.h"

#ifdef ACTIVE_RESPONSE
#include "encode.h"

int Active_Init(SnortConfig*);
int Active_Term(void);

typedef void (*Active_ResponseFunc)(Packet*, void* data);

int Active_QueueReject(void);
int Active_QueueResponse(Active_ResponseFunc, void*);
int Active_ResetQueue(void);

// this must be called on the wire packet and not a
// reassembled packet so that encoding is correct.
int Active_SendResponses(Packet*);
uint64_t Active_GetInjects(void);

// NULL flags implies ENC_FLAG_FWD
void Active_KillSession(Packet*, EncodeFlags*);

void Active_SendReset(Packet*, EncodeFlags);
void Active_SendUnreach(Packet*, EncodeType);
void Active_SendData(Packet*, EncodeFlags, const uint8_t* buf, uint32_t len);

int Active_IsRSTCandidate(const Packet*);
int Active_IsUNRCandidate(const Packet*);

int Active_IsEnabled(void);
void Active_SetEnabled(int on_off);
#endif // ACTIVE_RESPONSE

typedef enum {
    ACTIVE_ALLOW = 0,
    ACTIVE_DROP = 1,
    ACTIVE_WOULD_DROP = 2,
    ACTIVE_FORCE_DROP = 3
} tActiveDrop;
extern tActiveDrop active_drop_pkt;
extern int active_drop_ssn;
#ifdef ACTIVE_RESPONSE
extern int active_have_rsp;
#endif

static inline void Active_Reset (void)
{
    active_drop_pkt = ACTIVE_ALLOW;
    active_drop_ssn = 0;
#ifdef ACTIVE_RESPONSE
    active_have_rsp = 0;
#endif
}

static inline void Active_ForceDropPacket (void)
{
    active_drop_pkt = ACTIVE_FORCE_DROP;
}

static inline void Active_DropPacket (void)
{
    if ( active_drop_pkt != ACTIVE_FORCE_DROP )
    {
        if ( ScInlineMode() )
        {
            active_drop_pkt = ACTIVE_DROP;
        }
        else if (ScInlineTestMode())
        {
            active_drop_pkt = ACTIVE_WOULD_DROP;
        }
    }
}

static inline void Active_DropSession (void)
{
    active_drop_ssn = 1;
    Active_DropPacket();
}

static inline int Active_PacketWouldBeDropped (void)
{
    return (active_drop_pkt == ACTIVE_WOULD_DROP );
}

static inline int Active_PacketForceDropped (void)
{
    return (active_drop_pkt == ACTIVE_FORCE_DROP );
}

static inline int Active_PacketWasDropped (void)
{
    return ( active_drop_pkt == ACTIVE_DROP ) || Active_PacketForceDropped();
}

static inline int Active_SessionWasDropped (void)
{
    return ( active_drop_ssn != 0 );
}

#ifdef ACTIVE_RESPONSE
static inline int Active_ResponseQueued (void)
{
    return ( active_have_rsp != 0 );
}
#endif

// drops current session with active response invoked
// for rules with action = drop | sdrop | reject
int Active_DropAction(Packet*);

// drops current session w/o active response invoked
// for rules with custom response = resp3 | react
int Active_IgnoreSession(Packet*);

// force drops the current session w/o active response invoked
// ignores policy/inline test mode and treat drop as alert
int Active_ForceDropAction(Packet *p);

// force drops the current session with active response invoked
// ignores policy/inline test mode and treat drop as alert
int Active_ForceDropResetAction(Packet *p);

#endif // __ACTIVE_H__

