<?

/**************************************************************************
 * SNUI password changing script.
 *
 * Copyright (C) 2002, Matthew Palmer.  Released under the GPL version 2.
 * You should have received a copy of this licence with this software, if not
 * see http://www.fsf.org/copyleft/gpl.html for a full copy of the licence.
 */

// "$Id$"
 
require_once("/etc/snui/snui_admin.conf");
require_once("phtml/misc.inc");
require_once("phtml/html.inc");
require_once("phtml/form.inc");
require_once("phtml/table.inc");
require_once("phtml/log.inc");

require_once("passwd.inc");

log_open("MAINLOG", "$SNUI_LOG_DIR/snui_admin.log", "chpass");

echo html_header("SNUI: Change Password");

$reqd = array("username", "oldpass", "newpass", "newpass2");
if (!all_reqd($reqd)) {
	echo html_h1("Changing Password");
	
	echo form_header("chpass.php");
	echo table_header();
	echo table_row("<b>Username:</b> ", form_textbox("username", NULL, 12));
	echo table_row("<b>Old Password:</b> ", form_password("oldpass", NULL));
	echo table_row("<b>New Password:</b> ", form_password("newpass", NULL));
	echo table_row("<b>Confirm New Password:</b> ", form_password("newpass2", NULL));
	echo table_row("", form_submit("Update Info"));
	echo form_footer();

	echo html_footer();
	
	return;
}

if ($HTTP_POST_VARS["newpass"] != $HTTP_POST_VARS["newpass2"]) {
	echo html_h1("Password NOT changed");
	echo "<p>You failed to correctly confirm your password.  Use the
		button below to try again.\n";
	
	echo button_try_again("chpass.php");
	
	echo html_footer();

	return;
}

$user_list = read_auth($SNUI_AUTHDB);
if (is_string($user_list)) {
	echo "<p>A serious error occured while processing your request.
		Please inform the administrator.\n";

	logmsg("MAINLOG", "Failed to open auth DB $SNUI_AUTHDB: $user_list");

	return;
}

for ($i = 0; $i < count($user_list); $i++) {
	if ($user_list[$i]["username"] == $HTTP_POST_VARS["username"]) {
		if (md5($HTTP_POST_VARS["oldpass"]) != $user_list[$i]["password"]) {
			echo html_h1("Password NOT Changed");
			echo "<p>You failed to enter your old password
				correctly.  Please use the button below to
				go back and try again.\n";
			
			echo button_try_again("chpass.php");
			
			echo html_footer();
			
			return;
		}
		
		$user_list[$i]["password"] = md5($HTTP_POST_VARS["newpass"]);
		
		$rv = write_passwd($SNUI_AUTHDB);
		if (is_string($rv)) {
			echo "<p>A serious error occured while processing your
				request.  Please inform the administrator.\n";
			
			logmsg("MAINLOG", "Failed to update auth DB $SNUI_AUTHDB: $rv");
			
			return;
		}
		
		echo html_h1("Password changed");
		echo "<p>Your password has now been changed.  You will need to
			use your new password from now on.\n";
		
		return;
	}
}

echo "<p>A serious error occured while processing your request.  Please inform
	the administrator.\n";

logmsg("MAINLOG", "User [".$HTTP_POST_VARS["username"]."] not found.");









