<?

/**************************************************************************
 * SNUI administrative password changing script.
 *
 * Copyright (C) 2002, Matthew Palmer.  Released under the GPL version 2.
 * You should have received a copy of this licence with this software, if not
 * see http://www.fsf.org/copyleft/gpl.html for a full copy of the licence.
 */

// "$Id$"
 
require_once("/etc/snui/snui_admin.conf");
require_once("phtml/misc.inc");
require_once("phtml/html.inc");
require_once("phtml/form.inc");
require_once("phtml/table.inc");
require_once("phtml/log.inc");

require_once("passwd.inc");

log_open("MAINLOG", "$SNUI_LOG_DIR/snui_admin.log", "edituser");

echo html_header("SNUI: Edit User");

$reqd = array("auth_username", "auth_password", "username", "newpass", 
	"newpass_confirm");

if (!all_reqd($reqd)) {
	echo html_h1("Editing User Details");
	
	echo form_header("edituser.php");
	echo "<p>Enter your administrative details in the boxes below.\n";
	echo table_header();
	echo table_row("<b>Admin:</b> ", form_textbox("auth_username", NULL, 12));
	echo table_row("<b>Password:</b> ", form_password("auth_password", NULL));
	echo table_footer();
	
	echo "<p>Now enter the username of the person whose details you wish to
		change, along with their new details.";
	echo table_header();
	echo table_row("<b>Username:</b> ", form_textbox("username", NULL, 12));
	echo table_row("<b>New Password:</b> ", form_password("newpass", NULL));
	echo table_row("<b>Confirm New Password:</b> ", form_password("newpass_confirm", NULL));
	echo table_row("", form_submit("Update Info"));
	echo table_footer();
	echo form_footer();

	echo html_footer();
	
	return;
}

if ($HTTP_POST_VARS["newpass"] != $HTTP_POST_VARS["newpass_confirm"]) {
	echo html_h1("Password NOT changed");
	echo "<p>The password was not correctly confirmed.  Use the
		button below to try again.\n";
	
	echo button_try_again("edituser.php");
	
	echo html_footer();

	return;
}

$user_list = read_auth($SNUI_AUTHDB);
if (is_string($user_list)) {
	echo "<p>A serious error occured while processing your request.
		Please inform the administrator.\n";

	logmsg("MAINLOG", "Failed to open auth DB $SNUI_AUTHDB: $user_list");

	return;
}

if (!admin_auth_check($HTTP_POST_VARS["auth_username"], $HTTP_POST_VARS["auth_password"])) {
	echo "<p>You failed to successfully authenticate yourself as an
		administrator.  Please use the button below to go back and try
		again.\n";
	
	echo button_try_again("edituser.php");
	
	echo html_footer();
	
	return;
}


for ($i = 0; $i < count($user_list); $i++) {
	if ($user_list[$i]["username"] == $HTTP_POST_VARS["username"]) {
		$user_list[$i]["password"] = md5($HTTP_POST_VARS["newpass"]);
		
		$rv = write_passwd($SNUI_AUTHDB);
		if (is_string($rv)) {
			echo "<p>A serious error occured while processing your
				request.  Please inform the administrator.\n";
			
			logmsg("MAINLOG", "Failed to update auth DB $SNUI_AUTHDB: $rv");
			
			return;
		}
		
		echo html_h1("User details changed");
		echo "<p>User details have been updated.  The user must use
			their newly entered password from now on.\n";
		
		return;
	}
}

echo "<p>The username you entered was not found in the system.  Please use
	the button below to go back and try again.\n";

echo button_try_again("edituser.php");

logmsg("MAINLOG", "User [".$HTTP_POST_VARS["username"]."] not found.");
