<?

/**************************************************************************
 * Functions to manipulate a password, group or SNUI authentication
 * database.
 *
 * Copyright (C) 2002, Matthew Palmer.  Released under the GPL version 2.
 * You should have received a copy of this licence with this software, if not
 * see http://www.fsf.org/copyleft/gpl.html for a full copy of the licence.
 */

// "$Id$"

function read_passwd($filename)
{
	$fd = fopen($filename, "r");
	if (!$fd) {
		return "There was an error opening the file";
	}
	
	$retval = array();
	while (!feof($fd)) {
		$line = fgets($fd, 65535);
		$line = str_replace("\n", "", $line);
		if ($line == "") {
			continue;
		}
		$fields = split(':', $line);
		$new_field = array();
		$new_field["username"] = $fields[0];
		$new_field["password"] = $fields[1];
		$new_field["uid"] = $fields[2];
		$new_field["gid"] = $fields[3];
		$new_field["gecos"] = $fields[4];
		$new_field["homedir"] = $fields[5];
		$new_field["shell"] = $fields[6];
		$retval[] = $new_field;
	}
	
	fclose($fd);

	return $retval;
}

function write_passwd($filename, $data)
{
	$fd = fopen($filename, "w");
	if (!$fd) {
		return "There was an error opening $filename";
	}
	
	foreach ($data as $d) {
		$line = $d["username"].":".$d["password"].":".$d["uid"].":"
			.$d["gid"].":".$d["gecos"].":".$d["homedir"].":"
				.$d["shell"]."\n";
		fputs($fd, $line);
	}
	
	fclose($fd);
	
	return 0;
}

/* OK, yeah, it's a pretty big hack.  But it works.
 */
function first_available_uid($filename)
{
	global $SNUI_ADDUSER_MINUID;
	
	$uids = array();
	$userdata = read_passwd($filename);
	foreach($userdata as $user) {
		$uids[$user["uid"]] = 1;
	}
	
	for ($i = $SNUI_ADDUSER_MINUID; $uids[$i]; $i++);
	
	return $i;
}

function read_group($filename)
{
	$fd = fopen($filename, "r");
	if (!$fd) {
		return "There was an error opening the file";
	}
	
	$retval = array();
	while (!feof($fd)) {
		$line = fgets(fd, 65535);
		$line = str_replace("\n", "", $line);
		if ($line == "") {
			continue;
		}
		$fields = split(':', $line);
		$new_field = array();
		$new_field["groupname"] = $fields[0];
		$new_field["password"] = $fields[1];
		$new_field["gid"] = $fields[2];
		$new_field["members"] = split(',', $fields[3]);
		$retval[] = $new_field;
	}
	
	fclose($fd);

	return $retval;
}

function write_group($filename, $data)
{
	$fd = fopen($filename, "w");
	if (!$fd) {
		return "There was an error opening $filename";
	}
	
	foreach ($data as $d) {
		$line = $d["groupname"].":".$d["password"].":".$d["gid"].":"
			.implode(',', $d["members"])."\n";
		fputs($fd, $line);
	}
	
	fclose($fd);
	
	return 0;
}

function add_user_to_group($username, $group, $group_db)
{
	$groups = read_group($group_db);
	if (is_string($groups)) {
		return $groups;
	}
	
	for ($i = 0; $i < count($groups); $i++) {
		if ($groups[$i]["groupname"] == $group) {
			if (count(array_intersect(array($username), $groups[$i]["members"]))) {
				return "The user is already in the group";
			}
			$group[$i]["members"][] = $username;
		}
	}
	
	$rv = write_group($group_db, $groups);
	if (is_string($rv)) {
		return $rv;
	}
}			

function read_auth($filename)
{
	$fd = fopen($filename, "r");
	if (!$fd) {
		return "There was an error opening the file";
	}
	
	$retval = array();
	while (!feof($fd)) {
		$line = fgets($fd, 65535);
		$line = str_replace("\n", "", $line);
		if ($line == "") {
			continue;
		}
		$fields = split(':', $line);
		$new_field = array();
		$new_field["username"] = $fields[0];
		$new_field["password"] = $fields[1];
		$retval[] = $new_field;
	}
	
	fclose($fd);

	return $retval;
}

function write_auth($filename, $data)
{
	$fd = fopen($filename, "w");
	if (!$fd) {
		return "There was an error opening $filename";
	}
	
	foreach ($data as $d) {
		$line = $d["username"].":".$d["password"]."\n";
		fputs($fd, $line);
	}
	
	fclose($fd);
	
	return 0;
}

function admin_auth_check($username, $password)
{
	$user_data = read_passwd("/etc/passwd");
	if (is_string($user_data)) {
		return $user_data;
	}
	foreach($user_data as $user) {
		if ($user["username"] == $username) {
			if (crypt($password, $user["password"]) == $user["password"]) {
				return 1;
			} else {
				return 0;
			}
		}
	}
	
	return 0;
}

function button_try_again($file)
{
	$retval = form_header($file);
	$retval .= form_hidden("username");
	$retval .= form_hidden("auth_username");
	$retval .= form_hidden("realname");
	$retval .= form_submit("Try Again");
	$retval .= form_footer();
	
	return $retval;
}	
