/******************************************************************************
*       SOFA, Simulation Open-Framework Architecture, version 1.0 beta 3      *
*                (c) 2006-2008 MGH, INRIA, USTL, UJF, CNRS                    *
*                                                                             *
* This library is free software; you can redistribute it and/or modify it     *
* under the terms of the GNU Lesser General Public License as published by    *
* the Free Software Foundation; either version 2.1 of the License, or (at     *
* your option) any later version.                                             *
*                                                                             *
* This library is distributed in the hope that it will be useful, but WITHOUT *
* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or       *
* FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License *
* for more details.                                                           *
*                                                                             *
* You should have received a copy of the GNU Lesser General Public License    *
* along with this library; if not, write to the Free Software Foundation,     *
* Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301 USA.          *
*******************************************************************************
*                               SOFA :: Modules                               *
*                                                                             *
* Authors: The SOFA Team and external contributors (see Authors.txt)          *
*                                                                             *
* Contact information: contact@sofa-framework.org                             *
******************************************************************************/
#ifndef OGLSHADERMACRO_H_
#define OGLSHADERMACRO_H_

#include <sofa/component/visualmodel/OglShader.h>

namespace sofa
{

namespace component
{

namespace visualmodel
{

/**
 *  \brief Small class to define macro into an OglShader.
 *
 *  This small abstract class describes macro into an OpenGL shader
 *  (GLSL). It was mainly written for implementing #ifdef macro
 *  into shader, and therefore, to have a multi-purpose shader (and not
 *  many fragmented shaders).
 *
 */

class OglShaderMacro : public OglShaderElement {
protected:

public:
	OglShaderMacro();
	virtual ~OglShaderMacro();
	virtual void init();

};


class OglShaderDefineMacro : public OglShaderMacro {
protected:
	Data<std::string> value;
public:
	OglShaderDefineMacro();
	virtual ~OglShaderDefineMacro();
	virtual void init();
};

}

}

}

#endif /*OGLSHADERMACRO_H_*/
