/* -*- C -*-
 *
 * This file is part of the Sofia-SIP package
 *
 * Copyright (C) 2006 Nokia Corporation.
 *
 * Contact: Pekka Pessi <pekka.pessi@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef SIP_EXTRA_H
/** Defined when <sofia-sip/sip_extra.h> has been included. */
#define SIP_EXTRA_H

/**@file sofia-sip/sip_extra.h
*
 * @brief Extension headers for SIP.
 *
 * This file is automatically generated from <sip_extra_headers.txt> by msg_parser.awk.
 *
 * @author Pekka Pessi <Pekka.Pessi@nokia.com>.
 */

#ifndef SIP_H
#include <sofia-sip/sip.h>
#endif

#ifndef SIP_HEADER_H
#include <sofia-sip/sip_header.h>
#endif

SOFIA_BEGIN_DECLS

typedef struct sip_refer_sub_s      sip_refer_sub_t;

/**@ingroup sip_refer_sub
 * @brief Structure for @ReferSub header.
 */
struct sip_refer_sub_s
{
  sip_common_t        rs_common[1];   	/**< Common fragment info */
  sip_error_t        *rs_next;        	/**< Dummy link to next */
  char const         *rs_value;       	/**< "true" or "false" */
  msg_param_t const  *rs_params;      	/**< List of extension parameters */
};

typedef struct sip_suppress_body_if_match_s sip_suppress_body_if_match_t;

/**@ingroup sip_suppress_body_if_match
 * @brief Structure for @SuppressBodyIfMatch header.
 */
struct sip_suppress_body_if_match_s
{
  sip_common_t   sbim_common[1];	/**< Common fragment info */
  sip_error_t   *sbim_next;		/**< Dummy link to next header */
  char const    *sbim_tag;		/**< Entity-tag */
};

typedef struct sip_suppress_notify_if_match_s sip_suppress_notify_if_match_t;

/**@ingroup sip_suppress_notify_if_match
 * @brief Structure for @SuppressNotifyIfMatch header.
 */
struct sip_suppress_notify_if_match_s
{
  sip_common_t   snim_common[1];	/**< Common fragment info */
  sip_error_t   *snim_next;		/**< Dummy link to next header */
  char const    *snim_tag;		/**< Entity-tag */
};



enum { 
  /**@ingroup sip_refer_sub @internal 
   *
   * Hash of @ref sip_refer_sub "Refer-Sub header".
   *
   * @since New in @NEW_1_12_5.
   */
  sip_refer_sub_hash = 14607 
};

/**Header class for @ref sip_refer_sub "Refer-Sub header".
 * 
 * The header class sip_refer_sub_class defines how a SIP
 * @ref sip_refer_sub "Refer-Sub header" is parsed and printed.
 * It also contains methods used by SIP parser and other functions to
 * manipulate the #sip_refer_sub_t header structure.
 *
 * @ingroup sip_refer_sub
 *
 * @since New in @NEW_1_12_5.
 */
SIP_DLL extern msg_hclass_t sip_refer_sub_class[];


/**@addtogroup sip_refer_sub
 * @{
 */

/** Parse a SIP @ref sip_refer_sub "Refer-Sub header". @internal */
SOFIAPUBFUN issize_t sip_refer_sub_d(su_home_t *, msg_header_t *,
				       char *s, isize_t slen);

/** Print a SIP @ref sip_refer_sub "Refer-Sub header". @internal */
SOFIAPUBFUN issize_t sip_refer_sub_e(char b[], isize_t bsiz,
                    	            msg_header_t const *h, int flags);

/**Access a SIP @ref sip_refer_sub "Refer-Sub header"
 * structure #sip_refer_sub_t from #sip_t.
 * 
 * @since New in @NEW_1_12_5.
 */
#define sip_refer_sub(sip) \
  ((sip_refer_sub_t *)msg_header_access((msg_pub_t*)(sip), sip_refer_sub_class))

/**Initializer for structure #sip_refer_sub_t.
 * 
 * A static #sip_refer_sub_t structure for
 * @ref sip_refer_sub "Refer-Sub header" must be initialized with
 * the SIP_REFER_SUB_INIT() macro. 
 * For instance,
 * @code 
 * 
 *  sip_refer_sub_t sip_refer_sub = SIP_REFER_SUB_INIT;
 * 
 * @endcode
 * @HI
 *
 * @since New in @NEW_1_12_5.
 */
#define SIP_REFER_SUB_INIT() SIP_HDR_INIT(refer_sub)

/**Initialize a structure #sip_refer_sub_t.
 * 
 * An #sip_refer_sub_t structure for
 * @ref sip_refer_sub "Refer-Sub header" can be initialized with the
 * sip_refer_sub_init() function/macro. For instance,
 * @code
 * 
 *  sip_refer_sub_t sip_refer_sub;
 * 
 *  sip_refer_sub_init(&sip_refer_sub);
 * 
 * @endcode
 * @HI
 *
 * @since New in @NEW_1_12_5.
 */
#if SU_HAVE_INLINE
su_inline sip_refer_sub_t *sip_refer_sub_init(sip_refer_sub_t x[1])
{
  return SIP_HEADER_INIT(x, sip_refer_sub_class, sizeof(sip_refer_sub_t));
}
#else
#define sip_refer_sub_init(x) \
  SIP_HEADER_INIT(x, sip_refer_sub_class, sizeof(sip_refer_sub_t))
#endif

/**Test if header object is instance of #sip_refer_sub_t.
 * 
 * Check if the header class is an instance of
 * @ref sip_refer_sub "Refer-Sub header" object and return true (nonzero),
 * otherwise return false (zero).
 * 
 * @param header pointer to the header structure to be tested
 * 
 * @retval 1 (true) if the @a header is an instance of header refer_sub 
 * @retval 0 (false) otherwise
 *
 * @since New in @NEW_1_12_5.
 */
#if SU_HAVE_INLINE
su_inline int sip_is_refer_sub(sip_header_t const *header)
{
  return header && header->sh_class->hc_hash == sip_refer_sub_hash;
}
#else
int sip_is_refer_sub(sip_header_t const *header);
#endif

#define sip_refer_sub_p(h) sip_is_refer_sub((h))


/**Duplicate a list of @ref sip_refer_sub "Refer-Sub header" header structures #sip_refer_sub_t.
 * 
 * Duplicate a header
 * structure @a hdr.  If the header structure @a hdr
 * contains a reference (@c hdr->x_next) to a list of
 * headers, all the headers in the list are duplicated, too.
 * 
 * @param home  memory home used to allocate new structure
 * @param hdr   header structure to be duplicated
 * 
 * When duplicating, all parameter lists and non-constant
 * strings attached to the header are copied, too.  The
 * function uses given memory @a home to allocate all the
 * memory areas used to copy the header.
 * 
 * @par Example
 * @code
 * 
 *   refer_sub = sip_refer_sub_dup(home, sip->sip_refer_sub);
 * 
 * @endcode
 * 
 * @return
 * A pointer to the
 * newly duplicated #sip_refer_sub_t header structure, or NULL
 * upon an error.
 *
 * @since New in @NEW_1_12_5.
 */
#if SU_HAVE_INLINE
su_inline
#endif
sip_refer_sub_t *sip_refer_sub_dup(su_home_t *home, sip_refer_sub_t const *hdr) 
     __attribute__((__malloc__));

#if SU_HAVE_INLINE
su_inline
sip_refer_sub_t *sip_refer_sub_dup(su_home_t *home, sip_refer_sub_t const *hdr)
{ 
  return (sip_refer_sub_t *)
    msg_header_dup_as(home, sip_refer_sub_class, (msg_header_t const *)hdr);
}
#endif

/**Copy a list of @ref sip_refer_sub "Refer-Sub header" header structures #sip_refer_sub_t.
 * 
 * The function sip_refer_sub_copy() copies a header structure @a
 * hdr.  If the header structure @a hdr contains a reference (@c
 * hdr->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home
 * to allocate all the memory areas used to copy the list of header
 * structure @a hdr.
 * 
 * @param home    memory home used to allocate new structure
 * @param hdr     pointer to the header structure to be copied
 * 
 * When copying, only the header structure and parameter lists attached to
 * it are duplicated. The new header structure retains all the references to
 * the strings within the old @a hdr header, including the encoding of the
 * old header, if present.
 * 
 * @par Example
 * @code
 * 
 *   refer_sub = sip_refer_sub_copy(home, sip->sip_refer_sub);
 * 
 * @endcode
 * 
 * @return
 * A pointer to newly copied header structure, or NULL upon an error.
 *
 * @since New in @NEW_1_12_5.
 */
#if SU_HAVE_INLINE
su_inline
#endif
sip_refer_sub_t *sip_refer_sub_copy(su_home_t *home, sip_refer_sub_t const *hdr) 
     __attribute__((__malloc__));

#if SU_HAVE_INLINE
su_inline
sip_refer_sub_t *sip_refer_sub_copy(su_home_t *home, sip_refer_sub_t const *hdr) 
{ 
  return (sip_refer_sub_t *)
    msg_header_copy_as(home, sip_refer_sub_class, (msg_header_t const *)hdr); 
}
#endif

/**Make a @ref sip_refer_sub "Refer-Sub header" structure #sip_refer_sub_t.
 * 
 * The function sip_refer_sub_make() makes a new
 * #sip_refer_sub_t header structure.  It allocates a new
 * header structure, and decodes the string @a s as the
 * value of the structure.
 * 
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 * 
 * @return
 * A pointer to newly maked #sip_refer_sub_t header structure, or NULL upon an
 * error.
 *
 * @since New in @NEW_1_12_5.
 */
#if SU_HAVE_INLINE
su_inline 
#endif
sip_refer_sub_t *sip_refer_sub_make(su_home_t *home, char const *s)
     __attribute__((__malloc__));

#if SU_HAVE_INLINE
su_inline sip_refer_sub_t *sip_refer_sub_make(su_home_t *home, char const *s)
{
  return (sip_refer_sub_t *)sip_header_make(home, sip_refer_sub_class, s);
}
#endif

/**Make a @ref sip_refer_sub "Refer-Sub header" from formatting result.
 * 
 * Make a new #sip_refer_sub_t object using formatting result as its value. 
 * The function first prints the arguments according to the format @a fmt
 * specified. Then it allocates a new header structure, and parses the
 * formatting result to the structure #sip_refer_sub_t.
 * 
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 * 
 * @return
 * A pointer to newly
 * makes header structure, or NULL upon an error.
 * 
 * @HIDE
 *
 * @since New in @NEW_1_12_5.
 */
#if SU_HAVE_INLINE
su_inline
#endif
sip_refer_sub_t *sip_refer_sub_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__malloc__, __format__ (printf, 2, 3)));

#if SU_HAVE_INLINE
su_inline sip_refer_sub_t *sip_refer_sub_format(su_home_t *home, char const *fmt, ...)
{
  sip_header_t *h;
  va_list ap;
  
  va_start(ap, fmt);
  h = sip_header_vformat(home, sip_refer_sub_class, fmt, ap);
  va_end(ap);
 
  return (sip_refer_sub_t *)h;
}
#endif

/** @} */

#if SU_HAVE_EXPERIMENTAL

enum { 
  /**@ingroup sip_suppress_body_if_match @internal 
   *
   * Hash of @ref sip_suppress_body_if_match "Suppress-Body-If-Match header".
   *
   * @since New in @EXP_1_12_5.
   */
  sip_suppress_body_if_match_hash = 49874 
};

/**Header class for @ref sip_suppress_body_if_match "Suppress-Body-If-Match header".
 * 
 * The header class sip_suppress_body_if_match_class defines how a SIP
 * @ref sip_suppress_body_if_match "Suppress-Body-If-Match header" is parsed and printed.
 * It also contains methods used by SIP parser and other functions to
 * manipulate the #sip_suppress_body_if_match_t header structure.
 *
 * @ingroup sip_suppress_body_if_match
 *
 * @since New in @EXP_1_12_5.
 */
SIP_DLL extern msg_hclass_t sip_suppress_body_if_match_class[];


/**@addtogroup sip_suppress_body_if_match
 * @{
 */

/** Parse a SIP @ref sip_suppress_body_if_match "Suppress-Body-If-Match header". @internal */
SOFIAPUBFUN issize_t sip_suppress_body_if_match_d(su_home_t *, msg_header_t *,
				       char *s, isize_t slen);

/** Print a SIP @ref sip_suppress_body_if_match "Suppress-Body-If-Match header". @internal */
SOFIAPUBFUN issize_t sip_suppress_body_if_match_e(char b[], isize_t bsiz,
                    	            msg_header_t const *h, int flags);

/**Access a SIP @ref sip_suppress_body_if_match "Suppress-Body-If-Match header"
 * structure #sip_suppress_body_if_match_t from #sip_t.
 * 
 * @since New in @EXP_1_12_5.
 */
#define sip_suppress_body_if_match(sip) \
  ((sip_suppress_body_if_match_t *)msg_header_access((msg_pub_t*)(sip), sip_suppress_body_if_match_class))

/**Initializer for structure #sip_suppress_body_if_match_t.
 * 
 * A static #sip_suppress_body_if_match_t structure for
 * @ref sip_suppress_body_if_match "Suppress-Body-If-Match header" must be initialized with
 * the SIP_SUPPRESS_BODY_IF_MATCH_INIT() macro. 
 * For instance,
 * @code 
 * 
 *  sip_suppress_body_if_match_t sip_suppress_body_if_match = SIP_SUPPRESS_BODY_IF_MATCH_INIT;
 * 
 * @endcode
 * @HI
 *
 * @since New in @EXP_1_12_5.
 */
#define SIP_SUPPRESS_BODY_IF_MATCH_INIT() SIP_HDR_INIT(suppress_body_if_match)

/**Initialize a structure #sip_suppress_body_if_match_t.
 * 
 * An #sip_suppress_body_if_match_t structure for
 * @ref sip_suppress_body_if_match "Suppress-Body-If-Match header" can be initialized with the
 * sip_suppress_body_if_match_init() function/macro. For instance,
 * @code
 * 
 *  sip_suppress_body_if_match_t sip_suppress_body_if_match;
 * 
 *  sip_suppress_body_if_match_init(&sip_suppress_body_if_match);
 * 
 * @endcode
 * @HI
 *
 * @since New in @EXP_1_12_5.
 */
#if SU_HAVE_INLINE
su_inline sip_suppress_body_if_match_t *sip_suppress_body_if_match_init(sip_suppress_body_if_match_t x[1])
{
  return SIP_HEADER_INIT(x, sip_suppress_body_if_match_class, sizeof(sip_suppress_body_if_match_t));
}
#else
#define sip_suppress_body_if_match_init(x) \
  SIP_HEADER_INIT(x, sip_suppress_body_if_match_class, sizeof(sip_suppress_body_if_match_t))
#endif

/**Test if header object is instance of #sip_suppress_body_if_match_t.
 * 
 * Check if the header class is an instance of
 * @ref sip_suppress_body_if_match "Suppress-Body-If-Match header" object and return true (nonzero),
 * otherwise return false (zero).
 * 
 * @param header pointer to the header structure to be tested
 * 
 * @retval 1 (true) if the @a header is an instance of header suppress_body_if_match 
 * @retval 0 (false) otherwise
 *
 * @since New in @EXP_1_12_5.
 */
#if SU_HAVE_INLINE
su_inline int sip_is_suppress_body_if_match(sip_header_t const *header)
{
  return header && header->sh_class->hc_hash == sip_suppress_body_if_match_hash;
}
#else
int sip_is_suppress_body_if_match(sip_header_t const *header);
#endif

#define sip_suppress_body_if_match_p(h) sip_is_suppress_body_if_match((h))


/**Duplicate a list of @ref sip_suppress_body_if_match "Suppress-Body-If-Match header" header structures #sip_suppress_body_if_match_t.
 * 
 * Duplicate a header
 * structure @a hdr.  If the header structure @a hdr
 * contains a reference (@c hdr->x_next) to a list of
 * headers, all the headers in the list are duplicated, too.
 * 
 * @param home  memory home used to allocate new structure
 * @param hdr   header structure to be duplicated
 * 
 * When duplicating, all parameter lists and non-constant
 * strings attached to the header are copied, too.  The
 * function uses given memory @a home to allocate all the
 * memory areas used to copy the header.
 * 
 * @par Example
 * @code
 * 
 *   suppress_body_if_match = sip_suppress_body_if_match_dup(home, sip->sip_suppress_body_if_match);
 * 
 * @endcode
 * 
 * @return
 * A pointer to the
 * newly duplicated #sip_suppress_body_if_match_t header structure, or NULL
 * upon an error.
 *
 * @since New in @EXP_1_12_5.
 */
#if SU_HAVE_INLINE
su_inline
#endif
sip_suppress_body_if_match_t *sip_suppress_body_if_match_dup(su_home_t *home, sip_suppress_body_if_match_t const *hdr) 
     __attribute__((__malloc__));

#if SU_HAVE_INLINE
su_inline
sip_suppress_body_if_match_t *sip_suppress_body_if_match_dup(su_home_t *home, sip_suppress_body_if_match_t const *hdr)
{ 
  return (sip_suppress_body_if_match_t *)
    msg_header_dup_as(home, sip_suppress_body_if_match_class, (msg_header_t const *)hdr);
}
#endif

/**Copy a list of @ref sip_suppress_body_if_match "Suppress-Body-If-Match header" header structures #sip_suppress_body_if_match_t.
 * 
 * The function sip_suppress_body_if_match_copy() copies a header structure @a
 * hdr.  If the header structure @a hdr contains a reference (@c
 * hdr->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home
 * to allocate all the memory areas used to copy the list of header
 * structure @a hdr.
 * 
 * @param home    memory home used to allocate new structure
 * @param hdr     pointer to the header structure to be copied
 * 
 * When copying, only the header structure and parameter lists attached to
 * it are duplicated. The new header structure retains all the references to
 * the strings within the old @a hdr header, including the encoding of the
 * old header, if present.
 * 
 * @par Example
 * @code
 * 
 *   suppress_body_if_match = sip_suppress_body_if_match_copy(home, sip->sip_suppress_body_if_match);
 * 
 * @endcode
 * 
 * @return
 * A pointer to newly copied header structure, or NULL upon an error.
 *
 * @since New in @EXP_1_12_5.
 */
#if SU_HAVE_INLINE
su_inline
#endif
sip_suppress_body_if_match_t *sip_suppress_body_if_match_copy(su_home_t *home, sip_suppress_body_if_match_t const *hdr) 
     __attribute__((__malloc__));

#if SU_HAVE_INLINE
su_inline
sip_suppress_body_if_match_t *sip_suppress_body_if_match_copy(su_home_t *home, sip_suppress_body_if_match_t const *hdr) 
{ 
  return (sip_suppress_body_if_match_t *)
    msg_header_copy_as(home, sip_suppress_body_if_match_class, (msg_header_t const *)hdr); 
}
#endif

/**Make a @ref sip_suppress_body_if_match "Suppress-Body-If-Match header" structure #sip_suppress_body_if_match_t.
 * 
 * The function sip_suppress_body_if_match_make() makes a new
 * #sip_suppress_body_if_match_t header structure.  It allocates a new
 * header structure, and decodes the string @a s as the
 * value of the structure.
 * 
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 * 
 * @return
 * A pointer to newly maked #sip_suppress_body_if_match_t header structure, or NULL upon an
 * error.
 *
 * @since New in @EXP_1_12_5.
 */
#if SU_HAVE_INLINE
su_inline 
#endif
sip_suppress_body_if_match_t *sip_suppress_body_if_match_make(su_home_t *home, char const *s)
     __attribute__((__malloc__));

#if SU_HAVE_INLINE
su_inline sip_suppress_body_if_match_t *sip_suppress_body_if_match_make(su_home_t *home, char const *s)
{
  return (sip_suppress_body_if_match_t *)sip_header_make(home, sip_suppress_body_if_match_class, s);
}
#endif

/**Make a @ref sip_suppress_body_if_match "Suppress-Body-If-Match header" from formatting result.
 * 
 * Make a new #sip_suppress_body_if_match_t object using formatting result as its value. 
 * The function first prints the arguments according to the format @a fmt
 * specified. Then it allocates a new header structure, and parses the
 * formatting result to the structure #sip_suppress_body_if_match_t.
 * 
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 * 
 * @return
 * A pointer to newly
 * makes header structure, or NULL upon an error.
 * 
 * @HIDE
 *
 * @since New in @EXP_1_12_5.
 */
#if SU_HAVE_INLINE
su_inline
#endif
sip_suppress_body_if_match_t *sip_suppress_body_if_match_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__malloc__, __format__ (printf, 2, 3)));

#if SU_HAVE_INLINE
su_inline sip_suppress_body_if_match_t *sip_suppress_body_if_match_format(su_home_t *home, char const *fmt, ...)
{
  sip_header_t *h;
  va_list ap;
  
  va_start(ap, fmt);
  h = sip_header_vformat(home, sip_suppress_body_if_match_class, fmt, ap);
  va_end(ap);
 
  return (sip_suppress_body_if_match_t *)h;
}
#endif

/** @} */

#endif /* SU_HAVE_EXPERIMENTAL */
#if SU_HAVE_EXPERIMENTAL

enum { 
  /**@ingroup sip_suppress_notify_if_match @internal 
   *
   * Hash of @ref sip_suppress_notify_if_match "Suppress-Notify-If-Match header".
   *
   * @since New in @EXP_1_12_5.
   */
  sip_suppress_notify_if_match_hash = 51341 
};

/**Header class for @ref sip_suppress_notify_if_match "Suppress-Notify-If-Match header".
 * 
 * The header class sip_suppress_notify_if_match_class defines how a SIP
 * @ref sip_suppress_notify_if_match "Suppress-Notify-If-Match header" is parsed and printed.
 * It also contains methods used by SIP parser and other functions to
 * manipulate the #sip_suppress_notify_if_match_t header structure.
 *
 * @ingroup sip_suppress_notify_if_match
 *
 * @since New in @EXP_1_12_5.
 */
SIP_DLL extern msg_hclass_t sip_suppress_notify_if_match_class[];


/**@addtogroup sip_suppress_notify_if_match
 * @{
 */

/** Parse a SIP @ref sip_suppress_notify_if_match "Suppress-Notify-If-Match header". @internal */
SOFIAPUBFUN issize_t sip_suppress_notify_if_match_d(su_home_t *, msg_header_t *,
				       char *s, isize_t slen);

/** Print a SIP @ref sip_suppress_notify_if_match "Suppress-Notify-If-Match header". @internal */
SOFIAPUBFUN issize_t sip_suppress_notify_if_match_e(char b[], isize_t bsiz,
                    	            msg_header_t const *h, int flags);

/**Access a SIP @ref sip_suppress_notify_if_match "Suppress-Notify-If-Match header"
 * structure #sip_suppress_notify_if_match_t from #sip_t.
 * 
 * @since New in @EXP_1_12_5.
 */
#define sip_suppress_notify_if_match(sip) \
  ((sip_suppress_notify_if_match_t *)msg_header_access((msg_pub_t*)(sip), sip_suppress_notify_if_match_class))

/**Initializer for structure #sip_suppress_notify_if_match_t.
 * 
 * A static #sip_suppress_notify_if_match_t structure for
 * @ref sip_suppress_notify_if_match "Suppress-Notify-If-Match header" must be initialized with
 * the SIP_SUPPRESS_NOTIFY_IF_MATCH_INIT() macro. 
 * For instance,
 * @code 
 * 
 *  sip_suppress_notify_if_match_t sip_suppress_notify_if_match = SIP_SUPPRESS_NOTIFY_IF_MATCH_INIT;
 * 
 * @endcode
 * @HI
 *
 * @since New in @EXP_1_12_5.
 */
#define SIP_SUPPRESS_NOTIFY_IF_MATCH_INIT() SIP_HDR_INIT(suppress_notify_if_match)

/**Initialize a structure #sip_suppress_notify_if_match_t.
 * 
 * An #sip_suppress_notify_if_match_t structure for
 * @ref sip_suppress_notify_if_match "Suppress-Notify-If-Match header" can be initialized with the
 * sip_suppress_notify_if_match_init() function/macro. For instance,
 * @code
 * 
 *  sip_suppress_notify_if_match_t sip_suppress_notify_if_match;
 * 
 *  sip_suppress_notify_if_match_init(&sip_suppress_notify_if_match);
 * 
 * @endcode
 * @HI
 *
 * @since New in @EXP_1_12_5.
 */
#if SU_HAVE_INLINE
su_inline sip_suppress_notify_if_match_t *sip_suppress_notify_if_match_init(sip_suppress_notify_if_match_t x[1])
{
  return SIP_HEADER_INIT(x, sip_suppress_notify_if_match_class, sizeof(sip_suppress_notify_if_match_t));
}
#else
#define sip_suppress_notify_if_match_init(x) \
  SIP_HEADER_INIT(x, sip_suppress_notify_if_match_class, sizeof(sip_suppress_notify_if_match_t))
#endif

/**Test if header object is instance of #sip_suppress_notify_if_match_t.
 * 
 * Check if the header class is an instance of
 * @ref sip_suppress_notify_if_match "Suppress-Notify-If-Match header" object and return true (nonzero),
 * otherwise return false (zero).
 * 
 * @param header pointer to the header structure to be tested
 * 
 * @retval 1 (true) if the @a header is an instance of header suppress_notify_if_match 
 * @retval 0 (false) otherwise
 *
 * @since New in @EXP_1_12_5.
 */
#if SU_HAVE_INLINE
su_inline int sip_is_suppress_notify_if_match(sip_header_t const *header)
{
  return header && header->sh_class->hc_hash == sip_suppress_notify_if_match_hash;
}
#else
int sip_is_suppress_notify_if_match(sip_header_t const *header);
#endif

#define sip_suppress_notify_if_match_p(h) sip_is_suppress_notify_if_match((h))


/**Duplicate a list of @ref sip_suppress_notify_if_match "Suppress-Notify-If-Match header" header structures #sip_suppress_notify_if_match_t.
 * 
 * Duplicate a header
 * structure @a hdr.  If the header structure @a hdr
 * contains a reference (@c hdr->x_next) to a list of
 * headers, all the headers in the list are duplicated, too.
 * 
 * @param home  memory home used to allocate new structure
 * @param hdr   header structure to be duplicated
 * 
 * When duplicating, all parameter lists and non-constant
 * strings attached to the header are copied, too.  The
 * function uses given memory @a home to allocate all the
 * memory areas used to copy the header.
 * 
 * @par Example
 * @code
 * 
 *   suppress_notify_if_match = sip_suppress_notify_if_match_dup(home, sip->sip_suppress_notify_if_match);
 * 
 * @endcode
 * 
 * @return
 * A pointer to the
 * newly duplicated #sip_suppress_notify_if_match_t header structure, or NULL
 * upon an error.
 *
 * @since New in @EXP_1_12_5.
 */
#if SU_HAVE_INLINE
su_inline
#endif
sip_suppress_notify_if_match_t *sip_suppress_notify_if_match_dup(su_home_t *home, sip_suppress_notify_if_match_t const *hdr) 
     __attribute__((__malloc__));

#if SU_HAVE_INLINE
su_inline
sip_suppress_notify_if_match_t *sip_suppress_notify_if_match_dup(su_home_t *home, sip_suppress_notify_if_match_t const *hdr)
{ 
  return (sip_suppress_notify_if_match_t *)
    msg_header_dup_as(home, sip_suppress_notify_if_match_class, (msg_header_t const *)hdr);
}
#endif

/**Copy a list of @ref sip_suppress_notify_if_match "Suppress-Notify-If-Match header" header structures #sip_suppress_notify_if_match_t.
 * 
 * The function sip_suppress_notify_if_match_copy() copies a header structure @a
 * hdr.  If the header structure @a hdr contains a reference (@c
 * hdr->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home
 * to allocate all the memory areas used to copy the list of header
 * structure @a hdr.
 * 
 * @param home    memory home used to allocate new structure
 * @param hdr     pointer to the header structure to be copied
 * 
 * When copying, only the header structure and parameter lists attached to
 * it are duplicated. The new header structure retains all the references to
 * the strings within the old @a hdr header, including the encoding of the
 * old header, if present.
 * 
 * @par Example
 * @code
 * 
 *   suppress_notify_if_match = sip_suppress_notify_if_match_copy(home, sip->sip_suppress_notify_if_match);
 * 
 * @endcode
 * 
 * @return
 * A pointer to newly copied header structure, or NULL upon an error.
 *
 * @since New in @EXP_1_12_5.
 */
#if SU_HAVE_INLINE
su_inline
#endif
sip_suppress_notify_if_match_t *sip_suppress_notify_if_match_copy(su_home_t *home, sip_suppress_notify_if_match_t const *hdr) 
     __attribute__((__malloc__));

#if SU_HAVE_INLINE
su_inline
sip_suppress_notify_if_match_t *sip_suppress_notify_if_match_copy(su_home_t *home, sip_suppress_notify_if_match_t const *hdr) 
{ 
  return (sip_suppress_notify_if_match_t *)
    msg_header_copy_as(home, sip_suppress_notify_if_match_class, (msg_header_t const *)hdr); 
}
#endif

/**Make a @ref sip_suppress_notify_if_match "Suppress-Notify-If-Match header" structure #sip_suppress_notify_if_match_t.
 * 
 * The function sip_suppress_notify_if_match_make() makes a new
 * #sip_suppress_notify_if_match_t header structure.  It allocates a new
 * header structure, and decodes the string @a s as the
 * value of the structure.
 * 
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 * 
 * @return
 * A pointer to newly maked #sip_suppress_notify_if_match_t header structure, or NULL upon an
 * error.
 *
 * @since New in @EXP_1_12_5.
 */
#if SU_HAVE_INLINE
su_inline 
#endif
sip_suppress_notify_if_match_t *sip_suppress_notify_if_match_make(su_home_t *home, char const *s)
     __attribute__((__malloc__));

#if SU_HAVE_INLINE
su_inline sip_suppress_notify_if_match_t *sip_suppress_notify_if_match_make(su_home_t *home, char const *s)
{
  return (sip_suppress_notify_if_match_t *)sip_header_make(home, sip_suppress_notify_if_match_class, s);
}
#endif

/**Make a @ref sip_suppress_notify_if_match "Suppress-Notify-If-Match header" from formatting result.
 * 
 * Make a new #sip_suppress_notify_if_match_t object using formatting result as its value. 
 * The function first prints the arguments according to the format @a fmt
 * specified. Then it allocates a new header structure, and parses the
 * formatting result to the structure #sip_suppress_notify_if_match_t.
 * 
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 * 
 * @return
 * A pointer to newly
 * makes header structure, or NULL upon an error.
 * 
 * @HIDE
 *
 * @since New in @EXP_1_12_5.
 */
#if SU_HAVE_INLINE
su_inline
#endif
sip_suppress_notify_if_match_t *sip_suppress_notify_if_match_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__malloc__, __format__ (printf, 2, 3)));

#if SU_HAVE_INLINE
su_inline sip_suppress_notify_if_match_t *sip_suppress_notify_if_match_format(su_home_t *home, char const *fmt, ...)
{
  sip_header_t *h;
  va_list ap;
  
  va_start(ap, fmt);
  h = sip_header_vformat(home, sip_suppress_notify_if_match_class, fmt, ap);
  va_end(ap);
 
  return (sip_suppress_notify_if_match_t *)h;
}
#endif

/** @} */

#endif /* SU_HAVE_EXPERIMENTAL */

SOFIA_END_DECLS

#endif /** !defined(SIP_EXTRA_H) */
