CC=gcc
CPP=g++
RANLIB=ranlib
AR=ar

prefix=/usr/local
bindir=$(prefix)/bin
libdir=$(prefix)/lib/softgun/

#CFLAGS=-Wall -pg -O0 -g   
CFLAGS=-Wall -O9 -g  -fomit-frame-pointer  -D_GNU_SOURCE 
#CFLAGS=-Wall -O1 -g  -DDEBUG
SHAREDCFLAGS=-fPIC
SHAREDLDFLAGS=-nostdlib -shared
LDFLAGS=-rdynamic -lpthread -ldl -lrt -lm
INCLUDES=-I$(top_srcdir)

.SUFFIXES: .c .o .be.o
.PHONY: clean all

%.be.o: %.c
	$(CC) $(CFLAGS) $(INCLUDES) -DTARGET_BIG_ENDIAN=1 -c -o $@ $<

%.o: %.c
	$(CC) $(CFLAGS) $(INCLUDES) -DTARGET_BIG_ENDIAN=0 -c $<

%.so: %.c
	$(CC) $(SHAREDCFLAGS) $(SHAREDLDFLAGS) $(CFLAGS) $(INCLUDES) -DTARGET_BIG_ENDIAN=0 $< -o $@

%_be.so: %.c
	$(CC) $(SHAREDCFLAGS) $(SHAREDLDFLAGS) $(CFLAGS) $(INCLUDES) -DTARGET_BIG_ENDIAN=1  $< -o $@ 
