/*
 * --------------------------------------------------------
 * Emulation of the Coldfire Flash Module (CFM)
 *
 * (C) 2008 Jochen Karrer 
 *   Author: Jochen Karrer
 *
 * State:
 *	Not implemented
 *
 *  This program is free software; you can distribute it and/or modify it
 *  under the terms of the GNU General Public License (Version 2) as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 *  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston MA 02111-1307, USA.
 *
 * --------------------------------------------------------
 */

#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <string.h>
#include "bus.h"
#include "configfile.h"
#include "sgstring.h"
#include "diskimage.h"
#include "cfm.h"

typedef struct CFFlash {
	BusDevice bdev;
	uint32_t size;
	uint8_t *host_mem;
	DiskImage *disk_image;
} CFFlash;

static void
cfm_write(void *clientData,uint32_t value,uint32_t addr,int rqlen)
{
	fprintf(stderr,"Write to Flash addr %08x value %08x len %d\n",addr,value,rqlen);
}


static void
Flash_UnMap(void *module_owner,uint32_t base,uint32_t mapsize)
{
        Mem_UnMapRange(base,mapsize);
        IOH_DeleteRegion(base,mapsize);
}

static void
Flash_Map(void *module_owner,uint32_t base,uint32_t mapsize,uint32_t flags)
{
	CFFlash *cfm = (CFFlash *) module_owner;
	uint32_t readflags = flags & MEM_FLAG_READABLE;
	uint32_t writeflags = flags & MEM_FLAG_WRITABLE;
        Mem_MapRange(base,cfm->host_mem,cfm->size,mapsize,readflags);
	IOH_NewRegion(base,cfm->size,NULL,cfm_write,writeflags,cfm);
}

BusDevice *
CFM_New(const char *flash_name) 
{
	char *imagedir;
	CFFlash *cfm = sg_calloc(sizeof(*cfm)); 
	imagedir = Config_ReadVar("global","imagedir");
	cfm->size = 512*1024;
	if(imagedir) {
                char *mapfile = alloca(strlen(imagedir) + strlen(flash_name)+20);
                sprintf(mapfile,"%s/%s.img",imagedir,flash_name);
                cfm->disk_image = DiskImage_Open(mapfile,cfm->size,DI_RDWR | DI_CREAT_FF);
                if(!cfm->disk_image) {
                        fprintf(stderr,"Open disk image failed\n");
                        exit(1);
                }
                cfm->host_mem=DiskImage_Mmap(cfm->disk_image);
        } else {
                cfm->host_mem=sg_calloc(cfm->size);
                memset(cfm->host_mem,0xff,cfm->size);
        }
	cfm->bdev.first_mapping=NULL;
        cfm->bdev.Map=Flash_Map;
        cfm->bdev.UnMap=Flash_UnMap;
        cfm->bdev.owner=cfm;
        cfm->bdev.hw_flags=MEM_FLAG_READABLE;
        fprintf(stderr,"Created Coldfire Flash Module with size %d\n",cfm->size);
	return &cfm->bdev;
}
