#include <controller/somaplayer.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <gtk/gtk.h>

#define NAME_EXAMPLE "somaplayer_controller_g"

typedef struct
{
  GtkWidget *v;
  GtkWidget *b;
  GtkWidget *sb;

  int sb_id;

  int no_rec;
  int no_timer;

} vb_scales;

static vb_scales *scales;

void
quit (void)
{
  puts ("Error: server connection.");
  exit (1);
}

void
b_prev (GtkWidget * w, somaplayer_controller * c)
{
  if (somaplayer_prev (c))
    quit ();
}

void
b_next (GtkWidget * w, somaplayer_controller * c)
{
  if (somaplayer_next (c))
    quit ();
}

void
b_quit (GtkWidget * w, somaplayer_controller * c)
{
  if (somaplayer_quit (c))
    quit ();

  exit (0);
}

void
b_pause (GtkWidget * w, somaplayer_controller * c)
{
  if (somaplayer_pause (c))
    quit ();
}

void
s_volume (GtkWidget * w, somaplayer_controller * c)
{
  GtkAdjustment *v;

  if (scales->no_rec)
    return;

  scales->no_timer = 1;

  v = gtk_range_get_adjustment (GTK_RANGE (w));

  if (somaplayer_set_volume (c, (int) v->value))
    quit ();

  scales->no_timer = 0;
}

void
s_balance (GtkWidget * w, somaplayer_controller * c)
{
  GtkAdjustment *v;

  if (scales->no_rec)
    return;

  scales->no_timer = 1;

  v = gtk_range_get_adjustment (GTK_RANGE (w));

  if (v->value > 45 && v->value < 55)
    {
      gtk_adjustment_set_value (GTK_ADJUSTMENT (v), 50);
      if (somaplayer_set_balance (c, 0))
	quit ();

      scales->no_timer = 0;
      return;
    }

  if (somaplayer_set_balance (c, ((int) v->value * 2) - 100))
    quit ();

  scales->no_timer = 0;
}

void
create_window (somaplayer_controller * c, int v, int b)
{
  GtkWidget *window;
  GtkWidget *box;
  GtkWidget *frame;
  GtkWidget *hbox;
  GtkWidget *vbox;
  GtkWidget *button;
  GtkWidget *scale;
  GtkAdjustment *adj;
  GtkWidget *statusbar;

  scales->no_rec = 1;

  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (window), "Somaplayer Controller");
  g_signal_connect ((gpointer) window, "destroy", G_CALLBACK (gtk_main_quit),
		    NULL);

  box = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (box);
  gtk_container_add (GTK_CONTAINER (window), box);
  frame = gtk_frame_new ("Somaplayer Controller");
  gtk_widget_show (frame);
  gtk_box_pack_start (GTK_BOX (box), frame, TRUE, TRUE, 0);

  vbox = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox);
  gtk_container_add (GTK_CONTAINER (frame), vbox);

  hbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox);
  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);

  button = gtk_button_new_with_mnemonic ("Prev");
  gtk_widget_show (button);
  gtk_box_pack_start (GTK_BOX (hbox), button, FALSE, FALSE, 0);
  g_signal_connect ((gpointer) button, "clicked", G_CALLBACK (b_prev), c);

  button = gtk_button_new_with_mnemonic ("Next");
  gtk_widget_show (button);
  gtk_box_pack_start (GTK_BOX (hbox), button, FALSE, FALSE, 0);
  g_signal_connect ((gpointer) button, "clicked", G_CALLBACK (b_next), c);

  button = gtk_button_new_with_mnemonic ("Pause");
  gtk_widget_show (button);
  gtk_box_pack_start (GTK_BOX (hbox), button, FALSE, FALSE, 0);
  g_signal_connect ((gpointer) button, "clicked", G_CALLBACK (b_pause), c);

  button = gtk_button_new_with_mnemonic ("Quit");
  gtk_widget_show (button);
  gtk_box_pack_start (GTK_BOX (hbox), button, FALSE, FALSE, 0);
  g_signal_connect ((gpointer) button, "clicked", G_CALLBACK (b_quit), c);

  adj = (GtkAdjustment *) gtk_adjustment_new ((gdouble) v, 0, 100, 5, 5, 0);
  scale = gtk_hscale_new (adj);
  gtk_widget_show (scale);
  gtk_box_pack_start (GTK_BOX (vbox), scale, FALSE, FALSE, 0);
  g_signal_connect ((gpointer) scale, "value_changed", G_CALLBACK (s_volume),
		    c);

  scales->v = scale;

  adj =
    (GtkAdjustment *)
    gtk_adjustment_new ((gdouble) ((b + 100) != 0 ? (b + 100) / 2 : 0), 0,
			100, 5, 5, 0);
  scale = gtk_hscale_new (adj);
  gtk_widget_show (scale);
  gtk_box_pack_start (GTK_BOX (vbox), scale, FALSE, FALSE, 0);
  g_signal_connect ((gpointer) scale, "value_changed", G_CALLBACK (s_balance),
		    c);

  scales->b = scale;

  statusbar = gtk_statusbar_new ();
  gtk_widget_show (statusbar);
  gtk_box_pack_start (GTK_BOX (box), statusbar, FALSE, FALSE, 0);

  scales->sb = statusbar;
  scales->sb_id =
    gtk_statusbar_get_context_id (GTK_STATUSBAR (statusbar), "");

  gtk_widget_show (window);
}

gint
timeout (somaplayer_controller * c)
{
  int vol, bal;
  double v, b;
  GtkAdjustment *adj;
  char *file;

  if (scales->no_timer)
    return TRUE;

  if (somaplayer_get_volume (c, &vol))
    quit ();

  if (somaplayer_get_balance (c, &bal))
    quit ();

  if (!(file = somaplayer_this (c)))
    quit ();

  v = (double) vol;
  b = (double) bal;

  adj = gtk_range_get_adjustment (GTK_RANGE (scales->v));
  if (adj->value != v)
    {
      scales->no_rec = 1;
      gtk_adjustment_set_value (adj, v);
      scales->no_rec = 0;
    }

  adj = gtk_range_get_adjustment (GTK_RANGE (scales->b));

  if (adj->value != ((b + 100) != 0 ? (b + 100) / 2 : 0))
    {
      scales->no_rec = 1;
      gtk_adjustment_set_value (adj,
				((b + 100) / 2) != 0 ? (b + 100) / 2 : 0);
      scales->no_rec = 0;
    }

  if (file)
    {
      gtk_statusbar_pop (GTK_STATUSBAR (scales->sb), scales->sb_id);
      scales->sb_id =
	gtk_statusbar_push (GTK_STATUSBAR (scales->sb), scales->sb_id, file);
      free (file);
    }

  return TRUE;
}

int
usage (void)
{
  fprintf (stderr,
	   "Usage:\n\n" "\t%s [unix://file] or [tcp://server[:port]]\n\n"
	   "You can run:\n\n" "\t%s [unix] or [tcp]\n"
	   "for generic connections\n\n", NAME_EXAMPLE, NAME_EXAMPLE);
  return 1;
}

somaplayer_controller *
parse (char *a)
{

  if (!strcmp (a, "unix"))
    return somaplayer_open_unix (NULL);

  if (!strcmp (a, "tcp"))
    return somaplayer_open_tcp (NULL, 0);

  if (!strncmp (a, "unix://", 7))
    {
      char *file;
      file = a + 7;

      return somaplayer_open_unix (file);
    }

  if (!strncmp (a, "tcp://", 6))
    {
      char *server;
      int i, port = 0;

      server = a + 6;

      for (i = 0; i < strlen (server); i++)
	{
	  if (server[i] == ':')
	    {

	      if (i + 1 < strlen (server))
		{
		  port = atoi (&server[i + 1]);
		}

	      server[i] = 0;
	    }
	}

      return somaplayer_open_tcp (server, port);
    }

  return NULL;
}

int
main (int argc, char *argv[])
{
  somaplayer_controller *c;
  int v, b;

  if (argc != 2 || (!strcmp (argv[1], "-h") || !strcmp (argv[1], "--help")))
    return usage ();

  if (!(c = parse (argv[1])))
    {
      puts ("Argoment error!");
      return 1;
    }

  if (!(scales = (vb_scales *) malloc (sizeof (vb_scales))))
    {
      puts ("Error: memory.");
      return 1;
    }

  if (somaplayer_get_volume (c, &v))
    quit ();
  if (somaplayer_get_balance (c, &b))
    quit ();

  gtk_init (NULL, NULL);
  create_window (c, v, b);

  scales->no_rec = 0;
  scales->no_timer = 0;

  g_timeout_add (800, timeout, c);

  gtk_main ();

  if (somaplayer_close (c))
    quit ();

  return 0;
}
