/* Somaplayer - Copyright (C) 2003-4 bakunin - Andrea Marchesini 
 *                                     <bakunin@autistici.org>
 *
 * This source code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published 
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This source code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * Please refer to the GNU Public License for more details.
 *
 * You should have received a copy of the GNU Public License along with
 * this source code; if not, write to:
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This program is released under the GPL with the additional exemption that
 * compiling, linking, and/or using OpenSSL is allowed.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#else
# error Use configure; make; make install
#endif

#include "player.h"
#include "bad_list.h"
#include "other.h"
#include "output.h"

void *bad_list_thread (void *);

void
bad_list_insert (audio * ao)
{
  audio *o;

  if (!(o = (audio *) malloc (sizeof (audio))))
    fatal ("Error: memory.");
  memcpy (o, ao, sizeof (audio));

  pthread_mutex_lock (&play->bad_list_mutex);

  o->next = play->bad_list;
  play->bad_list = o;

  pthread_mutex_unlock (&play->bad_list_mutex);

  msg("Insert the removed output in the bad list.");
  /* Insert output struct  in the bad list */
  if (play->bad_list_status == BAD_LIST_STOP)
    {
      pthread_join (play->bad_list_th, NULL);
      play->bad_list_status = BAD_LIST_NULL;
    }

  if (play->bad_list_status == BAD_LIST_NULL)
    {
      if (pthread_create (&play->bad_list_th, NULL, bad_list_thread, NULL))
	fatal (_("Thread error."));
      play->bad_list_status = BAD_LIST_WORK;
    }
}

void *
bad_list_thread (void *dummy)
{
  int ret = 0;

  while (!events.quit && !ret)
    {
      sleep (BAD_LIST_TIMER);

      pthread_mutex_lock (&play->bad_list_mutex);

      if (!play->bad_list)
	ret = 1;
      else
	{

	  audio *ao, *ao2 = NULL;
	  ao = play->bad_list;

	  while (ao)
	    {
	      if (!ao->
		  open (ao, play->ao_rate, play->ao_channels,
			play->ao_bitrate))
		{
		  msg("Re-insert a removed output.");

		  if (!ao2)
		    play->bad_list = ao->next;
		  else
		    ao2 = ao->next;

		  output_lock ();
		  ao->next = play->output;
		  play->output = ao;
		  output_unlock ();
		}

	      ao2 = ao;
	      ao = ao->next;
	    }
	}

      pthread_mutex_unlock (&play->bad_list_mutex);
    }

  play->bad_list_status = BAD_LIST_STOP;
  pthread_exit (NULL);
}

/* EOF */
