/* Somaplayer - Copyright (C) 2003-4 bakunin - Andrea Marchesini 
 *                                     <bakunin@autistici.org>
 *
 * This source code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published 
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This source code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * Please refer to the GNU Public License for more details.
 *
 * You should have received a copy of the GNU Public License along with
 * this source code; if not, write to:
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This program is released under the GPL with the additional exemption that
 * compiling, linking, and/or using OpenSSL is allowed.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#else
# error Use configure; make; make install
#endif

#ifdef ENABLE_GTK

#include "../player.h"
#include "gdaemon.h"
#include "../other.h"
#include "../admin.h"

/* It searchs the somaplayer binary program. */
void
on_dplayer_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  char p[SIZE_BUFFER];
  struct stat st;
  GtkWidget *dialog;

  snprintf (p, SIZE_BUFFER, "/usr/bin/somaplayer");
  if (!lstat (p, &st))
    {
      run_gsplayer (p);
      return;
    }

  snprintf (p, SIZE_BUFFER, "/usr/local/bin/somaplayer");
  if (!lstat (p, &st))
    {
      run_gsplayer (p);
      return;
    }

  snprintf (p, SIZE_BUFFER, "./somaplayer");
  if (!lstat (p, &st))
    {
      run_gsplayer (p);
      return;
    }

  dialog = gtk_message_dialog_new (GTK_WINDOW (windaemon),
				   GTK_DIALOG_MODAL |
				   GTK_DIALOG_DESTROY_WITH_PARENT,
				   GTK_MESSAGE_ERROR, GTK_BUTTONS_OK,
				   _("SomaPlayer not found."));

  gtk_dialog_run (GTK_DIALOG (dialog));
  gtk_widget_destroy (dialog);
}

/* Run the player */

void
run_gsplayer (char *a)
{
  char *argv[7];

  argv[0] = a;
  argv[1] = "-g";
  argv[2] = "-ao";
  argv[3] = "sds";
  argv[4] = "-ad";

  if(play->daemon->socket==SOCKET_TCP)
    argv[5] = "tcp://localhost";
  else
    argv[5] = "unix";

  argv[6] = NULL;

  switch (fork ())
    {
    case -1:
      fatal (_("Fork error."));
    case 0:
      execve (argv[0], argv, env);
      break;
    default:
      gpid++;
      break;
    }
}

/* Check the program. If someone exists, I use a waitpid. */
int
gtimeout (gpointer t)
{
  int p;

  if (gpid)
    {
      p = waitpid (0, NULL, WNOHANG);

      if (p > 0 || (p == -1 && errno == ECHILD))
	gpid--;
    }

  return 1;
}
#endif

/* EOF */
