/* Somaplayer - Copyright (C) 2003-4 bakunin - Andrea Marchesini 
 *                                     <bakunin@autistici.org>
 *
 * This source code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published 
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This source code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * Please refer to the GNU Public License for more details.
 *
 * You should have received a copy of the GNU Public License along with
 * this source code; if not, write to:
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This program is released under the GPL with the additional exemption that
 * compiling, linking, and/or using OpenSSL is allowed.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#else
# error Use configure; make; make install
#endif

#ifdef ENABLE_CDAUDIO

#include "../player.h"
#include "../file.h"
#include "../format.h"
#include "../list.h"
#include "graphic.h"

void
add_cdaudio_activate (GtkWidget * w, gpointer data)
{
  GtkWidget *dialog;
  GtkWidget *box;
  GtkWidget *stock;
  GtkWidget *scrolledwindow;
  GtkTreeSelection *selection;
  GtkListStore *model;
  GtkTreeIter iter;
  GtkCellRenderer *renderer;
  GtkWidget *cdaudio_list;
  cdrom_drive *d;
  int k;
  char s[SIZE_BUFFER];

  d = cdda_identify (play->cd, CDDA_MESSAGE_FORGETIT, NULL);
  cdda_verbose_set (d, CDDA_MESSAGE_FORGETIT, CDDA_MESSAGE_FORGETIT);

  if (cdda_open (d))
    {
      gtk_dialog_msg (_("Cdaudio no present."));
      return;
    }

  dialog =
    gtk_dialog_new_with_buttons (_("SomaPlayer - CdAudio Select Tracks"),
				 GTK_WINDOW (winmain),
				 GTK_DIALOG_MODAL |
				 GTK_DIALOG_DESTROY_WITH_PARENT, GTK_STOCK_OK,
				 GTK_RESPONSE_OK, GTK_STOCK_CANCEL,
				 GTK_RESPONSE_CANCEL, NULL);

  box = gtk_hbox_new (FALSE, 8);
  gtk_container_set_border_width (GTK_CONTAINER (box), 8);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox), box, FALSE, FALSE,
		      0);
  stock =
    gtk_image_new_from_stock (GTK_STOCK_DIALOG_QUESTION,
			      GTK_ICON_SIZE_DIALOG);
  gtk_box_pack_start (GTK_BOX (box), stock, FALSE, FALSE, 0);

  scrolledwindow = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (scrolledwindow);
  gtk_box_pack_start (GTK_BOX (box), scrolledwindow, TRUE, TRUE, 0);
  gtk_widget_set_size_request (scrolledwindow, 250, -1);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow),
				  GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  model = gtk_list_store_new (1, G_TYPE_STRING);
  cdaudio_list = gtk_tree_view_new_with_model (GTK_TREE_MODEL (model));
  selection = gtk_tree_view_get_selection (GTK_TREE_VIEW (cdaudio_list));
  gtk_tree_selection_set_mode (selection, GTK_SELECTION_MULTIPLE);
  gtk_tree_view_set_rules_hint (GTK_TREE_VIEW (cdaudio_list), TRUE);
  gtk_tree_view_set_search_column (GTK_TREE_VIEW (cdaudio_list), 0);

  renderer = gtk_cell_renderer_text_new ();
  gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (cdaudio_list),
					       -1, _("Tracks"), renderer,
					       "text", 0, NULL);

  gtk_widget_show (cdaudio_list);

  for (k = 0; k < d->tracks; k++)
    {
      snprintf (s, SIZE_BUFFER, _("Track %d"), k + 1);
      gtk_list_store_append (GTK_LIST_STORE (model), &iter);
      gtk_list_store_set (GTK_LIST_STORE (model), &iter, 0, s, -1);
    }

  cdda_close (d);

  g_object_unref (model);

  gtk_container_add (GTK_CONTAINER (scrolledwindow), cdaudio_list);

  gtk_widget_show_all (box);

  if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_OK)
    {
      GtkTreeModel *model2;
      GList *list;
      int k;

      list = gtk_tree_selection_get_selected_rows (selection, &model2);

      format_add (TYPE_CDAUDIO);
      while (list)
	{

	  k = gtk_tree_path_get_indices (list->data)[0];
	  gtk_tree_path_free (list->data);

	  if (list_add_cdrom_n (k + 1))
	    {
	      gtk_dialog_msg (_("Error in cdaudio."));
	      break;
	    }

	  list = list->next;
	}

      g_list_free (list);

      playlist_refresh ();

    }

  gtk_widget_destroy (dialog);
}

#endif

/* EOF */
