/* Somaplayer - Copyright (C) 2003-4 bakunin - Andrea Marchesini 
 *                                     <bakunin@autistici.org>
 *
 * This source code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published 
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This source code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * Please refer to the GNU Public License for more details.
 *
 * You should have received a copy of the GNU Public License along with
 * this source code; if not, write to:
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This program is released under the GPL with the additional exemption that
 * compiling, linking, and/or using OpenSSL is allowed.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#else
# error Use configure; make; make install
#endif

#ifdef ENABLE_SNDFILE

#include "../player.h"
#include "../audio.h"
#include "../output.h"
#include "../other.h"
#include "../output/sndfile/fsndfile.h"
#include "graphic.h"

void
on_write_a_file_new_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  GtkWidget *dialog;
  GtkWidget *box;
  GtkWidget *table;
  GtkWidget *stock;
  GtkWidget *label;

  GtkWidget *combo;
  GtkWidget *entry;

  audio *tmp;
  audio_data_sndfile *data;

  dialog =
    gtk_dialog_new_with_buttons (_("SomaPlayer - Write a File configuration"),
				 GTK_WINDOW (winmain),
				 GTK_DIALOG_MODAL |
				 GTK_DIALOG_DESTROY_WITH_PARENT, GTK_STOCK_OK,
				 GTK_RESPONSE_OK, GTK_STOCK_CANCEL,
				 GTK_RESPONSE_CANCEL, NULL);

  box = gtk_hbox_new (FALSE, 8);
  gtk_container_set_border_width (GTK_CONTAINER (box), 8);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox), box, FALSE, FALSE,
		      0);

  stock =
    gtk_image_new_from_stock (GTK_STOCK_DIALOG_QUESTION,
			      GTK_ICON_SIZE_DIALOG);
  gtk_box_pack_start (GTK_BOX (box), stock, FALSE, FALSE, 0);

  table = gtk_table_new (0, 0, FALSE);
  gtk_table_set_row_spacings (GTK_TABLE (table), 4);
  gtk_table_set_col_spacings (GTK_TABLE (table), 4);
  gtk_box_pack_start (GTK_BOX (box), table, TRUE, TRUE, 0);

  label = gtk_label_new_with_mnemonic (_("File:"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 0, 1);
  entry = gtk_entry_new ();
  gtk_table_attach_defaults (GTK_TABLE (table), entry, 1, 2, 0, 1);

  label = gtk_label_new_with_mnemonic (_("Type File:"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 1, 2);

  combo = gtk_combo_box_new_text ();

  gtk_combo_box_append_text (GTK_COMBO_BOX (combo),
			     "Wav - Microsoft WAV format (little endian)");
  gtk_combo_box_append_text (GTK_COMBO_BOX (combo),
			     "Aiff -  Apple/SGI AIFF format (big endian)");
  gtk_combo_box_append_text (GTK_COMBO_BOX (combo),
			     "Au - Sun/NeXT AU file format (big endian)");
  gtk_combo_box_append_text (GTK_COMBO_BOX (combo), "Raw - Raw PCM data");
  gtk_combo_box_append_text (GTK_COMBO_BOX (combo),
			     "Paf - Ensoniq PARIS file format");
  gtk_combo_box_append_text (GTK_COMBO_BOX (combo),
			     "Svx -  Amiga IFF / SVX8 / SV16 format");
  gtk_combo_box_append_text (GTK_COMBO_BOX (combo),
			     "Nist - Sphere NIST format");
  gtk_combo_box_append_text (GTK_COMBO_BOX (combo), "Voc -  Voc files");
  gtk_combo_box_append_text (GTK_COMBO_BOX (combo),
			     "Ircam - Berkeley/IRCAM/CARL");
  gtk_combo_box_append_text (GTK_COMBO_BOX (combo),
			     "W64 - Sonic Foundry's 64 bit RIFF/WAV");
  gtk_combo_box_append_text (GTK_COMBO_BOX (combo),
			     "Mat4 - Matlab (tm) V4.2 / GNU Octave 2.0");
  gtk_combo_box_append_text (GTK_COMBO_BOX (combo),
			     "Mat5 - Matlab (tm) V5.0 / GNU Octave 2.1");
  gtk_combo_box_append_text (GTK_COMBO_BOX (combo),
			     "Pvf -  Portable Voice Format");
  gtk_combo_box_append_text (GTK_COMBO_BOX (combo),
			     "XI - Fasttracker 2 Extended Instrument");
  gtk_combo_box_append_text (GTK_COMBO_BOX (combo),
			     "Htk - HMM Tool Kit format");
#ifdef USE_MIDI
  gtk_combo_box_append_text (GTK_COMBO_BOX (combo),
			     "Midi - Midi Sample Dump Standard");
#endif

#ifdef USE_AVR
  gtk_combo_box_append_text (GTK_COMBO_BOX (combo),
			     "Avr - Audio Visual Research");
#endif

#ifdef USE_WAVEX
  gtk_combo_box_append_text (GTK_COMBO_BOX (combo),
			     "Wavex - MS WAVE with WAVEFORMATEX");
#endif

  gtk_combo_box_set_active (GTK_COMBO_BOX (combo), 0);

  gtk_table_attach_defaults (GTK_TABLE (table), combo, 1, 2, 1, 2);

  gtk_widget_show_all (box);

  while (1)
    {
      if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_OK)
	{

	  if (!strlen (gtk_entry_get_text (GTK_ENTRY (entry))))
	    {
	      gtk_dialog_msg (_("No file?"));
	      continue;

	    }

	  if (!(tmp = (audio *) malloc (sizeof (audio))))
	    fatal (_("Error: memory."));

	  if (!
	      (data =
	       (audio_data_sndfile *) malloc (sizeof (audio_data_sndfile))))
	    fatal (_("Error: memory."));

	  data->fd = NULL;

	  tmp->realtime = 0;

	  tmp->open = sndfile_init;
	  tmp->write = sndfile_write;
	  tmp->close = sndfile_quit;
	  tmp->check = NULL;
	  tmp->info = sndfile_show;
	  tmp->data = data;
	  tmp->next = NULL;
	  tmp->status = OUTPUT_DONE;

	  tmp->stop = 0;

	  switch (gtk_combo_box_get_active (GTK_COMBO_BOX (combo)))
	    {
	    case 0:
	      tmp->audio_type = USE_WAV;
	      break;
	    case 1:
	      tmp->audio_type = USE_AIFF;
	      break;
	    case 2:
	      tmp->audio_type = USE_AU;
	      break;
	    case 3:
	      tmp->audio_type = USE_RAW;
	      break;
	    case 4:
	      tmp->audio_type = USE_PAF;
	      break;
	    case 5:
	      tmp->audio_type = USE_SVX;
	      break;
	    case 6:
	      tmp->audio_type = USE_NIST;
	      break;
	    case 7:
	      tmp->audio_type = USE_VOC;
	      break;
	    case 8:
	      tmp->audio_type = USE_IRCAM;
	      break;
	    case 9:
	      tmp->audio_type = USE_W64;
	      break;
	    case 10:
	      tmp->audio_type = USE_MAT4;
	      break;
	    case 11:
	      tmp->audio_type = USE_MAT5;
	      break;
	    case 12:
	      tmp->audio_type = USE_PVF;
	      break;
	    case 13:
	      tmp->audio_type = USE_XI;
	      break;
	    case 14:
	      tmp->audio_type = USE_HTK;
	      break;
#ifdef  USE_MIDI
	    case 15:
	      tmp->audio_type = USE_MIDI;
	      break;
#endif

#ifdef  USE_AVR
	    case 16:
	      tmp->audio_type = USE_AVR;
	      break;
#endif

#ifdef  USE_WAVEX
	    case 17:
	      tmp->audio_type = USE_WAVEX;
	      break;
#endif
	    }

	  if (!
	      (tmp->audio_dev =
	       strdup (gtk_entry_get_text (GTK_ENTRY (entry)))))
	    fatal (_("Error: memory."));

	  if (pthread_cond_init (&tmp->cond, NULL))
	    fatal (_("Error: Cond init."));
	  if (pthread_mutex_init (&tmp->mutex, NULL))
	    fatal (_("Error: Mutex init."));
	  if (pthread_create (&tmp->th, NULL, output_thread, tmp))
	    fatal (_("Thread error."));

	  if (play->ao_rate && play->ao_channels && play->ao_bitrate)
	    {
	      if (tmp->
		  open (tmp, play->ao_rate, play->ao_channels,
			play->ao_bitrate))
		{
		  free (tmp->audio_dev);
		  free (tmp);
		}
	      else
		{

		  tmp->info (tmp);

		  output_lock ();

		  tmp->next = play->output;
		  play->output = tmp;

		  output_unlock ();

		  output_window_add (tmp, PREPEND);
		}
	    }
	  else
	    {
	      output_lock ();

	      tmp->next = play->output;
	      play->output = tmp;

	      output_unlock ();

	      output_window_add (tmp, PREPEND);
	    }
	}
      break;
    }

  gtk_widget_destroy (dialog);
}

#endif

/* EOF */
