/* Somaplayer - Copyright (C) 2003-4 bakunin - Andrea Marchesini 
 *                                     <bakunin@autistici.org>
 *
 * This source code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published 
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This source code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * Please refer to the GNU Public License for more details.
 *
 * You should have received a copy of the GNU Public License along with
 * this source code; if not, write to:
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This program is released under the GPL with the additional exemption that
 * compiling, linking, and/or using OpenSSL is allowed.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#else
# error Use configure; make; make install
#endif

#ifdef ENABLE_SNDFILE

#include "../player.h"
#include "../audio.h"
#include "graphic.h"

void
on_write_a_file_show_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  GtkWidget *dialog;
  GtkWidget *box;
  GtkWidget *table;
  GtkWidget *stock;
  GtkWidget *label;

  GtkWidget *entry1;
  GtkWidget *entry2;

  audio *ao = (audio *) user_data;

  if (!ao)
    return;

  dialog =
    gtk_dialog_new_with_buttons (_("SomaPlayer - Write a File configuration"),
				 GTK_WINDOW (winmain),
				 GTK_DIALOG_MODAL |
				 GTK_DIALOG_DESTROY_WITH_PARENT, GTK_STOCK_OK,
				 GTK_RESPONSE_OK, GTK_STOCK_CANCEL,
				 GTK_RESPONSE_CANCEL, NULL);

  box = gtk_hbox_new (FALSE, 8);
  gtk_container_set_border_width (GTK_CONTAINER (box), 8);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox), box, FALSE, FALSE,
		      0);

  stock =
    gtk_image_new_from_stock (GTK_STOCK_DIALOG_QUESTION,
			      GTK_ICON_SIZE_DIALOG);
  gtk_box_pack_start (GTK_BOX (box), stock, FALSE, FALSE, 0);

  table = gtk_table_new (0, 0, FALSE);
  gtk_table_set_row_spacings (GTK_TABLE (table), 4);
  gtk_table_set_col_spacings (GTK_TABLE (table), 4);
  gtk_box_pack_start (GTK_BOX (box), table, TRUE, TRUE, 0);

  label = gtk_label_new_with_mnemonic (_("File:"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 0, 1);
  entry1 = gtk_entry_new ();
  gtk_table_attach_defaults (GTK_TABLE (table), entry1, 1, 2, 0, 1);
  gtk_entry_set_text (GTK_ENTRY (entry1), ao->audio_dev);
  gtk_entry_set_editable (GTK_ENTRY (entry1), FALSE);

  label = gtk_label_new_with_mnemonic (_("Type File:"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 1, 2);

  entry2 = gtk_entry_new ();

  switch (ao->audio_type)
    {
    case USE_WAV:
      gtk_entry_set_text (GTK_ENTRY (entry2),
			  _("WAV - Windows WAV format (little endian)"));
      break;
    case USE_AIFF:
      gtk_entry_set_text (GTK_ENTRY (entry2),
			  _("Apple/SGI AIFF format (big endian)"));
      break;
    case USE_AU:
      gtk_entry_set_text (GTK_ENTRY (entry2),
			  _("Sun/NeXT AU file format (big endian)"));
      break;
    case USE_RAW:
      gtk_entry_set_text (GTK_ENTRY (entry2), _("Raw PCM data"));
      break;
    case USE_PAF:
      gtk_entry_set_text (GTK_ENTRY (entry2), _("Ensoniq PARIS file format"));
      break;
    case USE_SVX:
      gtk_entry_set_text (GTK_ENTRY (entry2),
			  _("Amiga IFF / SVX8 / SV16 format"));
      break;
    case USE_NIST:
      gtk_entry_set_text (GTK_ENTRY (entry2), _("Sphere NIST format"));
      break;
    case USE_VOC:
      gtk_entry_set_text (GTK_ENTRY (entry2), _("Voc files"));
      break;
    case USE_IRCAM:
      gtk_entry_set_text (GTK_ENTRY (entry2), _("Berkeley/IRCAM/CARL"));
      break;
    case USE_W64:
      gtk_entry_set_text (GTK_ENTRY (entry2),
			  _("Sonic Foundry's 64 bit RIFF/WAV"));
      break;
    case USE_MAT4:
      gtk_entry_set_text (GTK_ENTRY (entry2),
			  _("Matlab (tm) V4.2 / GNU Octave 2.0"));
      break;
    case USE_MAT5:
      gtk_entry_set_text (GTK_ENTRY (entry2),
			  _("Matlab (tm) V5.0 / GNU Octave 2.1"));
      break;
    case USE_PVF:
      gtk_entry_set_text (GTK_ENTRY (entry2), _("Portable Voice Format"));
      break;
    case USE_XI:
      gtk_entry_set_text (GTK_ENTRY (entry2),
			  _("Fasttracker 2 Extended Instrument"));
      break;
    case USE_HTK:
      gtk_entry_set_text (GTK_ENTRY (entry2), _("HMM Tool Kit format"));
      break;

#ifdef USE_MIDI
    case USE_MIDI:
      gtk_entry_set_text (GTK_ENTRY (entry2), _("Midi Sample Dump Standard"));
      break;
#endif

#ifdef USE_AVR
    case USE_AVR:
      gtk_entry_set_text (GTK_ENTRY (entry2), _("Audio Visual Research"));
      break;
#endif

#ifdef USE_WAVEX
    case USE_WAVEX:
      gtk_entry_set_text (GTK_ENTRY (entry2), _("MS WAVE with WAVEFORMATEX"));
      break;
#endif
    }
  gtk_entry_set_editable (GTK_ENTRY (entry2), FALSE);

  gtk_table_attach_defaults (GTK_TABLE (table), entry2, 1, 2, 1, 2);

  gtk_widget_show_all (box);

  gtk_dialog_run (GTK_DIALOG (dialog));
  gtk_widget_destroy (dialog);
}

#endif

/* EOF */
