/* Somaplayer - Copyright (C) 2003-4 bakunin - Andrea Marchesini 
 *                                     <bakunin@autistici.org>
 *
 * This source code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published 
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This source code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * Please refer to the GNU Public License for more details.
 *
 * You should have received a copy of the GNU Public License along with
 * this source code; if not, write to:
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This program is released under the GPL with the additional exemption that
 * compiling, linking, and/or using OpenSSL is allowed.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#else
# error Use configure; make; make install
#endif

#include "player.h"
#include "mix.h"

void
mix_8_mono_16_stereo (char *buf, int size, int rate, char *dst)
{

  signed short *buffer = (signed short *) dst;
  signed short sample;
  int i = 0, k = 0;

  while (i < size)
    {

      k = i * rate / 44100;
      k /= 2;

      sample = buf[k++];
      sample -= 127;
      sample *= 256;
      buffer[i++] = sample;
      buffer[i++] = sample;
    }
}

void
mix_8_stereo_16_stereo (char *buf, int size, int rate, char *dst)
{
  signed short *buffer = (signed short *) dst;
  signed short sample;
  int i = 0, k = 0;

  if (rate == 44100)
    {

      while (i < size)
	{
	  sample = (buf[i] - 127) * 256;
	  buffer[i++] += sample;
	}
    }
  else
    {
      while (i < size)
	{
	  i = k * rate / 44100;

	  sample = buf[k++];
	  sample -= 127;
	  sample *= 256;

	  buffer[i++] = sample;
	}
    }
}

void
mix_16_mono_16_stereo (char *buf, int size, int rate, char *dst)
{
  signed short sample;
  signed short *buffer = (signed short *) dst;
  signed short *pre = (signed short *) buf;
  int i = 0, k = 0;

  while (i < size)
    {
      k = i * rate / 44100;
      k /= 2;

      sample = pre[k++];

      buffer[i++] = sample;
      buffer[i++] = sample;
    }
}

void
mix_16_stereo_16_stereo (char *buf, int size, int rate, char *dst)
{
  signed short sample;
  signed short *buffer = (signed short *) dst;
  signed short *pre = (signed short *) buf;
  int i = 0, k = 0;

  if (rate == 44100)
    {
      memcpy (dst, buf, size);
    }
  else
    {
      while (i < size)
	{
	  k = i * rate / 44100;
	  sample = pre[k++];
	  buffer[i++] = sample;
	}
    }
}

/* EOF */
