/* Somaplayer - Copyright (C) 2003-5 bakunin - Andrea Marchesini 
 *                                     <bakunin@autistici.org>
 *
 * This source code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published 
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This source code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * Please refer to the GNU Public License for more details.
 *
 * You should have received a copy of the GNU Public License along with
 * this source code; if not, write to:
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This program is released under the GPL with the additional exemption that
 * compiling, linking, and/or using OpenSSL is allowed.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#else
# error Use configure; make; make install
#endif

#ifdef ENABLE_GTK

#include "../player.h"
#include "../other.h"
#include "gdaemon.h"

GtkWidget *cross_b_active;

/* Hide and show the crossfade window */
void
crossfade_b_hide (GtkWidget * w, gpointer data)
{
  gtk_widget_hide (crossfade_b);
}

void
crossfade_b_show (GtkWidget * w, gpointer data)
{
  gtk_widget_show (crossfade_b);
}

/* Update the graphic element and the output values */
void
crossfade_b_value_changed (GtkWidget * widget, gpointer user_data)
{
  GtkAdjustment *v, *k;
  static double value = 0;
  int i;
  double diff_value, j;

  if (!gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (cross_b_active)))
    return;

  v = gtk_range_get_adjustment (GTK_RANGE (widget));

  diff_value = v->value - value;

  stop_50_cent = 1;

  for (i = 0; i < DAEMON_MAX_CLIENTS; i++)
    {
      if (play->daemon->client[i] != NULL)
	{

	  if (play->daemon->client[i]->b_up)
	    {
	      k =
		gtk_range_get_adjustment (GTK_RANGE
					  (play->daemon->client[i]->
					   w_balance));
	      j = k->value + diff_value;

	      if (j < 0)
		j = 0;
	      if (j > 100)
		j = 100;

	      gtk_adjustment_set_value (k, j);

	    }
	  else if (play->daemon->client[i]->b_down)
	    {
	      k =
		gtk_range_get_adjustment (GTK_RANGE
					  (play->daemon->client[i]->
					   w_balance));
	      j = k->value - diff_value;

	      if (j < 0)
		j = 0;
	      if (j > 100)
		j = 100;

	      gtk_adjustment_set_value (k, j);
	    }

	}
    }

  stop_50_cent = 0;

  value = v->value;
}

/* Active the widget UP */
void
crossfade_b_up_toggled (GtkWidget * widget, gpointer user_data)
{
  daemon_client *c = (daemon_client *) user_data;

  if (!c)
    fatal (_("Internal error."));

  if (!gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (widget)))
    {
      c->b_up = 0;
      return;
    }

  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (c->w_b_down), FALSE);
  c->b_down = 0;
  c->b_up = 1;
}

/* Active the widget DOWN */
void
crossfade_b_down_toggled (GtkWidget * widget, gpointer user_data)
{
  daemon_client *c = (daemon_client *) user_data;

  if (!c)
    fatal (_("Internal error."));

  if (!gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (widget)))
    {
      c->b_down = 0;
      return;
    }

  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (c->w_b_up), FALSE);
  c->b_down = 1;
  c->b_up = 0;
}

/* Create the window */
GtkWidget *
create_crossfade_b (void)
{
  GtkWidget *window;
  GtkWidget *frame;
  GtkWidget *cross;
  GtkWidget *box;

  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_size_request (window, 400, -1);
  gtk_window_set_title (GTK_WINDOW (window), _("SdS - crossfade balance"));

  frame = gtk_frame_new (NULL);
  gtk_widget_show (frame);
  gtk_container_add (GTK_CONTAINER (window), frame);

  box = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (box);
  gtk_container_add (GTK_CONTAINER (frame), box);

  cross_b_active = gtk_check_button_new_with_mnemonic (_("_Active"));
  gtk_widget_show (cross_b_active);
  gtk_box_pack_start (GTK_BOX (box), cross_b_active, FALSE, FALSE, 0);

  cross =
    gtk_hscale_new (GTK_ADJUSTMENT
		    (gtk_adjustment_new (0, 0, 100, 5, 10, 0)));
  gtk_widget_show (cross);
  gtk_box_pack_start (GTK_BOX (box), cross, TRUE, TRUE, 0);

  g_signal_connect ((gpointer) window, "delete_event",
		    G_CALLBACK (crossfade_b_hide), NULL);
  g_signal_connect ((gpointer) cross, "value_changed",
		    G_CALLBACK (crossfade_b_value_changed), NULL);

  return window;
}

#endif

/* EOF */
