/* Somaplayer - Copyright (C) 2003-5 bakunin - Andrea Marchesini 
 *                                     <bakunin@autistici.org>
 *
 * This source code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published 
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This source code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * Please refer to the GNU Public License for more details.
 *
 * You should have received a copy of the GNU Public License along with
 * this source code; if not, write to:
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This program is released under the GPL with the additional exemption that
 * compiling, linking, and/or using OpenSSL is allowed.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#else
# error Use configure; make; make install
#endif

#include "../player.h"
#include "../other.h"
#include "graphic.h"

static int spls_win = 1;
static GtkWidget *sl_widget;

void spls_save(SomaList *sl, gpointer dummy) {
  if(somalist_save(sl)==FALSE) dialog_msg(_("Save error"));
}

gboolean
spls_key_event (GtkWidget * w, GdkEventKey * event, gpointer dummy)
{
  if (event->keyval == GDK_Escape)
    {
      spls_window_show (NULL, NULL);
      return TRUE;
    }

  return FALSE;
}

void spls_add_item(GtkWidget *w, SomaList *sl) {
  GList *list, *old;

  if(!(list=somalist_get_selected_items(sl))) return;
  old=list;

  while(list) {
    playlist_add ((char *)list->data);
    list=list->next;
  }

  g_list_free(old);
}

void spls_add_playlist(GtkWidget *w, SomaList *sl) {
  GList *list, *old;

  if(!(list=somalist_get_selected_playlist_items(sl))) return;
  old=list;

  while(list) {
    playlist_add ((char *)list->data);
    list=list->next;
  }

  g_list_free(old);
}

GtkWidget *
create_winspls (void)
{
  GtkWidget *window;
  GtkWidget *box;
  GtkWidget *hbox;
  GtkWidget *sep;
  GtkWidget *b;
  GtkWidget *image;
  GtkWidget *label;
  GtkWidget *alignment;
  char s[1024];

  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  snprintf (s, sizeof (s), _("%s %s - Soma Playlist"), NAME, VERSION);
  gtk_window_set_title (GTK_WINDOW (window), s);
  gtk_widget_set_size_request (window, gdk_screen_width() * 2 / 3, gdk_screen_height() * 2 / 3);

  g_signal_connect ((gpointer) window, "delete_event",
                    G_CALLBACK (spls_window_show), window);

  g_signal_connect ((gpointer) window, "key-press-event",
                    GTK_SIGNAL_FUNC (spls_key_event), NULL);

  box = gtk_vbox_new(0, FALSE);
  gtk_widget_show(box);
  gtk_container_add(GTK_CONTAINER(window), box);

  sl_widget=somalist_new();
  gtk_widget_show(sl_widget);
  gtk_box_pack_start (GTK_BOX (box), sl_widget, TRUE, TRUE, 0);
  somalist_set_file_default(SOMALIST(sl_widget));
  g_signal_connect ((gpointer) sl_widget, "changed",
                    GTK_SIGNAL_FUNC (spls_save), NULL);

  sep = gtk_hseparator_new ();
  gtk_widget_show(sep);
  gtk_widget_set_size_request (sep, -1, 10);
  gtk_box_pack_start (GTK_BOX (box), sep, FALSE, FALSE, 0);
  
  hbox = gtk_hbox_new (0, FALSE);
  gtk_widget_show(hbox);
  gtk_box_pack_start (GTK_BOX (box), hbox, FALSE, FALSE, 0);
  
  b = gtk_button_new ();
  gtk_widget_show(b);
  gtk_box_pack_start (GTK_BOX (hbox), b, TRUE, TRUE, 0);
  g_signal_connect ((gpointer) b, "clicked", GTK_SIGNAL_FUNC (spls_add_item), sl_widget);

  alignment = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (alignment);
  gtk_container_add (GTK_CONTAINER (b), alignment);

  box = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (box);
  gtk_container_add (GTK_CONTAINER (alignment), box);

  image = gtk_image_new_from_stock ("gtk-add", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image);
  gtk_box_pack_start (GTK_BOX (box), image, FALSE, FALSE, 0);

  label = gtk_label_new_with_mnemonic ("Add Item");
  gtk_widget_show (label);
  gtk_box_pack_start (GTK_BOX (box), label, FALSE, FALSE, 0);

  b = gtk_button_new ();
  gtk_widget_show(b);
  gtk_box_pack_start (GTK_BOX (hbox), b, TRUE, TRUE, 0);
  g_signal_connect ((gpointer) b, "clicked", GTK_SIGNAL_FUNC (spls_add_playlist), sl_widget);

  alignment = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (alignment);
  gtk_container_add (GTK_CONTAINER (b), alignment);

  box = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (box);
  gtk_container_add (GTK_CONTAINER (alignment), box);

  image = gtk_image_new_from_stock ("gtk-add", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image);
  gtk_box_pack_start (GTK_BOX (box), image, FALSE, FALSE, 0);

  label = gtk_label_new_with_mnemonic ("Add Playlist");
  gtk_widget_show (label);
  gtk_box_pack_start (GTK_BOX (box), label, FALSE, FALSE, 0);

  return window;
}

int
spls_window_show (GtkWidget * w, gpointer data)
{

  if (data || !spls_win)
    {
      spls_win = 1;
      gtk_widget_hide (winspls);
    }
  else if (spls_win)
    {
      somalist_refresh(SOMALIST(sl_widget));
      gtk_widget_show (winspls);
      spls_win = 0;
    }

  return TRUE;
}

/* EOF */
