/* Somaplayer - Copyright (C) 2003-5 bakunin - Andrea Marchesini 
 *                                     <bakunin@autistici.org>
 *
 * This source code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published 
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This source code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * Please refer to the GNU Public License for more details.
 *
 * You should have received a copy of the GNU Public License along with
 * this source code; if not, write to:
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This program is released under the GPL with the additional exemption that
 * compiling, linking, and/or using OpenSSL is allowed.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#else
# error Use configure; make; make install
#endif
#ifdef ENABLE_MIC

#include "../../player.h"
#include "../../other.h"

int
mic_read_config (char *file, format_data_mic * fmt)
{
  cfg_t *cfg;
  int a;

  cfg_opt_t opts[] = {
    CFG_INT ("rate", 44100, CFGF_NONE),
    CFG_INT ("bitrate", 16, CFGF_NONE),
    CFG_INT ("channels", OUT_MONO, CFGF_NONE),
    CFG_END ()
  };

  cfg = cfg_init (opts, CFGF_NOCASE);
  a = cfg_parse (cfg, file);

  if (a != 0)
    {
      if (a == CFG_FILE_ERROR)
	msg_error (_("No mic config file."));
      else if (a == CFG_PARSE_ERROR)
	msg_error (_("Error of parsing mic file."));

      return 1;
    }

  msg (_("Read mic config file."));

  fmt->rate = cfg_getint (cfg, "rate");
  fmt->bitrate = cfg_getint (cfg, "bitrate");
  fmt->channels = cfg_getint (cfg, "channels");

  cfg_free (cfg);

  return 0;
}

#endif
