7.1 Laufende Synths steuern

# Laufende Synths steuern

Bisher haben wir uns nur damit befasst, neue Sounds und Effekte zu 
starten.

Mit Sonic Pi kannst Du aber auch laufende Klänge steuern und verändern.
Um das zu tun, speichern wir die Referenz zu einem Synth in einer
Variable:

```
s = play 60, release: 5
```

Jetzt haben wir eine run-local Variable `s`. Sie repräsentiert einen
Synth, der die Note 60 spielt. Beachte, dass diese Variable
eine *lokale* ist - Du kannst nicht von anderen Runs, wie
beispielsweise Funktionen, auf sie zugreifen.

Sobald wir die Referenz in der Variable `s` haben, können wir den 
Synth mit Hilfe der `control`-Funktion steuern:

```
s = play 60, release: 5
sleep 0.5
control s, note: 65
sleep 0.5
control s, note: 67
sleep 3
control s, note: 72
```

Wichtig ist hier, dass wir nicht vier verschiedene Synths starten - 
wir starten einen einzigen und ändern danach dreimal die Tonhöhe, 
während er noch spielt.

Wir können jeden der Standard-Parameter an die `control`-Funktion 
übergeben. Das erlaubt Dir, Dinge wie `amp:`, `cutoff:` oder `pan:` zu 
kontrollieren.

## Nicht-kontrollierbare Parameter

Manche Parameter lassen sich nach dem Start des Synths nicht mehr
verändern. Das trifft auf alle ADSR-Hüllkurven-Parameter 
zu. Welche Parameter kontrollierbar sind, kannst Du in der 
Dokumentation im Hilfe-System herausfinden. Parameter, die mit *Can not
be changed once set* markiert sind, lassen sich nach dem Synth-Start
nicht mehr verändern.
