3.3 Étirement des échantillons

# Étirement des échantillons

Maintenant que nous pouvons jouer une variété de synthés et d'échantillons
pour créer une musique, il est temps d'apprendre comment modifier à 
la fois les synthés et les échantillons pour faire de la musique encore 
plus originale et intéressante. En premier, explorons la faculté 
d'*étirer* et de *compresser* les échantillons.

## Représentation des échantillons

Les échantillons ("samples") sont des sons pré-enregistrés stockés 
à l'aide de nombres qui représentent comment se déplace la membrane du 
haut-parleur pour reproduire le son. La membrane du haut-parleur peut 
avancer et reculer, et ainsi les nombres ont juste besoin de 
représenter la distance d'avancée ou de recul que la membrane doit 
avoir pour chaque moment dans le temps. Pour être capable de reproduire 
fidèlement un son enregistré, un échantillon a typiquement besoin de 
stocker des milliers de nombres par seconde. Sonic Pi prend cette liste 
de nombres et en alimente à la bonne vitesse l'ordinateur pour faire 
avancer et reculer comme il le faut la membrane de son haut-parleur 
pour reproduire le son. Cependant, c'est aussi amusant de changer la
vitesse à laquelle est alimenté le haut-parleur pour changer le son.

## Changement de vitesse ("Rate")

Jouons avec un des sons d'ambiance : `:ambi_choir`. Pour le jouer avec 
la vitesse par défaut, vous pouvez passer un argument `rate:` au `sample` :

```
sample :ambi_choir, rate: 1
```

Ceci le joue à la vitesse normale (1), aussi rien de spécial pour 
l'instant. Cependant, vous êtes libre de changer ce nombre pour une 
autre valeur. Que dire de `0.5` :

```
sample :ambi_choir, rate: 0.5
```

Wooh ! Que se passe-t-il ici ? Eh bien, deux choses. Premièrement, 
l'échantillon est joué pendant 2 fois plus de temps, deuxièmement le 
son est a un octave en-dessous. Explorons ces choses un peu plus en 
détails.

## Étirons

Un échantillon qui est amusant à étirer ou à compresser est Amen. A 
vitesse normale, on pourrait imaginer de l'insérer dans une piste de 
batterie et de basse :

```
sample :loop_amen
```

Toutefois en modifiant la vitesse on peut changer de genre. Essayez de 
réduire de moitié la vitesse pour une *vieille école hip-hop* :

```
sample :loop_amen, rate: 0.5
```

Si nous l'accélérons, nous entrons dans le territoire de la *jungle* :

```
sample :loop_amen, rate: 1.5
```

Maintenant pour notre astuce finale - voyons ce qui se passe lorsque 
nous utilisons un "rate" négatif :

```
sample :loop_amen, rate: -1
```

Wooh ! Il le joue à *l'envers* ! Maintenant, essayez de jouer avec des 
tas d'échantillons différents. Essayez des vitesses très rapides et
des vitesses insensément lentes. Voyez quels sons intéressants 
vous pouvez produire.

## Une simple explication de la vitesse d'échantillon ("sample rate")

Un moyen imagé d'assimiler les échantillons est de penser aux ressorts.  
La vitesse de lecture est comme l'étirement et la compression du ressort. 
Si vous jouez l'échantillon à la vitesse 2, vous compressez le ressort 
à la moitié de sa longueur normale. Ainsi l'échantillon met la 
moitié du temps à être joué puisqu'il est plus court. Si vous jouez 
l'échantillon à la moitié de la vitesse, vous *étirez le ressort* au 
double de sa longueur. Ainsi l'échantillon met deux fois plus de temps 
à être joué puisqu'il est plus long. Plus vous compressez (vitesse 
plus élevée), plus il devient court, plus vous étirez (vitesse plus 
lente), plus il devient long.

Compresser un ressort augmente sa densité (le nombre de spires par cm) 
- ceci est similaire à l'échantillon sonnant *plus aigu*. Étirer le 
ressort diminue sa densité, c'est similaire à un son *plus grave*.


## Les maths derrière la vitesse d'échantillon

(Cette section est fournie pour ceux que les détails intéressent. 
Soyez libre de la sauter...)

Comme nous l'avons vu ci-dessus, un échantillon est représenté par 
une longue liste de nombres qui représentent la position où devrait être
la membrane du haut-parleur dans le temps. Nous pouvons prendre cette 
liste de nombres et l'utiliser pour tracer un graphique qui 
ressemblerait à ceci :

![sample graph](../images/tutorial/sample.png)

Vous devriez avoir déjà vu des images comme cela. C'est appelé la
*forme d'onde* d'un échantillon. C'est juste un graphique de nombres. 
Typiquement, une forme d'onde comme cela aura 44100 points de données 
par seconde (en application du théorème d'échantillonnage de 
Nyquist-Shannon). Ainsi, si l'échantillon dure 2 secondes, la forme 
d'onde sera représentée par 88200 nombres qui alimenteront le 
haut-parleur à la vitesse de 44100 points par seconde. Bien sûr, nous 
pouvons l'alimenter à une vitesse double qui serait de 88200 points par 
seconde. Ceci prendrait ainsi une seconde à être joué. Nous pourrions 
aussi le jouer à la moitié de la vitesse qui serait donc de 22050 
points par seconde, en prenant 4 secondes pour être joué.

La durée d'un échantillon est affecté par la  vitesse de jeu : 

* Doubler la vitesse de jeu diminue de moitié la durée du jeu,
* Diminuer de moitié la vitesse de jeu double la durée de jeu,
* Utiliser une vitesse de jeu d'un quart quadruple la durée du jeu,
* Utiliser une vitesse de jeu de 1/10 fait durer le jeu 10 fois plus 
longtemps.


On peut représenter ceci avec la formule :

```
nouvelle_durée  = (1 / rate) * durée_normale 
```

Changer la vitesse de jeu affecte aussi la hauteur du son. La fréquence 
ou le ton d'une forme d'onde est déterminé par la vitesse à laquelle 
elle monte et descend. Notre cerveau curieusement change le mouvement 
rapide de la membrane du haut-parleur en notes hautes et le mouvement 
lent en notes basses. C'est pourquoi vous pouvez quelquefois voir un 
gros haut-parleur de basse bouger en émettant une super basse - il va 
et vient beaucoup moins vite qu'un haut-parleur produisant des notes 
plus aiguës.

Si vous prenez une forme d'onde et que vous la compressez, elle va 
monter et descendre plus de fois par seconde. Ceci va faire un son  
plus aigu. On en déduit que doubler le montant des mouvements de 
montée et descente (oscillations) double la fréquence. Ainsi, *jouer 
votre échantillon à double vitesse double la fréquence que vous entendez*. 
De même, *diminuer de moitié la vitesse va diminuer de moitié la fréquence*. 
D'autres vitesses affecterons la fréquence dans le même sens.
