/*
  Copyright (C) 2000-2005 SKYRIX Software AG

  This file is part of SOPE.

  SOPE is free software; you can redistribute it and/or modify it under
  the terms of the GNU Lesser General Public License as published by the
  Free Software Foundation; either version 2, or (at your option) any
  later version.

  SOPE is distributed in the hope that it will be useful, but WITHOUT ANY
  WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
  License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with SOPE; see the file COPYING.  If not, write to the
  Free Software Foundation, 59 Temple Place - Suite 330, Boston, MA
  02111-1307, USA.
*/

#include "WOInput.h"
#include "common.h"

@interface WORadioButton : WOInput
{
  // WODynamicElement: extraAttributes
  // WODynamicElement: otherTagString
  // WOInput:    name
  // WOInput:    value
  // WOInput:    disabled
@protected
  WOAssociation *selection;
  WOAssociation *checked;
}

@end /* WORadioButton */

@implementation WORadioButton

- (id)initWithName:(NSString *)_name
  associations:(NSDictionary *)_config
  template:(WOElement *)_t 
{
  if ((self = [super initWithName:_name associations:_config template:_t])) {
    self->selection = OWGetProperty(_config, @"selection");
    self->checked   = OWGetProperty(_config, @"checked");
    
    if ((self->checked != nil) && (self->value != nil)) {
      NSLog(@"WARNING: specified both, 'checked' and 'value', "
            @"associations for radio button!");
    }
  }
  return self;
}

- (void)dealloc {
  [self->selection release];
  [self->checked   release];
  [super dealloc];
}

/* handling requests */

- (void)takeValuesFromRequest:(WORequest *)_req inContext:(WOContext *)_ctx {
  WOComponent *sComponent;
  id formValue;
  
  sComponent = [_ctx component];
  if ([self->disabled boolValueInComponent:sComponent])
    return;
  
  formValue = [_req formValueForKey:OWFormElementName(self, _ctx)];

  if (self->checked) {
    if ([self->checked isValueSettable]) {
      [self->checked setBoolValue:[formValue isEqual:[_ctx elementID]]
                     inComponent:sComponent];
    }
  }
  
  if ([self->selection isValueSettable])
    [self->selection setValue:formValue inComponent:sComponent];
}

/* generating response */

- (void)appendToResponse:(WOResponse *)_response inContext:(WOContext *)_ctx {
  WOComponent *sComponent;
  NSString *lvalue;
  
  sComponent = [_ctx component];
  lvalue = self->checked
    ? [_ctx elementID]
    : [self->value stringValueInComponent:sComponent];
  
  WOResponse_AddCString(_response, "<input type=\"radio\" name=\"");
  [_response appendContentHTMLAttributeValue:OWFormElementName(self, _ctx)];
  WOResponse_AddCString(_response, "\" value=\"");
  [_response appendContentHTMLAttributeValue:lvalue];
  WOResponse_AddCString(_response, "\"");
  
  if (self->checked) {
    if ([self->checked boolValueInComponent:sComponent])
      WOResponse_AddCString(_response, " checked=\"checked\"");
  }
  else {
    id v   = [self->value     valueInComponent:sComponent];
    id sel = [self->selection valueInComponent:sComponent];
    
    if ([v isEqual:sel])
      WOResponse_AddCString(_response, " checked=\"checked\"");
  }
  
  [self appendExtraAttributesToResponse:_response inContext:_ctx];
  if (self->otherTagString) {
    WOResponse_AddChar(_response, ' ');
    WOResponse_AddString(_response,
                         [self->otherTagString stringValueInComponent:
                              sComponent]);
  }
  WOResponse_AddCString(_response, " />");
}

/* description */

- (NSString *)associationDescription {
  NSMutableString *str = nil;
  
  str = [[[super associationDescription] mutableCopy] autorelease];
  if (self->selection) [str appendFormat:@" selection=%@", self->selection];
  if (self->checked)   [str appendFormat:@" checked=%@", self->checked];
  return str;
}

@end /* WORadioButton */
