/*
  Copyright (C) 2000-2005 SKYRIX Software AG

  This file is part of SOPE.

  SOPE is free software; you can redistribute it and/or modify it under
  the terms of the GNU Lesser General Public License as published by the
  Free Software Foundation; either version 2, or (at your option) any
  later version.

  SOPE is distributed in the hope that it will be useful, but WITHOUT ANY
  WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
  License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with SOPE; see the file COPYING.  If not, write to the
  Free Software Foundation, 59 Temple Place - Suite 330, Boston, MA
  02111-1307, USA.
*/

#include "NSObject+Logs.h"
#include "common.h"

@implementation NSObject(NGLogs)

static Class StringClass = Nil;

static inline Class NSStringClass(void) {
  if (StringClass == Nil) StringClass = [NSString class];
  return StringClass;
}

- (BOOL)isDebuggingEnabled {
#if DEBUG
  return YES;
#else
  return NO;
#endif
}
- (NSString *)loggingPrefix {
  /* improve perf ... */
  return [NSStringClass() stringWithFormat:@"<0x%08X[%@]>",
                       self, NSStringFromClass([self class])];
}

- (void)logWithFormat:(NSString *)_format arguments:(va_list)ap {
  NSString *value = nil;
  
  value = [[NSStringClass() alloc] initWithFormat:_format arguments:ap];
  NSLog(@"%@ %@", [self loggingPrefix], value);
  [value release];
}

- (void)debugWithFormat:(NSString *)_format arguments:(va_list)ap {
#if DEBUG
  NSString *value = nil;
  
  if (![self isDebuggingEnabled]) return;
  
  value = [[NSStringClass() alloc] initWithFormat:_format arguments:ap];
  NSLog(@"<%@>D %@", [self loggingPrefix], value);
  [value release];
#else
#  warning debug is disabled, debugWithFormat wont print anything ..
#endif
}

- (void)logWithFormat:(NSString *)_format, ... {
  va_list ap;
  
  va_start(ap, _format);
  [self logWithFormat:_format arguments:ap];
  va_end(ap);
}
- (void)debugWithFormat:(NSString *)_format, ... {
  va_list ap;
  
  va_start(ap, _format);
  [self debugWithFormat:_format arguments:ap];
  va_end(ap);
}

@end /* NSObject(NGLogs) */
