/* 
   EOGenericRecord.h
   
   Copyright (C) SKYRIX Software AG and Helge Hess

   Author: Helge Hess (helge.hess@opengroupware.org)
   Date:   1999-2004

   This file is part of the GNUstep Database Library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef __eoaccess_EOGenericRecord_H__
#define __eoaccess_EOGenericRecord_H__

#import <EOControl/EOGenericRecord.h>

@class NSDictionary;
@class EOEntity;

@interface EOGenericRecord(EOAccess)

// Initializing new instances

- (id)initWithPrimaryKey:(NSDictionary *)aKey entity:(EOEntity *)anEntity;

// Getting the associated entity

- (EOEntity *)entity;

@end

/*
 * Informal protocol. NOT implemented by NSObject.
 * Before sending one of this messages the caller must
 * check if the object responds to them.
 */

@interface NSObject(EOGenericRecord)

/*
 * Initialize an new instance of an object. 
 * If an enterprise object does not respond
 * to this method it will receive -init.
 */
- (id)initWithPrimaryKey:(NSDictionary *)key entity:(EOEntity *)entity;

/*
 * Determines the entity of user defined objects, 
 * when more than one entity uses the same class for its objects.
 */
- (EOEntity *)entity;

/*
 * Determine the class for object based on its fetched row. 
 * The returned class *must* be a subclass of the class that 
 * receives this method.
 */
+ (Class)classForEntity:(EOEntity *)entity values:(NSDictionary *)values;

@end

#endif /* __eoaccess_EOGenericRecord_H__ */

