/*
  Copyright (C) 2000-2005 SKYRIX Software AG

  This file is part of SOPE.

  SOPE is free software; you can redistribute it and/or modify it under
  the terms of the GNU Lesser General Public License as published by the
  Free Software Foundation; either version 2, or (at your option) any
  later version.

  SOPE is distributed in the hope that it will be useful, but WITHOUT ANY
  WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
  License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with SOPE; see the file COPYING.  If not, write to the
  Free Software Foundation, 59 Temple Place - Suite 330, Boston, MA
  02111-1307, USA.
*/

#ifndef __DOMImplementation_H__
#define __DOMImplementation_H__

#import <Foundation/NSObject.h>

@class NSString;

@interface DOMImplementation : NSObject
{
  Class elementClass;
  Class textNodeClass;
  Class attrClass;
}

- (id)createDocumentWithName:(NSString *)_qname
  namespaceURI:(NSString *)_uri
  documentType:(id)_doctype;

- (id)createDocumentType:(NSString *)_qname
  publicId:(NSString *)_pubId
  systemId:(NSString *)_sysId;

@end

@interface DOMImplementation(PrivateClassRegistry)
- (Class)domElementClass;
- (Class)domElementNSClass;
- (Class)domDocumentFragmentClass;
- (Class)domTextNodeClass;
- (Class)domCommentClass;
- (Class)domCDATAClass;
- (Class)domProcessingInstructionClass;
- (Class)domAttributeClass;
- (Class)domAttributeNSClass;
- (Class)domEntityReferenceClass;
@end

#endif /* __DOMImplementation_H__ */
