#! /bin/sh
# **************************************************************************
# This is a hack for generating a Microsoft Developer Studio project and
# workspace files (.dsp/.dsw) for building Coin from the MSVC++ IDE.  It
# hooks into the Automake process as a fake compiler, building the project
# file instead of the sources.
#
# It now also creates an installation script for the header files.
# It also supports automatically moc'ing of source files, if certain
# conventions are followed.
#
# TODO:
#  - Indicate that the dsp file is *not* generated by Microsoft Developer
#    Studio?  Will the MSVC++ IDE eat "foreign" dsp files?
#
# 20050105 larsa

me=$0

enable_static=true

# **************************************************************************
# useful sed commands

sed_d2u='s,\\,/,g' # dos2unix path delimiter switching
sed_u2d='s,/,\\,g' # unix2dos path delimiter switching

# **************************************************************************
# useful autoconf variables - added for optimization/simplification reasons

prefix="/cygdrive/c/Coin3D"
build_dir="/cygdrive/c/Work/source/release/SoQt/cfg/../."
src_dir="/cygdrive/c/Work/source/release/SoQt/cfg/.."
ac_unique_file="src/Inventor/Qt/SoQt.cpp"
sim_ac_relative_src_dir="."
sim_ac_relative_src_dir_p="true"

me_u=`echo $me | sed $sed_d2u`
medir_u=`echo $me_u | sed 's,[^/]*$,,g'`
srcdir_u=`cd $medir_u/..; pwd | sed $sed_d2u`
thisdir_u=`pwd | sed $sed_d2u`

if $sim_ac_relative_src_dir_p; then
  if test -f $srcdir_u/$sim_ac_relative_src_dir/$ac_unique_file; then
    :
    # things are in place
  else
    echo >&2 "$me: error: directories have been moved relative to each other"
    echo >&2 "   since the last configure run."
    exit
  fi
else
  echo >&2 "$me: error: dsp generation is not supported when absolute paths"
  echo >&2 "   are necessary to locate files."
  exit
fi

# **************************************************************************
# preliminary variable exploration

# echo "me:       $me_u"
# echo "medir:    $medir_u"
# echo "srcdir:   $srcdir_u"
# echo "thisdir:  $thisdir_u"

# exit

# run this where needed: me=`echo $me | sed 's%^.*/%%g'`

# **************************************************************************
# The following block (the --registar-public-header part) generates
# 1) the public headers part of the .dsp file
# 2) the install-headers.bat file
# It is invoked from a "make ... install-data"-command far down in this script

if test x"$1" = x"--register-public-header"; then
  studiofile=$2
  headerfile=$3
  installpath=$4
  finalheader=`echo "$installpath" | sed -e "s,.*$prefix/\\(include\\|data\\)/,%COINDIR%/\\1/," -e "s,/\\./,/,g" -e "$sed_u2d"`
  sim_ac_relative_src_dir_q=`echo "." | sed -e 's,\.,\\\\.,g'`

  # echo "========================="
  # echo "source dir:   $src_dir"
  # echo "build dir:    $build_dir"
  # echo "install dir:  $installpath"
  # echo "header:       $headerfile"

  # echo "relative:     $sim_ac_relative_src_dir"

  tested=true
  case $headerfile in
  *$sim_ac_relative_src_dir/* )
    headerfile=`echo $headerfile | sed -e "s%.*$sim_ac_relative_src_dir_q%$sim_ac_relative_src_dir%"`
    ;;
  $build_dir/* )
    tested=false
    echo "EXPLICIT IN BUILD DIR"
    headerfile=`echo $headerfile | sed -e "s%$build_dir/%%"`
    ;;
  $src_dir* )
    tested=false
    echo "EXPLICIT IN SOURCE DIR - CONVERT TO RELATIVE"
    headerfile=`echo $headerfile | sed -e "s%$src_dir%$sim_ac_relative_src_dir%"`
    ;;
  *)
    headerfile=`pwd`/$headerfile
    headerfile=`echo $headerfile | sed -e "s%$build_dir/%%"`
    ;;
  esac

  # echo "final header: $headerfile"
  # echo "FINAL header: $finalheader"
  # echo "========================="

  headerfile=`echo $headerfile | sed -e "$sed_u2d"`

  if $tested; then :; else
    echo "untested case - manual inspection required";
    exit 1;
  fi

  echo "# Begin Source File" >>"$studiofile"
  echo "" >>"$studiofile"
  echo "SOURCE=$headerfile" >>"$studiofile"
  echo "# End Source File" >>"$studiofile"

  # and the installation script
  installheadersfile=`echo $studiofile | sed -e 's,\([^\\/0-9]*\)[0-9][^\\/]*\.dsp,install-headers.bat,'`

  # sourcedirq=`echo "$sourcedir" | sed -e 's,\\\\,\\\\,g'`
  # builddirq=`echo "$builddir" | sed -e 's,\\\\,\\\\,g'`
  # relheader=`echo "$headerfile" | sed -e "s,$builddirq,.,g" -e "s,$sourcedirq,..\\\\..,g" -e 's,\\\\,\\\\\\\\,g'`
  # finalheader=`echo "$relheader" | sed -e 's,.*include,include,g'`
  # relheader=`echo "$relheader"`
  # finalheader=`echo "$finalheader"`

  echo "copy $headerfile $finalheader >nul:" >>"$installheadersfile"
  exit 0
fi

# **************************************************************************
#

# this variable should contain the list of variables we want to use in the
# project file setup, instead of just having the values.

reversevars="QTDIR COINDIR"

sourcefile=
objectfile=
dependfile=
studiofile=
outputfile=

LIBRARY=
library=
Library=

for arg
do
  if test x"$outputfile" = x"next"; then
    outputfile=$arg
  else
    case $arg in
    -c )
      # -c only means _compile_ some file, not that the source file is
      # the next argument, hence we need to do it differently than for
      # the -o option
      sourcefile=get
      ;;
    -o ) outputfile=next ;;
    -MF | -MD | -MP )
      # haven't investigated if one of these are defined to be last
      # before the dep-file, so i've done it this way.
      dependfile=get
      ;;
    -Wp,-MD,* )
      dependfile=`echo $arg | cut -c9-`
      ;;
    -D*_INTERNAL )
      LIBRARY=`echo $arg | cut -d_ -f1 | cut -c3-`
      library=`echo $LIBRARY | tr A-Z a-z`
      case $library in
      coin ) Library=Coin ;;
      soqt ) Library=SoQt ;;
      sowin ) Library=SoWin ;;
      * ) Library=$library ;;
      esac
      ;;
    -Ddspfile=* | -Wl,-Ddspfile=* )
      # the build system is hacked to pass us the path to the .dsp file
      # this way.
      studiofile=`echo $arg | cut -d= -f2-`
      # FIXME: we don't get the -D*_INTERNAL flag when closing, so we
      # have to set up the variables here too.
      library=`echo "$studiofile" | sed -e 's%.*[\\/]%%g' -e 's%[0-9].*$%%'`
      LIBRARY=`echo $library | tr a-z A-Z`
      case $library in
      coin ) Library=Coin ;;
      soqt ) Library=SoQt ;;
      sowin ) Library=SoWin ;;
      * ) Library=$library ;;
      esac
      ;;
    -* )
      ;;
    * )
      if test x"$sourcefile" = x"get"; then
        sourcefile=$arg
      elif test x"$dependfile" = x"get"; then
        dependfile=$arg
      fi
      ;;
    esac
  fi
done

if test x"$studiofile" = x""; then
  exit 0
fi

if test x"$sourcefile" = x""; then :; else
  if test x"$objectfile" = x""; then
    objectfile=`echo $sourcefile | sed -e 's%^.*[/\\\\]%%g' -e 's%\.\(cpp\|c\)$%.o%'`
  fi
fi

if test x"$objectfile" = x""; then :; else
  date >$objectfile
fi

if test x"$dependfile" = x""; then :; else
  echo "" >$dependfile
fi

if test -f "$studiofile"; then :; else
  # file does not exist yet
  echo "# Microsoft Developer Studio Project File - Name=\"${library}@${LIBRARY}_MAJOR_VERSION@\" - Package Owner=<4>" >>"$studiofile"
  echo "# Microsoft Developer Studio Generated Build File, Format Version 6.00" >>"$studiofile"
  echo "# ** DO NOT EDIT **" >>"$studiofile"
  echo "" >>"$studiofile"
  echo "# TARGTYPE \"Win32 (x86) Dynamic-Link Library\" 0x0102" >>"$studiofile"
  echo "" >>"$studiofile"
  echo "CFG=${library}@${LIBRARY}_MAJOR_VERSION@ - Win32 DLL (Debug)" >>"$studiofile"
  echo "!MESSAGE This is not a valid makefile. To build this project using NMAKE," >>"$studiofile"
  echo "!MESSAGE use the Export Makefile command and run" >>"$studiofile"
  echo "!MESSAGE" >>"$studiofile"
  echo "!MESSAGE NMAKE /f \"${library}@${LIBRARY}_MAJOR_VERSION@.mak\"." >>"$studiofile"
  echo "!MESSAGE" >>"$studiofile"
  echo "!MESSAGE You can specify a configuration when running NMAKE" >>"$studiofile"
  echo "!MESSAGE by defining the macro CFG on the command line. For example:" >>"$studiofile"
  echo "!MESSAGE" >>"$studiofile"
  echo "!MESSAGE NMAKE /f \"${library}@${LIBRARY}_MAJOR_VERSION@.mak\" CFG=\"${library}@${LIBRARY}_MAJOR_VERSION@ - Win32 DLL (Debug)\"" >>"$studiofile"
  echo "!MESSAGE" >>"$studiofile"
  echo "!MESSAGE Possible choices for configuration are:" >>"$studiofile"
  echo "!MESSAGE" >>"$studiofile"
  # last configuration mentioned seems to become default / selected by IDE
  if $enable_static; then
    echo "!MESSAGE \"${library}@${LIBRARY}_MAJOR_VERSION@ - Win32 LIB (Release)\" (based on \"Win32 (x86) Static Library\")" >>"$studiofile"
    echo "!MESSAGE \"${library}@${LIBRARY}_MAJOR_VERSION@ - Win32 LIB (Debug)\" (based on \"Win32 (x86) Static Library\")" >>"$studiofile"
  fi
  echo "!MESSAGE \"${library}@${LIBRARY}_MAJOR_VERSION@ - Win32 DLL (Release)\" (based on \"Win32 (x86) Dynamic-Link Library\")" >>"$studiofile"
  echo "!MESSAGE \"${library}@${LIBRARY}_MAJOR_VERSION@ - Win32 DLL (Debug)\" (based on \"Win32 (x86) Dynamic-Link Library\")" >>"$studiofile"
  echo "!MESSAGE" >>"$studiofile"
  echo "" >>"$studiofile"
  echo "# Begin Project" >>"$studiofile"
  echo "# PROP AllowPerConfigDependencies 0" >>"$studiofile"
  echo "# PROP Scc_ProjName \"\"" >>"$studiofile"
  echo "# PROP Scc_LocalPath \"\"" >>"$studiofile"
  echo "CPP=cl.exe" >>"$studiofile"
  echo "MTL=midl.exe" >>"$studiofile"
  echo "RSC=rc.exe" >>"$studiofile"
  echo "" >>"$studiofile"
  echo "!IF  \"\$(CFG)\" == \"${library}@${LIBRARY}_MAJOR_VERSION@ - Win32 DLL (Release)\"" >>"$studiofile"
  echo "" >>"$studiofile"
  echo "# PROP BASE Use_MFC 0" >>"$studiofile"
  echo "# PROP BASE Use_Debug_Libraries 0" >>"$studiofile"
  echo "# PROP BASE Output_Dir \"Release\"" >>"$studiofile"
  echo "# PROP BASE Intermediate_Dir \"Release\"" >>"$studiofile"
  echo "# PROP BASE Target_Dir \"\"" >>"$studiofile"
  echo "# PROP Use_MFC 0" >>"$studiofile"
  echo "# PROP Use_Debug_Libraries 0" >>"$studiofile"
  echo "# PROP Output_Dir \"Release\"" >>"$studiofile"
  echo "# PROP Intermediate_Dir \"Release\"" >>"$studiofile"
  echo "# PROP Ignore_Export_Lib 0" >>"$studiofile"
  echo "# PROP Target_Dir \"\"" >>"$studiofile"
  echo "# ADD BASE CPP /nologo /MD /W3 /GX /O2 /D \"WIN32\" /D \"NDEBUG\" /D \"_WINDOWS\" /D \"${LIBRARY}_DEBUG=0\" @${LIBRARY}_DSP_DEFS@ @${LIBRARY}_DSP_INCS@ /YX /FD /c" >>"$studiofile"
  echo "# ADD CPP /nologo /MD /W3 /GX /O1 /D \"WIN32\" /D \"NDEBUG\" /D \"_WINDOWS\" /D \"${LIBRARY}_DEBUG=0\" @${LIBRARY}_DSP_DEFS@ @${LIBRARY}_DSP_INCS@ /YX /FD /c" >>"$studiofile"
  echo "# ADD BASE MTL /nologo /D \"NDEBUG\" /mktyplib203 /win32" >>"$studiofile"
  echo "# ADD MTL /nologo /D \"NDEBUG\" /mktyplib203 /win32" >>"$studiofile"
  echo "# ADD BASE RSC /l 0x409 /d \"NDEBUG\"" >>"$studiofile"
  echo "# ADD RSC /l 0x409 /d \"NDEBUG\"" >>"$studiofile"
  echo "BSC32=bscmake.exe" >>"$studiofile"
  echo "# ADD BASE BSC32 /nologo" >>"$studiofile"
  echo "# ADD BSC32 /nologo" >>"$studiofile"
  echo "LINK32=link.exe" >>"$studiofile"
  echo "# ADD BASE LINK32 @${LIBRARY}_DSP_LIBS@ /nologo /dll /machine:I386" >>"$studiofile"
  echo "# ADD LINK32 @${LIBRARY}_DSP_LIBS@ /nologo /dll /machine:I386 /out:\"${library}@${LIBRARY}_MAJOR_VERSION@.dll\" /opt:nowin98" >>"$studiofile"
  echo "# SUBTRACT LINK32 /pdb:none" >>"$studiofile"
  echo "# Begin Special Build Tool" >>"$studiofile"
  echo "SOURCE=\"\$(InputPath)\"" >>"$studiofile"
  echo "PostBuild_Cmds=install-dll-release.bat" >>"$studiofile"
  echo "# End Special Build Tool" >>"$studiofile"
  echo "" >>"$studiofile"

  echo "!ELSEIF  \"\$(CFG)\" == \"${library}@${LIBRARY}_MAJOR_VERSION@ - Win32 DLL (Debug)\"" >>"$studiofile"
  echo "" >>"$studiofile"
  echo "# PROP BASE Use_MFC 0" >>"$studiofile"
  echo "# PROP BASE Use_Debug_Libraries 1" >>"$studiofile"
  echo "# PROP BASE Output_Dir \"Debug\"" >>"$studiofile"
  echo "# PROP BASE Intermediate_Dir \"Debug\"" >>"$studiofile"
  echo "# PROP BASE Target_Dir \"\"" >>"$studiofile"
  echo "# PROP Use_MFC 0" >>"$studiofile"
  echo "# PROP Use_Debug_Libraries 1" >>"$studiofile"
  echo "# PROP Output_Dir \"Debug\"" >>"$studiofile"
  echo "# PROP Intermediate_Dir \"Debug\"" >>"$studiofile"
  echo "# PROP Target_Dir \"\"" >>"$studiofile"
  echo "# ADD BASE CPP /nologo /MDd /W3 /Gm /GX /ZI /Od /D \"WIN32\" /D \"_DEBUG\" /D \"_WINDOWS\" /D \"${LIBRARY}_DEBUG=1\" @${LIBRARY}_DSP_DEFS@ @${LIBRARY}_DSP_INCS@ /YX /FD /GZ /c" >>"$studiofile"
  echo "# ADD CPP /nologo /MDd /W3 /Gm /GX /ZI /Od /D \"WIN32\" /D \"_DEBUG\" /D \"_WINDOWS\" /D \"${LIBRARY}_DEBUG=1\" @${LIBRARY}_DSP_DEFS@ @${LIBRARY}_DSP_INCS@ /YX /FD /GZ /c" >>"$studiofile"
  echo "# ADD BASE MTL /nologo /D \"_DEBUG\" /mktyplib203 /win32" >>"$studiofile"
  echo "# ADD MTL /nologo /D \"_DEBUG\" /mktyplib203 /win32" >>"$studiofile"
  echo "# ADD BASE RSC /l 0x409 /d \"_DEBUG\"" >>"$studiofile"
  echo "# ADD RSC /l 0x409 /d \"_DEBUG\"" >>"$studiofile"
  echo "BSC32=bscmake.exe" >>"$studiofile"
  echo "# ADD BASE BSC32 /nologo" >>"$studiofile"
  echo "# ADD BSC32 /nologo" >>"$studiofile"
  echo "LINK32=link.exe" >>"$studiofile"
  echo "# ADD BASE LINK32 @${LIBRARY}_DSP_LIBS@ /nologo /dll /debug /machine:I386 /pdbtype:sept" >>"$studiofile"
  echo "# ADD LINK32 @${LIBRARY}_DSP_LIBS@ /nologo /dll /debug /machine:I386 /pdbtype:sept /out:\"${library}@${LIBRARY}_MAJOR_VERSION@d.dll\"" >>"$studiofile"
  echo "# Begin Special Build Tool" >>"$studiofile"
  echo "SOURCE=\"\$(InputPath)\"" >>"$studiofile"
  echo "PostBuild_Cmds=install-dll-debug.bat" >>"$studiofile"
  echo "# End Special Build Tool" >>"$studiofile"
  echo "" >>"$studiofile"

  if $enable_static; then
    echo "!ELSEIF  \"\$(CFG)\" == \"${library}@${LIBRARY}_MAJOR_VERSION@ - Win32 LIB (Release)\"" >>"$studiofile"
    echo "" >>"$studiofile"
    echo "# PROP BASE Use_MFC 0" >>"$studiofile"
    echo "# PROP BASE Use_Debug_Libraries 0" >>"$studiofile"
    echo "# PROP BASE Output_Dir \"StaticRelease\"" >>"$studiofile"
    echo "# PROP BASE Intermediate_Dir \"StaticRelease\"" >>"$studiofile"
    echo "# PROP BASE Target_Dir \"\"" >>"$studiofile"
    echo "# PROP Use_MFC 0" >>"$studiofile"
    echo "# PROP Use_Debug_Libraries 0" >>"$studiofile"
    echo "# PROP Output_Dir \"StaticRelease\"" >>"$studiofile"
    echo "# PROP Intermediate_Dir \"StaticRelease\"" >>"$studiofile"
    echo "# PROP Target_Dir \"\"" >>"$studiofile"
    echo "# ADD BASE CPP /nologo /MD /W3 /GX /O2 /D \"WIN32\" /D \"NDEBUG\" /D \"_WINDOWS\" /D \"_LIB\" /D \"${LIBRARY}_DEBUG=0\" @${LIBRARY}_LIB_DSP_DEFS@ @${LIBRARY}_DSP_INCS@ /YX /FD /c" >>"$studiofile"
    echo "# ADD CPP /nologo /MD /W3 /GX /O2 /D \"WIN32\" /D \"NDEBUG\" /D \"_WINDOWS\" /D \"_LIB\" /D \"${LIBRARY}_DEBUG=0\" @${LIBRARY}_LIB_DSP_DEFS@ @${LIBRARY}_DSP_INCS@ /YX /FD /c" >>"$studiofile"
    echo "# ADD BASE RSC /l 0x414 /d \"NDEBUG\"" >>"$studiofile"
    echo "# ADD RSC /l 0x414 /d \"NDEBUG\"" >>"$studiofile"
    echo "BSC32=bscmake.exe" >>"$studiofile"
    echo "# ADD BASE BSC32 /nologo" >>"$studiofile"
    echo "# ADD BSC32 /nologo" >>"$studiofile"
    echo "LIB32=link.exe -lib" >>"$studiofile"
    echo "# ADD BASE LIB32 /nologo /machine:I386 /out:\"${library}@${LIBRARY}_MAJOR_VERSION@s.lib\"" >>"$studiofile"
    echo "# ADD LIB32 /nologo /machine:I386 /out:\"${library}@${LIBRARY}_MAJOR_VERSION@s.lib\"" >>"$studiofile"
    echo "# Begin Special Build Tool" >>"$studiofile"
    echo "SOURCE=\"\$(InputPath)\"" >>"$studiofile"
    echo "PostBuild_Cmds=install-lib-release.bat" >>"$studiofile"
    echo "# End Special Build Tool" >>"$studiofile"
    echo "" >>"$studiofile"
  
    echo "!ELSEIF  \"\$(CFG)\" == \"${library}@${LIBRARY}_MAJOR_VERSION@ - Win32 LIB (Debug)\"" >>"$studiofile"
    echo "" >>"$studiofile"
    echo "# PROP BASE Use_MFC 0" >>"$studiofile"
    echo "# PROP BASE Use_Debug_Libraries 1" >>"$studiofile"
    echo "# PROP BASE Output_Dir \"StaticDebug\"" >>"$studiofile"
    echo "# PROP BASE Intermediate_Dir \"StaticDebug\"" >>"$studiofile"
    echo "# PROP BASE Target_Dir \"\"" >>"$studiofile"
    echo "# PROP Use_MFC 0" >>"$studiofile"
    echo "# PROP Use_Debug_Libraries 1" >>"$studiofile"
    echo "# PROP Output_Dir \"StaticDebug\"" >>"$studiofile"
    echo "# PROP Intermediate_Dir \"StaticDebug\"" >>"$studiofile"
    echo "# PROP Target_Dir \"\"" >>"$studiofile"
    echo "# ADD BASE CPP /nologo /MD /W3 /GX /O2 /D \"WIN32\" /D \"_DEBUG\" /D \"_WINDOWS\" /D \"_LIB\" /D \"${LIBRARY}_DEBUG=1\" @${LIBRARY}_LIB_DSP_DEFS@ @${LIBRARY}_DSP_INCS@ /YX /FD /c" >>"$studiofile"
    echo "# ADD CPP /nologo /MD /W3 /GX /O2 /D \"WIN32\" /D \"_DEBUG\" /D \"_WINDOWS\" /D \"_LIB\" /D \"${LIBRARY}_DEBUG=1\" @${LIBRARY}_LIB_DSP_DEFS@ @${LIBRARY}_DSP_INCS@ /YX /FD /c" >>"$studiofile"
    echo "# ADD BASE RSC /l 0x414 /d \"_DEBUG\"" >>"$studiofile"
    echo "# ADD RSC /l 0x414 /d \"_DEBUG\"" >>"$studiofile"
    echo "BSC32=bscmake.exe" >>"$studiofile"
    echo "# ADD BASE BSC32 /nologo" >>"$studiofile"
    echo "# ADD BSC32 /nologo" >>"$studiofile"
    echo "LIB32=link.exe -lib" >>"$studiofile"
    echo "# ADD BASE LIB32 /nologo /machine:I386 /out:\"${library}@${LIBRARY}_MAJOR_VERSION@sd.lib\"" >>"$studiofile"
    echo "# ADD LIB32 /nologo /machine:I386 /out:\"${library}@${LIBRARY}_MAJOR_VERSION@sd.lib\"" >>"$studiofile"
    echo "# Begin Special Build Tool" >>"$studiofile"
    echo "SOURCE=\"\$(InputPath)\"" >>"$studiofile"
    echo "PostBuild_Cmds=install-lib-debug.bat" >>"$studiofile"
    echo "# End Special Build Tool" >>"$studiofile"
    echo ""
  fi

  echo "!ENDIF" >>"$studiofile"


  echo "" >>"$studiofile"
  echo "# Begin Target" >>"$studiofile"
  echo "" >>"$studiofile"
  echo "# Name \"${library}@${LIBRARY}_MAJOR_VERSION@ - Win32 DLL (Release)\"" >>"$studiofile"
  echo "# Name \"${library}@${LIBRARY}_MAJOR_VERSION@ - Win32 DLL (Debug)\"" >>"$studiofile"
  if $enable_static; then
    echo "# Name \"${library}@${LIBRARY}_MAJOR_VERSION@ - Win32 LIB (Release)\"" >>"$studiofile"
    echo "# Name \"${library}@${LIBRARY}_MAJOR_VERSION@ - Win32 LIB (Debug)\"" >>"$studiofile"
  fi
  echo "# Begin Group \"Source Files\"" >>"$studiofile"
  echo "" >>"$studiofile"
  echo "# PROP Default_Filter \"cpp;c;ic;icc\"" >>"$studiofile"
fi

if test `grep -c "# End Project" "$studiofile"` -gt 0; then
  me=`echo $me | sed 's%^.*/%%g'`
  echo >&2 "$me: error: project file is closed - you must start from scratch (make clean)"
  exit 1
fi

if test x"$sourcefile" = x""; then :; else
  # set up section for the source file
  case $sourcefile in
  [a-zA-Z]:* | /* ) ;;
  * )
    # this is a relative path
    sourcefile="`pwd`/$sourcefile"
    ;;
  esac
  echo "# Begin Source File" >>"$studiofile"
  echo "" >>"$studiofile"
  sourcefile=`CYGWIN= cygpath -w "$sourcefile" 2>/dev/null || echo "$sourcefile"`
  echo "SOURCE=$sourcefile" >>"$studiofile"
  sourcefileunixname=`CYGWIN= cygpath -u "$sourcefile"`
  sourcefiledir=`dirname "$sourcefileunixname"`
  sourcefiledirdir=`dirname "$sourcefiledir"`
  targetdir=`echo $sourcefiledir | sed "s%^$sourcefiledirdir%%" | sed s%/%%g`
  echo '!IF  "$(CFG)" == "'${library}@${LIBRARY}_MAJOR_VERSION@' - Win32 DLL (Release)"' >>"$studiofile"
  echo "# PROP Intermediate_Dir \"Release\\$targetdir\"" >>"$studiofile"
  echo '!ELSEIF  "$(CFG)" == "'${library}@${LIBRARY}_MAJOR_VERSION@' - Win32 DLL (Debug)"' >>"$studiofile"
  echo "# PROP Intermediate_Dir \"Debug\\$targetdir\"" >>"$studiofile"
  if $enable_static; then
    echo '!ELSEIF  "$(CFG)" == "'${library}@${LIBRARY}_MAJOR_VERSION@' - Win32 LIB (Release)"' >>"$studiofile"
    echo "# PROP Intermediate_Dir \"StaticRelease\\$targetdir\"" >>"$studiofile"
    echo '!ELSEIF  "$(CFG)" == "'${library}@${LIBRARY}_MAJOR_VERSION@' - Win32 LIB (Debug)"' >>"$studiofile"
    echo "# PROP Intermediate_Dir \"StaticDebug\\$targetdir\"" >>"$studiofile"
  fi
  echo '!ENDIF ' >>"$studiofile"
  echo "# End Source File" >>"$studiofile"

  if egrep "moc_.*.icc" "$sourcefileunixname" >/dev/null 2>&1; then
    # The sourcefile needs MOC to be executed before building.
    # The assumptions here are that the header is in the same directory in the
    # hierarchy, and that the moc file contains the magic text telling the
    # header file name.  It is also assumed that the moc file is not built
    # on its own but included in the source file, and named moc_*.icc.
    mocfile=`egrep "moc_.*.icc" "$sourcefileunixname" | sed -e 's,.*<\(.*icc\)>.*,\1,'`
    mocfile=`echo $mocfile | sed -e 's,.*/,,'`
    headerfile=`egrep "from reading C" $mocfile | sed -e "s,.*'\(.*\)'\$,\1,"`
    mocfile="`pwd`/$mocfile"
    mocfile=`echo $mocfile | sed -e "s%$build_dir/%%"`
    mocfile=`echo $mocfile | sed -e "$sed_u2d"`
    headerfilepath="`pwd`/$headerfile"
    headerfilepath=`echo $headerfilepath | sed -e "s%$build_dir/%%"`
    if test -f "$headerfile"; then
      headerfile="$headerfilepath"
    else
      headerfile="$sim_ac_relative_src_dir/$headerfilepath"
    fi
    headerfile=`echo $headerfile | sed -e "$sed_u2d"`

    echo "# Begin Source File" >>"$studiofile"
    echo "" >>"$studiofile"
    echo "SOURCE=$headerfile" >>"$studiofile"
    echo "" >>"$studiofile"

    echo '!IF  "$(CFG)" == "'${library}@${LIBRARY}_MAJOR_VERSION@' - Win32 DLL (Release)"' >>"$studiofile"
    echo "" >>"$studiofile"
    echo "# PROP IgnoreDefaultTool 1" >>"$studiofile"
    echo "#Begin Custom Build - moc'ing \$(InputPath)" >>"$studiofile"
    echo "InputPath=$headerfile" >>"$studiofile"
    echo "" >>"$studiofile"
    echo "\"$mocfile\" : \$(SOURCE) \"\$(INTDIR)\" \"\$(OUTDIR)\"" >>"$studiofile"
    echo "	\$(QTDIR)\bin\moc -o $mocfile $headerfile" >>"$studiofile"
    echo "" >>"$studiofile"
    echo "# End Custom Build" >>"$studiofile"
    echo "" >>"$studiofile"

    echo '!ELSEIF  "$(CFG)" == "'${library}@${LIBRARY}_MAJOR_VERSION@' - Win32 DLL (Debug)"' >>"$studiofile"
    echo "" >>"$studiofile"
    echo "# PROP IgnoreDefaultTool 1" >>"$studiofile"
    echo "#Begin Custom Build - moc'ing \$(InputPath)" >>"$studiofile"
    echo "InputPath=$headerfile" >>"$studiofile"
    echo "" >>"$studiofile"
    echo "\"$mocfile\" : \$(SOURCE) \"\$(INTDIR)\" \"\$(OUTDIR)\"" >>"$studiofile"
    echo "	\$(QTDIR)\bin\moc -o $mocfile $headerfile" >>"$studiofile"
    echo "" >>"$studiofile"
    echo "# End Custom Build" >>"$studiofile"
    echo "" >>"$studiofile"

    if $enable_static; then
      echo '!ELSEIF  "$(CFG)" == "'${library}@${LIBRARY}_MAJOR_VERSION@' - Win32 LIB (Release)"' >>"$studiofile"
      echo "" >>"$studiofile"
      echo "# PROP IgnoreDefaultTool 1" >>"$studiofile"
      echo "#Begin Custom Build - moc'ing \$(InputPath)" >>"$studiofile"
      echo "InputPath=$headerfile" >>"$studiofile"
      echo "" >>"$studiofile"
      echo "\"$mocfile\" : \$(SOURCE) \"\$(INTDIR)\" \"\$(OUTDIR)\"" >>"$studiofile"
      echo "	\$(QTDIR)\bin\moc -o $mocfile $headerfile" >>"$studiofile"
      echo "" >>"$studiofile"
      echo "# End Custom Build" >>"$studiofile"
      echo "" >>"$studiofile"
  
      echo '!ELSEIF  "$(CFG)" == "'${library}@${LIBRARY}_MAJOR_VERSION@' - Win32 LIB (Debug)"' >>"$studiofile"
      echo "" >>"$studiofile"
      echo "# PROP IgnoreDefaultTool 1" >>"$studiofile"
      echo "#Begin Custom Build - moc'ing \$(InputPath)" >>"$studiofile"
      echo "InputPath=$headerfile" >>"$studiofile"
      echo "" >>"$studiofile"
      echo "\"$mocfile\" : \$(SOURCE) \"\$(INTDIR)\" \"\$(OUTDIR)\"" >>"$studiofile"
      echo "	\$(QTDIR)\bin\moc -o $mocfile $headerfile" >>"$studiofile"
      echo "" >>"$studiofile"
      echo "# End Custom Build" >>"$studiofile"
      echo "" >>"$studiofile"
    fi

    echo "!ENDIF " >>"$studiofile"
    echo "" >>"$studiofile"
    echo "# End Source File" >>"$studiofile"
  fi
fi

case "$outputfile" in
*.so.* )
  # this is how we detect the last command in the build process
  date >>"$outputfile"
  # "close" the dsp file
  echo '# End Group' >>"$studiofile"

  # We need to know about the root build dir and source dir to trigger the
  # header installation rule, and to locate the additional source files we
  # should put in the .dsp file
  builddir=`echo "$studiofile" | sed -e 's%/[^/]*$%%'`
  builddir_unix=$builddir
  builddir=`CYGWIN= cygpath -w "$builddir" 2>/dev/null || echo "$builddir"`

  sourcedir=`echo "$0" | sed -e 's%/cfg/gendsp.sh$%%' -e 's,\\cfg\\gendsp.sh,,'`
  sourcedir_unix=$sourcedir
  sourcedir=`CYGWIN= cygpath -w "$sourcedir" 2>/dev/null || echo "$sourcedir"`

  # PUBLIC HEADERS
  # To get the list of public header files, we run "make install" into a
  # temporary directory, while overriding the header-install program to be
  # this script with a magic option as the first argument.  Afterwards we
  # clean out the temporary install dir.
  echo '# Begin Group "Public Headers"' >>"$studiofile"
  echo "" >>"$studiofile"
  echo '# PROP Default_Filter "h"' >>"$studiofile"
  tmpdir=/tmp/dsp-install.tmp
  ( cd $builddir_unix;
    make INSTALL_HEADER="$0 --register-public-header $studiofile" DESTDIR="$tmpdir" install-data )
  rm -rf $tmpdir
  echo '# End Group' >>"$studiofile"

  # PRIVATE HEADERS
  # I don't know how to properly construct a list of private headers yet,
  # but we can for sure assume that all .ic/.icc source files are includes
  # used from other source files.  We also assume that header files that
  # check for <lib>_INTERNAL and emits a #error with a message containing
  # "private" or "internal" is an internal header file.
  echo '# Begin Group "Private Headers"' >>"$studiofile"
  echo "" >>"$studiofile"
  echo '# PROP Default_Filter "h;ic;icc"' >>"$studiofile"
  for file in `find $sourcedir_unix $builddir_unix -name "*.h" | xargs grep -l "_INTERNAL\$" | xargs grep -i -l "#error.*private"`; do
    echo "# Begin Source File" >>"$studiofile"
    echo "" >>"$studiofile"
    filepath=`CYGWIN= cygpath -w "$file" 2>/dev/null || echo "$file"`
    echo "SOURCE=$filepath" >>"$studiofile"
    echo "# PROP Exclude_From_Build 1" >>"$studiofile"
    echo "# End Source File" >>"$studiofile"
  done
  for file in `find $sourcedir_unix $builddir_unix -name "*.ic" -o -name "*.icc"`; do
    echo "# Begin Source File" >>"$studiofile"
    echo "" >>"$studiofile"
    filepath=`CYGWIN= cygpath -w "$file" 2>/dev/null || echo "$file"`
    echo "SOURCE=$filepath" >>"$studiofile"
    echo "# PROP Exclude_From_Build 1" >>"$studiofile"
    echo "# End Source File" >>"$studiofile"
  done
  echo '# End Group' >>"$studiofile"
  # close the .dsp file
  echo '# End Target' >>"$studiofile"
  echo '# End Project' >>"$studiofile"

  # create the .dsw file
  workspacefile=`echo "$studiofile" | sed 's/\.dsp/.dsw/'`
  echo "Microsoft Developer Studio Workspace File, Format Version 6.00" >>"$workspacefile.in"
  echo "# WARNING: DO NOT EDIT OR DELETE THIS WORKSPACE FILE!" >>"$workspacefile.in"
  echo "" >>"$workspacefile.in"
  echo "###############################################################################" >>"$workspacefile.in"
  echo "" >>"$workspacefile.in"
  echo "Project: \"${library}@${LIBRARY}_MAJOR_VERSION@\"=.\\${library}@${LIBRARY}_MAJOR_VERSION@.dsp - Package Owner=<4>" >>"$workspacefile.in"
  echo "" >>"$workspacefile.in"
  echo "Package=<5>" >>"$workspacefile.in"
  echo "{{{" >>"$workspacefile.in"
  echo "}}}" >>"$workspacefile.in"
  echo "" >>"$workspacefile.in"
  echo "Package=<4>" >>"$workspacefile.in"
  echo "{{{" >>"$workspacefile.in"
  echo "}}}" >>"$workspacefile.in"
  echo "" >>"$workspacefile.in"
  echo "###############################################################################" >>"$workspacefile.in"
  echo "" >>"$workspacefile.in"
  echo "Global:" >>"$workspacefile.in"
  echo "" >>"$workspacefile.in"
  echo "Package=<5>" >>"$workspacefile.in"
  echo "{{{" >>"$workspacefile.in"
  echo "}}}" >>"$workspacefile.in"
  echo "" >>"$workspacefile.in"
  echo "Package=<3>" >>"$workspacefile.in"
  echo "{{{" >>"$workspacefile.in"
  echo "}}}" >>"$workspacefile.in"
  echo "" >>"$workspacefile.in"
  echo "###############################################################################" >>"$workspacefile.in"
  echo "" >>"$workspacefile.in"

  # Make everything peachy for MS DOS

  mv "$studiofile" "$studiofile.in2"
  ( cd "$builddir_unix"; ./config.status --file="-:-" <"$workspacefile.in" >"$workspacefile.txt" )
  ( cd "$builddir_unix"; ./config.status --file="-:-" <"$studiofile.in2" >"$studiofile.in" )

  # If we are making the Win32 precompiled SDK installer, we need to make
  # the .dsp-file contain relative paths that works from where the sources and
  # build files are going to be installed...
  # The first two rules are for individual source files, the next two are for
  # the include directive settings.

  sed -e "s%^SOURCE=.:.*\\(${Library}-[0-9]\\.[^/\\\\]*\\)%SOURCE=..\\\\source\\\\\\1%" \
      -e 's%^SOURCE=.:.*build-files%SOURCE=.%' \
      -e "s%.:[^ ]*\\(${Library}-[0-9]\\.[^/\\\\\"]*\\)%..\\\\source\\\\\\1%" \
      -e 's%.:[^ ]*build-files\([^"]*\)%.\1%g' \
      <"$studiofile.in" >"$studiofile.txt2"

  sourcedirregexp=`echo "$sourcedir" | sed -e 's%\\\\%\\\\\\\\%g'`
  builddirregexp=`echo "$builddir" | sed -e 's%\\\\%\\\\\\\\%g'`

  # Transform paths to be relative paths for non-installer-builds too.
  # This should probably be configurable in some way though.
  if test x"$sourcedir" = x"$builddir"; then
    relsourcedir="."
  else
    num=1
    while true; do
      presource=`echo $sourcedir | cut -d'\' -f1-$num`
      prebuild=`echo $builddir | cut -d'\' -f1-$num`
      if test x"$presource" = x"$prebuild"; then :; else
        break
      fi
      num=`expr $num + 1`
    done
    num=`expr $num - 1`
    if test $num -eq 0; then
      # relative path impossible
      relsourcedir=$sourcedirregexp
    else
      numplus=`expr $num + 1`
      # prefix=`echo $sourcedir | cut -d'\' -f1-$num`
      upfix=`echo "$builddir\\\\" | cut -d'\' -f$numplus- | sed -e 's%[^\\\\]*\\\\%..\\\\%g' -e 's%\\\\%\\\\\\\\%g'`
      postfix=`echo $sourcedir | cut -d'\' -f$numplus- | sed -e 's%\\\\%\\\\\\\\%g'`
      relsourcedir="$upfix$postfix"
    fi
  fi
  sed -e "s%$sourcedirregexp%$relsourcedir%g" \
      -e "s%$builddirregexp\\\\%.\\\\%g" \
      -e "s%$builddirregexp%.\\\\%g" \
    <"$studiofile.txt2" >"$studiofile.txt"

  # here we try to reverse some environment variable values back to their
  # variable references, to make the project less system-dependent.
  for var in $reversevars; do
    eval varval="\$$var"
    varval=`CYGWIN= cygpath -w "$varval" 2>/dev/null || echo "$varval"`
    varval="`echo $varval | sed -e 's%\\\\%\\\\\\\\%g'`"
    if test x"$varval" = x""; then :; else
      mv "$studiofile.txt" "$studiofile.txt2"
      sed -e "s%$varval%\\\$($var)%g" <"$studiofile.txt2" >"$studiofile.txt"
    fi
    if test -f "$studiofile.txt"; then :; else
      echo "error doing substitutions"
      echo "cmd: s%$varval%\\\$($var)%g"
      exit 1
    fi
  done

  # we want to link debug versions of this project with debug versions of the
  # libs they depend on.  we only do this for our own known libraries though.
  debuglibs="coin[0-9] soqt[0-9] sowin[0-9]"
  for lib in $debuglibs; do
    mv "$studiofile.txt" "$studiofile.txt2"
    sed -e '/\/debug/ s%\<\('$lib'\)\.lib\>%\1d.lib%g' <"$studiofile.txt2" >"$studiofile.txt"
    if test -f "$studiofile.txt"; then :; else
      echo "error doing substitutions"
      echo "cmd: s%$varval%\\\$($var)%g"
      exit 1
    fi
  done

  # do unix2dos conversion (\n -> \r\n) on the DevStudio files
  echo -e "s/\$/\r/;\np;" >unix2dos.sed
  sed -n -f unix2dos.sed "$studiofile.txt" >"$studiofile"
  sed -n -f unix2dos.sed "$workspacefile.txt" >"$workspacefile"
  # clean out temporary files
  rm -f "$studiofile.txt2" "$studiofile.txt" "$studiofile.in2" "$studiofile.in" "$workspacefile.txt" "$workspacefile.in" unix2dos.sed
  ;;
esac

